/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.languages;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gvsig.catalog.languages.ILanguages;

public abstract class AbstractGeneralLanguage
implements ILanguages {
    public static final String EXACT_WORDS = "E";
    public static final String ANY_WORDS = "Y";
    public static final String ALL_WORDS = "A";
    public static final String AND = "And";
    public static final String OR = "Or";
    public static final String and = "and";
    public static final String or = "or";
    protected String currentQuery = null;
    protected String currentClause = null;

    public Iterator parseValues(String line, String titleKeys) {
        return this.parseValues(line, titleKeys, "PropertyIsEqualTo", null);
    }

    public Iterator parseValues(String line, String titleKeys, String relationship, String wildCard) {
        Vector<String> values = new Vector<String>();
        if (titleKeys == null) {
            titleKeys = EXACT_WORDS;
        }
        if (titleKeys.equals(EXACT_WORDS)) {
            values.add(line);
            return values.iterator();
        }
        StringTokenizer doubleQuotesTokenizer = new StringTokenizer(line, "\"", true);
        boolean inside = false;
        while (doubleQuotesTokenizer.hasMoreTokens()) {
            String token = doubleQuotesTokenizer.nextToken();
            if (token.equals("\"")) {
                inside = !inside;
                continue;
            }
            if (inside) {
                if (relationship.compareTo("PropertyIsLike") == 0) {
                    token = wildCard + token + wildCard;
                }
                values.add(token);
                continue;
            }
            StringTokenizer spaceTokenizer = new StringTokenizer(token, " ");
            while (spaceTokenizer.hasMoreTokens()) {
                String value = spaceTokenizer.nextToken();
                if (relationship.compareTo("PropertyIsLike") == 0) {
                    value = wildCard + value + wildCard;
                }
                values.add(value);
            }
        }
        return values.iterator();
    }

    public String getOperator(String titleKeys) {
        if (titleKeys == null) {
            titleKeys = EXACT_WORDS;
        }
        if (titleKeys.equals(ANY_WORDS)) {
            return OR;
        }
        return AND;
    }
}

