/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.metadataxml;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLNode {
    public static final String ISNOTXML = "NOTXML";
    private Vector subNodes = new Vector();
    private String cdata = null;
    private Hashtable attr = new Hashtable();
    private String nodeName;
    private String text = null;
    private Vector attrKeys = new Vector();
    private String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public XMLNode(File file) throws Exception {
        this(factory.newDocumentBuilder().parse(file));
    }

    public XMLNode(InputStream inputstream) throws Exception {
        this(factory.newDocumentBuilder().parse(inputstream));
    }

    public XMLNode(InputSource inputsource) throws Exception {
        this(factory.newDocumentBuilder().parse(inputsource));
    }

    public XMLNode(Document dom) throws Exception {
        this((Element)dom.getFirstChild());
    }

    public XMLNode(String name) throws Exception {
        this.nodeName = name;
    }

    public XMLNode(String name, String text) throws Exception {
        this.nodeName = name;
        this.text = text;
    }

    public XMLNode(Element dom) throws Exception {
        this.nodeName = dom.getNodeName();
        NamedNodeMap map = dom.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node att = map.item(i);
            this.addAtrribute(att.getNodeName(), att.getNodeValue());
        }
        NodeList nodeList = dom.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String s;
            Node sub = nodeList.item(i);
            if (sub.getNodeType() == 1) {
                this.addSubNode(new XMLNode((Element)sub));
                continue;
            }
            if (sub.getNodeType() == 4) {
                String sCdata = sub.getNodeValue().trim();
                if (sCdata.length() <= 0) continue;
                this.cdata = sCdata;
                continue;
            }
            if (sub.getNodeType() != 3 || (s = sub.getNodeValue().trim()).length() <= 0) continue;
            if (this.text != null) {
                throw new Exception("XMLNode '" + this.nodeName + "' has 2 Textblocks");
            }
            this.text = s;
        }
    }

    public void setText(String s) {
        this.text = s;
    }

    public void addSubNode(XMLNode s) {
        this.subNodes.add(s);
    }

    public void addAtrribute(String name, String value) throws Exception {
        if (this.attr.containsKey(name)) {
            throw new Exception("XMLNode '" + this.nodeName + "' already contains Attribute '" + name + "'");
        }
        this.attr.put(name, value);
        this.attrKeys.add(name);
    }

    public int getNumSubNodes() {
        return this.subNodes.size();
    }

    public String getName() {
        return this.nodeName;
    }

    public String getText() {
        return this.text;
    }

    public String getCdata() {
        return this.cdata;
    }

    public XMLNode getSubNode(int index) {
        return (XMLNode)this.subNodes.get(index);
    }

    public XMLNode[] getSubnodes() {
        XMLNode[] xmlNodes = new XMLNode[this.getNumSubNodes()];
        for (int i = 0; i < this.getNumSubNodes(); ++i) {
            xmlNodes[i] = this.getSubNode(i);
        }
        return xmlNodes;
    }

    public Vector getAttributeNames() {
        return this.attrKeys;
    }

    public void write(Writer wr) throws Exception {
        this.wwrite("", wr);
    }

    private void wwrite(String pre, Writer wr) throws Exception {
        int i;
        wr.write(pre + "<" + this.nodeName);
        for (i = 0; i < this.attrKeys.size(); ++i) {
            String name = (String)this.attrKeys.get(i);
            String val = (String)this.attr.get(name);
            wr.write(" " + name + "='" + val + "'");
        }
        if (this.getNumSubNodes() == 0 && this.text == null) {
            wr.write("/>\n");
        } else {
            wr.write(">");
            if (this.text != null) {
                wr.write(this.text);
            }
            if (this.getNumSubNodes() > 0) {
                wr.write("\n");
                for (i = 0; i < this.subNodes.size(); ++i) {
                    if (this.getSubNode(i) == null) continue;
                    this.getSubNode(i).wwrite(pre + "  ", wr);
                }
                wr.write(pre + "</" + this.nodeName + ">\n");
            } else {
                wr.write("</" + this.nodeName + ">\n");
            }
        }
    }

    public String getAttribute(String key) {
        return (String)this.attr.get(key);
    }

    public double getDoubleAttribute(String key) {
        return Double.parseDouble((String)this.attr.get(key));
    }

    public boolean getBoolAttribute(String key) {
        if (!this.hasAttribute(key)) {
            return false;
        }
        return new Boolean((String)this.attr.get(key));
    }

    public int getIntAttribute(String key) {
        return Integer.parseInt((String)this.attr.get(key));
    }

    public boolean hasAttribute(String key) {
        return this.attr.containsKey(key);
    }

    public void write(File f) throws Exception {
        FileWriter fw = new FileWriter(f);
        fw.write(this.header);
        this.write(fw);
        fw.flush();
        fw.close();
    }

    public String toString() {
        return this.getName();
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void printSubNodes() {
        for (int i = 0; i < this.getNumSubNodes(); ++i) {
            System.out.println(this.getSubNode(i).getName() + " = " + this.getSubNode(i).getText());
        }
    }

    public void printNode() {
        this.printNode(this);
    }

    public XMLNode searchNode(String etiqueta) {
        return XMLTree.searchNode(this, etiqueta);
    }

    public String searchAtribute(String attributeName) {
        return XMLTree.searchAtribute(this, attributeName);
    }

    public String searchNodeValue(String etiqueta) {
        return XMLTree.searchNodeValue(this, etiqueta);
    }

    public String searchNodeAtribute(XMLNode node, String etiqueta, String atributo) {
        return XMLTree.searchNodeAtribute(this, etiqueta, atributo);
    }

    public String[] searchMultipleNodeValue(String label) {
        return XMLTree.searchMultipleNodeValue(this, label);
    }

    public XMLNode[] searchMultipleNode(String label) {
        return XMLTree.searchMultipleNode(this, label);
    }

    public String getXmlTree() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + this.getName());
        for (i = 0; i < this.getAttributeNames().size(); ++i) {
            String name = (String)this.getAttributeNames().get(i);
            String val = this.getAttribute(name);
            buffer.append(" " + name + "='" + val + "'");
        }
        if (this.getNumSubNodes() == 0 && this.getText() == null) {
            buffer.append("/>\n");
        } else {
            buffer.append(">");
            if (this.getText() != null) {
                buffer.append(this.getText());
            }
            if (this.getNumSubNodes() > 0) {
                buffer.append("\n");
                for (i = 0; i < this.getSubnodes().length; ++i) {
                    if (this.getSubnodes()[i] == null) continue;
                    buffer.append(this.getSubnodes()[i].getXmlTree());
                }
                buffer.append("</" + this.getName() + ">\n");
            } else {
                buffer.append("</" + this.getName() + ">\n");
            }
        }
        return buffer.toString();
    }

    private void printNode(XMLNode node) {
        System.out.print(this.getXmlTree());
    }

    static {
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(true);
    }
}

