/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import java.net.URI;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.querys.Coordinates;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;

public class DublinCoreRecord
extends Record {
    public DublinCoreRecord() {
    }

    public DublinCoreRecord(URI uri, XMLNode node) {
        super(uri, node);
        this.setTitle(XMLTree.searchNodeValue(node, "dc:title"));
        this.setAbstract_(XMLTree.searchNodeValue(node, "dc:subject"));
        this.setPurpose(XMLTree.searchNodeValue(node, "dc:description"));
        this.setResources(this.getResources(node));
    }

    public Resource[] getResources(XMLNode node) {
        String format = XMLTree.searchNodeValue(node, "dc:format");
        String source = XMLTree.searchNodeValue(node, "dc:source");
        Coordinates coordinates = new Coordinates(XMLTree.searchNodeValue(this.getNode(), "dc:spatial->dcmiBox:Box->dcmiBox:westlimit"), XMLTree.searchNodeValue(this.getNode(), "dc:spatial->dcmiBox:Box->dcmiBox:northlimit"), XMLTree.searchNodeValue(this.getNode(), "dc:spatial->dcmiBox:Box->dcmiBox:eastlimit"), XMLTree.searchNodeValue(this.getNode(), "dc:spatial->dcmiBox:Box->dcmiBox:southlimit"));
        if (source == null || format == null) {
            return null;
        }
        if (format.toLowerCase().equals("shapefile")) {
            format = "WWW:DOWNLOAD";
        }
        if (format.toLowerCase().trim().equals("web page")) {
            format = "WWW:LINK";
        }
        Resource[] resources = new Resource[]{new Resource(source, format, "", "", "", "", coordinates)};
        return resources;
    }

    @Override
    public boolean accept(URI uri, XMLNode node) {
        return node.getName().equals("dc:metadata") || node.getName().equals("simpledc") || node.getName().equals("csw:SummaryRecord") || node.getName().equals("csw:Record");
    }
}

