/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import java.net.URI;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.querys.Coordinates;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;

public class GeonetworkISO19115Record
extends Record {
    public GeonetworkISO19115Record() {
    }

    public GeonetworkISO19115Record(URI uri, XMLNode node) {
        super(uri, node);
        String imageURL;
        this.setTitle(XMLTree.searchNodeValue(node, "dataIdInfo->idCitation->resTitle"));
        this.setAbstract_(XMLTree.searchNodeValue(node, "dataIdInfo->idAbs"));
        this.setPurpose(XMLTree.searchNodeValue(node, "dataIdInfo->idPurp"));
        this.setKeyWords(XMLTree.searchMultipleNodeValue(node, "dataIdInfo->descKeys->keyword"));
        this.setResources(this.getResources("distInfo->distTranOps->onLineSrc"));
        this.setFileID(XMLTree.searchNodeValue(node, "mdFileID"));
        XMLNode[] nodes = XMLTree.searchMultipleNode(node, "dataIdInfo->graphOver");
        if (nodes != null && nodes.length > 0 && (imageURL = XMLTree.searchNodeValue(nodes[0], "bgFileName")) != null) {
            this.setImageURL(imageURL);
        }
    }

    private Resource[] getResources(String label) {
        XMLNode[] nodes = XMLTree.searchMultipleNode(this.getNode(), label);
        Coordinates coordinates = null;
        String srs = null;
        if (nodes == null) {
            return null;
        }
        Resource[] resources = new Resource[nodes.length];
        if (nodes.length > 0) {
            srs = XMLTree.searchNodeValue(this.getNode(), "refSysInfo->MdCoRefSys->refSysID->identCode");
            coordinates = new Coordinates(XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->westBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->northBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->eastBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->southBL"));
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i] = new Resource(XMLTree.searchNodeValue(nodes[i], "linkage"), XMLTree.searchNodeValue(nodes[i], "protocol"), XMLTree.searchNodeValue(nodes[i], "orName"), XMLTree.searchNodeValue(nodes[i], "orDesc"), XMLTree.searchNodeAtribute(nodes[i], "orFunct->OnFunctCd", "value"), srs, coordinates);
            if (resources[i].getLinkage() != null) continue;
            resources[i].setLinkage("");
        }
        return resources;
    }

    @Override
    public boolean accept(URI uri, XMLNode node) {
        return node.getName().equals("Metadata") && XMLTree.searchNode(node, "mdFileID") != null;
    }
}

