/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import org.gvsig.catalog.querys.Coordinates;

public class Resource {
    public static final String WMS = "OGC:WMS";
    public static final String WMS_SERVICE = "OGC:WMS_SERVICE";
    public static final String WFS = "OGC:WFS";
    public static final String WCS = "OGC:WCS";
    public static final String POSTGIS = "POSTGIS";
    public static final String ARCIMS_IMAGE = "ESRI:AIMS--HTTP-GET-IMAGE";
    public static final String ARCIMS_VECTORIAL = "ESRI:AIMS--HTTP-GET-FEATURE";
    public static final String WEBSITE = "WWW:LINK";
    public static final String DOWNLOAD = "WWW:DOWNLOAD";
    public static final String UNKNOWN = "UNKNOWN";
    private String linkage = null;
    private String protocol = null;
    private String name = null;
    private String description = null;
    private String function = null;
    private String srs = null;
    private Coordinates coordinates = null;
    private String Type = null;

    public Resource(String linkage, String protocol, String name, String description, String function, String srs, Coordinates coordinates) {
        this.linkage = linkage;
        this.protocol = protocol;
        this.name = name;
        this.description = description;
        this.function = function;
        this.srs = srs;
        this.coordinates = coordinates;
        this.setResourceType();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getLinkage() {
        return this.linkage;
    }

    public void setLinkage(String linkage) {
        this.linkage = linkage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    public String getType() {
        return this.Type;
    }

    public void setType(String type) {
        this.Type = type;
    }

    public void setResourceType() {
        try {
            if (this.getProtocol().toUpperCase().indexOf(WCS) >= 0) {
                this.setType(WCS);
            } else if (this.getProtocol().toUpperCase().indexOf(WMS) >= 0) {
                this.setType(WMS);
            } else if (this.getProtocol().toUpperCase().indexOf(WFS) >= 0) {
                this.setType(WFS);
            } else if (this.getProtocol().toUpperCase().indexOf(POSTGIS) >= 0) {
                this.setType(POSTGIS);
            } else if (this.getProtocol().toUpperCase().indexOf(WEBSITE) >= 0) {
                this.setType(WEBSITE);
            } else if (this.getProtocol().toUpperCase().indexOf(DOWNLOAD) >= 0) {
                this.setType(DOWNLOAD);
            } else if (this.getProtocol().toUpperCase().indexOf(ARCIMS_IMAGE) >= 0) {
                this.setType(ARCIMS_IMAGE);
            } else if (this.getProtocol().toUpperCase().indexOf(ARCIMS_VECTORIAL) >= 0) {
                this.setType(ARCIMS_VECTORIAL);
            } else {
                this.setType(UNKNOWN);
            }
        }
        catch (NullPointerException e) {
            this.setType(UNKNOWN);
        }
    }
}

