/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.srw.drivers;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.gvsig.catalog.drivers.AbstractCatalogServiceDriver;
import org.gvsig.catalog.drivers.CatalogCapabilities;
import org.gvsig.catalog.drivers.DiscoveryServiceCapabilities;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.protocols.HTTPGetProtocol;
import org.gvsig.catalog.protocols.SOAPProtocol;
import org.gvsig.catalog.querys.CatalogQuery;
import org.gvsig.catalog.srw.drivers.SRWMessages;
import org.gvsig.catalog.srw.parsers.SrwCapabilitiesParser;

public class SRWCatalogServiceDriver
extends AbstractCatalogServiceDriver {
    private String version = "1.1";
    private String recordXPath;
    private String resultSetTTL;

    @Override
    public DiscoveryServiceCapabilities getCapabilities(URI uri) {
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            this.setServerAnswerReady("errorServerNotFound");
            return null;
        }
        SRWMessages messages = new SRWMessages(this);
        Collection nodes = new HTTPGetProtocol().doQuery(url, messages.getHTTPGETCapabilities(true), 0);
        nodes = new SOAPProtocol().doQuery(url, messages.getSOAPCapabilities(), 0);
        new SrwCapabilitiesParser(this).parse((XMLNode)nodes.toArray()[0]);
        CatalogCapabilities capabilities = new CatalogCapabilities();
        capabilities.setVersion(this.version);
        capabilities.setServerMessage(this.getServerAnswerReady());
        return capabilities;
    }

    @Override
    public GetRecordsReply getRecords(URI uri, CatalogQuery query, int firstRecord) {
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            this.setServerAnswerReady("errorServerNotFound");
            return null;
        }
        this.setQuery(query);
        SRWMessages messages = new SRWMessages(this);
        Collection nodes = new ArrayList();
        if (url.getHost().equals("idee.unizar.es")) {
            try {
                url = new URL("http://idee.unizar.es/SRW/servlet/search/SRW");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        XMLNode root = null;
        nodes = new SOAPProtocol().doQuery(url, messages.getSOAPRecords(this.getQuery(), firstRecord), firstRecord);
        root = (XMLNode)nodes.toArray()[0];
        String prefix = new StringTokenizer((root = root.getSubNode(0).getSubNode(0)).getName(), ":").nextToken();
        prefix = prefix.equals(root.getName()) ? "" : prefix + ":";
        int numberOfRecords = this.getNumberOfRecords(root, prefix + "numberOfRecords", null);
        if (numberOfRecords == -1) {
            return null;
        }
        GetRecordsReply recordsReply = new GetRecordsReply(numberOfRecords);
        this.parseRecords(root, recordsReply, uri, prefix, numberOfRecords, firstRecord);
        return recordsReply;
    }

    private void parseRecords(XMLNode node, GetRecordsReply recordsReply, URI uri, String prefix, int numberOfRecords, int firstRecord) {
        XMLNode[] auxNodes = XMLTree.searchMultipleNode(node, prefix + "records->" + prefix + "record");
        for (int i = 1; i <= numberOfRecords && i <= 10 && i <= numberOfRecords - firstRecord + 1; ++i) {
            recordsReply.addRecord(uri, auxNodes[i - 1]);
        }
    }

    public String getRecordXPath() {
        return this.recordXPath;
    }

    public void setRecordXPath(String recordXPath) {
        this.recordXPath = recordXPath;
    }

    public String getResultSetTTL() {
        return this.resultSetTTL;
    }

    public void setResultSetTTL(String resultSetTTL) {
        this.resultSetTTL = resultSetTTL;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean isProtocolSupported(URI uri) {
        return SOAPProtocol.isProtocolSupported(null);
    }

    @Override
    public String getServiceName() {
        return "SRW";
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    public String getDefaultSchema() {
        return "http";
    }
}

