/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.srw.parsers;

import java.util.StringTokenizer;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.srw.drivers.SRWCatalogServiceDriver;

public class SrwCapabilitiesParser {
    private SRWCatalogServiceDriver driver;

    public SrwCapabilitiesParser(SRWCatalogServiceDriver driver) {
        this.driver = driver;
    }

    public boolean parse(XMLNode node) {
        if (node == null || node.getName() == null) {
            this.driver.setServerAnswerReady("errorNotSupportedProtocol");
            return false;
        }
        if (node.getName().toLowerCase().equals("serviceexceptionreport")) {
            this.driver.setServerAnswerReady("errorServerException");
            return false;
        }
        String prefix = new StringTokenizer(node.getName(), ":").nextToken();
        prefix = prefix + ":";
        this.driver.setOutputSchema(XMLTree.searchNodeValue(node, prefix + "record->" + prefix + "recordSchema"));
        this.driver.setOutputFormat(XMLTree.searchNodeValue(node, prefix + "record->" + prefix + "recordPacking"));
        this.driver.setStartPosition("1");
        this.driver.setMaxRecords("10");
        this.driver.setRecordXPath("");
        this.driver.setResultSetTTL("0");
        String title = XMLTree.searchNodeValue(node, prefix + "record->" + prefix + "recordData->explain->databaseInfo->title");
        String description = XMLTree.searchNodeValue(node, prefix + "record->" + prefix + "recordData->explain->databaseInfo->description");
        if (title != null) {
            this.driver.setServerAnswerReady(title + "\n");
            if (description != null) {
                this.driver.setServerAnswerReady(this.driver.getServerAnswerReady() + description + "\n");
            }
        } else {
            this.driver.setServerAnswerReady("");
            if (description != null) {
                this.driver.setServerAnswerReady(description + "\n");
            }
        }
        return true;
    }
}

