/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.z3950.filters;

import org.gvsig.catalog.filters.AbstractFilter;
import org.gvsig.catalog.languages.BasicEncodingRules;
import org.gvsig.catalog.querys.CatalogQuery;
import org.gvsig.i18n.Messages;

public class Z3950Filter
extends AbstractFilter {
    private String database = null;

    public Z3950Filter(String database) {
        this.database = database;
    }

    @Override
    public String getQuery(CatalogQuery query) {
        BasicEncodingRules filter = new BasicEncodingRules();
        if (query.getTitle() != null) {
            filter.addClauses("4", "6", "3", query.getTitle(), query.getTitleFilter(), "and");
        }
        if (query.isMinimized()) {
            if (query.getAbstract() != null) {
                filter.addClauses("62", "6", "3", query.getAbstract(), "E", "or");
            }
        } else {
            if (query.getAbstract() != null) {
                filter.addClauses("62", "6", "3", query.getAbstract(), "E", "and");
            }
            if (query.getThemeKey() != null) {
                filter.addClauses("2002", "6", "3", query.getThemeKey(), "Y", "and");
            }
            if (query.getScale() != null) {
                if (query.getMinScale() != null) {
                    filter.addClauses("1024", "109", "4", query.getMinScale(), "E", "and");
                }
                if (query.getMaxScale() != null) {
                    filter.addClauses("1024", "109", "2", query.getMaxScale(), "E", "and");
                }
            }
            if (query.getProvider() != null) {
                filter.addClauses("1005", "6", "3", query.getProvider(), "E", "and");
            }
            if (query.getDateFrom() != null) {
                filter.addClauses("1012", "210", "18", query.getDateFrom(), "E", "and");
            }
            if (query.getDateTo() != null) {
                filter.addClauses("1012", "210", "14", query.getDateTo(), "E", "and");
            }
        }
        if (query.getCoordenates() != null && query.isCoordinatesClicked()) {
            String sNorth = query.getCoordenates().getUly();
            String sWest = query.getCoordenates().getUlx();
            String sSouth = query.getCoordenates().getBry();
            String sEast = query.getCoordenates().getBrx();
            String sBounding = sNorth + " " + sWest + " " + sSouth + " " + sEast;
            String sRelation = this.getRelation(query.getCoordenatesFilter());
            filter.addClauses("2060", "201", sRelation, sBounding, "E", "and");
        }
        return filter.toString(this.database);
    }

    private String getRelation(String relacion) {
        if (relacion.equals(Messages.getText((String)"coordinatesEqual"))) {
            return "3";
        }
        if (relacion.equals(Messages.getText((String)"coordinatesContains"))) {
            return "7";
        }
        if (relacion.equals(Messages.getText((String)"coordinatesEnclose"))) {
            return "9";
        }
        return "10";
    }
}

