/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.ui.cts;

import org.cresques.cts.IProjection;
import org.cresques.impl.cts.ProjectionPool;

public class CSSelectionModel {
    public static int NONE = 1;
    public static int GEODETIC = 2;
    public static int TRANSVERSAL = 3;
    public String[] datumList = new String[]{"WGS 84", "European 1950", "Datum 73", "North American Datum 1927", "North American Datum 1983", "La Canoa", "NTF (Paris)", "ETRS 89", "Moon (IAU 2000)", "Mars (IAU 2000)", "Campo_Inchauspe", "RGF93"};
    private String[][] projList = new String[][]{{"Geodesica", "(UTM) Universal Transversal Mercator", "LCC Canada", "Mercator"}, {"Geodesica", "(UTM) Universal Transversal Mercator"}, {"Geodesica", "Modified Portuguese Grid"}, {"Geodesica", "(UTM) Universal Transversal Mercator"}, {"Geodesica", "(UTM) Universal Transversal Mercator", "NRCan LCC Canada"}, {"Geodesica", "(UTM) Universal Transversal Mercator"}, {"Geodesica", "Lambert Etendu"}, {"Geodesica", "(UTM) Universal Transversal Mercator"}, {"Geodesica"}, {"Geodesica"}, {"Geodesica", "Zonas 1-7"}, {"Geodesica", "Lambert-93"}};
    private int[][] projType = new int[][]{{GEODETIC, TRANSVERSAL, NONE, NONE}, {GEODETIC, TRANSVERSAL}, {GEODETIC, NONE}, {GEODETIC, TRANSVERSAL}, {GEODETIC, TRANSVERSAL, NONE}, {GEODETIC, TRANSVERSAL}, {GEODETIC, NONE}, {GEODETIC, TRANSVERSAL}, {GEODETIC}, {GEODETIC}, {GEODETIC, TRANSVERSAL}, {GEODETIC, NONE}};
    private int[][] zoneRange = new int[][]{{1, 60}, {1, 60}, {0, 0}, {3, 23}, {3, 23}, {18, 21}, {0, 0}, {28, 38}, {0, 0}, {0, 0}, {1, 7}, {0, 0}};
    private String[] zoneList = new String[60];
    private int selectedDatum = 0;
    private int selectedProj = 0;
    private int selectedZone = 0;

    public CSSelectionModel() {
        for (int i = 1; i <= 60; ++i) {
            this.zoneList[i - 1] = "Huso " + Integer.toString(i);
        }
    }

    public String[] getDatumList() {
        return this.datumList;
    }

    public String[] getProjectionList() {
        return this.projList[this.getSelectedDatum()];
    }

    public String[] getZoneList() {
        int[] r = this.zoneRange[this.getSelectedDatum()];
        return this.getZoneList(r[0], r[1]);
    }

    public String[] getZoneList(int from, int to) {
        this.zoneList = new String[to - from + 1];
        for (int i = from; i <= to; ++i) {
            this.zoneList[i - from] = "Huso " + Integer.toString(i);
        }
        return this.zoneList;
    }

    public void setSelectedDatum(int opNr) {
        this.selectedDatum = opNr;
    }

    public void setSelectedDatum(Object item) {
        String[] list = this.datumList;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].compareTo((String)item) != 0) continue;
            this.selectedDatum = i;
            break;
        }
    }

    public int getSelectedDatum() {
        return this.selectedDatum;
    }

    public void setSelectedProj(int opNr) {
        this.selectedProj = opNr;
    }

    public void setSelectedProj(Object item) {
        String[] list = this.projList[this.getSelectedDatum()];
        for (int i = 0; i < list.length; ++i) {
            if (list[i].compareTo((String)item) != 0) continue;
            this.selectedProj = i;
            break;
        }
    }

    public int getSelectedProj() {
        return this.selectedProj;
    }

    public int getSelectedProjType() {
        return this.projType[this.getSelectedDatum()][this.selectedProj];
    }

    public void setSelectedZone(int opNr) {
        this.selectedZone = opNr;
    }

    public void setSelectedZone(Object item) {
        String[] list = this.zoneList;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].compareTo((String)item) != 0) continue;
            this.selectedZone = i;
            break;
        }
    }

    public int getSelectedZone() {
        return this.selectedZone;
    }

    public void setProjection(IProjection proj) {
        if (proj != null) {
            String key = proj.getAbrev();
            key = key.split(":")[1];
            this.setSelectedProj(0);
            this.setSelectedZone(-1);
            if (key.endsWith("4326")) {
                this.setSelectedDatum(0);
            } else if (key.endsWith("4230")) {
                this.setSelectedDatum(1);
            } else if (key.endsWith("4274")) {
                this.setSelectedDatum(2);
            } else if (key.endsWith("4267")) {
                this.setSelectedDatum(3);
            } else if (key.endsWith("4269")) {
                this.setSelectedDatum(4);
            } else if (key.endsWith("4247")) {
                this.setSelectedDatum(5);
            } else if (key.endsWith("4807")) {
                this.setSelectedDatum(6);
            } else if (key.endsWith("4258")) {
                this.setSelectedDatum(7);
            } else if (key.endsWith("30100")) {
                this.setSelectedDatum(8);
            } else if (key.endsWith("49900")) {
                this.setSelectedDatum(9);
            } else if (key.endsWith("4221")) {
                this.setSelectedDatum(10);
            } else if (key.endsWith("4171")) {
                this.setSelectedDatum(11);
            } else if (key.startsWith("326")) {
                this.setSelectedDatum(0);
                this.setSelectedProj(1);
                this.setSelectedZone("Huso " + Integer.parseInt(key.substring(3)));
            } else if (key.startsWith("230")) {
                this.setSelectedDatum(1);
                this.setSelectedProj(1);
                this.setSelectedZone("Huso " + Integer.parseInt(key.substring(3)));
            } else if (key.startsWith("267")) {
                this.setSelectedDatum(3);
                this.setSelectedProj(1);
                this.setSelectedZone("Huso " + Integer.parseInt(key.substring(3)));
            } else if (key.startsWith("269")) {
                this.setSelectedDatum(4);
                this.setSelectedProj(1);
                this.setSelectedZone("Huso " + Integer.parseInt(key.substring(3)));
            } else if (key.startsWith("247")) {
                this.setSelectedDatum(5);
                this.setSelectedProj(1);
                this.setSelectedZone("Huso " + Integer.parseInt(key.substring(3)));
            } else if (key.startsWith("258")) {
                this.setSelectedDatum(7);
                this.setSelectedProj(1);
                this.setSelectedZone("Huso " + Integer.parseInt(key.substring(3)));
            } else if (key.startsWith("221")) {
                this.setSelectedDatum(10);
                this.setSelectedProj(1);
                this.setSelectedZone("Huso " + Integer.parseInt(key.substring(4)));
            } else if (key.endsWith("27492")) {
                this.setSelectedDatum(2);
                this.setSelectedProj(1);
                this.setSelectedZone(-1);
            } else if (key.endsWith("42101")) {
                this.setSelectedDatum(0);
                this.setSelectedProj(2);
                this.setSelectedZone(-1);
            } else if (key.endsWith("9804")) {
                this.setSelectedDatum(0);
                this.setSelectedProj(3);
                this.setSelectedZone(-1);
            } else if (key.endsWith("30100")) {
                this.setSelectedDatum(8);
                this.setSelectedProj(0);
                this.setSelectedZone(-1);
            } else if (key.endsWith("49900")) {
                this.setSelectedDatum(9);
                this.setSelectedProj(0);
                this.setSelectedZone(-1);
            } else if (key.endsWith("42304")) {
                this.setSelectedDatum(4);
                this.setSelectedProj(2);
                this.setSelectedZone(-1);
            } else if (key.endsWith("27582")) {
                this.setSelectedDatum(6);
                this.setSelectedProj(1);
                this.setSelectedZone(-1);
            } else if (key.equals("2154")) {
                this.setSelectedDatum(11);
                this.setSelectedProj(1);
                this.setSelectedZone(-1);
            } else {
                System.err.println("CAGADA EN EL PARSING DE LA PROYECCION: " + key);
            }
        } else {
            this.selectedDatum = 0;
            this.selectedProj = 0;
            this.selectedZone = 0;
        }
    }

    public IProjection getProjection() {
        IProjection proj = null;
        String datum = "326";
        if (this.selectedDatum == 0) {
            datum = "326";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                String zone = Integer.toString(this.selectedZone + 1);
                if (this.selectedZone < 9) {
                    zone = "0" + zone;
                }
                return new ProjectionPool().get("EPSG:" + datum + zone);
            }
            if (this.selectedProj == 2) {
                return new ProjectionPool().get("EPSG:42101");
            }
            if (this.selectedProj == 3) {
                return new ProjectionPool().get("EPSG:9804");
            }
        } else if (this.selectedDatum == 1) {
            datum = "230";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                String zone = Integer.toString(this.selectedZone + 1);
                if (this.selectedZone < 9) {
                    zone = "0" + zone;
                }
                return new ProjectionPool().get("EPSG:" + datum + zone);
            }
        } else if (this.selectedDatum == 2) {
            datum = "274";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                return new ProjectionPool().get("EPSG:" + datum + "92");
            }
        } else if (this.selectedDatum == 3) {
            datum = "267";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                String zone = Integer.toString(this.selectedZone + 3);
                if (this.selectedZone + 3 <= 9) {
                    zone = "0" + zone;
                }
                return new ProjectionPool().get("EPSG:" + datum + zone);
            }
        } else if (this.selectedDatum == 4) {
            datum = "269";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                String zone = Integer.toString(this.selectedZone + 3);
                if (this.selectedZone + 3 <= 9) {
                    zone = "0" + zone;
                }
                return new ProjectionPool().get("EPSG:" + datum + zone);
            }
            if (this.selectedProj == 2) {
                return new ProjectionPool().get("EPSG:42304");
            }
        } else if (this.selectedDatum == 5) {
            datum = "247";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                String zone = Integer.toString(this.selectedZone + 18);
                return new ProjectionPool().get("EPSG:" + datum + zone);
            }
        } else if (this.selectedDatum == 6) {
            datum = "807";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                return new ProjectionPool().get("EPSG:27582");
            }
        } else if (this.selectedDatum == 7) {
            datum = "258";
            if (this.selectedProj == 0) {
                return new ProjectionPool().get("EPSG:4" + datum);
            }
            if (this.selectedProj == 1) {
                String zone = Integer.toString(this.selectedZone + 28);
                return new ProjectionPool().get("EPSG:" + datum + zone);
            }
        } else {
            if (this.selectedDatum == 8) {
                datum = "30100";
                return new ProjectionPool().get("IAU2000:" + datum);
            }
            if (this.selectedDatum == 9) {
                datum = "49900";
                return new ProjectionPool().get("IAU2000:" + datum);
            }
            if (this.selectedDatum == 10) {
                datum = "221";
                if (this.selectedProj == 0) {
                    return new ProjectionPool().get("EPSG:4" + datum);
                }
                if (this.selectedProj == 1) {
                    String zone = Integer.toString(this.selectedZone + 1);
                    return new ProjectionPool().get("EPSG:" + datum + "9" + zone);
                }
            } else if (this.selectedDatum == 11) {
                if (this.selectedProj == 0) {
                    return new ProjectionPool().get("EPSG:4171");
                }
                if (this.selectedProj == 1) {
                    return new ProjectionPool().get("EPSG:2154");
                }
            }
        }
        if (this.selectedProj == 2) {
            return new ProjectionPool().get("EPSG:27492");
        }
        if (this.selectedProj == 3) {
            return new ProjectionPool().get("EPSG:42101");
        }
        if (this.selectedProj == 4) {
            return new ProjectionPool().get("EPSG:42304");
        }
        if (this.selectedProj == 5) {
            return new ProjectionPool().get("EPSG:27582");
        }
        if (this.selectedProj == 6) {
            return new ProjectionPool().get("EPSG:2154");
        }
        if (this.selectedProj == 7) {
            return new ProjectionPool().get("EPSG:9804");
        }
        if (this.selectedProj == 8) {
            datum = "221";
            String zone = "9";
            zone = this.selectedZone < 1 ? zone + "1" : (this.selectedZone > 7 ? zone + "7" : zone + (this.selectedZone + 1) + "");
            return new ProjectionPool().get("EPSG:" + datum + zone);
        }
        if (this.selectedProj == 0) {
            return new ProjectionPool().get("EPSG:4" + datum);
        }
        if (this.selectedProj == 1) {
            String Zone = Integer.toString(this.selectedZone + 1);
            if (this.selectedZone < 9) {
                Zone = "0" + Zone;
            }
            if (this.selectedDatum == 2 || this.selectedDatum == 3) {
                if (this.selectedZone < 3) {
                    Zone = "03";
                }
                if (this.selectedZone > 23) {
                    Zone = "23";
                }
            }
            if (this.selectedDatum == 5) {
                if (this.selectedZone < 18) {
                    Zone = "18";
                }
                if (this.selectedZone > 22) {
                    Zone = "22";
                }
            }
            if (this.selectedDatum == 7) {
                if (this.selectedZone < 28) {
                    Zone = "28";
                }
                if (this.selectedZone > 38) {
                    Zone = "38";
                }
            }
            return new ProjectionPool().get("EPSG:" + datum + Zone);
        }
        return proj;
    }
}

