/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.dynobject.DelegatedDynObject;

public class DGNOpenStoreParameters
extends AbstractDataStoreParameters
implements FilesystemStoreParameters,
OpenFeatureStoreParameters {
    public static final String PARAMETERS_DEFINITION_NAME = "DGN";
    private static final String FIELD_FILE = "file";
    private static final String FIELD_CRS = "CRS";
    private static final String FIELD_XMLFILE = "XMLFile";
    private static final String FIELD_LOAD_MODE = "LoadMode";
    private static final String FIELD_RELOAD = "Reload";
    private static final String FIELD_GEOMTYPE_FILTER = "geomtypeFilter";
    private static final String FIELD_LEVEL_FILTER = "levelFilter";
    private static final String FIELD_TEXT_FILTER = "textFilter";
    private static final String FIELD_COLOR_FILTER = "colorFilter";
    private static final String FIELD_STYLE_FILTER = "styleFilter";
    private static final String FIELD_WEIGHT_FILTER = "weightFilter";
    private static final String FIELD_TYPE_FILTER = "typeFilter";
    private static final String FIELD_STYPE_FILTER = "stypeFilter";
    private static final String FIELD_GROUP_FILTER = "groupFilter";
    private static final String FIELD_ID_FILTER = "idFilter";
    private static final String FIELD_CROP_FILTER = "cropFilter";
    private static final String FIELD_CROPOPERATION_FILTER = "cropOperationFilter";
    private static final String FIELD_SKYPCORRUPTGEOMETRIES_FILTER = "skipCorruptGeometries";
    private static final String FIELD_SORT_BY_GEOMETRY_TYPE = "sortByGeometryType";
    private static final String FIELD_LOGS_ERRORS = "logErrors";
    private static final String FIELD_IGNORE_Z = "ignoreZ";
    private static final String FIELD_GROUPBY = "groupby";
    private static final String FIELD_USE_Z_AS_ELEVATION = "useZAsElevation";
    private static final String FIELD_ELEVATION_FACTOR = "elevationFactor";
    private static final String FIELD_ROUND_ELEVATION = "roundElevation";
    public static final String FIELD_LINK_FILTER_INDEX = "LinkFilterIndex";
    public static final String FIELD_LINK_FILTER_TYPE = "LinkFilterType";
    public static final String FIELD_LINK_FILTER_ENTITY = "LinkFilterEntity";
    public static final String FIELD_LINK_FILTER_MS = "LinkFilterMS";
    public static final String FIELD_LINK_FILTER_DATA = "LinkFilterData";
    public static final String FIELD_GROUP_GEOMETRIES_OPERATION = "GroupGeometriesOperation";
    public static final String FIELD_FORZE2D = "force2D";
    private DelegatedDynObject parameters;

    public DGNOpenStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME);
    }

    protected DGNOpenStoreParameters(String parametersDefinitionName) {
        this(parametersDefinitionName, PARAMETERS_DEFINITION_NAME);
    }

    public DGNOpenStoreParameters(String parametersDefinitionName, String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters((String)parametersDefinitionName);
        this.setDynValue("ProviderName", name);
    }

    public String getDataStoreName() {
        return (String)this.getDynValue("ProviderName");
    }

    public String getDescription() {
        return this.getDynClass().getDescription();
    }

    public void setCRS(IProjection srs) {
        this.setDynValue(FIELD_CRS, srs);
    }

    public void setCRS(String srs) {
        this.setDynValue(FIELD_CRS, srs);
    }

    public IProjection getCRS() {
        return (IProjection)this.getDynValue(FIELD_CRS);
    }

    public String getFileName() {
        return this.getFile().getPath();
    }

    public boolean isValid() {
        if (this.getCRS() == null) {
            return false;
        }
        return this.getFile() != null;
    }

    public File getFile() {
        return (File)this.getDynValue(FIELD_FILE);
    }

    public File getXMLFile() {
        return (File)this.getDynValue(FIELD_XMLFILE);
    }

    public int getGeometryTypeFilter() {
        Integer x = (Integer)this.getDynValue(FIELD_GEOMTYPE_FILTER);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public int getLoadMode() {
        Integer x = (Integer)this.getDynValue(FIELD_LOAD_MODE);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public int getGroupGeometriesOperation() {
        Integer x = (Integer)this.getDynValue(FIELD_GROUP_GEOMETRIES_OPERATION);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public double geElevationFactor() {
        Double x = (Double)this.getDynValue(FIELD_ELEVATION_FACTOR);
        if (x == null) {
            return 1.0;
        }
        return x;
    }

    public int getCropOperationFilter() {
        Integer x = (Integer)this.getDynValue(FIELD_CROPOPERATION_FILTER);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public Geometry getCropFilter() {
        Geometry x = (Geometry)this.getDynValue(FIELD_CROP_FILTER);
        return x;
    }

    public String getGroupBy() {
        return (String)this.getDynValue(FIELD_GROUPBY);
    }

    public String getLevelFilter() {
        return (String)this.getDynValue(FIELD_LEVEL_FILTER);
    }

    public String getGroupFilter() {
        return (String)this.getDynValue(FIELD_GROUP_FILTER);
    }

    public String getTextFilter() {
        return (String)this.getDynValue(FIELD_TEXT_FILTER);
    }

    public String getIDFilter() {
        return (String)this.getDynValue(FIELD_ID_FILTER);
    }

    public String getTypeFilter() {
        return (String)this.getDynValue(FIELD_TYPE_FILTER);
    }

    public String getSTypeFilter() {
        return (String)this.getDynValue(FIELD_STYPE_FILTER);
    }

    public String getColorFilter() {
        return (String)this.getDynValue(FIELD_COLOR_FILTER);
    }

    public String getStyleFilter() {
        return (String)this.getDynValue(FIELD_STYLE_FILTER);
    }

    public String getWeightFilter() {
        return (String)this.getDynValue(FIELD_WEIGHT_FILTER);
    }

    public boolean useReload() {
        Boolean x = (Boolean)this.getDynValue(FIELD_RELOAD);
        if (x == null) {
            return Boolean.FALSE;
        }
        return x;
    }

    public boolean getApplyRoundToElevation() {
        Boolean x = (Boolean)this.getDynValue(FIELD_ROUND_ELEVATION);
        if (x == null) {
            return Boolean.FALSE;
        }
        return x;
    }

    public String getLinkFilterData() {
        return StringUtils.trimToNull((String)((String)this.getDynValue(FIELD_LINK_FILTER_DATA)));
    }

    public Pattern getLinkFilterDataAsPattern() {
        String s = this.getLinkFilterData();
        if (s == null) {
            return null;
        }
        return Pattern.compile(s);
    }

    public Integer getLinkFilterIndex() {
        return (Integer)this.getDynValue(FIELD_LINK_FILTER_INDEX);
    }

    public Integer getLinkFilterType() {
        return (Integer)this.getDynValue(FIELD_LINK_FILTER_TYPE);
    }

    public Integer getLinkFilterEntity() {
        return (Integer)this.getDynValue(FIELD_LINK_FILTER_ENTITY);
    }

    public Integer getLinkFilterMS() {
        return (Integer)this.getDynValue(FIELD_LINK_FILTER_MS);
    }

    public boolean ignoreZs() {
        Boolean x = (Boolean)this.getDynValue(FIELD_IGNORE_Z);
        if (x == null) {
            return Boolean.FALSE;
        }
        return x;
    }

    public boolean logErrors() {
        Boolean x = (Boolean)this.getDynValue(FIELD_LOGS_ERRORS);
        if (x == null) {
            return Boolean.FALSE;
        }
        return x;
    }

    public boolean skipCorruptGeometries() {
        Boolean x = (Boolean)this.getDynValue(FIELD_SKYPCORRUPTGEOMETRIES_FILTER);
        if (x == null) {
            return Boolean.FALSE;
        }
        return x;
    }

    boolean useZAsElevation() {
        Boolean x = (Boolean)this.getDynValue(FIELD_USE_Z_AS_ELEVATION);
        if (x == null) {
            return Boolean.FALSE;
        }
        return x;
    }

    boolean force2D() {
        Boolean x = (Boolean)this.getDynValue(FIELD_FORZE2D);
        if (x == null) {
            return Boolean.FALSE;
        }
        return x;
    }

    public boolean sortByGeometryType() {
        Boolean x = (Boolean)this.getDynValue(FIELD_SORT_BY_GEOMETRY_TYPE);
        if (x == null) {
            return Boolean.TRUE;
        }
        return x;
    }

    public void setFile(File file) {
        this.setDynValue(FIELD_FILE, file);
    }

    public void setFile(String file) {
        this.setDynValue(FIELD_FILE, file);
    }

    public EditableFeatureType getDefaultFeatureType() {
        return null;
    }

    public void setDefaultFeatureType(FeatureType defaultFeatureType) {
        throw new UnsupportedOperationException();
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }
}

