/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.store.dgn.DGNOpenStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessFilterOperation {
    private static final Logger logger = LoggerFactory.getLogger(PostProcessFilterOperation.class);
    private Pattern levelFilter = null;
    private Pattern colorFilter = null;
    private Pattern styleFilter = null;
    private Pattern weighFilter = null;
    private Pattern typeFilter = null;
    private Pattern stypeFilter = null;
    private Pattern idFilter = null;
    private Pattern groupFilter = null;
    private Pattern textFilter = null;
    private Point pointForCheckGeometries = null;
    private boolean hasfilter = false;
    private boolean skipCurruptGeometries = true;
    private int geometryTypeFilter = 0;
    private int counter_exceptions = 0;
    private int cropOperationFilter;
    private Geometry cropFilter = null;
    private int ID_FIELD_LEVEL = -1;
    private int ID_FIELD_COLOR = -1;
    private int ID_FIELD_STYLE = -1;
    private int ID_FIELD_WEIGHT = -1;
    private int ID_FIELD_TYPE = -1;
    private int ID_FIELD_STYPE = -1;
    private int ID_FIELD_GROUP = -1;
    private int ID_FIELD_ID = -1;
    private int ID_FIELD_TEXT = -1;

    PostProcessFilterOperation(DGNOpenStoreParameters parameters, FeatureType featureType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        this.geometryTypeFilter = parameters.getGeometryTypeFilter();
        this.skipCurruptGeometries = parameters.skipCorruptGeometries();
        if (!StringUtils.isBlank((CharSequence)parameters.getLevelFilter())) {
            this.levelFilter = Pattern.compile(parameters.getLevelFilter());
            this.ID_FIELD_LEVEL = featureType.getIndex("Layer");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getColorFilter())) {
            this.colorFilter = Pattern.compile(parameters.getColorFilter());
            this.ID_FIELD_COLOR = featureType.getIndex("Color");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getStyleFilter())) {
            this.styleFilter = Pattern.compile(parameters.getStyleFilter());
            this.ID_FIELD_STYLE = featureType.getIndex("Style");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getTypeFilter())) {
            this.typeFilter = Pattern.compile(parameters.getTypeFilter());
            this.ID_FIELD_TYPE = featureType.getIndex("Type");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getSTypeFilter())) {
            this.stypeFilter = Pattern.compile(parameters.getSTypeFilter());
            this.ID_FIELD_STYPE = featureType.getIndex("SType");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getWeightFilter())) {
            this.weighFilter = Pattern.compile(parameters.getWeightFilter());
            this.ID_FIELD_WEIGHT = featureType.getIndex("Weight");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getGroupFilter())) {
            this.groupFilter = Pattern.compile(parameters.getGroupFilter());
            this.ID_FIELD_GROUP = featureType.getIndex("Group");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getIDFilter())) {
            this.idFilter = Pattern.compile(parameters.getIDFilter());
            this.ID_FIELD_ID = featureType.getIndex("ID");
            this.hasfilter = true;
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getTextFilter())) {
            this.textFilter = Pattern.compile(parameters.getTextFilter());
            this.ID_FIELD_TEXT = featureType.getIndex("Text");
            this.hasfilter = true;
        }
        if (this.geometryTypeFilter != 0) {
            this.hasfilter = true;
        }
        this.cropFilter = parameters.getCropFilter();
        if (this.cropFilter != null) {
            this.hasfilter = true;
        }
        this.cropOperationFilter = parameters.getCropOperationFilter();
        if (this.cropOperationFilter == 0) {
            this.cropFilter = null;
        }
        this.pointForCheckGeometries = null;
        if (this.skipCurruptGeometries) {
            try {
                int geomSubtype = featureType.getDefaultGeometryAttribute().getGeomType().getSubType();
                this.pointForCheckGeometries = geomManager.createPoint(1.0, 1.0, geomSubtype);
                if (geomSubtype == 1) {
                    this.pointForCheckGeometries.setCoordinateAt(2, 1.0);
                }
            }
            catch (Exception ex) {
                this.pointForCheckGeometries = null;
            }
        }
    }

    public boolean hasFilter() {
        return this.hasfilter;
    }

    private boolean match(Pattern exp, Object value) {
        if (value == null) {
            return false;
        }
        return exp.matcher(value.toString()).matches();
    }

    public boolean accept(FeatureProvider data) {
        if (!this.hasfilter) {
            return true;
        }
        Geometry geometry = data.getDefaultGeometry();
        if (this.pointForCheckGeometries != null && geometry != null) {
            try {
                this.pointForCheckGeometries.intersects(geometry);
            }
            catch (Exception ex) {
                data.setDefaultGeometry(null);
                geometry = null;
            }
        }
        try {
            if (this.levelFilter != null && !this.match(this.levelFilter, data.get(this.ID_FIELD_LEVEL))) {
                return false;
            }
            if (this.colorFilter != null && !this.match(this.colorFilter, data.get(this.ID_FIELD_COLOR))) {
                return false;
            }
            if (this.styleFilter != null && !this.match(this.styleFilter, data.get(this.ID_FIELD_STYLE))) {
                return false;
            }
            if (this.weighFilter != null && !this.match(this.weighFilter, data.get(this.ID_FIELD_WEIGHT))) {
                return false;
            }
            if (this.typeFilter != null && !this.match(this.typeFilter, data.get(this.ID_FIELD_TYPE))) {
                return false;
            }
            if (this.stypeFilter != null && !this.match(this.stypeFilter, data.get(this.ID_FIELD_STYPE))) {
                return false;
            }
            if (this.groupFilter != null && !this.match(this.groupFilter, data.get(this.ID_FIELD_GROUP))) {
                return false;
            }
            if (this.idFilter != null && !this.match(this.idFilter, data.get(this.ID_FIELD_ID))) {
                return false;
            }
            if (this.textFilter != null && !this.match(this.textFilter, data.get(this.ID_FIELD_TEXT))) {
                return false;
            }
            if (geometry != null) {
                if (this.geometryTypeFilter != 0) {
                    GeometryType geomtype = geometry.getGeometryType();
                    switch (this.geometryTypeFilter) {
                        case 1: {
                            if (geomtype.isTypeOf(1) || geomtype.isTypeOf(7)) break;
                            return false;
                        }
                        case 2: {
                            if (geomtype.isTypeOf(2) || geomtype.isTypeOf(8)) break;
                            return false;
                        }
                        case 3: {
                            if (geomtype.isTypeOf(3) || geomtype.isTypeOf(9)) break;
                            return false;
                        }
                    }
                }
                if (this.cropFilter != null) {
                    switch (this.cropOperationFilter) {
                        case 1: {
                            if (this.cropFilter.contains(geometry)) break;
                            return false;
                        }
                        case 3: {
                            if (this.cropFilter.coveredBy(geometry)) break;
                            return false;
                        }
                        case 2: {
                            if (this.cropFilter.covers(geometry)) break;
                            return false;
                        }
                        case 4: {
                            if (this.cropFilter.crosses(geometry)) break;
                            return false;
                        }
                        case 5: {
                            if (this.cropFilter.disjoint(geometry)) break;
                            return false;
                        }
                        case 6: {
                            if (this.cropFilter.intersects(geometry)) break;
                            return false;
                        }
                        case 7: {
                            if (this.cropFilter.overlaps(geometry)) break;
                            return false;
                        }
                        case 8: {
                            if (this.cropFilter.touches(geometry)) break;
                            return false;
                        }
                        case 9: {
                            if (this.cropFilter.within(geometry)) break;
                            return false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            if (++this.counter_exceptions < 10) {
                logger.warn("Can't filter data, accept it.", (Throwable)ex);
            } else if (this.counter_exceptions == 10) {
                logger.warn("Can't filter data, accept it.", (Throwable)ex);
                logger.warn("Too many exceptions, dont show more.");
            }
            return true;
        }
        return true;
    }
}

