/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferInterpolation {
    private static final Logger LOG = LoggerFactory.getLogger(BufferInterpolation.class);

    public void nearestNeighbourInterpolation(Buffer source, Buffer target, SimpleTaskStatus status) {
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Nearest neighbour interpolation");
            status.add();
            isMyStatus = true;
        } else {
            status.push();
        }
        try {
            int rows = target.getRows();
            int columns = target.getColumns();
            double stepX = (double)columns / (double)source.getColumns();
            double stepY = (double)rows / (double)source.getRows();
            status.setRangeOfValues(0L, (long)(source.getBandCount() * source.getRows() * source.getColumns()));
            status.message("Calculating interpolation");
            int count = 0;
            for (int iBand = 0; iBand < source.getBandCount(); ++iBand) {
                int sourceRow;
                Band sourceBand = source.getBand(iBand);
                Band targetBand = target.getBand(iBand);
                if (stepY < 1.0) {
                    int previousTargetRow = -1;
                    for (sourceRow = 0; sourceRow < source.getRows(); ++sourceRow) {
                        int targetRow = (int)((double)sourceRow * stepY);
                        if (targetRow != previousTargetRow) {
                            if (stepX < 1.0) {
                                this.submuestreoX(source, stepX, sourceBand, targetBand, sourceRow, targetRow);
                            } else {
                                this.supermuestreoX(columns, stepX, sourceBand, targetBand, sourceRow, targetRow);
                            }
                            status.setCurValue((long)(count += source.getColumns()));
                            if (status.isCancelled()) {
                                status.abort();
                                return;
                            }
                            previousTargetRow = targetRow;
                            continue;
                        }
                        status.setCurValue((long)(count += source.getColumns()));
                    }
                    continue;
                }
                for (int targetRow = 0; targetRow < rows; ++targetRow) {
                    sourceRow = (int)((double)targetRow / stepY);
                    if (stepX < 1.0) {
                        this.submuestreoX(source, stepX, sourceBand, targetBand, sourceRow, targetRow);
                    } else {
                        this.supermuestreoX(columns, stepX, sourceBand, targetBand, sourceRow, targetRow);
                    }
                    status.setCurValue((long)(count += source.getColumns()));
                    if (!status.isCancelled()) continue;
                    status.abort();
                    return;
                }
            }
            if (isMyStatus) {
                status.terminate();
            } else {
                status.pop();
            }
        }
        catch (Exception e) {
            status.abort();
            throw e;
        }
    }

    private void supermuestreoX(int columns, double stepX, Band sourceBand, Band targetBand, int sourceRow, int targetRow) {
        for (int targetCol = 0; targetCol < columns; ++targetCol) {
            int sourceColumn = (int)((double)targetCol / stepX);
            targetBand.set(targetRow, targetCol, sourceBand.get(sourceRow, sourceColumn));
        }
    }

    private void submuestreoX(Buffer source, double stepX, Band sourceBand, Band targetBand, int sourceRow, int targetRow) {
        int previousTargetColumn = -1;
        for (int sourceCol = 0; sourceCol < source.getColumns(); ++sourceCol) {
            int targetColumn = (int)((double)sourceCol * stepX);
            if (targetColumn == previousTargetColumn) continue;
            Object value = sourceBand.get(sourceRow, sourceCol);
            targetBand.set(targetRow, targetColumn, value);
            previousTargetColumn = targetColumn;
        }
    }

    public void bilinearInterpolation(Buffer source, Buffer target, SimpleTaskStatus status) {
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Bilinear interpolation");
            status.add();
            isMyStatus = true;
        } else {
            status.push();
        }
        status.add();
        try {
            int rows = target.getRows();
            int columns = target.getColumns();
            double pxSizeX = (double)source.getColumns() / (double)columns;
            double pxSizeY = (double)source.getRows() / (double)rows;
            double dx = 0.0;
            double dy = 0.0;
            int bandCount = source.getBandCount();
            for (int iBand = 0; iBand < bandCount; ++iBand) {
                status.setRangeOfValues(0L, (long)source.getRows());
                status.message("Interpolating, band " + iBand + "/" + bandCount);
                status.setCurValue(0L);
                double posY = pxSizeY / 2.0;
                Band sourceBand = source.getBand(iBand);
                Band targetBand = target.getBand(iBand);
                for (int iRow = 0; iRow < rows; ++iRow) {
                    status.setCurValue((long)iRow);
                    if (status.isCancelled()) {
                        status.abort();
                        return;
                    }
                    dy = posY - (double)((int)posY);
                    double posX = pxSizeX / 2.0;
                    for (int iCol = 0; iCol < columns; ++iCol) {
                        dx = posX - (double)((int)posX);
                        try {
                            double[] kernel = this.getKernel((int)posY, (int)posX, sourceBand);
                            this.setBandValueFromDouble(iRow, iCol, targetBand, this.getBilinearValue(dx, dy, kernel));
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            LOG.warn("Array index out of bounds exception. [band rows: {} band cols: {} row: {} col: {} dx: {} dy: {}]", new Object[]{targetBand.getRows(), targetBand.getColumns(), iRow, iCol, dx, dy});
                        }
                        posX += pxSizeX;
                    }
                    posY += pxSizeY;
                }
            }
            if (isMyStatus) {
                status.terminate();
            } else {
                status.pop();
            }
        }
        catch (Exception e) {
            status.abort();
            throw e;
        }
    }

    public void inverseDistanceInterpolation(Buffer source, Buffer target, SimpleTaskStatus status) {
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Inverse distance interpolation");
            status.add();
            isMyStatus = true;
        } else {
            status.push();
        }
        try {
            int rows = target.getRows();
            int columns = target.getColumns();
            double pxSizeX = (double)source.getColumns() / (double)columns;
            double pxSizeY = (double)source.getRows() / (double)rows;
            status.setRangeOfValues(0L, (long)(source.getBandCount() * source.getRows() * source.getColumns()));
            status.message("Calculating interpolation");
            int count = 0;
            double dx = 0.0;
            double dy = 0.0;
            for (int iBand = 0; iBand < source.getBandCount(); ++iBand) {
                double posY = pxSizeY / 2.0;
                Band sourceBand = source.getBand(iBand);
                Band targetBand = target.getBand(iBand);
                for (int iRow = 0; iRow < rows; ++iRow) {
                    dy = posY - (double)((int)posY);
                    double posX = pxSizeX / 2.0;
                    for (int iCol = 0; iCol < columns; ++iCol) {
                        status.setCurValue((long)count++);
                        if (status.isCancelled()) {
                            status.abort();
                            return;
                        }
                        dx = posX - (double)((int)posX);
                        try {
                            double[] kernel = this.getKernel((int)posY, (int)posX, sourceBand);
                            this.setBandValueFromDouble(iRow, iCol, targetBand, this.getInverseDistanceValue(dx, dy, kernel));
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            LOG.warn("Array index out of bounds exception. [band rows: {} band cols: {} row: {} col: {} dx: {} dy: {}]", new Object[]{targetBand.getRows(), targetBand.getColumns(), iRow, iCol, dx, dy});
                        }
                        posX += pxSizeX;
                    }
                    posY += pxSizeY;
                }
            }
            if (isMyStatus) {
                status.terminate();
            } else {
                status.pop();
            }
        }
        catch (Exception e) {
            status.abort();
            throw e;
        }
    }

    public void bicubicSplineInterpolation(Buffer source, Buffer target, SimpleTaskStatus status) {
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Bicubic spline interpolation");
            status.add();
            isMyStatus = true;
        } else {
            status.push();
        }
        try {
            int rows = target.getRows();
            int columns = target.getColumns();
            double pxSizeX = (double)source.getColumns() / (double)columns;
            double pxSizeY = (double)source.getRows() / (double)rows;
            status.setRangeOfValues(0L, (long)(source.getRows() * source.getBandCount()));
            status.message("Calculating interpolation");
            int count = 0;
            double dx = 0.0;
            double dy = 0.0;
            for (int iBand = 0; iBand < source.getBandCount(); ++iBand) {
                double posY = pxSizeY / 2.0;
                Band sourceBand = source.getBand(iBand);
                Band targetBand = target.getBand(iBand);
                for (int iRow = 0; iRow < rows; ++iRow) {
                    status.setCurValue((long)count++);
                    if (status.isCancelled()) {
                        status.abort();
                        return;
                    }
                    dy = posY - (double)((int)posY);
                    double posX = pxSizeX / 2.0;
                    for (int iCol = 0; iCol < columns; ++iCol) {
                        dx = posX - (double)((int)posX);
                        try {
                            double[][] submatrix = this.get4x4Submatrix((int)posY, (int)posX, source, sourceBand);
                            if (submatrix == null) {
                                double[] kernel = this.getKernel((int)posY, (int)posX, sourceBand);
                                this.setBandValueFromDouble(iRow, iCol, targetBand, this.getBilinearValue(dx, dy, kernel));
                            } else {
                                this.setBandValueFromDouble(iRow, iCol, targetBand, this.getBSplineValue(dx, dy, submatrix));
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            LOG.warn("Array index out of bounds exception. [band rows: {} band cols: {} row: {} col: {} dx: {} dy: {}]", new Object[]{targetBand.getRows(), targetBand.getColumns(), iRow, iCol, dx, dy});
                        }
                        posX += pxSizeX;
                    }
                    posY += pxSizeY;
                }
            }
            if (isMyStatus) {
                status.terminate();
            } else {
                status.pop();
            }
        }
        catch (Exception e) {
            status.abort();
            throw e;
        }
    }

    public void bSplineInterpolation(Buffer source, Buffer target, SimpleTaskStatus status) {
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("BSpline interpolation");
            status.add();
            isMyStatus = true;
        } else {
            status.push();
        }
        try {
            int rows = target.getRows();
            int columns = target.getColumns();
            double pxSizeX = (double)source.getColumns() / (double)columns;
            double pxSizeY = (double)source.getRows() / (double)rows;
            status.setRangeOfValues(0L, (long)(source.getBandCount() * source.getRows() * source.getColumns()));
            status.message("Calculating interpolation");
            int count = 0;
            double dx = 0.0;
            double dy = 0.0;
            for (int iBand = 0; iBand < source.getBandCount(); ++iBand) {
                double posY = pxSizeY / 2.0;
                Band sourceBand = source.getBand(iBand);
                Band targetBand = target.getBand(iBand);
                for (int iRow = 0; iRow < rows; ++iRow) {
                    dy = posY - (double)((int)posY);
                    double posX = pxSizeX / 2.0;
                    for (int iCol = 0; iCol < columns; ++iCol) {
                        status.setCurValue((long)count++);
                        if (status.isCancelled()) {
                            status.abort();
                            return;
                        }
                        dx = posX - (double)((int)posX);
                        try {
                            double[][] submatrix = this.get4x4Submatrix((int)posY, (int)posX, source, sourceBand);
                            if (submatrix == null) {
                                double[] kernel = this.getKernel((int)posY, (int)posX, sourceBand);
                                this.setBandValueFromDouble(iRow, iCol, targetBand, this.getBilinearValue(dx, dy, kernel));
                            } else {
                                this.setBandValueFromDouble(iRow, iCol, targetBand, this.getBicubicSplineValue(dx, dy, submatrix));
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            LOG.warn("Array index out of bounds exception. [band rows: {} band cols: {} row: {} col: {} dx: {} dy: {}]", new Object[]{targetBand.getRows(), targetBand.getColumns(), iRow, iCol, dx, dy});
                        }
                        posX += pxSizeX;
                    }
                    posY += pxSizeY;
                }
            }
            if (isMyStatus) {
                status.terminate();
            } else {
                status.pop();
            }
        }
        catch (Exception e) {
            status.abort();
            throw e;
        }
    }

    private double getBicubicSplineValue(double dx, double dy, double[][] kernel) {
        double b3;
        double b2;
        double b1;
        double a3;
        double a2;
        double a0;
        double[] c = new double[4];
        for (int i = 0; i < 4; ++i) {
            a0 = kernel[0][i] - kernel[1][i];
            a2 = kernel[2][i] - kernel[1][i];
            a3 = kernel[3][i] - kernel[1][i];
            b1 = -a0 / 3.0 + a2 - a3 / 6.0;
            b2 = a0 / 2.0 + a2 / 2.0;
            b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
            c[i] = kernel[1][i] + b1 * dx + b2 * (dx * dx) + b3 * (dx * dx * dx);
        }
        a0 = c[0] - c[1];
        a2 = c[2] - c[1];
        a3 = c[3] - c[1];
        b1 = -a0 / 3.0 + a2 - a3 / 6.0;
        b2 = a0 / 2.0 + a2 / 2.0;
        b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
        return c[1] + b1 * dy + b2 * (dy * dy) + b3 * (dy * dy * dy);
    }

    private double getBSplineValue(double dx, double dy, double[][] kernel) {
        int i = 0;
        int ix = 0;
        int iy = 0;
        double px = 0.0;
        double py = 0.0;
        double z = 0.0;
        double[] Rx = new double[4];
        double[] Ry = new double[4];
        i = 0;
        px = -1.0 - dx;
        py = -1.0 - dy;
        while (i < 4) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            Rx[i] = 0.0;
            Ry[i] = 0.0;
            z = px + 2.0;
            if (d8 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + z * z * z;
            }
            z = px + 1.0;
            if (d7 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + -4.0 * z * z * z;
            }
            z = px + 0.0;
            if (d6 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + 6.0 * z * z * z;
            }
            z = px - 1.0;
            if (d5 > 0.0) {
                int n = i;
                Rx[n] = Rx[n] + -4.0 * z * z * z;
            }
            z = py + 2.0;
            if (d4 > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + z * z * z;
            }
            z = py + 1.0;
            if (d3 > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + -4.0 * z * z * z;
            }
            z = py + 0.0;
            if (d2 > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + 6.0 * z * z * z;
            }
            z = py - 1.0;
            if (d > 0.0) {
                int n = i;
                Ry[n] = Ry[n] + -4.0 * z * z * z;
            }
            int n = i;
            Rx[n] = Rx[n] / 6.0;
            int n2 = i++;
            Ry[n2] = Ry[n2] / 6.0;
            px += 1.0;
            py += 1.0;
        }
        z = 0.0;
        for (iy = 0; iy < 4; ++iy) {
            for (ix = 0; ix < 4; ++ix) {
                z += kernel[ix][iy] * Rx[ix] * Ry[iy];
            }
        }
        return z;
    }

    private double getBilinearValue(double dx, double dy, double[] kernel) {
        double z = 0.0;
        double n = 0.0;
        double d = (1.0 - dx) * (1.0 - dy);
        z += d * kernel[0];
        n += d;
        d = dx * (1.0 - dy);
        z += d * kernel[1];
        n += d;
        d = (1.0 - dx) * dy;
        z += d * kernel[2];
        n += d;
        d = dx * dy;
        z += d * kernel[3];
        n += d;
        double b = 0.0;
        if (n > 0.0) {
            b = z / n;
        }
        return b;
    }

    private double getInverseDistanceValue(double dx, double dy, double[] kernel) {
        double z = 0.0;
        double n = 0.0;
        double t = Math.sqrt(dx * dx + dy * dy);
        double d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[0];
        n += d;
        t = Math.sqrt((1.0 - dx) * (1.0 - dx) + dy * dy);
        d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[1];
        n += d;
        t = Math.sqrt(dx * dx + (1.0 - dy) * (1.0 - dy));
        d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[2];
        n += d;
        t = Math.sqrt((1.0 - dx) * (1.0 - dx) + (1.0 - dy) * (1.0 - dy));
        d = 1.0 / (t == 0.0 ? 0.5 : t);
        z += d * kernel[3];
        n += d;
        double b = 0.0;
        if (n > 0.0) {
            b = z / n;
        }
        return b;
    }

    private double[][] get4x4Submatrix(int row, int column, Buffer buffer, Band band) {
        double[][] z_xy = new double[4][4];
        int iy = 0;
        int py = row - 1;
        while (iy < 4) {
            int ix = 0;
            int px = column - 1;
            while (ix < 4) {
                if (!buffer.isInside(px, py)) {
                    return null;
                }
                z_xy[ix][iy] = this.getBandValueToDouble(py, px, band);
                ++ix;
                ++px;
            }
            ++iy;
            ++py;
        }
        return z_xy;
    }

    private double[] getKernel(int row, int column, Band band) {
        double[] d = new double[4];
        d[0] = this.getBandValueToDouble(row, column, band);
        int nextColumn = column + 1 >= band.getColumns() ? column : column + 1;
        int nextRow = row + 1 >= band.getRows() ? row : row + 1;
        d[1] = this.getBandValueToDouble(row, nextColumn, band);
        d[2] = this.getBandValueToDouble(nextRow, column, band);
        d[3] = this.getBandValueToDouble(nextRow, nextColumn, band);
        return d;
    }

    private double getBandValueToDouble(int row, int column, Band band) {
        switch (band.getDataType()) {
            case 0: {
                return ((Band.BandByte)band).getValue(row, column) & 0xFF;
            }
            case 1: 
            case 2: {
                return ((Band.BandShort)band).getValue(row, column) & 0xFFFF;
            }
            case 3: {
                return ((Band.BandInt)band).getValue(row, column) & 0xFFFFFFFF;
            }
            case 4: {
                return ((Band.BandFloat)band).getValue(row, column);
            }
            case 5: {
                return ((Band.BandDouble)band).getValue(row, column);
            }
        }
        throw new IllegalArgumentException("Unknow dataType " + band.getDataType() + ".");
    }

    private void setBandValueFromDouble(int row, int column, Band band, Number value) {
        switch (band.getDataType()) {
            case 0: {
                ((Band.BandByte)band).setValue(row, column, value.byteValue());
                break;
            }
            case 1: 
            case 2: {
                ((Band.BandShort)band).setValue(row, column, value.shortValue());
                break;
            }
            case 3: {
                ((Band.BandInt)band).setValue(row, column, value.intValue());
                break;
            }
            case 4: {
                ((Band.BandFloat)band).setValue(row, column, value.floatValue());
                break;
            }
            case 5: {
                ((Band.BandDouble)band).setValue(row, column, value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow dataType " + band.getDataType() + ".");
            }
        }
    }
}

