/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractConvertedTypeBand;

public class ConvertedTypeBandInt
extends AbstractConvertedTypeBand
implements Band.BandInt {
    public ConvertedTypeBandInt(Buffer buffer, Band band) {
        super(buffer, band);
    }

    public int[] createRowBuffer() {
        return new int[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        for (int i = 0; i < this.getColumns(); ++i) {
            ((int[])rowBuffer)[i] = ((Number)this.band.get(row, i)).intValue();
        }
    }

    public int getValue(int row, int column) {
        return ((Number)this.get(row, column)).intValue();
    }

    public void setValue(int row, int column, int value) {
        this.doSet(row, column, new Integer(value));
    }

    public int getDataType() {
        return 3;
    }

    public Object get(int row, int column) {
        return ((Number)this.get(row, column)).intValue();
    }

    @Override
    public NoData getNoData() {
        NoData bandNoData = this.band.getNoData();
        if (bandNoData == null) {
            this.noData = BufferLocator.getBufferManager().createNoData(null, null);
        } else {
            Integer value = null;
            Integer defaultValue = null;
            Number bandvalue = bandNoData.getValue();
            Number bandDefaultValue = bandNoData.getDefaultValue();
            if (bandvalue != null) {
                value = bandvalue.intValue();
            }
            if (bandDefaultValue != null) {
                defaultValue = bandDefaultValue.intValue();
            }
            this.noData = BufferLocator.getBufferManager().createNoData((Number)value, (Number)defaultValue);
        }
        return this.noData;
    }
}

