/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.raster.lib.buffer.api.BandTileManager;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.Kernel;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.OperationManager;
import org.gvsig.raster.lib.buffer.api.PageManager;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.Operation;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.operations.OperationList;
import org.gvsig.raster.lib.buffer.api.operations.OperationListEntry;
import org.gvsig.raster.lib.buffer.impl.AwtRasterBandPageManager;
import org.gvsig.raster.lib.buffer.impl.ClippedBandByte;
import org.gvsig.raster.lib.buffer.impl.ClippedBandDouble;
import org.gvsig.raster.lib.buffer.impl.ClippedBandFloat;
import org.gvsig.raster.lib.buffer.impl.ClippedBandInt;
import org.gvsig.raster.lib.buffer.impl.ClippedBandShort;
import org.gvsig.raster.lib.buffer.impl.ClippedBuffer;
import org.gvsig.raster.lib.buffer.impl.ConvertedTypeBandByte;
import org.gvsig.raster.lib.buffer.impl.ConvertedTypeBandDouble;
import org.gvsig.raster.lib.buffer.impl.ConvertedTypeBandFloat;
import org.gvsig.raster.lib.buffer.impl.ConvertedTypeBandInt;
import org.gvsig.raster.lib.buffer.impl.ConvertedTypeBandShort;
import org.gvsig.raster.lib.buffer.impl.ConvertedTypeBuffer;
import org.gvsig.raster.lib.buffer.impl.DefaultBandInfo;
import org.gvsig.raster.lib.buffer.impl.DefaultBuffer;
import org.gvsig.raster.lib.buffer.impl.DefaultBufferDimensions;
import org.gvsig.raster.lib.buffer.impl.DefaultKernel;
import org.gvsig.raster.lib.buffer.impl.DefaultNoData;
import org.gvsig.raster.lib.buffer.impl.MemoryBandByte;
import org.gvsig.raster.lib.buffer.impl.MemoryBandDouble;
import org.gvsig.raster.lib.buffer.impl.MemoryBandFloat;
import org.gvsig.raster.lib.buffer.impl.MemoryBandInt;
import org.gvsig.raster.lib.buffer.impl.MemoryBandShort;
import org.gvsig.raster.lib.buffer.impl.PaginatedBandByte;
import org.gvsig.raster.lib.buffer.impl.PaginatedBandDouble;
import org.gvsig.raster.lib.buffer.impl.PaginatedBandFloat;
import org.gvsig.raster.lib.buffer.impl.PaginatedBandInt;
import org.gvsig.raster.lib.buffer.impl.PaginatedBandShort;
import org.gvsig.raster.lib.buffer.impl.SimpleBandPageManager;
import org.gvsig.raster.lib.buffer.impl.TiledBandByte;
import org.gvsig.raster.lib.buffer.impl.TiledBandDouble;
import org.gvsig.raster.lib.buffer.impl.TiledBandFloat;
import org.gvsig.raster.lib.buffer.impl.TiledBandInt;
import org.gvsig.raster.lib.buffer.impl.TiledBandShort;
import org.gvsig.raster.lib.buffer.impl.exceptions.CreateBandTypeException;
import org.gvsig.raster.lib.buffer.impl.exceptions.CreateBufferException;
import org.gvsig.raster.lib.buffer.impl.operations.DefaultOperationList;
import org.gvsig.raster.lib.buffer.impl.operations.DefaultOperationListEntry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToDouble;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToFloat;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToInt;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBufferManager
implements BufferManager,
OperationManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBufferManager.class);
    private File lastFolderUsedToSave;
    private int simplePaginatedCounter = 0;
    private Map<String, OperationFactory> operationFactoriesRegister = new HashMap<String, OperationFactory>();

    public NoData createNoData(Number value, Number defaultValue) {
        DefaultNoData noData = new DefaultNoData(defaultValue);
        noData.setValue(value);
        return noData;
    }

    public Band createBand(int dataType, int rows, int columns, NoData noData, PageManager pageManager) throws CreateBandTypeException {
        if (pageManager == null) {
            switch (dataType) {
                case 0: {
                    return new MemoryBandByte(rows, columns, noData);
                }
                case 2: {
                    return new MemoryBandShort(rows, columns, noData);
                }
                case 3: {
                    return new MemoryBandInt(rows, columns, noData);
                }
                case 4: {
                    return new MemoryBandFloat(rows, columns, noData);
                }
                case 5: {
                    return new MemoryBandDouble(rows, columns, noData);
                }
            }
            throw new CreateBandTypeException(dataType);
        }
        if (pageManager instanceof BandPageManager) {
            switch (dataType) {
                case 0: {
                    return new PaginatedBandByte(rows, columns, noData, (BandPageManager)pageManager);
                }
                case 2: {
                    return new PaginatedBandShort(rows, columns, noData, (BandPageManager)pageManager);
                }
                case 3: {
                    return new PaginatedBandInt(rows, columns, noData, (BandPageManager)pageManager);
                }
                case 4: {
                    return new PaginatedBandFloat(rows, columns, noData, (BandPageManager)pageManager);
                }
                case 5: {
                    return new PaginatedBandDouble(rows, columns, noData, (BandPageManager)pageManager);
                }
            }
            throw new CreateBandTypeException(dataType);
        }
        if (pageManager instanceof BandTileManager) {
            switch (dataType) {
                case 0: {
                    return new TiledBandByte(rows, columns, noData, (BandTileManager)pageManager);
                }
                case 1: 
                case 2: {
                    return new TiledBandShort(rows, columns, noData, (BandTileManager)pageManager);
                }
                case 3: {
                    return new TiledBandInt(rows, columns, noData, (BandTileManager)pageManager);
                }
                case 4: {
                    return new TiledBandFloat(rows, columns, noData, (BandTileManager)pageManager);
                }
                case 5: {
                    return new TiledBandDouble(rows, columns, noData, (BandTileManager)pageManager);
                }
            }
            throw new CreateBandTypeException(dataType);
        }
        return null;
    }

    public Buffer createBuffer(int rows, int columns, int[] bandDataTypes, IProjection projection) throws BufferException {
        return new DefaultBuffer(rows, columns, bandDataTypes, null, projection, null, null);
    }

    public Buffer createBuffer(int rows, int columns, int[] bandDataTypes, NoData[] bandNoData, IProjection projection) throws CreateBufferException {
        return new DefaultBuffer(rows, columns, bandDataTypes, bandNoData, projection, null, null);
    }

    public Buffer createBuffer(int rows, int columns, int[] bandDataTypes, NoData[] bandNoData, IProjection projection, Envelope envelope) throws BufferException {
        return new DefaultBuffer(rows, columns, bandDataTypes, bandNoData, projection, envelope, null);
    }

    public Buffer createBuffer(int rows, int columns, int[] bandDataTypes, NoData[] bandNoData, IProjection projection, Envelope envelope, List<PageManager> pageManagers) throws BufferException {
        return new DefaultBuffer(rows, columns, bandDataTypes, bandNoData, projection, envelope, pageManagers);
    }

    public BandPageManager createSimpleBandPageManager(File file, int rows, int columns, int dataType) throws IOException {
        return new SimpleBandPageManager(file, rows, columns, dataType);
    }

    public int getDataTypeSize(int dataType) {
        switch (dataType) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Data Type " + dataType + " not supported.");
    }

    public List<PageManager> createSimpleBandPageManagerList(File[] files, int rows, int columns, int[] dataType) throws IOException {
        if (files == null) {
            files = new File[dataType.length];
        }
        if (dataType.length != files.length) {
            throw new IllegalArgumentException("Length files array has to be same as length dataType array.");
        }
        ArrayList<PageManager> pageManagers = new ArrayList<PageManager>();
        for (int i = 0; i < dataType.length; ++i) {
            pageManagers.add((PageManager)this.createSimpleBandPageManager(files[i], rows, columns, dataType[i]));
        }
        return pageManagers;
    }

    public Buffer createClippedBuffer(Buffer buffer, Envelope envelope) throws BufferException {
        if (buffer == null) {
            try {
                throw new IllegalArgumentException("Can't clip a null buffer");
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (envelope == null) {
            try {
                throw new IllegalArgumentException("Null envelope");
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        Envelope bufferEnvelope = null;
        try {
            bufferEnvelope = buffer.getEnvelope();
        }
        catch (Exception e) {
            logger.warn("Can't get buffer envelope", (Throwable)e);
            throw new BufferException((Throwable)e);
        }
        if (!bufferEnvelope.intersects(envelope)) {
            return null;
        }
        try {
            Geometry intersection = bufferEnvelope.getGeometry().intersection(envelope.getGeometry());
            if (intersection == null) {
                return null;
            }
        }
        catch (GeometryOperationException | GeometryOperationNotSupportedException e1) {
            logger.warn("Can't get intersection between two envelopes", e1);
            return null;
        }
        return new ClippedBuffer(buffer, envelope);
    }

    public Buffer createConvertedTypeBuffer(Buffer buffer, int type) throws BufferException {
        return new ConvertedTypeBuffer(buffer, type);
    }

    public Band createClippedBand(Buffer buffer, Band band) throws CreateBandTypeException {
        int dataType = band.getDataType();
        switch (dataType) {
            case 0: {
                return new ClippedBandByte(buffer, band);
            }
            case 2: {
                return new ClippedBandShort(buffer, band);
            }
            case 3: {
                return new ClippedBandInt(buffer, band);
            }
            case 4: {
                return new ClippedBandFloat(buffer, band);
            }
            case 5: {
                return new ClippedBandDouble(buffer, band);
            }
        }
        throw new CreateBandTypeException(dataType);
    }

    public Band createConvertedTypeBand(Buffer buffer, Band band, int type) throws BandException {
        switch (type) {
            case 0: {
                return new ConvertedTypeBandByte(buffer, band);
            }
            case 1: 
            case 2: {
                return new ConvertedTypeBandShort(buffer, band);
            }
            case 3: {
                return new ConvertedTypeBandInt(buffer, band);
            }
            case 4: {
                return new ConvertedTypeBandFloat(buffer, band);
            }
            case 5: {
                return new ConvertedTypeBandDouble(buffer, band);
            }
        }
        throw new CreateBandTypeException(type);
    }

    public BandInfo createBandInfo(int band, String name, String description, int dataType, List<Map.Entry<Object, Object>> values) {
        return new DefaultBandInfo(band, name, description, dataType, values);
    }

    public Buffer createBuffer(Buffer buffer, boolean paginated) throws BufferException {
        List<PageManager> pageManagers = null;
        try {
            if (paginated) {
                pageManagers = this.createPageManagerList(buffer.getBandCount(), buffer.getRows(), buffer.getColumns(), buffer.getBandTypes());
            }
            Buffer newBuffer = this.createBuffer(buffer.getRows(), buffer.getColumns(), buffer.getBandTypes(), buffer.getBandNoData(), buffer.getProjection(), buffer.getEnvelope(), pageManagers);
            for (int i = 0; i < newBuffer.getBandCount(); ++i) {
                newBuffer.getBand(i).copyFrom(buffer.getBand(i));
            }
            return newBuffer;
        }
        catch (IOException | CreateEnvelopeException | BandException | LocatorException e) {
            throw new CreateBufferException(e);
        }
    }

    public BandPageManager createAwtRasterBandPageManager(Raster img, int band) {
        return new AwtRasterBandPageManager(img, band);
    }

    public List<PageManager> createAwtRasterBandPageManagerList(Raster img) throws IOException {
        ArrayList<PageManager> pageManagers = new ArrayList<PageManager>();
        for (int i = 0; i < img.getNumBands(); ++i) {
            BandPageManager pageManager = this.createAwtRasterBandPageManager(img, i);
            pageManagers.add((PageManager)pageManager);
        }
        return pageManagers;
    }

    private List<PageManager> createPageManagerList(int bands, int rows, int columns, int[] bandTypes) throws IOException {
        ArrayList<PageManager> pageManagers = new ArrayList<PageManager>();
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        for (int i = 0; i < bands; ++i) {
            String filename = "temp-buffer-" + this.simplePaginatedCounter + "-band-" + i + ".tmp";
            File file = foldersManager.getUniqueTemporaryFile(new String[]{filename});
            BandPageManager pageManager = this.createSimpleBandPageManager(file, rows, columns, bandTypes[i]);
            pageManagers.add((PageManager)pageManager);
        }
        ++this.simplePaginatedCounter;
        return pageManagers;
    }

    public List<Buffer> createOneBufferPerBand(Buffer buffer, boolean paginated) throws BufferException {
        ArrayList<Buffer> buffers = new ArrayList<Buffer>();
        try {
            for (int i = 0; i < buffer.getBandCount(); ++i) {
                int[] dataType = new int[]{buffer.getBandTypes()[i]};
                List<PageManager> pageManagers = null;
                if (paginated) {
                    pageManagers = this.createPageManagerList(1, buffer.getRows(), buffer.getColumns(), dataType);
                }
                int[] bandTypes = new int[]{dataType[0]};
                NoData[] bandNoDatas = new NoData[]{buffer.getBandNoData()[i]};
                Buffer newBuffer = this.createBuffer(buffer.getRows(), buffer.getColumns(), bandTypes, bandNoDatas, buffer.getProjection(), buffer.getEnvelope(), pageManagers);
                newBuffer.getBand(0).copyFrom(buffer.getBand(i));
                buffers.add(newBuffer);
            }
        }
        catch (IOException | CreateEnvelopeException | BandException | LocatorException e) {
            throw new CreateBufferException(e);
        }
        return buffers;
    }

    public int getBufferTypeFromAwtRaster(Raster raster) {
        int bufferType;
        int dataType = raster.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                bufferType = 0;
                break;
            }
            case 1: {
                bufferType = 1;
                break;
            }
            case 2: {
                bufferType = 2;
                break;
            }
            case 3: {
                bufferType = 3;
                break;
            }
            case 4: {
                bufferType = 4;
                break;
            }
            case 5: {
                bufferType = 5;
                break;
            }
            default: {
                throw new UnsupportedOperationException("DataBuffer type '" + dataType + "' no yet supported.");
            }
        }
        return bufferType;
    }

    private Buffer createBuffer(BufferedImage img, IProjection projection, Envelope envelope) throws BufferException {
        return this.createBuffer(img, projection, envelope, false);
    }

    private Buffer createBuffer(BufferedImage img, IProjection projection, Envelope envelope, boolean paginated) throws BufferException {
        SampleModel sampleModel = img.getSampleModel();
        int dataType = sampleModel.getDataType();
        int bufferType = this.getBufferTypeFromAwtRaster(img.getRaster());
        int bands = sampleModel.getNumBands();
        int[] bandDataTypes = new int[bands];
        NoData[] bandNoData = new NoData[bands];
        for (int i = 0; i < bandDataTypes.length; ++i) {
            bandDataTypes[i] = bufferType;
            bandNoData[i] = null;
        }
        List<PageManager> pageManagers = null;
        if (paginated) {
            try {
                pageManagers = this.createPageManagerList(bands, img.getHeight(), img.getWidth(), bandDataTypes);
            }
            catch (IOException e) {
                throw new CreateBufferException(e);
            }
        }
        Buffer buffer = this.createBuffer(img.getHeight(), img.getWidth(), bandDataTypes, bandNoData, projection, envelope, pageManagers);
        Raster raster = img.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        for (int i = 0; i < bands; ++i) {
            Object[] rowBuffer;
            Band band = buffer.getBand(i);
            if (bufferType == 0) {
                rowBuffer = (byte[])band.createRowBuffer();
                int[] intRowBuffer = new int[rowBuffer.length];
                for (int row = 0; row < img.getHeight(); ++row) {
                    sampleModel.getSamples(0, row, img.getWidth(), 1, i, intRowBuffer, dataBuffer);
                    for (int c = 0; c < rowBuffer.length; ++c) {
                        rowBuffer[c] = (byte)intRowBuffer[c];
                    }
                    band.putRow(row, (Object)rowBuffer);
                }
                continue;
            }
            if (bufferType != 3) continue;
            rowBuffer = (int[])band.createRowBuffer();
            for (int row = 0; row < img.getHeight(); ++row) {
                sampleModel.getSamples(0, row, img.getWidth(), 1, i, (int[])rowBuffer, dataBuffer);
                band.putRow(row, (Object)rowBuffer);
            }
        }
        return buffer;
    }

    public Buffer createRGBABuffer(BufferedImage img, IProjection projection, Envelope envelope) throws BufferException {
        int imageType = img.getType();
        if (imageType == 6 || imageType == 7) {
            return this.createBuffer(img, projection, envelope);
        }
        int bands = 4;
        int[] bandDataTypes = new int[bands];
        NoData[] bandNoData = new NoData[bands];
        for (int i = 0; i < bandDataTypes.length; ++i) {
            bandDataTypes[i] = 0;
            bandNoData[i] = null;
        }
        Buffer buffer = null;
        buffer = this.createBuffer(img.getHeight(), img.getWidth(), bandDataTypes, bandNoData, projection, envelope);
        for (int r = 0; r < img.getHeight(); ++r) {
            for (int c = 0; c < img.getWidth(); ++c) {
                int color = img.getRGB(c, r);
                Color awtColor = new Color(color, true);
                buffer.getBandByte(0).set(r, c, (Object)((byte)awtColor.getRed()));
                buffer.getBandByte(1).set(r, c, (Object)((byte)awtColor.getGreen()));
                buffer.getBandByte(2).set(r, c, (Object)((byte)awtColor.getBlue()));
                buffer.getBandByte(3).set(r, c, (Object)((byte)awtColor.getAlpha()));
            }
        }
        return buffer;
    }

    public Buffer createRGBBuffer(BufferedImage img, IProjection projection, Envelope envelope) throws BufferException {
        int imageType = img.getType();
        if (imageType == 5) {
            return this.createBuffer(img, projection, envelope);
        }
        int bands = 3;
        int[] bandDataTypes = new int[bands];
        NoData[] bandNoData = new NoData[bands];
        for (int i = 0; i < bandDataTypes.length; ++i) {
            bandDataTypes[i] = 0;
            bandNoData[i] = null;
        }
        Buffer buffer = null;
        buffer = this.createBuffer(img.getHeight(), img.getWidth(), bandDataTypes, bandNoData, projection, envelope);
        for (int r = 0; r < img.getHeight(); ++r) {
            for (int c = 0; c < img.getWidth(); ++c) {
                int color = img.getRGB(c, r);
                Color awtColor = new Color(color, true);
                buffer.getBandByte(0).set(r, c, (Object)((byte)awtColor.getRed()));
                buffer.getBandByte(1).set(r, c, (Object)((byte)awtColor.getGreen()));
                buffer.getBandByte(2).set(r, c, (Object)((byte)awtColor.getBlue()));
            }
        }
        return buffer;
    }

    public String getTypeName(int type) {
        DataTypesManager dtManager = ToolsLocator.getDataTypesManager();
        String[] names = new String[]{dtManager.getTypeName(2), "UShort", "Short", dtManager.getTypeName(4), dtManager.getTypeName(6), dtManager.getTypeName(7)};
        if (type <= 5) {
            return names[type];
        }
        if (type == 32) {
            return "Undefined";
        }
        return "Unknow";
    }

    public String getBufferTypeName(int dataType) {
        switch (dataType) {
            case 0: {
                return "Byte";
            }
            case 1: {
                return "Unsigned short";
            }
            case 2: {
                return "Short";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Double";
            }
        }
        throw new IllegalArgumentException();
    }

    public Object coerce(int dataType, Object value) throws CoercionException {
        CoerceToInt coercion = null;
        switch (dataType) {
            case 0: {
                coercion = new CoerceToInt();
                return new Integer(Math.abs(0xFF & (Integer)coercion.coerce(value))).byteValue();
            }
            case 1: 
            case 2: {
                coercion = new CoerceToInt();
                return 0xFFFF & (Integer)coercion.coerce(value);
            }
            case 3: {
                coercion = new CoerceToInt();
                return coercion.coerce(value);
            }
            case 4: {
                coercion = new CoerceToFloat();
                return coercion.coerce(value);
            }
            case 5: {
                coercion = new CoerceToDouble();
                return coercion.coerce(value);
            }
        }
        throw new IllegalArgumentException("Unknow data type.");
    }

    public BufferDimensions createBufferDimensions(int rows, int columns, Envelope envelope) {
        return new DefaultBufferDimensions(rows, columns, envelope);
    }

    public File getLastFolderUsedToSaveRaster() {
        return this.lastFolderUsedToSave;
    }

    public void setLastFolderUsedToSaveRaster(File folder) {
        this.lastFolderUsedToSave = folder;
    }

    public Operation createOperation(String name) {
        OperationFactory factory = this.getOperationFactory(name);
        return factory.create();
    }

    public DynObject createOperationParameters(String name) {
        OperationFactory factory = this.getOperationFactory(name);
        return factory.createParameters();
    }

    public void registerOperationFactory(OperationFactory factory) {
        factory.getName();
        this.operationFactoriesRegister.put(factory.getName(), factory);
    }

    public List<OperationFactory> getOperationFactories() {
        return new ArrayList<OperationFactory>(this.operationFactoriesRegister.values());
    }

    public OperationFactory getOperationFactory(String name) {
        return this.operationFactoriesRegister.get(name);
    }

    public Buffer execute(SimpleTaskStatus status, String name, Buffer buffer, DynObject parameters) throws BufferOperationException {
        OperationFactory factory = this.getOperationFactory(name);
        Operation operation = factory.create();
        return operation.execute(status, buffer, parameters);
    }

    public Kernel createKernel(double[][] k) {
        return new DefaultKernel(k);
    }

    public Kernel createKernel(double[][] k, double divisor) {
        return new DefaultKernel(k, divisor);
    }

    public OperationListEntry createOperationListEntry(Operation operation, DynObject parameters) {
        return new DefaultOperationListEntry(operation, parameters);
    }

    public OperationList createOperationList() {
        return new DefaultOperationList();
    }

    public Buffer createBufferFromAwtRaster(Raster raster, IProjection projection, Envelope envelope) throws IOException, BufferException {
        List<PageManager> pageManagers = this.createAwtRasterBandPageManagerList(raster);
        int[] dataTypes = new int[raster.getNumBands()];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = this.getBufferTypeFromAwtRaster(raster);
        }
        return this.createBuffer(raster.getHeight(), raster.getWidth(), dataTypes, null, projection, envelope, pageManagers);
    }
}

