/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;

public class SimpleBandPageManager
extends AbstractDisposable
implements BandPageManager {
    private RandomAccessFile raf;
    private int rows;
    private int columns;
    private int dataType;
    private File file;

    public SimpleBandPageManager(File file, int rows, int columns, int dataType) throws IOException {
        this.rows = rows;
        this.columns = columns;
        this.dataType = dataType;
        this.file = file;
        if (this.file == null) {
            this.file = File.createTempFile("bandPageManager", "tmp");
        }
        this.raf = new RandomAccessFile(this.file, "rw");
        BufferManager bufferManager = BufferLocator.getBufferManager();
        this.raf.setLength(rows * columns * bufferManager.getDataTypeSize(dataType));
    }

    public void load(Buffer buffer, int row, int rows, int dataType) throws IOException {
        int pos = row * this.columns;
        this.raf.seek(pos);
        BufferManager bufferManager = BufferLocator.getBufferManager();
        int dataTypeSize = bufferManager.getDataTypeSize(dataType);
        byte[] byteArray = new byte[buffer.capacity() * dataTypeSize];
        this.raf.read(byteArray);
        buffer.rewind();
        switch (dataType) {
            case 0: {
                ((ByteBuffer)buffer).put(byteArray, 0, byteArray.length);
                break;
            }
            case 1: 
            case 2: {
                for (int cell = 0; cell < byteArray.length; ++cell) {
                    ((ShortBuffer)buffer).put(cell / dataTypeSize, byteArray[cell]);
                }
                break;
            }
            case 3: {
                for (int cell = 0; cell < byteArray.length; ++cell) {
                    ((IntBuffer)buffer).put(cell / dataTypeSize, byteArray[cell]);
                }
                break;
            }
            case 4: {
                for (int cell = 0; cell < byteArray.length; ++cell) {
                    ((FloatBuffer)buffer).put(cell / dataTypeSize, byteArray[cell]);
                }
                break;
            }
            case 5: {
                for (int cell = 0; cell < byteArray.length; ++cell) {
                    ((DoubleBuffer)buffer).put(cell / dataTypeSize, byteArray[cell]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data Type " + dataType + " not supported.");
            }
        }
    }

    public void save(Buffer buffer, int row, int rows, int dataType) throws IOException {
        int pos = row * this.columns;
        this.raf.seek(pos);
        BufferManager bufferManager = BufferLocator.getBufferManager();
        ByteBuffer byteBuffer = ByteBuffer.allocate(buffer.capacity() * bufferManager.getDataTypeSize(dataType));
        switch (dataType) {
            case 0: {
                byteBuffer.put(((ByteBuffer)buffer).array());
                break;
            }
            case 1: 
            case 2: {
                ShortBuffer byteAsShortBuffer = byteBuffer.asShortBuffer();
                byteAsShortBuffer.put((short[])buffer.array());
                break;
            }
            case 3: {
                IntBuffer byteAsIntBuffer = byteBuffer.asIntBuffer();
                byteAsIntBuffer.put((int[])buffer.array());
                break;
            }
            case 4: {
                FloatBuffer byteAsFloatBuffer = byteBuffer.asFloatBuffer();
                byteAsFloatBuffer.put((float[])buffer.array());
                break;
            }
            case 5: {
                DoubleBuffer byteAsDoubleBuffer = byteBuffer.asDoubleBuffer();
                byteAsDoubleBuffer.put((double[])buffer.array());
                break;
            }
            default: {
                throw new IllegalArgumentException("Data Type " + dataType + " not supported.");
            }
        }
        this.raf.write(byteBuffer.array());
    }

    public boolean isSupportedSave() {
        return true;
    }

    public BandInfo getBandInfo() {
        return null;
    }

    protected void doDispose() throws BaseException {
        this.raf = null;
        this.file = null;
    }
}

