/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.h2spatial;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionPanel;
import org.gvsig.h2spatial.H2SpatialExtension;
import org.gvsig.h2spatial.ImportTableView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class ImportTable
extends ImportTableView {
    private static final long serialVersionUID = 3084071737749916812L;
    private File file = null;

    public ImportTable() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblConnection);
        toolsSwingManager.translate(this.lblFileType);
        toolsSwingManager.translate(this.lblFile);
        toolsSwingManager.translate(this.lblTableName);
        toolsSwingManager.translate(this.lblDeleteTables);
        this.loadConnectionCombo(this.cboConnection, null);
        this.btnConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.doConnectionExplore();
            }
        });
        this.cboFileType.removeAllItems();
        this.cboFileType.addItem("GPX");
        this.cboFileType.addItem("GeoJSon");
        this.cboFileType.addItem("OSM");
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.doFileExplore();
            }
        });
    }

    public JDBCServerExplorerParameters getExplorerParameters() {
        ListElement item = (ListElement)this.cboConnection.getSelectedItem();
        if (item == null) {
            return null;
        }
        return (JDBCServerExplorerParameters)item.getValue();
    }

    public String getFileType() {
        return (String)this.cboFileType.getSelectedItem();
    }

    public File getFile() {
        return this.file;
    }

    public String getTableName() {
        String s = this.txtTableName.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            if (this.file == null) {
                return null;
            }
            return FilenameUtils.getBaseName((String)this.file.getName());
        }
        return s.trim();
    }

    public boolean getDeleteTables() {
        return this.chkDeleteTables.isSelected();
    }

    private void loadConnectionCombo(JComboBox combo, String selected) {
        combo.removeAllItems();
        combo.addItem("");
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool explorersPool = dataManager.getDataServerExplorerPool();
        for (DataServerExplorerPoolEntry entry : explorersPool) {
            if (!(entry.getExplorerParameters() instanceof JDBCServerExplorerParameters)) continue;
            ListElement item = new ListElement(entry.getName(), (Object)entry.getExplorerParameters());
            combo.addItem(item);
            if (!StringUtils.equalsIgnoreCase((CharSequence)selected, (CharSequence)item.toString())) continue;
            combo.setSelectedItem(item);
        }
    }

    private void doConnectionExplore() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final JDBCConnectionPanel jdbcServerExplorer = DALSwingLocator.getSwingManager().createJDBCConnectionPanel();
        jdbcServerExplorer.setConnectorFilter(new JDBCConnectionPanel.ConnectorFilter(){

            public boolean accept(JDBCServerExplorerParameters parameters) {
                return StringUtils.equalsIgnoreCase((CharSequence)parameters.getExplorerName(), (CharSequence)H2SpatialExtension.DAL_EXPLORER_NAME);
            }
        });
        final Dialog dlg = winmanager.createDialog(jdbcServerExplorer.asJComponent(), i18n.getTranslation("_Import_file_in_H2_database"), i18n.getTranslation("_Import_a_Gpx_Geojson_or_OSM_as_tables_in_a_H2_database"), 3);
        dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dlg.getAction() == 1) {
                    ImportTable.this.loadConnectionCombo(ImportTable.this.cboConnection, jdbcServerExplorer.getConnectionName());
                }
            }
        });
        dlg.show(WindowManager.MODE.WINDOW);
    }

    private void doFileExplore() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        Object[] files = dialogs.showChooserDialog(i18n.getTranslation("_Select_the_file_to_import"), 0, 0, false, foldersManager.get("DataFolder"), new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return FilenameUtils.isExtension((String)f.getName().toLowerCase(), (String[])new String[]{"gpx", "geojson", "osm"});
            }

            @Override
            public String getDescription() {
                return "GPX, GeoJSon and OSM files";
            }
        }, false);
        if (!ArrayUtils.isEmpty((Object[])files)) {
            this.file = files[0];
            this.txtFile.setText(this.file.getAbsolutePath());
            if (StringUtils.isEmpty((CharSequence)this.txtTableName.getText())) {
                this.txtTableName.setText(FilenameUtils.getBaseName((String)this.file.getName()));
            }
        }
    }
}

