/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.h2spatial;

import java.util.ArrayList;
import javax.swing.JComboBox;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParametersBase;
import org.gvsig.h2spatial.ShutdownCompactView;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownCompact
extends ShutdownCompactView {
    private static Logger LOGGER = LoggerFactory.getLogger(ShutdownCompact.class);

    public ShutdownCompact() {
        this.initComponents();
    }

    private void initComponents() {
        this.fillConnections(this.cboCconnections);
    }

    private void fillConnections(JComboBox combo) {
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        combo.removeAllItems();
        ArrayList entries = new ArrayList();
        pool.iterator().forEachRemaining(e -> entries.add(e));
        entries.sort((o1, o2) -> StringUtils.compare((String)o1.getName(), (String)o2.getName()));
        for (DataServerExplorerPoolEntry entry : entries) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"H2Spatial", (CharSequence)entry.getExplorerParameters().getProviderName())) continue;
            JDBCServerExplorerParametersBase dbParams = (JDBCServerExplorerParametersBase)entry.getExplorerParameters();
            combo.addItem(new LabeledValueImpl(entry.getName(), (Object)dbParams));
        }
        combo.setSelectedIndex(-1);
    }

    public void shutdownAndCompact() {
        LabeledValue value = (LabeledValue)this.cboCconnections.getSelectedItem();
        if (value == null) {
            return;
        }
        try {
            DataManager dataManager = DALLocator.getManager();
            JDBCServerExplorer server = (JDBCServerExplorer)dataManager.openServerExplorer("H2Spatial", (DataServerExplorerParameters)value.getValue());
            server.execute("!SHUTDOWN");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't shutdown/compact database", (Throwable)ex);
        }
    }
}

