CREATE CACHED TABLE EPSG_ALIAS(ALIAS_CODE INTEGER NOT NULL,OBJECT_TABLE_NAME VARCHAR(80) NOT NULL,OBJECT_CODE INTEGER NOT NULL,NAMING_SYSTEM_CODE INTEGER NOT NULL,ALIAS VARCHAR(80) NOT NULL,REMARKS VARCHAR(254),CONSTRAINT PK_ALIAS PRIMARY KEY(ALIAS_CODE))
CREATE CACHED TABLE EPSG_AREA(AREA_CODE INTEGER NOT NULL,AREA_NAME VARCHAR(80) NOT NULL,AREA_OF_USE VARCHAR NOT NULL,AREA_SOUTH_BOUND_LAT DOUBLE,AREA_NORTH_BOUND_LAT DOUBLE,AREA_WEST_BOUND_LON DOUBLE,AREA_EAST_BOUND_LON DOUBLE,AREA_POLYGON_FILE_REF VARCHAR(254),ISO_A2_CODE VARCHAR(2),ISO_A3_CODE VARCHAR(3),ISO_N_CODE INTEGER,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_AREA PRIMARY KEY(AREA_CODE))
CREATE CACHED TABLE EPSG_CHANGE(CHANGE_ID DOUBLE NOT NULL,REPORT_DATE DATE NOT NULL,DATE_CLOSED DATE,REPORTER VARCHAR(254) NOT NULL,REQUEST VARCHAR(254) NOT NULL,TABLES_AFFECTED VARCHAR(254),CODES_AFFECTED VARCHAR(254),CHANGE_COMMENT VARCHAR(254),ACTION VARCHAR,CONSTRAINT UN_CHANGE_ID UNIQUE(CHANGE_ID))
CREATE CACHED TABLE EPSG_COORDINATEAXIS(COORD_AXIS_CODE INTEGER NOT NULL,COORD_SYS_CODE INTEGER NOT NULL,COORD_AXIS_NAME_CODE INTEGER NOT NULL,COORD_AXIS_ORIENTATION VARCHAR(24) NOT NULL,COORD_AXIS_ABBREVIATION VARCHAR(24) NOT NULL,UOM_CODE INTEGER NOT NULL,COORD_AXIS_ORDER SMALLINT NOT NULL,CONSTRAINT PK_COORDINATEAXIS PRIMARY KEY(COORD_SYS_CODE,COORD_AXIS_NAME_CODE),CONSTRAINT UN_COORD_AXIS_CODE UNIQUE(COORD_AXIS_CODE))
CREATE CACHED TABLE EPSG_COORDINATEAXISNAME(COORD_AXIS_NAME_CODE INTEGER NOT NULL,COORD_AXIS_NAME VARCHAR(80) NOT NULL,DESCRIPTION VARCHAR(254),REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDINATEAXISNAME PRIMARY KEY(COORD_AXIS_NAME_CODE))
CREATE CACHED TABLE EPSG_COORDINATEREFERENCESYSTEM(COORD_REF_SYS_CODE INTEGER NOT NULL,COORD_REF_SYS_NAME VARCHAR(80) NOT NULL,AREA_OF_USE_CODE INTEGER NOT NULL,COORD_REF_SYS_KIND VARCHAR(24) NOT NULL,COORD_SYS_CODE INTEGER,DATUM_CODE INTEGER,SOURCE_GEOGCRS_CODE INTEGER,PROJECTION_CONV_CODE INTEGER,CMPD_HORIZCRS_CODE INTEGER,CMPD_VERTCRS_CODE INTEGER,CRS_SCOPE VARCHAR(254) NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),SHOW_CRS SMALLINT NOT NULL,DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDINATEREFERENCESYSTEM PRIMARY KEY(COORD_REF_SYS_CODE))
CREATE CACHED TABLE EPSG_COORDINATESYSTEM(COORD_SYS_CODE INTEGER NOT NULL,COORD_SYS_NAME VARCHAR(254) NOT NULL,COORD_SYS_TYPE VARCHAR(24) NOT NULL,DIMENSION SMALLINT NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(50) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDINATESYSTEM PRIMARY KEY(COORD_SYS_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATION(COORD_OP_CODE INTEGER NOT NULL,COORD_OP_NAME VARCHAR(80) NOT NULL,COORD_OP_TYPE VARCHAR(24) NOT NULL,SOURCE_CRS_CODE INTEGER,TARGET_CRS_CODE INTEGER,COORD_TFM_VERSION VARCHAR(24),COORD_OP_VARIANT SMALLINT,AREA_OF_USE_CODE INTEGER NOT NULL,COORD_OP_SCOPE VARCHAR(254) NOT NULL,COORD_OP_ACCURACY FLOAT,COORD_OP_METHOD_CODE INTEGER,UOM_CODE_SOURCE_COORD_DIFF INTEGER,UOM_CODE_TARGET_COORD_DIFF INTEGER,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),SHOW_OPERATION SMALLINT NOT NULL,DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATION PRIMARY KEY(COORD_OP_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONMETHOD(COORD_OP_METHOD_CODE INTEGER NOT NULL,COORD_OP_METHOD_NAME VARCHAR(50) NOT NULL,REVERSE_OP SMALLINT NOT NULL,FORMULA VARCHAR,EXAMPLE VARCHAR,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATIONMETHOD PRIMARY KEY(COORD_OP_METHOD_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPARAM(PARAMETER_CODE INTEGER NOT NULL,PARAMETER_NAME VARCHAR(80) NOT NULL,DESCRIPTION VARCHAR,INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATIONPARAM PRIMARY KEY(PARAMETER_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPARAMUSAGE(COORD_OP_METHOD_CODE INTEGER NOT NULL,PARAMETER_CODE INTEGER NOT NULL,SORT_ORDER SMALLINT NOT NULL,PARAM_SIGN_REVERSAL VARCHAR(3),CONSTRAINT PK_COORDOPERATIONPARAMUSAGE PRIMARY KEY(PARAMETER_CODE,COORD_OP_METHOD_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPARAMVALUE(COORD_OP_CODE INTEGER NOT NULL,COORD_OP_METHOD_CODE INTEGER NOT NULL,PARAMETER_CODE INTEGER NOT NULL,PARAMETER_VALUE DOUBLE,PARAM_VALUE_FILE_REF VARCHAR(254),UOM_CODE INTEGER,CONSTRAINT PK_COORDOPERATIONPARAMVALUE PRIMARY KEY(COORD_OP_CODE,PARAMETER_CODE,COORD_OP_METHOD_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPATH(CONCAT_OPERATION_CODE INTEGER NOT NULL,SINGLE_OPERATION_CODE INTEGER NOT NULL,OP_PATH_STEP SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATIONPATH PRIMARY KEY(CONCAT_OPERATION_CODE,SINGLE_OPERATION_CODE))
CREATE CACHED TABLE EPSG_DATUM(DATUM_CODE INTEGER NOT NULL,DATUM_NAME VARCHAR(80) NOT NULL,DATUM_TYPE VARCHAR(24) NOT NULL,ORIGIN_DESCRIPTION VARCHAR(254),REALIZATION_EPOCH VARCHAR(4),ELLIPSOID_CODE INTEGER,PRIME_MERIDIAN_CODE INTEGER,AREA_OF_USE_CODE INTEGER NOT NULL,DATUM_SCOPE VARCHAR(254) NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_DATUM PRIMARY KEY(DATUM_CODE))
CREATE CACHED TABLE EPSG_DEPRECATION(DEPRECATION_ID INTEGER NOT NULL,DEPRECATION_DATE DATE,CHANGE_ID DOUBLE NOT NULL,OBJECT_TABLE_NAME VARCHAR(80),OBJECT_CODE INTEGER,REPLACED_BY INTEGER,DEPRECATION_REASON VARCHAR(254),CONSTRAINT PK_DEPRECATION PRIMARY KEY(DEPRECATION_ID))
CREATE CACHED TABLE EPSG_ELLIPSOID(ELLIPSOID_CODE INTEGER NOT NULL,ELLIPSOID_NAME VARCHAR(80) NOT NULL,SEMI_MAJOR_AXIS DOUBLE NOT NULL,UOM_CODE INTEGER NOT NULL,INV_FLATTENING DOUBLE,SEMI_MINOR_AXIS DOUBLE,ELLIPSOID_SHAPE SMALLINT NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_ELLIPSOID PRIMARY KEY(ELLIPSOID_CODE))
CREATE CACHED TABLE EPSG_NAMINGSYSTEM(NAMING_SYSTEM_CODE INTEGER NOT NULL,NAMING_SYSTEM_NAME VARCHAR(80) NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_NAMINGSYSTEM PRIMARY KEY(NAMING_SYSTEM_CODE))
CREATE CACHED TABLE EPSG_PRIMEMERIDIAN(PRIME_MERIDIAN_CODE INTEGER NOT NULL,PRIME_MERIDIAN_NAME VARCHAR(80) NOT NULL,GREENWICH_LONGITUDE DOUBLE NOT NULL,UOM_CODE INTEGER NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_PRIMEMERIDIAN PRIMARY KEY(PRIME_MERIDIAN_CODE))
CREATE CACHED TABLE EPSG_SUPERSESSION(SUPERSESSION_ID INTEGER NOT NULL,OBJECT_TABLE_NAME VARCHAR(80) NOT NULL,OBJECT_CODE INTEGER NOT NULL,SUPERSEDED_BY INTEGER,SUPERSESSION_TYPE VARCHAR(50),SUPERSESSION_YEAR SMALLINT,REMARKS VARCHAR(254),CONSTRAINT PK_SUPERSESSION PRIMARY KEY(SUPERSESSION_ID))
CREATE CACHED TABLE EPSG_UNITOFMEASURE(UOM_CODE INTEGER NOT NULL,UNIT_OF_MEAS_NAME VARCHAR(80) NOT NULL,UNIT_OF_MEAS_TYPE VARCHAR(50),TARGET_UOM_CODE INTEGER NOT NULL,FACTOR_B DOUBLE,FACTOR_C DOUBLE,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(255),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_UNITOFMEASURE PRIMARY KEY(UOM_CODE))
CREATE CACHED TABLE EPSG_VERSIONHISTORY(VERSION_HISTORY_CODE INTEGER NOT NULL,VERSION_DATE DATE,VERSION_NUMBER VARCHAR(10) NOT NULL,VERSION_REMARKS VARCHAR(254) NOT NULL,SUPERCEDED_BY VARCHAR(10),SUPERCEDES VARCHAR(10),CONSTRAINT PK_VERSIONHISTORY PRIMARY KEY(VERSION_HISTORY_CODE),CONSTRAINT UN_VERSION_HISTORY_CODE UNIQUE(VERSION_HISTORY_CODE))
INSERT INTO EPSG_ALIAS VALUES
(4,'Datum',6258,7300,'ETRF89',''),
(5,'Ellipsoid',7013,7300,'Modified Clarke 1880 (South Africa)','The Clarke 1880 (Arc) figure is one of several modifications to the original definition. The name Clarke Modified is usually taken to be the RGS modification. But in southern Africa it is usually taken to be the Arc or Cape modification.'),
(6,'Coordinate_Operation',8570,7300,'ED50 to EUREF89 (2)',''),
(7,'Unit of Measure',9001,7300,'meter',''),
(8,'Unit of Measure',9036,7300,'kilometer','Spelling used in US'),
(9,'Coordinate Reference System',21100,7300,'Genuk / NEIEZ',''),
(10,'Coordinate_Operation',1036,7301,'OSTN97',''),
(11,'Coordinate_Operation',1123,7301,'Genuk to WGS 84 (1)',''),
(12,'Coordinate_Operation',1149,7301,'ETRF89 to WGS 84 (1)',''),
(13,'Coordinate_Operation',1273,7301,'HD72 to ETRF89 (1)',''),
(14,'Coordinate_Operation',1309,7301,'DHDN to ETRF89 (1)',''),
(15,'Coordinate_Operation',1310,7301,'Pulkovo 1942 to ETRF89 (1)',''),
(16,'Coordinate_Operation',1311,7301,'ED50 to WGS 84 (Common Offshore)',''),
(17,'Coordinate_Operation',1331,7301,'EST92 to ETRF89 (1)',''),
(19,'Coordinate_Operation',1513,7301,'Final Datum 1958 to WGS 84 (1)',''),
(20,'Coordinate_Operation',1571,7301,'Amersfoort to ETRF89 (1)',''),
(21,'Coordinate_Operation',1584,7301,'Levant to WGS 72BE (1)',''),
(22,'Coordinate_Operation',1585,7301,'Levant to WGS 84 (2)',''),
(23,'Coordinate_Operation',1586,7301,'Levant to WGS 84 (3)',''),
(24,'Coordinate_Operation',1587,7301,'Levant to WGS 84 (4)',''),
(26,'Coordinate_Operation',1589,7301,'ED50 to ETRF89 (3)',''),
(28,'Coordinate_Operation',1611,7301,'IRENET95 to ETRF89 (1)',''),
(29,'Coordinate Reference System',2140,7301,'NAD83(CSRS98) / SCoPQ zone 3',''),
(30,'Coordinate Reference System',2141,7301,'NAD83(CSRS98) / SCoPQ zone 4',''),
(31,'Coordinate Reference System',2142,7301,'NAD83(CSRS98) / SCoPQ zone 5',''),
(32,'Coordinate Reference System',2143,7301,'NAD83(CSRS98) / SCoPQ zone 6',''),
(33,'Coordinate Reference System',2144,7301,'NAD83(CSRS98) / SCoPQ zone 7',''),
(34,'Coordinate Reference System',2145,7301,'NAD83(CSRS98) / SCoPQ zone 8',''),
(35,'Coordinate Reference System',2146,7301,'NAD83(CSRS98) / SCoPQ zone 9',''),
(36,'Coordinate Reference System',2147,7301,'NAD83(CSRS98) / SCoPQ zone 10',''),
(37,'Coordinate Reference System',2159,7301,'Sierra Leone 1924 / Peninsular Grid',''),
(38,'Coordinate Reference System',2291,7301,'NAD83 / PEI Stereo',''),
(39,'Coordinate Reference System',3200,7301,'Final Datum 1958 / Iraq zone',''),
(40,'Coordinate Reference System',4132,7301,'Final Datum 1958 (Iran)',''),
(41,'Coordinate Reference System',4140,7301,'NAD83(CSRS)',''),
(42,'Coordinate Reference System',4172,7301,'National Geodetic System [Argentina]','see http://www.igm.gov.ar/posgar.html'),
(43,'Coordinate Reference System',4211,7301,'Genuk',''),
(44,'Coordinate Reference System',4218,7301,'Bogota',''),
(45,'Coordinate Reference System',4227,7301,'Levant',''),
(46,'Coordinate Reference System',4258,7301,'ETRF89',''),
(47,'Coordinate Reference System',4272,7301,'GD49',''),
(48,'Coordinate Reference System',4813,7301,'Genuk (Jakarta)',''),
(49,'Datum',5104,7301,'Huang Hai 1956',''),
(51,'Datum',6125,7301,'Samboja P2 exc T9',''),
(52,'Datum',6160,7301,'Quini-Huao',''),
(53,'Datum',6174,7301,'Sierra Leone Peninsular 1924',''),
(54,'Datum',6211,7301,'Genuk',''),
(55,'Datum',6218,7301,'Bogota',''),
(56,'Datum',6222,7301,'South Africa',''),
(57,'Datum',6227,7301,'Levant',''),
(58,'Datum',6258,7301,'European Terrestrial Reference Frame 1989',''),
(59,'Datum',6269,7301,'NAD83 (1986)',''),
(60,'Datum',6272,7301,'GD49',''),
(61,'Datum',6308,7301,'Rikets koordinatsystem 1938',''),
(62,'Ellipsoid',7012,7301,'Clarke Modified 1880','The Clarke 1880 (RGS) figure is one of several modifications to the original definition. The name Clarke Modified is usually taken to be the RGS modification.'),
(63,'Ellipsoid',7013,7301,'Clarke 1880 (Cape)',''),
(64,'Ellipsoid',7019,7301,'International 1979','Adopted by IUGG 1979 Canberra as the Geodetic Reference Spheroid of 1980 (GRS 1980).'),
(65,'Ellipsoid',7022,7301,'Hayford 1909','Described as a=6378388 m. and b=6356909 m. from which 1/f derived to be 296.95926... The figure was adopted as the International ellipsoid in 1924 but with 1/f taken as 297 exactly from which b is derved as 6356911.946 m.'),
(66,'Ellipsoid',7029,7301,'McCaw 1924',''),
(67,'Ellipsoid',7030,7301,'WGS84',''),
(68,'Ellipsoid',7036,7301,'International 1967','More usually known as GRS 1967 to avoid confusion with the International 1924 figure.'),
(69,'Ellipsoid',7043,7301,'NWL 10D','Used by Transit Broadcast Ephemeris before 1989. Also referred to as WGS72 spheroid.'),
(70,'Coordinate_Operation',8568,7301,'Levant to WGS 84 (1)',''),
(71,'Coordinate_Operation',8570,7301,'ED50 to ETRF89 (2)',''),
(72,'Coordinate_Operation Parameter',8602,7301,'Longitude rotation',''),
(73,'Prime Meridian',8913,7301,'Kristiania',''),
(74,'Unit of Measure',9001,7301,'International metre',''),
(75,'Unit of Measure',9002,7301,'international foot',''),
(76,'Unit of Measure',9003,7301,'American foot',''),
(77,'Unit of Measure',9005,7301,'South African geodetic foot','Not to be confused with the Cape foot.'),
(78,'Unit of Measure',9030,1040,'International nautical mile',''),
(79,'Unit of Measure',9039,7301,'link (Clarke''s ratio)',''),
(80,'Unit of Measure',9040,7301,'yard',''),
(81,'Unit of Measure',9041,7301,'foot',''),
(82,'Unit of Measure',9042,7301,'chain',''),
(83,'Unit of Measure',9043,7301,'link',''),
(84,'Unit of Measure',9050,7301,'yard',''),
(85,'Unit of Measure',9051,7301,'foot',''),
(86,'Unit of Measure',9052,7301,'chain',''),
(87,'Unit of Measure',9053,7301,'link',''),
(88,'Unit of Measure',9060,7301,'yard',''),
(89,'Unit of Measure',9061,7301,'foot',''),
(90,'Unit of Measure',9062,7301,'chain',''),
(91,'Unit of Measure',9063,7301,'link',''),
(92,'Unit of Measure',9070,7301,'foot',''),
(93,'Unit of Measure',9080,7301,'Indian geodetic foot',''),
(94,'Unit of Measure',9081,7301,'Indian geodetic foot',''),
(95,'Unit of Measure',9084,7301,'yard','= 3 Indian feet.'),
(96,'Unit of Measure',9085,7301,'yard','= 3 Indian feet.'),
(97,'Unit of Measure',9094,7301,'foot',''),
(98,'Unit of Measure',9114,7317,'mil','Alias also applies to other variations of a mil, especially mil_6300 and mil_6000.'),
(100,'Coordinate_Operation',17001,7301,'Ghana TM',''),
(101,'Coordinate_Operation',17901,7301,'Mount Eden Circuit 1949',''),
(102,'Coordinate_Operation',17902,7301,'Bay of Plenty Circuit 1949',''),
(103,'Coordinate_Operation',17903,7301,'Poverty Bay Circuit 1949',''),
(104,'Coordinate_Operation',17904,7301,'Hawkes Bay Circuit 1949',''),
(105,'Coordinate_Operation',17905,7301,'Taranaki Circuit 1949',''),
(106,'Coordinate_Operation',17906,7301,'Tuhirangi Circuit 1949',''),
(107,'Coordinate_Operation',17907,7301,'Wanganui Circuit 1949',''),
(108,'Coordinate_Operation',17908,7301,'Wairarapa Circuit 1949',''),
(109,'Coordinate_Operation',17909,7301,'Wellington Circuit 1949',''),
(110,'Coordinate_Operation',17910,7301,'Collingwood Circuit 1949',''),
(111,'Coordinate_Operation',17911,7301,'Nelson Circuit 1949',''),
(112,'Coordinate_Operation',17912,7301,'Karamea Circuit 1949',''),
(113,'Coordinate_Operation',17913,7301,'Buller Circuit 1949',''),
(114,'Coordinate_Operation',17914,7301,'Grey Circuit 1949',''),
(115,'Coordinate_Operation',17915,7301,'Amuri Circuit 1949',''),
(116,'Coordinate_Operation',17916,7301,'Marlborough Circuit 1949',''),
(117,'Coordinate_Operation',17917,7301,'Hokitika Circuit 1949',''),
(118,'Coordinate_Operation',17918,7301,'Okarito Circuit 1949',''),
(119,'Coordinate_Operation',17919,7301,'Jacksons Bay Circuit 1949',''),
(120,'Coordinate_Operation',17920,7301,'Mount Pleasant Circuit 1949',''),
(121,'Coordinate_Operation',17921,7301,'Gawler Circuit 1949',''),
(122,'Coordinate_Operation',17922,7301,'Timaru Circuit 1949',''),
(123,'Coordinate_Operation',17923,7301,'Lindis Peak Circuit 1949',''),
(124,'Coordinate_Operation',17924,7301,'Mount Nicholas Circuit 1949',''),
(125,'Coordinate_Operation',17925,7301,'Mount York Circuit 1949',''),
(126,'Coordinate_Operation',17926,7301,'Observation Point Circuit 1949',''),
(127,'Coordinate_Operation',17927,7301,'North Taieri Circuit 1949',''),
(128,'Coordinate_Operation',17928,7301,'Bluff Circuit 1949',''),
(129,'Coordinate_Operation',19906,7301,'IOEPC Lambert','Sometimes seen defined with 2 standard parallels.'),
(130,'Coordinate_Operation',19959,7301,'Gold Coast Grid',''),
(131,'Coordinate_Operation',19963,7301,'Sierra Leone Peninsula Grid',''),
(132,'Coordinate Reference System',21100,7301,'Genuk (Jakarta) / NEIEZ',''),
(133,'Coordinate Reference System',21148,7301,'Genuk / UTM zone 48S',''),
(134,'Coordinate Reference System',21150,7301,'Genuk / UTM zone 50S',''),
(135,'Coordinate Reference System',22700,7301,'Levant / Levant Zone',''),
(136,'Coordinate Reference System',22770,7301,'Levant / Syria Lambert',''),
(137,'Coordinate Reference System',22780,7317,'Levant / Levant Stereo',''),
(138,'Coordinate Reference System',25828,7301,'ETRF89 / UTM zone 28N',''),
(139,'Coordinate Reference System',25829,7301,'ETRF89 / UTM zone 29N',''),
(140,'Coordinate Reference System',25830,7301,'ETRF89 / UTM zone 30N',''),
(141,'Coordinate Reference System',25831,7301,'ETRF89 / UTM zone 31N',''),
(142,'Coordinate Reference System',25832,7301,'ETRF89 / UTM zone 32N',''),
(143,'Coordinate Reference System',25833,7301,'ETRF89 / UTM zone 33N',''),
(144,'Coordinate Reference System',25834,7301,'ETRF89 / UTM zone 34N',''),
(145,'Coordinate Reference System',25835,7301,'ETRF89 / UTM zone 35N',''),
(146,'Coordinate Reference System',25836,7301,'ETRF89 / UTM zone 36N',''),
(147,'Coordinate Reference System',25837,7301,'ETRF89 / UTM zone 37N',''),
(148,'Coordinate Reference System',25838,7301,'ETRF89 / UTM zone 38N',''),
(149,'Coordinate Reference System',25884,7301,'ETRF89 / TM Baltic93',''),
(150,'Coordinate Reference System',27258,7301,'GD49 / UTM zone 58',''),
(151,'Coordinate Reference System',27259,7301,'GD49 / UTM zone 59',''),
(152,'Coordinate Reference System',27260,7301,'GD49 / UTM zone 60',''),
(153,'Coordinate Reference System',27291,7317,'GD49 / North Island Grid',''),
(154,'Coordinate Reference System',27292,7317,'GD49 / South Island Grid',''),
(156,'Coordinate Reference System',30791,7301,'Nord Sahara 1959 / Lambert Nord Voirol Unifie 1960','Voirol Unifie 1960 is NOT a geodetic datum nor GeogCRS. It is two Lambert projected coordinate reference systems based on Nord Sahara 1959 Datum. See also CRS code 30792.'),
(157,'Coordinate Reference System',30792,7301,'Nord Sahara 1959 / Lambert Sud Voirol Unifie 1960','Voirol Unifie 1960 is NOT a geodetic datum nor GeogCRS. It is two Lambert projected coordinate reference systems based on Nord Sahara 1959 Datum. See also CRS code 30791.'),
(158,'Coordinate Reference System',31170,7317,'Zanderij / Surinam Old','Old country name spelling.'),
(159,'Coordinate Reference System',31171,7301,'Zanderij / Surinam TM','Old spelling for country name.'),
(160,'Coordinate Reference System',31300,7317,'Belge Lambert 72',''),
(161,'Coordinate_Operation',1026,7302,'Madrid to ED50 (1)',''),
(162,'Coordinate_Operation',1027,7302,'Madrid to ED50 (2)',''),
(163,'Coordinate_Operation',1028,7302,'Madrid to ED50 (3)',''),
(164,'Coordinate_Operation',1029,7302,'RD New to ED50/UTM31 (1)',''),
(165,'Coordinate_Operation',1030,7302,'ED50/UTM31 to RD New (1)',''),
(166,'Coordinate_Operation',1031,7302,'RD New to ED50/UTM31 (2)',''),
(167,'Coordinate_Operation',1032,7302,'ED50/UTM31 to RD New (2)',''),
(170,'Coordinate Reference System',2000,7302,'Anguilla 1957 / BWI Grid',''),
(171,'Coordinate Reference System',2001,7302,'Antigua 1943 / BWI Grid',''),
(172,'Coordinate Reference System',2002,7302,'Dominica 1945 / BWI Grid',''),
(173,'Coordinate Reference System',2003,7302,'Grenada 1953 / BWI Grid',''),
(174,'Coordinate Reference System',2004,7302,'Montserrat 58 / BWI Grid',''),
(175,'Coordinate Reference System',2005,7302,'St Kitts 1955 / BWI Grid',''),
(176,'Coordinate Reference System',2006,7302,'St Lucia 1955 / BWI Grid',''),
(177,'Coordinate Reference System',2007,7302,'St Vincent 45 / BWI Grid',''),
(178,'Coordinate Reference System',2008,7302,'CGQ77 / SCoPQ zone 2',''),
(179,'Coordinate Reference System',2009,7302,'CGQ77 / SCoPQ zone 3',''),
(180,'Coordinate Reference System',2010,7302,'CGQ77 / SCoPQ zone 4',''),
(181,'Coordinate Reference System',2011,7302,'CGQ77 / SCoPQ zone 5',''),
(182,'Coordinate Reference System',2012,7302,'CGQ77 / SCoPQ zone 6',''),
(183,'Coordinate Reference System',2013,7302,'CGQ77 / SCoPQ zone 7',''),
(184,'Coordinate Reference System',2014,7302,'CGQ77 / SCoPQ zone 8',''),
(185,'Coordinate Reference System',2015,7302,'CGQ77 / SCoPQ zone 9',''),
(186,'Coordinate Reference System',2016,7302,'CGQ77 / SCoPQ zone 10',''),
(187,'Coordinate Reference System',2036,7302,'NAD83(CSRS) / NB Stereo',''),
(188,'Coordinate Reference System',2037,7302,'NAD83(CSRS) / UTM 19N',''),
(189,'Coordinate Reference System',2038,7302,'NAD83(CSRS) / UTM 20N',''),
(191,'Coordinate Reference System',2040,7302,'Locodjo 65 / UTM 30N',''),
(192,'Coordinate Reference System',2041,7302,'Abidjan 87 / UTM 30N',''),
(193,'Coordinate Reference System',2042,7302,'Locodjo 65 / UTM 29N',''),
(194,'Coordinate Reference System',2043,7302,'Abidjan 87 / UTM 29N',''),
(195,'Coordinate Reference System',2044,7302,'Hanoi 72 / Gauss zone 18',''),
(196,'Coordinate Reference System',2045,7302,'Hanoi 72 / Gauss zone 19',''),
(197,'Coordinate Reference System',2046,7301,'New S African CS zone 15',''),
(198,'Coordinate Reference System',2047,7301,'New S African CS zone 17',''),
(199,'Coordinate Reference System',2048,7301,'New S African CS zone 19',''),
(200,'Coordinate Reference System',2049,7301,'New S African CS zone 21',''),
(201,'Coordinate Reference System',2050,7301,'New S African CS zone 23',''),
(202,'Coordinate Reference System',2051,7301,'New S African CS zone 25',''),
(203,'Coordinate Reference System',2052,7301,'New S African CS zone 27',''),
(204,'Coordinate Reference System',2053,7301,'New S African CS zone 29',''),
(205,'Coordinate Reference System',2054,7301,'New S African CS zone 31',''),
(206,'Coordinate Reference System',2055,7301,'New S African CS zone 33',''),
(207,'Coordinate Reference System',2056,7302,'LV95',''),
(208,'Coordinate Reference System',2066,7302,'Mount Dillon / Tobago',''),
(209,'Coordinate Reference System',2067,7302,'Naparima 1955 / UTM 20N',''),
(210,'Coordinate Reference System',2081,7301,'Chos Malal 1914 / Argentina zone 2',''),
(212,'Coordinate Reference System',2083,7301,'Hito XVIII 1963 / Argentina zone 2',''),
(213,'Coordinate Reference System',2084,7302,'Hito XVIII / UTM 19S',''),
(214,'Coordinate Reference System',2089,7302,'Yemen NGN96 / UTM 38N',''),
(215,'Coordinate Reference System',2090,7302,'Yemen NGN96 / UTM 39N',''),
(216,'Coordinate Reference System',2091,7302,'S Yemen / Gauss zone 8',''),
(217,'Coordinate Reference System',2092,7302,'S Yemen / Gauss zone 9',''),
(219,'Coordinate Reference System',2097,7302,'Korean 1985 / Central',''),
(221,'Coordinate Reference System',2099,7301,'Qatar Plane CS',''),
(222,'Coordinate Reference System',2136,7301,'Accra / Gold Coast Grid',''),
(223,'Coordinate Reference System',2137,7301,'Accra / Ghana TM',''),
(224,'Coordinate Reference System',2157,7302,'IRENET95 / ITM',''),
(225,'Coordinate Reference System',2200,7302,'ATS77 / NB Stereographic',''),
(226,'Coordinate Reference System',2290,7302,'ATS77 / PEI Stereo',''),
(227,'Coordinate Reference System',2291,7302,'NAD83(CSRS) / PEI Stereo',''),
(228,'Coordinate Reference System',2294,7302,'ATS77 / MTM NS zone 4',''),
(229,'Coordinate Reference System',2295,7302,'ATS77 / MTM NS zone 5',''),
(230,'Coordinate Reference System',2393,7302,'KKJ / Finland zone 3',''),
(231,'Coordinate Reference System',2600,7302,'LKS94','This alias is also used for geographical and geocentric CRSs.'),
(232,'Coordinate Reference System',3561,7302,'Old Hawaiian / SP zone 1',''),
(233,'Coordinate Reference System',3562,7302,'Old Hawaiian / SP zone 2',''),
(234,'Coordinate Reference System',3563,7302,'Old Hawaiian / SP zone 3',''),
(235,'Coordinate Reference System',3564,7302,'Old Hawaiian / SP zone 4',''),
(236,'Coordinate Reference System',3565,7302,'Old Hawaiian / SP zone 5',''),
(237,'Coordinate Reference System',3991,7302,'Puerto Rico SPCS 27',''),
(238,'Coordinate Reference System',4134,7301,'PDO Survey Datum 1993',''),
(239,'Coordinate Reference System',4215,7302,'BD 50',''),
(240,'Coordinate Reference System',4268,7302,'NAD Michigan',''),
(241,'Coordinate Reference System',4313,7302,'BD 72',''),
(242,'Coordinate Reference System',4609,7302,'CGQ77',''),
(243,'Coordinate Reference System',4809,7302,'BD 50 (Brussels)',''),
(244,'Datum',5100,7302,'MSL',''),
(245,'Datum',5101,7302,'ODN',''),
(246,'Datum',5102,7302,'NGVD29',''),
(247,'Datum',5103,7302,'NAVD88',''),
(248,'Datum',5104,7302,'Yellow Sea',''),
(249,'Datum',5105,7302,'Baltic',''),
(250,'Datum',5106,7302,'Caspian',''),
(251,'Datum',5107,7302,'NGF',''),
(252,'Datum',5109,7302,'NAP',''),
(253,'Datum',5111,7302,'AHD',''),
(254,'Datum',5112,7302,'AHD (Tasmania)',''),
(255,'Datum',5114,7301,'CVD28',''),
(256,'Datum',5115,7302,'Piraeus86',''),
(257,'Datum',5116,7302,'N60',''),
(258,'Datum',5117,7302,'RH70',''),
(259,'Datum',5118,7302,'NGF - Lallemand',''),
(260,'Datum',5119,7302,'NGF-IGN69',''),
(261,'Datum',5120,7302,'NGF-IGN78',''),
(262,'Datum',5122,7302,'JSLD69',''),
(263,'Datum',5123,7302,'PHD93',''),
(264,'Datum',5127,7302,'LN02',''),
(265,'Datum',5128,7302,'LHN95',''),
(266,'Datum',5129,7302,'EVRF2000',''),
(267,'Coordinate Reference System',5701,7301,'Newlyn height',''),
(268,'Coordinate Reference System',5702,7301,'National Geodetic Vertical Datum of 1929 height (ftUS)',''),
(269,'Coordinate Reference System',5703,7301,'North American Vertical Datum of 1988 height (m)',''),
(270,'Coordinate Reference System',5709,7301,'Normaal Amsterdams Peil height',''),
(271,'Coordinate Reference System',5711,7301,'Australian Height Datum height','Australian Height Datum height'),
(272,'Coordinate Reference System',5712,7301,'Australian Height Datum (Tasmania) height',''),
(273,'Coordinate Reference System',5713,7301,'Canadian Geodetic Vertical Datum of 1928 height',''),
(274,'Coordinate Reference System',5714,7301,'mean sea level height',''),
(275,'Coordinate Reference System',5715,7301,'mean sea level depth',''),
(276,'Coordinate Reference System',5723,7301,'Japan Levelling Datum height','This alias is ambiguous as it is used for all realisations.'),
(277,'Coordinate Reference System',5724,7301,'PDO Height Datum 1993 height',''),
(278,'Coordinate Reference System',5728,7301,'Landesnivellement 1902 height',''),
(279,'Coordinate Reference System',5729,7301,'Landeshohennetz 1995 height',''),
(281,'Datum',6121,7302,'GGRS87',''),
(282,'Datum',6122,7302,'ATS77',''),
(283,'Datum',6123,7302,'KKJ',''),
(284,'Datum',6124,7302,'RT90',''),
(285,'Datum',6126,7302,'LKS94 (ETRS89)',''),
(286,'Datum',6130,7302,'Moznet',''),
(287,'Datum',6132,7302,'FD58',''),
(288,'Datum',6133,7302,'EST92',''),
(289,'Datum',6134,7302,'PSD93',''),
(290,'Datum',6140,7302,'NAD83(CSRS)',''),
(291,'Datum',6151,7302,'CHTRF95',''),
(292,'Datum',6152,7302,'NAD83(HARN)',''),
(293,'Datum',6154,7302,'ED50(ED77)',''),
(294,'Datum',6156,7302,'S-JTSK',''),
(295,'Datum',6159,7302,'ELD79',''),
(296,'Datum',6163,7302,'YNGN96',''),
(297,'Datum',6170,7302,'SIRGAS 1995',''),
(298,'Datum',6171,7302,'RGF93',''),
(299,'Datum',6172,7302,'POSGAR',''),
(300,'Datum',6202,7302,'AGD66',''),
(301,'Datum',6203,7302,'AGD84',''),
(302,'Datum',6204,7302,'Ain el Abd',''),
(303,'Datum',6215,7302,'Belge 1950',''),
(304,'Datum',6230,7302,'ED50',''),
(305,'Datum',6231,7302,'ED87',''),
(306,'Datum',6237,7302,'HD72',''),
(307,'Datum',6238,7302,'ID74',''),
(308,'Datum',6242,7302,'JAD69',''),
(309,'Datum',6246,7302,'KOC',''),
(310,'Datum',6248,7302,'PSAD56',''),
(311,'Datum',6258,7302,'ETRS89',''),
(312,'Datum',6267,7302,'NAD27',''),
(313,'Datum',6269,7302,'NAD83',''),
(314,'Datum',6272,7302,'NZGD49',''),
(315,'Datum',6275,7302,'NTF',''),
(316,'Datum',6278,7302,'OSGB70',''),
(317,'Datum',6279,7302,'OS(SN)80',''),
(318,'Datum',6280,7302,'Padang',''),
(319,'Datum',6283,7302,'GDA94',''),
(320,'Datum',6291,7302,'SAD69',''),
(321,'Datum',6297,7302,'Tananarive',''),
(322,'Datum',6303,7302,'TC(1948)',''),
(324,'Datum',6308,7302,'RT38',''),
(325,'Datum',6312,7302,'MGI',''),
(326,'Datum',6313,7302,'Belge 1972',''),
(327,'Datum',6314,7302,'DHDN',''),
(328,'Datum',6318,7302,'NGN',''),
(329,'Datum',6319,7302,'KUDAMS',''),
(330,'Datum',6322,7302,'WGS 72',''),
(331,'Datum',6324,7302,'WGS 72BE',''),
(332,'Datum',6326,7302,'WGS 84',''),
(333,'Datum',6608,7302,'NAD27(76)',''),
(334,'Datum',6609,7302,'CGQ77',''),
(335,'Datum',6901,7302,'ATF (Paris)',''),
(336,'Datum',6902,7302,'NDG (Paris)',''),
(337,'Ellipsoid',7003,7302,'ANS',''),
(338,'Coordinate Reference System',7401,7302,'NTF / France II + Lalle',''),
(339,'Coordinate Reference System',7402,7302,'NTF / France II + IGN69',''),
(340,'Coordinate Reference System',7403,7302,'NTF / France III + IGN69',''),
(341,'Coordinate Reference System',7405,7302,'GB Nat Grid + ODN ht',''),
(342,'Coordinate Reference System',7407,7302,'NAD27 / TX_N + NGVD29 ht',''),
(343,'Coordinate_Operation Parameter',8663,7302,'k',''),
(344,'Unit of Measure',9001,1041,'m',''),
(345,'Unit of Measure',9002,1041,'ft',''),
(346,'Unit of Measure',9003,7302,'ftUS',''),
(347,'Unit of Measure',9005,7302,'ftCla',''),
(348,'Unit of Measure',9014,7302,'f',''),
(349,'Unit of Measure',9030,7302,'NM',''),
(350,'Unit of Measure',9031,7302,'GLM',''),
(351,'Unit of Measure',9033,7302,'chUS',''),
(352,'Unit of Measure',9034,7302,'lkUS',''),
(353,'Unit of Measure',9035,7302,'miUS',''),
(354,'Unit of Measure',9036,1041,'km',''),
(355,'Unit of Measure',9037,7302,'ydCla',''),
(356,'Unit of Measure',9038,7302,'chCla',''),
(357,'Unit of Measure',9039,7302,'lkCla',''),
(358,'Unit of Measure',9040,7302,'ydSe',''),
(359,'Unit of Measure',9041,7302,'ftSe',''),
(360,'Unit of Measure',9042,7302,'chSe',''),
(361,'Unit of Measure',9043,7302,'lkSe',''),
(362,'Unit of Measure',9050,7302,'ydBnA',''),
(363,'Unit of Measure',9051,7302,'ftBnA',''),
(364,'Unit of Measure',9052,7302,'chBnA',''),
(365,'Unit of Measure',9053,7302,'lkBnA',''),
(366,'Unit of Measure',9060,7302,'ydBnB',''),
(367,'Unit of Measure',9061,7302,'ftBnB',''),
(368,'Unit of Measure',9062,7302,'chBnB',''),
(369,'Unit of Measure',9063,7302,'lkBnB',''),
(370,'Unit of Measure',9070,7302,'ftBr(65)',''),
(371,'Unit of Measure',9080,7302,'ftInd',''),
(372,'Unit of Measure',9081,7302,'ftInd(37)',''),
(373,'Unit of Measure',9082,7302,'ftInd(62)',''),
(374,'Unit of Measure',9083,7302,'ftInd(75)',''),
(375,'Unit of Measure',9084,7302,'ydInd',''),
(376,'Unit of Measure',9085,7302,'ydInd(37)',''),
(377,'Unit of Measure',9086,7302,'ydInd(62)',''),
(378,'Unit of Measure',9087,7302,'ydInd(75)',''),
(380,'Unit of Measure',9094,7302,'ftGC',''),
(381,'Unit of Measure',9101,1041,'rad',''),
(382,'Unit of Measure',9102,7302,'deg',''),
(383,'Unit of Measure',9103,7302,'min',''),
(384,'Unit of Measure',9104,7302,'sec',''),
(385,'Unit of Measure',9105,7302,'gr',''),
(386,'Unit of Measure',9106,7302,'g',''),
(387,'Unit of Measure',9107,7302,'DMS',''),
(388,'Unit of Measure',9108,7302,'DMSH',''),
(389,'Unit of Measure',9109,7302,'rad',''),
(390,'Unit of Measure',9110,7302,'DDD.MMSSsss',''),
(391,'Unit of Measure',9111,7302,'DDD.MMm',''),
(392,'Unit of Measure',9112,7302,'c',''),
(393,'Unit of Measure',9113,7302,'cc',''),
(395,'Unit of Measure',9202,1041,'ppm',''),
(396,'Unit of Measure',9204,7302,'Bin330ftUS',''),
(397,'Unit of Measure',9205,7302,'Bin165ftUS',''),
(398,'Unit of Measure',9206,7302,'Bin82.5ftUS',''),
(399,'Unit of Measure',9207,7302,'Bin37.5m',''),
(400,'Unit of Measure',9208,7302,'Bin25m',''),
(401,'Unit of Measure',9209,7302,'Bin12.5m',''),
(402,'Unit of Measure',9210,7302,'Bin6.25m',''),
(403,'Unit of Measure',9211,7302,'Bin3.125m',''),
(404,'Coordinate_Operation Method',9633,7302,'OSTN',''),
(405,'Coordinate_Operation Method',9824,7302,'UTM',''),
(406,'Coordinate_Operation',10101,7302,'Alabama East','This alias is ambiguous as also used for SPCS83 projection.'),
(407,'Coordinate_Operation',10102,7302,'Alabama West','This alias is ambiguous as also used for SPCS83 projection.'),
(408,'Coordinate_Operation',10131,7302,'Alabama East','This alias is ambiguous as also used for SPCS27 projection.'),
(409,'Coordinate_Operation',10132,7302,'Alabama West','This alias is ambiguous as also used for SPCS27 projection.'),
(410,'Coordinate_Operation',10201,7302,'Arizona East','This alias is ambiguous as also used for SPCS83 projection.'),
(411,'Coordinate_Operation',10202,7302,'Arizona Central','This alias is ambiguous as also used for SPCS83 projection.'),
(412,'Coordinate_Operation',10203,7302,'Arizona West','This alias is ambiguous as also used for SPCS83 projection.'),
(413,'Coordinate_Operation',10231,7302,'Arizona East','This alias is ambiguous as also used for SPCS27 projection.'),
(414,'Coordinate_Operation',10232,7302,'Arizona Central','This alias is ambiguous as also used for SPCS27 projection.'),
(415,'Coordinate_Operation',10233,7302,'Arizona West','This alias is ambiguous as also used for SPCS27 projection.'),
(416,'Coordinate_Operation',10301,7302,'Arkansas North','This alias is ambiguous as also used for SPCS83 projection.'),
(417,'Coordinate_Operation',10302,7302,'Arkansas South','This alias is ambiguous as also used for SPCS83 projection.'),
(418,'Coordinate_Operation Method',9809,7301,'Roussilhe',''),
(419,'Coordinate_Operation',10331,7302,'Arkansas North','This alias is ambiguous as also used for SPCS27 projection.'),
(420,'Coordinate_Operation',10332,7302,'Arkansas South','This alias is ambiguous as also used for SPCS27 projection.'),
(421,'Coordinate_Operation',10401,7302,'California zone I',''),
(422,'Coordinate_Operation',10402,7302,'California zone II',''),
(423,'Coordinate_Operation',10403,7302,'California zone III',''),
(424,'Coordinate_Operation',10404,7302,'California zone IV',''),
(425,'Coordinate_Operation',10405,7302,'California zone V',''),
(426,'Coordinate_Operation',10406,7302,'California zone VI',''),
(427,'Coordinate_Operation',10407,7302,'California zone VII',''),
(428,'Coordinate_Operation',10431,7302,'California zone 1',''),
(429,'Coordinate_Operation',10432,7302,'California zone 2',''),
(430,'Coordinate_Operation',10433,7302,'California zone 3',''),
(431,'Coordinate_Operation',10434,7302,'California zone 4',''),
(432,'Coordinate_Operation',10435,7302,'California zone 5',''),
(433,'Coordinate_Operation',10436,7302,'California zone 6',''),
(434,'Coordinate_Operation',10501,7302,'Colorado North','This alias is ambiguous as also used for SPCS83 projection.'),
(435,'Coordinate_Operation',10503,7302,'Colorado South','This alias is ambiguous as also used for SPCS83 projection.'),
(436,'Coordinate_Operation',10531,7302,'Colorado North','This alias is ambiguous as also used for SPCS27 projection.'),
(437,'Coordinate_Operation',10533,7302,'Colorado South','This alias is ambiguous as also used for SPCS27 projection.'),
(438,'Coordinate_Operation',10600,7302,'Connecticut','This alias is ambiguous as also used for SPCS83 projection.'),
(439,'Coordinate_Operation',10630,7302,'Connecticut','This alias is ambiguous as also used for SPCS27 projection.'),
(440,'Coordinate_Operation',10700,7302,'Delaware','This alias is ambiguous as also used for SPCS83 projection.'),
(441,'Coordinate_Operation',10730,7302,'Delaware','This alias is ambiguous as also used for SPCS27 projection.'),
(442,'Coordinate_Operation',10901,7302,'Florida East','This alias is ambiguous as also used for SPCS83 projection.'),
(443,'Coordinate_Operation',10902,7302,'Florida West','This alias is ambiguous as also used for SPCS83 projection.'),
(444,'Coordinate_Operation',10903,7302,'Florida North','This alias is ambiguous as also used for SPCS83 projection.'),
(445,'Coordinate_Operation',10931,7302,'Florida East','This alias is ambiguous as also used for SPCS27 projection.'),
(446,'Coordinate_Operation',10932,7302,'Florida West','This alias is ambiguous as also used for SPCS27 projection.'),
(447,'Coordinate_Operation',10933,7302,'Florida North','This alias is ambiguous as also used for SPCS27 projection.'),
(448,'Coordinate_Operation',11001,7302,'Georgia East','This alias is ambiguous as also used for SPCS83 projection.'),
(449,'Coordinate_Operation',11002,7302,'Georgia West','This alias is ambiguous as also used for SPCS83 projection.'),
(450,'Coordinate_Operation',11031,7302,'Georgia East','This alias is ambiguous as also used for SPCS27 projection.'),
(451,'Coordinate_Operation',11032,7302,'Georgia West','This alias is ambiguous as also used for SPCS27 projection.'),
(452,'Coordinate_Operation',11101,7302,'Idaho East','This alias is ambiguous as also used for SPCS83 projection.'),
(453,'Coordinate_Operation',11102,7302,'Idaho Central','This alias is ambiguous as also used for SPCS83 projection.'),
(454,'Coordinate_Operation',11103,7302,'Idaho West','This alias is ambiguous as also used for SPCS83 projection.'),
(455,'Coordinate_Operation',11131,7302,'Idaho East','This alias is ambiguous as also used for SPCS27 projection.'),
(456,'Coordinate_Operation',11132,7302,'Idaho Central','This alias is ambiguous as also used for SPCS27 projection.'),
(457,'Coordinate_Operation',11133,7302,'Idaho West','This alias is ambiguous as also used for SPCS27 projection.'),
(458,'Coordinate_Operation',11201,7302,'Illinois East','This alias is ambiguous as also used for SPCS83 projection.'),
(459,'Coordinate_Operation',11202,7302,'Illinois West','This alias is ambiguous as also used for SPCS83 projection.'),
(460,'Coordinate_Operation',11231,7302,'Illinois East','This alias is ambiguous as also used for SPCS27 projection.'),
(461,'Coordinate_Operation',11232,7302,'Illinois West','This alias is ambiguous as also used for SPCS27 projection.'),
(462,'Coordinate_Operation',11301,7302,'Indiana East','This alias is ambiguous as also used for SPCS83 projection.'),
(463,'Coordinate_Operation',11302,7302,'Indiana West','This alias is ambiguous as also used for SPCS83 projection.'),
(464,'Coordinate_Operation',11331,7302,'Indiana East','This alias is ambiguous as also used for SPCS27 projection.'),
(465,'Coordinate_Operation',11332,7302,'Indiana West','This alias is ambiguous as also used for SPCS27 projection.'),
(466,'Coordinate_Operation',11401,7302,'Iowa North','This alias is ambiguous as also used for SPCS83 projection.'),
(467,'Coordinate_Operation',11402,7302,'Iowa South','This alias is ambiguous as also used for SPCS83 projection.'),
(468,'Coordinate_Operation',11431,7302,'Iowa North','This alias is ambiguous as also used for SPCS27 projection.'),
(469,'Coordinate_Operation',11432,7302,'Iowa South','This alias is ambiguous as also used for SPCS27 projection.'),
(470,'Coordinate_Operation',11501,7302,'Kansas North','This alias is ambiguous as also used for SPCS83 projection.'),
(471,'Coordinate_Operation',11502,7302,'Kansas South','This alias is ambiguous as also used for SPCS83 projection.'),
(472,'Coordinate_Operation',11531,7302,'Kansas North','This alias is ambiguous as also used for SPCS27 projection.'),
(473,'Coordinate_Operation',11532,7302,'Kansas South','This alias is ambiguous as also used for SPCS27 projection.'),
(474,'Coordinate_Operation',11601,7302,'Kentucky North','This alias is ambiguous as also used for SPCS83 projection.'),
(475,'Coordinate_Operation',11602,7302,'Kentucky South','This alias is ambiguous as also used for SPCS83 projection.'),
(476,'Coordinate_Operation',11631,7302,'Kentucky North',''),
(477,'Coordinate_Operation',11632,7302,'Kentucky South','This alias is ambiguous as also used for SPCS27 projection.'),
(478,'Coordinate_Operation',11701,7302,'Louisiana North','This alias is ambiguous as also used for SPCS83 projection.'),
(479,'Coordinate_Operation',11702,7302,'Louisiana South','This alias is ambiguous as also used for SPCS83 projection.'),
(480,'Coordinate_Operation',11731,7302,'Louisiana North','This alias is ambiguous as also used for SPCS27 projection.'),
(481,'Coordinate_Operation',11732,7302,'Louisiana South','This alias is ambiguous as also used for SPCS27 projection.'),
(482,'Coordinate_Operation',11801,7302,'Maine East','This alias is ambiguous as also used for SPCS83 projection.'),
(483,'Coordinate_Operation',11802,7302,'Maine West','This alias is ambiguous as also used for SPCS27 projection.'),
(484,'Coordinate_Operation',11831,7302,'Maine East','This alias is ambiguous as also used for SPCS27 projection.'),
(485,'Coordinate_Operation',11832,7302,'Maine West','This alias is ambiguous as also used for SPCS83 projection.'),
(486,'Coordinate_Operation',11900,7302,'Maryland','This alias is ambiguous as also used for SPCS83 projection.'),
(487,'Coordinate_Operation',11930,7302,'Maryland','This alias is ambiguous as also used for SPCS27 projection.'),
(488,'Coordinate_Operation',12001,7302,'Massachusetts Mainland','This alias is ambiguous as also used for SPCS83 projection.'),
(489,'Coordinate_Operation',12002,7302,'Massachusetts Island','This alias is ambiguous as also used for SPCS83 projection.'),
(490,'Coordinate_Operation',12031,7302,'Massachusetts Mainland','This alias is ambiguous as also used for SPCS27 projection.'),
(491,'Coordinate_Operation',12032,7302,'Massachusetts Island','This alias is ambiguous as also used for SPCS27 projection.'),
(492,'Coordinate_Operation',12101,7302,'Michigan East',''),
(493,'Coordinate_Operation',12102,7302,'Michigan Old Central',''),
(494,'Coordinate_Operation',12111,7302,'Michigan North','This alias is ambiguous as also used for SPCS83 projection.'),
(495,'Coordinate_Operation',12112,7302,'Michigan Central','This alias is ambiguous as also used for SPCS83 projection.'),
(496,'Coordinate_Operation',12113,7302,'Michigan South','This alias is ambiguous as also used for SPCS83 projection.'),
(497,'Coordinate_Operation',12141,7302,'Michigan North','This alias is ambiguous as also used for SPCS27 projection.'),
(498,'Coordinate_Operation',12142,7302,'Michigan Central','This alias is ambiguous as also used for SPCS27 projection.'),
(499,'Coordinate_Operation',12143,7302,'Michigan South','This alias is ambiguous as also used for SPCS27 projection.'),
(500,'Coordinate_Operation',12201,7302,'Minnesota North','This alias is ambiguous as also used for SPCS83 projection.'),
(501,'Coordinate_Operation',12202,7302,'Minnesota Central',''),
(502,'Coordinate_Operation',12203,7302,'Minnesota South','This alias is ambiguous as also used for SPCS83 projection.'),
(503,'Coordinate_Operation',12231,7302,'Minnesota North','This alias is ambiguous as also used for SPCS27 projection.'),
(504,'Coordinate_Operation',12232,7302,'Minnesota Central (m)',''),
(505,'Coordinate_Operation',12233,7302,'Minnesota South','This alias is ambiguous as also used for SPCS27 projection.'),
(506,'Coordinate_Operation',12301,7302,'Mississippi East','This alias is ambiguous as also used for SPCS27 projection.'),
(507,'Coordinate_Operation',12302,7302,'Mississippi West','This alias is ambiguous as also used for SPCS83 projection.'),
(508,'Coordinate_Operation',12331,7302,'Mississippi East','This alias is ambiguous as also used for SPCS83 projection.'),
(509,'Coordinate_Operation',12332,7302,'Mississippi West','This alias is ambiguous as also used for SPCS27 projection.'),
(510,'Coordinate_Operation',12401,7302,'Missouri East','This alias is ambiguous as also used for SPCS83 projection.'),
(511,'Coordinate_Operation',12402,7302,'Missouri Central','This alias is ambiguous as also used for SPCS83 projection.'),
(512,'Coordinate_Operation',12403,7302,'Missouri West','This alias is ambiguous as also used for SPCS83 projection.'),
(513,'Coordinate_Operation',12431,7302,'Missouri East','This alias is ambiguous as also used for SPCS27 projection.'),
(514,'Coordinate_Operation',12432,7302,'Missouri Central','This alias is ambiguous as also used for SPCS27 projection.'),
(515,'Coordinate_Operation',12433,7302,'Missouri West','This alias is ambiguous as also used for SPCS27 projection.'),
(516,'Coordinate_Operation',12501,7302,'Montana North',''),
(517,'Coordinate_Operation',12502,7302,'Montana Central',''),
(518,'Coordinate_Operation',12503,7302,'Montana South',''),
(519,'Coordinate_Operation',12530,7302,'Montana',''),
(520,'Coordinate_Operation',12601,7302,'Nebraska North',''),
(521,'Coordinate_Operation',12602,7302,'Nebraska South',''),
(522,'Coordinate_Operation',12630,7302,'Nebraska (m)',''),
(523,'Coordinate_Operation',12701,7302,'Nevada East','This alias is ambiguous as also used for SPCS83 projection.'),
(524,'Coordinate_Operation',12702,7302,'Nevada Central','This alias is ambiguous as also used for SPCS83 projection.'),
(525,'Coordinate_Operation',12703,7302,'Nevada West','This alias is ambiguous as also used for SPCS83 projection.'),
(526,'Coordinate_Operation',12731,7302,'Nevada East','This alias is ambiguous as also used for SPCS27 projection.'),
(527,'Coordinate_Operation',12732,7302,'Nevada Central','This alias is ambiguous as also used for SPCS27 projection.'),
(528,'Coordinate_Operation',12733,7302,'Nevada West','This alias is ambiguous as also used for SPCS27 projection.'),
(529,'Coordinate_Operation',12800,7302,'New Hampshire','This alias is ambiguous as also used for SPCS83 projection.'),
(530,'Coordinate_Operation',12830,7302,'New Hampshire','This alias is ambiguous as also used for SPCS27 projection.'),
(531,'Coordinate_Operation',12900,7302,'New Jersey','This alias is ambiguous as also used for SPCS83 projection.'),
(532,'Coordinate_Operation',12930,7302,'New Jersey','This alias is ambiguous as also used for SPCS27 projection.'),
(533,'Coordinate_Operation',13001,7302,'New Mexico East','This alias is ambiguous as also used for SPCS83 projection.'),
(534,'Coordinate_Operation',13002,7302,'New Mexico Central','This alias is ambiguous as also used for SPCS83 projection.'),
(535,'Coordinate_Operation',13003,7302,'New Mexico West','This alias is ambiguous as also used for SPCS83 projection.'),
(536,'Coordinate_Operation',13031,7302,'New Mexico East','This alias is ambiguous as also used for SPCS27 projection.'),
(537,'Coordinate_Operation',13032,7302,'New Mexico Central','This alias is ambiguous as also used for SPCS27 projection.'),
(538,'Coordinate_Operation',13033,7302,'New Mexico West','This alias is ambiguous as also used for SPCS27 projection.'),
(539,'Coordinate_Operation',13101,7302,'New York East','This alias is ambiguous as also used for SPCS83 projection.'),
(540,'Coordinate_Operation',13102,7302,'New York Central','This alias is ambiguous as also used for SPCS83 projection.'),
(541,'Coordinate_Operation',13103,7302,'New York West','This alias is ambiguous as also used for SPCS83 projection.'),
(542,'Coordinate_Operation',13104,7302,'New York Long Island','This alias is ambiguous as also used for SPCS83 projection.'),
(543,'Coordinate_Operation',13131,7302,'New York East','This alias is ambiguous as also used for SPCS27 projection.'),
(544,'Coordinate_Operation',13132,7302,'New York Central','This alias is ambiguous as also used for SPCS27 projection.'),
(545,'Coordinate_Operation',13133,7302,'New York West','This alias is ambiguous as also used for SPCS27 projection.'),
(546,'Coordinate_Operation',13134,7302,'New York Long Island','This alias is ambiguous as also used for SPCS27 projection.'),
(547,'Coordinate_Operation',13200,7302,'North Carolina','This alias is ambiguous as also used for SPCS83 projection.'),
(548,'Coordinate_Operation',13230,7302,'North Carolina','This alias is ambiguous as also used for SPCS27 projection.'),
(549,'Coordinate_Operation',13301,7302,'North Dakota North','This alias is ambiguous as also used for SPCS83 projection.'),
(550,'Coordinate_Operation',13302,7302,'North Dakota South','This alias is ambiguous as also used for SPCS83 projection.'),
(551,'Coordinate_Operation',13331,7302,'North Dakota North','This alias is ambiguous as also used for SPCS27 projection.'),
(552,'Coordinate_Operation',13332,7302,'North Dakota South','This alias is ambiguous as also used for SPCS27 projection.'),
(553,'Coordinate_Operation',13401,7302,'Ohio North','This alias is ambiguous as also used for SPCS83 projection.'),
(554,'Coordinate_Operation',13402,7302,'Ohio South','This alias is ambiguous as also used for SPCS83 projection.'),
(555,'Coordinate_Operation',13431,7302,'Ohio North','This alias is ambiguous as also used for SPCS27 projection.'),
(556,'Coordinate_Operation',13432,7302,'Ohio South','This alias is ambiguous as also used for SPCS27 projection.'),
(557,'Coordinate_Operation',13501,7302,'Oklahoma North','This alias is ambiguous as also used for SPCS83 projection.'),
(558,'Coordinate_Operation',13502,7302,'Oklahoma South','This alias is ambiguous as also used for SPCS83 projection.'),
(559,'Coordinate_Operation',13531,7302,'Oklahoma North','This alias is ambiguous as also used for SPCS27 projection.'),
(560,'Coordinate_Operation',13532,7302,'Oklahoma South','This alias is ambiguous as also used for SPCS27 projection.'),
(561,'Coordinate_Operation',13601,7302,'Oregon North','This alias is ambiguous as also used for SPCS83 projection.'),
(562,'Coordinate_Operation',13602,7302,'Oregon South','This alias is ambiguous as also used for SPCS83 projection.'),
(563,'Coordinate_Operation',13631,7302,'Oregon North','This alias is ambiguous as also used for SPCS27 projection.'),
(564,'Coordinate_Operation',13632,7302,'Oregon South','This alias is ambiguous as also used for SPCS27 projection.'),
(565,'Coordinate_Operation',13701,7302,'Pennsylvania North','This alias is ambiguous as also used for SPCS83 projection.'),
(566,'Coordinate_Operation',13702,7302,'Pennsylvania South','This alias is ambiguous as also used for SPCS83 projection.'),
(567,'Coordinate_Operation',13731,7302,'Pennsylvania North','This alias is ambiguous as also used for SPCS27 projection.'),
(568,'Coordinate_Operation',13732,7302,'Pennsylvania South','This alias is ambiguous as also used for SPCS27 projection.'),
(569,'Coordinate_Operation',13800,7302,'Rhode Island','This alias is ambiguous as also used for SPCS83 projection.'),
(570,'Coordinate_Operation',13830,7302,'Rhode Island','This alias is ambiguous as also used for SPCS27 projection.'),
(571,'Coordinate_Operation',13901,7302,'South Carolina North',''),
(572,'Coordinate_Operation',13902,7302,'South Carolina South',''),
(573,'Coordinate_Operation',13930,7302,'South Carolina',''),
(574,'Coordinate_Operation',14001,7302,'South Dakota North',''),
(575,'Coordinate_Operation',14002,7302,'South Dakota South',''),
(576,'Coordinate_Operation',14031,7302,'South Dakota North',''),
(577,'Coordinate_Operation',14032,7302,'South Dakota South',''),
(578,'Coordinate_Operation',14100,7302,'Tennessee',''),
(579,'Coordinate_Operation',14130,7302,'Tennessee','This alias is ambiguous as also used for SPCS27 projection.'),
(580,'Coordinate_Operation',14201,7302,'Texas North','This alias is ambiguous as also used for SPCS83 projection.'),
(581,'Coordinate_Operation',14202,7302,'Texas North Central','This alias is ambiguous as also used for SPCS83 projection.'),
(582,'Coordinate_Operation',14203,7302,'Texas Central','This alias is ambiguous as also used for SPCS83 projection.'),
(583,'Coordinate_Operation',14204,7302,'Texas South Central','This alias is ambiguous as also used for SPCS83 projection.'),
(584,'Coordinate_Operation',14205,7302,'Texas South','This alias is ambiguous as also used for SPCS83 projection.'),
(585,'Coordinate_Operation',14231,7302,'Texas North','This alias is ambiguous as also used for SPCS27 projection.'),
(586,'Coordinate_Operation',14232,7302,'Texas North Central','This alias is ambiguous as also used for SPCS27 projection.'),
(587,'Coordinate_Operation',14233,7302,'Texas Central','This alias is ambiguous as also used for SPCS27 projection.'),
(588,'Coordinate_Operation',14234,7302,'Texas South Central','This alias is ambiguous as also used for SPCS27 projection.'),
(589,'Coordinate_Operation',14235,7302,'Texas South','This alias is ambiguous as also used for SPCS27 projection.'),
(590,'Coordinate_Operation',14301,7302,'Utah North','This alias is ambiguous as also used for SPCS83 projection.'),
(591,'Coordinate_Operation',14302,7302,'Utah Central','This alias is ambiguous as also used for SPCS83 projection.'),
(592,'Coordinate_Operation',14303,7302,'Utah South','This alias is ambiguous as also used for SPCS83 projection.'),
(593,'Coordinate_Operation',14331,7302,'Utah North','This alias is ambiguous as also used for SPCS27 projection.'),
(594,'Coordinate_Operation',14332,7302,'Utah Central','This alias is ambiguous as also used for SPCS27 projection.'),
(595,'Coordinate_Operation',14333,7302,'Utah South','This alias is ambiguous as also used for SPCS27 projection.'),
(596,'Coordinate_Operation',14400,7302,'Vermont','This alias is ambiguous as also used for SPCS83 projection.'),
(597,'Coordinate_Operation',14430,7302,'Vermont','This alias is ambiguous as also used for SPCS27 projection.'),
(598,'Coordinate_Operation',14501,7302,'Virginia North','This alias is ambiguous as also used for SPCS83 projection.'),
(599,'Coordinate_Operation',14502,7302,'Virginia South','This alias is ambiguous as also used for SPCS83 projection.'),
(600,'Coordinate_Operation',14531,7302,'Virginia North','This alias is ambiguous as also used for SPCS27 projection.'),
(601,'Coordinate_Operation',14532,7302,'Virginia South','This alias is ambiguous as also used for SPCS27 projection.'),
(602,'Coordinate_Operation',14601,7302,'Washington North','This alias is ambiguous as also used for SPCS83 projection.'),
(603,'Coordinate_Operation',14602,7302,'Washington South','This alias is ambiguous as also used for SPCS83 projection.'),
(604,'Coordinate_Operation',14631,7302,'Washington North','This alias is ambiguous as also used for SPCS27 projection.'),
(605,'Coordinate_Operation',14632,7302,'Washington South','This alias is ambiguous as also used for SPCS27 projection.'),
(606,'Coordinate_Operation',14701,7302,'West Virginia North','This alias is ambiguous as also used for SPCS83 projection.'),
(607,'Coordinate_Operation',14702,7302,'West Virginia South','This alias is ambiguous as also used for SPCS83 projection.'),
(608,'Coordinate_Operation',14731,7302,'West Virginia North','This alias is ambiguous as also used for SPCS27 projection.'),
(609,'Coordinate_Operation',14732,7302,'West Virginia South','This alias is ambiguous as also used for SPCS27 projection.'),
(610,'Coordinate_Operation',14801,7302,'Wisconsin North','This alias is ambiguous as also used for SPCS83 projection.'),
(611,'Coordinate_Operation',14802,7302,'Wisconsin Central','This alias is ambiguous as also used for SPCS83 projection.'),
(612,'Coordinate_Operation',14803,7302,'Wisconsin South','This alias is ambiguous as also used for SPCS83 projection.'),
(613,'Coordinate_Operation',14831,7302,'Wisconsin North','This alias is ambiguous as also used for SPCS27 projection.'),
(614,'Coordinate_Operation',14832,7302,'Wisconsin Central','This alias is ambiguous as also used for SPCS27 projection.'),
(615,'Coordinate_Operation',14833,7302,'Wisconsin South','This alias is ambiguous as also used for SPCS27 projection.'),
(616,'Coordinate_Operation',14901,7302,'Wyoming East','This alias is ambiguous as also used for SPCS83 projection.'),
(617,'Coordinate_Operation',14902,7302,'Wyoming East Central','This alias is ambiguous as also used for SPCS83 projection.'),
(618,'Coordinate_Operation',14903,7302,'Wyoming West Central','This alias is ambiguous as also used for SPCS83 projection.'),
(619,'Coordinate_Operation',14904,7302,'Wyoming West','This alias is ambiguous as also used for SPCS83 projection.'),
(620,'Coordinate_Operation',14931,7302,'Wyoming East','This alias is ambiguous as also used for SPCS27 projection.'),
(621,'Coordinate_Operation',14932,7302,'Wyoming East Central','This alias is ambiguous as also used for SPCS27 projection.'),
(622,'Coordinate_Operation',14933,7302,'Wyoming West Central','This alias is ambiguous as also used for SPCS27 projection.'),
(623,'Coordinate_Operation',14934,7302,'Wyoming West','This alias is ambiguous as also used for SPCS27 projection.'),
(624,'Coordinate_Operation',15001,7302,'Alaska zone 1','This alias is ambiguous as also used for SPCS83 projection.'),
(625,'Coordinate_Operation',15002,7302,'Alaska zone 2','This alias is ambiguous as also used for SPCS83 projection.'),
(626,'Coordinate_Operation',15003,7302,'Alaska zone 3','This alias is ambiguous as also used for SPCS83 projection.'),
(627,'Coordinate_Operation',15004,7302,'Alaska zone 4','This alias is ambiguous as also used for SPCS83 projection.'),
(628,'Coordinate_Operation',15005,7302,'Alaska zone 5','This alias is ambiguous as also used for SPCS83 projection.'),
(629,'Coordinate_Operation',15006,7302,'Alaska zone 6','This alias is ambiguous as also used for SPCS83 projection.'),
(630,'Coordinate_Operation',15007,7302,'Alaska zone 7','This alias is ambiguous as also used for SPCS83 projection.'),
(631,'Coordinate_Operation',15008,7302,'Alaska zone 8','This alias is ambiguous as also used for SPCS83 projection.'),
(632,'Coordinate_Operation',15009,7302,'Alaska zone 9','This alias is ambiguous as also used for SPCS83 projection.'),
(633,'Coordinate_Operation',15010,7302,'Alaska zone 10','This alias is ambiguous as also used for SPCS83 projection.'),
(634,'Coordinate_Operation',15031,7302,'Alaska zone 1','This alias is ambiguous as also used for SPCS27 projection.'),
(635,'Coordinate_Operation',15032,7302,'Alaska zone 2','This alias is ambiguous as also used for SPCS27 projection.'),
(636,'Coordinate_Operation',15033,7302,'Alaska zone 3','This alias is ambiguous as also used for SPCS27 projection.'),
(637,'Coordinate_Operation',15034,7302,'Alaska zone 4','This alias is ambiguous as also used for SPCS27 projection.'),
(638,'Coordinate_Operation',15035,7302,'Alaska zone 5','This alias is ambiguous as also used for SPCS27 projection.'),
(639,'Coordinate_Operation',15036,7302,'Alaska zone 6','This alias is ambiguous as also used for SPCS27 projection.'),
(640,'Coordinate_Operation',15037,7302,'Alaska zone 7','This alias is ambiguous as also used for SPCS27 projection.'),
(641,'Coordinate_Operation',15038,7302,'Alaska zone 8','This alias is ambiguous as also used for SPCS27 projection.'),
(642,'Coordinate_Operation',15039,7302,'Alaska zone 9','This alias is ambiguous as also used for SPCS27 projection.'),
(643,'Coordinate_Operation',15040,7302,'Alaska zone 10','This alias is ambiguous as also used for SPCS27 projection.'),
(644,'Coordinate_Operation',15101,7302,'Hawaii zone 1','This alias is ambiguous as also used for SPCS83 projection.'),
(645,'Coordinate_Operation',15102,7302,'Hawaii zone 2','This alias is ambiguous as also used for SPCS83 projection.'),
(646,'Coordinate_Operation',15103,7302,'Hawaii zone 3','This alias is ambiguous as also used for SPCS83 projection.'),
(647,'Coordinate_Operation',15104,7302,'Hawaii zone 4','This alias is ambiguous as also used for SPCS83 projection.'),
(648,'Coordinate_Operation',15105,7302,'Hawaii zone 5','This alias is ambiguous as also used for SPCS83 projection.'),
(649,'Coordinate_Operation',15131,7302,'Hawaii zone 1','This alias is ambiguous as also used for SPCS27 projection.'),
(650,'Coordinate_Operation',15132,7302,'Hawaii zone 2','This alias is ambiguous as also used for SPCS27 projection.'),
(651,'Coordinate_Operation',15133,7302,'Hawaii zone 3','This alias is ambiguous as also used for SPCS27 projection.'),
(652,'Coordinate_Operation',15134,7302,'Hawaii zone 4','This alias is ambiguous as also used for SPCS27 projection.'),
(653,'Coordinate_Operation',15135,7302,'Hawaii zone 5','This alias is ambiguous as also used for SPCS27 projection.'),
(654,'Coordinate_Operation',15201,7302,'Puerto Rico',''),
(655,'Coordinate_Operation',15202,7302,'St. Croix',''),
(656,'Coordinate_Operation',15230,7302,'Puerto Rico & Virgin Is.',''),
(657,'Coordinate_Operation',15914,7302,'BLM 14N (ftUS)',''),
(658,'Coordinate_Operation',15915,7302,'BLM 15N (ftUS)',''),
(659,'Coordinate_Operation',15916,7302,'BLM 16N (ftUS)',''),
(660,'Coordinate_Operation',15917,7302,'BLM 17N (ftUS)',''),
(661,'Coordinate_Operation',16061,7302,'UPS North',''),
(662,'Coordinate_Operation',16161,7302,'UPS South',''),
(663,'Coordinate_Operation',16261,7302,'3-degree Gauss zone 1',''),
(664,'Coordinate_Operation',16262,7302,'3-degree Gauss zone 2',''),
(665,'Coordinate_Operation',16263,7302,'3-degree Gauss zone 3',''),
(666,'Coordinate_Operation',16264,7302,'3-degree Gauss zone 4',''),
(667,'Coordinate_Operation',16265,7302,'3-degree Gauss zone 5',''),
(668,'Coordinate_Operation',16266,7302,'3-degree Gauss zone 6',''),
(669,'Coordinate_Operation',16267,7302,'3-degree Gauss zone 7',''),
(670,'Coordinate_Operation',16268,7302,'3-degree Gauss zone 8',''),
(671,'Coordinate_Operation',16361,7302,'3-deg Gauss-Kruger 3E',''),
(672,'Coordinate_Operation',16362,7302,'3-deg Gauss-Kruger 6E',''),
(673,'Coordinate_Operation',16363,7302,'3-deg Gauss-Kruger 9E',''),
(674,'Coordinate_Operation',16364,7302,'3-deg Gauss-Kruger 12E',''),
(675,'Coordinate_Operation',16365,7302,'3-deg Gauss-Kruger 15E',''),
(676,'Coordinate_Operation',16366,7302,'3-deg Gauss-Kruger 18E',''),
(677,'Coordinate_Operation',16367,7302,'3-deg Gauss-Kruger 21E',''),
(678,'Coordinate_Operation',16368,7302,'3-deg Gauss-Kruger 24E',''),
(679,'Coordinate_Operation',17348,7302,'MGA zone 48',''),
(680,'Coordinate_Operation',17349,7302,'MGA zone 49',''),
(681,'Coordinate_Operation',17350,7302,'MGA zone 50',''),
(682,'Coordinate_Operation',17351,7302,'MGA zone 51',''),
(683,'Coordinate_Operation',17352,7302,'MGA zone 52',''),
(684,'Coordinate_Operation',17353,7302,'MGA zone 53',''),
(685,'Coordinate_Operation',17354,7302,'MGA zone 54',''),
(686,'Coordinate_Operation',17355,7302,'MGA zone 55',''),
(687,'Coordinate_Operation',17356,7302,'MGA zone 56',''),
(688,'Coordinate_Operation',17357,7302,'MGA zone 57',''),
(689,'Coordinate_Operation',17358,7302,'MGA zone 58',''),
(690,'Coordinate_Operation',17448,7302,'AMG zone 48',''),
(691,'Coordinate_Operation',17449,7302,'AMG zone 49',''),
(692,'Coordinate_Operation',17450,7302,'AMG zone 50',''),
(693,'Coordinate_Operation',17451,7302,'AMG zone 51',''),
(694,'Coordinate_Operation',17452,7302,'AMG zone 52',''),
(695,'Coordinate_Operation',17453,7302,'AMG zone 53',''),
(696,'Coordinate_Operation',17454,7302,'AMG zone 54',''),
(697,'Coordinate_Operation',17455,7302,'AMG zone 55',''),
(698,'Coordinate_Operation',17456,7302,'AMG zone 56',''),
(699,'Coordinate_Operation',17457,7302,'AMG zone 57',''),
(700,'Coordinate_Operation',17458,7302,'AMG zone 58',''),
(701,'Coordinate_Operation',17515,7302,'S. African Grid zone 15',''),
(702,'Coordinate_Operation',17517,7302,'S. African Grid zone 17',''),
(703,'Coordinate_Operation',17519,7302,'S. African Grid zone 19',''),
(704,'Coordinate_Operation',17521,7302,'S. African Grid zone 21',''),
(705,'Coordinate_Operation',17523,7302,'S. African Grid zone 23',''),
(706,'Coordinate_Operation',17525,7302,'S. African Grid zone 25',''),
(707,'Coordinate_Operation',17527,7302,'S. African Grid zone 27',''),
(708,'Coordinate_Operation',17529,7302,'S. African Grid zone 29',''),
(709,'Coordinate_Operation',17531,7302,'S. African Grid zone 31',''),
(710,'Coordinate_Operation',17533,7302,'S. African Grid zone 33',''),
(711,'Coordinate_Operation',17611,7302,'SW African Grid zone 11',''),
(712,'Coordinate_Operation',17613,7302,'SW African Grid zone 13',''),
(713,'Coordinate_Operation',17615,7302,'SW African Grid zone 15',''),
(714,'Coordinate_Operation',17617,7302,'SW African Grid zone 17',''),
(715,'Coordinate_Operation',17619,7302,'SW African Grid zone 19',''),
(716,'Coordinate_Operation',17621,7302,'SW African Grid zone 21',''),
(717,'Coordinate_Operation',17623,7302,'SW African Grid zone 23',''),
(718,'Coordinate_Operation',17625,7302,'SW African Grid zone 25',''),
(720,'Coordinate_Operation',17801,7302,'Japan zone I',''),
(721,'Coordinate_Operation',17802,7302,'Japan zone II',''),
(722,'Coordinate_Operation',17803,7302,'Japan zone III',''),
(723,'Coordinate_Operation',17804,7302,'Japan zone IV',''),
(724,'Coordinate_Operation',17805,7302,'Japan zone V',''),
(725,'Coordinate_Operation',17806,7302,'Japan zone VI',''),
(726,'Coordinate_Operation',17807,7302,'Japan zone VII',''),
(727,'Coordinate_Operation',17808,7302,'Japan zone VIII',''),
(728,'Coordinate_Operation',17809,7302,'Japan zone IX',''),
(729,'Coordinate_Operation',17810,7302,'Japan zone X',''),
(730,'Coordinate_Operation',17811,7302,'Japan zone XI',''),
(731,'Coordinate_Operation',17812,7302,'Japan zone XII',''),
(732,'Coordinate_Operation',17813,7302,'Japan zone XIII',''),
(733,'Coordinate_Operation',17814,7302,'Japan zone XIV',''),
(734,'Coordinate_Operation',17815,7302,'Japan zone XV',''),
(735,'Coordinate_Operation',17816,7302,'Japan zone XVI',''),
(736,'Coordinate_Operation',17817,7302,'Japan zone XVII',''),
(737,'Coordinate_Operation',17818,7302,'Japan zone XVIII',''),
(738,'Coordinate_Operation',17901,7302,'Mt Eden Circuit',''),
(739,'Coordinate_Operation',17920,7302,'Mt Pleasant Circuit',''),
(740,'Coordinate_Operation',17924,7302,'Mt Nicholas Circuit',''),
(741,'Coordinate_Operation',17925,7302,'Mt York Circuit',''),
(742,'Coordinate_Operation',17926,7302,'Observation Pt Circuit',''),
(743,'Coordinate_Operation',18031,7302,'Argentina 1',''),
(744,'Coordinate_Operation',18032,7302,'Argentina 2',''),
(745,'Coordinate_Operation',18033,7302,'Argentina 3',''),
(746,'Coordinate_Operation',18034,7302,'Argentina 4',''),
(747,'Coordinate_Operation',18035,7302,'Argentina 5',''),
(748,'Coordinate_Operation',18036,7302,'Argentina 6',''),
(749,'Coordinate_Operation',18037,7302,'Argentina 7',''),
(750,'Coordinate_Operation',18044,7302,'M28',''),
(751,'Coordinate_Operation',18045,7302,'M31',''),
(752,'Coordinate_Operation',18046,7302,'M34',''),
(753,'Coordinate_Operation',18051,7302,'Colombia 3W',''),
(754,'Coordinate_Operation',18052,7302,'Colombia Bogota',''),
(755,'Coordinate_Operation',18053,7302,'Colombia 3E',''),
(756,'Coordinate_Operation',18054,7302,'Colombia 6E',''),
(757,'Coordinate_Operation',18071,7302,'Blue Belt',''),
(758,'Coordinate_Operation',18072,7302,'Red Belt',''),
(759,'Coordinate_Operation',18073,7302,'Purple Belt',''),
(760,'Coordinate_Operation',18074,7302,'Extended Purple Belt',''),
(761,'Coordinate_Operation',18141,7302,'North Island Grid',''),
(762,'Coordinate_Operation',18142,7302,'South Island Grid',''),
(763,'Coordinate_Operation',18193,7302,'Finland zone 3',''),
(764,'Coordinate_Operation',18203,7302,'ICS',''),
(765,'Coordinate_Operation',18204,7302,'ITM',''),
(766,'Coordinate_Operation',18231,7302,'India zone I',''),
(767,'Coordinate_Operation',18232,7302,'India zone IIa',''),
(768,'Coordinate_Operation',18233,7302,'India zone IIIa',''),
(769,'Coordinate_Operation',18234,7302,'India zone IVa',''),
(770,'Coordinate_Operation',18235,7302,'India zone IIb',''),
(771,'Coordinate_Operation',18236,7302,'India zone I',''),
(772,'Coordinate_Operation',18237,7302,'India zone IIa',''),
(773,'Coordinate_Operation',18238,7302,'India zone IIb',''),
(774,'Coordinate_Operation',19900,7302,'Bahrain Grid',''),
(775,'Coordinate_Operation',19905,7302,'NEIEZ',''),
(776,'Coordinate_Operation',19917,7302,'NZMG',''),
(777,'Coordinate_Operation',19922,7302,'LV03',''),
(778,'Coordinate_Operation',19923,7302,'LV03C',''),
(779,'Coordinate_Operation',19928,7302,'KTM',''),
(781,'Coordinate_Operation',19931,7302,'EOV',''),
(782,'Coordinate_Operation',19933,7302,'PEI Stereographic ATS77',''),
(783,'Coordinate_Operation',19935,7302,'R.S.O. Malaya',''),
(784,'Coordinate_Operation',19945,7302,'NB Stereographic ATS77',''),
(785,'Coordinate_Operation',19946,7302,'NB Stereographic NAD83',''),
(786,'Coordinate_Operation',19950,7302,'LV95',''),
(787,'Coordinate_Operation',19951,7302,'Nakhl e Taqi',''),
(788,'Coordinate_Operation',19956,7302,'RSO Borneo (chSe)',''),
(789,'Coordinate_Operation',19957,7302,'RSO Borneo (ftSe)',''),
(790,'Coordinate_Operation',19958,7302,'RSO Borneo (m)',''),
(791,'Coordinate_Operation',19960,7302,'PEI Stereographic NAD83',''),
(792,'Coordinate_Operation',19962,7302,'ITM',''),
(793,'Coordinate Reference System',20004,7302,'S-95 zone 4',''),
(794,'Coordinate Reference System',20005,7302,'S-95 zone 5',''),
(795,'Coordinate Reference System',20006,7302,'S-95 zone 6',''),
(796,'Coordinate Reference System',20007,7302,'S-95 zone 7',''),
(797,'Coordinate Reference System',20008,7302,'S-95 zone 8',''),
(798,'Coordinate Reference System',20009,7302,'S-95 zone 9',''),
(799,'Coordinate Reference System',20010,7302,'S-95 zone 10',''),
(800,'Coordinate Reference System',20011,7302,'S-95 zone 11',''),
(801,'Coordinate Reference System',20012,7302,'S-95 zone 12',''),
(802,'Coordinate Reference System',20013,7302,'S-95 zone 13',''),
(803,'Coordinate Reference System',20014,7302,'S-95 zone 14',''),
(804,'Coordinate Reference System',20015,7302,'S-95 zone 15',''),
(805,'Coordinate Reference System',20016,7302,'S-95 zone 16',''),
(806,'Coordinate Reference System',20017,7302,'S-95 zone 17',''),
(807,'Coordinate Reference System',20018,7302,'S-95 zone 18',''),
(808,'Coordinate Reference System',20019,7302,'S-95 zone 19',''),
(809,'Coordinate Reference System',20020,7302,'S-95 zone 20',''),
(810,'Coordinate Reference System',20021,7302,'S-95 zone 21',''),
(811,'Coordinate Reference System',20022,7302,'S-95 zone 22',''),
(812,'Coordinate Reference System',20023,7302,'S-95 zone 23',''),
(813,'Coordinate Reference System',20024,7302,'S-95 zone 24',''),
(814,'Coordinate Reference System',20025,7302,'S-95 zone 25',''),
(815,'Coordinate Reference System',20026,7302,'S-95 zone 26',''),
(816,'Coordinate Reference System',20027,7302,'S-95 zone 27',''),
(817,'Coordinate Reference System',20028,7302,'S-95 zone 28',''),
(818,'Coordinate Reference System',20029,7302,'S-95 zone 29',''),
(819,'Coordinate Reference System',20030,7302,'S-95 zone 30',''),
(820,'Coordinate Reference System',20031,7302,'S-95 zone 31',''),
(821,'Coordinate Reference System',20032,7302,'S-95 zone 32',''),
(822,'Coordinate Reference System',20064,7302,'Pulkovo 1995 / Gauss 4N',''),
(823,'Coordinate Reference System',20065,7302,'Pulkovo 1995 / Gauss 5N',''),
(824,'Coordinate Reference System',20066,7302,'Pulkovo 1995 / Gauss 6N',''),
(825,'Coordinate Reference System',20067,7302,'Pulkovo 1995 / Gauss 7N',''),
(826,'Coordinate Reference System',20068,7302,'Pulkovo 1995 / Gauss 8N',''),
(827,'Coordinate Reference System',20069,7302,'Pulkovo 1995 / Gauss 9N',''),
(828,'Coordinate Reference System',20070,7302,'Pulkovo 1995 / Gauss 10N',''),
(829,'Coordinate Reference System',20071,7302,'Pulkovo 1995 / Gauss 11N',''),
(830,'Coordinate Reference System',20072,7302,'Pulkovo 1995 / Gauss 12N',''),
(831,'Coordinate Reference System',20073,7302,'Pulkovo 1995 / Gauss 13N',''),
(832,'Coordinate Reference System',20074,7302,'Pulkovo 1995 / Gauss 14N',''),
(833,'Coordinate Reference System',20075,7302,'Pulkovo 1995 / Gauss 15N',''),
(834,'Coordinate Reference System',20076,7302,'Pulkovo 1995 / Gauss 16N',''),
(835,'Coordinate Reference System',20077,7302,'Pulkovo 1995 / Gauss 17N',''),
(836,'Coordinate Reference System',20078,7302,'Pulkovo 1995 / Gauss 18N',''),
(837,'Coordinate Reference System',20079,7302,'Pulkovo 1995 / Gauss 19N',''),
(838,'Coordinate Reference System',20080,7302,'Pulkovo 1995 / Gauss 20N',''),
(839,'Coordinate Reference System',20081,7302,'Pulkovo 1995 / Gauss 21N',''),
(840,'Coordinate Reference System',20082,7302,'Pulkovo 1995 / Gauss 22N',''),
(841,'Coordinate Reference System',20083,7302,'Pulkovo 1995 / Gauss 23N',''),
(842,'Coordinate Reference System',20084,7302,'Pulkovo 1995 / Gauss 24N',''),
(843,'Coordinate Reference System',20085,7302,'Pulkovo 1995 / Gauss 25N',''),
(844,'Coordinate Reference System',20086,7302,'Pulkovo 1995 / Gauss 26N',''),
(845,'Coordinate Reference System',20087,7302,'Pulkovo 1995 / Gauss 27N',''),
(846,'Coordinate Reference System',20088,7302,'Pulkovo 1995 / Gauss 28N',''),
(847,'Coordinate Reference System',20089,7302,'Pulkovo 1995 / Gauss 29N',''),
(848,'Coordinate Reference System',20090,7302,'Pulkovo 1995 / Gauss 30N',''),
(849,'Coordinate Reference System',20091,7302,'Pulkovo 1995 / Gauss 31N',''),
(850,'Coordinate Reference System',20092,7302,'Pulkovo 1995 / Gauss 32N',''),
(851,'Coordinate Reference System',20437,7302,'Ain el Abd / UTM 37N',''),
(852,'Coordinate Reference System',20438,7302,'Ain el Abd / UTM 38N',''),
(853,'Coordinate Reference System',20439,7302,'Ain el Abd / UTM 39N',''),
(854,'Coordinate Reference System',20790,7302,'Lisbon / Portuguese Nat',''),
(855,'Coordinate Reference System',21100,7302,'Batavia / NEIEZ',''),
(856,'Coordinate Reference System',21291,7302,'Barbados 1938 / BWI Grid',''),
(857,'Coordinate Reference System',21292,7302,'Barbados National Grid',''),
(858,'Coordinate Reference System',21413,7302,'Beijing / GK zone 13',''),
(859,'Coordinate Reference System',21414,7302,'Beijing / GK zone 14',''),
(860,'Coordinate Reference System',21415,7302,'Beijing / GK zone 15',''),
(861,'Coordinate Reference System',21416,7302,'Beijing / GK zone 16',''),
(862,'Coordinate Reference System',21417,7302,'Beijing / GK zone 17',''),
(863,'Coordinate Reference System',21418,7302,'Beijing / GK zone 18',''),
(864,'Coordinate Reference System',21419,7302,'Beijing / GK zone 19',''),
(865,'Coordinate Reference System',21420,7302,'Beijing / GK zone 20',''),
(866,'Coordinate Reference System',21421,7302,'Beijing / GK zone 21',''),
(867,'Coordinate Reference System',21422,7302,'Beijing / GK zone 22',''),
(868,'Coordinate Reference System',21423,7302,'Beijing / GK zone 23',''),
(869,'Coordinate Reference System',21473,7302,'Beijing / Gauss 13N',''),
(870,'Coordinate Reference System',21474,7302,'Beijing / Gauss 14N',''),
(871,'Coordinate Reference System',21475,7302,'Beijing / Gauss 15N',''),
(872,'Coordinate Reference System',21476,7302,'Beijing / Gauss 16N',''),
(873,'Coordinate Reference System',21477,7302,'Beijing / Gauss 17N',''),
(874,'Coordinate Reference System',21478,7302,'Beijing / Gauss 18N',''),
(875,'Coordinate Reference System',21479,7302,'Beijing / Gauss 19N',''),
(876,'Coordinate Reference System',21480,7302,'Beijing / Gauss 20N',''),
(877,'Coordinate Reference System',21481,7302,'Beijing / Gauss 21N',''),
(878,'Coordinate Reference System',21482,7302,'Beijing / Gauss 22N',''),
(879,'Coordinate Reference System',21483,7302,'Beijing / Gauss 23N',''),
(880,'Coordinate Reference System',21500,7302,'Belge Lambert 50',''),
(881,'Coordinate Reference System',21780,7302,'LV03C',''),
(882,'Coordinate Reference System',21781,7302,'LV03',''),
(883,'Coordinate Reference System',21891,7302,'Bogota / Colombia 3W',''),
(884,'Coordinate Reference System',21892,7302,'Bogota / Colombia Bogota',''),
(885,'Coordinate Reference System',21893,7302,'Bogota / Colombia 3E',''),
(886,'Coordinate Reference System',21894,7302,'Bogota / Colombia 6E',''),
(887,'Coordinate Reference System',22191,7302,'C Inchauspe / Argentina 1',''),
(888,'Coordinate Reference System',22192,7302,'C Inchauspe / Argentina 2',''),
(889,'Coordinate Reference System',22193,7302,'C Inchauspe / Argentina 3',''),
(890,'Coordinate Reference System',22194,7302,'C Inchauspe / Argentina 4',''),
(891,'Coordinate Reference System',22195,7302,'C Inchauspe / Argentina 5',''),
(892,'Coordinate Reference System',22196,7302,'C Inchauspe / Argentina 6',''),
(893,'Coordinate Reference System',22197,7302,'C Inchauspe / Argentina 7',''),
(894,'Coordinate Reference System',22275,7302,'South African CS zone 15',''),
(895,'Coordinate Reference System',22277,7302,'South African CS zone 17',''),
(896,'Coordinate Reference System',22279,7302,'South African CS zone 19',''),
(897,'Coordinate Reference System',22281,7302,'South African CS zone 21',''),
(898,'Coordinate Reference System',22283,7302,'South African CS zone 23',''),
(899,'Coordinate Reference System',22285,7302,'South African CS zone 25',''),
(900,'Coordinate Reference System',22287,7302,'South African CS zone 27',''),
(901,'Coordinate Reference System',22289,7302,'South African CS zone 29',''),
(902,'Coordinate Reference System',22291,7302,'South African CS zone 31',''),
(903,'Coordinate Reference System',22293,7302,'South African CS zone 33',''),
(904,'Coordinate Reference System',22300,7302,'Tunisia Mining Grid',''),
(905,'Coordinate Reference System',22523,7302,'Corrego Alegre / UTM 23S',''),
(906,'Coordinate Reference System',22524,7302,'Corrego Alegre / UTM 24S',''),
(907,'Coordinate Reference System',22994,7302,'Egypt 1907 / Ext. Purple',''),
(908,'Coordinate Reference System',23946,7302,'Indian 1954 / UTM 46N',''),
(909,'Coordinate Reference System',23947,7302,'Indian 1954 / UTM 47N',''),
(910,'Coordinate Reference System',23948,7302,'Indian 1954 / UTM 48N',''),
(911,'Coordinate Reference System',24047,7302,'Indian 1975 / UTM 47N',''),
(912,'Coordinate Reference System',24048,7302,'Indian 1975 / UTM 48N',''),
(913,'Coordinate Reference System',24100,7302,'Jamaica 1875 / Old Grid',''),
(914,'Coordinate Reference System',24200,7302,'JAD69 / Jamaica Grid',''),
(915,'Coordinate Reference System',24305,7302,'Kalianpur 37 / UTM 45N',''),
(916,'Coordinate Reference System',24306,7302,'Kalianpur 37 / UTM 46N',''),
(917,'Coordinate Reference System',24311,7302,'Kalianpur 62 / UTM 41N',''),
(918,'Coordinate Reference System',24312,7302,'Kalianpur 62 / UTM 42N',''),
(919,'Coordinate Reference System',24313,7302,'Kalianpur 62 / UTM 43N',''),
(920,'Coordinate Reference System',24342,7302,'Kalianpur 75 / UTM 42N',''),
(921,'Coordinate Reference System',24343,7302,'Kalianpur 75 / UTM 43N',''),
(922,'Coordinate Reference System',24344,7302,'Kalianpur 75 / UTM 44N',''),
(923,'Coordinate Reference System',24345,7302,'Kalianpur 75 / UTM 45N',''),
(924,'Coordinate Reference System',24346,7302,'Kalianpur 75 / UTM 46N',''),
(925,'Coordinate Reference System',24347,7302,'Kalianpur 75 / UTM 47N',''),
(926,'Coordinate Reference System',24370,7302,'Kalianpur / India 0',''),
(927,'Coordinate Reference System',24371,7302,'Kalianpur / India I',''),
(928,'Coordinate Reference System',24372,7302,'Kalianpur / India IIa',''),
(929,'Coordinate Reference System',24373,7302,'Kalianpur / India IIIa',''),
(930,'Coordinate Reference System',24374,7302,'Kalianpur / India IVa',''),
(931,'Coordinate Reference System',24375,7302,'Kalianpur 37 / India IIb',''),
(932,'Coordinate Reference System',24376,7302,'Kalianpur 62 / India I',''),
(933,'Coordinate Reference System',24377,7302,'Kalianpur 62 / India IIa',''),
(934,'Coordinate Reference System',24378,7302,'Kalianpur 75 / India I',''),
(935,'Coordinate Reference System',24379,7302,'Kalianpur 75 / India IIa',''),
(936,'Coordinate Reference System',24380,7302,'Kalianpur 75 / India IIb',''),
(937,'Coordinate Reference System',24381,7302,'Kalianpur 75 / India IIIa',''),
(938,'Coordinate Reference System',24382,7302,'Kalianpur / India IIb',''),
(939,'Coordinate Reference System',24383,7302,'Kalianpur 75 / India IVa',''),
(940,'Coordinate Reference System',24892,7302,'PSAD56 / Peru central',''),
(941,'Coordinate Reference System',25000,7302,'Leigon / Ghana Grid',''),
(942,'Coordinate Reference System',25391,7302,'Luzon / Philippines I',''),
(943,'Coordinate Reference System',25392,7302,'Luzon / Philippines II',''),
(944,'Coordinate Reference System',25393,7302,'Luzon / Philippines III',''),
(945,'Coordinate Reference System',25394,7302,'Luzon / Philippines IV',''),
(946,'Coordinate Reference System',25395,7302,'Luzon / Philippines V',''),
(947,'Coordinate Reference System',25700,7302,'Makassar / NEIEZ',''),
(948,'Coordinate Reference System',25932,7302,'Malongo 1987 / UTM 32S',''),
(949,'Coordinate Reference System',26391,7302,'Minna / Nigeria West',''),
(950,'Coordinate Reference System',26393,7302,'Minna / Nigeria East',''),
(951,'Coordinate Reference System',26591,7302,'Monte Mario / Italy 1',''),
(952,'Coordinate Reference System',26592,7302,'Monte Mario / Italy 2',''),
(953,'Coordinate Reference System',26632,7302,'M''poraloko / UTM 32N',''),
(954,'Coordinate Reference System',26692,7302,'M''poraloko / UTM 32S',''),
(955,'Coordinate Reference System',26741,7302,'NAD27 / California I',''),
(956,'Coordinate Reference System',26742,7302,'NAD27 / California II',''),
(957,'Coordinate Reference System',26743,7302,'NAD27 / California III',''),
(958,'Coordinate Reference System',26744,7302,'NAD27 / California IV',''),
(959,'Coordinate Reference System',26745,7302,'NAD27 / California V',''),
(960,'Coordinate Reference System',26746,7302,'NAD27 / California VI',''),
(961,'Coordinate Reference System',26747,7302,'NAD27 / California VII',''),
(962,'Coordinate Reference System',26786,7302,'NAD27 / Massachusetts',''),
(963,'Coordinate Reference System',26787,7302,'NAD27 / Massachusetts Is',''),
(964,'Coordinate Reference System',26792,7302,'NAD27 / Minnesota Cent.',''),
(965,'Coordinate Reference System',26801,7302,'NAD27 / Michigan East',''),
(966,'Coordinate Reference System',26802,7302,'NAD27 / Michigan Old Cen',''),
(967,'Coordinate Reference System',26803,7302,'NAD27 / Michigan West',''),
(968,'Coordinate Reference System',26811,7302,'NAD27 / Michigan North',''),
(969,'Coordinate Reference System',26812,7302,'NAD27 / Michigan Central',''),
(970,'Coordinate Reference System',26813,7302,'NAD27 / Michigan South',''),
(971,'Coordinate Reference System',26941,7302,'NAD83 / California 1',''),
(972,'Coordinate Reference System',26942,7302,'NAD83 / California 2',''),
(973,'Coordinate Reference System',26943,7302,'NAD83 / California 3',''),
(974,'Coordinate Reference System',26944,7302,'NAD83 / California 4',''),
(975,'Coordinate Reference System',26945,7302,'NAD83 / California 5',''),
(976,'Coordinate Reference System',26946,7302,'NAD83 / California 6',''),
(977,'Coordinate Reference System',26986,7302,'NAD83 / Massachusetts',''),
(978,'Coordinate Reference System',26987,7302,'NAD83 / Massachusetts Is',''),
(979,'Coordinate Reference System',26992,7302,'NAD83 / Minnesota Cent.',''),
(980,'Coordinate Reference System',27038,7302,'Nahrwan 1967 / UTM 38N',''),
(981,'Coordinate Reference System',27039,7302,'Nahrwan 1967 / UTM 39N',''),
(982,'Coordinate Reference System',27040,7302,'Nahrwan 1967 / UTM 40N',''),
(983,'Coordinate Reference System',27120,7302,'Naparima 1972 / UTM 20N',''),
(984,'Coordinate Reference System',27200,7302,'NZGD49 / NZ Map Grid',''),
(985,'Coordinate Reference System',27391,7302,'NGO 1948 / I',''),
(986,'Coordinate Reference System',27392,7302,'NGO 1948 / II',''),
(987,'Coordinate Reference System',27393,7302,'NGO 1948 / III',''),
(988,'Coordinate Reference System',27394,7302,'NGO 1948 / IV',''),
(989,'Coordinate Reference System',27395,7302,'NGO 1948 / V',''),
(990,'Coordinate Reference System',27396,7302,'NGO 1948 / VI',''),
(991,'Coordinate Reference System',27397,7302,'NGO 1948 / VII',''),
(992,'Coordinate Reference System',27398,7302,'NGO 1948 / VIII',''),
(993,'Coordinate Reference System',27500,7302,'ATF / Nord de Guerre',''),
(994,'Coordinate Reference System',27581,7302,'NTF / France I',''),
(995,'Coordinate Reference System',27582,7302,'NTF / France II',''),
(996,'Coordinate Reference System',27583,7302,'NTF / France III',''),
(997,'Coordinate Reference System',27584,7302,'NTF / France IV',''),
(998,'Coordinate Reference System',27591,7302,'NTF / Nord France',''),
(999,'Coordinate Reference System',27592,7302,'NTF / Centre France',''),
(1000,'Coordinate Reference System',27593,7302,'NTF / Sud France',''),
(1001,'Coordinate Reference System',27594,7302,'NTF / Corse',''),
(1002,'Coordinate Reference System',27700,7302,'British National Grid',''),
(1003,'Coordinate Reference System',28191,7302,'Palestine Grid',''),
(1004,'Coordinate Reference System',28192,7302,'Palestine Belt',''),
(1005,'Coordinate Reference System',28193,7302,'Israeli CS Grid',''),
(1006,'Coordinate Reference System',28232,7302,'Point Noire / UTM 32S',''),
(1009,'Coordinate Reference System',28404,7317,'S-42 zone 4','This name is ambiguous as it is also used for other CRSs.'),
(1010,'Coordinate Reference System',28405,7317,'S-42 zone 5','This name is ambiguous as it is also used for other CRSs.'),
(1011,'Coordinate Reference System',28406,7317,'S-42 zone 6',''),
(1012,'Coordinate Reference System',28407,7317,'S-42 zone 7',''),
(1013,'Coordinate Reference System',28408,7317,'S-42 zone 8',''),
(1014,'Coordinate Reference System',28409,7317,'S-42 zone 9',''),
(1015,'Coordinate Reference System',28410,7317,'S-42 zone 10',''),
(1016,'Coordinate Reference System',28411,7317,'S-42 zone 11',''),
(1017,'Coordinate Reference System',28412,7317,'S-42 zone 12',''),
(1018,'Coordinate Reference System',28413,7317,'S-42 zone 13',''),
(1019,'Coordinate Reference System',28414,7317,'S-42 zone 14',''),
(1020,'Coordinate Reference System',28415,7317,'S-42 zone 15',''),
(1021,'Coordinate Reference System',28416,7317,'S-42 zone 16',''),
(1022,'Coordinate Reference System',28417,7317,'S-42 zone 17',''),
(1023,'Coordinate Reference System',28418,7317,'S-42 zone 18',''),
(1024,'Coordinate Reference System',28419,7317,'S-42 zone 19',''),
(1025,'Coordinate Reference System',28420,7317,'S-42 zone 20',''),
(1026,'Coordinate Reference System',28421,7317,'S-42 zone 21',''),
(1027,'Coordinate Reference System',28422,7317,'S-42 zone 22',''),
(1028,'Coordinate Reference System',28423,7317,'S-42 zone 23',''),
(1029,'Coordinate Reference System',28424,7317,'S-42 zone 24',''),
(1030,'Coordinate Reference System',28425,7317,'S-42 zone 25',''),
(1031,'Coordinate Reference System',28426,7317,'S-42 zone 26',''),
(1032,'Coordinate Reference System',28427,7317,'S-42 zone 27',''),
(1033,'Coordinate Reference System',28428,7317,'S-42 zone 28',''),
(1034,'Coordinate Reference System',28429,7317,'S-42 zone 29',''),
(1035,'Coordinate Reference System',28430,7317,'S-42 zone 30',''),
(1036,'Coordinate Reference System',28431,7317,'S-42 zone 31',''),
(1037,'Coordinate Reference System',28432,7317,'S-42 zone 32',''),
(1038,'Coordinate Reference System',28462,7302,'Pulkovo / Gauss 2N',''),
(1039,'Coordinate Reference System',28463,7302,'Pulkovo / Gauss 3N',''),
(1040,'Coordinate Reference System',28464,7302,'Pulkovo / Gauss 4N',''),
(1041,'Coordinate Reference System',28465,7302,'Pulkovo / Gauss 5N',''),
(1042,'Coordinate Reference System',28466,7302,'Pulkovo / Gauss 6N',''),
(1043,'Coordinate Reference System',28467,7302,'Pulkovo / Gauss 7N',''),
(1044,'Coordinate Reference System',28468,7302,'Pulkovo / Gauss 8N',''),
(1045,'Coordinate Reference System',28469,7302,'Pulkovo / Gauss 9N',''),
(1046,'Coordinate Reference System',28470,7302,'Pulkovo / Gauss 10N',''),
(1047,'Coordinate Reference System',28471,7302,'Pulkovo / Gauss 11N',''),
(1048,'Coordinate Reference System',28472,7302,'Pulkovo / Gauss 12N',''),
(1049,'Coordinate Reference System',28473,7302,'Pulkovo / Gauss 13N',''),
(1050,'Coordinate Reference System',28474,7302,'Pulkovo / Gauss 14N',''),
(1051,'Coordinate Reference System',28475,7302,'Pulkovo / Gauss 15N',''),
(1052,'Coordinate Reference System',28476,7302,'Pulkovo / Gauss 16N',''),
(1053,'Coordinate Reference System',28477,7302,'Pulkovo / Gauss 17N',''),
(1054,'Coordinate Reference System',28478,7302,'Pulkovo / Gauss 18N',''),
(1055,'Coordinate Reference System',28479,7302,'Pulkovo / Gauss 19N',''),
(1056,'Coordinate Reference System',28480,7302,'Pulkovo / Gauss 20N',''),
(1057,'Coordinate Reference System',28481,7302,'Pulkovo / Gauss 21N',''),
(1058,'Coordinate Reference System',28482,7302,'Pulkovo / Gauss 22N',''),
(1059,'Coordinate Reference System',28483,7302,'Pulkovo / Gauss 23N',''),
(1060,'Coordinate Reference System',28484,7302,'Pulkovo / Gauss 24N',''),
(1061,'Coordinate Reference System',28485,7302,'Pulkovo / Gauss 25N',''),
(1062,'Coordinate Reference System',28486,7302,'Pulkovo / Gauss 26N',''),
(1063,'Coordinate Reference System',28487,7302,'Pulkovo / Gauss 27N',''),
(1064,'Coordinate Reference System',28488,7302,'Pulkovo / Gauss 28N',''),
(1065,'Coordinate Reference System',28489,7302,'Pulkovo / Gauss 29N',''),
(1066,'Coordinate Reference System',28490,7302,'Pulkovo / Gauss 30N',''),
(1067,'Coordinate Reference System',28491,7302,'Pulkovo / Gauss 31N',''),
(1068,'Coordinate Reference System',28492,7302,'Pulkovo / Gauss 32N',''),
(1069,'Coordinate Reference System',28600,7302,'Qatar National Grid',''),
(1070,'Coordinate Reference System',29220,7302,'Sapper Hill / UTM 20S',''),
(1071,'Coordinate Reference System',29221,7302,'Sapper Hill / UTM 21S',''),
(1072,'Coordinate Reference System',29333,7302,'Schwarzeck / UTM 33S',''),
(1073,'Coordinate Reference System',29371,7302,'SW African CS zone 11',''),
(1074,'Coordinate Reference System',29373,7302,'SW African CS zone 13',''),
(1075,'Coordinate Reference System',29375,7302,'SW African CS zone 15',''),
(1076,'Coordinate Reference System',29377,7302,'SW African CS zone 17',''),
(1077,'Coordinate Reference System',29379,7302,'SW African CS zone 19',''),
(1078,'Coordinate Reference System',29381,7302,'SW African CS zone 21',''),
(1079,'Coordinate Reference System',29383,7302,'SW African CS zone 23',''),
(1080,'Coordinate Reference System',29385,7302,'SW African CS zone 25',''),
(1081,'Coordinate Reference System',29700,7302,'Tananarive / Laborde',''),
(1082,'Coordinate Reference System',29738,7302,'Tananarive / UTM 38S',''),
(1083,'Coordinate Reference System',29739,7302,'Tananarive / UTM 39S',''),
(1084,'Coordinate Reference System',29849,7302,'Timbalai 1948 / UTM 49N',''),
(1085,'Coordinate Reference System',29850,7302,'Timbalai 1948 / UTM 50N',''),
(1086,'Coordinate Reference System',29871,7302,'Timbalai / Borneo (ch)',''),
(1087,'Coordinate Reference System',29872,7302,'Timbalai / Borneo (ftSe)',''),
(1088,'Coordinate Reference System',29873,7302,'Timbalai / Borneo (m)',''),
(1089,'Coordinate Reference System',29900,7302,'TM65 / Irish Nat Grid',''),
(1090,'Coordinate Reference System',30161,7302,'Tokyo / Japan zone I',''),
(1091,'Coordinate Reference System',30162,7302,'Tokyo / Japan zone II',''),
(1092,'Coordinate Reference System',30163,7302,'Tokyo / Japan zone III',''),
(1093,'Coordinate Reference System',30164,7302,'Tokyo / Japan zone IV',''),
(1094,'Coordinate Reference System',30165,7302,'Tokyo / Japan zone V',''),
(1095,'Coordinate Reference System',30166,7302,'Tokyo / Japan zone VI',''),
(1096,'Coordinate Reference System',30167,7302,'Tokyo / Japan zone VII',''),
(1097,'Coordinate Reference System',30168,7302,'Tokyo / Japan zone VIII',''),
(1098,'Coordinate Reference System',30169,7302,'Tokyo / Japan zone IX',''),
(1099,'Coordinate Reference System',30170,7302,'Tokyo / Japan zone X',''),
(1100,'Coordinate Reference System',30171,7302,'Tokyo / Japan zone XI',''),
(1101,'Coordinate Reference System',30172,7302,'Tokyo / Japan zone XII',''),
(1102,'Coordinate Reference System',30173,7302,'Tokyo / Japan zone XIII',''),
(1103,'Coordinate Reference System',30174,7302,'Tokyo / Japan zone XIV',''),
(1104,'Coordinate Reference System',30175,7302,'Tokyo / Japan zone XV',''),
(1105,'Coordinate Reference System',30176,7302,'Tokyo / Japan zone XVI',''),
(1106,'Coordinate Reference System',30177,7302,'Tokyo / Japan zone XVII',''),
(1107,'Coordinate Reference System',30178,7302,'Tokyo / Japan zone XVIII',''),
(1108,'Coordinate Reference System',30200,7317,'Trinidad 1903 / Cassini',''),
(1109,'Coordinate Reference System',30491,7302,'Voirol75 / N Algeria old',''),
(1110,'Coordinate Reference System',30492,7302,'Voirol75 / S Algeria old',''),
(1111,'Coordinate Reference System',30729,7302,'Nord Sahara / UTM 29N',''),
(1112,'Coordinate Reference System',30730,7302,'Nord Sahara / UTM 30N',''),
(1113,'Coordinate Reference System',30731,7302,'Nord Sahara / UTM 31N',''),
(1114,'Coordinate Reference System',30732,7302,'Nord Sahara / UTM 32N',''),
(1115,'Coordinate Reference System',30791,7302,'Nord Sahara / N Algerie',''),
(1116,'Coordinate Reference System',30792,7302,'Nord Sahara / S Algerie',''),
(1117,'Coordinate Reference System',31265,7302,'MGI / Gauss zone 5',''),
(1118,'Coordinate Reference System',31266,7302,'MGI / Gauss zone 6',''),
(1119,'Coordinate Reference System',31267,7302,'MGI / Gauss zone 7',''),
(1120,'Coordinate Reference System',31268,7302,'MGI / Gauss zone 8',''),
(1121,'Coordinate Reference System',31291,7302,'MGI / Austria West',''),
(1122,'Coordinate Reference System',31292,7302,'MGI / Austria Central',''),
(1123,'Coordinate Reference System',31293,7302,'MGI / Austria East',''),
(1124,'Coordinate Reference System',31370,7301,'BD 72 / Lambert 72',''),
(1125,'Coordinate Reference System',31461,7302,'DHDN / Gauss zone 1',''),
(1126,'Coordinate Reference System',31462,7302,'DHDN / Gauss zone 2',''),
(1127,'Coordinate Reference System',31463,7302,'DHDN / Gauss zone 3',''),
(1128,'Coordinate Reference System',31464,7302,'DHDN / Gauss zone 4',''),
(1129,'Coordinate Reference System',31465,7302,'DHDN / Gauss zone 5',''),
(1130,'Coordinate Reference System',31600,7317,'Stereo 33',''),
(1131,'Coordinate Reference System',31700,7302,'Stereo 70',''),
(1132,'Coordinate Reference System',32013,7302,'NAD27 / New Mexico Cent.',''),
(1133,'Coordinate Reference System',32018,7302,'NAD27 / New York Long Is',''),
(1134,'Coordinate Reference System',32020,7302,'NAD27 / North Dakota N',''),
(1135,'Coordinate Reference System',32021,7302,'NAD27 / North Dakota S',''),
(1136,'Coordinate Reference System',32028,7302,'NAD27 / Pennsylvania N',''),
(1137,'Coordinate Reference System',32029,7302,'NAD27 / Pennsylvania S',''),
(1138,'Coordinate Reference System',32031,7302,'NAD27 / South Carolina N',''),
(1139,'Coordinate Reference System',32033,7302,'NAD27 / South Carolina S',''),
(1140,'Coordinate Reference System',32034,7302,'NAD27 / South Dakota N',''),
(1141,'Coordinate Reference System',32035,7302,'NAD27 / South Dakota S',''),
(1142,'Coordinate Reference System',32038,7302,'NAD27 / Texas North Cen.',''),
(1143,'Coordinate Reference System',32040,7302,'NAD27 / Texas South Cen.',''),
(1144,'Coordinate Reference System',32050,7302,'NAD27 / West Virginia N',''),
(1145,'Coordinate Reference System',32051,7302,'NAD27 / West Virginia S',''),
(1146,'Coordinate Reference System',32053,7302,'NAD27 / Wisconsin Cen.',''),
(1147,'Coordinate Reference System',32056,7302,'NAD27 / Wyoming E. Cen.',''),
(1148,'Coordinate Reference System',32057,7302,'NAD27 / Wyoming W. Cen.',''),
(1149,'Coordinate Reference System',32113,7302,'NAD83 / New Mexico Cent.',''),
(1150,'Coordinate Reference System',32118,7302,'NAD83 / New York Long Is',''),
(1151,'Coordinate Reference System',32120,7302,'NAD83 / North Dakota N',''),
(1152,'Coordinate Reference System',32121,7302,'NAD83 / North Dakota S',''),
(1153,'Coordinate Reference System',32128,7302,'NAD83 / Pennsylvania N',''),
(1154,'Coordinate Reference System',32129,7302,'NAD83 / Pennsylvania S',''),
(1155,'Coordinate Reference System',32134,7302,'NAD83 / South Dakota N',''),
(1156,'Coordinate Reference System',32135,7302,'NAD83 / South Dakota S',''),
(1157,'Coordinate Reference System',32138,7302,'NAD83 / Texas North Cen.',''),
(1158,'Coordinate Reference System',32140,7302,'NAD83 / Texas South Cen.',''),
(1159,'Coordinate Reference System',32150,7302,'NAD83 / West Virginia N',''),
(1160,'Coordinate Reference System',32151,7302,'NAD83 / West Virginia S',''),
(1161,'Coordinate Reference System',32153,7302,'NAD83 / Wisconsin Cen.',''),
(1162,'Coordinate Reference System',32156,7302,'NAD83 / Wyoming E. Cen.',''),
(1163,'Coordinate Reference System',32157,7302,'NAD83 / Wyoming W. Cen.',''),
(1166,'Unit of Measure',9003,7306,'ft[US]',''),
(1167,'Unit of Measure',9005,7306,'ft[Cla]',''),
(1168,'Unit of Measure',9014,7306,'fathom',''),
(1169,'Unit of Measure',9030,7306,'mi[naut]',''),
(1170,'Unit of Measure',9031,7306,'m[Ger]',''),
(1171,'Unit of Measure',9033,7306,'chain[US]',''),
(1172,'Unit of Measure',9034,7306,'link[US]',''),
(1173,'Unit of Measure',9035,7306,'mi[US]',''),
(1174,'Datum',1161,7302,'DHHN12',''),
(1175,'Unit of Measure',9037,7306,'yd[Cla]',''),
(1176,'Unit of Measure',9038,7306,'chain[Cla]',''),
(1177,'Unit of Measure',9039,7306,'link[Cla]',''),
(1178,'Unit of Measure',9040,7306,'yd[Se]',''),
(1179,'Unit of Measure',9041,7306,'ft[Se]',''),
(1180,'Unit of Measure',9042,7306,'chain[Se]',''),
(1181,'Unit of Measure',9043,7306,'link[Se]',''),
(1182,'Unit of Measure',9050,7306,'yd[BnA]',''),
(1183,'Unit of Measure',9051,7306,'ft[BnA]',''),
(1184,'Unit of Measure',9052,7306,'chain[BnA]',''),
(1185,'Unit of Measure',9053,7306,'link[BnA]',''),
(1186,'Unit of Measure',9060,7306,'yd[BnB]',''),
(1187,'Unit of Measure',9061,7306,'ft[BnB]',''),
(1188,'Unit of Measure',9062,7306,'chain[BnB]',''),
(1189,'Unit of Measure',9063,7306,'link[BnB]',''),
(1190,'Unit of Measure',9070,7306,'ft[Br65]',''),
(1191,'Unit of Measure',9080,7306,'ft[Ind]',''),
(1192,'Unit of Measure',9081,7306,'ft[Ind37]',''),
(1193,'Unit of Measure',9082,7306,'ft[Ind62]',''),
(1194,'Unit of Measure',9083,7306,'ft[Ind75]',''),
(1195,'Unit of Measure',9084,7306,'yd[Ind]',''),
(1196,'Unit of Measure',9085,7306,'yd[Ind37]',''),
(1197,'Unit of Measure',9086,7306,'yd[Ind62]',''),
(1198,'Unit of Measure',9087,7306,'yd[Ind75]',''),
(1199,'Unit of Measure',9093,1041,'mi',''),
(1200,'Unit of Measure',9094,7306,'ft[GC]',''),
(1201,'Datum',1161,7301,'Deutsches Haupthhennetz 1912',''),
(1202,'Unit of Measure',9102,7306,'dega',''),
(1203,'Unit of Measure',9103,7306,'mina',''),
(1204,'Unit of Measure',9104,7306,'seca',''),
(1205,'Unit of Measure',9105,7306,'gon',''),
(1206,'Unit of Measure',9106,7306,'gon',''),
(1207,'Datum',1162,7302,'LAS-2000',''),
(1208,'Datum',1159,7302,'GSK-2011',''),
(1209,'Unit of Measure',9109,7306,'urad',''),
(1210,'Datum',1159,7301,'GRS-2011',''),
(1211,'Coordinate_Operation',7723,7302,'Andhra Pradesh',''),
(1212,'Unit of Measure',9112,7306,'cgr',''),
(1213,'Unit of Measure',9113,7306,'ccgr',''),
(1214,'Unit of Measure',9114,7306,'mila',''),
(1215,'Coordinate_Operation Method',9824,7302,'UTM grid system',''),
(1216,'Coordinate Reference System',4143,7301,'Cte d''Ivoire','Same alias is ambiguous as also applied to Locodjo 1965 (code 4142).'),
(1217,'Coordinate Reference System',4143,7301,'Port Bouet','Same alias is ambiguous as also applied to Locodjo 1965 (code 4142).'),
(1218,'Coordinate Reference System',4142,7301,'Port Bouet','Same alias is ambiguous as also applied to Abidjan 1987 (code 4143).'),
(1219,'Coordinate Reference System',4142,7301,'Cte d''Ivoire','Same alias is ambiguous as also applied to Abidjan 1987 (code 4143).'),
(1220,'Coordinate Reference System',2164,7301,'Cote d''Ivoire / TM 5 NW','Same alias is ambiguous as used for Abidjan 1987 / TM 5 NW (code 2165).'),
(1221,'Coordinate Reference System',2164,7301,'Port Bouet / TM 5 NW','Same alias is ambiguous as used for Abidjan 1987 / TM 5 NW (code 2165).'),
(1222,'Coordinate Reference System',2165,7301,'Cote d''Ivoire / TM 5 NW','Same alias is ambiguous as used for Locodjo 1965 / TM 5 NW (code 2164).'),
(1223,'Coordinate Reference System',2165,7301,'Port Bouet / TM 5 NW','Same alias is ambiguous as used for Abidjan 1987 / TM 5 NW (code 2165).'),
(1224,'Coordinate_Operation',1588,7301,'ED50 to EUREF89 (1)',''),
(1225,'Coordinate_Operation',1588,7301,'ED50 to ETRF89 (1)',''),
(1226,'Coordinate_Operation',6739,7301,'NAD27 to NAD83(HPGN) (22)',''),
(1227,'Coordinate_Operation',1589,7301,'ED50 to EUREF89 (3)',''),
(1228,'Coordinate Reference System',6696,7302,'JGD2000',''),
(1229,'Datum',6181,7301,'LUREF',''),
(1230,'Datum',6180,7302,'EST97',''),
(1231,'Datum',6179,7307,'42/58',''),
(1232,'Datum',6178,7307,'42/83',''),
(1233,'Datum',1031,7308,'HR1901',''),
(1234,'Coordinate Reference System',6697,7302,'JGD2011',''),
(1235,'Coordinate_Operation Method',9807,7301,'Gauss-Kruger',''),
(1236,'Coordinate_Operation Method',9807,7302,'TM',''),
(1237,'Datum',6818,7300,'Systm Jednotn Trigonometrick Ste Katastrln (Ferro)',''),
(1238,'Coordinate Reference System',2393,7301,'KKJ / Basic Coordinate System zone 3',''),
(1239,'Coordinate Reference System',2391,7301,'KKJ / Basic Coordinate System zone 1',''),
(1240,'Coordinate Reference System',2392,7301,'KKJ / Basic Coordinate System zone 2',''),
(1241,'Coordinate Reference System',2394,7301,'KKJ / Basic Coordinate System zone 4',''),
(1242,'Coordinate Reference System',31467,7310,'DHDN / Gauss-Kruger zone 3',''),
(1243,'Coordinate Reference System',31468,7310,'DHDN / Gauss-Kruger zone 4',''),
(1244,'Coordinate Reference System',31469,7310,'DHDN / Gauss-Kruger zone 5',''),
(1245,'Coordinate Reference System',6787,7302,'NAD83(2011) / OCRS_BKE (ft)',''),
(1246,'Coordinate Reference System',6786,7302,'NAD83(2011) / OCRS_BKE (m)',''),
(1247,'Coordinate Reference System',4178,7307,'42/83',''),
(1248,'Coordinate Reference System',31466,7310,'DHDN / Gauss-Kruger zone 2',''),
(1249,'Coordinate Reference System',2166,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3',''),
(1250,'Coordinate Reference System',2167,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4',''),
(1251,'Coordinate Reference System',4181,7301,'LUREF',''),
(1252,'Coordinate Reference System',6791,7302,'NAD83(2011) / OCRS_BKF (ft)',''),
(1253,'Coordinate Reference System',4258,7301,'EUREF89',''),
(1254,'Coordinate Reference System',2180,7301,'EUREF89 / CS92',''),
(1255,'Coordinate Reference System',3906,7308,'HR1901',''),
(1256,'Coordinate Reference System',6795,7302,'NAD83(2011) / OCRS_BRP (ft)',''),
(1257,'Coordinate Reference System',6794,7302,'NAD83(2011) / OCRS_BRP (m)',''),
(1258,'Coordinate Reference System',6803,7302,'NAD83(2011) / OCRS_CGP (ft)',''),
(1259,'Coordinate Reference System',31275,7308,'HDKS zone 5','HDKS = Hrvatski Drzavni Koordinatni Sustav'),
(1260,'Coordinate Reference System',31276,7308,'HDKS zone 6','HDKS = Hrvatski Drzavni Koordinatni Sustav'),
(1261,'Coordinate Reference System',31275,7309,'D48 zone 5',''),
(1262,'Coordinate Reference System',2169,7301,'LUREF / Gauss',''),
(1263,'Coordinate Reference System',3396,7301,'DHDN / 3GK zone 3','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(1264,'Coordinate Reference System',3397,7301,'DHDN / 3GK zone 4','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(1265,'Coordinate Reference System',3398,7301,'DHDN / Gauss-Kruger zone 4','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(1266,'Coordinate Reference System',3399,7301,'DHDN / Gauss-Kruger zone 5','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(1267,'Coordinate_Operation',1620,7308,'HR1901 to ETRS89 (2)',''),
(1268,'Coordinate_Operation',1619,7307,'AT_MGI to ETRS89','EuroGeographics quote this transformation with reduced precision to the translation and scale difference parameter values.'),
(1269,'Coordinate_Operation',1622,7307,'CZ_S-JTSK to ETRS89',''),
(1270,'Coordinate_Operation',1620,7307,'HR_HDKS to ETRS89',''),
(1271,'Coordinate_Operation',1624,7307,'SK_S-JTSK to ETRS89',''),
(1272,'Coordinate_Operation',1626,7307,'DK_ED50 to ETRS89',''),
(1273,'Coordinate_Operation',1628,7307,'GI_ED50 to ETRS89',''),
(1274,'Coordinate_Operation',1630,7307,'ES_ED50 (BAL99) to ETRS89',''),
(1275,'Coordinate_Operation',1632,7307,'ES_ED50 (EST99) to ETRS89',''),
(1276,'Coordinate_Operation',1634,7307,'ES_ED50 (ZNW99) to ETRS89',''),
(1277,'Coordinate_Operation',1783,7307,'TR_ED50 to ETRS89',''),
(1278,'Coordinate_Operation',1638,7307,'FI_KKJ to ETRS89',''),
(1279,'Coordinate_Operation',1640,7307,'IE_Ireland65 to ETRS89','IE_Ireland65 to ETRS89 applies to the Republic of Ireland. Also referred to in EuroGeographics as NI_Ireland65 to ETRS89 for Northern Ireland.'),
(1280,'Coordinate_Operation',1642,7307,'LU_LUREF to ETRS89',''),
(1281,'Coordinate_Operation',1644,7307,'PL_42/58 to ETRS89',''),
(1282,'Coordinate_Operation',1646,7307,'CH_CH1903 to ETRS89','EuroGeographics rounds the parameter values to decimetre resolution to reflect accuracy of CH1903 network.'),
(1283,'Coordinate_Operation',1647,7307,'CH_CH1903+ to ETRS89',''),
(1284,'Coordinate_Operation',1648,7307,'EE_L-EST97 to ETRS89',''),
(1285,'Coordinate_Operation',1650,7307,'FR_ED50 to ETRS89',''),
(1286,'Coordinate_Operation',1651,7307,'FR_NTF to ETRS89',''),
(1287,'Coordinate_Operation',1653,7307,'NO_NGO1948 to ETRS89',''),
(1288,'Coordinate_Operation',1657,7307,'PT_D73 to ETRS89',''),
(1289,'Coordinate_Operation',1655,7307,'PT_DLX(HAY) to ETRS89',''),
(1290,'Coordinate_Operation',1652,7307,'BE_BD72 to ETRS89',''),
(1291,'Coordinate Reference System',31282,7302,'MGI (Ferro) / Austria C',''),
(1292,'Coordinate Reference System',31283,7302,'MGI (Ferro) / Austria E',''),
(1293,'Coordinate Reference System',31281,7302,'MGI (Ferro) / Austria W',''),
(1294,'Datum',6176,7302,'AAD98',''),
(1295,'Coordinate Reference System',4176,7302,'AAD98',''),
(1296,'Datum',6167,7302,'NZGD2000',''),
(1297,'Coordinate Reference System',2193,7301,'NZGD2000 / NZTM',''),
(1298,'Coordinate_Operation',19971,7301,'NZTM',''),
(1299,'Coordinate Reference System',6802,7302,'NAD83(2011) / OCRS_CGP (m)',''),
(1300,'Datum',5119,7301,'Nivellement general de la France','This alias is also used for other datum realisations: see NGF - Lallemand (code 5118) and NGF - IGN78 (code 5120).'),
(1301,'Datum',5119,7301,'NGF','This alias is also used for other datum realisations: see NGF - Lallemand (code 5118) and NGF - IGN78 (code 5120).'),
(1302,'Datum',5120,7301,'IGN78',''),
(1303,'Datum',5118,7301,'NGF','This alias is also used for other datum realisations: see NGF - IGN69 (code 5119) and NGF - IGN78 (code 5120).'),
(1304,'Datum',5120,7301,'Nivellement general de la France','This alias is also used for other datum realisations: see NGF - Lallemand (code 5118) and NGF - IGN69 (code 5119).'),
(1305,'Datum',5118,7301,'Nivellement general de la France','This alias is also used for other datum realisations: see NGF - IGN69 (code 5119) and NGF - IGN78 (code 5120).'),
(1306,'Datum',6143,7301,'Cte d''Ivoire (Ivory Coast)','This alias is not unique: it is also used for code 6142.'),
(1307,'Datum',6142,7301,'Cte d''Ivoire (Ivory Coast)','This alias is not unique: it is also used for code 6143.'),
(1308,'Coordinate Reference System',4300,7301,'1975 Mapping Adjustment',''),
(1309,'Coordinate Reference System',2196,7301,'EUREF89 / Kp2000 Jutland',''),
(1310,'Coordinate Reference System',2196,7301,'System 2000 Jylland zoner',''),
(1311,'Coordinate Reference System',2197,7301,'EUREF89 / Kp2000 Zealand',''),
(1312,'Coordinate Reference System',2197,7301,'System 2000 Sjaelland zoner',''),
(1313,'Coordinate Reference System',2198,7301,'EUREF89 / Kp2000 Bornholm',''),
(1314,'Coordinate Reference System',2198,7301,'System 2000 Bornholm zoner',''),
(1315,'Datum',6189,7301,'SIRGAS-REGVEN',''),
(1316,'Datum',6189,7302,'REGVEN',''),
(1317,'Datum',6171,7300,'Rseau Godsique Franais 1993',''),
(1318,'Datum',6172,7300,'Posiciones Geodsicas Argentinas',''),
(1319,'Coordinate Reference System',6807,7302,'NAD83(2011) / OCRS_CRE (ft)',''),
(1320,'Coordinate Reference System',6810,7302,'NAD83(2011) / OCRS_CRW (m)',''),
(1321,'Coordinate Reference System',6811,7302,'NAD83(2011) / OCRS_CRW (ft)',''),
(1322,'Coordinate_Operation',15304,7302,'Arizona East (ft)',''),
(1323,'Coordinate_Operation',15305,7302,'Arizona Central (ft)',''),
(1324,'Coordinate_Operation',15306,7302,'Arizona West (ft)',''),
(1325,'Coordinate_Operation',15307,7302,'California zone 1 (ftUS)',''),
(1326,'Coordinate_Operation',15308,7302,'California zone 2 (ftUS)',''),
(1327,'Coordinate_Operation',15309,7302,'California zone 3 (ftUS)',''),
(1328,'Coordinate_Operation',15310,7302,'California zone 4 (ftUS)',''),
(1329,'Coordinate_Operation',15311,7302,'California zone 5 (ftUS)',''),
(1330,'Coordinate_Operation',15312,7302,'California zone 6 (ftUS)',''),
(1331,'Coordinate_Operation',15313,7302,'Colorado North (ftUS)',''),
(1332,'Coordinate_Operation',15314,7302,'Colorado Central (ftUS)',''),
(1333,'Coordinate_Operation',15315,7302,'Colorado South (ftUS)',''),
(1334,'Coordinate_Operation',15316,7301,'Connecticut (ftUS)',''),
(1335,'Coordinate_Operation',15317,7302,'Delaware (ftUS)',''),
(1336,'Coordinate_Operation',15318,7301,'Florida East (ftUS)',''),
(1337,'Coordinate_Operation',15319,7302,'Florida West (ftUS)',''),
(1338,'Coordinate_Operation',15320,7302,'Florida North (ftUS)',''),
(1339,'Coordinate_Operation',15321,7302,'Georgia East (ftUS)',''),
(1340,'Coordinate_Operation',15322,7302,'Georgia West (ftUS)',''),
(1341,'Coordinate_Operation',15323,7302,'Idaho East (ftUS)',''),
(1342,'Coordinate_Operation',15324,7302,'Idaho Central (ftUS)',''),
(1343,'Coordinate_Operation',15325,7302,'Idaho West (ftUS)',''),
(1344,'Coordinate_Operation',15326,7302,'Indiana East (ftUS)',''),
(1345,'Coordinate_Operation',15327,7302,'Indiana West (ftUS)',''),
(1346,'Coordinate_Operation',15328,7302,'Kentucky North (ftUS)',''),
(1347,'Coordinate_Operation',15329,7302,'Kentucky South (ftUS)',''),
(1348,'Coordinate_Operation',15330,7302,'Maryland (ftUS)',''),
(1349,'Coordinate_Operation',15331,7302,'Massachusetts Mainland (ftUS)',''),
(1350,'Coordinate_Operation',15332,7302,'Massachusetts Island (ftUS)',''),
(1351,'Coordinate_Operation',15333,7302,'Michigan North (ft)',''),
(1352,'Coordinate_Operation',15334,7302,'Michigan Central (ft)',''),
(1353,'Coordinate_Operation',15335,7302,'Michigan South (ft)',''),
(1354,'Coordinate_Operation',15336,7302,'Mississippi East (ftUS)',''),
(1355,'Coordinate_Operation',15337,7302,'Mississippi West (ftUS)',''),
(1356,'Coordinate_Operation',15338,7301,'Montana (ftUS)',''),
(1357,'Coordinate_Operation',15339,7302,'New Mexico East (ftUS)',''),
(1358,'Coordinate_Operation',15340,7302,'New Mexico Central (ftUS)',''),
(1359,'Coordinate_Operation',15341,7302,'New Mexico West (ftUS)',''),
(1360,'Coordinate_Operation',15342,7302,'New York East (ftUS)',''),
(1361,'Coordinate_Operation',15343,7302,'New York Central (ftUS)',''),
(1362,'Coordinate_Operation',15344,7302,'New York West (ftUS)',''),
(1363,'Coordinate_Operation',15345,7302,'New York Long Island (ftUS)',''),
(1364,'Coordinate_Operation',15346,7302,'North Carolina (ftUS)',''),
(1365,'Coordinate_Operation',15347,7302,'North Dakota North (ft)',''),
(1366,'Coordinate_Operation',15348,7302,'North Dakota South (ft)',''),
(1367,'Coordinate_Operation',15349,7302,'Oklahoma North (ftUS)',''),
(1368,'Coordinate_Operation',15350,7302,'Oklahoma South (ftUS)',''),
(1369,'Coordinate_Operation',15351,7302,'Oregon North (ft)',''),
(1370,'Coordinate_Operation',15352,7302,'Oregon South (ft)',''),
(1371,'Coordinate_Operation',15353,7302,'Pennsylvania North (ftUS)',''),
(1372,'Coordinate_Operation',15354,7301,'Pennsylvania South (ftUS)',''),
(1373,'Coordinate_Operation',15355,7302,'South Carolina (ft)',''),
(1374,'Coordinate_Operation',15356,7302,'Tennessee (ftUS)',''),
(1375,'Coordinate_Operation',15357,7302,'Texas North (ftUS)',''),
(1376,'Coordinate_Operation',15358,7302,'Texas North Central (ftUS)',''),
(1377,'Coordinate_Operation',15359,7302,'Texas Central (ftUS)',''),
(1378,'Coordinate_Operation',15360,7302,'Texas South Central (ftUS)',''),
(1379,'Coordinate_Operation',15361,7302,'Texas South (ftUS)',''),
(1380,'Coordinate_Operation',15362,7302,'Utah North (ft)',''),
(1381,'Coordinate_Operation',15363,7302,'Utah Central (ft)',''),
(1382,'Coordinate_Operation',15364,7302,'Utah South (ft)',''),
(1383,'Coordinate_Operation',15365,7302,'Virginia North (ftUS)',''),
(1384,'Coordinate_Operation',15366,7302,'Virginia South (ftUS)',''),
(1385,'Coordinate_Operation',15367,7302,'Washington North (ftUS)',''),
(1386,'Coordinate_Operation',15368,7302,'Washington South (ftUS)',''),
(1387,'Coordinate_Operation',15369,7302,'Wisconsin North (ftUS)',''),
(1388,'Coordinate_Operation',15370,7302,'Wisconsin Central (ftUS)',''),
(1389,'Coordinate_Operation',15371,7302,'Wisconsin South (ftUS)',''),
(1390,'Datum',6190,7302,'POSGAR 98',''),
(1391,'Datum',6190,7300,'Posiciones Geodsicas Argentinas 1998',''),
(1392,'Coordinate Reference System',4190,7301,'National Geodetic System [Argentina]','See information source.'),
(1393,'Datum',6182,7301,'Observatario Flores',''),
(1394,'Datum',6182,7302,'Azores Occidental 1939',''),
(1395,'Datum',6183,7301,'Graciosa','The same name is also used for the 1995 adjustment (see datum code 6665).'),
(1396,'Datum',6183,7302,'Azores Central 1948',''),
(1397,'Datum',6184,7301,'Sao Bras','The same name is also used for the 1995 adjustment (see datum code 6664).'),
(1398,'Datum',6184,7302,'Azores Oriental 1940',''),
(1399,'Coordinate Reference System',6806,7302,'NAD83(2011) / OCRS_CRE (m)',''),
(1400,'Coordinate Reference System',4183,7301,'Graciosa','The same name is also used for the 1995 adjustment (see CRS code 4665).'),
(1401,'Coordinate Reference System',4184,7301,'Sao Braz','The same name is also used for the 1995 adjustment (see CRS code 4664).'),
(1402,'Coordinate_Operation',18084,7301,'France zone IV',''),
(1403,'Coordinate_Operation',18083,7301,'France zone III',''),
(1404,'Coordinate_Operation',18082,7301,'France zone II',''),
(1405,'Coordinate_Operation',18081,7301,'France zone I',''),
(1406,'Coordinate_Operation',18093,7301,'Sud France',''),
(1407,'Coordinate_Operation',18094,7301,'Corse',''),
(1408,'Coordinate_Operation',18092,7301,'Centre France',''),
(1409,'Coordinate_Operation',18091,7301,'Nord France',''),
(1410,'Coordinate Reference System',27561,7317,'NTF (Paris) / Nord France',''),
(1411,'Coordinate Reference System',27562,7317,'NTF (Paris) / Cen France',''),
(1412,'Coordinate Reference System',27563,7317,'NTF (Paris) / Sud France',''),
(1413,'Coordinate Reference System',27564,7317,'NTF (Paris) / Corse',''),
(1414,'Coordinate Reference System',27571,7317,'NTF (Paris) / France I',''),
(1415,'Coordinate Reference System',27572,7317,'NTF (Paris) / France II',''),
(1416,'Coordinate Reference System',27573,7317,'NTF (Paris) / France III',''),
(1417,'Coordinate Reference System',27574,7317,'NTF (Paris) / France IV',''),
(1418,'Coordinate Reference System',27572,7301,'NTF (Paris) / Lambert zone II etendu',''),
(1419,'Datum',6156,7300,'Systm Jednotn Trigonometrick Ste Katastrln',''),
(1420,'Coordinate Reference System',6815,7302,'NAD83(2011) / OCRS_CGC (ft)',''),
(1421,'Coordinate_Operation',1751,7301,'Amersfoort to ETRF89 (1)',''),
(1422,'Coordinate Reference System',2168,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5',''),
(1423,'Coordinate_Operation',15302,7302,'Tennessee','This alias is ambiguous as also used for SPCS83 projection.'),
(1424,'Coordinate_Operation',16269,7302,'3-degree Gauss zone 9',''),
(1425,'Coordinate_Operation',16270,7302,'3-degree Gauss zone 10',''),
(1426,'Coordinate_Operation',16271,7302,'3-degree Gauss zone 11',''),
(1427,'Coordinate_Operation',16272,7302,'3-degree Gauss zone 12',''),
(1428,'Coordinate_Operation',16273,7302,'3-degree Gauss zone 13',''),
(1429,'Coordinate_Operation',16274,7302,'3-degree Gauss zone 14',''),
(1430,'Coordinate_Operation',16275,7302,'3-degree Gauss zone 15',''),
(1431,'Datum',6123,7300,'Kartastokoordinaattijrjestelm (1966)',''),
(1432,'Coordinate Reference System',2206,7317,'ED50 / Turkey zone 9',''),
(1433,'Coordinate Reference System',2207,7317,'ED50 / Turkey zone 10',''),
(1434,'Coordinate Reference System',2208,7317,'ED50 / Turkey zone 11',''),
(1435,'Coordinate Reference System',2209,7317,'ED50 / Turkey zone 12',''),
(1436,'Coordinate Reference System',2210,7317,'ED50 / Turkey zone 13',''),
(1437,'Coordinate Reference System',2211,7317,'ED50 / Turkey zone 14',''),
(1438,'Coordinate Reference System',2212,7317,'ED50 / Turkey zone 15',''),
(1439,'Coordinate Reference System',6814,7302,'NAD83(2011) / OCRS_CGC (m)',''),
(1440,'Coordinate Reference System',2189,7301,'Graciosa / UTM zone 26N','The same name is also used for the 1995 adjustment (see CRS code 3063).'),
(1441,'Coordinate Reference System',2190,7301,'Sao Braz / UTM zone 26N','The same name is also used for the 1995 adjustment (see CRS code 3062).'),
(1442,'Coordinate_Operation',1781,7310,'PD/83 to ETRS89',''),
(1443,'Coordinate_Operation',1782,7310,'RD/83 to ETRS89',''),
(1444,'Coordinate Reference System',4207,7301,'Lisbon 1937',''),
(1445,'Coordinate Reference System',4803,7301,'Lisbon 1937 (Lisbon)',''),
(1446,'Coordinate Reference System',20791,7301,'Lisbon 1937 (Lisbon) / Portuguese Grid',''),
(1447,'Coordinate Reference System',20790,7301,'Lisbon 1937 (Lisbon)/Portuguese National Grid',''),
(1448,'Coordinate_Operation',18411,7301,'Afrique Occidentale Franaise Senegal zone',''),
(1449,'Coordinate_Operation',18412,7301,'Afrique Occidentale Franaise Cte d''Ivoire zone',''),
(1450,'Coordinate_Operation',18413,7301,'Afrique Occidentale Franaise Dahomey zone',''),
(1451,'Coordinate_Operation',18415,7301,'Afrique Equatoriale Franaise ouest zone',''),
(1452,'Coordinate_Operation',18416,7301,'Afrique Equatoriale Franaise centrale zone',''),
(1453,'Coordinate_Operation',18417,7301,'Afrique Equatoriale Franaise est zone',''),
(1454,'Coordinate_Operation',18414,7301,'Afrique Occidentale Franaise Niger zone',''),
(1455,'Coordinate_Operation',18411,7302,'AOF Senegal zone',''),
(1456,'Coordinate_Operation',18412,7302,'AOF Cte d''Ivoire zone',''),
(1457,'Coordinate_Operation',18413,7302,'AOF Dahomey zone',''),
(1458,'Coordinate_Operation',18414,7302,'AOF Niger zone',''),
(1459,'Coordinate_Operation',18415,7302,'AEF west',''),
(1460,'Coordinate_Operation',18416,7302,'AEF central',''),
(1461,'Coordinate_Operation',18417,7302,'AEF east',''),
(1462,'Coordinate Reference System',6819,7302,'NAD83(2011) / OCRS_DFM (ft)',''),
(1463,'Coordinate Reference System',6818,7302,'NAD83(2011) / OCRS_DFM (m)',''),
(1464,'Coordinate_Operation',1469,7301,'Cte d''Ivoire to WGS 84 (1)','Same alias also applied to Abidjan 1987 to WGS 84 (1) (code 1470).'),
(1465,'Coordinate_Operation',1469,7301,'Port Bouet to WGS 84 (1)','Same alias also applied to Abidjan 1987 to WGS 84 (1) (code 1470).'),
(1466,'Coordinate_Operation',1470,7301,'Cte d''Ivoire to WGS 84 (1)','Same alias also applied to Locodjo 1965 to WGS 84 (1) (code 1469).'),
(1467,'Coordinate_Operation',1470,7301,'Port Bouet to WGS 84 (1)','Same alias also applied to Locodjo 1965 to WGS 84 (1) (code 1469).'),
(1468,'Coordinate Reference System',2040,7301,'Port Bouet / UTM zone 30N','Same alias used for Abidjan 1987 / UTM zone 30N (code 2041).'),
(1469,'Coordinate Reference System',2040,7301,'Cte d''Ivoire / UTM zone 30N','Same alias used for Abidjan 1987 / UTM zone 30N (code 2041).'),
(1470,'Coordinate Reference System',2041,7301,'Port Bouet / UTM zone 30N','Same alias used for Locodjo 1965 / UTM zone 30N (code 2040).'),
(1471,'Coordinate Reference System',2041,7301,'Cte d''Ivoire / UTM zone 30N','Same alias used for Locodjo 1965 / UTM zone 30N (code 2040).'),
(1472,'Coordinate Reference System',2042,7301,'Port Bouet / UTM zone 29N','Same alias used for Abidjan 1987 / UTM zone 29N (code 2043).'),
(1473,'Coordinate Reference System',2042,7301,'Cte d''Ivoire / UTM zone 29N','Same alias used for Abidjan 1987 / UTM zone 29N (code 2043).'),
(1474,'Coordinate Reference System',2043,7301,'Port Bouet / UTM zone 29N','Same alias used for Locodjo 1965 / UTM zone 29N (code 2042).'),
(1475,'Coordinate Reference System',2043,7301,'Cte d''Ivoire / UTM zone 29N','Same alias used for Locodjo 1965 / UTM zone 29N (code 2042).'),
(1476,'Coordinate Reference System',6823,7302,'NAD83(2011) / OCRS_EUG (ft)',''),
(1477,'Coordinate Reference System',6822,7302,'NAD83(2011) / OCRS_EUG (m)',''),
(1478,'Coordinate Reference System',6827,7302,'NAD83(2011) / OCRS_GPA (ft)',''),
(1479,'Coordinate_Operation',18421,7301,'Greenland zone 1 west',''),
(1480,'Coordinate_Operation',18428,7301,'Greenland zone 8 west',''),
(1481,'Coordinate Reference System',2297,7301,'Qornoq 1927 / Greenland zone 1 west',''),
(1482,'Coordinate Reference System',2307,7301,'Qornoq 1927 / Greenland zone 8 west',''),
(1483,'Coordinate Reference System',32113,7301,'NAD83 / New Mexico Central (m)',''),
(1484,'Coordinate Reference System',26949,7301,'NAD83 / Arizona Central (m)',''),
(1485,'Coordinate Reference System',26929,7301,'NAD83 / Alabama East (m)',''),
(1486,'Coordinate Reference System',26930,7301,'NAD83 / Alabama West (m)',''),
(1487,'Coordinate Reference System',26931,7301,'NAD83 / Alaska zone 1 (m)',''),
(1488,'Coordinate Reference System',26940,7301,'NAD83 / Alaska zone 10 (m)',''),
(1489,'Coordinate Reference System',26932,7301,'NAD83 / Alaska zone 2 (m)',''),
(1490,'Coordinate Reference System',26933,7301,'NAD83 / Alaska zone 3 (m)',''),
(1491,'Coordinate Reference System',26934,7301,'NAD83 / Alaska zone 4 (m)',''),
(1492,'Coordinate Reference System',26935,7301,'NAD83 / Alaska zone 5 (m)',''),
(1493,'Coordinate Reference System',26936,7301,'NAD83 / Alaska zone 6 (m)',''),
(1494,'Coordinate Reference System',26937,7301,'NAD83 / Alaska zone 7 (m)',''),
(1495,'Coordinate Reference System',26938,7301,'NAD83 / Alaska zone 8 (m)',''),
(1496,'Coordinate Reference System',26939,7301,'NAD83 / Alaska zone 9 (m)',''),
(1497,'Coordinate Reference System',26948,7301,'NAD83 / Arizona East (m)',''),
(1498,'Coordinate Reference System',26950,7301,'NAD83 / Arizona West (m)',''),
(1499,'Coordinate Reference System',26951,7301,'NAD83 / Arkansas North (m)',''),
(1500,'Coordinate Reference System',26952,7301,'NAD83 / Arkansas South (m)',''),
(1501,'Coordinate Reference System',26941,7301,'NAD83 / California zone 1 (m)',''),
(1502,'Coordinate Reference System',26942,7301,'NAD83 / California zone 2 (m)',''),
(1503,'Coordinate Reference System',26943,7301,'NAD83 / California zone 3 (m)',''),
(1504,'Coordinate Reference System',26944,7301,'NAD83 / California zone 4 (m)',''),
(1505,'Coordinate Reference System',26945,7301,'NAD83 / California zone 5 (m)',''),
(1506,'Coordinate Reference System',26946,7301,'NAD83 / California zone 6 (m)',''),
(1507,'Coordinate Reference System',26954,7301,'NAD83 / Colorado Central (m)',''),
(1508,'Coordinate Reference System',26953,7301,'NAD83 / Colorado North (m)',''),
(1509,'Coordinate Reference System',26955,7301,'NAD83 / Colorado South (m)',''),
(1510,'Coordinate Reference System',26956,7301,'NAD83 / Connecticut (m)',''),
(1511,'Coordinate Reference System',26957,7301,'NAD83 / Delaware (m)',''),
(1512,'Coordinate Reference System',26958,7301,'NAD83 / Florida East (m)',''),
(1513,'Coordinate Reference System',26960,7301,'NAD83 / Florida North (m)',''),
(1514,'Coordinate Reference System',26959,7301,'NAD83 / Florida West (m)',''),
(1515,'Coordinate Reference System',26966,7301,'NAD83 / Georgia East (m)',''),
(1516,'Coordinate Reference System',26967,7301,'NAD83 / Georgia West (m)',''),
(1517,'Coordinate Reference System',26961,7301,'NAD83 / Hawaii zone 1 (m)',''),
(1518,'Coordinate Reference System',26962,7301,'NAD83 / Hawaii zone 2 (m)',''),
(1519,'Coordinate Reference System',26963,7301,'NAD83 / Hawaii zone 3 (m)',''),
(1520,'Coordinate Reference System',26964,7301,'NAD83 / Hawaii zone 4 (m)',''),
(1521,'Coordinate Reference System',26965,7301,'NAD83 / Hawaii zone 5 (m)',''),
(1522,'Coordinate Reference System',26969,7301,'NAD83 / Idaho Central (m)',''),
(1523,'Coordinate Reference System',26968,7301,'NAD83 / Idaho East (m)',''),
(1524,'Coordinate Reference System',26970,7301,'NAD83 / Idaho West (m)',''),
(1525,'Coordinate Reference System',26971,7301,'NAD83 / Illinois East (m)',''),
(1526,'Coordinate Reference System',26972,7301,'NAD83 / Illinois West (m)',''),
(1527,'Coordinate Reference System',26973,7301,'NAD83 / Indiana East (m)',''),
(1528,'Coordinate Reference System',26974,7301,'NAD83 / Indiana West (m)',''),
(1529,'Coordinate Reference System',26975,7301,'NAD83 / Iowa North (m)',''),
(1530,'Coordinate Reference System',26976,7301,'NAD83 / Iowa South (m)',''),
(1531,'Coordinate Reference System',26977,7301,'NAD83 / Kansas North (m)',''),
(1532,'Coordinate Reference System',26978,7301,'NAD83 / Kansas South (m)',''),
(1533,'Coordinate Reference System',2205,7301,'NAD83 / Kentucky North (m)',''),
(1534,'Coordinate Reference System',26980,7301,'NAD83 / Kentucky South (m)',''),
(1535,'Coordinate Reference System',26981,7301,'NAD83 / Louisiana North (m)',''),
(1536,'Coordinate Reference System',26982,7301,'NAD83 / Louisiana South (m)',''),
(1537,'Coordinate Reference System',26983,7301,'NAD83 / Maine East (m)',''),
(1538,'Coordinate Reference System',26984,7301,'NAD83 / Maine West (m)',''),
(1539,'Coordinate Reference System',26985,7301,'NAD83 / Maryland (m)',''),
(1540,'Coordinate Reference System',26987,7301,'NAD83 / Massachusetts Island (m)',''),
(1541,'Coordinate Reference System',26986,7301,'NAD83 / Massachusetts Mainland (m)',''),
(1542,'Coordinate Reference System',26989,7301,'NAD83 / Michigan Central (m)',''),
(1543,'Coordinate Reference System',26988,7301,'NAD83 / Michigan North (m)',''),
(1544,'Coordinate Reference System',26990,7301,'NAD83 / Michigan South (m)',''),
(1545,'Coordinate Reference System',26992,7301,'NAD83 / Minnesota Central (m)',''),
(1546,'Coordinate Reference System',26991,7301,'NAD83 / Minnesota North (m)',''),
(1547,'Coordinate Reference System',26993,7301,'NAD83 / Minnesota South (m)',''),
(1548,'Coordinate Reference System',26994,7301,'NAD83 / Mississippi East (m)',''),
(1549,'Coordinate Reference System',26995,7301,'NAD83 / Mississippi West (m)',''),
(1550,'Coordinate Reference System',26997,7301,'NAD83 / Missouri Central (m)',''),
(1551,'Coordinate Reference System',26996,7301,'NAD83 / Missouri East (m)',''),
(1552,'Coordinate Reference System',26998,7301,'NAD83 / Missouri West (m)',''),
(1553,'Coordinate Reference System',32100,7301,'NAD83 / Montana (m)',''),
(1554,'Coordinate Reference System',32104,7301,'NAD83 / Nebraska (m)',''),
(1555,'Coordinate Reference System',32108,7301,'NAD83 / Nevada Central (m)',''),
(1556,'Coordinate Reference System',32107,7301,'NAD83 / Nevada East (m)',''),
(1557,'Coordinate Reference System',32109,7301,'NAD83 / Nevada West (m)',''),
(1558,'Coordinate Reference System',32110,7301,'NAD83 / New Hampshire (m)',''),
(1559,'Coordinate Reference System',32111,7301,'NAD83 / New Jersey (m)',''),
(1560,'Coordinate Reference System',32112,7301,'NAD83 / New Mexico East (m)',''),
(1561,'Coordinate Reference System',32114,7301,'NAD83 / New Mexico West (m)',''),
(1562,'Coordinate Reference System',32116,7301,'NAD83 / New York Central (m)',''),
(1563,'Coordinate Reference System',32115,7301,'NAD83 / New York East (m)',''),
(1564,'Coordinate Reference System',32118,7301,'NAD83 / New York Long Island (m)',''),
(1565,'Coordinate Reference System',32117,7301,'NAD83 / New York West (m)',''),
(1566,'Coordinate Reference System',32119,7301,'NAD83 / North Carolina (m)',''),
(1567,'Coordinate Reference System',32120,7301,'NAD83 / North Dakota North (m)',''),
(1568,'Coordinate Reference System',32121,7301,'NAD83 / North Dakota South (m)',''),
(1569,'Coordinate Reference System',32122,7301,'NAD83 / Ohio North (m)',''),
(1570,'Coordinate Reference System',32123,7301,'NAD83 / Ohio South (m)',''),
(1571,'Coordinate Reference System',32124,7301,'NAD83 / Oklahoma North (m)',''),
(1572,'Coordinate Reference System',32125,7301,'NAD83 / Oklahoma South (m)',''),
(1573,'Coordinate Reference System',32126,7301,'NAD83 / Oregon North (m)',''),
(1574,'Coordinate Reference System',32127,7301,'NAD83 / Oregon South (m)',''),
(1575,'Coordinate Reference System',32128,7301,'NAD83 / Pennsylvania North (m)',''),
(1576,'Coordinate Reference System',32129,7301,'NAD83 / Pennsylvania South (m)',''),
(1577,'Coordinate Reference System',32130,7301,'NAD83 / Rhode Island (m)',''),
(1578,'Coordinate Reference System',32133,7301,'NAD83 / South Carolina (m)',''),
(1579,'Coordinate Reference System',32134,7301,'NAD83 / South Dakota North (m)',''),
(1580,'Coordinate Reference System',32135,7301,'NAD83 / South Dakota South (m)',''),
(1581,'Coordinate Reference System',32136,7301,'NAD83 / Tennessee (m)',''),
(1582,'Coordinate Reference System',32139,7301,'NAD83 / Texas Central (m)',''),
(1583,'Coordinate Reference System',32137,7301,'NAD83 / Texas North (m)',''),
(1584,'Coordinate Reference System',32138,7301,'NAD83 / Texas North Central (m)',''),
(1585,'Coordinate Reference System',32141,7301,'NAD83 / Texas South (m)',''),
(1586,'Coordinate Reference System',32140,7301,'NAD83 / Texas South Central (m)',''),
(1587,'Coordinate Reference System',32143,7301,'NAD83 / Utah Central (m)',''),
(1588,'Coordinate Reference System',32142,7301,'NAD83 / Utah North (m)',''),
(1589,'Coordinate Reference System',32144,7301,'NAD83 / Utah South (m)',''),
(1590,'Coordinate Reference System',32145,7301,'NAD83 / Vermont (m)',''),
(1591,'Coordinate Reference System',32146,7301,'NAD83 / Virginia North (m)',''),
(1592,'Coordinate Reference System',32147,7301,'NAD83 / Virginia South (m)',''),
(1593,'Coordinate Reference System',32148,7301,'NAD83 / Washington North (m)',''),
(1594,'Coordinate Reference System',32149,7301,'NAD83 / Washington South (m)',''),
(1595,'Coordinate Reference System',32150,7301,'NAD83 / West Virginia North (m)',''),
(1596,'Coordinate Reference System',32151,7301,'NAD83 / West Virginia South (m)',''),
(1597,'Coordinate Reference System',32153,7301,'NAD83 / Wisconsin Central (m)',''),
(1598,'Coordinate Reference System',32152,7301,'NAD83 / Wisconsin North (m)',''),
(1599,'Coordinate Reference System',32154,7301,'NAD83 / Wisconsin South (m)',''),
(1600,'Coordinate Reference System',32155,7301,'NAD83 / Wyoming East (m)',''),
(1601,'Coordinate Reference System',32156,7301,'NAD83 / Wyoming East Central (m)',''),
(1602,'Coordinate Reference System',32158,7301,'NAD83 / Wyoming West (m)',''),
(1603,'Coordinate Reference System',32157,7301,'NAD83 / Wyoming West Central (m)',''),
(1604,'Coordinate Reference System',32161,7301,'NAD83 / Puerto Rico & Virgin Is. (m)',''),
(1605,'Coordinate_Operation',10131,7301,'Alabama CS83 East zone',''),
(1606,'Coordinate_Operation',10132,7301,'Alabama CS83 West zone',''),
(1607,'Coordinate_Operation',10231,7301,'Arizona CS83 East zone',''),
(1608,'Coordinate_Operation',10232,7301,'Arizona CS83 Central zone',''),
(1609,'Coordinate_Operation',10233,7301,'Arizona CS83 West zone',''),
(1610,'Coordinate_Operation',10331,7301,'Arkansas CS83 North zone',''),
(1611,'Coordinate_Operation',10332,7301,'Arkansas CS83 South zone',''),
(1612,'Coordinate_Operation',10431,7301,'California CS83 zone 1',''),
(1613,'Coordinate_Operation',10432,7301,'California CS83 zone 2',''),
(1614,'Coordinate_Operation',10433,7301,'California CS83 zone 3',''),
(1615,'Coordinate_Operation',10434,7301,'California CS83 zone 4',''),
(1616,'Coordinate_Operation',10435,7301,'California CS83 zone 5',''),
(1617,'Coordinate_Operation',10436,7301,'California CS83 zone 6',''),
(1618,'Coordinate_Operation',10531,7301,'Colorado CS83 North zone',''),
(1619,'Coordinate_Operation',10532,7301,'Colorado CS83 Central zone',''),
(1620,'Coordinate_Operation',10533,7301,'Colorado CS83 South zone',''),
(1621,'Coordinate_Operation',10630,7301,'Connecticut CS83',''),
(1622,'Coordinate_Operation',10730,7301,'Delaware CS83',''),
(1623,'Coordinate_Operation',10931,7301,'Florida CS83 East zone',''),
(1624,'Coordinate_Operation',10932,7301,'Florida CS83 West zone',''),
(1625,'Coordinate_Operation',10933,7301,'Florida CS83 North zone',''),
(1626,'Coordinate_Operation',11031,7301,'Georgia CS83 East zone',''),
(1627,'Coordinate_Operation',11032,7301,'Georgia CS83 West zone',''),
(1628,'Coordinate_Operation',11131,7301,'Idaho CS83 East zone',''),
(1629,'Coordinate_Operation',11132,7301,'Idaho CS83 Central zone',''),
(1630,'Coordinate_Operation',11133,7301,'Idaho CS83 West zone',''),
(1631,'Coordinate_Operation',11231,7301,'Illinois CS83 East zone',''),
(1632,'Coordinate_Operation',11232,7301,'Illinois CS83 West zone',''),
(1633,'Coordinate_Operation',11331,7301,'Indiana CS83 East zone',''),
(1634,'Coordinate_Operation',11332,7301,'Indiana CS83 West zone',''),
(1635,'Coordinate_Operation',11431,7301,'Iowa CS83 North zone',''),
(1636,'Coordinate_Operation',11432,7301,'Iowa CS83 South zone',''),
(1637,'Coordinate_Operation',11531,7301,'Kansas CS83 North zone',''),
(1638,'Coordinate_Operation',11532,7301,'Kansas CS83 South zone',''),
(1639,'Coordinate Reference System',6826,7302,'NAD83(2011) / OCRS_GPA (m)',''),
(1640,'Coordinate_Operation',11632,7301,'Kentucky CS83 South zone',''),
(1641,'Coordinate_Operation',11731,7301,'Louisiana CS83 North zone',''),
(1642,'Coordinate_Operation',11732,7301,'Louisiana CS83 South zone',''),
(1643,'Coordinate_Operation',11831,7301,'Maine CS83 East (m)',''),
(1644,'Coordinate_Operation',11832,7301,'Maine CS83 West zone',''),
(1645,'Coordinate_Operation',11930,7301,'Maryland CS83',''),
(1646,'Coordinate_Operation',12031,7301,'Massachusetts CS83 Mainland zone',''),
(1647,'Coordinate_Operation',12032,7301,'Massachusetts CS83 Island zone',''),
(1648,'Coordinate_Operation',12141,7301,'Michigan CS83 North zone',''),
(1649,'Coordinate_Operation',12142,7301,'Michigan CS83 Central zone',''),
(1650,'Coordinate_Operation',12143,7301,'Michigan CS83 South zone',''),
(1651,'Coordinate_Operation',12231,7301,'Minnesota CS83 North zone (m)',''),
(1652,'Coordinate_Operation',12232,7301,'Minnesota CS83 Central zone',''),
(1653,'Coordinate_Operation',12233,7301,'Minnesota CS83 South zone (m)',''),
(1654,'Coordinate_Operation',12331,7301,'Mississippi CS83 East zone',''),
(1655,'Coordinate_Operation',12332,7301,'Mississippi CS83 West zone',''),
(1656,'Coordinate_Operation',12431,7301,'Missouri CS83 East zone',''),
(1657,'Coordinate_Operation',12433,7301,'Missouri CS83 West zone',''),
(1658,'Coordinate_Operation',12530,7301,'Montana CS83',''),
(1659,'Coordinate_Operation',12630,7301,'Nebraska CS83',''),
(1660,'Coordinate_Operation',12731,7301,'Nevada CS83 East zone',''),
(1661,'Coordinate_Operation',12732,7301,'Nevada CS83 Central zone',''),
(1662,'Coordinate_Operation',12733,7301,'Nevada CS83 West zone',''),
(1663,'Coordinate_Operation',12830,7301,'New Hampshire CS83',''),
(1664,'Coordinate_Operation',12930,7301,'New Jersey CS83',''),
(1665,'Coordinate_Operation',13031,7301,'New Mexico CS83 East zone',''),
(1666,'Coordinate_Operation',13032,7301,'New Mexico CS83 Central zone',''),
(1667,'Coordinate_Operation',13033,7301,'New Mexico CS83 West zone',''),
(1668,'Coordinate_Operation',13131,7301,'New York CS83 East zone',''),
(1669,'Coordinate_Operation',13132,7301,'New York CS83 Central zone',''),
(1670,'Coordinate_Operation',13133,7301,'New York CS83 West zone',''),
(1671,'Coordinate_Operation',13134,7301,'New York CS83 Long Island zone',''),
(1672,'Coordinate_Operation',13230,7301,'North Carolina CS83',''),
(1673,'Coordinate_Operation',13331,7301,'North Dakota CS83 North zone',''),
(1674,'Coordinate_Operation',13332,7301,'North Dakota CS83 South zone',''),
(1675,'Coordinate_Operation',13431,7301,'Ohio CS83 North zone',''),
(1676,'Coordinate_Operation',13432,7301,'Ohio CS83 South zone',''),
(1677,'Coordinate_Operation',13531,7301,'Oklahoma CS83 North zone',''),
(1678,'Coordinate_Operation',13532,7301,'Oklahoma CS83 South zone',''),
(1679,'Coordinate_Operation',13631,7301,'Oregon CS83 North zone',''),
(1680,'Coordinate_Operation',13632,7301,'Oregon CS83 South zone',''),
(1681,'Coordinate_Operation',13731,7301,'Pennsylvania CS83 North zone',''),
(1682,'Coordinate_Operation',13732,7301,'Pennsylvania CS83 South zone',''),
(1683,'Coordinate_Operation',13830,7301,'Rhode Island CS83',''),
(1684,'Coordinate_Operation',13930,7301,'South Carolina CS83',''),
(1685,'Coordinate_Operation',14031,7301,'South Dakota CS83 North zone',''),
(1686,'Coordinate_Operation',14032,7301,'South Dakota CS83 South zone',''),
(1687,'Coordinate_Operation',14130,7301,'Tennessee CS83',''),
(1688,'Coordinate_Operation',14231,7301,'Texas CS83 North zone',''),
(1689,'Coordinate_Operation',14232,7301,'Texas CS83 North Central zone',''),
(1690,'Coordinate_Operation',14233,7301,'Texas CS83 Central zone',''),
(1691,'Coordinate_Operation',14234,7301,'Texas CS83 South Central zone',''),
(1692,'Coordinate_Operation',14235,7301,'Texas CS83 South zone',''),
(1693,'Coordinate_Operation',14331,7301,'Utah CS83 North zone',''),
(1694,'Coordinate_Operation',14332,7301,'Utah CS83 Central zone',''),
(1695,'Coordinate_Operation',14333,7301,'Utah CS83 South zone',''),
(1696,'Coordinate_Operation',14430,7301,'Vermont CS83',''),
(1697,'Coordinate_Operation',14531,7301,'Virginia CS83 North zone',''),
(1698,'Coordinate_Operation',14532,7301,'Virginia CS83 South zone',''),
(1699,'Coordinate_Operation',14631,7301,'Washington CS83 North zone',''),
(1700,'Coordinate_Operation',14632,7301,'Washington CS83 South zone',''),
(1701,'Coordinate_Operation',14731,7301,'West Virginia North (m)',''),
(1702,'Coordinate_Operation',14732,7301,'West Virginia South (m)',''),
(1703,'Coordinate_Operation',14831,7301,'Wisconsin CS83 North zone',''),
(1704,'Coordinate_Operation',14832,7301,'Wisconsin CS83 Central zone',''),
(1705,'Coordinate_Operation',14833,7301,'Wisconsin CS83 South zone',''),
(1706,'Coordinate_Operation',14931,7301,'Wyoming CS83 East zone',''),
(1707,'Coordinate_Operation',14932,7301,'Wyoming CS83 East Central zone',''),
(1708,'Coordinate_Operation',14933,7301,'Wyoming CS83 West Central zone',''),
(1709,'Coordinate_Operation',14934,7301,'Wyoming CS83 West zone',''),
(1710,'Coordinate_Operation',15031,7301,'Alaska CS83 zone 1',''),
(1711,'Coordinate_Operation',15032,7301,'Alaska CS83 zone 2',''),
(1712,'Coordinate_Operation',15033,7301,'Alaska CS83 zone 3',''),
(1713,'Coordinate_Operation',15034,7301,'Alaska CS83 zone 4',''),
(1714,'Coordinate_Operation',15035,7301,'Alaska CS83 zone 5',''),
(1715,'Coordinate_Operation',15036,7301,'Alaska CS83 zone 6',''),
(1716,'Coordinate_Operation',15037,7301,'Alaska CS83 zone 7',''),
(1717,'Coordinate_Operation',15038,7301,'Alaska CS83 zone 8',''),
(1718,'Coordinate_Operation',15039,7301,'Alaska CS83 zone 9',''),
(1719,'Coordinate_Operation',15040,7301,'Alaska CS83 zone 10',''),
(1720,'Coordinate_Operation',15131,7301,'Hawaii CS83 zone 1',''),
(1721,'Coordinate_Operation',15132,7301,'Hawaii CS83 zone 2',''),
(1722,'Coordinate_Operation',15133,7301,'Hawaii CS83 zone 3',''),
(1723,'Coordinate_Operation',15134,7301,'Hawaii CS83 zone 4',''),
(1724,'Coordinate_Operation',15135,7301,'Hawaii CS83 zone 5',''),
(1725,'Coordinate_Operation',15230,7301,'Puerto Rico & Virgin Islands CS83',''),
(1726,'Coordinate_Operation',15303,7301,'Kentucky CS83 North zone',''),
(1727,'Coordinate_Operation',12432,7301,'Missouri CS83 Central zone',''),
(1728,'Coordinate_Operation',15303,7302,'Kentucky North','This alias is ambiguous as also used for SPCS27 projection.'),
(1729,'Coordinate_Operation',10532,7302,'Colorado Central','This alias is ambiguous as also used for SPCS27 projection.'),
(1730,'Coordinate Reference System',4282,7301,'Congo 1960 Pointe Noire',''),
(1731,'Coordinate Reference System',28232,7301,'Congo 1960 Pointe Noire / UTM zone 32S',''),
(1732,'Coordinate_Operation',1801,7301,'Congo 1960 Pointe Noire to WGS 84 (2)',''),
(1733,'Coordinate_Operation',1802,7301,'Congo 1960 Pointe Noire to WGS 84 (3)',''),
(1734,'Coordinate_Operation',1200,7301,'Congo 1960 Pointe Noire to WGS 84 (1)',''),
(1735,'Coordinate_Operation',15914,7301,'BLM zone 14N in feet',''),
(1736,'Coordinate_Operation',15915,7301,'BLM zone 15N in feet',''),
(1737,'Coordinate_Operation',15916,7301,'BLM zone 16N in feet',''),
(1738,'Coordinate_Operation',15917,7301,'BLM zone 17N in feet',''),
(1739,'Coordinate Reference System',21149,7301,'Genuk / UTM zone 49S',''),
(1740,'Coordinate Reference System',2308,7301,'Genuk / TM 109 SE',''),
(1741,'Datum',5133,7302,'AIOC95',''),
(1742,'Coordinate Reference System',5705,7301,'Kronstadt height',''),
(1743,'Datum',6199,7301,'New Egyptian','Old Egyptian is an alias for Egypt 1907 (code 6229).'),
(1744,'Datum',6229,7301,'Old Egyptian','New Egyptian is an alias for Egypt 1930 (code 6199).'),
(1745,'Coordinate Reference System',4199,7301,'New Egyptian','Old Egyptian is an alias for Egypt 1907 (code 4229).'),
(1746,'Coordinate Reference System',4229,7301,'Old Egyptian','New Egyptian is an alias for Egypt 1930 (code 4199).'),
(1747,'Coordinate_Operation',1516,7301,'PSAD56 to WGS 84 (1)',''),
(1748,'Coordinate_Operation',1813,7301,'Genuk to WGS 84 (ONWJ)',''),
(1749,'Coordinate Reference System',32064,7301,'NAD27 / UTM zone 14N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 14N (code 26714). UTM is a metric system so strictly this is not UTM.'),
(1750,'Coordinate Reference System',32065,7301,'NAD27 / UTM zone 15N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 15N (code 26715). UTM is a metric system so strictly this is not UTM.'),
(1751,'Coordinate Reference System',32066,7301,'NAD27 / UTM zone 16N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 16N (code 26716). UTM is a metric system so strictly this is not UTM.'),
(1752,'Coordinate Reference System',32067,7301,'NAD27 / UTM zone 17N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 17N (code 26717). UTM is a metric system so strictly this is not UTM.'),
(1753,'Coordinate Reference System',6831,7302,'NAD83(2011) / OCRS_GWS (ft)',''),
(1754,'Coordinate Reference System',2319,7301,'ED50 / 3-degree Gauss-Kruger CM 27E',''),
(1755,'Coordinate Reference System',2320,7301,'ED50 / 3-degree Gauss-Kruger CM 30E',''),
(1756,'Coordinate Reference System',2321,7301,'ED50 / 3-degree Gauss-Kruger CM 33E',''),
(1757,'Coordinate Reference System',2322,7301,'ED50 / 3-degree Gauss-Kruger CM 36E',''),
(1758,'Coordinate Reference System',2323,7301,'ED50 / 3-degree Gauss-Kruger CM 39E',''),
(1759,'Coordinate Reference System',2324,7301,'ED50 / 3-degree Gauss-Kruger CM 42E',''),
(1760,'Coordinate Reference System',2325,7301,'ED50 / 3-degree Gauss-Kruger CM 45E',''),
(1761,'Datum',6612,7302,'JGD2000',''),
(1762,'Datum',5137,7301,'Huang Hai 1985',''),
(1763,'Datum',5135,7302,'HKPD',''),
(1764,'Coordinate Reference System',6830,7302,'NAD83(2011) / OCRS_GWS (m)',''),
(1765,'Coordinate Reference System',5736,7301,'Huang Hai 1956 height',''),
(1766,'Coordinate Reference System',5738,7301,'Hong Kong Principal Datum height',''),
(1767,'Coordinate Reference System',2343,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 105E',''),
(1768,'Coordinate Reference System',2344,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 111E',''),
(1769,'Coordinate Reference System',2338,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 75E',''),
(1770,'Coordinate Reference System',2342,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 99E',''),
(1771,'Coordinate Reference System',2348,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 135E',''),
(1772,'Coordinate Reference System',2339,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 81E',''),
(1773,'Coordinate Reference System',2340,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 87E',''),
(1774,'Coordinate Reference System',2341,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 93E',''),
(1775,'Coordinate Reference System',2345,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 117E',''),
(1776,'Coordinate Reference System',2346,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 123E',''),
(1777,'Coordinate Reference System',2347,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 129E',''),
(1778,'Datum',6611,7302,'HK80',''),
(1779,'Datum',5135,7301,'Ordnance Datum','This is the former name.'),
(1780,'Datum',5136,7301,'Admiralty Chart Datum','This is the former name.'),
(1781,'Coordinate Reference System',5737,7301,'Huang Hai 1985 height',''),
(1782,'Coordinate Reference System',2326,7302,'HK 1980 Grid System',''),
(1783,'Coordinate Reference System',4611,7302,'HK1980',''),
(1784,'Coordinate_Operation Parameter',8802,7301,'Central Meridian','Abbeviated as "CM".'),
(1785,'Coordinate_Operation Parameter',8802,7302,'CM','Abbreviation for "Central Meridian".'),
(1786,'Coordinate Reference System',2327,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 13','Part of the China National Coordinate System of 1980.'),
(1787,'Coordinate Reference System',2328,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 14','Part of the China National Coordinate System of 1980.'),
(1788,'Coordinate Reference System',2329,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 15','Part of the China National Coordinate System of 1980.'),
(1789,'Coordinate Reference System',2330,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 16','Part of the China National Coordinate System of 1980.'),
(1790,'Coordinate Reference System',2331,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 17','Part of the China National Coordinate System of 1980.'),
(1791,'Coordinate Reference System',2332,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 18','Part of the China National Coordinate System of 1980.'),
(1792,'Coordinate Reference System',2333,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 19','Part of the China National Coordinate System of 1980.'),
(1793,'Coordinate Reference System',2334,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 20','Part of the China National Coordinate System of 1980.'),
(1794,'Coordinate Reference System',2335,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 21','Part of the China National Coordinate System of 1980.'),
(1795,'Coordinate Reference System',2336,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 22','Part of the China National Coordinate System of 1980.'),
(1796,'Coordinate Reference System',2337,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 23','Part of the China National Coordinate System of 1980.'),
(1797,'Coordinate Reference System',21413,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 13',''),
(1798,'Coordinate Reference System',21414,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 14',''),
(1799,'Coordinate Reference System',21415,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 15',''),
(1800,'Coordinate Reference System',21416,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 16',''),
(1801,'Coordinate Reference System',21417,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 17',''),
(1802,'Coordinate Reference System',21418,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 18',''),
(1803,'Coordinate Reference System',21419,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 19',''),
(1804,'Coordinate Reference System',21420,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 20',''),
(1805,'Coordinate Reference System',21421,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 21',''),
(1806,'Coordinate Reference System',21422,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 22',''),
(1807,'Coordinate Reference System',21423,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 23',''),
(1808,'Coordinate Reference System',21453,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 75E',''),
(1809,'Coordinate Reference System',21454,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 81E',''),
(1810,'Coordinate Reference System',21455,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 87E',''),
(1811,'Coordinate Reference System',21456,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 93E',''),
(1812,'Coordinate Reference System',21457,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 99E',''),
(1813,'Coordinate Reference System',21458,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 105E',''),
(1814,'Coordinate Reference System',21459,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 111E',''),
(1815,'Coordinate Reference System',21460,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 117E',''),
(1816,'Coordinate Reference System',21461,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 123E',''),
(1817,'Coordinate Reference System',21462,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 129E',''),
(1818,'Coordinate Reference System',21463,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 135E',''),
(1819,'Coordinate_Operation',5405,7302,'HKPD to Hong Kong Chart (1)',''),
(1820,'Coordinate Reference System',2044,7301,'Hanoi 1972 / 6-degree Gauss-Kruger zone 18',''),
(1821,'Coordinate Reference System',2045,7301,'Hanoi 1972 / 6-degree Gauss-Kruger zone 19',''),
(1822,'Coordinate Reference System',2462,7301,'Albanian 1987 / 6-degree Gauss-Kruger zone 4',''),
(1823,'Coordinate Reference System',2397,7310,'Pulkovo 1942(83) / Gauss-Kruger zone 3',''),
(1824,'Coordinate Reference System',2398,7310,'Pulkovo 1942(83) / Gauss-Kruger zone 4',''),
(1825,'Coordinate Reference System',2399,7310,'Pulkovo 1942(83) / Gauss-Kruger zone 5',''),
(1826,'Coordinate Reference System',2395,7302,'S Yemen / G-K zone 8',''),
(1827,'Coordinate Reference System',2396,7302,'S Yemen / G-K zone 9',''),
(1828,'Coordinate Reference System',2396,7301,'South Yemen / 6-degree Gauss-Kruger zone 9',''),
(1829,'Coordinate Reference System',2395,7301,'South Yemen / 6-degree Gauss-Kruger zone 8',''),
(1830,'Coordinate_Operation',18031,7301,'Gauss-Kruger zone 1',''),
(1831,'Coordinate_Operation',18032,7301,'Gauss-Kruger zone 2',''),
(1832,'Coordinate_Operation',18033,7301,'Gauss-Kruger zone 3',''),
(1833,'Coordinate_Operation',18034,7301,'Gauss-Kruger zone 4',''),
(1834,'Coordinate_Operation',18035,7301,'Gauss-Kruger zone 5',''),
(1835,'Coordinate_Operation',18036,7301,'Gauss-Kruger zone 6',''),
(1836,'Coordinate_Operation',18037,7301,'Gauss-Kruger zone 7',''),
(1837,'Coordinate Reference System',22191,7301,'Campo Inchauspe / Gauss-Kruger zone 1',''),
(1838,'Coordinate Reference System',22192,7301,'Campo Inchauspe / Gauss-Kruger zone 2',''),
(1839,'Coordinate Reference System',22193,7301,'Campo Inchauspe / Gauss-Kruger zone 3',''),
(1840,'Coordinate Reference System',22194,7301,'Campo Inchauspe / Gauss-Kruger zone 4',''),
(1841,'Coordinate Reference System',22195,7301,'Campo Inchauspe / Gauss-Kruger zone 5',''),
(1842,'Coordinate Reference System',22196,7301,'Campo Inchauspe / Gauss-Kruger zone 6',''),
(1843,'Coordinate Reference System',22197,7301,'Campo Inchauspe / Gauss-Kruger zone 7',''),
(1844,'Coordinate Reference System',2081,7301,'Chos Malal 1914 / Gauss-Kruger zone 2',''),
(1845,'Coordinate Reference System',2082,7301,'Pampa del Castillo / Gauss-Kruger zone 2',''),
(1846,'Coordinate Reference System',2083,7301,'Hito XVIII 1963 / Gauss-Kruger zone 2',''),
(1847,'Coordinate Reference System',20004,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 4',''),
(1848,'Coordinate Reference System',20005,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 5',''),
(1849,'Coordinate Reference System',20006,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 6',''),
(1850,'Coordinate Reference System',20007,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 7',''),
(1851,'Coordinate Reference System',20008,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 8',''),
(1852,'Coordinate Reference System',20009,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 9',''),
(1853,'Coordinate Reference System',20010,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 10',''),
(1854,'Coordinate Reference System',20011,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 11',''),
(1855,'Coordinate Reference System',20012,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 12',''),
(1856,'Coordinate Reference System',20013,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 13',''),
(1857,'Coordinate Reference System',20014,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 14',''),
(1858,'Coordinate Reference System',20015,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 15',''),
(1859,'Coordinate Reference System',20016,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 16',''),
(1860,'Coordinate Reference System',20017,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 17',''),
(1861,'Coordinate Reference System',20018,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 18',''),
(1862,'Coordinate Reference System',20019,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 19',''),
(1863,'Coordinate Reference System',20020,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 20',''),
(1864,'Coordinate Reference System',20021,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 21',''),
(1865,'Coordinate Reference System',20022,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 22',''),
(1866,'Coordinate Reference System',20023,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 23',''),
(1867,'Coordinate Reference System',20024,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 24',''),
(1868,'Coordinate Reference System',20025,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 25',''),
(1869,'Coordinate Reference System',20026,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 26',''),
(1870,'Coordinate Reference System',20027,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 27',''),
(1871,'Coordinate Reference System',20028,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 28',''),
(1872,'Coordinate Reference System',20029,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 29',''),
(1873,'Coordinate Reference System',20030,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 30',''),
(1874,'Coordinate Reference System',20031,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 31',''),
(1875,'Coordinate Reference System',20032,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 32',''),
(1876,'Coordinate Reference System',28402,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 2',''),
(1877,'Coordinate Reference System',28403,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 3',''),
(1878,'Coordinate Reference System',28404,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 4',''),
(1879,'Coordinate Reference System',28405,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 5',''),
(1880,'Coordinate Reference System',28406,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 6',''),
(1881,'Coordinate Reference System',28407,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 7',''),
(1882,'Coordinate Reference System',28408,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 8',''),
(1883,'Coordinate Reference System',28409,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 9',''),
(1884,'Coordinate Reference System',28410,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 10',''),
(1885,'Coordinate Reference System',28411,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 11',''),
(1886,'Coordinate Reference System',28412,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 12',''),
(1887,'Coordinate Reference System',28413,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 13',''),
(1888,'Coordinate Reference System',28414,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 14',''),
(1889,'Coordinate Reference System',28415,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 15',''),
(1890,'Coordinate Reference System',28416,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 16',''),
(1891,'Coordinate Reference System',28417,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 17',''),
(1892,'Coordinate Reference System',28418,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 18',''),
(1893,'Coordinate Reference System',28419,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 19',''),
(1894,'Coordinate Reference System',28420,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 20',''),
(1895,'Coordinate Reference System',28421,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 21',''),
(1896,'Coordinate Reference System',28422,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 22',''),
(1897,'Coordinate Reference System',28423,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 23',''),
(1898,'Coordinate Reference System',28424,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 24',''),
(1899,'Coordinate Reference System',28425,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 25',''),
(1900,'Coordinate Reference System',28426,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 26',''),
(1901,'Coordinate Reference System',28427,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 27',''),
(1902,'Coordinate Reference System',28428,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 28',''),
(1903,'Coordinate Reference System',28429,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 29',''),
(1904,'Coordinate Reference System',28430,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 30',''),
(1905,'Coordinate Reference System',28431,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 31',''),
(1906,'Coordinate Reference System',28432,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 32',''),
(1907,'Coordinate Reference System',2463,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 21E',''),
(1908,'Coordinate Reference System',2464,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 27E',''),
(1909,'Coordinate Reference System',2465,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 33E',''),
(1910,'Coordinate Reference System',2466,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 39E',''),
(1911,'Coordinate Reference System',2467,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 45E',''),
(1912,'Coordinate Reference System',2468,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 51E',''),
(1913,'Coordinate Reference System',2469,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 57E',''),
(1914,'Coordinate Reference System',2470,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 63E',''),
(1915,'Coordinate Reference System',2471,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 69E',''),
(1916,'Coordinate Reference System',2472,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 75E',''),
(1917,'Coordinate Reference System',2473,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 81E',''),
(1918,'Coordinate Reference System',2474,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 87E',''),
(1919,'Coordinate Reference System',2475,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 93E',''),
(1920,'Coordinate Reference System',2476,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 99E',''),
(1921,'Coordinate Reference System',2477,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 105E',''),
(1922,'Coordinate Reference System',2478,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 111E',''),
(1923,'Coordinate Reference System',2479,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 117E',''),
(1924,'Coordinate Reference System',2480,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 123E',''),
(1925,'Coordinate Reference System',2481,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 129E',''),
(1926,'Coordinate Reference System',2482,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 135E',''),
(1927,'Coordinate Reference System',2483,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 141E',''),
(1928,'Coordinate Reference System',2484,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 147E',''),
(1929,'Coordinate Reference System',2485,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 153E',''),
(1930,'Coordinate Reference System',2486,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 159E',''),
(1931,'Coordinate Reference System',2487,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 165E',''),
(1932,'Coordinate Reference System',2488,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 171E',''),
(1933,'Coordinate Reference System',2489,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 177E',''),
(1934,'Coordinate Reference System',2490,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 177W',''),
(1935,'Coordinate Reference System',2491,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 171W',''),
(1936,'Coordinate Reference System',2492,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 9E',''),
(1937,'Coordinate Reference System',2493,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 15E',''),
(1938,'Coordinate Reference System',2494,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 21E',''),
(1939,'Coordinate Reference System',2495,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 27E',''),
(1940,'Coordinate Reference System',2496,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 33E',''),
(1941,'Coordinate Reference System',2497,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 39E',''),
(1942,'Coordinate Reference System',2498,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 45E',''),
(1943,'Coordinate Reference System',2499,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 51E',''),
(1944,'Coordinate Reference System',2500,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 57E',''),
(1945,'Coordinate Reference System',2501,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 63E',''),
(1946,'Coordinate Reference System',2502,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 69E',''),
(1947,'Coordinate Reference System',2503,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 75E',''),
(1948,'Coordinate Reference System',2504,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 81E',''),
(1949,'Coordinate Reference System',2505,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 87E',''),
(1950,'Coordinate Reference System',2506,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 93E',''),
(1951,'Coordinate Reference System',2507,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 99E',''),
(1952,'Coordinate Reference System',2508,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 105E',''),
(1953,'Coordinate Reference System',2509,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 111E',''),
(1954,'Coordinate Reference System',2510,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 117E',''),
(1955,'Coordinate Reference System',2511,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 123E',''),
(1956,'Coordinate Reference System',2512,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 129E',''),
(1957,'Coordinate Reference System',2513,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 135E',''),
(1958,'Coordinate Reference System',2514,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 141E',''),
(1959,'Coordinate Reference System',2515,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 147E',''),
(1960,'Coordinate Reference System',2516,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 153E',''),
(1961,'Coordinate Reference System',2517,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 159E',''),
(1962,'Coordinate Reference System',2518,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 165E',''),
(1963,'Coordinate Reference System',2519,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 171E',''),
(1964,'Coordinate Reference System',2520,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 177E',''),
(1965,'Coordinate Reference System',2521,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 177W',''),
(1966,'Coordinate Reference System',2522,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 171W',''),
(1967,'Unit of Measure',9115,7302,'DM',''),
(1968,'Datum',1164,7302,'ODN (Offshore)',''),
(1969,'Coordinate Reference System',6792,7302,'CORS96 / OCRS_BRP (m)',''),
(1970,'Coordinate Reference System',6801,7302,'CORS96 / OCRS_CGP (ft)',''),
(1971,'Coordinate Reference System',6800,7302,'CORS96 / OCRS_CGP (m)',''),
(1972,'Coordinate Reference System',6805,7302,'CORS96 / OCRS_CRE (ft)',''),
(1973,'Coordinate Reference System',6809,7302,'CORS96 / OCRS_CRW (ft)',''),
(1974,'Coordinate Reference System',6804,7302,'CORS96 / OCRS_CRE (m)',''),
(1975,'Coordinate Reference System',6808,7302,'CORS96 / OCRS_CRW (m)',''),
(1976,'Coordinate Reference System',6813,7302,'CORS96 / OCRS_CGC (ft)',''),
(1977,'Coordinate Reference System',6812,7302,'CORS96 / OCRS_CGC (m)',''),
(1978,'Coordinate Reference System',6817,7302,'CORS96 / OCRS_DFM (ft)',''),
(1979,'Coordinate Reference System',6816,7302,'CORS96 / OCRS_DFM (m)',''),
(1980,'Coordinate Reference System',6821,7302,'CORS96 / OCRS_EUG (ft)',''),
(1981,'Coordinate Reference System',6820,7302,'CORS96 / OCRS_EUG (m)',''),
(1982,'Coordinate Reference System',6825,7302,'CORS96 / OCRS_GPA (ft)',''),
(1983,'Coordinate Reference System',6824,7302,'CORS96 / OCRS_GPA (m)',''),
(1984,'Coordinate Reference System',6829,7302,'CORS96 / OCRS_GWS (ft)',''),
(1985,'Coordinate Reference System',6828,7302,'CORS96 / OCRS_GWS (m)',''),
(1986,'Coordinate Reference System',6832,7302,'CORS96 / OCRS_LDG (m)',''),
(1987,'Coordinate Reference System',6833,7302,'CORS96 / OCRS_LDG (ft)',''),
(1988,'Coordinate Reference System',6835,7302,'NAD83(2011) / OCRS_LDG (ft)',''),
(1989,'Coordinate Reference System',6837,7302,'CORS96 / OCRS_ONT (ft)',''),
(1990,'Coordinate Reference System',6838,7302,'NAD83(2011) / OCRS_ONT (m)',''),
(1991,'Coordinate Reference System',4327,7311,'DGN-95 (geographic 3D)','Datum Geodesi Nasional 1995 (DGN-95) is a synonym for WGS 84 in Indonesia.'),
(1992,'Coordinate Reference System',4328,7311,'DGN-95 (geocentric)','Datum Geodesi Nasional 1995 (DGN-95) is a synonym for WGS 84 in Indonesia.'),
(1993,'Coordinate Reference System',6834,7302,'NAD83(2011) / OCRS_LDG (m)',''),
(1994,'Coordinate_Operation',1814,7301,'Genuk to WGS 84 (3)',''),
(1995,'Coordinate Reference System',6839,7302,'NAD83(2011) / OCRS_ONT (ft)',''),
(1996,'Datum',6820,7302,'Segara (Jakarta)',''),
(1997,'Datum',6613,7302,'Segara',''),
(1998,'Datum',6613,7301,'Samboja','Samboja-1 is one of two stations used as the baseline for extension to government triangulation by Total Indonesia in 1970-71.'),
(1999,'Datum',6613,7301,'P2 Exc','P2 Exc is one of two stations used as the baseline for extension to government triangulation by Total Indonesia in 1970-71. P2 Exc is a replacement satellite station to the destroyed station P2.'),
(2000,'Datum',6613,7301,'P2 Exc-T9','P2 Exc was a replacement satellite station to the destroyed station P2 from which several Toran stations including T9 were coordinated in 1970-71. When further control work was executed in 1995 P2 Exc was by then destroyed and T9 was used as its origin.'),
(2001,'Coordinate Reference System',4613,7301,'Samboja','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and P2 Exc-T9.'),
(2002,'Coordinate Reference System',4613,7301,'P2 Exc-T9','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and Samboja.'),
(2003,'Coordinate Reference System',4613,7301,'P2 Exc','Oil industry extension in the Mahakam delta region. Also known as P2 Exc-T9 and Samboja.'),
(2004,'Coordinate_Operation',1838,7301,'Samboja to WGS 84 (4)',''),
(2005,'Coordinate_Operation',1838,7301,'P2 Exc-T9 to WGS 84 (4)',''),
(2006,'Datum',6614,7302,'QND95',''),
(2007,'Coordinate Reference System',6840,7302,'CORS96 / OCRS_ORC (m)',''),
(2008,'Coordinate Reference System',2933,7301,'Samboja / UTM zone 50S',''),
(2009,'Coordinate Reference System',2933,7301,'P2 Exc-T9 / UTM zone 50S',''),
(2010,'Unit of Measure',9110,7301,'sexagesimal degree DDD.MMSSsss',''),
(2011,'Coordinate Reference System',2952,7301,'NAD83(CSRS) / SCoPQ zone 10',''),
(2012,'Coordinate Reference System',2945,7301,'NAD83(CSRS) / SCoPQ zone 3',''),
(2013,'Coordinate Reference System',2946,7301,'NAD83(CSRS) / SCoPQ zone 4',''),
(2014,'Coordinate Reference System',2947,7301,'NAD83(CSRS) / SCoPQ zone 5',''),
(2015,'Coordinate Reference System',2948,7301,'NAD83(CSRS) / SCoPQ zone 6',''),
(2016,'Coordinate Reference System',2949,7301,'NAD83(CSRS) / SCoPQ zone 7',''),
(2017,'Coordinate Reference System',2950,7301,'NAD83(CSRS) / SCoPQ zone 8',''),
(2018,'Coordinate Reference System',2951,7301,'NAD83(CSRS) / SCoPQ zone 9',''),
(2019,'Coordinate_Operation',18071,7301,'Green Belt',''),
(2020,'Coordinate Reference System',22991,7301,'Egypt 1907 / Green Belt',''),
(2021,'Coordinate_Operation Parameter',8806,7301,'False westing','This alias applies only in the case of projection methods which have an axis positive west, e.g. Transverse Mercator (South Orientated).'),
(2022,'Coordinate_Operation Parameter',8807,7301,'False southing','This alias applies only in the case of projection methods which have an axis positive south, e.g. Transverse Mercator (South Orientated).'),
(2023,'Ellipsoid',7050,7301,'GRS 1967',''),
(2024,'Coordinate_Operation',18131,7301,'Zone 1 Nord Maroc',''),
(2025,'Coordinate_Operation',18132,7301,'Zone 2 Sud Maroc',''),
(2026,'Coordinate_Operation',18134,7301,'Zone 3 Sahara Nord',''),
(2027,'Coordinate_Operation',18135,7301,'Zone 4 Sahara Sud',''),
(2028,'Coordinate Reference System',26191,7301,'Merchich / Zone 1 Nord Maroc',''),
(2029,'Coordinate Reference System',26192,7301,'Merchich / Zone 2 Sud Maroc',''),
(2030,'Coordinate Reference System',26194,7301,'Merchich / Zone 3 Sahara Nord',''),
(2031,'Coordinate Reference System',26195,7301,'Merchich / Zone 4 Sahara Sud',''),
(2032,'Datum',6620,7301,'12th Parallel traverse',''),
(2033,'Coordinate Reference System',4620,7301,'12th Parallel traverse',''),
(2034,'Datum',5131,7302,'Belfast',''),
(2035,'Datum',5101,7301,'Newlyn',''),
(2036,'Coordinate Reference System',5732,7301,'Belfast Lough height',''),
(2037,'Coordinate Reference System',6836,7302,'CORS96 / OCRS_ONT (m)',''),
(2038,'Coordinate_Operation',6748,7301,'Oregon Bend-Vale zone (International feet)','Previous name.'),
(2039,'Coordinate Reference System',6841,7302,'CORS96 / OCRS_ORC (ft)',''),
(2040,'Coordinate_Operation',1886,7301,'Graciosa to WGS 84 (1)',''),
(2041,'Coordinate_Operation',1885,7301,'Sao Braz to WGS 84 (1)',''),
(2042,'Coordinate_Operation',1890,7302,'AAD98 to WGS 84 (1)',''),
(2043,'Coordinate Reference System',31281,7312,'Gebrauchsnetz M28',''),
(2044,'Coordinate Reference System',31282,7312,'Gebrauchsnetz M31',''),
(2045,'Coordinate Reference System',31283,7312,'Gebrauchsnetz M34',''),
(2046,'Coordinate Reference System',31288,7312,'Bundesmeldenetz M28',''),
(2047,'Coordinate Reference System',31289,7312,'Bundesmeldenetz M31',''),
(2048,'Coordinate Reference System',31290,7312,'Bundesmeldenetz M34',''),
(2049,'Coordinate_Operation',5401,7301,'Belfast Lough to Malin Head',''),
(2050,'Coordinate Reference System',6842,7302,'NAD83(2011) / OCRS_ORC (m)',''),
(2051,'Coordinate_Operation',1895,7301,'RT90 to ETRS89 (2)','Supersedes RT90 to ETRS89 (1) (code 1437).'),
(2052,'Coordinate Reference System',6843,7302,'NAD83(2011) / OCRS_ORC (ft)',''),
(2053,'Coordinate Reference System',6844,7302,'CORS96 / OCRS_PDT (m)',''),
(2054,'Coordinate Reference System',6845,7302,'CORS96 / OCRS_PDT (ft)',''),
(2055,'Coordinate Reference System',6846,7302,'NAD83(2011) / OCRS_PDT (m)',''),
(2056,'Coordinate Reference System',6848,7302,'CORS96 / OCRS_PLG (m)',''),
(2057,'Coordinate Reference System',6849,7302,'CORS96 / OCRS_PLG (ft)',''),
(2058,'Coordinate Reference System',6850,7302,'NAD83(2011) / OCRS_PLG (m)',''),
(2059,'Coordinate Reference System',6851,7302,'NAD83(2011) / OCRS_PLG (ft)',''),
(2060,'Coordinate Reference System',6847,7302,'NAD83(2011) / OCRS_PDT (ft)',''),
(2061,'Coordinate Reference System',6852,7302,'CORS96 / OCRS_PDX (m)',''),
(2062,'Coordinate Reference System',6853,7302,'CORS96 / OCRS_PDX (ft)',''),
(2063,'Coordinate Reference System',6854,7302,'NAD83(2011) / OCRS_PDX (m)',''),
(2064,'Unit of Measure',9121,7302,'DDDMMSS.sss',''),
(2065,'Coordinate_Operation',7712,7301,'ETRF89 to Newlyn (Orkney Isles) height (2)',''),
(2066,'Unit of Measure',9120,7302,'HDMS',''),
(2067,'Coordinate Reference System',7707,7301,'Newlyn (Offshore) height',''),
(2068,'Unit of Measure',9119,7302,'HDM',''),
(2069,'Coordinate_Operation',7709,7302,'OSTN15_NTv2',''),
(2070,'Unit of Measure',9117,7302,'Hdeg',''),
(2071,'Coordinate_Operation',7709,7301,'OSGB 1936 to ETRF2000 (1)',''),
(2072,'Unit of Measure',9118,7302,'DMH',''),
(2073,'Coordinate_Operation',7708,7302,'OSTN15',''),
(2074,'Unit of Measure',9116,7302,'degH',''),
(2075,'Coordinate_Operation',7708,7301,'OSGB 1936 / British National Grid to ETRF97 (3)',''),
(2076,'Datum',6637,7302,'Perroud 1950',''),
(2077,'Datum',6634,7301,'MHNC72',''),
(2078,'Datum',6627,7302,'RGR92',''),
(2079,'Datum',6624,7302,'RGFG95',''),
(2080,'Datum',6623,7302,'CSG67',''),
(2081,'Coordinate Reference System',6855,7302,'NAD83(2011) / OCRS_PDX (ft)',''),
(2082,'Datum',6648,7302,'ITRF89',''),
(2083,'Datum',6649,7302,'ITRF90',''),
(2084,'Datum',6650,7302,'ITRF91',''),
(2085,'Datum',6651,7302,'ITRF92',''),
(2086,'Datum',6652,7302,'ITRF93',''),
(2087,'Datum',6653,7302,'ITRF94',''),
(2088,'Datum',6654,7302,'ITRF96',''),
(2089,'Datum',6655,7302,'ITRF97',''),
(2090,'Datum',6656,7302,'ITRF2000',''),
(2091,'Datum',6623,7301,'Guyane Francaise',''),
(2092,'Coordinate Reference System',6856,7302,'CORS96 / OCRS_SLE (m)',''),
(2093,'Datum',5151,7302,'NGNC69',''),
(2094,'Coordinate Reference System',6857,7302,'CORS96 / OCRS_SLE (ft)',''),
(2095,'Coordinate Reference System',4346,7301,'ETRF89 (geocentric)',''),
(2096,'Coordinate Reference System',4346,7301,'EUREF89 (geocentric)',''),
(2097,'Datum',6638,7302,'St. Pierre et Miquelon 1950',''),
(2098,'Coordinate Reference System',4638,7302,'St Pierre Miquelon 1950',''),
(2099,'Coordinate Reference System',66386405,7302,'St Pierre Miquelon (deg)',''),
(2100,'Coordinate_Operation',1923,7302,'St. Pierre et Miquelon 1950 to WGS 84 (1)',''),
(2101,'Coordinate_Operation',19981,7302,'Lambert NC',''),
(2102,'Coordinate Reference System',2984,7302,'RGNC 1991 / Lambert NC',''),
(2103,'Coordinate_Operation',13633,7302,'Oregon LCC (m)',''),
(2104,'Coordinate_Operation',15374,7302,'Oregon GIC Lambert (ft)',''),
(2105,'Coordinate Reference System',6858,7302,'NAD83(2011) / OCRS_SLE (m)',''),
(2106,'Coordinate Reference System',2985,7301,'Petrels 1972 / Terre Adelie Stereo',''),
(2107,'Coordinate Reference System',2986,7301,'Perroud 1950 / Terre Adelie Stereo',''),
(2108,'Coordinate Reference System',4634,7301,'MHNC72',''),
(2109,'Coordinate Reference System',66346405,7301,'MHNC72 (deg)',''),
(2110,'Coordinate Reference System',2982,7301,'MHNC72 / UTM zone 58S',''),
(2111,'Coordinate_Operation',1909,7301,'Fort Desaix to RRAF 1991 (1)',''),
(2112,'Coordinate_Operation',1910,7301,'Fort Desaix to RRAF 1991 (2)',''),
(2113,'Coordinate_Operation',1903,7301,'Fort Marigot to RRAF 1991 (1)',''),
(2114,'Coordinate_Operation',1904,7301,'Sainte Anne to RRAF 1991 (1)',''),
(2115,'Coordinate_Operation',1905,7301,'Sainte Anne to RRAF 1991 (2)',''),
(2116,'Datum',6647,7302,'ITRF88',''),
(2117,'Datum',6645,7302,'RGNC91',''),
(2118,'Datum',6640,7302,'RRAF91',''),
(2119,'Coordinate Reference System',61436405,7301,'Cte D''Ivoire (deg)','Same alias also applied to Locodjo 1965 (deg) (code 61426405).'),
(2120,'Coordinate Reference System',61436405,7301,'Port Bouet (deg)','Same alias also applied to Locodjo 1965 (deg) (code 61426405).'),
(2121,'Coordinate Reference System',61766413,7302,'AAD98 (3D deg)',''),
(2122,'Coordinate Reference System',4339,7302,'AAD98 (3D)',''),
(2123,'Coordinate Reference System',61766405,7302,'AAD98 (deg)',''),
(2124,'Coordinate Reference System',4340,7302,'AAD98 (geocentric)',''),
(2125,'Coordinate Reference System',61836405,7301,'Graciosa (deg)','The same name is also used for the 1995 adjustment (see CRS code 66656405).'),
(2126,'Coordinate Reference System',61826405,7301,'Observatorio Flores (deg)',''),
(2127,'Coordinate Reference System',61846405,7301,'Sao Braz (deg)',''),
(2128,'Coordinate Reference System',62116405,7301,'Genuk (deg)',''),
(2129,'Coordinate Reference System',68136405,7301,'Genuk (Jakarta) (deg)',''),
(2130,'Coordinate Reference System',62156405,7302,'BD 50 (deg)',''),
(2131,'Coordinate Reference System',68096405,7302,'BD 50 (Brussels) (deg)',''),
(2132,'Coordinate Reference System',63136405,7302,'BD 72 (deg)',''),
(2133,'Coordinate Reference System',62276405,7301,'Levant (deg)',''),
(2134,'Coordinate Reference System',63146405,7310,'PD/83 (deg)','Used for describing result of transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(2135,'Coordinate Reference System',63146405,7310,'RD/83 (deg)','Used for describing result of transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(2136,'Coordinate Reference System',62296405,7301,'Old Egyptian (deg)','New Egyptian (deg) is an alias for Egypt 1930 (deg) (code 61996405).'),
(2137,'Coordinate Reference System',61996405,7301,'New Egyptian (deg)','Old Egyptian (deg) is an alias for Egypt 1907 (deg) (code 62296405).'),
(2138,'Coordinate Reference System',62586413,7301,'ETRF89 (3D deg)',''),
(2139,'Coordinate Reference System',4345,7301,'ETRF89 (3D)',''),
(2140,'Coordinate Reference System',62586405,7301,'ETRF89 (deg)',''),
(2141,'Coordinate Reference System',62586413,7301,'EUREF89 (3D deg)',''),
(2142,'Coordinate Reference System',4345,7301,'EUREF89 (3D)',''),
(2143,'Coordinate Reference System',62586405,7301,'EUREF89 (deg)',''),
(2144,'Coordinate Reference System',61326405,7301,'Final Datum 1958 (Iran) (deg)',''),
(2145,'Coordinate Reference System',66116405,7302,'HK1980 (deg)',''),
(2146,'Coordinate Reference System',62076405,7301,'Lisbon 1937 (deg)',''),
(2147,'Coordinate Reference System',68036405,7301,'Lisbon 1937 (Lisbon) (deg)',''),
(2148,'Coordinate Reference System',4356,7302,'LKS94 (geocentric)',''),
(2149,'Coordinate Reference System',61266405,7302,'LKS94 (deg)',''),
(2150,'Coordinate Reference System',4126,7302,'LKS94','This same alias is used for both geographical and projected CRSs.'),
(2151,'Coordinate Reference System',4355,7302,'LKS94 (3D)',''),
(2152,'Coordinate Reference System',61266413,7302,'LKS94 (3D deg)',''),
(2153,'Coordinate Reference System',61426405,7301,'Cte D''Ivoire (deg)','Same alias also applied to Abidjan 1987 (deg) (code 61436405).'),
(2154,'Coordinate Reference System',61426405,7301,'Port Bouet (deg)','Same alias also applied to Abidjan 1987 (deg) (code 61436405).'),
(2155,'Coordinate Reference System',61816405,7301,'LUREF (deg)',''),
(2156,'Coordinate Reference System',63126405,7309,'D48 (deg)',''),
(2157,'Coordinate Reference System',68056405,7309,'D48 (Ferro) (deg)',''),
(2158,'Coordinate Reference System',63126405,7308,'HR1901 (deg)',''),
(2159,'Coordinate Reference System',68056405,7308,'HR1901 (Ferro) (deg)',''),
(2160,'Coordinate Reference System',62686405,7302,'NAD Michigan (deg)',''),
(2161,'Coordinate Reference System',66096405,7302,'CGQ77 (deg)',''),
(2162,'Coordinate Reference System',62726405,7301,'GD49 (deg)',''),
(2163,'Coordinate Reference System',61346405,7302,'PSD93 (deg)',''),
(2164,'Coordinate Reference System',66206405,7301,'12th Parallel traverse (deg)',''),
(2165,'Coordinate Reference System',62826405,7301,'Congo 1960 Pointe Noire (deg)',''),
(2166,'Coordinate Reference System',61906413,7301,'National Geodetic System [Argentina] (3D deg)','see http://www.igm.gov.ar/posgar.html'),
(2167,'Coordinate Reference System',4365,7301,'National Geodetic System [Argentina] (3D)','see http://www.igm.gov.ar/posgar.html'),
(2168,'Coordinate Reference System',61906405,7301,'National Geodetic System [Argentina] (deg)','see http://www.igm.gov.ar/posgar.html'),
(2169,'Coordinate Reference System',4366,7301,'National Geodetic System [Argentina] (geocentric)','see http://www.igm.gov.ar/posgar.html'),
(2170,'Coordinate Reference System',61786405,7301,'42/83 (deg)',''),
(2171,'Coordinate Reference System',66136405,7301,'P2 Exc (deg)','Oil industry extension in the Mahakam delta region. Also known as P2 Exc-T9 and Samboja.'),
(2172,'Coordinate Reference System',66136405,7301,'P2 Exc-T9 (deg)','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and Samboja.'),
(2173,'Coordinate Reference System',66136405,7301,'Samboja (deg)','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and P2 Exc-T9.'),
(2174,'Coordinate Reference System',4820,7301,'Samboja (Jakarta)',''),
(2175,'Coordinate Reference System',68206405,7301,'Samboja (Jakarta) (deg)',''),
(2176,'Coordinate Reference System',63006405,7301,'1975 Mapping Adjustment (deg)',''),
(2177,'Coordinate Reference System',63266405,7311,'DGN-95 (deg)','Datum Geodesi Nasional 1995 (DGN-95) is a synonym for WGS 84 in Indonesia.'),
(2178,'Coordinate Reference System',6859,7302,'NAD83(2011) / OCRS_SLE (ft)',''),
(2179,'Area',2832,7302,'BC',''),
(2180,'Coordinate_Operation',19984,7302,'BC Albers',''),
(2181,'Coordinate Reference System',6870,1038,'KRGJSH-2010','Several CRSs forming KRGJSH-2010 use this alias.'),
(2182,'Coordinate Reference System',6862,7302,'NAD83(2011) / OCRS_SAN (m)',''),
(2183,'Coordinate Reference System',6862,7301,'NAD83(2011) / Oregon Sweet Home-Sisters zone (m)','Previous name.'),
(2184,'Coordinate Reference System',4289,7315,'Stelsel van de Rijksdriehoeksmeting','Official Dutch name of this CRS.'),
(2185,'Coordinate Reference System',6863,7302,'NAD83(2011) / OCRS_SAN (ft)',''),
(2186,'Coordinate_Operation',19929,7301,'2.5 gon V 0:-15',''),
(2187,'Coordinate_Operation',19929,7301,'Swedish National Projection',''),
(2188,'Coordinate Reference System',3019,7301,'RT90 7.5 gon V 0:-15',''),
(2189,'Coordinate Reference System',6798,7302,'NAD83(2011) / OCRS_BBU (m)',''),
(2190,'Coordinate Reference System',3020,7301,'RT90 5 gon V 0:-15',''),
(2191,'Coordinate Reference System',3021,7301,'RT90 2.5 gon V 0:-15',''),
(2192,'Coordinate Reference System',3022,7301,'RT90 0 gon 0:-15',''),
(2193,'Coordinate Reference System',3023,7301,'RT90 2.5 gon O 0:-15',''),
(2194,'Coordinate Reference System',3024,7301,'RT90 5 gon O 0:-15',''),
(2195,'Datum',6659,7302,'ISN93',''),
(2196,'Coordinate Reference System',6790,7302,'NAD83(2011) / OCRS_BKF (m)',''),
(2197,'Coordinate_Operation',19986,1029,'LAEA',''),
(2198,'Coordinate Reference System',6799,7302,'NAD83(2011) / OCRS_BBU (ft)',''),
(2199,'Datum',6300,7302,'TM75',''),
(2200,'Datum',6300,7301,'1975 Mapping Adjustment',''),
(2201,'Coordinate_Operation',1953,7307,'(IE_Ireland65 to ETRS89 - see alias remarks)','IE_Ireland65 to ETRS89 applies to the Republic of Ireland. Also referred to in EuroGeographics as NI_Ireland65 to ETRS89 for Northern Ireland.'),
(2202,'Unit of Measure',9095,7302,'ftBr(36)',''),
(2203,'Unit of Measure',9095,7306,'ft[Br36]',''),
(2204,'Unit of Measure',9095,7301,'foot',''),
(2205,'Datum',5153,7302,'NGG1977',''),
(2206,'Datum',5154,7301,'Martinique 1987',''),
(2207,'Coordinate Reference System',6797,7301,'NAD83(CORS96) / Oregon Bend-Vale zone (ft)','Previous name.'),
(2208,'Coordinate Reference System',5758,7301,'IGN89 height',''),
(2209,'Datum',5156,7301,'Reunion 1989',''),
(2210,'Datum',5156,7302,'IGN89',''),
(2211,'Datum',5155,7301,'IGN 1988',''),
(2212,'Datum',5154,7302,'IGN87',''),
(2213,'Coordinate Reference System',6797,7302,'CORS96 / OCRS_BBU (ft)',''),
(2214,'Datum',6661,7302,'LKS92',''),
(2215,'Datum',6615,7301,'Madeira SE Base',''),
(2216,'Datum',6665,7301,'Graciosa','The same name is also used for the 1948 adjustment (see datum code 6183).'),
(2217,'Datum',6665,7302,'Azores Central 1995',''),
(2218,'Datum',6665,7301,'Base SW','The same name is also used for the 1948 adjustment (see datum code 6183).'),
(2219,'Datum',6183,7301,'Base SW','The same name is also used for the 1995 adjustment (see datum code 6665).'),
(2220,'Datum',6664,7301,'Sao Bras','The same name is also used for the 1940 adjustment (see datum code 6184).'),
(2221,'Datum',6664,7302,'Azores Oriental 1995',''),
(2222,'Datum',6615,7301,'Base SE','The same name is also used for the 1995 adjustment (see datum code 6663).'),
(2223,'Datum',6663,7301,'Base SE','The same name is also used for the 1936 adjustment (see datum code 6615).'),
(2224,'Datum',6663,7301,'Madeira SE Base 1995',''),
(2225,'Coordinate Reference System',4183,7301,'Base SW','The same name is also used for the 1995 adjustment (see CRS code 4665).'),
(2226,'Coordinate Reference System',4665,7301,'Base SW','The same name is also used for the 1948 adjustment (see CRS code 4183).'),
(2227,'Coordinate Reference System',4665,7301,'Graciosa','The same name is also used for the 1948 adjustment (see CRS code 4183).'),
(2228,'Coordinate Reference System',2189,7301,'Base SW / UTM zone 26N','The same name is also used for the 1995 adjustment (see CRS code 3063).'),
(2229,'Coordinate Reference System',4664,7301,'Sao Braz','The same name is also used for the 1940 adjustment (see CRS code 4184).'),
(2230,'Coordinate Reference System',3062,7301,'Sao Braz / UTM zone 26N','The same name is also used for the 1940 adjustment (see CRS code 2190).'),
(2231,'Coordinate Reference System',3063,7301,'Base SW / UTM zone 26N','The same name is also used for the 1948 adjustment (see CRS code 2189).'),
(2232,'Coordinate Reference System',3063,7301,'Graciosa / UTM zone 26N','The same name is also used for the 1948 adjustment (see CRS code 2189).'),
(2233,'Coordinate Reference System',4615,7301,'Porto Santo 1936',''),
(2234,'Coordinate Reference System',4663,7301,'Base SE','The same name is also used for the 1936 adjustment (see CRS code 4615).'),
(2235,'Coordinate Reference System',2942,7301,'Base SE / UTM zone 28N','The same name is also used for the 1995 adjustment (see CRS code 3061).'),
(2236,'Coordinate Reference System',3061,7301,'Base SE / UTM zone 28N','The same name is also used for the 1948 adjustment (see CRS code 2942).'),
(2237,'Datum',6615,7301,'Porto Santo',''),
(2238,'Coordinate_Operation',1886,7301,'Base SW to WGS 84 (1)',''),
(2239,'Coordinate_Operation',1888,7301,'Base SE to WGS 84 (1)',''),
(2240,'Coordinate_Operation',1966,7301,'Base SE to WGS 84 (2)',''),
(2241,'Coordinate_Operation',1967,7301,'Base SE to WGS 84 (3)',''),
(2242,'Coordinate_Operation',1980,7301,'Graciosa to WGS 84 (10)',''),
(2243,'Coordinate_Operation',1981,7301,'Base SW to WGS 84 (11)',''),
(2244,'Coordinate_Operation',1972,7301,'Base SW to WGS 84 (2)',''),
(2245,'Coordinate_Operation',1973,7301,'Base SW to WGS 84 (3)',''),
(2246,'Coordinate_Operation',1974,7301,'Base SW to WGS 84 (4)',''),
(2247,'Coordinate_Operation',1975,7301,'Base SW to WGS 84 (5)',''),
(2248,'Coordinate_Operation',1976,7301,'Base SW to WGS 84 (6)',''),
(2249,'Coordinate_Operation',1977,7301,'Base SW to WGS 84 (7)',''),
(2250,'Coordinate_Operation',1978,7301,'Base SW to WGS 84 (8)',''),
(2251,'Coordinate_Operation',1979,7301,'Base SW to WGS 84 (9)',''),
(2252,'Coordinate_Operation',1980,7301,'Base SW to WGS 84 (10)',''),
(2253,'Coordinate_Operation',1981,7301,'Graciosa to WGS 84 (11)',''),
(2254,'Coordinate_Operation',1972,7301,'Graciosa to WGS 84 (2)',''),
(2255,'Coordinate_Operation',1973,7301,'Graciosa to WGS 84 (3)',''),
(2256,'Coordinate_Operation',1974,7301,'Graciosa to WGS 84 (4)',''),
(2257,'Coordinate_Operation',1975,7301,'Graciosa to WGS 84 (5)',''),
(2258,'Coordinate_Operation',1976,7301,'Graciosa to WGS 84 (6)',''),
(2259,'Coordinate_Operation',1977,7301,'Graciosa to WGS 84 (7)',''),
(2260,'Coordinate_Operation',1978,7301,'Graciosa to WGS 84 (8)',''),
(2261,'Coordinate_Operation',1979,7301,'Graciosa to WGS 84 (9)',''),
(2262,'Coordinate_Operation',1992,7302,'D73 to ETRS89 (3)',''),
(2263,'Coordinate_Operation',1968,7301,'Sao Braz to WGS 84 (2)',''),
(2264,'Coordinate_Operation',1969,7301,'Sao Braz to WGS 84 (3)',''),
(2265,'Coordinate_Operation',1970,7301,'Sao Braz to WGS 84 (4)',''),
(2266,'Coordinate_Operation',1971,7301,'Sao Braz to WGS 84 (5)',''),
(2267,'Coordinate_Operation',1982,7301,'Observatario Flores to WGS 84 (2)',''),
(2268,'Coordinate_Operation',1984,7301,'Lisbon 1937 to WGS 84 (3)',''),
(2269,'Coordinate_Operation',1756,7301,'Lisbon 1937 (Lisbon) to Lisbon 1937 (1)',''),
(2270,'Coordinate_Operation',8637,7301,'Lisbon 1937 (Lisbon) to WGS 84 (1)',''),
(2271,'Coordinate_Operation',1655,7301,'Lisbon 1937 to ETRS89 (1)',''),
(2272,'Coordinate_Operation',1790,7301,'Lisbon 1937 to ETRS89 (2)',''),
(2273,'Coordinate_Operation',1988,7301,'Lisbon 1937 to WGS 84 (4)',''),
(2274,'Coordinate_Operation',17336,7301,'0 gon 0:-15',''),
(2275,'Coordinate_Operation',17337,7301,'2.5 gon O 0:-15',''),
(2276,'Coordinate_Operation',17338,7301,'5 gon O 0:-15',''),
(2277,'Coordinate_Operation',17335,7301,'5 gon V 0:-15',''),
(2278,'Coordinate_Operation',17334,7301,'7.5 gon V 0:-15',''),
(2279,'Coordinate Reference System',3028,7301,'RT38 0 gon 0:-15',''),
(2280,'Coordinate Reference System',3029,7301,'RT38 2.5 gon O 0:-15',''),
(2281,'Coordinate Reference System',3027,7301,'RT38 2.5 gon V 0:-15',''),
(2282,'Coordinate Reference System',3030,7301,'RT38 5 gon O 0:-15',''),
(2283,'Coordinate Reference System',3026,7301,'RT38 5 gon V 0:-15',''),
(2284,'Coordinate Reference System',3025,7301,'RT38 2.5 gon V 0:-15',''),
(2285,'Datum',6667,7301,'IKBD-92',''),
(2286,'Unit of Measure',9122,7302,'deg',''),
(2287,'Coordinate Reference System',7793,7301,'RDN2008 / TM34 (E-N)',''),
(2288,'Coordinate Reference System',66656405,7301,'Base SW (deg)','The same name is also used for the 1948 adjustment (see CRS code 61836405).'),
(2289,'Coordinate Reference System',61836405,7301,'Base SW (deg)','The same name is also used for the 1995 adjustment (see CRS code 66656405).'),
(2290,'Coordinate Reference System',66656405,7301,'Graciosa (deg)','The same name is also used for the 1948 adjustment (see CRS code 61836405).'),
(2291,'Coordinate Reference System',66646405,7301,'Sao Braz (deg)','The same name is also used for the 1940 adjustment (see CRS code 61846405).'),
(2292,'Coordinate Reference System',4615,7301,'Base SE','The same name is also used for the 1995 adjustment (see CRS code 4663).'),
(2293,'Coordinate Reference System',66156405,7301,'Base SE (deg)','The same name is also used for the 1936 adjustment (see CRS code 66636405).'),
(2294,'Coordinate Reference System',66636405,7301,'Base SE (deg)','The same name is also used for the 1936 adjustment (see CRS code 66156405).'),
(2295,'Coordinate Reference System',66156405,7301,'Porto Santo 1936 (deg)',''),
(2296,'Coordinate_Operation',1792,7302,'D73 to ETRS89 (2)',''),
(2297,'Coordinate_Operation',1657,7302,'D73 to ETRS89 (1)',''),
(2298,'Coordinate_Operation',1983,7302,'D73 to WGS 84 (3)',''),
(2299,'Coordinate_Operation',1987,7302,'D73 to WGS 84 (4)',''),
(2300,'Coordinate_Operation',1986,7302,'B DLx to WGS 84 (1)',''),
(2301,'Coordinate_Operation',1990,7302,'B DLx to WGS 84 (2)',''),
(2302,'Coordinate_Operation',1655,7302,'DLx to ETRS89 (1)',''),
(2303,'Coordinate_Operation',1790,7302,'DLx to ETRS89 (2)',''),
(2304,'Coordinate_Operation',1984,7302,'DLx to WGS 84 (3)',''),
(2305,'Coordinate_Operation',1988,7302,'DLx to WGS 84 (4)',''),
(2306,'Coordinate Reference System',25884,7301,'LKS92 / TM Baltic93','Alias used in Latvia.'),
(2307,'Coordinate Reference System',25884,7301,'LKS94 / TM Baltic93','Alias used in Lithuania.'),
(2308,'Coordinate Reference System',25884,7301,'EST97 / TM Baltic93','Alias used in Estonia.'),
(2309,'Coordinate Reference System',3300,7317,'EST92','This same alias is used for both geographical and projected CRSs.'),
(2310,'Coordinate Reference System',3301,7317,'EST97','This same alias is used for both geographical and projected CRSs.'),
(2311,'Coordinate Reference System',3059,7301,'LKS92','This alias is used for both geographical and projected CRSs.'),
(2312,'Coordinate_Operation',1997,7302,'DLx to ETRS89 (2)',''),
(2313,'Coordinate_Operation',1997,7301,'Lisbon 1937 to ETRS89 (2)',''),
(2314,'Datum',6668,7302,'ED79',''),
(2315,'Datum',6131,7301,'Indian (DMA Reduced)',''),
(2316,'Coordinate Reference System',4131,7301,'Indian (DMA Reduced)',''),
(2317,'Coordinate Reference System',61316405,7301,'Indian (DMA Reduced) (deg)',''),
(2318,'Coordinate Reference System',3176,7301,'Indian (DMA Reduced) / TM 106 NE',''),
(2319,'Coordinate Reference System',3148,7301,'Indian (DMA Reduced) / UTM zone 48N',''),
(2320,'Coordinate Reference System',3149,7301,'Indian (DMA Reduced) / UTM zone 49N',''),
(2321,'Coordinate Reference System',4930,7302,'AAD98',''),
(2322,'Coordinate Reference System',4936,7301,'ETRF89',''),
(2323,'Coordinate Reference System',4936,7301,'EUREF89',''),
(2324,'Coordinate Reference System',6863,7301,'NAD83(2011) / Oregon Sweet Home-Sisters zone (ft)','Previous name.'),
(2325,'Coordinate Reference System',6796,7302,'CORS96 / OCRS_BBU (m)',''),
(2326,'Coordinate Reference System',4950,7301,'LKS94 (ETRS89)',''),
(2327,'Coordinate Reference System',4931,7302,'AAD98',''),
(2328,'Coordinate Reference System',4937,7301,'ETRF89',''),
(2329,'Coordinate Reference System',4937,7301,'EUREF89',''),
(2330,'Coordinate Reference System',4951,7301,'LKS94 (ETRS89)',''),
(2331,'Coordinate Reference System',6861,7301,'NAD83(CORS96) / Oregon Sweet Home-Sisters zone (ft)','Previous name.'),
(2332,'Coordinate Reference System',6860,7302,'CORS96 / OCRS_SAN (m)',''),
(2333,'Datum',6265,7301,'Rome 1940',''),
(2334,'Datum',6806,7301,'Rome 1940 (Rome)',''),
(2335,'Datum',6670,7302,'IGM95',''),
(2336,'Coordinate Reference System',4265,7301,'Rome 1940',''),
(2337,'Coordinate Reference System',4806,7301,'Rome 1940 (Rome)',''),
(2338,'Coordinate Reference System',3004,7301,'Rome 1940 / Italy zone 2',''),
(2339,'Coordinate Reference System',3003,7301,'Rome 1940 / Italy zone 1',''),
(2340,'Coordinate_Operation',1094,7301,'Rome 1940 to WGS 84 (11)',''),
(2341,'Coordinate_Operation',1093,7301,'Rome 1940 to WGS 84 (10)',''),
(2342,'Coordinate_Operation',1092,7301,'Rome 1940 to WGS 84 (9)',''),
(2343,'Coordinate_Operation',1091,7301,'Rome 1940 to WGS 84 (8)',''),
(2344,'Coordinate_Operation',1090,7302,'Rome 1940 to WGS 84 (7)',''),
(2345,'Coordinate_Operation',1089,7301,'Rome 1940 to WGS 84 (6)',''),
(2346,'Coordinate_Operation',1088,7301,'Rome 1940 to WGS 84 (5)',''),
(2347,'Coordinate_Operation',1664,7301,'Rome 1940 to WGS 84 (3)',''),
(2348,'Coordinate_Operation',1663,7301,'Rome 1940 to ETRS89 (3)',''),
(2349,'Coordinate_Operation',1661,7301,'Rome 1940 to ETRS89 (2)',''),
(2350,'Coordinate_Operation',1660,7301,'Rome 1940 to WGS 84 (4)',''),
(2351,'Coordinate_Operation',1169,7301,'Rome 1940 to WGS 84 (1)',''),
(2352,'Coordinate_Operation',1662,7301,'Rome 1940 to WGS 84 (2)',''),
(2353,'Coordinate_Operation',1659,7301,'Rome 1940 to ETRS89 (1)',''),
(2354,'Coordinate_Operation',19995,7302,'Jordan TM',''),
(2355,'Coordinate Reference System',3066,7301,'ED50 / Jordan Transverse Mercator',''),
(2356,'Datum',6673,7302,'CI1979',''),
(2357,'Coordinate_Operation',16065,7301,'UTM zone 35N',''),
(2358,'Datum',5172,7302,'NG-L',''),
(2359,'Coordinate_Operation',1642,7302,'LUREF to ETRS89 (1)',''),
(2360,'Coordinate_Operation',1643,7302,'LUREF to WGS 84 (1)',''),
(2361,'Coordinate_Operation',1079,7302,'LUREF to WGS 84 (2)',''),
(2362,'Coordinate_Operation',1078,7302,'LUREF to ETRS89 (2)',''),
(2363,'Datum',5174,7302,'NN1954',''),
(2364,'Datum',5173,7301,'TNVCN99',''),
(2365,'Coordinate_Operation',10021,7302,'ETRS89 to ODN (1)',''),
(2366,'Coordinate_Operation',10022,7301,'ETRS89 to Belfast Lough height (1)',''),
(2367,'Datum',6173,7301,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(2368,'Coordinate Reference System',2157,7301,'ETRS89 / ITM','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(2369,'Coordinate Reference System',6860,7301,'NAD83(CORS96) / Oregon Sweet Home-Sisters zone (m)','Previous name.'),
(2370,'Coordinate Reference System',4173,7301,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(2371,'Coordinate_Operation Method',9636,7301,'Molodenski-Badekas transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(2372,'Coordinate_Operation Method',9607,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Position Vector 7-param. Transformation method (code 9606).'),
(2373,'Coordinate_Operation Method',9606,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Coordinate Frame rotation method (code 9607).'),
(2374,'Coordinate_Operation',1071,7301,'Old Israeli to New Israeli (1)',''),
(2375,'Coordinate_Operation',1072,7301,'Old Israel to New Israel (1)',''),
(2376,'Coordinate_Operation',6965,7302,'Michigan North','This alias is ambiguous as also used for SPCS83 projection.'),
(2377,'Datum',6281,7301,'Old Israeli Datum','Alias used within Israel.'),
(2378,'Datum',6281,7302,'OID','Abbreviation of "Old Israeli Datum"; used within Israel.'),
(2379,'Datum',1146,7301,'Abu Dhabi Vertical Datum',''),
(2380,'Datum',6674,7302,'SIRGAS 2000',''),
(2381,'Coordinate Reference System',4269,7301,'NAD83 (1986)',''),
(2382,'Coordinate Reference System',4170,7301,'SIRGAS',''),
(2383,'Coordinate Reference System',4974,7301,'SIRGAS',''),
(2384,'Coordinate Reference System',32000,7317,'SIRGAS / UTM zone 25S',''),
(2385,'Coordinate Reference System',31999,7317,'SIRGAS / UTM zone 24S',''),
(2386,'Coordinate Reference System',31998,7317,'SIRGAS / UTM zone 23S',''),
(2387,'Coordinate Reference System',31997,7317,'SIRGAS / UTM zone 22S',''),
(2388,'Coordinate Reference System',31996,7317,'SIRGAS / UTM zone 21S',''),
(2389,'Coordinate Reference System',31995,7317,'SIRGAS / UTM zone 20S',''),
(2390,'Coordinate Reference System',31994,7317,'SIRGAS / UTM zone 19S',''),
(2391,'Coordinate Reference System',31993,7317,'SIRGAS / UTM zone 18S',''),
(2392,'Coordinate Reference System',31992,7317,'SIRGAS / UTM zone 17S',''),
(2393,'Coordinate Reference System',31991,7317,'SIRGAS / UTM zone 22N',''),
(2394,'Coordinate Reference System',31990,7317,'SIRGAS / UTM zone 21N',''),
(2395,'Coordinate Reference System',31989,7317,'SIRGAS / UTM zone 20N',''),
(2396,'Coordinate Reference System',31988,7317,'SIRGAS / UTM zone 19N',''),
(2397,'Coordinate Reference System',31987,7317,'SIRGAS / UTM zone 18N',''),
(2398,'Coordinate Reference System',31986,7317,'SIRGAS / UTM zone 17N',''),
(2399,'Coordinate Reference System',4975,7301,'SIRGAS',''),
(2400,'Coordinate Reference System',6861,7302,'CORS96 / OCRS_SAN (ft)',''),
(2401,'Coordinate Reference System',3069,7302,'NAD27 / WTM 27',''),
(2402,'Coordinate Reference System',5723,7301,'Japanese Standard Levelling Datum height','This alias is ambiguous as it is used for all realisations.'),
(2403,'Coordinate_Operation',15545,7301,'SIRGAS 1995 geog3D to geog2D',''),
(2404,'Coordinate Reference System',7005,7302,'Nahrwan 1934 / UTM 37N',''),
(2405,'Coordinate_Operation',6877,7301,'Fuso Italia',''),
(2406,'Coordinate_Operation',15544,7301,'SIRGAS 1995 geocentric to geog3D',''),
(2407,'Coordinate_Operation',15508,7301,'ETRF89 geocentric to geog3D',''),
(2408,'Coordinate_Operation',15508,7301,'EUREF89 geocentric to geog3D',''),
(2409,'Coordinate_Operation',15509,7301,'ETRF89 geocentric to geog3D',''),
(2410,'Coordinate_Operation',15509,7301,'EUREF89 geocentric to geog3D',''),
(2411,'Coordinate_Operation',15500,7302,'AAD98 geocentric to geog3D',''),
(2412,'Coordinate_Operation',15501,7302,'AAD98 geog3D to geog2D',''),
(2413,'Datum',6678,7302,'Lao 1997',''),
(2414,'Datum',5182,7302,'DHHN85',''),
(2415,'Datum',5183,7302,'SNN76',''),
(2416,'Coordinate Reference System',6875,7301,'RDN2008 / Fuso Italia (N-E)',''),
(2417,'Coordinate_Operation',5412,7302,'CD to PWD (1)',''),
(2418,'Coordinate_Operation',5413,7302,'CD height to WD depth',''),
(2419,'Coordinate_Operation',5414,7302,'WD to PWD',''),
(2420,'Datum',5172,7302,'NG95',''),
(2421,'Datum',5176,7302,'GHA',''),
(2422,'Datum',5177,7302,'NVN99',''),
(2423,'Datum',5178,7301,'RNGAP',''),
(2424,'Datum',5180,7301,'REDNAP',''),
(2425,'Datum',5181,7302,'DHHN92',''),
(2426,'Datum',5185,7301,'EOMA 1980',''),
(2427,'Datum',5186,7302,'PWD',''),
(2428,'Datum',5187,7302,'WD',''),
(2429,'Datum',5188,7302,'CD',''),
(2430,'Coordinate Reference System',6876,7301,'RDN2008 / Fuso 12 (N-E)',''),
(2431,'Coordinate Reference System',5787,7301,'Baltic 1980 height',''),
(2432,'Coordinate Reference System',5782,7301,'REDNAP height',''),
(2433,'Coordinate_Operation',6878,7301,'Zone 12',''),
(2434,'Coordinate_Operation',6872,7301,'Cte d''Ivoire to WGS 84 (2)',''),
(2435,'Coordinate Reference System',3072,7301,'Maine Coordinate System of 2000 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 East zone projection.'),
(2436,'Coordinate Reference System',3073,7301,'Maine Coordinate System of 2000 Central Zone','This alias also used for NAD83(HARN) / Maine CS2000 Central.'),
(2437,'Coordinate Reference System',3074,7301,'Maine Coordinate System of 2000 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 West zone projection.'),
(2438,'Coordinate Reference System',2802,7301,'Maine Coordinate System of 1983 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 East zone projection.'),
(2439,'Coordinate Reference System',2803,7301,'Maine Coordinate System of 1983 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 West zone projection.'),
(2440,'Coordinate Reference System',26783,7301,'Maine Coordinate System of 1927 East Zone',''),
(2441,'Coordinate Reference System',26784,7301,'Maine Coordinate System of 1927 West Zone',''),
(2442,'Coordinate Reference System',26984,7301,'Maine Coordinate System of 1983 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 West zone projection.'),
(2443,'Coordinate Reference System',26983,7301,'Maine Coordinate System of 1983 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 East zone projection.'),
(2444,'Coordinate_Operation',12150,7301,'Michigan GeoRef',''),
(2445,'Coordinate Reference System',3078,7301,'Michigan GeoRef','This alias is ambiguous as also used for NAD83(HARN) / Michigan Oblique Mercator.'),
(2446,'Coordinate_Operation',14251,7302,'TSMS',''),
(2447,'Coordinate_Operation',14254,7302,'TCMS/AEA',''),
(2448,'Coordinate_Operation',14253,7302,'TCMS/LC',''),
(2449,'Coordinate Reference System',3081,7302,'NAD83 / TSMS',''),
(2450,'Coordinate Reference System',3083,7302,'NAD83 / TX Albers',''),
(2451,'Coordinate Reference System',3083,7301,'Texas Centric Mapping System / Albers Equal Area','This alias is ambiguous as also used for NAD83(HARN) / Texas Centric Albers Equal Area.'),
(2452,'Coordinate Reference System',3082,7301,'Texas Centric Mapping System / Lambert Conformal','This alias is ambiguous as also used for NAD83(HARN) / Texas Centric Lambert Conformal.'),
(2453,'Coordinate Reference System',3082,7301,'TCMS/LC','This alias is ambiguous as also used for NAD83(HARN) / Texas Centric Lambert Conformal.'),
(2454,'Coordinate_Operation',19997,7302,'KTM',''),
(2455,'Coordinate_Operation',10088,7302,'JAD69 / National Grid to Ja1875 / Old Grid (1)',''),
(2456,'Coordinate_Operation',10087,7302,'Ja1875 / Old Grid to JAD69 / National Grid (1)',''),
(2457,'Coordinate_Operation',15527,7301,'NAD83(HPGN) geog3D to geog2D',''),
(2458,'Coordinate_Operation',15526,7301,'NAD83(HPGN) geocentric to geog3D',''),
(2459,'Coordinate Reference System',3091,7301,'NAD83(HPGN) / Kentucky Single Zone (ftUS)',''),
(2460,'Coordinate Reference System',3089,7302,'NAD83 / KY1Z (ftUS)',''),
(2461,'Coordinate Reference System',3087,7301,'NAD83(HPGN) / Florida GDL Albers',''),
(2462,'Coordinate Reference System',3085,7301,'NAD83(HPGN) / Texas Centric Albers Equal Area',''),
(2463,'Coordinate Reference System',3084,7301,'NAD83(HPGN) / Texas Centric Lambert Conformal',''),
(2464,'Coordinate Reference System',3079,7301,'NAD83(HPGN) / Michigan Oblique Mercator',''),
(2465,'Coordinate Reference System',3077,7301,'NAD83(HPGN) / Maine CS2000 West',''),
(2466,'Coordinate Reference System',3076,7301,'NAD83(HPGN) / Maine CS2000 Central',''),
(2467,'Coordinate Reference System',3075,7301,'NAD83(HPGN) / Maine CS2000 East',''),
(2468,'Coordinate Reference System',3071,7301,'NAD83(HPGN) / Wisconsin Transverse Mercator',''),
(2469,'Coordinate Reference System',3070,7302,'NAD83 / WTM 83',''),
(2470,'Coordinate Reference System',3088,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(2471,'Coordinate Reference System',3090,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(2472,'Coordinate_Operation',6872,7301,'Port Bouet to WGS 84 (2)',''),
(2473,'Coordinate Reference System',3090,7301,'NAD83(HPGN) / Kentucky Single Zone',''),
(2474,'Datum',6152,7301,'NAD83 (High Precision Geodetic Network)',''),
(2475,'Datum',6152,7301,'NAD83(HPGN)',''),
(2476,'Coordinate Reference System',4152,7301,'NAD83(HPGN)',''),
(2477,'Coordinate Reference System',4956,7301,'NAD83(HPGN)',''),
(2478,'Coordinate Reference System',4957,7301,'NAD83(HPGN)',''),
(2479,'Coordinate Reference System',2195,7301,'NAD83(HPGN) / UTM zone 2S',''),
(2480,'Coordinate Reference System',2759,7301,'NAD83(HPGN) / Alabama East',''),
(2481,'Coordinate Reference System',2760,7301,'NAD83(HPGN) / Alabama West',''),
(2482,'Coordinate Reference System',2761,7301,'NAD83(HPGN) / Arizona East',''),
(2483,'Coordinate Reference System',2762,7301,'NAD83(HPGN) / Arizona Central',''),
(2484,'Coordinate Reference System',2763,7301,'NAD83(HPGN) / Arizona West',''),
(2485,'Coordinate Reference System',2764,7301,'NAD83(HPGN) / Arkansas North',''),
(2486,'Coordinate Reference System',2765,7301,'NAD83(HPGN) / Arkansas South',''),
(2487,'Coordinate Reference System',2766,7301,'NAD83(HPGN) / California zone 1',''),
(2488,'Coordinate Reference System',2767,7301,'NAD83(HPGN) / California zone 2',''),
(2489,'Coordinate Reference System',2768,7301,'NAD83(HPGN) / California zone 3',''),
(2490,'Coordinate Reference System',2769,7301,'NAD83(HPGN) / California zone 4',''),
(2491,'Coordinate Reference System',2770,7301,'NAD83(HPGN) / California zone 5',''),
(2492,'Coordinate Reference System',2771,7301,'NAD83(HPGN) / California zone 6',''),
(2493,'Coordinate Reference System',2772,7301,'NAD83(HPGN) / Colorado North',''),
(2494,'Coordinate Reference System',2773,7301,'NAD83(HPGN) / Colorado Central',''),
(2495,'Coordinate Reference System',2774,7301,'NAD83(HPGN) / Colorado South',''),
(2496,'Coordinate Reference System',2775,7301,'NAD83(HPGN) / Connecticut',''),
(2497,'Coordinate Reference System',2776,7301,'NAD83(HPGN) / Delaware',''),
(2498,'Coordinate Reference System',2777,7301,'NAD83(HPGN) / Florida East',''),
(2499,'Coordinate Reference System',2778,7301,'NAD83(HPGN) / Florida West',''),
(2500,'Coordinate Reference System',2779,7301,'NAD83(HPGN) / Florida North',''),
(2501,'Coordinate Reference System',2780,7301,'NAD83(HPGN) / Georgia East',''),
(2502,'Coordinate Reference System',2781,7301,'NAD83(HPGN) / Georgia West',''),
(2503,'Coordinate Reference System',2782,7301,'NAD83(HPGN) / Hawaii zone 1',''),
(2504,'Coordinate Reference System',2783,7301,'NAD83(HPGN) / Hawaii zone 2',''),
(2505,'Coordinate Reference System',2784,7301,'NAD83(HPGN) / Hawaii zone 3',''),
(2506,'Coordinate Reference System',2785,7301,'NAD83(HPGN) / Hawaii zone 4',''),
(2507,'Coordinate Reference System',2786,7301,'NAD83(HPGN) / Hawaii zone 5',''),
(2508,'Coordinate Reference System',2787,7301,'NAD83(HPGN) / Idaho East',''),
(2509,'Coordinate Reference System',2788,7301,'NAD83(HPGN) / Idaho Central',''),
(2510,'Coordinate Reference System',2789,7301,'NAD83(HPGN) / Idaho West',''),
(2511,'Coordinate Reference System',2790,7301,'NAD83(HPGN) / Illinois East',''),
(2512,'Coordinate Reference System',2791,7301,'NAD83(HPGN) / Illinois West',''),
(2513,'Coordinate Reference System',2792,7301,'NAD83(HPGN) / Indiana East',''),
(2514,'Coordinate Reference System',2793,7301,'NAD83(HPGN) / Indiana West',''),
(2515,'Coordinate Reference System',2794,7301,'NAD83(HPGN) / Iowa North',''),
(2516,'Coordinate Reference System',2795,7301,'NAD83(HPGN) / Iowa South',''),
(2517,'Coordinate Reference System',2796,7301,'NAD83(HPGN) / Kansas North',''),
(2518,'Coordinate Reference System',2797,7301,'NAD83(HPGN) / Kansas South',''),
(2519,'Coordinate Reference System',2798,7301,'NAD83(HPGN) / Kentucky North',''),
(2520,'Coordinate Reference System',2799,7301,'NAD83(HPGN) / Kentucky South',''),
(2521,'Coordinate Reference System',2800,7301,'NAD83(HPGN) / Louisiana North',''),
(2522,'Coordinate Reference System',2801,7301,'NAD83(HPGN) / Louisiana South',''),
(2523,'Coordinate Reference System',2802,7301,'NAD83(HPGN) / Maine East',''),
(2524,'Coordinate Reference System',2803,7301,'NAD83(HPGN) / Maine West',''),
(2525,'Coordinate Reference System',2804,7301,'NAD83(HPGN) / Maryland',''),
(2526,'Coordinate Reference System',2805,7301,'NAD83(HPGN) / Massachusetts Mainland',''),
(2527,'Coordinate Reference System',2806,7301,'NAD83(HPGN) / Massachusetts Island',''),
(2528,'Coordinate Reference System',2807,7301,'NAD83(HPGN) / Michigan North',''),
(2529,'Coordinate Reference System',2808,7301,'NAD83(HPGN) / Michigan Central',''),
(2530,'Coordinate Reference System',2809,7301,'NAD83(HPGN) / Michigan South',''),
(2531,'Coordinate Reference System',2810,7301,'NAD83(HPGN) / Minnesota North',''),
(2532,'Coordinate Reference System',2811,7301,'NAD83(HPGN) / Minnesota Central',''),
(2533,'Coordinate Reference System',2812,7301,'NAD83(HPGN) / Minnesota South',''),
(2534,'Coordinate Reference System',2813,7301,'NAD83(HPGN) / Mississippi East',''),
(2535,'Coordinate Reference System',2814,7301,'NAD83(HPGN) / Mississippi West',''),
(2536,'Coordinate Reference System',2815,7301,'NAD83(HPGN) / Missouri East',''),
(2537,'Coordinate Reference System',2816,7301,'NAD83(HPGN) / Missouri Central',''),
(2538,'Coordinate Reference System',2817,7301,'NAD83(HPGN) / Missouri West',''),
(2539,'Coordinate Reference System',2818,7301,'NAD83(HPGN) / Montana',''),
(2540,'Coordinate Reference System',2819,7301,'NAD83(HPGN) / Nebraska',''),
(2541,'Coordinate Reference System',2820,7301,'NAD83(HPGN) / Nevada East',''),
(2542,'Coordinate Reference System',2821,7301,'NAD83(HPGN) / Nevada Central',''),
(2543,'Coordinate Reference System',2822,7301,'NAD83(HPGN) / Nevada West',''),
(2544,'Coordinate Reference System',2823,7301,'NAD83(HPGN) / New Hampshire',''),
(2545,'Coordinate Reference System',2824,7301,'NAD83(HPGN) / New Jersey',''),
(2546,'Coordinate Reference System',2825,7301,'NAD83(HPGN) / New Mexico East',''),
(2547,'Coordinate Reference System',2826,7301,'NAD83(HPGN) / New Mexico Central',''),
(2548,'Coordinate Reference System',2827,7301,'NAD83(HPGN) / New Mexico West',''),
(2549,'Coordinate Reference System',2828,7301,'NAD83(HPGN) / New York East',''),
(2550,'Coordinate Reference System',2829,7301,'NAD83(HPGN) / New York Central',''),
(2551,'Coordinate Reference System',2830,7301,'NAD83(HPGN) / New York West',''),
(2552,'Coordinate Reference System',2831,7301,'NAD83(HPGN) / New York Long Island',''),
(2553,'Coordinate Reference System',2832,7301,'NAD83(HPGN) / North Dakota North',''),
(2554,'Coordinate Reference System',2833,7301,'NAD83(HPGN) / North Dakota South',''),
(2555,'Coordinate Reference System',2834,7301,'NAD83(HPGN) / Ohio North',''),
(2556,'Coordinate Reference System',2835,7301,'NAD83(HPGN) / Ohio South',''),
(2557,'Coordinate Reference System',2836,7301,'NAD83(HPGN) / Oklahoma North',''),
(2558,'Coordinate Reference System',2837,7301,'NAD83(HPGN) / Oklahoma South',''),
(2559,'Coordinate Reference System',2838,7301,'NAD83(HPGN) / Oregon North',''),
(2560,'Coordinate Reference System',2839,7301,'NAD83(HPGN) / Oregon South',''),
(2561,'Coordinate Reference System',2840,7301,'NAD83(HPGN) / Rhode Island',''),
(2562,'Coordinate Reference System',2841,7301,'NAD83(HPGN) / South Dakota North',''),
(2563,'Coordinate Reference System',2842,7301,'NAD83(HPGN) / South Dakota South',''),
(2564,'Coordinate Reference System',2843,7301,'NAD83(HPGN) / Tennessee',''),
(2565,'Coordinate Reference System',2844,7301,'NAD83(HPGN) / Texas North',''),
(2566,'Coordinate Reference System',2845,7301,'NAD83(HPGN) / Texas North Central',''),
(2567,'Coordinate Reference System',2846,7301,'NAD83(HPGN) / Texas Central',''),
(2568,'Coordinate Reference System',2847,7301,'NAD83(HPGN) / Texas South Central',''),
(2569,'Coordinate Reference System',2848,7301,'NAD83(HPGN) / Texas South',''),
(2570,'Coordinate Reference System',2849,7301,'NAD83(HPGN) / Utah North',''),
(2571,'Coordinate Reference System',2850,7301,'NAD83(HPGN) / Utah Central',''),
(2572,'Coordinate Reference System',2851,7301,'NAD83(HPGN) / Utah South',''),
(2573,'Coordinate Reference System',2852,7301,'NAD83(HPGN) / Vermont',''),
(2574,'Coordinate Reference System',2853,7301,'NAD83(HPGN) / Virginia North',''),
(2575,'Coordinate Reference System',2854,7301,'NAD83(HPGN) / Virginia South',''),
(2576,'Coordinate Reference System',2855,7301,'NAD83(HPGN) / Washington North',''),
(2577,'Coordinate Reference System',2856,7301,'NAD83(HPGN) / Washington South',''),
(2578,'Coordinate Reference System',2857,7301,'NAD83(HPGN) / West Virginia North',''),
(2579,'Coordinate Reference System',2858,7301,'NAD83(HPGN) / West Virginia South',''),
(2580,'Coordinate Reference System',2859,7301,'NAD83(HPGN) / Wisconsin North',''),
(2581,'Coordinate Reference System',2860,7301,'NAD83(HPGN) / Wisconsin Central',''),
(2582,'Coordinate Reference System',2861,7301,'NAD83(HPGN) / Wisconsin South',''),
(2583,'Coordinate Reference System',2862,7301,'NAD83(HPGN) / Wyoming East',''),
(2584,'Coordinate Reference System',2863,7301,'NAD83(HPGN) / Wyoming East Central',''),
(2585,'Coordinate Reference System',2864,7301,'NAD83(HPGN) / Wyoming West Central',''),
(2586,'Coordinate Reference System',2865,7301,'NAD83(HPGN) / Wyoming West',''),
(2587,'Coordinate Reference System',2866,7301,'NAD83(HPGN) / Puerto Rico and Virgin Is.',''),
(2588,'Coordinate Reference System',2867,7301,'NAD83(HPGN) / Arizona East (ft)',''),
(2589,'Coordinate Reference System',2868,7301,'NAD83(HPGN) / Arizona Central (ft)',''),
(2590,'Coordinate Reference System',2869,7301,'NAD83(HPGN) / Arizona West (ft)',''),
(2591,'Coordinate Reference System',2870,7301,'NAD83(HPGN) / California zone 1 (ftUS)',''),
(2592,'Coordinate Reference System',2871,7301,'NAD83(HPGN) / California zone 2 (ftUS)',''),
(2593,'Coordinate Reference System',2872,7301,'NAD83(HPGN) / California zone 3 (ftUS)',''),
(2594,'Coordinate Reference System',2873,7301,'NAD83(HPGN) / California zone 4 (ftUS)',''),
(2595,'Coordinate Reference System',2874,7301,'NAD83(HPGN) / California zone 5 (ftUS)',''),
(2596,'Coordinate Reference System',2875,7301,'NAD83(HPGN) / California zone 6 (ftUS)',''),
(2597,'Coordinate Reference System',2876,7301,'NAD83(HPGN) / Colorado North (ftUS)',''),
(2598,'Coordinate Reference System',2877,7301,'NAD83(HPGN) / Colorado Central (ftUS)',''),
(2599,'Coordinate Reference System',2878,7301,'NAD83(HPGN) / Colorado South (ftUS)',''),
(2600,'Coordinate Reference System',2879,7301,'NAD83(HPGN) / Connecticut (ftUS)',''),
(2601,'Coordinate Reference System',2880,7301,'NAD83(HPGN) / Delaware (ftUS)',''),
(2602,'Coordinate Reference System',2881,7301,'NAD83(HPGN) / Florida East (ftUS)',''),
(2603,'Coordinate Reference System',2882,7301,'NAD83(HPGN) / Florida West (ftUS)',''),
(2604,'Coordinate Reference System',2883,7301,'NAD83(HPGN) / Florida North (ftUS)',''),
(2605,'Coordinate Reference System',2884,7301,'NAD83(HPGN) / Georgia East (ftUS)',''),
(2606,'Coordinate Reference System',2885,7301,'NAD83(HPGN) / Georgia West (ftUS)',''),
(2607,'Coordinate Reference System',2886,7301,'NAD83(HPGN) / Idaho East (ftUS)',''),
(2608,'Coordinate Reference System',2887,7301,'NAD83(HPGN) / Idaho Central (ftUS)',''),
(2609,'Coordinate Reference System',2888,7301,'NAD83(HPGN) / Idaho West (ftUS)',''),
(2610,'Coordinate Reference System',2891,7301,'NAD83(HPGN) / Kentucky North (ftUS)',''),
(2611,'Coordinate Reference System',2892,7301,'NAD83(HPGN) / Kentucky South (ftUS)',''),
(2612,'Coordinate Reference System',2893,7301,'NAD83(HPGN) / Maryland (ftUS)',''),
(2613,'Coordinate Reference System',2894,7301,'NAD83(HPGN) / Massachusetts Mainland (ftUS)',''),
(2614,'Coordinate Reference System',2895,7301,'NAD83(HPGN) / Massachusetts Island (ftUS)',''),
(2615,'Coordinate Reference System',2896,7301,'NAD83(HPGN) / Michigan North (ft)',''),
(2616,'Coordinate Reference System',2897,7301,'NAD83(HPGN) / Michigan Central (ft)',''),
(2617,'Coordinate Reference System',2898,7301,'NAD83(HPGN) / Michigan South (ft)',''),
(2618,'Coordinate Reference System',2899,7301,'NAD83(HPGN) / Mississippi East (ftUS)',''),
(2619,'Coordinate Reference System',2900,7301,'NAD83(HPGN) / Mississippi West (ftUS)',''),
(2620,'Coordinate Reference System',2901,7301,'NAD83(HPGN) / Montana (ft)',''),
(2621,'Coordinate Reference System',2902,7301,'NAD83(HPGN) / New Mexico East (ftUS)',''),
(2622,'Coordinate Reference System',2903,7301,'NAD83(HPGN) / New Mexico Central (ftUS)',''),
(2623,'Coordinate Reference System',2904,7301,'NAD83(HPGN) / New Mexico West (ftUS)',''),
(2624,'Coordinate Reference System',2905,7301,'NAD83(HPGN) / New York East (ftUS)',''),
(2625,'Coordinate Reference System',2906,7301,'NAD83(HPGN) / New York Central (ftUS)',''),
(2626,'Coordinate Reference System',2907,7301,'NAD83(HPGN) / New York West (ftUS)',''),
(2627,'Coordinate Reference System',2908,7301,'NAD83(HPGN) / New York Long Island (ftUS)',''),
(2628,'Coordinate Reference System',2909,7301,'NAD83(HPGN) / North Dakota North (ft)',''),
(2629,'Coordinate Reference System',2910,7301,'NAD83(HPGN) / North Dakota South (ft)',''),
(2630,'Coordinate Reference System',2911,7301,'NAD83(HPGN) / Oklahoma North (ftUS)',''),
(2631,'Coordinate Reference System',2912,7301,'NAD83(HPGN) / Oklahoma South (ftUS)',''),
(2632,'Coordinate Reference System',2913,7301,'NAD83(HPGN) / Oregon North (ft)',''),
(2633,'Coordinate Reference System',2914,7301,'NAD83(HPGN) / Oregon South (ft)',''),
(2634,'Coordinate Reference System',2915,7301,'NAD83(HPGN) / Tennessee (ftUS)',''),
(2635,'Coordinate Reference System',2916,7301,'NAD83(HPGN) / Texas North (ftUS)',''),
(2636,'Coordinate Reference System',2917,7301,'NAD83(HPGN) / Texas North Central (ftUS)',''),
(2637,'Coordinate Reference System',2918,7301,'NAD83(HPGN) / Texas Central (ftUS)',''),
(2638,'Coordinate Reference System',2919,7301,'NAD83(HPGN) / Texas South Central (ftUS)',''),
(2639,'Coordinate Reference System',2920,7301,'NAD83(HPGN) / Texas South (ftUS)',''),
(2640,'Coordinate Reference System',2921,7301,'NAD83(HPGN) / Utah North (ft)',''),
(2641,'Coordinate Reference System',2922,7301,'NAD83(HPGN) / Utah Central (ft)',''),
(2642,'Coordinate Reference System',2923,7301,'NAD83(HPGN) / Utah South (ft)',''),
(2643,'Coordinate Reference System',2924,7301,'NAD83(HPGN) / Virginia North (ftUS)',''),
(2644,'Coordinate Reference System',2925,7301,'NAD83(HPGN) / Virginia South (ftUS)',''),
(2645,'Coordinate Reference System',2926,7301,'NAD83(HPGN) / Washington North (ftUS)',''),
(2646,'Coordinate Reference System',2927,7301,'NAD83(HPGN) / Washington South (ftUS)',''),
(2647,'Coordinate Reference System',2928,7301,'NAD83(HPGN) / Wisconsin North (ftUS)',''),
(2648,'Coordinate Reference System',2929,7301,'NAD83(HPGN) / Wisconsin Central (ftUS)',''),
(2649,'Coordinate Reference System',2930,7301,'NAD83(HPGN) / Wisconsin South (ftUS)',''),
(2650,'Coordinate Reference System',2967,7301,'NAD83(HPGN) / Indiana East (ftUS)',''),
(2651,'Coordinate Reference System',2968,7301,'NAD83(HPGN) / Indiana West (ftUS)',''),
(2652,'Coordinate Reference System',2993,7301,'NAD83(HPGN) / LCC (m)',''),
(2653,'Coordinate Reference System',2994,7301,'NAD83(HPGN) / Oregon GIC Lambert (ft)',''),
(2654,'Coordinate_Operation',1578,7301,'American Samoa 1962 to NAD83(HPGN) (1)',''),
(2655,'Coordinate_Operation',1579,7301,'American Samoa 1962 to NAD83(HPGN) (2)',''),
(2656,'Coordinate_Operation',1068,7301,'Guam 1963 to NAD83(HPGN) (1)',''),
(2657,'Coordinate_Operation',8460,7301,'NAD27 to NAD83(HPGN) (1)',''),
(2658,'Coordinate_Operation',8469,7301,'NAD27 to NAD83(HPGN) (10)',''),
(2659,'Coordinate_Operation',8470,7301,'NAD27 to NAD83(HPGN) (11)',''),
(2660,'Coordinate_Operation',8471,7302,'NAD27 to NAD83(HPGN) (12)',''),
(2661,'Coordinate_Operation',8472,7301,'NAD27 to NAD83(HPGN) (13)',''),
(2662,'Coordinate_Operation',8473,7301,'NAD27 to NAD83(HPGN) (14)',''),
(2663,'Coordinate_Operation',8474,7301,'NAD27 to NAD83(HPGN) (15)',''),
(2664,'Coordinate_Operation',8475,7301,'NAD27 to NAD83(HPGN) (16)',''),
(2665,'Coordinate_Operation',8476,7301,'NAD27 to NAD83(HPGN) (17)',''),
(2666,'Coordinate_Operation',8477,7302,'NAD27 to NAD83(HPGN) (18)',''),
(2667,'Coordinate_Operation',8478,7301,'NAD27 to NAD83(HPGN) (19)',''),
(2668,'Coordinate_Operation',8461,7301,'NAD27 to NAD83(HPGN) (2)',''),
(2669,'Coordinate_Operation',8479,7301,'NAD27 to NAD83(HPGN) (20)',''),
(2670,'Coordinate_Operation',8480,7302,'NAD27 to NAD83(HPGN) (21)',''),
(2671,'Coordinate_Operation',8482,7301,'NAD27 to NAD83(HPGN) (22)',''),
(2672,'Coordinate_Operation',8483,7301,'NAD27 to NAD83(HPGN) (23)',''),
(2673,'Coordinate_Operation',8484,7301,'NAD27 to NAD83(HPGN) (24)',''),
(2674,'Coordinate_Operation',8485,7301,'NAD27 to NAD83(HPGN) (25)',''),
(2675,'Coordinate_Operation',8486,7301,'NAD27 to NAD83(HPGN) (26)',''),
(2676,'Coordinate_Operation',8487,7301,'NAD27 to NAD83(HPGN) (27)',''),
(2677,'Coordinate_Operation',8488,7301,'NAD27 to NAD83(HPGN) (28)',''),
(2678,'Coordinate_Operation',8489,7301,'NAD27 to NAD83(HPGN) (29)',''),
(2679,'Coordinate_Operation',8462,7301,'NAD27 to NAD83(HPGN) (3)',''),
(2680,'Coordinate_Operation',8509,7302,'NAD27 to NAD83(HPGN) (30)',''),
(2681,'Coordinate_Operation',8510,7301,'NAD27 to NAD83(HPGN) (31)',''),
(2682,'Coordinate_Operation',8511,7301,'NAD27 to NAD83(HPGN) (32)',''),
(2683,'Coordinate_Operation',8512,7301,'NAD27 to NAD83(HPGN) (33)',''),
(2684,'Coordinate_Operation',8513,7301,'NAD27 to NAD83(HPGN) (34)',''),
(2685,'Coordinate_Operation',8514,7301,'NAD27 to NAD83(HPGN) (35)',''),
(2686,'Coordinate_Operation',8553,7301,'NAD27 to NAD83(HPGN) (36)',''),
(2687,'Coordinate_Operation',8554,7301,'NAD27 to NAD83(HPGN) (37)',''),
(2688,'Coordinate_Operation',8586,7302,'NAD27 to NAD83(HPGN) (38)',''),
(2689,'Coordinate_Operation',8587,7301,'NAD27 to NAD83(HPGN) (39)',''),
(2690,'Coordinate_Operation',8463,7301,'NAD27 to NAD83(HPGN) (4)',''),
(2691,'Coordinate_Operation',8588,7301,'NAD27 to NAD83(HPGN) (40)',''),
(2692,'Coordinate_Operation',8589,7301,'NAD27 to NAD83(HPGN) (41)',''),
(2693,'Coordinate_Operation',8464,7301,'NAD27 to NAD83(HPGN) (5)',''),
(2694,'Coordinate_Operation',8465,7301,'NAD27 to NAD83(HPGN) (6)',''),
(2695,'Coordinate_Operation',8466,7301,'NAD27 to NAD83(HPGN) (7)',''),
(2696,'Coordinate_Operation',8467,7301,'NAD27 to NAD83(HPGN) (8)',''),
(2697,'Coordinate_Operation',8468,7301,'NAD27 to NAD83(HPGN) (9)',''),
(2698,'Coordinate_Operation',1474,7301,'NAD83 to NAD83(HPGN) (1)',''),
(2699,'Coordinate_Operation',1483,7301,'NAD83 to NAD83(HPGN) (10)',''),
(2700,'Coordinate_Operation',1484,7301,'NAD83 to NAD83(HPGN) (11)',''),
(2701,'Coordinate_Operation',1485,7301,'NAD83 to NAD83(HPGN) (12)',''),
(2702,'Coordinate_Operation',1486,7301,'NAD83 to NAD83(HPGN) (13)',''),
(2703,'Coordinate_Operation',1487,7301,'NAD83 to NAD83(HPGN) (14)',''),
(2704,'Coordinate_Operation',1488,7301,'NAD83 to NAD83(HPGN) (15)',''),
(2705,'Coordinate_Operation',1489,7301,'NAD83 to NAD83(HPGN) (16)',''),
(2706,'Coordinate_Operation',1490,7301,'NAD83 to NAD83(HPGN) (17)',''),
(2707,'Coordinate_Operation',1491,7301,'NAD83 to NAD83(HPGN) (18)',''),
(2708,'Coordinate_Operation',1492,7301,'NAD83 to NAD83(HPGN) (19)',''),
(2709,'Coordinate_Operation',1475,7301,'NAD83 to NAD83(HPGN) (2)',''),
(2710,'Coordinate_Operation',1493,7301,'NAD83 to NAD83(HPGN) (20)',''),
(2711,'Coordinate_Operation',1494,7301,'NAD83 to NAD83(HPGN) (21)',''),
(2712,'Coordinate_Operation',1495,7302,'NAD83 to NAD83(HPGN) (22)',''),
(2713,'Coordinate_Operation',1496,7301,'NAD83 to NAD83(HPGN) (23)',''),
(2714,'Coordinate_Operation',1497,7301,'NAD83 to NAD83(HPGN) (24)',''),
(2715,'Coordinate_Operation',1498,7301,'NAD83 to NAD83(HPGN) (25)',''),
(2716,'Coordinate_Operation',1499,7301,'NAD83 to NAD83(HPGN) (26)',''),
(2717,'Coordinate_Operation',1500,7301,'NAD83 to NAD83(HPGN) (27)',''),
(2718,'Coordinate_Operation',1501,7301,'NAD83 to NAD83(HPGN) (28)',''),
(2719,'Coordinate_Operation',1502,7301,'NAD83 to NAD83(HPGN) (29)',''),
(2720,'Coordinate_Operation',1476,7301,'NAD83 to NAD83(HPGN) (3)',''),
(2721,'Coordinate_Operation',1503,7301,'NAD83 to NAD83(HPGN) (30)',''),
(2722,'Coordinate_Operation',1520,7301,'NAD83 to NAD83(HPGN) (31)',''),
(2723,'Coordinate_Operation',1521,7301,'NAD83 to NAD83(HPGN) (32)',''),
(2724,'Coordinate_Operation',1522,7301,'NAD83 to NAD83(HPGN) (33)',''),
(2725,'Coordinate_Operation',1523,7301,'NAD83 to NAD83(HPGN) (34)',''),
(2726,'Coordinate_Operation',1524,7301,'NAD83 to NAD83(HPGN) (35)',''),
(2727,'Coordinate_Operation',1525,7301,'NAD83 to NAD83(HPGN) (36)',''),
(2728,'Coordinate_Operation',1526,7301,'NAD83 to NAD83(HPGN) (37)',''),
(2729,'Coordinate_Operation',1553,7301,'NAD83 to NAD83(HPGN) (38)',''),
(2730,'Coordinate_Operation',1554,7301,'NAD83 to NAD83(HPGN) (39)',''),
(2731,'Coordinate_Operation',1477,7301,'NAD83 to NAD83(HPGN) (4)',''),
(2732,'Coordinate_Operation',1704,7301,'NAD83 to NAD83(HPGN) (40)',''),
(2733,'Coordinate_Operation',1705,7301,'NAD83 to NAD83(HPGN) (41)',''),
(2734,'Coordinate_Operation',1706,7301,'NAD83 to NAD83(HPGN) (42)',''),
(2735,'Coordinate_Operation',1707,7301,'NAD83 to NAD83(HPGN) (43)',''),
(2736,'Coordinate_Operation',1478,7301,'NAD83 to NAD83(HPGN) (5)',''),
(2737,'Coordinate_Operation',1479,7301,'NAD83 to NAD83(HPGN) (6)',''),
(2738,'Coordinate_Operation',1480,7301,'NAD83 to NAD83(HPGN) (7)',''),
(2739,'Coordinate_Operation',1481,7301,'NAD83 to NAD83(HPGN) (8)',''),
(2740,'Coordinate_Operation',1482,7301,'NAD83 to NAD83(HPGN) (9)',''),
(2741,'Coordinate_Operation',1580,7301,'NAD83(HPGN) to WGS 84 (1)',''),
(2742,'Coordinate_Operation',1900,7301,'NAD83(HPGN) to WGS 84 (2)',''),
(2743,'Coordinate_Operation',1901,7301,'NAD83(HPGN) to WGS 84 (3)',''),
(2744,'Coordinate_Operation',8508,7301,'Old Hawaiian to NAD83(HPGN) (1)',''),
(2745,'Coordinate_Operation',8481,7301,'Puerto Rico to NAD83(HPGN) (1)',''),
(2746,'Coordinate Reference System',3088,7301,'NAD83 / Kentucky Single Zone (m)',''),
(2747,'Coordinate Reference System',6879,7301,'NAD83(2011) / Wisconsin Central (m)',''),
(2748,'Coordinate Reference System',3089,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(2749,'Coordinate Reference System',3091,7302,'NAD83(HARN) / KY1Z (ftUS)',''),
(2750,'Coordinate_Operation',11630,7301,'SPCS83 Kentucky Single Zone',''),
(2751,'Datum',6625,7301,'Fort Desaix',''),
(2752,'Datum',6622,7301,'Sainte Anne',''),
(2753,'Datum',6626,7301,'Piton des Neiges',''),
(2754,'Coordinate Reference System',4622,7301,'Sainte Anne',''),
(2755,'Coordinate Reference System',4625,7301,'Fort Desaix',''),
(2756,'Coordinate Reference System',4626,7301,'Piton des Neiges',''),
(2757,'Coordinate Reference System',2970,7301,'Sainte Anne / UTM zn 20N',''),
(2758,'Coordinate Reference System',2973,7301,'Fort Desaix / UTM zn 20N',''),
(2759,'Coordinate Reference System',2990,7301,'Piton des Neiges / TM Reunion',''),
(2760,'Coordinate_Operation',1905,7301,'Sainte Anne to WGS 84 (2)',''),
(2761,'Coordinate_Operation',1904,7301,'Sainte Anne to WGS 84 (1)',''),
(2762,'Coordinate_Operation',1910,7301,'Fort Desaix to WGS 84 (2)',''),
(2763,'Coordinate_Operation',1909,7301,'Fort Desaix to WGS 84 (1)',''),
(2764,'Coordinate_Operation',1926,7301,'Piton des Neiges to RGR92 (1)',''),
(2765,'Coordinate_Operation',1911,7301,'Piton des Neiges to WGS 84 (1)',''),
(2766,'Coordinate_Operation',1964,7301,'RGR92 to Piton des Neiges (1)',''),
(2767,'Datum',5189,7302,'NGC',''),
(2768,'Coordinate Reference System',5757,7301,'IGN 1988 height',''),
(2769,'Coordinate Reference System',5756,7301,'IGN 1987',''),
(2770,'Coordinate Reference System',5758,7301,'IGN 1989 height',''),
(2771,'Coordinate Reference System',5793,7301,'IGN 1950 height',''),
(2772,'Coordinate Reference System',5794,7301,'IGN 1955 height',''),
(2773,'Datum',5192,7301,'IGN 1955',''),
(2774,'Coordinate Reference System',5795,7301,'IGN 1951 height',''),
(2775,'Coordinate_Operation',10004,7301,'RRAF 1991 to IGN 1987 (1)',''),
(2776,'Coordinate_Operation',10005,7301,'RRAF 1991 to IGN 1988 (1)',''),
(2777,'Coordinate_Operation',10006,7301,'RRAF 1991 to IGN 1988 (2)',''),
(2778,'Coordinate_Operation',10007,7300,'RRAF 1991 to IGN 1988 (3)',''),
(2779,'Coordinate_Operation',10008,7301,'RRAF 1991 to IGN 1988 (4)',''),
(2780,'Coordinate_Operation',10009,7301,'RRAF 1991 to IGN 1988 (5)',''),
(2781,'Coordinate_Operation',10010,7301,'RRAF 1991 to IGN 1988 (6)',''),
(2782,'Coordinate_Operation',10012,7301,'RGR92 to IGN 1989 (1)',''),
(2783,'Datum',5191,7301,'IGN 1950',''),
(2784,'Coordinate Reference System',3106,7302,'Gulshan / Bangladesh TM',''),
(2785,'Coordinate Reference System',3108,7301,'ETRS89 / New Guernsey Grid',''),
(2786,'Coordinate Reference System',3109,7301,'ETRF89 / Jersey Transverse Mercator',''),
(2787,'Coordinate Reference System',3109,7302,'ETRS89 / JTM',''),
(2788,'Coordinate Reference System',3109,7301,'ETRF89 / JTM',''),
(2789,'Datum',5114,7301,'Canadian Vertical Datum of 1928',''),
(2790,'Datum',5114,7302,'CGVD28',''),
(2791,'Coordinate Reference System',5713,7301,'CVD28 height',''),
(2792,'Coordinate Reference System',5713,7301,'Canadian Vertical Datum of 1928 height',''),
(2793,'Coordinate Reference System',3108,7301,'ETRF89 / Guernsey Grid',''),
(2794,'Datum',6683,7302,'PRS92',''),
(2795,'Coordinate_Operation',17360,7301,'Vicgrid',''),
(2796,'Coordinate Reference System',6879,7302,'NAD83(2011) / WI C (m)',''),
(2797,'Coordinate_Operation',17362,7301,'Geoscience Australia Lambert',''),
(2798,'Coordinate Reference System',3110,7301,'Vicgrid',''),
(2799,'Datum',6683,7301,'Modified Luzon Datum',''),
(2800,'Coordinate_Operation',15708,7301,'New Luzon to WGS 84 (1)',''),
(2801,'Coordinate Reference System',4994,7301,'New Luzon',''),
(2802,'Coordinate Reference System',4683,7301,'New Luzon',''),
(2803,'Coordinate Reference System',4995,7301,'New Luzon',''),
(2804,'Coordinate Reference System',3125,7301,'New Luzon / Philippines zone 5',''),
(2805,'Coordinate Reference System',3124,7301,'New Luzon / Philippines zone 4',''),
(2806,'Coordinate Reference System',3123,7301,'New Luzon / Philippines zone 3',''),
(2807,'Coordinate Reference System',3122,7301,'New Luzon / Philippines zone 2',''),
(2808,'Coordinate Reference System',3121,7301,'New Luzon / Philippines zone 1',''),
(2809,'Coordinate_Operation',17363,7302,'BCSG02',''),
(2810,'Datum',6686,7301,'MAGNA-SIRGAS',''),
(2811,'Coordinate Reference System',21897,7302,'Bogota / Colombia Bogota',''),
(2812,'Coordinate Reference System',21899,7302,'Bogota / Colombia 6E',''),
(2813,'Coordinate Reference System',21898,7302,'Bogota / Colombia 3E',''),
(2814,'Coordinate Reference System',21896,7302,'Bogota / Colombia 3W',''),
(2815,'Coordinate_Operation',1886,7313,'Graciosa Base SW to WGS 84',''),
(2816,'Coordinate_Operation',6747,7301,'Oregon Bend-Vale zone (meters)','Previous name'),
(2817,'Coordinate Reference System',6880,7302,'NAD83(2011) / NE (ftUS)',''),
(2818,'Coordinate_Operation',1306,7313,'Hermannskogel to WGS 84',''),
(2819,'Coordinate_Operation',1287,7313,'S-42 to WGS 84 (code SPK-A)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(2820,'Coordinate_Operation',1288,7313,'S-42 to WGS 84 (code SPK-B)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(2821,'Coordinate_Operation',1289,7313,'S-42 to WGS 84 (code SPK-C)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(2822,'Coordinate_Operation',1290,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(2823,'Coordinate_Operation',1291,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(2824,'Coordinate_Operation',1292,7313,'S-42 to WGS 84 (code SPK-F)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(2825,'Coordinate_Operation',1293,7313,'S-42 to WGS 84 (code SPK-G)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(2826,'Coordinate_Operation',1897,7313,'Gunung Segara to WGS 84',''),
(2827,'Coordinate Reference System',3034,7307,'ETRS - LCC','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2828,'Coordinate Reference System',3035,7307,'ETRS - LAEA','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2829,'Coordinate Reference System',3038,7307,'ETRS - TM26','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2830,'Coordinate Reference System',3039,7307,'ETRS - TM27','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2831,'Coordinate Reference System',3040,7307,'ETRS - TM28','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2832,'Coordinate Reference System',3041,7307,'ETRS - TM29','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2833,'Coordinate Reference System',3042,7307,'ETRS - TM30','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2834,'Coordinate Reference System',3043,7307,'ETRS - TM31','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2835,'Coordinate Reference System',3044,7307,'ETRS - TM32','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2836,'Coordinate Reference System',3045,7307,'ETRS - TM33','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2837,'Coordinate Reference System',3046,7307,'ETRS - TM34','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2838,'Coordinate Reference System',3047,7307,'ETRS - TM35','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2839,'Coordinate Reference System',3048,7307,'ETRS - TM36','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2840,'Coordinate Reference System',3049,7307,'ETRS - TM37','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2841,'Coordinate Reference System',3050,7307,'ETRS - TM38','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2842,'Coordinate Reference System',3051,7307,'ETRS - TM39','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2843,'Datum',1133,7302,'NAD83(CORS96)',''),
(2844,'Coordinate Reference System',4936,7307,'ETRS89 / (X, Y, Z)','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2845,'Coordinate Reference System',4937,7307,'ETRS89','This identifier is as used by the information source but has been superseded by the INSPIRE identifier.'),
(2846,'Coordinate Reference System',5730,7307,'EVRF_AMST / NH',''),
(2847,'Coordinate Reference System',6884,7301,'NAD83(CORS96) / Oregon North (m)',''),
(2848,'Coordinate Reference System',2462,7307,'AL_ALB87 / TM_6',''),
(2849,'Coordinate Reference System',5777,7307,'AL_DUR / NOH',''),
(2850,'Coordinate Reference System',5778,7307,'AT_TRIE / NOH',''),
(2851,'Coordinate Reference System',31281,7307,'AT_MGI / AT_TM','This same identifier used for each of West, Central and East zones.'),
(2852,'Coordinate Reference System',31282,7307,'AT_MGI / AT_TM','This same identifier used for each of West, Central and East zones.'),
(2853,'Coordinate Reference System',31283,7307,'AT_MGI / AT_TM','This same identifier used for each of West, Central and East zones.'),
(2854,'Coordinate Reference System',31370,7307,'(BE_BD72 / LAMB72 - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2855,'Coordinate_Operation',5415,7307,'AT_TRIE / NOH to EVRF2000',''),
(2856,'Coordinate Reference System',5786,7307,'BG_KRON / NH',''),
(2857,'Coordinate_Operation',5416,7307,'BG_KRON / NH to EVRF2000',''),
(2858,'Coordinate Reference System',31275,7307,'HR_HDKS / HR_TM','This same identifier used for both of zones 5 and 6.'),
(2859,'Coordinate Reference System',31276,7307,'HR_HDKS / HR_TM','This same identifier used for both of zones 5 and 6.'),
(2860,'Coordinate Reference System',2065,7307,'CZ_S-JTSK / KROVAK','The EuroGeographics projection description differs from that given here but is equivalent.'),
(2861,'Coordinate Reference System',2065,7307,'SK_S-JTSK / KROVAK','The EuroGeographics projection description differs from that given here but is equivalent.'),
(2862,'Coordinate Reference System',23032,7307,'(DK_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 33.'),
(2863,'Coordinate Reference System',23033,7307,'(DK_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 32.'),
(2864,'Coordinate_Operation',5417,7307,'DK_DK10 / OH to EVRF2000',''),
(2865,'Coordinate Reference System',5733,7307,'DK_DK10 / OH',''),
(2866,'Coordinate Reference System',3301,7307,'EE_L-EST97 / EST_LAMB',''),
(2867,'Coordinate Reference System',5705,7307,'EE_KRON / NH',''),
(2868,'Coordinate Reference System',5705,7301,'Baltic 1977 height',''),
(2869,'Datum',5105,7301,'Baltic 1977',''),
(2870,'Coordinate Reference System',5705,7302,'BHS77 height',''),
(2871,'Coordinate_Operation',5418,7307,'EE_KRON / NH to EVRF2000',''),
(2872,'Coordinate Reference System',2393,7307,'FI_KKJ / FI_TM',''),
(2873,'Coordinate Reference System',5717,7307,'FI_HELS / OH',''),
(2874,'Coordinate_Operation',10098,7307,'(FI_KKJ to ETRS89)','This identifier is for an equivalent transformation using the Position Vector method.'),
(2875,'Coordinate_Operation',5432,7307,'FI_HELS / OH to EVRF2000',''),
(2876,'Coordinate_Operation',5419,7307,'FR_MARS / NH to EVRF2000',''),
(2877,'Coordinate Reference System',2192,7307,'(FR_ED50 / EUROLAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2878,'Coordinate Reference System',27562,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2879,'Coordinate Reference System',27564,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2880,'Coordinate Reference System',27561,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2881,'Coordinate Reference System',27563,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2882,'Coordinate Reference System',27572,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2883,'Coordinate Reference System',2154,7307,'(FR_RGF93 / LAMB93 - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2884,'Coordinate Reference System',5720,7307,'FR_MARS / NH',''),
(2885,'Coordinate Reference System',31466,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2886,'Coordinate Reference System',31467,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2887,'Coordinate Reference System',31468,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2888,'Coordinate Reference System',31469,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2889,'Coordinate Reference System',3398,7307,'DE_RD/83 / GK_3','This EuroGeographics identifier is used for both of zones 4 and 5. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2890,'Coordinate Reference System',3399,7307,'DE_RD/83 / GK_3','This EuroGeographics identifier is used for both of zones 4 and 5. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2891,'Coordinate Reference System',3396,7307,'DE_PD/83 / GK_3','This EuroGeographics identifier is used for both of zones 3 and 4. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2892,'Coordinate Reference System',3397,7307,'DE_PD/83 / GK_3','This EuroGeographics identifier is used for both of zones 3 and 4. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2893,'Coordinate Reference System',5785,7307,'DE_KRON / NH',''),
(2894,'Coordinate Reference System',5783,7307,'DE_AMST / NH',''),
(2895,'Coordinate Reference System',5784,7307,'DE_AMST / NOH',''),
(2896,'Coordinate Reference System',2399,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2897,'Coordinate Reference System',2398,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2898,'Coordinate Reference System',2397,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2899,'Coordinate Reference System',3045,7307,'DE_ETRS89 / UTM',''),
(2900,'Coordinate_Operation',5422,7307,'DE_KRON / NH to EVRF2000',''),
(2901,'Coordinate_Operation',5420,7307,'DE_AMST / NH to EVRF2000',''),
(2902,'Coordinate_Operation',5421,7307,'DE_AMST / NOH to EVRF2000',''),
(2903,'Coordinate_Operation',1779,7307,'DE_DHDN (Middle) to ETRS89',''),
(2904,'Coordinate_Operation',1780,7307,'DE_DHDN (North) to ETRS89',''),
(2905,'Coordinate_Operation',1776,7307,'DE_DHDN (whole country, 2001) to ETRS89',''),
(2906,'Coordinate_Operation',1778,7307,'DE_DHDN (South) to ETRS89',''),
(2907,'Coordinate_Operation',1309,7307,'DE_DHDN (whole country, 1995) to ETRS89',''),
(2908,'Coordinate_Operation',1781,7307,'DE_PD/83 to ETRS89',''),
(2909,'Coordinate_Operation',1782,7307,'DE_RD/83 to ETRS89',''),
(2910,'Coordinate_Operation',1775,7307,'DE_42/83 to ETRS89',''),
(2911,'Coordinate Reference System',23030,7307,'(GI_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2912,'Coordinate Reference System',5701,7307,'GB_NEWL / OH',''),
(2913,'Coordinate_Operation',5433,7307,'GB_NEWL / OH to EVRF2000',''),
(2914,'Coordinate_Operation',1314,7307,'GB_OSGB36 to ETRS89',''),
(2915,'Coordinate Reference System',2100,7307,'(GR_GGRS87 / GR_TM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2916,'Coordinate Reference System',27700,7307,'(GB_OSGB36 / NATIONALGRID - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2917,'Coordinate Reference System',5787,7307,'HU_KRON / NH',''),
(2918,'Coordinate_Operation',5424,7307,'HU_KRON / NH to EVRF2000',''),
(2919,'Coordinate Reference System',5731,7307,'IE_MALH / OH',''),
(2920,'Coordinate Reference System',29902,7307,'(IE_IRELAND65 / IRELAND75_IRISHGRID - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2921,'Coordinate Reference System',29902,7307,'(NI_IRELAND65 / IRELAND75_IRISHGRID - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2922,'Coordinate Reference System',23033,7307,'(IT_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 32.'),
(2923,'Coordinate Reference System',23032,7307,'(IT_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 33.'),
(2924,'Coordinate Reference System',3003,7307,'(IT_ROMA40 / EAST_WEST - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for each of zones 1 and 2.'),
(2925,'Coordinate Reference System',3004,7307,'(IT_ROMA40 / EAST_WEST - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for each of zones 1 and 2.'),
(2926,'Coordinate_Operation',1659,7307,'IT_ROMA40 (peninsular part) to ETRS89',''),
(2927,'Coordinate_Operation',1661,7307,'IT_ROMA40 (Sardinia) to ETRS89',''),
(2928,'Coordinate_Operation',1663,7307,'IT_ROMA40 (Sicily) to ETRS89',''),
(2929,'Coordinate Reference System',3059,7307,'LV_LKS-92 / LV_TM',''),
(2930,'Coordinate Reference System',2600,7307,'LT_LKS94 / LT_TM',''),
(2931,'Coordinate_Operation',5434,7307,'LT_KRON / NH',''),
(2932,'Coordinate Reference System',5774,7307,'LU_AMST / OH',''),
(2933,'Coordinate Reference System',2169,7307,'LU_LUREF / LU_TM',''),
(2934,'Coordinate Reference System',28992,7307,'(NL_RD / DUTCH_ST - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2935,'Coordinate Reference System',5709,7307,'NL_AMST / OH',''),
(2936,'Coordinate_Operation',5425,7307,'NL_AMST / OH to EVRF2000',''),
(2937,'Coordinate_Operation',1751,7307,'NL_RD to ETRS89',''),
(2938,'Coordinate Reference System',3044,7307,'NO_ETRS89 / UTM',''),
(2939,'Coordinate Reference System',3045,7307,'NO_ETRS89 / UTM',''),
(2940,'Coordinate Reference System',3047,7307,'NO_ETRS89 / UTM',''),
(2941,'Coordinate Reference System',27391,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2942,'Coordinate Reference System',27392,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2943,'Coordinate Reference System',27393,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2944,'Coordinate Reference System',27394,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2945,'Coordinate Reference System',27395,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2946,'Coordinate Reference System',27396,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2947,'Coordinate Reference System',27397,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2948,'Coordinate Reference System',27398,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2949,'Coordinate Reference System',5776,7307,'NO_TREG / NOH',''),
(2950,'Coordinate_Operation',5426,7307,'NO_TREG / NOH to EVRF2000',''),
(2951,'Coordinate Reference System',2180,7307,'PL_EUREF89 / 1992',''),
(2952,'Coordinate Reference System',2179,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2953,'Coordinate Reference System',2178,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2954,'Coordinate Reference System',2177,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2955,'Coordinate Reference System',2176,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2956,'Coordinate Reference System',2171,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2957,'Coordinate Reference System',2172,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2958,'Coordinate Reference System',2173,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2959,'Coordinate Reference System',2174,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2960,'Coordinate Reference System',2175,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2961,'Coordinate_Operation',1992,7307,'PT_D73 to ETRS89',''),
(2962,'Coordinate_Operation',1997,7307,'PT_DLX(HAY) to ETRS89',''),
(2963,'Coordinate_Operation',5427,7307,'PT_CASC / OH to EVRF2000',''),
(2964,'Coordinate Reference System',5780,7307,'PT_CASC / OH',''),
(2965,'Coordinate Reference System',2942,7307,'(PT_MAD / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2966,'Coordinate Reference System',27492,7307,'PT_D73 / TM_D73',''),
(2967,'Coordinate Reference System',2190,7307,'(PT_AZO_ORIE / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2968,'Coordinate Reference System',6884,7302,'CORS96 / OR N (m)',''),
(2969,'Coordinate Reference System',2189,7307,'(PT_AZO_CENT / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2970,'Coordinate Reference System',5705,7307,'SK_KRON / NH',''),
(2971,'Coordinate_Operation',5435,7307,'SK_KRON / NH to EVRF2000',''),
(2972,'Coordinate_Operation',5428,7307,'SI_TRIE / NOH to EVRF2000',''),
(2973,'Coordinate Reference System',5779,7307,'SI_TRIE / NOH',''),
(2974,'Coordinate Reference System',2170,7307,'SI_D48 / SI_TM',''),
(2975,'Coordinate Reference System',2170,7309,'D48 / Slovenia Grid',''),
(2976,'Coordinate_Operation',1785,7307,'SI_D48 to ETRS89',''),
(2977,'Coordinate_Operation',1785,7309,'D48 to ETRS89 (3)',''),
(2978,'Coordinate_Operation',1786,7309,'D48 to WGS 84 (5)',''),
(2979,'Coordinate_Operation',5429,7307,'ES_ALIC / OH to EVRF2000',''),
(2980,'Coordinate Reference System',23028,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2981,'Coordinate Reference System',23029,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2982,'Coordinate Reference System',23030,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2983,'Coordinate Reference System',23031,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2984,'Coordinate Reference System',5718,7307,'SE_AMST / NH',''),
(2985,'Coordinate Reference System',3021,7307,'SE_RT90 / SE_TM',''),
(2986,'Coordinate_Operation',1895,7307,'SE_RT90 to ETRS89',''),
(2987,'Coordinate_Operation',5431,7307,'CH_MARS / UNCOR to EVRF2000',''),
(2988,'Coordinate Reference System',5728,7307,'CH_MARS / UNCOR',''),
(2989,'Coordinate Reference System',5729,7307,'CH_MARS / OH',''),
(2990,'Coordinate Reference System',2056,7307,'(CH_CH1903+ / CH_PROJECTION+ - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2991,'Coordinate Reference System',21781,7307,'(CH_CH1903 / CH_PROJECTION - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2992,'Coordinate Reference System',5775,7307,'TR_ANT / OH',''),
(2993,'Coordinate Reference System',2319,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2994,'Coordinate Reference System',2320,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2995,'Coordinate Reference System',2321,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2996,'Coordinate Reference System',2322,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2997,'Coordinate Reference System',2323,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2998,'Coordinate Reference System',2324,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2999,'Coordinate Reference System',2325,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(3000,'Coordinate Reference System',23035,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3001,'Coordinate Reference System',23036,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3002,'Coordinate Reference System',23037,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3003,'Coordinate Reference System',23038,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3004,'Coordinate_Operation',1155,7313,'Indian to WGS 84',''),
(3005,'Coordinate_Operation',1156,7313,'Indian to WGS 84',''),
(3006,'Coordinate_Operation',1247,7313,'Indian to WGS 84',''),
(3007,'Coordinate_Operation',1256,7313,'Oman to WGS 84',''),
(3008,'Coordinate_Operation',1561,7313,'Qatar National to WGS 84',''),
(3009,'Coordinate_Operation',1956,7313,'Ireland 1965 to WGS 84',''),
(3010,'Coordinate_Operation',1125,7313,'Bogota Observatory to WGS 84',''),
(3011,'Coordinate_Operation',1131,7313,'Chua Astro to WGS 84',''),
(3012,'Coordinate_Operation',1892,7313,'Provisional South Chilean 1963 to WGS 84',''),
(3013,'Coordinate_Operation',1227,7313,'Tananarive Observatory to WGS 84',''),
(3014,'Coordinate_Operation',15750,7313,'Fort Thomas 1955 to WGS 84',''),
(3015,'Coordinate_Operation',1900,7301,'NAD83(CORS96) to WGS 84 (2)',''),
(3016,'Coordinate_Operation',1901,7301,'NAD83(CORS96) to WGS 84 (3)',''),
(3017,'Coordinate Reference System',5782,7307,'ES_ALIC / OH',''),
(3018,'Datum',6687,7302,'RGPF',''),
(3019,'Datum',6688,7301,'MHEFO 55',''),
(3020,'Datum',6628,7301,'IGN 1952',''),
(3021,'Datum',6692,7302,'MOP 1983',''),
(3022,'Datum',6628,7301,'Tahiti',''),
(3023,'Datum',6629,7301,'Tahaa',''),
(3024,'Coordinate Reference System',4692,7301,'MOP 1983',''),
(3025,'Coordinate Reference System',4629,7301,'Tahaa',''),
(3026,'Coordinate Reference System',4628,7301,'Tahiti',''),
(3027,'Coordinate Reference System',3306,7301,'MOP 1983 / UTM zone 5S',''),
(3028,'Coordinate Reference System',2977,7301,'Tahaa / UTM zone 5S',''),
(3029,'Coordinate Reference System',2976,7301,'Tahiti / UTM zone 6S',''),
(3030,'Coordinate_Operation',1913,7301,'Tahaa to WGS 84 (1)',''),
(3031,'Coordinate_Operation',1924,7301,'Tahiti to WGS 84 (1)',''),
(3032,'Coordinate Reference System',4688,7301,'MHEFO 55',''),
(3033,'Coordinate Reference System',3303,7301,'MHEFO 55 / UTM zone 7S',''),
(3034,'Coordinate_Operation',15760,7301,'MHEFO 55 to RGPF (1)',''),
(3035,'Coordinate_Operation',15772,7301,'MHEFO 55 to WGS 84 (1)',''),
(3036,'Datum',5195,7302,'NGPF',''),
(3037,'Coordinate_Operation',17364,7302,'NSW Lambert',''),
(3038,'Coordinate_Operation Parameter',8733,7302,'Io',''),
(3039,'Coordinate_Operation Parameter',8734,7302,'Jo',''),
(3040,'Coordinate_Operation Parameter',8735,7302,'Eo',''),
(3041,'Coordinate_Operation Parameter',8736,7302,'No',''),
(3042,'Datum',6694,7302,'POSGAR 94',''),
(3043,'Datum',6694,7301,'POSGAR','This alias is ambiguous, used for POSGAR 94, POSGAR 98 and POSGAR 2007.'),
(3044,'Datum',6190,7301,'POSGAR','This alias is ambiguous, used for both POSGAR 94 and POSGAR 98.'),
(3045,'Datum',6694,7300,'Posiciones Geodsicas Argentinas 1994',''),
(3046,'Coordinate_Operation',10420,7301,'Teale Albers',''),
(3047,'Coordinate Reference System',3309,7301,'NAD27 / California (Teale) Albers',''),
(3048,'Coordinate Reference System',3310,7301,'NAD83 / California (Teale) Albers',''),
(3049,'Coordinate Reference System',3311,7301,'NAD83(HARN) / California (Teale) Albers',''),
(3050,'Coordinate Reference System',4943,7301,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(3051,'Coordinate Reference System',4942,7302,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(3052,'Coordinate Reference System',4697,7317,'IGC 1962',''),
(3053,'Coordinate Reference System',6886,7301,'NAD83(CORS96) / Oregon South (m)',''),
(3054,'Coordinate Reference System',6886,7302,'CORS96 / OR S (m)',''),
(3055,'Coordinate_Operation',17401,7302,'Katanga Lambert',''),
(3056,'Coordinate_Operation',17402,7302,'Katanga TM',''),
(3057,'Coordinate_Operation',17412,7302,'Congo TM zone 12',''),
(3058,'Coordinate_Operation',17414,7302,'Congo TM zone 14',''),
(3059,'Coordinate_Operation',17416,7302,'Congo TM zone 16',''),
(3060,'Coordinate_Operation',17418,7302,'Congo TM zone 18',''),
(3061,'Coordinate_Operation',17420,7302,'Congo TM zone 20',''),
(3062,'Coordinate_Operation',17422,7302,'Congo TM zone 22',''),
(3063,'Coordinate_Operation',17424,7302,'Congo TM zone 24',''),
(3064,'Coordinate_Operation',17426,7302,'Congo TM zone 26',''),
(3065,'Coordinate_Operation',17428,7302,'Congo TM zone 28',''),
(3066,'Coordinate_Operation',17430,7302,'Congo TM zone 30',''),
(3067,'Coordinate Reference System',3120,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(3068,'Coordinate Reference System',3328,7314,'System GUGiK-80',''),
(3069,'Coordinate Reference System',3329,7314,'System 1942/15 (3)',''),
(3070,'Coordinate Reference System',3330,7314,'System 1942/18 (3)',''),
(3071,'Coordinate Reference System',3331,7314,'System 1942/21 (3)',''),
(3072,'Coordinate Reference System',3332,7314,'System 1942/24 (3)',''),
(3073,'Coordinate Reference System',3333,7314,'System 1942/15 (6)',''),
(3074,'Coordinate Reference System',3334,7314,'System 1942/21 (6)',''),
(3075,'Coordinate Reference System',3335,7314,'System 1942/27 (6)',''),
(3076,'Coordinate Reference System',2172,7314,'System 1965 zone II',''),
(3077,'Coordinate Reference System',2173,7314,'System 1965 zone III',''),
(3078,'Coordinate Reference System',2174,7314,'System 1965 zone IV',''),
(3079,'Coordinate Reference System',2175,7314,'System 1965 zone V',''),
(3080,'Coordinate Reference System',2176,7314,'System 2000/15',''),
(3081,'Coordinate Reference System',2177,7314,'System 2000/18',''),
(3082,'Coordinate Reference System',2178,7314,'System 2000/21',''),
(3083,'Coordinate Reference System',2179,7314,'System 2000/24',''),
(3084,'Coordinate Reference System',2180,7314,'System 1992',''),
(3085,'Coordinate Reference System',3120,7314,'System 1965 zone I',''),
(3086,'Coordinate Reference System',3346,7302,'LKS94','This alias is also used for geographical and geocentric CRSs.'),
(3087,'Coordinate Reference System',3346,7307,'LT_LKS94 / LT_TM',''),
(3088,'Coordinate Reference System',3346,7301,'Lietuvos Koordinaciu Sistema 1994',''),
(3089,'Datum',6701,7302,'IGCB 1955',''),
(3090,'Datum',6701,7301,'Bas Congo 1955',''),
(3091,'Coordinate Reference System',4701,7301,'Bas Congo 1955',''),
(3092,'Coordinate Reference System',3339,7301,'Bas Congo 1955 / Congo TM zone 12',''),
(3093,'Coordinate Reference System',3340,7301,'Bas Congo 1955 / Congo TM zone 14',''),
(3094,'Coordinate Reference System',3341,7301,'Bas Congo 1955 / Congo TM zone 16',''),
(3095,'Coordinate Reference System',3342,7301,'Bas Congo 1955 / UTM zone 33S',''),
(3096,'Coordinate_Operation',19898,7302,'PDC Mercator',''),
(3097,'Coordinate Reference System',3347,7302,'NAD83 / STC Lambert',''),
(3098,'Coordinate Reference System',3348,7317,'NAD83(CSRS) / STC LCC',''),
(3099,'Coordinate Reference System',3348,7301,'NAD83 / STC Lambert','See CRS remarks.'),
(3100,'Datum',6182,7313,'Observatorio Meteorologico 1939','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000). Prior versions of TR8350.2 erroneously called this "Observatorio 1966".'),
(3101,'Datum',6182,7313,'Observatorio 1966','As incorrectly carried in NIMA TR8350.2 original edition (September 1987), from which the name has widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by "Observatorio Meteorologico 1939".'),
(3102,'Coordinate Reference System',6885,7302,'NAD83(CORS96) / OR N (ft)',''),
(3103,'Coordinate Reference System',6887,7302,'CORS96 / OR S (ft)',''),
(3104,'Coordinate_Operation Method',1034,7301,'Molodensky-Badekas (geocentric domain)',''),
(3105,'Coordinate_Operation Method',1039,7301,'Molodensky-Badekas (geog3D domain)',''),
(3106,'Datum',6616,7313,'Selvagem Grande 1938','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000). Prior versions of TR8350.2 erroneously called this "Marco Astro".'),
(3107,'Datum',6616,7313,'Marco Astro','As incorrectly carried in NIMA TR8350.2 original edition (Sept. 1987), from which the name has widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by "Observatorio Meteorologico 1939". Not to be confused with Marcus Island Astro.'),
(3108,'Coordinate Reference System',4616,7313,'Marco Astro','As incorrectly carried in NIMA TR8350.2 original edition (Sept. 1987), from which the name has widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by "Observatorio Meteorologico 1939". Not to be confused with Marcus Island Astro.'),
(3109,'Coordinate Reference System',4616,7313,'Selvagem Grande 1938','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000). Prior versions of TR8350.2 erroneously called this "Marco Astro".'),
(3110,'Coordinate Reference System',2943,7313,'Selvagem Grande 1938 / UTM zone 28N','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000). Prior versions of TR8350.2 erroneously called the base geographic CRS "Marco Astro".'),
(3111,'Coordinate_Operation',6780,7301,'Oregon Sweet Home-Sisters zone (International feet)','Previous name.'),
(3112,'Coordinate_Operation',6779,7301,'Oregon Sweet Home-Sisters zone (meters)','Previous name.'),
(3113,'Coordinate Reference System',6799,7301,'NAD83(2011) / Oregon Bend-Vale zone (ft)','Previous name.'),
(3114,'Datum',6703,7302,'Mhast 1951',''),
(3115,'Datum',6705,7301,'Mhast','This same alias is ambiguous as is also used for Mhast (onshore) and Malongo 1987.'),
(3116,'Datum',6704,7301,'Mhast','This same alias is ambiguous as is also used for Mhast offshore and Malongo 1987.'),
(3117,'Datum',6259,7301,'Mhast','This same alias is ambiguous as is also used for Mhast (onshore) and Mhast (offshore).'),
(3118,'Coordinate Reference System',4259,7301,'Mhast','This same alias is ambiguous as is also used for Mhast (onshore) and Mhast (offshore).'),
(3119,'Coordinate Reference System',25932,7301,'Mhast / UTM zone 32S','This same alias is ambiguous as is also used for projected CRSs using Mhast (onshore) or Mhast (offshore) as base geographic CRS, with UTM zone 32S.'),
(3120,'Coordinate Reference System',4705,7301,'Mhast','This same alias is ambiguous as is also used for Mhast (onshore) and Malongo 1987.'),
(3121,'Coordinate Reference System',4704,7301,'Mhast','This same alias is ambiguous as is also used for Mhast offshore and Malongo 1987.'),
(3122,'Coordinate Reference System',3354,7301,'Mhast / UTM zone 32S','This same alias is ambiguous as is also used for projected CRSs using Mhast (onshore) or Malongo 1987 as base geographic CRS, with UTM zone 32S.'),
(3123,'Coordinate Reference System',3353,7301,'Mhast / UTM zone 32S','This same alias is ambiguous as is also used for projected CRSs using Mhast (offshore) or Malongo 1987 as base geographic CRS, with UTM zone 32S.'),
(3124,'Coordinate_Operation',15790,7301,'Mhast to WGS 72BE (1)',''),
(3125,'Coordinate_Operation',8656,7301,'Mhast to WGS 84 (4)',''),
(3126,'Datum',6699,7301,'Le Pouce (Mauritius 94)','Mauritius 1994 is a GPS-derived coordinate set consistent with the Le Pouce 1934 coordinate set.'),
(3127,'Datum',6699,7301,'Le Pouce (Mauritius PN 94)','Mauritius PN 1994 is a GPS-derived coordinate set retaining GPS scale and orientation and consistent with the Le Pouce 1934 coordinate set to better than 2 metres.'),
(3128,'Coordinate Reference System',4699,7301,'Le Pouce (Mauritius 94)','Mauritius 1994 is a GPS-derived coordinate set for 80 stations exactly consistent with Le Pouce 1934 coordinates.'),
(3129,'Coordinate Reference System',4699,7301,'Le Pouce (Mauritius PN 94)','Mauritius Precise Network (PN) 1994 is a GPS-derived coordinate set for 80 stations retaining GPS scale and direction and consistent with Le Pouce 1934 coordinates to better than 2 metres.'),
(3130,'Coordinate Reference System',3337,7301,'Le Pouce (Mauritius 94) / Mauritius Grid',''),
(3131,'Coordinate Reference System',3337,7301,'Le Pouce (Mauritius PN 94) / Mauritius Grid',''),
(3132,'Coordinate_Operation',15784,7301,'Le Pouce (Mauritius 94) to WGS 84 (1)',''),
(3133,'Coordinate_Operation',15784,7301,'Le Pouce (Mauritius PN 94) to WGS 84 (1)',''),
(3134,'Coordinate Reference System',4700,7301,'Mauritanian Mining Cadastre 1999',''),
(3135,'Coordinate Reference System',3367,7301,'Mauritanian Mining Cadastre 1999 / UTM zone 28N',''),
(3136,'Coordinate Reference System',3368,7301,'Mauritanian Mining Cadastre 1999 / UTM zone 29N',''),
(3137,'Coordinate Reference System',3369,7301,'Mauritanian Mining Cadastre 1999 / UTM zone 30N',''),
(3138,'Coordinate_Operation',15857,7301,'Mining Cadastre 1999 / UTM zone 28N to Mauritania 1999 / UTM zone 28N (1)',''),
(3139,'Coordinate_Operation',15858,7301,'Mining Cadastre 1999 / UTM zone 29N to Mauritania 1999 / UTM zone 29N (1)',''),
(3140,'Coordinate_Operation',15859,7301,'Mining Cadastre 1999 / UTM zone 30N to Mauritania 1999 / UTM zone 30N (1)',''),
(3141,'Coordinate_Operation',15795,7313,'Astro Tern Island (FRIG) 1961 to WGS 84','Found in DMA TR8350.2 3rd edition under this name.'),
(3142,'Coordinate_Operation',15795,7313,'Astro B4 Sorol Atoll to WGS 84','Found in DMA TR8350.2 original 1987 under this name.'),
(3143,'Coordinate_Operation',15794,7313,'Anna 1 Astro 1965 to WGS 84',''),
(3144,'Datum',6725,7301,'Johnston Atoll 1961',''),
(3145,'Coordinate_Operation Method',9636,7301,'Molodensky-Badekas (geog2D domain)',''),
(3146,'Coordinate Reference System',6798,7301,'NAD83(2011) / Oregon Bend-Vale zone (m)','Previous name.'),
(3147,'Coordinate_Operation',15798,7313,'Astro DOS 71/4 to WGS 84',''),
(3148,'Coordinate_Operation',15799,7313,'Astronomic Station 1952 to WGS 84',''),
(3149,'Coordinate_Operation',15809,7313,'Johnston Island 1961 Astro to WGS 84',''),
(3150,'Coordinate_Operation',15809,7301,'Johnston Atoll 1961 to WGS 84 (1)',''),
(3151,'Coordinate_Operation',15810,7313,'Kusaie Astro 1951 to WGS 84',''),
(3152,'Coordinate_Operation',15813,7313,'ISTS 061 Astro 1968 to WGS 84',''),
(3153,'Coordinate_Operation',15814,7313,'L. C. 5 Astro 1961 to WGS 84',''),
(3154,'Coordinate_Operation',15816,7313,'Tristan Astro 1968 to WGS 84',''),
(3155,'Coordinate_Operation',15817,7313,'Midway Astro 1961 to WGS 84','This same alias also used for replacement transformation (see code 15818).'),
(3156,'Coordinate_Operation',15818,7313,'Midway Astro 1961 to WGS 84','This same alias also used for superseded transformation (see code 15817).'),
(3157,'Coordinate_Operation',15819,7313,'Pitcairn Astro 1967 to WGS 84',''),
(3158,'Coordinate_Operation',15820,7313,'Santo (DOS) 1965 to WGS 84',''),
(3159,'Coordinate_Operation',15822,7313,'Wake - Eniwetok 1960 to WGS 84',''),
(3160,'Coordinate_Operation',15823,7313,'Wake Island Astro 1952 to WGS 84',''),
(3161,'Coordinate_Operation',15811,7313,'Antigua Island Astro 1943 to WGS 84',''),
(3162,'Coordinate_Operation',15805,7313,'DOS 1968 to WGS 84',''),
(3163,'Coordinate_Operation',15807,7313,'GUX 1 Astro to WGS 84',''),
(3164,'Coordinate Reference System',4725,7301,'Johnston Atoll 1961',''),
(3165,'Datum',6737,7301,'Korea 2000',''),
(3166,'Coordinate_Operation',15808,7313,'ISTS 073 Astro 1969 to WGS 84',''),
(3167,'Coordinate_Operation',15803,7313,'Canton Astro 1966 to WGS 84',''),
(3168,'Coordinate_Operation',15801,7313,'Bellevue IGN to WGS 84',''),
(3169,'Coordinate Reference System',2987,7301,'St. Pierre et Miquelon 1950 / UTM zone 21N',''),
(3170,'Datum',6740,7302,'PZ-90',''),
(3171,'Datum',6739,7301,'HK63(67)',''),
(3172,'Datum',6738,7302,'HK63',''),
(3173,'Coordinate Reference System',4738,7302,'HK63',''),
(3174,'Coordinate Reference System',4739,7302,'HK63(67)',''),
(3175,'Coordinate_Operation',15842,7302,'HK63(67) to WGS 84 (1)',''),
(3176,'Coordinate_Operation',15842,7313,'Hong Kong 1963 to WGS 84',''),
(3177,'Coordinate_Operation',15844,7301,'S-42 to PZ-90 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(3178,'Coordinate_Operation',15865,7301,'S-42 to WGS 84 (16)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(3179,'Coordinate Reference System',7415,7315,'RDNAP',''),
(3180,'Datum',6690,7301,'IGN79 Tahiti',''),
(3181,'Datum',6639,7301,'Uvea SHOM 1978',''),
(3182,'Coordinate Reference System',4690,7301,'IGN79 Tahiti',''),
(3183,'Coordinate Reference System',4639,7301,'Uvea SHOM 1978',''),
(3184,'Coordinate_Operation',15847,7301,'Ueva SHOM 1978 to WGS 84 (2)',''),
(3185,'Coordinate Reference System',3355,7302,'S-650 TL / Red Belt',''),
(3186,'Coordinate_Operation',15792,7302,'S-650 TL to WGS 72BE (1)',''),
(3187,'Coordinate Reference System',4706,7302,'S-650 TL',''),
(3188,'Coordinate_Operation',8657,7302,'S-650 TL to WGS 84 (1)',''),
(3189,'Coordinate_Operation',15846,7302,'S-650 TL to WGS 84 (2)',''),
(3190,'Datum',6706,7302,'S-650 TL',''),
(3191,'Coordinate_Operation',1888,7313,'Porto Santo 1936 to WGS 84',''),
(3192,'Coordinate_Operation',1444,7313,'Montserrat Island Astro 1958 to WGS 84',''),
(3193,'Coordinate_Operation',15850,7313,'Kerguelen Island 1949 to WGS 84',''),
(3194,'Coordinate_Operation',15741,7301,'Levant to WGS 84 (2)',''),
(3195,'Coordinate Reference System',2004,7301,'Montserrat 58 / British West Indies Grid',''),
(3196,'Coordinate Reference System',4604,7302,'Montserrat 58',''),
(3197,'Coordinate_Operation',15861,7301,'Mining Cadastre 1999 / UTM zone 28N to WGS 84 / UTM zone 28N (1)',''),
(3198,'Coordinate_Operation',15862,7301,'Mining Cadastre 1999 / UTM zone 29N to WGS 84 / UTM zone 29N (1)',''),
(3199,'Coordinate_Operation',15863,7301,'Mining Cadastre 1999 / UTM zone 30N to WGS 84 / UTM zone 30N (1)',''),
(3200,'Datum',6741,7302,'FD54',''),
(3201,'Datum',6742,7302,'GDM2000',''),
(3202,'Coordinate Reference System',3386,7301,'KKJ / Basic Coordinate System zone 0',''),
(3203,'Coordinate Reference System',3387,7301,'KKJ / Basic Coordinate System zone 5',''),
(3204,'Coordinate Reference System',4669,7301,'LKS94 (ETRS89)',''),
(3205,'Coordinate_Operation',1283,7301,'LKS94 (ETRS89) to WGS 84 (1)',''),
(3206,'Coordinate_Operation',1274,7301,'Pulkovo 1942 to LKS94(ETRS89) (1)',''),
(3207,'Coordinate_Operation Method',1061,7301,'Molodenski-Badekas transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(3208,'Coordinate_Operation Method',1061,7301,'Molodensky-Badekas 10-parameter transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(3209,'Coordinate_Operation Method',1063,7301,'Molodenski-Badekas transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(3210,'Coordinate_Operation Method',1063,7301,'Molodensky-Badekas 10-parameter transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(3211,'Coordinate_Operation Method',1062,7301,'Molodenski-Badekas transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(3212,'Datum',6745,7302,'RD/83',''),
(3213,'Datum',6746,7302,'PD/83','PD/83 is so-named to distinguish this datum from RD/83. The fundamental point Rauenberg was destroyed in 1910 and replaced by the station at Potsdam.'),
(3214,'Coordinate_Operation',15868,7307,'DE_RD/83 to ETRS89',''),
(3215,'Coordinate_Operation',15867,7307,'DE_PD/83 to ETRS89',''),
(3216,'Coordinate_Operation Method',1062,7301,'Molodensky-Badekas 10-parameter transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(3217,'Datum',6747,7302,'GR96',''),
(3218,'Datum',6720,7302,'FGD 1986',''),
(3219,'Coordinate Reference System',32164,7301,'NAD83 / UTM zone 14N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 14N (code 26914). UTM is a metric system so strictly this is not UTM.'),
(3220,'Coordinate Reference System',32165,7301,'NAD83 / UTM zone 15N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 15N (code 26915). UTM is a metric system so strictly this is not UTM.'),
(3221,'Coordinate Reference System',32166,7301,'NAD83 / UTM zone 16N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 16N (code 26916). UTM is a metric system so strictly this is not UTM.'),
(3222,'Coordinate Reference System',32167,7301,'NAD83 / UTM zone 17N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 17N (code 26917). UTM is a metric system so strictly this is not UTM.'),
(3223,'Coordinate Reference System',32664,7301,'WGS 84 / UTM zone 14N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 14N (code 32614). UTM is a metric system so strictly this is not UTM.'),
(3224,'Coordinate Reference System',32665,7301,'WGS 84 / UTM zone 15N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 15N (code 32615). UTM is a metric system so strictly this is not UTM.'),
(3225,'Coordinate Reference System',32666,7301,'WGS 84 / UTM zone 16N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 16N (code 32616). UTM is a metric system so strictly this is not UTM.'),
(3226,'Coordinate Reference System',32667,7301,'WGS 84 / UTM zone 17N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 17N (code 32617). UTM is a metric system so strictly this is not UTM.'),
(3227,'Coordinate_Operation',19881,7302,'Alberta 10-TM Forest',''),
(3228,'Coordinate_Operation',19882,7302,'Alberta 10-TM Resource',''),
(3229,'Coordinate Reference System',4720,7302,'FGD 1986',''),
(3230,'Datum',6720,7301,'Fiji 1986',''),
(3231,'Coordinate Reference System',3143,7302,'FGD 1986 / Fiji Map Grid',''),
(3232,'Coordinate Reference System',3144,7302,'fk54',''),
(3233,'Coordinate Reference System',3144,7301,'Faroe Cadastre 1954',''),
(3234,'Coordinate Reference System',3145,7302,'fke',''),
(3235,'Coordinate Reference System',3173,7301,'Faroe Cadastre 1989',''),
(3236,'Coordinate_Operation',15877,7302,'FGD 1986 to WGS 84 (2)',''),
(3237,'Coordinate_Operation',15876,7302,'FGD 1986 to WGS 84 (1)',''),
(3238,'Coordinate Reference System',4752,7301,'Viti Levu 1916','The report on the 1912 survey work was issued in 1916.'),
(3239,'Coordinate Reference System',3140,7301,'Viti Levu 1916 / Viti Levu Grid','The report on the 1912 survey work was issued in 1916.'),
(3240,'Datum',6752,7301,'Viti Levu 1916','The survey network adjustment of 1912 was published in 1916.'),
(3241,'Datum',6748,7301,'Vanua Levu 1917','The survey network adjustment of 1915 was published in 1917.'),
(3242,'Coordinate Reference System',4748,7301,'Vanua Levu 1917','The report on the 1915 survey work was issued in 1917.'),
(3243,'Coordinate Reference System',3139,7301,'Vanua Levu 1917 / Vanua Levu Grid','The report on the 1915 survey work was issued in 1917.'),
(3244,'Coordinate_Operation',15878,7301,'Vanua Levu 1917 to WGS 84 (1)',''),
(3245,'Coordinate Reference System',3400,7301,'NAD83 / 10TM AEP Forest','Same alias is ambiguous as may be used for NAD83(CSRS) / 10-TM (Forest). See CRS code 3402.'),
(3246,'Coordinate Reference System',3401,7301,'NAD83 / 10TM AEP Resource','Same alias is ambiguous as may be used for NAD83(CSRS) / 10-TM (Resource). See CRS code 3403.'),
(3247,'Coordinate Reference System',3403,7301,'NAD83 / 10TM AEP Resource','This CRS may sometimes be called "NAD83 / 10TM AEP Resource". That is the name of a different system (see CRS code 3401) but at the scales involved the submeter positional differences are not considered significant.'),
(3248,'Coordinate Reference System',3402,7301,'NAD83 / 10TM AEP Forest','This CRS may sometimes be called "NAD83 / 10TM AEP Forest". That is the name of a different system (see CRS code 3400) but at the scales involved the submeter positional differences are not considered significant.'),
(3249,'Unit of Measure',9097,7301,'international chain',''),
(3250,'Unit of Measure',9096,7301,'international yard',''),
(3251,'Unit of Measure',9098,7301,'international link',''),
(3252,'Unit of Measure',9096,1041,'yd',''),
(3253,'Unit of Measure',9097,7302,'ch',''),
(3254,'Unit of Measure',9098,7302,'lk',''),
(3255,'Coordinate_Operation',15897,7301,'Viti Levu 1916 to WGS 84 (1)',''),
(3256,'Coordinate Reference System',3854,7301,'ST74 0 gon 65:-1',''),
(3257,'Datum',6749,7301,'RGNC91-93',''),
(3258,'Datum',6749,7302,'RGNC',''),
(3259,'Coordinate Reference System',3163,7301,'RGNC / Lambert New Caledonia',''),
(3260,'Coordinate_Operation',16301,7301,'6-degree Gauss-Kruger CM 3E',''),
(3261,'Coordinate_Operation',16302,7301,'6-degree Gauss-Kruger CM 9E',''),
(3262,'Coordinate_Operation',16303,7301,'6-degree Gauss-Kruger CM 15E',''),
(3263,'Coordinate_Operation',6888,7302,'Ocotepeque to NAD27 (1)',''),
(3264,'Coordinate_Operation',16305,7301,'6-degree Gauss-Kruger CM 27E',''),
(3265,'Coordinate_Operation',16306,7301,'6-degree Gauss-Kruger CM 33E',''),
(3266,'Coordinate_Operation',16307,7301,'6-degree Gauss-Kruger CM 39E',''),
(3267,'Coordinate_Operation',16308,7301,'6-degree Gauss-Kruger CM 45E',''),
(3268,'Coordinate_Operation',16309,7301,'6-degree Gauss-Kruger CM 51E',''),
(3269,'Coordinate_Operation',16310,7301,'6-degree Gauss-Kruger CM 57E',''),
(3270,'Coordinate_Operation',16311,7301,'6-degree Gauss-Kruger CM 63E',''),
(3271,'Coordinate_Operation',16312,7301,'6-degree Gauss-Kruger CM 69E',''),
(3272,'Coordinate_Operation',16313,7301,'6-degree Gauss-Kruger CM 75E',''),
(3273,'Coordinate_Operation',16314,7301,'6-degree Gauss-Kruger CM 81E',''),
(3274,'Coordinate_Operation',16315,7301,'6-degree Gauss-Kruger CM 87E',''),
(3275,'Coordinate_Operation',16316,7301,'6-degree Gauss-Kruger CM 93E',''),
(3276,'Coordinate_Operation',16317,7301,'6-degree Gauss-Kruger CM 99E',''),
(3277,'Coordinate_Operation',16318,7301,'6-degree Gauss-Kruger CM 105E',''),
(3278,'Coordinate_Operation',16319,7301,'6-degree Gauss-Kruger CM 111E',''),
(3279,'Coordinate_Operation',16320,7301,'6-degree Gauss-Kruger CM 117E',''),
(3280,'Coordinate_Operation',16321,7301,'6-degree Gauss-Kruger CM 123E',''),
(3281,'Coordinate_Operation',16322,7301,'6-degree Gauss-Kruger CM 129E',''),
(3282,'Coordinate_Operation',16323,7301,'6-degree Gauss-Kruger CM 135E',''),
(3283,'Coordinate_Operation',16324,7301,'6-degree Gauss-Kruger CM 141E',''),
(3284,'Coordinate_Operation',16325,7301,'6-degree Gauss-Kruger CM 147E',''),
(3285,'Coordinate_Operation',16326,7301,'6-degree Gauss-Kruger CM 153E',''),
(3286,'Coordinate_Operation',16327,7301,'6-degree Gauss-Kruger CM 159E',''),
(3287,'Coordinate_Operation',16328,7301,'6-degree Gauss-Kruger CM 165E',''),
(3288,'Coordinate_Operation',16329,7301,'6-degree Gauss-Kruger CM 171E',''),
(3289,'Coordinate_Operation',16330,7301,'6-degree Gauss-Kruger CM 177E',''),
(3290,'Coordinate_Operation',16331,7301,'6-degree Gauss-Kruger CM 177W',''),
(3291,'Coordinate_Operation',16332,7301,'6-degree Gauss-Kruger CM 171W',''),
(3292,'Coordinate_Operation',16333,7301,'6-degree Gauss-Kruger CM 165W',''),
(3293,'Coordinate_Operation',16334,7301,'6-degree Gauss-Kruger CM 159W',''),
(3294,'Coordinate_Operation',16335,7301,'6-degree Gauss-Kruger CM 153W',''),
(3295,'Coordinate_Operation',16336,7301,'6-degree Gauss-Kruger CM 147W',''),
(3296,'Coordinate_Operation',16337,7301,'6-degree Gauss-Kruger CM 141W',''),
(3297,'Coordinate_Operation',16338,7301,'6-degree Gauss-Kruger CM 135W',''),
(3298,'Coordinate_Operation',16339,7301,'6-degree Gauss-Kruger CM 129W',''),
(3299,'Coordinate_Operation',16340,7301,'6-degree Gauss-Kruger CM 123W',''),
(3300,'Coordinate_Operation',16341,7301,'6-degree Gauss-Kruger CM 117W',''),
(3301,'Coordinate_Operation',16342,7301,'6-degree Gauss-Kruger CM 111W',''),
(3302,'Coordinate_Operation',16343,7301,'6-degree Gauss-Kruger CM 105W',''),
(3303,'Coordinate_Operation',16344,7301,'6-degree Gauss-Kruger CM 99W',''),
(3304,'Coordinate_Operation',16345,7301,'6-degree Gauss-Kruger CM 93W',''),
(3305,'Coordinate_Operation',16346,7301,'6-degree Gauss-Kruger CM 87W',''),
(3306,'Coordinate_Operation',16347,7301,'6-degree Gauss-Kruger CM 81W',''),
(3307,'Coordinate_Operation',16348,7301,'6-degree Gauss-Kruger CM 75W',''),
(3308,'Coordinate_Operation',16349,7301,'6-degree Gauss-Kruger CM 69W',''),
(3309,'Coordinate_Operation',16350,7301,'6-degree Gauss-Kruger CM 63W',''),
(3310,'Coordinate_Operation',16351,7301,'6-degree Gauss-Kruger CM 57W',''),
(3311,'Coordinate_Operation',16352,7301,'6-degree Gauss-Kruger CM 51W',''),
(3312,'Coordinate_Operation',16353,7301,'6-degree Gauss-Kruger CM 45W',''),
(3313,'Coordinate_Operation',16354,7301,'6-degree Gauss-Kruger CM 39W',''),
(3314,'Coordinate_Operation',16355,7301,'6-degree Gauss-Kruger CM 33W',''),
(3315,'Coordinate_Operation',16356,7301,'6-degree Gauss-Kruger CM 27W',''),
(3316,'Coordinate_Operation',16357,7301,'6-degree Gauss-Kruger CM 21W',''),
(3317,'Coordinate_Operation',16358,7301,'6-degree Gauss-Kruger CM 15W',''),
(3318,'Coordinate_Operation',16359,7301,'6-degree Gauss-Kruger CM 9W',''),
(3319,'Coordinate_Operation',16360,7301,'6-degree Gauss-Kruger CM 3W',''),
(3320,'Datum',6298,7301,'Timbalai 1968',''),
(3321,'Datum',6298,7301,'Borneo Triangulation of 1968',''),
(3322,'Datum',6298,7302,'BT68',''),
(3323,'Coordinate Reference System',4298,7301,'Timbalai 1968',''),
(3324,'Coordinate Reference System',4298,7301,'BT68',''),
(3325,'Coordinate Reference System',29849,7301,'BT68 / UTM zone 49N',''),
(3326,'Coordinate Reference System',29850,7301,'BT68 / UTM zone 50N',''),
(3327,'Coordinate Reference System',29873,7301,'BT68 / RSO Borneo (m)',''),
(3328,'Coordinate Reference System',29849,7301,'Timbalai 1968 / UTM zone 49N',''),
(3329,'Coordinate Reference System',29850,7301,'Timbalai 1968 / UTM zone 50N',''),
(3330,'Coordinate Reference System',29873,7301,'Timbalai 1968 / RSO Borneo (m)',''),
(3331,'Coordinate_Operation',1228,7301,'Timbalai 1968 to WGS 84 (1)',''),
(3332,'Coordinate_Operation',1228,7301,'BT68 to WGS 84 (1)',''),
(3333,'Coordinate_Operation',1592,7301,'Timbalai 1968 to WGS 84 (2)',''),
(3334,'Coordinate_Operation',1592,7301,'BT68 to WGS 84 (2)',''),
(3335,'Coordinate_Operation',1615,7301,'Timbalai 1968 to WGS 84 (3)',''),
(3336,'Coordinate_Operation',1615,7301,'BT68 to WGS 84 (3)',''),
(3337,'Coordinate_Operation',1852,7301,'Timbalai 1968 to WGS 84 (4)',''),
(3338,'Coordinate_Operation',1852,7301,'BT68 to WGS 84 (4)',''),
(3339,'Datum',6245,7301,'Malaysia Revised Triangulation 1968',''),
(3340,'Datum',6245,7302,'MRT68',''),
(3341,'Coordinate Reference System',4245,7301,'MRT68',''),
(3342,'Coordinate Reference System',24500,7317,'MRT68 / Singapore Grid',''),
(3343,'Coordinate Reference System',24547,7317,'MRT68 / UTM zone 47N',''),
(3344,'Coordinate Reference System',24548,7317,'MRT68 / UTM zone 48N',''),
(3345,'Coordinate_Operation',1158,7313,'Kertau 1948 to WGS 84','MRT68 superseded MRT48. OGP believes that the info source used 1968 data for derivation of the transformation, but mislabelled it.'),
(3346,'Coordinate_Operation',1158,7301,'MRT68 to WGS 84 (1)',''),
(3347,'Coordinate_Operation',15896,7301,'Kertau (RSO) to MRT68 (1)',''),
(3348,'Unit of Measure',9301,7301,'chain',''),
(3349,'Unit of Measure',9301,7302,'chSe(T)',''),
(3350,'Coordinate Reference System',3169,7301,'RGNC / UTM zone 57S',''),
(3351,'Coordinate Reference System',3170,7301,'RGNC / UTM zone 58S',''),
(3352,'Coordinate Reference System',3171,7301,'RGNC / UTM zone 59S',''),
(3353,'Datum',6714,7301,'Bellevue (IGN)',''),
(3354,'Datum',6730,7301,'Santo (DOS)',''),
(3355,'Coordinate Reference System',4714,7301,'Bellevue (IGN)',''),
(3356,'Coordinate Reference System',4730,7301,'Santo (DOS)',''),
(3357,'Coordinate_Operation',15801,7301,'Bellevue (IGN) to WGS 84 (1)',''),
(3358,'Coordinate Reference System',3143,7302,'Fiji 1986 / FMG',''),
(3359,'Coordinate Reference System',3153,7301,'NAD83 / BC Albers','This CRS may sometimes be called "NAD83 / BC Albers". That is the name of a different system (see CRS code 3005) but at the scales involved the submeter positional differences are not considered significant.'),
(3360,'Coordinate Reference System',3173,7302,'fk89','This abbreviation is used for datum, geogCRS and projCRS.'),
(3361,'Coordinate Reference System',4753,7301,'FD54a',''),
(3362,'Datum',6753,7301,'FD54a',''),
(3363,'Coordinate Reference System',3311,7301,'NAD83(HPGN) / California (Teale) Albers',''),
(3364,'Coordinate Reference System',3358,7301,'NAD83(HPGN) / North Carolina',''),
(3365,'Coordinate Reference System',3359,7301,'NAD83(HPGN) / North Carolina (ftUS)',''),
(3366,'Coordinate Reference System',3360,7301,'NAD83(HPGN) / South Carolina',''),
(3367,'Coordinate Reference System',3361,7301,'NAD83(HPGN) / South Carolina (ft)',''),
(3368,'Coordinate Reference System',3362,7301,'NAD83(HPGN) / Pennsylvania North',''),
(3369,'Coordinate Reference System',3363,7301,'NAD83(HPGN) / Pennsylvania North (ftUS)',''),
(3370,'Coordinate Reference System',3364,7301,'NAD83(HPGN) / Pennsylvania South',''),
(3371,'Coordinate Reference System',3365,7301,'NAD83(HPGN) / Pennsylvania South (ftUS)',''),
(3372,'Coordinate Reference System',3075,7301,'Maine Coordinate System of 2000 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 East zone projection.'),
(3373,'Coordinate Reference System',3076,7301,'Maine Coordinate System of 2000 Central Zone','This alias is ambiguous as also used for NAD83 / Maine CS2000 Central.'),
(3374,'Coordinate Reference System',3077,7301,'Maine Coordinate System of 2000 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 West zone projection.'),
(3375,'Coordinate_Operation',19871,7302,'RSO Malaya (m)',''),
(3376,'Coordinate_Operation',19872,7302,'RSO Malaya (m)',''),
(3377,'Coordinate_Operation',15905,7301,'Viti Levu Grid to FMG (1)',''),
(3378,'Coordinate_Operation',15906,7302,'Vanua Levu Grid to FMG (1)',''),
(3379,'Datum',6754,7302,'LGD2006',''),
(3380,'Coordinate Reference System',3079,7301,'Michigan GeoRef','This alias is ambiguous as also used for NAD83 / Michigan Oblique Mercator.'),
(3381,'Coordinate Reference System',3085,7301,'TCMS/AEA','This alias is ambiguous as also used for NAD83 / Texas Centric Albers Equal Area.'),
(3382,'Coordinate Reference System',3085,7301,'Texas Centric Mapping System / Albers Equal Area','This alias is ambiguous as also used for NAD83 / Texas Centric Albers Equal Area.'),
(3383,'Coordinate Reference System',3084,7301,'Texas Centric Mapping System / Lambert Conformal','This alias is ambiguous as also used for NAD83 / Texas Centric Lambert Conformal.'),
(3384,'Coordinate Reference System',3084,7301,'TCMS/ LC','This alias is ambiguous as also used for NAD83 / Texas Centric Lambert Conformal.'),
(3385,'Datum',6755,7302,'DGN95',''),
(3386,'Datum',6755,7301,'Indonesian Geodetic Datum 1995',''),
(3387,'Datum',6755,7301,'IGD95',''),
(3388,'Coordinate Reference System',4755,7301,'IGD95',''),
(3389,'Coordinate Reference System',4898,7301,'IGD95',''),
(3390,'Coordinate Reference System',4897,7301,'IGD95',''),
(3391,'Coordinate Reference System',23866,7301,'IGD95 / UTM zone 46N',''),
(3392,'Coordinate Reference System',23867,7301,'IGD95 / UTM zone 47N',''),
(3393,'Coordinate Reference System',23868,7301,'IGD95 / UTM zone 48N',''),
(3394,'Coordinate Reference System',23869,7301,'IGD95 / UTM zone 49N',''),
(3395,'Coordinate Reference System',23870,7301,'IGD95 / UTM zone 50N',''),
(3396,'Coordinate Reference System',23871,7301,'IGD95 / UTM zone 51N',''),
(3397,'Coordinate Reference System',23872,7301,'IGD95 / UTM zone 52N',''),
(3398,'Coordinate Reference System',23877,7301,'IGD95 / UTM zone 47S',''),
(3399,'Coordinate Reference System',23878,7301,'IGD95 / UTM zone 48S',''),
(3400,'Coordinate Reference System',23879,7301,'IGD95 / UTM zone 49S',''),
(3401,'Coordinate Reference System',23880,7301,'IGD95 / UTM zone 50S',''),
(3402,'Coordinate Reference System',23881,7301,'IGD95 / UTM zone 51S',''),
(3403,'Coordinate Reference System',23882,7301,'IGD95 / UTM zone 52S',''),
(3404,'Coordinate Reference System',23883,7301,'IGD95 / UTM zone 53S',''),
(3405,'Coordinate Reference System',23884,7301,'IGD95 / UTM zone 54S',''),
(3406,'Coordinate_Operation',15912,7301,'IGD95 to WGS 84 (1)',''),
(3407,'Coordinate_Operation',15911,7301,'ID74 to IGD95 (1)',''),
(3408,'Datum',6697,7302,'IGC 1962 6th Parallel South',''),
(3409,'Datum',6756,7302,'VN-2000',''),
(3410,'Coordinate Reference System',3404,7301,'NAD83(HPGN) / North Carolina (ftUS)',''),
(3411,'Coordinate_Operation',19867,7302,'NSIDC EASE-grid north projection',''),
(3412,'Coordinate_Operation',19868,7302,'NSIDC EASE-grid south projection',''),
(3413,'Coordinate_Operation',19869,7302,'NSIDC EASE-grid global projection',''),
(3414,'Datum',6896,7302,'ITRF2005',''),
(3415,'Coordinate Reference System',3414,7301,'SVY21 plane coordinate system',''),
(3416,'Datum',6647,7301,'IERS Terrestrial Reference Frame 1988','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3417,'Datum',6648,7301,'IERS Terrestrial Reference Frame 1989','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3418,'Datum',6649,7301,'IERS Terrestrial Reference Frame 1990','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3419,'Datum',6650,7301,'IERS Terrestrial Reference Frame 1991','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3420,'Datum',6651,7301,'IERS Terrestrial Reference Frame 1992','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3421,'Datum',6652,7301,'IERS Terrestrial Reference Frame 1993','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3422,'Datum',6653,7301,'IERS Terrestrial Reference Frame 1994','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3423,'Coordinate_Operation',1314,7301,'OSGB 1936 to WGS 84 (Petroleum)',''),
(3424,'Unit of Measure',9099,7301,'yard',''),
(3425,'Unit of Measure',9099,7302,'ydSe(T)',''),
(3426,'Unit of Measure',9300,7301,'foot',''),
(3427,'Unit of Measure',9300,7302,'ftSe(T)',''),
(3428,'Unit of Measure',9302,7301,'link',''),
(3429,'Unit of Measure',9302,7302,'lkSe(T)',''),
(3430,'Coordinate_Operation',15397,7301,'GLGIS Albers (basin)',''),
(3431,'Coordinate_Operation',15398,7301,'GLGIS Albers (basin+SLS)',''),
(3432,'Coordinate Reference System',3174,7301,'NAD83 / GLGIS Albers (basin)',''),
(3433,'Coordinate Reference System',3175,7301,'NAD83 / GLGIS Albers (basin+SLS)',''),
(3434,'Datum',5204,7301,'IGLD 1955',''),
(3435,'Datum',5205,7301,'IGLD 1985',''),
(3436,'Coordinate_Operation',19866,7301,'NSIDC Sea Ice south',''),
(3437,'Coordinate_Operation',19865,7301,'NSIDC Sea Ice north',''),
(3438,'Coordinate Reference System',7416,7301,'EUREF89 / UTM zone 32N + DVR90 height',''),
(3439,'Coordinate Reference System',7417,7301,'EUREF89 / UTM zone 33N + DVR90 height',''),
(3440,'Coordinate Reference System',7418,7301,'EUREF89 / Kp2000 Jutland + DVR90 height',''),
(3441,'Coordinate Reference System',7419,7301,'EUREF89 / Kp2000 Zealand + DVR90 height',''),
(3442,'Coordinate Reference System',7420,7301,'EUREF89 / Kp2000 Bornholm + DVR90 height',''),
(3443,'Coordinate Reference System',3415,7302,'WGS 72BE / SCS Lambert',''),
(3444,'Coordinate_Operation',15377,7301,'Iowa CS83 North zone (ftUS)',''),
(3445,'Coordinate_Operation',15378,7302,'Iowa CS83 South zone (ftUS)',''),
(3446,'Coordinate_Operation',15379,7301,'Kansas CS83 North zone (ftUS)',''),
(3447,'Coordinate_Operation',15380,7301,'Kansas CS83 South zone (ftUS)',''),
(3448,'Coordinate_Operation',15381,7301,'Nevada CS83 East zone (ftUS)',''),
(3449,'Coordinate_Operation',15382,7301,'Nevada CS83 Central zone (ftUS)',''),
(3450,'Coordinate_Operation',15383,7301,'Nevada CS83 West zone (ftUS)',''),
(3451,'Coordinate_Operation',15384,7301,'New Jersey CS83 (ftUS)',''),
(3452,'Coordinate_Operation',15385,7301,'Arkansas CS83 North zone (ftUS)',''),
(3453,'Coordinate_Operation',15386,7301,'Arkansas CS83 South zone (ftUS)',''),
(3454,'Coordinate_Operation',15387,7301,'Illinois CS83 East zone (ftUS)',''),
(3455,'Coordinate_Operation',15388,7301,'Illinois CS83 West zone (ftUS)',''),
(3456,'Coordinate_Operation',15389,7301,'New Hampshire CS83 (ftUS)',''),
(3457,'Coordinate_Operation',15390,7301,'Rhode Island CS83 (ftUS)',''),
(3458,'Coordinate Reference System',3425,7301,'NAD83(HPGN) / Iowa North (ftUS)',''),
(3459,'Coordinate Reference System',3426,7301,'NAD83(HPGN) / Iowa South (ftUS)',''),
(3460,'Coordinate Reference System',3427,7301,'NAD83(HPGN) / Kansas North (ftUS)',''),
(3461,'Coordinate Reference System',3428,7301,'NAD83(HPGN) / Kansas South (ftUS)',''),
(3462,'Coordinate Reference System',3429,7301,'NAD83(HPGN) / Nevada East (ftUS)',''),
(3463,'Coordinate Reference System',3430,7301,'NAD83(HPGN) / Nevada Central (ftUS)',''),
(3464,'Coordinate Reference System',3431,7301,'NAD83(HPGN) / Nevada West (ftUS)',''),
(3465,'Coordinate Reference System',3432,7301,'NAD83(HPGN) / New Jersey (ftUS)',''),
(3466,'Coordinate Reference System',3441,7301,'NAD83(HPGN) / Arkansas North (ftUS)',''),
(3467,'Coordinate Reference System',3442,7301,'NAD83(HPGN) / Arkansas South (ftUS)',''),
(3468,'Coordinate Reference System',3443,7301,'NAD83(HPGN) / Illinois East (ftUS)',''),
(3469,'Coordinate Reference System',3444,7301,'NAD83(HPGN) / Illinois West (ftUS)',''),
(3470,'Coordinate Reference System',3445,7301,'NAD83(HPGN) / New Hampshire (ftUS)',''),
(3471,'Coordinate Reference System',3446,7301,'NAD83(HPGN) / Rhode Island (ftUS)',''),
(3472,'Datum',5206,7302,'DVR90',''),
(3473,'Coordinate Reference System',3447,7301,'ETRS89 / Lambert 2005',''),
(3474,'Coordinate Reference System',4746,7301,'DHDN','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(3475,'Coordinate_Operation',6889,7302,'Ocotepeque to WGS 84 (2)',''),
(3476,'Coordinate Reference System',3397,7310,'PD/83 / Gauss-Kruger zone 4',''),
(3477,'Coordinate Reference System',4745,7301,'DHDN','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(3478,'Coordinate Reference System',3398,7310,'RD/83 / Gauss-Kruger zone 4',''),
(3479,'Coordinate Reference System',3399,7310,'RD/83 / Gauss-Kruger zone 5',''),
(3480,'Coordinate Reference System',29701,7302,'Tananarive / Laborde',''),
(3481,'Coordinate_Operation',19911,7301,'Laborde Grid',''),
(3482,'Coordinate Reference System',29702,7302,'Tananarive / Laborde app',''),
(3483,'Coordinate Reference System',3448,7301,'WGS 84 / Jamaica Metric Grid 2001',''),
(3484,'Coordinate_Operation',15391,7301,'Louisiana CS83 North zone (ftUS)',''),
(3485,'Coordinate_Operation',15392,7301,'Louisiana CS83 South zone (ftUS)',''),
(3486,'Coordinate_Operation',15393,7301,'Louisiana CS83 Offshore zone (ftUS)',''),
(3487,'Coordinate_Operation',15394,7302,'South Dakota CS83 North zone (ftUS)',''),
(3488,'Coordinate_Operation',15395,7301,'South Dakota CS83 South zone (ftUS)',''),
(3489,'Coordinate Reference System',32199,7301,'NAD83 / Louisiana Offshore (m)',''),
(3490,'Coordinate_Operation',6890,7302,'Ocotepeque to CR05 (1)',''),
(3491,'Coordinate Reference System',3072,7301,'NAD83 / Maine CS2000 East (m)',''),
(3492,'Coordinate Reference System',3074,7301,'NAD83 / Maine CS2000 West (m)',''),
(3493,'Coordinate Reference System',2759,7301,'NAD83(HARN) / Alabama East (m)',''),
(3494,'Coordinate Reference System',2760,7301,'NAD83(HARN) / Alabama West (m)',''),
(3495,'Coordinate Reference System',2762,7301,'NAD83(HARN) / Arizona Central (m)',''),
(3496,'Coordinate Reference System',2761,7301,'NAD83(HARN) / Arizona East (m)',''),
(3497,'Coordinate Reference System',2763,7301,'NAD83(HARN) / Arizona West (m)',''),
(3498,'Coordinate Reference System',2764,7301,'NAD83(HARN) / Arkansas North (m)',''),
(3499,'Coordinate Reference System',2765,7301,'NAD83(HARN) / Arkansas South (m)',''),
(3500,'Coordinate Reference System',2766,7301,'NAD83(HARN) / California zone 1 (m)',''),
(3501,'Coordinate Reference System',2767,7301,'NAD83(HARN) / California zone 2 (m)',''),
(3502,'Coordinate Reference System',2768,7301,'NAD83(HARN) / California zone 3 (m)',''),
(3503,'Coordinate Reference System',2769,7301,'NAD83(HARN) / California zone 4 (m)',''),
(3504,'Coordinate Reference System',2770,7301,'NAD83(HARN) / California zone 5 (m)',''),
(3505,'Coordinate Reference System',2771,7301,'NAD83(HARN) / California zone 6 (m)',''),
(3506,'Coordinate Reference System',2773,7301,'NAD83(HARN) / Colorado Central (m)',''),
(3507,'Coordinate Reference System',2772,7301,'NAD83(HARN) / Colorado North (m)',''),
(3508,'Coordinate Reference System',2774,7301,'NAD83(HARN) / Colorado South (m)',''),
(3509,'Coordinate Reference System',2775,7301,'NAD83(HARN) / Connecticut (m)',''),
(3510,'Coordinate Reference System',2776,7301,'NAD83(HARN) / Delaware (m)',''),
(3511,'Coordinate Reference System',2777,7301,'NAD83(HARN) / Florida East (m)',''),
(3512,'Coordinate Reference System',2779,7301,'NAD83(HARN) / Florida North (m)',''),
(3513,'Coordinate Reference System',2778,7301,'NAD83(HARN) / Florida West (m)',''),
(3514,'Coordinate Reference System',2780,7301,'NAD83(HARN) / Georgia East (m)',''),
(3515,'Coordinate Reference System',2781,7301,'NAD83(HARN) / Georgia West (m)',''),
(3516,'Coordinate Reference System',2782,7301,'NAD83(HARN) / Hawaii zone 1 (m)',''),
(3517,'Coordinate Reference System',2783,7301,'NAD83(HARN) / Hawaii zone 2 (m)',''),
(3518,'Coordinate Reference System',2784,7301,'NAD83(HARN) / Hawaii zone 3 (m)',''),
(3519,'Coordinate Reference System',2785,7301,'NAD83(HARN) / Hawaii zone 4 (m)',''),
(3520,'Coordinate Reference System',2786,7301,'NAD83(HARN) / Hawaii zone 5 (m)',''),
(3521,'Coordinate Reference System',2788,7301,'NAD83(HARN) / Idaho Central (m)',''),
(3522,'Coordinate Reference System',2787,7301,'NAD83(HARN) / Idaho East (m)',''),
(3523,'Coordinate Reference System',2789,7301,'NAD83(HARN) / Idaho West (m)',''),
(3524,'Coordinate Reference System',2790,7302,'NAD83(HARN) / IL E (m)',''),
(3525,'Coordinate Reference System',2791,7301,'NAD83(HARN) / Illinois West (m)',''),
(3526,'Coordinate Reference System',2792,7301,'NAD83(HARN) / Indiana East (m)',''),
(3527,'Coordinate Reference System',2793,7301,'NAD83(HARN) / Indiana West (m)',''),
(3528,'Coordinate Reference System',2794,7301,'NAD83(HARN) / Iowa North (m)',''),
(3529,'Coordinate Reference System',2795,7301,'NAD83(HARN) / Iowa South (m)',''),
(3530,'Coordinate Reference System',2796,7301,'NAD83(HARN) / Kansas North (m)',''),
(3531,'Coordinate Reference System',2797,7301,'NAD83(HARN) / Kansas South (m)',''),
(3532,'Coordinate Reference System',2798,7301,'NAD83(HARN) / Kentucky North (m)',''),
(3533,'Coordinate Reference System',2799,7301,'NAD83(HARN) / Kentucky South (m)',''),
(3534,'Coordinate Reference System',3090,7301,'NAD83(HARN) / Kentucky Single Zone (m)',''),
(3535,'Coordinate Reference System',2800,7301,'NAD83(HARN) / Louisiana North (m)',''),
(3536,'Coordinate Reference System',3456,7301,'NAD83(HPGN) / Louisiana North (ftUS)',''),
(3537,'Coordinate Reference System',2801,7301,'NAD83(HARN) / Louisiana South (m)',''),
(3538,'Coordinate Reference System',3457,7301,'NAD83(HPGN) / Louisiana South (ftUS)',''),
(3539,'Coordinate_Operation',6891,7302,'Ocotepeque to WGS 84 (3)',''),
(3540,'Coordinate Reference System',3075,7301,'NAD83(HARN) / Maine CS2000 East (m)',''),
(3541,'Coordinate Reference System',3077,7301,'NAD83(HARN) / Maine CS2000 West (m)',''),
(3542,'Coordinate Reference System',6867,7302,'CORS96 / OR LCC (m)',''),
(3543,'Coordinate Reference System',6868,7302,'CORS96 / OR GIC Lam (ft)',''),
(3544,'Coordinate_Operation',6864,7301,'ITRF96 to NAD83(CSRS) (1)',''),
(3545,'Coordinate Reference System',6785,7302,'CORS96 / OCRS_BKE (ft)',''),
(3546,'Coordinate Reference System',6789,7302,'CORS96 / OCRS_BKF (ft)',''),
(3547,'Coordinate Reference System',6784,7302,'CORS96 / OCRS_BKE (m)',''),
(3548,'Coordinate Reference System',6788,7302,'CORS96 / OCRS_BKF (m)',''),
(3549,'Coordinate Reference System',6793,7302,'CORS96 / OCRS_BRP (ft)',''),
(3550,'Datum',1140,7302,'SHD',''),
(3551,'Coordinate Reference System',6915,7302,'SE Island / UTM zone 40N',''),
(3552,'Coordinate Reference System',2802,7301,'NAD83(HARN) / Maine East (m)',''),
(3553,'Coordinate Reference System',2803,7301,'NAD83(HARN) / Maine West (m)',''),
(3554,'Coordinate Reference System',2804,7301,'NAD83(HARN) / Maryland (m)',''),
(3555,'Coordinate Reference System',2806,7301,'NAD83(HARN) / Massachusetts Island (m)',''),
(3556,'Coordinate Reference System',2805,7301,'NAD83(HARN) / Massachusetts Mainland (m)',''),
(3557,'Coordinate Reference System',2808,7301,'NAD83(HARN) / Michigan Central (m)',''),
(3558,'Coordinate Reference System',2807,7301,'NAD83(HARN) / Michigan North (m)',''),
(3559,'Coordinate Reference System',2809,7301,'NAD83(HARN) / Michigan South (m)',''),
(3560,'Coordinate Reference System',2811,7301,'NAD83(HARN) / Minnesota Central (m)',''),
(3561,'Coordinate Reference System',2810,7301,'NAD83(HARN) / Minnesota North (m)',''),
(3562,'Coordinate Reference System',2812,7301,'NAD83(HARN) / Minnesota South (m)',''),
(3563,'Coordinate Reference System',2813,7301,'NAD83(HARN) / Mississippi East (m)',''),
(3564,'Coordinate Reference System',2814,7301,'NAD83(HARN) / Mississippi West (m)',''),
(3565,'Coordinate Reference System',2816,7301,'NAD83(HARN) / Missouri Central (m)',''),
(3566,'Coordinate Reference System',2815,7301,'NAD83(HARN) / Missouri East (m)',''),
(3567,'Coordinate Reference System',2817,7301,'NAD83(HARN) / Missouri West (m)',''),
(3568,'Coordinate Reference System',2818,7301,'NAD83(HARN) / Montana (m)',''),
(3569,'Coordinate Reference System',2819,7301,'NAD83(HARN) / Nebraska (m)',''),
(3570,'Coordinate Reference System',2821,7301,'NAD83(HARN) / Nevada Central (m)',''),
(3571,'Coordinate Reference System',2820,7301,'NAD83(HARN) / Nevada East (m)',''),
(3572,'Coordinate Reference System',2822,7301,'NAD83(HARN) / Nevada West (m)',''),
(3573,'Coordinate Reference System',2823,7301,'NAD83(HARN) / New Hampshire (m)',''),
(3574,'Coordinate Reference System',2824,7301,'NAD83(HARN) / New Jersey (m)',''),
(3575,'Coordinate Reference System',2826,7301,'NAD83(HARN) / New Mexico Central (m)',''),
(3576,'Coordinate Reference System',2825,7301,'NAD83(HARN) / New Mexico East (m)',''),
(3577,'Coordinate Reference System',2827,7301,'NAD83(HARN) / New Mexico West (m)',''),
(3578,'Coordinate Reference System',2829,7301,'NAD83(HARN) / New York Central (m)',''),
(3579,'Coordinate Reference System',2828,7301,'NAD83(HARN) / New York East (m)',''),
(3580,'Coordinate Reference System',2831,7301,'NAD83(HARN) / New York Long Island (m)',''),
(3581,'Coordinate Reference System',2830,7301,'NAD83(HARN) / New York West (m)',''),
(3582,'Coordinate Reference System',3358,7301,'NAD83(HARN) / North Carolina (m)',''),
(3583,'Coordinate Reference System',2832,7301,'NAD83(HARN) / North Dakota North (m)',''),
(3584,'Coordinate Reference System',2833,7301,'NAD83(HARN) / North Dakota South (m)',''),
(3585,'Coordinate Reference System',2834,7301,'NAD83(HARN) / Ohio North (m)',''),
(3586,'Coordinate Reference System',2835,7301,'NAD83(HARN) / Ohio South (m)',''),
(3587,'Coordinate Reference System',2836,7301,'NAD83(HARN) / Oklahoma North (m)',''),
(3588,'Coordinate Reference System',2837,7301,'NAD83(HARN) / Oklahoma South (m)',''),
(3589,'Coordinate_Operation',6920,7301,'Kansas LCC',''),
(3590,'Coordinate Reference System',2838,7301,'NAD83(HARN) / Oregon North (m)',''),
(3591,'Coordinate Reference System',2839,7301,'NAD83(HARN) / Oregon South (m)',''),
(3592,'Coordinate Reference System',3362,7301,'NAD83(HARN) / Pennsylvania North (m)',''),
(3593,'Coordinate Reference System',3364,7301,'NAD83(HARN) / Pennsylvania South (m)',''),
(3594,'Coordinate Reference System',2840,7301,'NAD83(HARN) / Rhode Island (m)',''),
(3595,'Coordinate Reference System',3360,7301,'NAD83(HARN) / South Carolina (m)',''),
(3596,'Coordinate Reference System',2841,7301,'NAD83(HARN) / South Dakota North (m)',''),
(3597,'Coordinate Reference System',3458,7301,'NAD83(HPGN) / South Dakota North (ftUS)',''),
(3598,'Coordinate Reference System',2842,7301,'NAD83(HARN) / South Dakota South (m)',''),
(3599,'Coordinate Reference System',3459,7301,'NAD83(HPGN) / South Dakota South (ftUS)',''),
(3600,'Coordinate Reference System',2843,7301,'NAD83(HARN) / Tennessee (m)',''),
(3601,'Coordinate Reference System',2846,7301,'NAD83(HARN) / Texas Central (m)',''),
(3602,'Coordinate Reference System',2844,7301,'NAD83(HARN) / Texas North (m)',''),
(3603,'Coordinate Reference System',2845,7301,'NAD83(HARN) / Texas North Central (m)',''),
(3604,'Coordinate Reference System',2848,7301,'NAD83(HARN) / Texas South (m)',''),
(3605,'Coordinate Reference System',2847,7301,'NAD83(HARN) / Texas South Central (m)',''),
(3606,'Coordinate Reference System',2850,7301,'NAD83(HARN) / Utah Central (m)',''),
(3607,'Coordinate Reference System',2849,7301,'NAD83(HARN) / Utah North (m)',''),
(3608,'Coordinate Reference System',2851,7301,'NAD83(HARN) / Utah South (m)',''),
(3609,'Coordinate Reference System',2852,7301,'NAD83(HARN) / Vermont (m)',''),
(3610,'Coordinate Reference System',2853,7301,'NAD83(HARN) / Virginia North (m)',''),
(3611,'Coordinate Reference System',2854,7301,'NAD83(HARN) / Virginia South (m)',''),
(3612,'Coordinate Reference System',2855,7301,'NAD83(HARN) / Washington North (m)',''),
(3613,'Coordinate Reference System',2856,7301,'NAD83(HARN) / Washington South (m)',''),
(3614,'Coordinate Reference System',2857,7301,'NAD83(HARN) / West Virginia North (m)',''),
(3615,'Coordinate Reference System',2858,7301,'NAD83(HARN) / West Virginia South (m)',''),
(3616,'Coordinate Reference System',2860,7301,'NAD83(HARN) / Wisconsin Central (m)',''),
(3617,'Coordinate Reference System',2859,7301,'NAD83(HARN) / Wisconsin North (m)',''),
(3618,'Coordinate Reference System',2861,7301,'NAD83(HARN) / Wisconsin South (m)',''),
(3619,'Coordinate Reference System',2862,7301,'NAD83(HARN) / Wyoming East (m)',''),
(3620,'Coordinate Reference System',2863,7301,'NAD83(HARN) / Wyoming East Central (m)',''),
(3621,'Coordinate Reference System',2865,7301,'NAD83(HARN) / Wyoming West (m)',''),
(3622,'Coordinate Reference System',2864,7301,'NAD83(HARN) / Wyoming West Central (m)',''),
(3623,'Coordinate_Operation',15298,7302,'Utah Central (ftUS)',''),
(3624,'Coordinate_Operation',15297,7302,'Utah North (ftUS)',''),
(3625,'Coordinate_Operation',15299,7302,'Utah South (ftUS)',''),
(3626,'Coordinate Reference System',3568,7301,'NAD83(HPGN) / Utah North (ftUS)',''),
(3627,'Coordinate Reference System',3569,7301,'NAD83(HPGN) / Utah Central (ftUS)',''),
(3628,'Coordinate Reference System',3570,7301,'NAD83(HPGN) / Utah South (ftUS)',''),
(3629,'Coordinate_Operation',17295,7302,'North Pole LAEA Bering Sea',''),
(3630,'Coordinate_Operation',17296,7302,'North Pole LAEA Alaska',''),
(3631,'Coordinate_Operation',17297,7302,'North Pole LAEA Canada',''),
(3632,'Coordinate_Operation',17298,7302,'North Pole LAEA Atlantic',''),
(3633,'Coordinate_Operation',17299,7302,'North Pole LAEA Europe',''),
(3634,'Coordinate_Operation',17300,7302,'North Pole LAEA Russia',''),
(3635,'Coordinate Reference System',3448,7301,'JAD2001 / Jamaica Metric Grid 2001',''),
(3636,'Datum',6758,7302,'JAD2001',''),
(3637,'Coordinate_Operation',19860,7302,'Jamaica Metric Grid',''),
(3638,'Coordinate_Operation',18001,7302,'Austria GK West Zone',''),
(3639,'Coordinate_Operation',18002,7302,'Austria GK Central Zone',''),
(3640,'Coordinate_Operation',18003,7302,'Austria GK East Zone',''),
(3641,'Coordinate_Operation',18004,7302,'Austria GK West',''),
(3642,'Coordinate_Operation',18005,7302,'Austria GK Central',''),
(3643,'Coordinate_Operation',18006,7302,'Austria GK East',''),
(3644,'Coordinate_Operation',18007,7302,'Austria GK M28',''),
(3645,'Coordinate_Operation',18008,7302,'Austria GK M31',''),
(3646,'Coordinate_Operation',18009,7302,'Austria GK M34',''),
(3647,'Coordinate Reference System',3416,7301,'ETRF89 / Austria Lambert',''),
(3648,'Coordinate Reference System',2176,7301,'ETRF89 / Poland CS2000 zone 5',''),
(3649,'Coordinate Reference System',2177,7301,'ETRF89 / Poland CS2000 zone 6',''),
(3650,'Coordinate Reference System',2178,7301,'ETRF89 / Poland CS2000 zone 7',''),
(3651,'Coordinate Reference System',2179,7301,'ETRF89 / Poland CS2000 zone 8',''),
(3652,'Coordinate_Operation',6921,7301,'Kansas LCC (ftUS)',''),
(3653,'Coordinate Reference System',2180,7301,'ETRF89 / Poland CS92',''),
(3654,'Coordinate Reference System',2196,7301,'ETRF89 / Kp2000 Jutland',''),
(3655,'Coordinate Reference System',2197,7301,'ETRF89 / Kp2000 Zealand',''),
(3656,'Coordinate Reference System',2198,7301,'ETRF89 / Kp2000 Bornholm',''),
(3657,'Coordinate Reference System',2213,7301,'ETRF89 / TM 30 NE',''),
(3658,'Coordinate Reference System',3034,7301,'ETRF89 / LCC',''),
(3659,'Coordinate Reference System',3035,7301,'ETRF89 / LAEA',''),
(3660,'Coordinate Reference System',3038,7301,'ETRF89 / TM26',''),
(3661,'Coordinate Reference System',3039,7301,'ETRF89 / TM27',''),
(3662,'Coordinate Reference System',3040,7301,'ETRF89 / UTM zone 28N (N-E)',''),
(3663,'Coordinate Reference System',3041,7301,'ETRF89 / UTM zone 29N (N-E)',''),
(3664,'Coordinate Reference System',3042,7301,'ETRF89 / UTM zone 30N (N-E)',''),
(3665,'Coordinate Reference System',3043,7301,'ETRF89 / UTM zone 31N (N-E)',''),
(3666,'Coordinate Reference System',3044,7301,'ETRF89 / UTM zone 32N (N-E)',''),
(3667,'Coordinate Reference System',3045,7301,'ETRF89 / UTM zone 33N (N-E)',''),
(3668,'Coordinate Reference System',3046,7301,'ETRF89 / UTM zone 34N (N-E)',''),
(3669,'Coordinate Reference System',3047,7301,'ETRF89 / UTM zone 35N (N-E)',''),
(3670,'Coordinate Reference System',3048,7301,'ETRF89 / UTM zone 36N (N-E)',''),
(3671,'Coordinate Reference System',3049,7301,'ETRF89 / UTM zone 37N (N-E)',''),
(3672,'Coordinate Reference System',3050,7301,'ETRF89 / TM38',''),
(3673,'Coordinate Reference System',3051,7301,'ETRF89 / TM39',''),
(3674,'Coordinate Reference System',3067,7301,'ETRF89 / TM35FIN(E,N)',''),
(3675,'Coordinate Reference System',3126,7301,'ETRF89 / ETRS-GK19FIN',''),
(3676,'Coordinate Reference System',3127,7301,'ETRF89 / ETRS-GK20FIN',''),
(3677,'Coordinate Reference System',3128,7301,'ETRF89 / ETRS-GK21FIN',''),
(3678,'Coordinate Reference System',3129,7301,'ETRF89 / ETRS-GK22FIN',''),
(3679,'Coordinate Reference System',3130,7301,'ETRF89 / ETRS-GK23FIN',''),
(3680,'Coordinate Reference System',3131,7301,'ETRF89 / ETRS-GK24FIN',''),
(3681,'Coordinate Reference System',3132,7301,'ETRF89 / ETRS-GK25FIN',''),
(3682,'Coordinate Reference System',3133,7301,'ETRF89 / ETRS-GK26FIN',''),
(3683,'Coordinate Reference System',3134,7301,'ETRF89 / ETRS-GK27FIN',''),
(3684,'Coordinate Reference System',3135,7301,'ETRF89 / ETRS-GK28FIN',''),
(3685,'Coordinate Reference System',3136,7301,'ETRF89 / ETRS-GK29FIN',''),
(3686,'Coordinate Reference System',3137,7301,'ETRF89 / ETRS-GK30FIN',''),
(3687,'Coordinate Reference System',3138,7301,'ETRF89 / ETRS-GK31FIN',''),
(3688,'Coordinate Reference System',3145,7301,'ETRF89 / Faroe Lambert',''),
(3689,'Coordinate Reference System',3447,7301,'ETRF89 / Belgian Lambert 2005',''),
(3690,'Coordinate Reference System',7409,7301,'ETRF89 + EVRF2000 height',''),
(3691,'Coordinate Reference System',7416,7301,'ETRF89 / UTM zone 32N + DVR90 height',''),
(3692,'Coordinate Reference System',7417,7301,'ETRF89 / UTM zone 33N + DVR90 height',''),
(3693,'Coordinate Reference System',6922,7301,'NAD83 / Kansas LCC (m)',''),
(3694,'Coordinate Reference System',7418,7301,'ETRF89 / Kp2000 Jutland + DVR90 height',''),
(3695,'Coordinate Reference System',7419,7301,'ETRF89 / Kp2000 Zealand + DVR90 height',''),
(3696,'Coordinate Reference System',7420,7301,'ETRF89 / Kp2000 Bornholm + DVR90 height',''),
(3697,'Coordinate Reference System',6924,7301,'NAD83(2011) / Kansas LCC (m)',''),
(3698,'Coordinate_Operation',15875,1039,'FJI',''),
(3699,'Coordinate Reference System',3396,7310,'PD/83 / Gauss-Kruger zone 3',''),
(3700,'Coordinate_Operation',6905,1039,'AUA',''),
(3701,'Coordinate Reference System',3463,7301,'Maine Coordinate System of 2000 Central Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 Central zone projection.'),
(3702,'Coordinate Reference System',3463,7301,'NAD83 / Maine CS2000 Central (m)',''),
(3703,'Coordinate Reference System',3464,7301,'Maine Coordinate System of 2000 Central Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 Central zone projection.'),
(3704,'Coordinate Reference System',3464,7301,'NAD83(HARN) / Maine CS2000 Central (m)',''),
(3705,'Coordinate Reference System',3464,7301,'NAD83(HPGN) / Maine CS2000 Central',''),
(3706,'Coordinate_Operation',17517,7301,'Lo17',''),
(3707,'Coordinate_Operation',17519,7301,'Lo19',''),
(3708,'Coordinate_Operation',17521,7301,'Lo21',''),
(3709,'Coordinate_Operation',17523,7301,'Lo23',''),
(3710,'Coordinate_Operation',17525,7301,'Lo25',''),
(3711,'Coordinate_Operation',17527,7301,'Lo27',''),
(3712,'Coordinate_Operation',17529,7301,'Lo29',''),
(3713,'Coordinate_Operation',17531,7301,'Lo31',''),
(3714,'Coordinate_Operation',17533,7301,'Lo33',''),
(3715,'Coordinate_Operation',17611,7301,'Lo22/11',''),
(3716,'Coordinate_Operation',17613,7301,'Lo22/13',''),
(3717,'Coordinate_Operation',17615,7301,'Lo22/15',''),
(3718,'Coordinate_Operation',17617,7301,'Lo22/17',''),
(3719,'Coordinate_Operation',17619,7301,'Lo22/19',''),
(3720,'Coordinate_Operation',17621,7301,'Lo22/21',''),
(3721,'Coordinate_Operation',17623,7301,'Lo22/23',''),
(3722,'Coordinate_Operation',17625,7301,'Lo22/25',''),
(3723,'Coordinate_Operation',17515,7301,'Lo15',''),
(3724,'Coordinate Reference System',22275,7301,'South African Coordinate System zone 15',''),
(3725,'Coordinate Reference System',22277,7301,'South African Coordinate System zone 17',''),
(3726,'Coordinate Reference System',22279,7301,'South African Coordinate System zone 19',''),
(3727,'Coordinate Reference System',22281,7301,'South African Coordinate System zone 21',''),
(3728,'Coordinate Reference System',22283,7301,'South African Coordinate System zone 23',''),
(3729,'Coordinate Reference System',22285,7301,'South African Coordinate System zone 25',''),
(3730,'Coordinate Reference System',22287,7301,'South African Coordinate System zone 27',''),
(3731,'Coordinate Reference System',22289,7301,'South African Coordinate System zone 29',''),
(3732,'Coordinate Reference System',22291,7301,'South African Coordinate System zone 31',''),
(3733,'Coordinate Reference System',22293,7301,'South African Coordinate System zone 33',''),
(3734,'Coordinate Reference System',29371,7301,'South West African Coord. System zone 11',''),
(3735,'Coordinate Reference System',29373,7301,'South West African Coord. System zone 13',''),
(3736,'Coordinate Reference System',29375,7301,'South West African Coord. System zone 15',''),
(3737,'Coordinate Reference System',29377,7301,'South West African Coord. System zone 17',''),
(3738,'Coordinate Reference System',29379,7301,'South West African Coord. System zone 19',''),
(3739,'Coordinate Reference System',29381,7301,'South West African Coord. System zone 21',''),
(3740,'Coordinate Reference System',29383,7301,'South West African Coord. System zone 23',''),
(3741,'Coordinate Reference System',29385,7301,'South West African Coord. System zone 25',''),
(3742,'Coordinate_Operation',19857,7302,'NWT Lambert',''),
(3743,'Coordinate_Operation Method',9807,7301,'Gauss-Boaga',''),
(3744,'Coordinate_Operation',6896,1039,'ACC',''),
(3745,'Coordinate_Operation',13433,7302,'Ohio CS83 North zone (ftUS)',''),
(3746,'Coordinate_Operation',13434,7301,'Ohio CS83 South zone (ftUS)',''),
(3747,'Coordinate_Operation',14935,7301,'Wyoming CS83 East zone (ftUS)',''),
(3748,'Coordinate_Operation',14936,7301,'Wyoming CS83 East Central zone (ftUS)',''),
(3749,'Coordinate_Operation',14937,7301,'Wyoming CS83 West Central zone (ftUS)',''),
(3750,'Coordinate_Operation',14938,7301,'Wyoming CS83 West zone (ftUS)',''),
(3751,'Coordinate Reference System',3465,7301,'NAD83(NSRS2007) / Alabama East (m)',''),
(3752,'Coordinate Reference System',3466,7301,'NAD83(NSRS2007) / Alabama West (m)',''),
(3753,'Coordinate Reference System',3468,7301,'NAD83(NSRS2007) / Alaska zone 1 (m)',''),
(3754,'Coordinate Reference System',3477,7301,'NAD83(NSRS2007) / Alaska zone 10 (m)',''),
(3755,'Coordinate Reference System',3469,7301,'NAD83(NSRS2007) / Alaska zone 2 (m)',''),
(3756,'Coordinate Reference System',3470,7301,'NAD83(NSRS2007) / Alaska zone 3 (m)',''),
(3757,'Coordinate Reference System',3471,7301,'NAD83(NSRS2007) / Alaska zone 4 (m)',''),
(3758,'Coordinate Reference System',3472,7301,'NAD83(NSRS2007) / Alaska zone 5 (m)',''),
(3759,'Coordinate Reference System',3473,7301,'NAD83(NSRS2007) / Alaska zone 6 (m)',''),
(3760,'Coordinate Reference System',3474,7301,'NAD83(NSRS2007) / Alaska zone 7 (m)',''),
(3761,'Coordinate Reference System',3475,7301,'NAD83(NSRS2007) / Alaska zone 8 (m)',''),
(3762,'Coordinate Reference System',3476,7301,'NAD83(NSRS2007) / Alaska zone 9 (m)',''),
(3763,'Coordinate Reference System',3478,7301,'NAD83(NSRS2007) / Arizona Central (m)',''),
(3764,'Coordinate Reference System',3480,7301,'NAD83(NSRS2007) / Arizona East (m)',''),
(3765,'Coordinate Reference System',3482,7301,'NAD83(NSRS2007) / Arizona West (m)',''),
(3766,'Coordinate Reference System',3484,7301,'NAD83(NSRS2007) / Arkansas North (m)',''),
(3767,'Coordinate Reference System',3486,7301,'NAD83(NSRS2007) / Arkansas South (m)',''),
(3768,'Coordinate Reference System',3489,7301,'NAD83(NSRS2007) / California zone 1 (m)',''),
(3769,'Coordinate Reference System',3491,7301,'NAD83(NSRS2007) / California zone 2 (m)',''),
(3770,'Coordinate Reference System',3493,7301,'NAD83(NSRS2007) / California zone 3 (m)',''),
(3771,'Coordinate Reference System',3495,7301,'NAD83(NSRS2007) / California zone 4 (m)',''),
(3772,'Coordinate Reference System',3497,7301,'NAD83(NSRS2007) / California zone 5 (m)',''),
(3773,'Coordinate Reference System',3499,7301,'NAD83(NSRS2007) / California zone 6 (m)',''),
(3774,'Coordinate Reference System',3501,7301,'NAD83(NSRS2007) / Colorado Central (m)',''),
(3775,'Coordinate Reference System',3503,7301,'NAD83(NSRS2007) / Colorado North (m)',''),
(3776,'Coordinate Reference System',3505,7301,'NAD83(NSRS2007) / Colorado South (m)',''),
(3777,'Coordinate Reference System',3507,7301,'NAD83(NSRS2007) / Connecticut (m)',''),
(3778,'Coordinate Reference System',3509,7301,'NAD83(NSRS2007) / Delaware (m)',''),
(3779,'Coordinate Reference System',3511,7301,'NAD83(NSRS2007) / Florida East (m)',''),
(3780,'Coordinate Reference System',3514,7301,'NAD83(NSRS2007) / Florida North (m)',''),
(3781,'Coordinate Reference System',3516,7301,'NAD83(NSRS2007) / Florida West (m)',''),
(3782,'Coordinate Reference System',3518,7301,'NAD83(NSRS2007) / Georgia East (m)',''),
(3783,'Coordinate Reference System',3520,7301,'NAD83(NSRS2007) / Georgia West (m)',''),
(3784,'Coordinate Reference System',3522,7301,'NAD83(NSRS2007) / Idaho Central (m)',''),
(3785,'Coordinate Reference System',3524,7301,'NAD83(NSRS2007) / Idaho East (m)',''),
(3786,'Coordinate Reference System',3526,7301,'NAD83(NSRS2007) / Idaho West (m)',''),
(3787,'Coordinate Reference System',3528,7301,'NAD83(NSRS2007) / Illinois East (m)',''),
(3788,'Coordinate Reference System',3530,7301,'NAD83(NSRS2007) / Illinois West (m)',''),
(3789,'Coordinate Reference System',3532,7301,'NAD83(NSRS2007) / Indiana East (m)',''),
(3790,'Coordinate Reference System',3534,7301,'NAD83(NSRS2007) / Indiana West (m)',''),
(3791,'Coordinate Reference System',3536,7301,'NAD83(NSRS2007) / Iowa North (m)',''),
(3792,'Coordinate Reference System',3538,7301,'NAD83(NSRS2007) / Iowa South (m)',''),
(3793,'Coordinate Reference System',3540,7301,'NAD83(NSRS2007) / Kansas North (m)',''),
(3794,'Coordinate Reference System',3542,7301,'NAD83(NSRS2007) / Kansas South (m)',''),
(3795,'Coordinate Reference System',3544,7301,'NAD83(NSRS2007) / Kentucky North (m)',''),
(3796,'Coordinate Reference System',3546,7301,'NAD83(NSRS2007) / Kentucky Single Zone (m)',''),
(3797,'Coordinate Reference System',3548,7301,'NAD83(NSRS2007) / Kentucky South (m)',''),
(3798,'Coordinate Reference System',3550,7301,'NAD83(NSRS2007) / Louisiana North (m)',''),
(3799,'Coordinate Reference System',3552,7301,'NAD83(NSRS2007) / Louisiana South (m)',''),
(3800,'Coordinate Reference System',3554,7301,'NAD83(NSRS2007) / Maine CS2000 Central (m)',''),
(3801,'Coordinate Reference System',3555,7301,'NAD83(NSRS2007) / Maine CS2000 East (m)',''),
(3802,'Coordinate Reference System',3556,7301,'NAD83(NSRS2007) / Maine CS2000 West (m)',''),
(3803,'Coordinate Reference System',3557,7301,'NAD83(NSRS2007) / Maine CS83 East (m)',''),
(3804,'Coordinate Reference System',3558,7301,'NAD83(NSRS2007) / Maine West (m)',''),
(3805,'Coordinate Reference System',3559,7301,'NAD83(NSRS2007) / Maryland (m)',''),
(3806,'Coordinate Reference System',3583,7301,'NAD83(NSRS2007) / Massachusetts Island (m)',''),
(3807,'Coordinate Reference System',3585,7301,'NAD83(NSRS2007) / Massachusetts Mainland (m)',''),
(3808,'Coordinate Reference System',3587,7301,'NAD83(NSRS2007) / Michigan Central (m)',''),
(3809,'Coordinate Reference System',3589,7301,'NAD83(NSRS2007) / Michigan North (m)',''),
(3810,'Coordinate Reference System',3592,7301,'NAD83(NSRS2007) / Michigan South (m)',''),
(3811,'Coordinate Reference System',3594,7301,'NAD83(NSRS2007) / Minnesota Central (m)',''),
(3812,'Coordinate Reference System',3595,7301,'NAD83(NSRS2007) / Minnesota North (m)',''),
(3813,'Coordinate Reference System',3596,7301,'NAD83(NSRS2007) / Minnesota South (m)',''),
(3814,'Coordinate Reference System',3597,7301,'NAD83(NSRS2007) / Mississippi East (m)',''),
(3815,'Coordinate Reference System',3599,7301,'NAD83(NSRS2007) / Mississippi West (m)',''),
(3816,'Coordinate Reference System',3601,7301,'NAD83(NSRS2007) / Missouri Central (m)',''),
(3817,'Coordinate Reference System',3602,7301,'NAD83(NSRS2007) / Missouri East (m)',''),
(3818,'Coordinate Reference System',3603,7301,'NAD83(NSRS2007) / Missouri West (m)',''),
(3819,'Coordinate Reference System',3604,7301,'NAD83(NSRS2007) / Montana (m)',''),
(3820,'Coordinate Reference System',3606,7301,'NAD83(NSRS2007) / Nebraska (m)',''),
(3821,'Coordinate Reference System',3607,7301,'NAD83(NSRS2007) / Nevada Central (m)',''),
(3822,'Coordinate Reference System',3609,7301,'NAD83(NSRS2007) / Nevada East (m)',''),
(3823,'Coordinate Reference System',3611,7301,'NAD83(NSRS2007) / Nevada West (m)',''),
(3824,'Coordinate Reference System',3613,7301,'NAD83(NSRS2007) / New Hampshire (m)',''),
(3825,'Coordinate Reference System',3615,7301,'NAD83(NSRS2007) / New Jersey (m)',''),
(3826,'Coordinate Reference System',3617,7301,'NAD83(NSRS2007) / New Mexico Central (m)',''),
(3827,'Coordinate Reference System',3619,7301,'NAD83(NSRS2007) / New Mexico East (m)',''),
(3828,'Coordinate Reference System',3621,7301,'NAD83(NSRS2007) / New Mexico West (m)',''),
(3829,'Coordinate Reference System',3623,7301,'NAD83(NSRS2007) / New York Central (m)',''),
(3830,'Coordinate Reference System',3625,7301,'NAD83(NSRS2007) / New York East (m)',''),
(3831,'Coordinate Reference System',3627,7301,'NAD83(NSRS2007) / New York Long Island (m)',''),
(3832,'Coordinate Reference System',3629,7301,'NAD83(NSRS2007) / New York West (m)',''),
(3833,'Coordinate Reference System',3631,7301,'NAD83(NSRS2007) / North Carolina (m)',''),
(3834,'Coordinate Reference System',3633,7301,'NAD83(NSRS2007) / North Dakota North (m)',''),
(3835,'Coordinate Reference System',3635,7301,'NAD83(NSRS2007) / North Dakota South (m)',''),
(3836,'Coordinate Reference System',3637,7301,'NAD83(NSRS2007) / Ohio North (m)',''),
(3837,'Coordinate Reference System',3638,7301,'NAD83(NSRS2007) / Ohio South (m)',''),
(3838,'Coordinate Reference System',3639,7301,'NAD83(NSRS2007) / Oklahoma North (m)',''),
(3839,'Coordinate Reference System',3641,7301,'NAD83(NSRS2007) / Oklahoma South (m)',''),
(3840,'Coordinate Reference System',3643,7301,'NAD83(2007) / Oregon LCC (m)',''),
(3841,'Coordinate Reference System',3645,7301,'NAD83(NSRS2007) / Oregon North (m)',''),
(3842,'Coordinate Reference System',3647,7301,'NAD83(NSRS2007) / Oregon South (m)',''),
(3843,'Coordinate Reference System',3649,7301,'NAD83(NSRS2007) / Pennsylvania North (m)',''),
(3844,'Coordinate Reference System',3651,7301,'NAD83(NSRS2007) / Pennsylvania South (m)',''),
(3845,'Coordinate Reference System',3653,7301,'NAD83(NSRS2007) / Rhode Island (m)',''),
(3846,'Coordinate Reference System',3655,7301,'NAD83(NSRS2007) / South Carolina (m)',''),
(3847,'Coordinate Reference System',3657,7301,'NAD83(NSRS2007) / South Dakota North (m)',''),
(3848,'Coordinate Reference System',3659,7301,'NAD83(NSRS2007) / South Dakota South (m)',''),
(3849,'Coordinate Reference System',3661,7301,'NAD83(NSRS2007) / Tennessee (m)',''),
(3850,'Coordinate Reference System',3663,7301,'NAD83(NSRS2007) / Texas Central (m)',''),
(3851,'Coordinate Reference System',3667,7301,'NAD83(NSRS2007) / Texas North (m)',''),
(3852,'Coordinate Reference System',3669,7301,'NAD83(NSRS2007) / Texas North Central (m)',''),
(3853,'Coordinate Reference System',3671,7301,'NAD83(NSRS2007) / Texas South (m)',''),
(3854,'Coordinate Reference System',3673,7301,'NAD83(NSRS2007) / Texas South Central (m)',''),
(3855,'Coordinate Reference System',3675,7301,'NAD83(NSRS2007) / Utah Central (m)',''),
(3856,'Coordinate Reference System',3678,7301,'NAD83(NSRS2007) / Utah North (m)',''),
(3857,'Coordinate Reference System',3681,7301,'NAD83(NSRS2007) / Utah South (m)',''),
(3858,'Coordinate Reference System',3684,7301,'NAD83(NSRS2007) / Vermont (m)',''),
(3859,'Coordinate Reference System',3685,7301,'NAD83(NSRS2007) / Virginia North (m)',''),
(3860,'Coordinate Reference System',3687,7301,'NAD83(NSRS2007) / Virginia South (m)',''),
(3861,'Coordinate Reference System',3689,7301,'NAD83(NSRS2007) / Washington North (m)',''),
(3862,'Coordinate Reference System',3691,7301,'NAD83(NSRS2007) / Washington South (m)',''),
(3863,'Coordinate Reference System',3695,7301,'NAD83(NSRS2007) / Wisconsin Central (m)',''),
(3864,'Coordinate Reference System',3697,7301,'NAD83(NSRS2007) / Wisconsin North (m)',''),
(3865,'Coordinate Reference System',3699,7301,'NAD83(NSRS2007) / Wisconsin South (m)',''),
(3866,'Coordinate Reference System',3702,7301,'NAD83(NSRS2007) / Wyoming East (m)',''),
(3867,'Coordinate Reference System',3703,7301,'NAD83(NSRS2007) / Wyoming East Central (m)',''),
(3868,'Coordinate Reference System',3705,7301,'NAD83(NSRS2007) / Wyoming West (m)',''),
(3869,'Coordinate Reference System',3704,7301,'NAD83(NSRS2007) / Wyoming West Central (m)',''),
(3870,'Coordinate Reference System',3693,7301,'NAD83(NSRS2007) / West Virginia North (m)',''),
(3871,'Coordinate Reference System',3694,7301,'NAD83(NSRS2007) / West Virginia South (m)',''),
(3872,'Coordinate Reference System',3727,7301,'Piton des Neiges / TM Reunion',''),
(3873,'Coordinate Reference System',3740,7301,'NAD83(HPGN) / UTM zone 10N',''),
(3874,'Coordinate Reference System',3741,7301,'NAD83(HPGN) / UTM zone 11N',''),
(3875,'Coordinate Reference System',3742,7301,'NAD83(HPGN) / UTM zone 12N',''),
(3876,'Coordinate Reference System',3743,7301,'NAD83(HPGN) / UTM zone 13N',''),
(3877,'Coordinate Reference System',3744,7301,'NAD83(HPGN) / UTM zone 14N',''),
(3878,'Coordinate Reference System',3745,7301,'NAD83(HPGN) / UTM zone 15N',''),
(3879,'Coordinate Reference System',3746,7301,'NAD83(HPGN) / UTM zone 16N',''),
(3880,'Coordinate Reference System',3747,7301,'NAD83(HPGN) / UTM zone 17N',''),
(3881,'Coordinate Reference System',3748,7301,'NAD83(HPGN) / UTM zone 18N',''),
(3882,'Coordinate Reference System',3749,7301,'NAD83(HPGN) / UTM zone 19N',''),
(3883,'Coordinate Reference System',3750,7301,'NAD83(HPGN) / UTM zone 4N',''),
(3884,'Coordinate Reference System',3751,7301,'NAD83(HPGN) / UTM zone 5N',''),
(3885,'Ellipsoid',7025,7301,'WGS 66','Has same parameters as NWL 9D'),
(3886,'Datum',6760,7302,'WGS 66',''),
(3887,'Coordinate Reference System',3760,7301,'NAD83(HPGN) / Hawaii zone 3 (ftUS)',''),
(3888,'Coordinate_Operation',6910,7313,'Aden to WGS 84',''),
(3889,'Coordinate Reference System',3546,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(3890,'Coordinate Reference System',3547,7302,'NAD83(NSRS) / KY1Z (ftUS)',''),
(3891,'Coordinate Reference System',3547,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(3892,'Coordinate_Operation',15950,7302,'Viti Levu Grid to FMG (1)',''),
(3893,'Coordinate_Operation',6910,1039,'ADN',''),
(3894,'Coordinate_Operation',15951,7302,'Vanua Levu Grid to FMG (1)',''),
(3895,'Coordinate_Operation',15948,7301,'DHDN to ETRF89 (8)',''),
(3896,'Coordinate_Operation',15948,7307,'DE_DHDN (BeTA, 2007) to ETRS89',''),
(3897,'Coordinate_Operation',1674,7301,'Pulkovo 1942(83) to ETRF89 (1)',''),
(3898,'Coordinate_Operation',1775,7301,'Pulkovo 1942(83) to ETRF89 (2)',''),
(3899,'Coordinate_Operation',1036,7301,'OSGB 1936 / British National Grid to ETRF89 (1)',''),
(3900,'Coordinate_Operation',1039,7302,'OSTN02',''),
(3901,'Coordinate_Operation',1039,7301,'OSGB 1936 / British National Grid to ETRF89 (2)',''),
(3902,'Coordinate_Operation',1041,7301,'TM75 to ETRF89 (1)',''),
(3903,'Coordinate_Operation',1054,7301,'NTF to ETRF89 (2)',''),
(3904,'Coordinate_Operation',1066,7301,'Amersfoort to ETRF89 (2)',''),
(3905,'Coordinate_Operation',1078,7301,'Luxembourg 1930 to ETRF89 (2)',''),
(3906,'Coordinate_Operation',1098,7301,'IGM95 to ETRF89 (1)',''),
(3907,'Coordinate_Operation',1437,7301,'RT90 to ETRF89 (1)',''),
(3908,'Coordinate_Operation',1591,7301,'RGF93 to ETRF89 (1)',''),
(3909,'Coordinate_Operation',1619,7301,'MGI to ETRF89 (1)',''),
(3910,'Coordinate_Operation',1620,7301,'MGI to ETRF89 (2)',''),
(3911,'Coordinate_Operation',1622,7301,'S-JTSK to ETRF89 (1)',''),
(3912,'Coordinate_Operation',1624,7301,'S-JTSK to ETRF89 (2)',''),
(3913,'Coordinate_Operation',1626,7301,'ED50 to ETRF89 (4)',''),
(3914,'Coordinate_Operation',1628,7301,'ED50 to ETRF89 (5)',''),
(3915,'Coordinate_Operation',1630,7301,'ED50 to ETRF89 (6)',''),
(3916,'Coordinate_Operation',1632,7301,'ED50 to ETRF89 (7)',''),
(3917,'Coordinate_Operation',1634,7301,'ED50 to ETRF89 (8)',''),
(3918,'Coordinate_Operation',1638,7301,'KKJ to ETRF89 (1)',''),
(3919,'Coordinate_Operation',1642,7301,'Luxembourg 1930 to ETRF89 (1)',''),
(3920,'Coordinate_Operation',1644,7301,'Pulkovo 1942(58) to ETRF89 (1)',''),
(3921,'Coordinate_Operation',1646,7301,'CH1903 to ETRF89 (1)',''),
(3922,'Coordinate_Operation',1647,7301,'CH1903+ to ETRF89 (1)',''),
(3923,'Coordinate_Operation',1648,7301,'EST97 to ETRF89 (1)',''),
(3924,'Coordinate_Operation',1650,7301,'ED50 to ETRF89 (10)',''),
(3925,'Coordinate_Operation',1651,7301,'NTF to ETRF89 (1)',''),
(3926,'Coordinate_Operation',1652,7301,'BD72 to ETRF89 (1)',''),
(3927,'Coordinate_Operation',1653,7301,'NGO 1948 to ETRF89 (1)',''),
(3928,'Coordinate_Operation',1655,7301,'Lisbon to ETRF89 (1)',''),
(3929,'Coordinate_Operation',1657,7301,'Datum 73 to ETRF89 (1)',''),
(3930,'Coordinate_Operation',1659,7301,'Monte Mario to ETRF89 (1)',''),
(3931,'Coordinate_Operation',1661,7301,'Monte Mario to ETRF89 (2)',''),
(3932,'Coordinate_Operation',1663,7301,'Monte Mario to ETRF89 (3)',''),
(3933,'Coordinate_Operation',1776,7301,'DHDN to ETRF89 (2)',''),
(3934,'Coordinate_Operation',1778,7301,'DHDN to ETRF89 (3)',''),
(3935,'Coordinate_Operation',1779,7301,'DHDN to ETRF89 (4)',''),
(3936,'Coordinate_Operation',1780,7301,'DHDN to ETRF89 (5)',''),
(3937,'Coordinate_Operation',1783,7301,'ED50 to ETRF89 (9)',''),
(3938,'Coordinate_Operation',1785,7301,'MGI to ETRF89 (3)',''),
(3939,'Coordinate_Operation',1829,7301,'HD72 to ETRF89 (1)',''),
(3940,'Coordinate_Operation',1878,7301,'SWEREF99 to ETRF89 (1)',''),
(3941,'Coordinate_Operation',1953,7301,'TM75 to ETRF89 (2)',''),
(3942,'Coordinate_Operation',1992,7301,'Datum 73 to ETRF89 (3)',''),
(3943,'Coordinate_Operation',1997,7301,'Lisbon to ETRF89 (2)',''),
(3944,'Coordinate_Operation',8654,7301,'ED50 to ETRF89 (2)',''),
(3945,'Coordinate_Operation',10098,7301,'KKJ to ETRF89 (2)',''),
(3946,'Coordinate_Operation',15739,7301,'Amersfoort to ETRF89 (3)',''),
(3947,'Coordinate_Operation',15740,7301,'Amersfoort to ETRF89 (4)',''),
(3948,'Coordinate_Operation',15867,7301,'PD/83 to ETRF89 (1)',''),
(3949,'Coordinate_Operation',15868,7301,'RD/83 to ETRF89 (1)',''),
(3950,'Coordinate_Operation',15895,7301,'ED50 to ETRF89 (11)',''),
(3951,'Coordinate_Operation',15928,7301,'BD72 to ETRF89 (2)',''),
(3952,'Coordinate_Operation',15932,7301,'ED50 to ETRF89 (12)',''),
(3953,'Coordinate_Operation',15941,7301,'NTF to ETRF89 (3)',''),
(3954,'Coordinate_Operation',10001,7301,'ETRF89 to NGF IGN69 (1)',''),
(3955,'Coordinate_Operation',10003,7301,'ETRF89 to IGN78 Corsica (1)',''),
(3956,'Coordinate_Operation',10021,7301,'ETRF89 to Newlyn (1)',''),
(3957,'Coordinate_Operation',10022,7301,'ETRF89 to Belfast height (1)',''),
(3958,'Coordinate_Operation',10023,7301,'ETRF89 to Douglas height (1)',''),
(3959,'Coordinate_Operation',10024,7301,'ETRF89 to Fair Isle height (1)',''),
(3960,'Coordinate_Operation',10025,7301,'ETRF89 to Flannan Isles height (1)',''),
(3961,'Coordinate_Operation',10026,7301,'ETRF89 to Foula height (1)',''),
(3962,'Coordinate_Operation',10027,7301,'ETRF89 to Lerwick height (1)',''),
(3963,'Coordinate_Operation',10028,7301,'ETRF89 to Malin Head height (1)',''),
(3964,'Coordinate_Operation',10029,7301,'ETRF89 to Newlyn (Orkney Isles) height (1)',''),
(3965,'Coordinate_Operation',10030,7301,'ETRF89 to North Rona height (1)',''),
(3966,'Coordinate_Operation',10031,7301,'ETRF89 to St. Kilda height (1)',''),
(3967,'Coordinate_Operation',10032,7301,'ETRF89 to St. Marys height (1)',''),
(3968,'Coordinate_Operation',10033,7301,'ETRF89 to Stornoway height (1)',''),
(3969,'Coordinate_Operation',10034,7301,'ETRF89 to Sule Skerry height (1)',''),
(3970,'Coordinate Reference System',3447,7307,'BE_ETRS89 / LB05',''),
(3971,'Coordinate Reference System',3763,7301,'ETRF89 / Portugal TM06',''),
(3972,'Datum',1034,7301,'SREF98',''),
(3973,'Datum',5207,7308,'HVRS71',''),
(3974,'Coordinate_Operation',15963,7301,'Yacare to SIRGAS 1995 (1)',''),
(3975,'Coordinate_Operation',19851,7308,'Croatia TM',''),
(3976,'Coordinate_Operation',19852,7308,'Croatia LCC',''),
(3977,'Coordinate Reference System',3765,7308,'HTRS96 / TM',''),
(3978,'Coordinate Reference System',3766,7308,'HTRS96 / LCC',''),
(3979,'Coordinate_Operation',15965,1039,'CCD',''),
(3980,'Datum',6762,7302,'BDA2000',''),
(3981,'Coordinate Reference System',3770,7302,'BNG2000',''),
(3982,'Coordinate Reference System',3769,7317,'Bermuda National Grid',''),
(3983,'Coordinate_Operation',17722,7302,'Alberta 3TM ref merid 111',''),
(3984,'Coordinate_Operation',17723,7302,'Alberta 3TM ref merid 114',''),
(3985,'Coordinate_Operation',17724,7302,'Alberta 3TM ref merid 117',''),
(3986,'Coordinate_Operation',17725,7302,'Alberta 3TM ref merid 120',''),
(3987,'Coordinate_Operation',14733,7302,'West Virginia North (ftUS)',''),
(3988,'Coordinate_Operation',14734,7302,'West Virginia South (ftUS)',''),
(3989,'Coordinate_Operation',12234,7302,'Minnesota North (ftUS)',''),
(3990,'Coordinate_Operation',12235,7302,'Minnesota Central (ftUS)',''),
(3991,'Coordinate_Operation',12236,7302,'Minnesota South (ftUS)',''),
(3992,'Coordinate_Operation',15396,7302,'Nebraska (ftUS)',''),
(3993,'Coordinate_Operation',6904,1039,'ARS-C','See main remarks. Code perhaps should be ARF-x.'),
(3994,'Coordinate_Operation',11853,7302,'Maine CS2000 West (m)',''),
(3995,'Coordinate_Operation',11854,7302,'Maine CS2000 Central (m)',''),
(3996,'Coordinate_Operation',6907,1039,'PHA',''),
(3997,'Coordinate_Operation',6911,1039,'BVD',''),
(3998,'Coordinate_Operation',6908,7313,'Oman to WGS 84',''),
(3999,'Coordinate_Operation',11833,7302,'Maine CS83 East (ftUS)',''),
(4000,'Coordinate_Operation',11834,7302,'Maine CS83 West (ftUS)',''),
(4001,'Coordinate_Operation',15373,7302,'Indiana West (ftUS)',''),
(4002,'Coordinate_Operation',15375,7302,'Kentucky 1Z (ftUS)',''),
(4003,'Coordinate Reference System',26825,7301,'NAD83(HPGN) / Maine CS83 East (ftUS)',''),
(4004,'Coordinate Reference System',26826,7301,'NAD83(HPGN) / Maine CS83 West (ftUS)',''),
(4005,'Coordinate_Operation',6908,1039,'FAH',''),
(4006,'Coordinate_Operation',6913,1039,'GAI',''),
(4007,'Coordinate_Operation',6909,1039,'HJO',''),
(4008,'Coordinate Reference System',26830,7301,'NAD83(HPGN) / Minnesota North (ftUS)',''),
(4009,'Coordinate Reference System',26831,7301,'NAD83(HPGN) / Minnesota Central (ftUS)',''),
(4010,'Coordinate Reference System',26832,7301,'NAD83(HPGN) / Minnesota South (ftUS)',''),
(4011,'Coordinate Reference System',26833,7301,'NAD83(HPGN) / Nebraska (ftUS)',''),
(4012,'Coordinate Reference System',26834,7301,'NAD83(HPGN) / West Virginia North (ftUS)',''),
(4013,'Coordinate Reference System',26835,7301,'NAD83(HPGN) / West Virginia South (ftUS)',''),
(4014,'Coordinate Reference System',26826,7301,'NAD83(HARN) / Maine CS83 West (ftUS)',''),
(4015,'Coordinate Reference System',26825,7301,'NAD83(HARN) / Maine CS83 East (ftUS)',''),
(4016,'Coordinate Reference System',26815,7301,'NAD83 / Maine CS83 West (ftUS)',''),
(4017,'Coordinate Reference System',26814,7301,'NAD83 / Maine CS83 East (ftUS)',''),
(4018,'Coordinate Reference System',3554,7301,'Maine Coordinate System of 2000 Central Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 Central zone projection.'),
(4019,'Coordinate Reference System',3555,7301,'Maine Coordinate System of 2000 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 East zone projection.'),
(4020,'Coordinate Reference System',3556,7301,'Maine Coordinate System of 2000 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 West zone projection.'),
(4021,'Coordinate Reference System',3557,7301,'Maine Coordinate System of 1983 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 East zone projection.'),
(4022,'Coordinate Reference System',3558,7301,'Maine Coordinate System of 1983 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 West zone projection.'),
(4023,'Coordinate Reference System',26837,7301,'NAD83(NSRS2007) / Maine CS83 West (ftUS)',''),
(4024,'Coordinate Reference System',26836,7301,'NAD83(NSRS2007) / Maine CS83 East (ftUS)',''),
(4025,'Coordinate_Operation',10502,7302,'Colorado Central','This alias is ambiguous as also used for SPCS83 projection.'),
(4026,'Coordinate Reference System',5612,7301,'Baltic 1977 depth',''),
(4027,'Coordinate Reference System',5612,7302,'BHS77 depth',''),
(4028,'Coordinate Reference System',5612,7301,'Kronstadt depth',''),
(4029,'Coordinate_Operation',5452,7301,'Belfast Lough height to Malin Head height',''),
(4030,'Coordinate_Operation',5450,7301,'Construction Datum height to PWD height (1)',''),
(4031,'Coordinate_Operation',5425,7301,'Normaal Amsterdams Peil height to EVRF2000 height (1)',''),
(4032,'Coordinate Reference System',4274,7302,'D73',''),
(4033,'Coordinate Reference System',4803,7302,'DLx',''),
(4034,'Coordinate Reference System',3771,7301,'NAD27 / Alberta 3TM ref merid 111',''),
(4035,'Coordinate Reference System',3772,7301,'NAD27 / Alberta 3TM ref merid 114',''),
(4036,'Coordinate Reference System',3773,7301,'NAD27 / Alberta 3TM ref merid 117',''),
(4037,'Coordinate Reference System',3774,7301,'NAD27 / Alberta 3TM ref merid 120',''),
(4038,'Coordinate Reference System',3775,7301,'NAD83 / Alberta 3TM ref merid 111',''),
(4039,'Coordinate Reference System',3776,7301,'NAD83 / Alberta 3TM ref merid 114',''),
(4040,'Coordinate Reference System',3777,7301,'NAD83 / Alberta 3TM ref merid 117',''),
(4041,'Coordinate Reference System',3778,7301,'NAD83 / Alberta 3TM ref merid 120',''),
(4042,'Coordinate Reference System',3779,7301,'NAD83(CSRS) / Alberta 3TM ref merid 111',''),
(4043,'Coordinate Reference System',3780,7301,'NAD83(CSRS) / Alberta 3TM ref merid 114',''),
(4044,'Coordinate Reference System',3781,7301,'NAD83(CSRS) / Alberta 3TM ref merid 117',''),
(4045,'Coordinate Reference System',3782,7301,'NAD83(CSRS) / Alberta 3TM ref merid 120',''),
(4046,'Coordinate_Operation',11851,7302,'Maine CS2000 East (m)',''),
(4047,'Datum',5208,7302,'RH2000',''),
(4048,'Datum',5209,7302,'RH00',''),
(4049,'Coordinate Reference System',3787,7309,'D48 / GK',''),
(4050,'Coordinate_Operation',6900,7313,'Observatario Campos Rodrigues 1907 to WGS 84',''),
(4051,'Coordinate_Operation',6900,1039,'CPR',''),
(4052,'Coordinate_Operation',18101,7302,'CC42',''),
(4053,'Coordinate_Operation',18102,7302,'CC43',''),
(4054,'Coordinate_Operation',18103,7302,'CC44',''),
(4055,'Coordinate_Operation',18104,7302,'CC45',''),
(4056,'Coordinate_Operation',18105,7302,'CC46',''),
(4057,'Coordinate_Operation',18106,7302,'CC47',''),
(4058,'Coordinate_Operation',18107,7302,'CC48',''),
(4059,'Coordinate_Operation',18108,7302,'CC49',''),
(4060,'Coordinate_Operation',18109,7302,'CC50',''),
(4061,'Coordinate_Operation',17965,7302,'CITM2000',''),
(4062,'Coordinate_Operation',17963,7302,'RITM2000',''),
(4063,'Coordinate_Operation',17962,7302,'AITM2000',''),
(4064,'Coordinate_Operation',17961,7302,'CATM2000',''),
(4065,'Coordinate_Operation',17960,7302,'AKTM2000',''),
(4066,'Coordinate_Operation',17931,7302,'EDENTM2000',''),
(4067,'Coordinate_Operation',17932,7302,'PLENTM2000',''),
(4068,'Coordinate_Operation',17933,7302,'POVETM2000',''),
(4069,'Coordinate_Operation',17934,7302,'HAWKTM2000',''),
(4070,'Coordinate_Operation',17935,7302,'TARATM2000',''),
(4071,'Coordinate_Operation',17936,7302,'TUHITM2000',''),
(4072,'Coordinate_Operation',17937,7302,'WANGTM2000',''),
(4073,'Coordinate_Operation',17938,7302,'WAIRTM2000',''),
(4074,'Coordinate_Operation',17939,7302,'WELLTM2000',''),
(4075,'Coordinate_Operation',17940,7302,'COLLTM2000',''),
(4076,'Coordinate_Operation',17941,7302,'NELSTM2000',''),
(4077,'Coordinate_Operation',17942,7302,'KARATM2000',''),
(4078,'Coordinate_Operation',17943,7302,'BULLTM2000',''),
(4079,'Coordinate_Operation',17944,7302,'GREYTM2000',''),
(4080,'Coordinate_Operation',17945,7302,'AMURTM2000',''),
(4081,'Coordinate_Operation',17946,7302,'MARLTM2000',''),
(4082,'Coordinate_Operation',17947,7302,'HOKITM2000',''),
(4083,'Coordinate_Operation',17948,7302,'OKARTM2000',''),
(4084,'Coordinate_Operation',17949,7302,'JACKTM2000',''),
(4085,'Coordinate_Operation',17950,7302,'PLEATM2000',''),
(4086,'Coordinate_Operation',17951,7302,'GAWLTM2000',''),
(4087,'Coordinate_Operation',17952,7302,'TIMATM2000',''),
(4088,'Coordinate_Operation',17953,7302,'LINDTM2000',''),
(4089,'Coordinate_Operation',17954,7302,'NICHTM2000',''),
(4090,'Coordinate_Operation',17955,7302,'YORKTM2000',''),
(4091,'Coordinate_Operation',17956,7302,'OBSETM2000',''),
(4092,'Coordinate_Operation',17957,7302,'TAIETM2000',''),
(4093,'Coordinate_Operation',17958,7302,'BLUFTM2000',''),
(4094,'Coordinate_Operation',17958,7301,'Bluff Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4095,'Coordinate_Operation',6899,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4096,'Coordinate_Operation',17957,7301,'North Taieri Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4097,'Coordinate_Operation',17956,7301,'Observation Point Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4098,'Coordinate_Operation',17955,7301,'Mount York Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4099,'Coordinate_Operation',17954,7301,'Mount Nicholas Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4100,'Coordinate_Operation',17953,7301,'Lindis Peak Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4101,'Coordinate_Operation',17952,7301,'Timaru Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4102,'Coordinate_Operation',17951,7301,'Gawler Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4103,'Coordinate_Operation',17950,7301,'Mount Pleasant Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4104,'Coordinate_Operation',17949,7301,'Jacksons Bay Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4105,'Coordinate_Operation',17948,7301,'Okarito Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4106,'Coordinate_Operation',17947,7301,'Hokitika Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4107,'Coordinate_Operation',17946,7301,'Marlborough Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4108,'Coordinate_Operation',17945,7301,'Amuri Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4109,'Coordinate_Operation',17944,7301,'Grey Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4110,'Coordinate_Operation',17943,7301,'Buller Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4111,'Coordinate_Operation',17942,7301,'Karamea Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4112,'Coordinate_Operation',17941,7301,'Nelson Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4113,'Coordinate_Operation',17940,7301,'Collingwood Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4114,'Coordinate_Operation',17939,7301,'Wellington Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4115,'Coordinate_Operation',17938,7301,'Wairarapa Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4116,'Coordinate_Operation',17937,7301,'Wanganui Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4117,'Coordinate_Operation',17936,7301,'Turhirangi Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4118,'Coordinate_Operation',17935,7301,'Taranaki Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4119,'Coordinate_Operation',17934,7301,'Hawkes Bay Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4120,'Coordinate_Operation',17933,7301,'Poverty Bay Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4121,'Coordinate_Operation',17932,7301,'Bay of Plenty Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4122,'Coordinate_Operation',17931,7301,'Mount Eden Circuit 2000','This name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4123,'Datum',6764,7302,'RSRGD2000',''),
(4124,'Coordinate Reference System',3788,7302,'NZGD2000 / AKTM2000',''),
(4125,'Coordinate Reference System',3789,7302,'NZGD2000 / CATM2000',''),
(4126,'Coordinate Reference System',3790,7302,'NZGD2000 / AITM2000',''),
(4127,'Coordinate Reference System',3791,7302,'NZGD2000 / RITM2000',''),
(4128,'Coordinate_Operation',6899,1039,'SPK-H',''),
(4129,'Coordinate Reference System',3793,7302,'NZGD2000 / CITM2000',''),
(4130,'Coordinate Reference System',4673,7302,'CI1979',''),
(4131,'Coordinate Reference System',4672,7302,'CI1971',''),
(4132,'Coordinate Reference System',2193,7301,'NZGD2000 / New Zealand Transverse Mercator',''),
(4133,'Coordinate Reference System',2105,7301,'NZGD2000 / Mount Eden Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4134,'Coordinate Reference System',2106,7301,'NZGD2000 / Bay of Plenty Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4135,'Coordinate Reference System',2107,7301,'NZGD2000 / Poverty Bay Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4136,'Coordinate Reference System',2108,7301,'NZGD2000 / Hawkes Bay Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4137,'Coordinate Reference System',2109,7301,'NZGD2000 / Taranaki Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4138,'Coordinate Reference System',2110,7301,'NZGD2000 / Turhirangi Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4139,'Coordinate Reference System',2111,7301,'NZGD2000 / Wanganui Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4140,'Coordinate Reference System',2112,7301,'NZGD2000 / Wairarapa Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4141,'Coordinate Reference System',2113,7301,'NZGD2000 / Wellington Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4142,'Coordinate Reference System',2114,7301,'NZGD2000 / Collingwood Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4143,'Coordinate Reference System',2115,7301,'NZGD2000 / Nelson Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4144,'Coordinate Reference System',2116,7301,'NZGD2000 / Karamea Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4145,'Coordinate Reference System',2117,7301,'NZGD2000 / Buller Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4146,'Coordinate Reference System',2118,7301,'NZGD2000 / Grey Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4147,'Coordinate Reference System',2119,7301,'NZGD2000 / Amuri Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4148,'Coordinate Reference System',2120,7301,'NZGD2000 / Marlborough Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4149,'Coordinate Reference System',2121,7301,'NZGD2000 / Hokitika Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4150,'Coordinate Reference System',2122,7301,'NZGD2000 / Okarito Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4151,'Coordinate Reference System',2123,7301,'NZGD2000 / Jacksons Bay Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4152,'Coordinate Reference System',2124,7301,'NZGD2000 / Mount Pleasant Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4153,'Coordinate Reference System',2125,7301,'NZGD2000 / Gawler Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4154,'Coordinate Reference System',2126,7301,'NZGD2000 / Timaru Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4155,'Coordinate Reference System',2127,7301,'NZGD2000 / Lindis Peak Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4156,'Coordinate Reference System',2128,7301,'NZGD2000 / Mount Nicholas Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4157,'Coordinate Reference System',2129,7301,'NZGD2000 / Mount York Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4158,'Coordinate Reference System',2130,7301,'NZGD2000 / Observation Point Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4159,'Coordinate Reference System',2131,7301,'NZGD2000 / North Taieri Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4160,'Coordinate Reference System',2132,7301,'NZGD2000 / Bluff Circuit 2000','The projection name was assigned in OSG Technical Report 8, April 1999 and amended in LINZS25001, November 2007.'),
(4161,'Coordinate Reference System',2105,7302,'NZGD2000 / EDENTM2000',''),
(4162,'Coordinate Reference System',2106,7302,'NZGD2000 / PLENTM2000',''),
(4163,'Coordinate Reference System',2107,7302,'NZGD2000 / POVETM2000',''),
(4164,'Coordinate Reference System',2108,7302,'NZGD2000 / HAWKTM2000',''),
(4165,'Coordinate Reference System',2109,7302,'NZGD2000 / TARATM2000',''),
(4166,'Coordinate Reference System',2110,7302,'NZGD2000 / TUHITM2000',''),
(4167,'Coordinate Reference System',2111,7302,'NZGD2000 / WANGTM2000',''),
(4168,'Coordinate Reference System',2112,7302,'NZGD2000 / WAIRTM2000',''),
(4169,'Coordinate Reference System',2113,7302,'NZGD2000 / WELLTM2000',''),
(4170,'Coordinate Reference System',2114,7302,'NZGD2000 / COLLTM2000',''),
(4171,'Coordinate Reference System',2115,7302,'NZGD2000 / NELSTM2000',''),
(4172,'Coordinate Reference System',2116,7302,'NZGD2000 / KARATM2000',''),
(4173,'Coordinate Reference System',2117,7302,'NZGD2000 / BULLTM2000',''),
(4174,'Coordinate Reference System',2118,7301,'NZGD2000 / GREYTM2000',''),
(4175,'Coordinate Reference System',2119,7301,'NZGD2000 / AMURTM2000',''),
(4176,'Coordinate Reference System',2120,7302,'NZGD2000 / MARLTM2000',''),
(4177,'Coordinate Reference System',2121,7302,'NZGD2000 / HOKITM2000',''),
(4178,'Coordinate Reference System',2122,7302,'NZGD2000 / OKARTM2000',''),
(4179,'Coordinate Reference System',2123,7302,'NZGD2000 / JACKTM2000',''),
(4180,'Coordinate Reference System',2124,7302,'NZGD2000 / PLEATM2000',''),
(4181,'Coordinate Reference System',2125,7302,'NZGD2000 / GAWLTM2000',''),
(4182,'Coordinate Reference System',2126,7302,'NZGD2000 / TIMATM2000',''),
(4183,'Coordinate Reference System',2127,7302,'NZGD2000 / LINDTM2000',''),
(4184,'Coordinate Reference System',2128,7302,'NZGD2000 / NICHTM2000',''),
(4185,'Coordinate Reference System',2129,7302,'NZGD2000 / YORKTM2000',''),
(4186,'Coordinate Reference System',2130,7302,'NZGD2000 / OBSETM2000',''),
(4187,'Coordinate Reference System',2131,7302,'NZGD2000 / TAIETM2000',''),
(4188,'Coordinate Reference System',2132,7302,'NZGD2000 / BLUFTM2000',''),
(4189,'Coordinate Reference System',2193,7302,'NZGD2000 / NZTM2000',''),
(4190,'Coordinate_Operation',19971,7301,'New Zealand Transverse Mercator',''),
(4191,'Coordinate_Operation',19971,7302,'NZTM2000',''),
(4192,'Datum',5157,7301,'Auckland',''),
(4193,'Datum',5158,7301,'Bluff',''),
(4194,'Datum',5169,7301,'Chatham Island 1959',''),
(4195,'Datum',5159,7301,'Dunedin',''),
(4196,'Datum',5160,7301,'Gisborne',''),
(4197,'Datum',5161,7301,'Lyttelton',''),
(4198,'Datum',5162,7301,'Moturiki',''),
(4199,'Datum',5163,7301,'Napier',''),
(4200,'Datum',5164,7301,'Nelson',''),
(4201,'Datum',5165,7301,'One Tree Point',''),
(4202,'Datum',5170,7301,'Stewart Island',''),
(4203,'Datum',5167,7301,'Taranaki',''),
(4204,'Datum',5166,7301,'Tararu',''),
(4205,'Datum',5168,7301,'Wellington',''),
(4206,'Coordinate Reference System',5759,7301,'Auckland height',''),
(4207,'Coordinate Reference System',5760,7301,'Bluff height',''),
(4208,'Coordinate Reference System',5761,7301,'Dunedin height',''),
(4209,'Coordinate Reference System',5762,7301,'Gisborne height',''),
(4210,'Coordinate Reference System',5763,7301,'Lyttelton height',''),
(4211,'Coordinate Reference System',5764,7301,'Moturiki height',''),
(4212,'Coordinate Reference System',5765,7301,'Napier height',''),
(4213,'Coordinate Reference System',5766,7301,'Nelson height',''),
(4214,'Coordinate Reference System',5767,7317,'One Tree Point height',''),
(4215,'Coordinate Reference System',5768,7301,'Tararu height',''),
(4216,'Coordinate Reference System',5769,7301,'Taranaki height',''),
(4217,'Coordinate Reference System',5770,7301,'Wellington height',''),
(4218,'Coordinate Reference System',5771,7301,'Chatham Island height',''),
(4219,'Coordinate Reference System',5772,7317,'Stewart Island height',''),
(4220,'Coordinate Reference System',5739,7301,'Hong Kong Chart Datum depth',''),
(4221,'Coordinate Reference System',5788,7302,'PWD height',''),
(4222,'Coordinate Reference System',5740,7301,'Newlyn (Orkney Isles) height',''),
(4223,'Coordinate_Operation',6914,7313,'South East Island to WGS 84',''),
(4224,'Datum',6765,7309,'D96',''),
(4225,'Datum',6765,7302,'Slovenia 1996',''),
(4226,'Coordinate Reference System',4883,7309,'D96',''),
(4227,'Coordinate Reference System',4882,7309,'D96',''),
(4228,'Coordinate Reference System',4765,7309,'D96',''),
(4229,'Coordinate Reference System',3794,7309,'D96 / TM',''),
(4230,'Coordinate_Operation',15976,7301,'D96 to WGS 84 (1)',''),
(4231,'Coordinate_Operation',15977,7301,'Slovenia 1996 to ETRF89 (1)',''),
(4232,'Coordinate_Operation',15977,7309,'D96 to ETRS89',''),
(4233,'Coordinate_Operation',19844,7302,'MTQ Lambert',''),
(4234,'Coordinate_Operation',14735,7302,'West Virginia North (ftUS)',''),
(4235,'Coordinate_Operation',14736,7302,'West Virginia South (ftUS)',''),
(4236,'Coordinate Reference System',26847,7301,'NAD83 / Maine CS83 East (ftUS)',''),
(4237,'Coordinate Reference System',26848,7301,'NAD83 / Maine CS83 West (ftUS)',''),
(4238,'Coordinate Reference System',26855,7301,'NAD83(HPGN) / Maine CS83 East (ftUS)',''),
(4239,'Coordinate Reference System',26855,7301,'NAD83(HARN) / Maine CS83 East (ftUS)',''),
(4240,'Coordinate Reference System',26856,7301,'NAD83(HARN) / Maine CS83 West (ftUS)',''),
(4241,'Coordinate Reference System',26856,7301,'NAD83(HPGN) / Maine CS83 West (ftUS)',''),
(4242,'Coordinate Reference System',26863,7301,'NAD83(NSRS2007) / Maine CS83 East (ftUS)',''),
(4243,'Coordinate Reference System',26864,7301,'NAD83(NSRS2007) / Maine CS83 West (ftUS)',''),
(4244,'Coordinate Reference System',26857,7301,'NAD83(HPGN) / Minnesota North (ftUS)',''),
(4245,'Coordinate Reference System',26858,7301,'NAD83(HPGN) / Minnesota Central (ftUS)',''),
(4246,'Coordinate Reference System',26859,7301,'NAD83(HPGN) / Minnesota South (ftUS)',''),
(4247,'Coordinate Reference System',26860,7301,'NAD83(HPGN) / Nebraska (ftUS)',''),
(4248,'Coordinate Reference System',26861,7301,'NAD83(HPGN) / West Virginia North (ftUS)',''),
(4249,'Coordinate Reference System',26862,7301,'NAD83(HPGN) / West Virginia South (ftUS)',''),
(4250,'Coordinate_Operation',17726,7302,'Alberta 3TM ref merid 120',''),
(4251,'Coordinate Reference System',3800,7301,'NAD27 / Alberta 3TM ref merid 120',''),
(4252,'Coordinate Reference System',3801,7301,'NAD83 / Alberta 3TM ref merid 120',''),
(4253,'Coordinate Reference System',3802,7301,'NAD83(CSRS) / Alberta 3TM ref merid 120',''),
(4254,'Area',2423,7301,'USSR',''),
(4255,'Coordinate_Operation',1267,7301,'S-42 to WGS 84 (17)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4256,'Coordinate_Operation',1281,7301,'CS95 to WGS 84 (1)',''),
(4257,'Coordinate_Operation',1257,7301,'CS95 to PZ-90 (1)',''),
(4258,'Coordinate Reference System',3812,7301,'ETRF89 / Belgian Lambert 2008',''),
(4259,'Coordinate Reference System',3812,7301,'ETRS89 / Lambert 2008',''),
(4260,'Coordinate_Operation',3813,7302,'MSTM',''),
(4261,'Coordinate Reference System',3814,7302,'NAD83 / MSTM',''),
(4262,'Coordinate Reference System',3815,7302,'NAD83(HARN) / MSTM',''),
(4263,'Coordinate Reference System',3815,7301,'NAD83(HPGN) / Mississippi TM',''),
(4264,'Coordinate Reference System',3816,7302,'NAD83(NSRS2007) / MSTM',''),
(4265,'Coordinate_Operation',1452,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (1)',''),
(4266,'Coordinate_Operation',1453,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (2)',''),
(4267,'Coordinate_Operation',1465,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (3)',''),
(4268,'Coordinate_Operation',1535,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (4)',''),
(4269,'Coordinate_Operation',1636,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (5)',''),
(4270,'Coordinate_Operation',1637,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (6)',''),
(4271,'Coordinate_Operation',2181,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (7)',''),
(4272,'Coordinate_Operation',2182,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (8)',''),
(4273,'Coordinate_Operation',2183,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (9)',''),
(4274,'Coordinate_Operation',2184,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (10)',''),
(4275,'Coordinate_Operation',2185,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (11)',''),
(4276,'Coordinate_Operation',2186,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (12)',''),
(4277,'Coordinate_Operation',2187,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (13)',''),
(4278,'Coordinate_Operation',2293,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (14)',''),
(4279,'Coordinate_Operation',2974,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (15)',''),
(4280,'Coordinate_Operation',3792,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (16)',''),
(4281,'Coordinate_Operation',3803,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (17)',''),
(4282,'Coordinate_Operation',3804,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (18)',''),
(4283,'Coordinate_Operation',3805,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (19)',''),
(4284,'Coordinate_Operation',3806,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (20)',''),
(4285,'Coordinate_Operation',3807,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (21)',''),
(4286,'Coordinate_Operation',3808,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (22)',''),
(4287,'Coordinate_Operation',3809,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (23)',''),
(4288,'Coordinate_Operation',3810,7301,'MGI / Slovene National Grid to Slovenia 1996 / Slovene National Grid (24)',''),
(4289,'Datum',1024,7302,'HD1909',''),
(4290,'Coordinate_Operation',1449,7301,'HD72 to ETRF89 (2)',''),
(4291,'Coordinate Reference System',3812,7302,'ETRS89 / LB08',''),
(4292,'Coordinate Reference System',3447,7302,'ETRS89 / LB05',''),
(4293,'Coordinate Reference System',31370,7302,'BD 72 / LB72',''),
(4294,'Coordinate_Operation',19862,7301,'Lambert 2005',''),
(4295,'Coordinate_Operation',3811,7301,'Lambert 2008',''),
(4296,'Datum',1025,7302,'TWD67',''),
(4297,'Datum',1026,7302,'TWD97',''),
(4298,'Coordinate_Operation',3818,7302,'TM2 zone 119',''),
(4299,'Coordinate_Operation',3820,7302,'TM2 zone 121',''),
(4300,'Datum',6236,7301,'Hu Tzu Shan',''),
(4301,'Coordinate Reference System',4236,7301,'Hu Tzu Shan',''),
(4302,'Coordinate_Operation',1152,7301,'Hu Tzu Shan to WGS 84 (1)',''),
(4303,'Coordinate_Operation',3831,7302,'PDC Mercator',''),
(4304,'Coordinate_Operation',15981,7309,'D48 to D96 (1)',''),
(4305,'Coordinate_Operation',15982,7309,'D48 to WGS 84 (9)',''),
(4306,'Coordinate_Operation',15983,7309,'D48 to D96 (2)',''),
(4307,'Coordinate_Operation',15984,7309,'D48 to D96 (3)',''),
(4308,'Coordinate_Operation',15985,7309,'D48 to D96 (4)',''),
(4309,'Coordinate_Operation',15986,7309,'D48 to D96 (5)',''),
(4310,'Coordinate_Operation',15987,7309,'D48 to D96 (6)',''),
(4311,'Coordinate_Operation',15988,7309,'D48 to D96 (7)',''),
(4312,'Coordinate_Operation',15989,7309,'D48 to D96 (8)',''),
(4313,'Coordinate_Operation',15990,7309,'D48 to D96 (9)',''),
(4314,'Coordinate_Operation',15991,7309,'D48 to D96 (10)',''),
(4315,'Coordinate_Operation',15992,7309,'D48 to D96 (11)',''),
(4316,'Coordinate_Operation',15993,7301,'S-42 to ETRS89 (3)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4317,'Coordinate_Operation',15994,7301,'S-42 to ETRS89 (4)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4318,'Coordinate_Operation',15995,7301,'S-42 to WGS 84 (19)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4319,'Coordinate Reference System',4179,7301,'Pulkovo 1942(56)','Adjustment completed in 1956.'),
(4320,'Coordinate Reference System',4178,7301,'Uniform Astro-Geodetic Network (UAGN) 1983',''),
(4321,'Coordinate Reference System',4179,7301,'Pulkovo 1942(57)','Locally densified in participating countries at differing times during 1957 and 1958.'),
(4322,'Coordinate_Operation',6914,1039,'SEI',''),
(4323,'Coordinate Reference System',4178,7301,'S-42','This name is ambiguous as it is also used for several CRSs.'),
(4324,'Coordinate Reference System',4179,7301,'Uniform Astro-Geodetic Network (UAGN) 1956',''),
(4325,'Coordinate Reference System',4179,7307,'42/58',''),
(4326,'Coordinate Reference System',4179,7301,'S-42','This name is ambiguous as it is also used for several CRSs.'),
(4327,'Coordinate Reference System',4284,7301,'S-42','This name is ambiguous as it is also used for several CRSs.'),
(4328,'Coordinate Reference System',4200,7301,'S-95',''),
(4329,'Coordinate Reference System',3333,7301,'S-42 zone 3','This name is ambiguous as it is also used for several CRSs.'),
(4330,'Coordinate Reference System',3334,7301,'S-42 zone 4','This name is ambiguous as it is also used for several CRSs.'),
(4331,'Coordinate Reference System',3334,7316,'S-42 zone 34',''),
(4332,'Coordinate Reference System',3335,7301,'S-42 zone 5','This name is ambiguous as it is also used for several CRSs.'),
(4333,'Coordinate Reference System',3335,7316,'S-42 zone 35',''),
(4334,'Coordinate Reference System',3335,7301,'Pulkovo 1942(58) / 6-degree Gauss-Kruger zone 5',''),
(4335,'Coordinate Reference System',3334,7301,'Pulkovo 1942(58) / 6-degree Gauss-Kruger zone 4',''),
(4336,'Coordinate Reference System',3333,7301,'Pulkovo 1942(58) / 6-degree Gauss-Kruger zone 3',''),
(4337,'Coordinate Reference System',3834,7301,'Pulkovo 1942(83) / 6-degree Gauss-Kruger zone 2',''),
(4338,'Coordinate Reference System',3834,7301,'S-42 zone 2','This name is ambiguous as it is also used for several CRSs.'),
(4339,'Coordinate Reference System',3833,7301,'Pulkovo 1942(58) / 6-degree Gauss-Kruger zone 2',''),
(4340,'Coordinate Reference System',3833,7301,'S-42 zone 2','This name is ambiguous as it is also used for several CRSs.'),
(4341,'Coordinate Reference System',3835,7301,'Pulkovo 1942(83) / 6-degree Gauss-Kruger zone 3',''),
(4342,'Coordinate Reference System',3835,7302,'S-42 zone 3','This name is ambiguous as it is also used for several CRSs.'),
(4343,'Coordinate Reference System',3836,7301,'Pulkovo 1942(83) / 6-degree Gauss-Kruger zone 4',''),
(4344,'Coordinate Reference System',3836,7301,'S-42 zone 4','This name is ambiguous as it is also used for several CRSs.'),
(4345,'Coordinate_Operation',1254,7301,'S-42 to WGS 84 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4346,'Coordinate_Operation',1274,7301,'S-42 to LKS94 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4347,'Coordinate_Operation',1303,7301,'S-42 to WGS 84 (10)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4348,'Coordinate_Operation',1332,7301,'S-42 to EST92 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4349,'Coordinate_Operation',1334,7301,'S-42 to WGS 84 (12)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4350,'Coordinate_Operation',1644,7301,'S-42 to ETRS89 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4351,'Coordinate_Operation',1645,7301,'S-42 to WGS 84 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4352,'Coordinate_Operation',1674,7301,'S-42 to ETRS89 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4353,'Coordinate_Operation',1675,7301,'S-42 to WGS 84 (1)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4354,'Coordinate_Operation',1679,7301,'S-42 to WGS 84 (2)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4355,'Coordinate_Operation',1775,7301,'S-42 to ETRS89 (2)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4356,'Coordinate_Operation',1807,7301,'S-42 to WGS 84 (13)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4357,'Coordinate_Operation',1808,7301,'S-42 to WGS 84 (14)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4358,'Coordinate_Operation',1809,7301,'S-42 to WGS 84 (15)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4359,'Coordinate Reference System',3844,7302,'Stereo 70',''),
(4360,'Coordinate Reference System',3844,7301,'S-42 / Stereo 70','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4361,'Coordinate Reference System',3844,7301,'Dealul Piscului 1970/ Stereo 70',''),
(4362,'Coordinate Reference System',4316,7301,'Dealul Piscului 1933',''),
(4363,'Coordinate Reference System',31600,7301,'Dealul Piscului 1933/ Stereo 33',''),
(4364,'Coordinate Reference System',31600,7316,'Stereo 30',''),
(4365,'Datum',6316,7301,'Dealul Piscului 1933',''),
(4366,'Coordinate_Operation',1995,7301,'Dealul Piscului 1933 to WGS 84 (1)',''),
(4367,'Coordinate_Operation',15496,7301,'S-42 to WGS 84 (18)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4368,'Coordinate_Operation',15996,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4369,'Coordinate_Operation',15997,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4370,'Coordinate_Operation',15998,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4371,'Coordinate_Operation',15999,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4372,'Coordinate_Operation',15497,7313,'S-42 to WGS 84','S-42 is ambiguous as it is used as a name for several CRSs.'),
(4373,'Coordinate_Operation',17339,7301,'RT90 zone 7.5 gon V 0:-15 emulation',''),
(4374,'Coordinate_Operation',17340,7301,'RT90 zone 5 gon V 0:-15 emulation',''),
(4375,'Coordinate_Operation',17341,7301,'RT90 zone 2.5 gon V 0:-15 emulation',''),
(4376,'Coordinate_Operation',17342,7301,'RT90 zone 0 gon 0:-15 emulation',''),
(4377,'Coordinate_Operation',17343,7301,'RT90 zone 2.5 gon O 0:-15 emulation',''),
(4378,'Coordinate_Operation',17344,7301,'RT90 zone 5 gon O 0:-15 emulation',''),
(4379,'Coordinate Reference System',3848,7301,'SWEREF99 / RT90 0 gon 0:-15 emulation',''),
(4380,'Coordinate Reference System',3849,7301,'SWEREF99 / RT90 2.5 gon O 0:-15 emulation',''),
(4381,'Coordinate Reference System',3847,7301,'SWEREF99 / RT90 2.5 gon V 0:-15 emulation',''),
(4382,'Coordinate Reference System',3850,7301,'SWEREF99 / RT90 5 gon O 0:-15 emulation',''),
(4383,'Coordinate Reference System',3846,7301,'SWEREF99 / RT90 5 gon V 0:-15 emulation',''),
(4384,'Coordinate Reference System',3845,7301,'SWEREF99 / RT90 7.5 gon V 0:-15 emulation',''),
(4385,'Coordinate_Operation',19841,7302,'LV03C-G',''),
(4386,'Coordinate Reference System',21782,7302,'LV03C-G',''),
(4387,'Coordinate_Operation',6897,7313,'DCS-3 (Astro 1955) to WGS 84',''),
(4388,'Coordinate_Operation',6897,1039,'DCS',''),
(4389,'Coordinate_Operation',6901,7313,'Tete 1960 to WGS 84',''),
(4390,'Coordinate_Operation',6901,1039,'TEC',''),
(4391,'Coordinate_Operation',6902,7301,'Timbalai 1968 to WGS 84 (6)',''),
(4392,'Coordinate Reference System',21781,7301,'LV03M',''),
(4393,'Coordinate Reference System',2031,7302,'NAD27(CGQ77) / UTM 17N',''),
(4394,'Coordinate Reference System',2032,7302,'NAD27(CGQ77) / UTM 18N',''),
(4395,'Coordinate Reference System',2033,7302,'NAD27(CGQ77) / UTM 19N',''),
(4396,'Coordinate Reference System',2034,7302,'NAD27(CGQ77) / UTM 20N',''),
(4397,'Coordinate Reference System',2035,7302,'NAD27(CGQ77) / UTM 21N',''),
(4398,'Coordinate Reference System',2057,7302,'Rassadiran /Nakhl e Taqi',''),
(4399,'Coordinate Reference System',2058,7302,'ED50(ED77) / UTM 38N',''),
(4400,'Coordinate Reference System',2059,7302,'ED50(ED77) / UTM 39N',''),
(4401,'Coordinate Reference System',2060,7302,'ED50(ED77) / UTM 40N',''),
(4402,'Coordinate Reference System',2061,7302,'ED50(ED77) / UTM 41N',''),
(4403,'Coordinate Reference System',2062,7302,'Madrid (Madrid) / Spain',''),
(4404,'Coordinate Reference System',2063,7302,'Dabola 1981 / UTM 28N',''),
(4405,'Coordinate Reference System',2064,7302,'Dabola 1981 / UTM 29N',''),
(4406,'Coordinate Reference System',2104,7302,'Lake / La Rosa Grid',''),
(4407,'Coordinate Reference System',2136,7302,'Accra / Ghana Nat. Grid',''),
(4408,'Coordinate Reference System',2138,7302,'CGQ77 / Quebec Lambert',''),
(4409,'Coordinate Reference System',2159,7302,'Sierra Leone 24 / Colony',''),
(4410,'Coordinate Reference System',2160,7302,'Sierra Leone 24 / WarOff',''),
(4411,'Coordinate Reference System',2161,7302,'Sierra Leone 68 /UTM 28N',''),
(4412,'Coordinate Reference System',2162,7302,'Sierra Leone 68 /UTM 29N',''),
(4413,'Coordinate Reference System',2163,7302,'US National Atlas EA',''),
(4414,'Coordinate_Operation',6902,7313,'Timbalai 1968 to WGS 84',''),
(4415,'Coordinate Reference System',2189,7302,'Azores Cen. 48 / UTM 26N',''),
(4416,'Coordinate Reference System',2190,7317,'Sao Braz 1940 / UTM 26N',''),
(4417,'Coordinate Reference System',2192,7302,'ED50 / France EuroLamb',''),
(4418,'Coordinate Reference System',2195,7302,'NAD83(HARN) / UTM 2S',''),
(4419,'Coordinate Reference System',2215,7302,'Manoca 1962 / UTM 32N',''),
(4420,'Coordinate Reference System',2216,7302,'Qornoq 1927 / UTM 22N',''),
(4421,'Coordinate Reference System',2217,7302,'Qornoq 1927 / UTM 23N',''),
(4422,'Coordinate Reference System',2218,7302,'Scoresbysund / GRL 5 E',''),
(4423,'Coordinate Reference System',2221,7302,'Scoresbysund / GRL 6 E',''),
(4424,'Coordinate Reference System',2222,7302,'NAD83 / Arizona E (ft)',''),
(4425,'Coordinate Reference System',2223,7302,'NAD83 / Arizona Cen (ft)',''),
(4426,'Coordinate Reference System',2224,7302,'NAD83 / Arizona W (ft)',''),
(4427,'Coordinate Reference System',2225,7302,'NAD83 / CA zone 1 (ftUS)',''),
(4428,'Coordinate Reference System',2226,7302,'NAD83 / CA zone 2 (ftUS)',''),
(4429,'Coordinate Reference System',2227,7302,'NAD83 / CA zone 3 (ftUS)',''),
(4430,'Coordinate Reference System',2228,7302,'NAD83 / CA zone 4 (ftUS)',''),
(4431,'Coordinate Reference System',2229,7302,'NAD83 / CA zone 5 (ftUS)',''),
(4432,'Coordinate Reference System',2230,7302,'NAD83 / CA zone 6 (ftUS)',''),
(4433,'Coordinate Reference System',2231,7302,'NAD83 / CO North (ftUS)',''),
(4434,'Coordinate Reference System',2232,7302,'NAD83 / CO Cen (ftUS)',''),
(4435,'Coordinate Reference System',2233,7302,'NAD83 / CO South (ftUS)',''),
(4436,'Coordinate Reference System',2234,7302,'NAD83 / CT (ftUS)',''),
(4437,'Coordinate Reference System',2236,7302,'NAD83 / FL East (ftUS)',''),
(4438,'Coordinate Reference System',2237,7302,'NAD83 / FL West (ftUS)',''),
(4439,'Coordinate Reference System',2238,7302,'NAD83 / FL North (ftUS)',''),
(4440,'Coordinate Reference System',2239,7302,'NAD83 / Georgia E (ftUS)',''),
(4441,'Coordinate Reference System',2240,7302,'NAD83 / Georgia W (ftUS)',''),
(4442,'Coordinate Reference System',2241,7302,'NAD83 / Idaho E (ftUS)',''),
(4443,'Coordinate Reference System',2242,7302,'NAD83 / Idaho Cen (ftUS)',''),
(4444,'Coordinate Reference System',2243,7302,'NAD83 / Idaho W (ftUS)',''),
(4445,'Coordinate Reference System',2246,7302,'NAD83 / KY North (ftUS)',''),
(4446,'Coordinate Reference System',2247,7302,'NAD83 / KY South (ftUS)',''),
(4447,'Coordinate Reference System',2249,7302,'NAD83 / MA Mainld (ftUS)',''),
(4448,'Coordinate Reference System',2250,7302,'NAD83 / MA Island (ftUS)',''),
(4449,'Coordinate Reference System',2251,7302,'NAD83 / Michigan N (ft)',''),
(4450,'Coordinate Reference System',2252,7302,'NAD83 / Michigan C (ft)',''),
(4451,'Coordinate Reference System',2253,7302,'NAD83 / Michigan S (ft)',''),
(4452,'Coordinate Reference System',2254,7302,'NAD83 / MS East (ftUS)',''),
(4453,'Coordinate Reference System',2255,7302,'NAD83 / MS West (ftUS)',''),
(4454,'Coordinate Reference System',2257,7302,'NAD83 / New Mex E (ftUS)',''),
(4455,'Coordinate Reference System',2258,7302,'NAD83 / New Mex C (ftUS)',''),
(4456,'Coordinate Reference System',2259,7302,'NAD83 / New Mex W (ftUS)',''),
(4457,'Coordinate Reference System',2260,7302,'NAD83 / NY East (ftUS)',''),
(4458,'Coordinate Reference System',2261,7302,'NAD83 / NY C (ftUS)',''),
(4459,'Coordinate Reference System',2262,7302,'NAD83 / NY W (ftUS)',''),
(4460,'Coordinate Reference System',2263,7302,'NAD83 / NY Island (ftUS)',''),
(4461,'Coordinate Reference System',2264,7302,'NAD83 / NCarolina (ftUS)',''),
(4462,'Coordinate Reference System',2265,7302,'NAD83 / N Dakota N (ft)',''),
(4463,'Coordinate Reference System',2266,7302,'NAD83 / N Dakota S (ft)',''),
(4464,'Coordinate Reference System',2267,7302,'NAD83 / OK North (ftUS)',''),
(4465,'Coordinate Reference System',2268,7302,'NAD83 / OK South (ftUS)',''),
(4466,'Coordinate Reference System',2269,7301,'NAD83 / Oregon N (ft)',''),
(4467,'Coordinate Reference System',2270,7302,'NAD83 / Oregon S (ft)',''),
(4468,'Coordinate Reference System',2271,7302,'NAD83 / PA North (ftUS)',''),
(4469,'Coordinate Reference System',2272,7302,'NAD83 / PA South (ftUS)',''),
(4470,'Coordinate Reference System',2273,7302,'NAD83 / S Carolina (ft)',''),
(4471,'Coordinate Reference System',2275,7302,'NAD83 / Texas N (ftUS)',''),
(4472,'Coordinate Reference System',2276,7302,'NAD83 / Texas NC (ftUS)',''),
(4473,'Coordinate Reference System',2277,7302,'NAD83 / Texas C (ftUS)',''),
(4474,'Coordinate Reference System',2278,7302,'NAD83 / Texas SC (ftUS)',''),
(4475,'Coordinate Reference System',2279,7302,'NAD83 / Texas S (ftUS)',''),
(4476,'Coordinate Reference System',2281,7302,'NAD83 / Utah Cen. (ft)',''),
(4477,'Coordinate Reference System',2283,7302,'NAD83 / VA North (ftUS)',''),
(4478,'Coordinate Reference System',2284,7302,'NAD83 / VA South (ftUS)',''),
(4479,'Coordinate Reference System',2285,7302,'NAD83 / WA North (ftUS)',''),
(4480,'Coordinate Reference System',2286,7302,'NAD83 / WA South (ftUS)',''),
(4481,'Coordinate Reference System',2287,7302,'NAD83 / WI North (ftUS)',''),
(4482,'Coordinate Reference System',2288,7302,'NAD83 / WI Cen. (ftUS)',''),
(4483,'Coordinate Reference System',2289,7302,'NAD83 / WI South (ftUS)',''),
(4484,'Coordinate Reference System',2296,7302,'Ammassalik 58 / GRL 7 E',''),
(4485,'Coordinate Reference System',2298,7302,'Qornoq 1927 / GRL 2 east',''),
(4486,'Coordinate Reference System',2299,7302,'Qornoq 1927 / GRL 2 west',''),
(4487,'Coordinate Reference System',2301,7302,'Qornoq 1927 / GRL 3 west',''),
(4488,'Coordinate Reference System',2303,7302,'Qornoq 1927 / GRL 4 west',''),
(4489,'Coordinate Reference System',2304,7302,'Qornoq 1927 / GRL 5 west',''),
(4490,'Coordinate Reference System',2305,7302,'Qornoq 1927 / GRL 6 west',''),
(4491,'Coordinate Reference System',2306,7302,'Qornoq 1927 / GRL 7 west',''),
(4492,'Coordinate Reference System',2307,7302,'Qornoq 1927 / GRL 8 east',''),
(4493,'Coordinate Reference System',2314,7302,'Trinidad 03 Grid (ftCla)',''),
(4494,'Coordinate Reference System',2315,7302,'C Inchauspe / UTM 19S',''),
(4495,'Coordinate Reference System',2316,7302,'C Inchauspe / UTM 20S',''),
(4496,'Coordinate Reference System',2318,7302,'Ain el Abd / Aramco Lamb',''),
(4497,'Coordinate Reference System',2327,7302,'Xian 1980 / G-K zone 13',''),
(4498,'Coordinate Reference System',2328,7302,'Xian 1980 / G-K zone 14',''),
(4499,'Coordinate Reference System',2329,7302,'Xian 1980 / G-K zone 15',''),
(4500,'Coordinate_Operation',6902,1039,'TIN',''),
(4501,'Coordinate Reference System',2330,7302,'Xian 1980 / G-K zone 16',''),
(4502,'Coordinate Reference System',2331,7302,'Xian 1980 / G-K zone 17',''),
(4503,'Coordinate Reference System',2332,7302,'Xian 1980 / G-K zone 18',''),
(4504,'Coordinate_Operation',6895,7301,'Viti Levu 1916 to WGS 84 (2)',''),
(4505,'Coordinate Reference System',2334,7302,'Xian 1980 / G-K zone 20',''),
(4506,'Coordinate Reference System',2335,7302,'Xian 1980 / G-K zone 21',''),
(4507,'Coordinate Reference System',2336,7302,'Xian 1980 / G-K zone 22',''),
(4508,'Coordinate Reference System',2337,7302,'Xian 1980 / G-K zone 23',''),
(4509,'Coordinate Reference System',2338,7302,'Xian 1980 / G-K CM 75E',''),
(4510,'Coordinate Reference System',2339,7302,'Xian 1980 / G-K CM 81E',''),
(4511,'Coordinate Reference System',2340,7302,'Xian 1980 / G-K CM 87E',''),
(4512,'Coordinate Reference System',2341,7302,'Xian 1980 / G-K CM 93E',''),
(4513,'Coordinate Reference System',2342,7302,'Xian 1980 / G-K CM 99E',''),
(4514,'Coordinate Reference System',2343,7302,'Xian 1980 / G-K CM 105E',''),
(4515,'Coordinate Reference System',2344,7302,'Xian 1980 / G-K CM 111E',''),
(4516,'Coordinate Reference System',2345,7302,'Xian 1980 / G-K CM 117E',''),
(4517,'Coordinate Reference System',2346,7302,'Xian 1980 / G-K CM 123E',''),
(4518,'Coordinate Reference System',2347,7302,'Xian 1980 / G-K CM 129E',''),
(4519,'Coordinate Reference System',2348,7302,'Xian 1980 / G-K CM 135E',''),
(4520,'Coordinate Reference System',2349,7302,'Xian 1980 / 3GK zone 25',''),
(4521,'Coordinate Reference System',2350,7302,'Xian 1980 / 3GK zone 26',''),
(4522,'Coordinate Reference System',2351,7302,'Xian 1980 / 3GK zone 27',''),
(4523,'Coordinate Reference System',2352,7302,'Xian 1980 / 3GK zone 28',''),
(4524,'Coordinate Reference System',2353,7302,'Xian 1980 / 3GK zone 29',''),
(4525,'Coordinate Reference System',2354,7302,'Xian 1980 / 3GK zone 30',''),
(4526,'Coordinate Reference System',2355,7302,'Xian 1980 / 3GK zone 31',''),
(4527,'Coordinate Reference System',2356,7302,'Xian 1980 / 3GK zone 32',''),
(4528,'Coordinate Reference System',2357,7302,'Xian 1980 / 3GK zone 33',''),
(4529,'Coordinate Reference System',2358,7302,'Xian 1980 / 3GK zone 34',''),
(4530,'Coordinate Reference System',2359,7302,'Xian 1980 / 3GK zone 35',''),
(4531,'Coordinate Reference System',2360,7302,'Xian 1980 / 3GK zone 36',''),
(4532,'Coordinate Reference System',2361,7302,'Xian 1980 / 3GK zone 37',''),
(4533,'Coordinate Reference System',2362,7302,'Xian 1980 / 3GK zone 38',''),
(4534,'Coordinate Reference System',2363,7302,'Xian 1980 / 3GK zone 39',''),
(4535,'Coordinate_Operation',6895,1039,'MVS',''),
(4536,'Coordinate_Operation',6903,7313,'YOF Astro 1967 to WGS 84',''),
(4537,'Coordinate_Operation',6903,1039,'YOF',''),
(4538,'Coordinate_Operation',6912,1039,'BIO',''),
(4539,'Coordinate_Operation',6898,7301,'Lisbon 1937 to WGS 84 (5)',''),
(4540,'Coordinate Reference System',2364,7302,'Xian 1980 / 3GK zone 40',''),
(4541,'Coordinate Reference System',2365,7302,'Xian 1980 / 3GK zone 41',''),
(4542,'Coordinate Reference System',2366,7302,'Xian 1980 / 3GK zone 42',''),
(4543,'Coordinate Reference System',2367,7302,'Xian 1980 / 3GK zone 43',''),
(4544,'Coordinate Reference System',2368,7302,'Xian 1980 / 3GK zone 44',''),
(4545,'Coordinate Reference System',2369,7302,'Xian 1980 / 3GK zone 45',''),
(4546,'Coordinate Reference System',2370,7302,'Xian 1980 / 3GK CM 75E',''),
(4547,'Coordinate Reference System',2371,7302,'Xian 1980 / 3GK CM 78E',''),
(4548,'Coordinate Reference System',2372,7302,'Xian 1980 / 3GK CM 81E',''),
(4549,'Coordinate Reference System',2373,7302,'Xian 1980 / 3GK CM 84E',''),
(4550,'Coordinate Reference System',2374,7302,'Xian 1980 / 3GK CM 87E',''),
(4551,'Coordinate Reference System',2375,7302,'Xian 1980 / 3GK CM 90E',''),
(4552,'Coordinate Reference System',2376,7302,'Xian 1980 / 3GK CM 93E',''),
(4553,'Coordinate Reference System',2377,7302,'Xian 1980 / 3GK CM 96E',''),
(4554,'Coordinate Reference System',2378,7302,'Xian 1980 / 3GK CM 99E',''),
(4555,'Coordinate Reference System',2379,7302,'Xian 1980 / 3GK CM 102E',''),
(4556,'Coordinate Reference System',2380,7302,'Xian 1980 / 3GK CM 105E',''),
(4557,'Coordinate Reference System',2381,7302,'Xian 1980 / 3GK CM 108E',''),
(4558,'Coordinate Reference System',2382,7302,'Xian 1980 / 3GK CM 111E',''),
(4559,'Coordinate Reference System',2383,7302,'Xian 1980 / 3GK CM 114E',''),
(4560,'Coordinate Reference System',2384,7302,'Xian 1980 / 3GK CM 117E',''),
(4561,'Coordinate Reference System',2385,7302,'Xian 1980 / 3GK CM 120E',''),
(4562,'Coordinate Reference System',2386,7302,'Xian 1980 / 3GK CM 123E',''),
(4563,'Coordinate Reference System',2387,7302,'Xian 1980 / 3GK CM 126E',''),
(4564,'Coordinate Reference System',2388,7302,'Xian 1980 / 3GK CM 129E',''),
(4565,'Coordinate Reference System',2389,7302,'Xian 1980 / 3GK CM 132E',''),
(4566,'Coordinate Reference System',2390,7302,'Xian 1980 / 3GK CM 135E',''),
(4567,'Coordinate Reference System',2397,7302,'Pulkovo 42(83) / 3GK zn3',''),
(4568,'Coordinate Reference System',2398,7302,'Pulkovo 42(83) / 3GK zn4',''),
(4569,'Coordinate Reference System',2399,7302,'Pulkovo 42(83) / 3GK zn5',''),
(4570,'Coordinate Reference System',2401,7302,'Beijing 1954 / 3GK zn 25',''),
(4571,'Coordinate Reference System',2402,7302,'Beijing 1954 / 3GK zn 26',''),
(4572,'Coordinate Reference System',2403,7302,'Beijing 1954 / 3GK zn 27',''),
(4573,'Coordinate Reference System',2404,7302,'Beijing 1954 / 3GK zn 28',''),
(4574,'Coordinate Reference System',2405,7302,'Beijing 1954 / 3GK zn 29',''),
(4575,'Coordinate Reference System',2406,7302,'Beijing 1954 / 3GK zn 30',''),
(4576,'Coordinate Reference System',2407,7302,'Beijing 1954 / 3GK zn 31',''),
(4577,'Coordinate Reference System',2408,7302,'Beijing 1954 / 3GK zn 32',''),
(4578,'Coordinate Reference System',2409,7302,'Beijing 1954 / 3GK zn 33',''),
(4579,'Coordinate Reference System',2410,7302,'Beijing 1954 / 3GK zn 34',''),
(4580,'Coordinate Reference System',2411,7302,'Beijing 1954 / 3GK zn 35',''),
(4581,'Coordinate Reference System',2412,7302,'Beijing 1954 / 3GK zn 36',''),
(4582,'Coordinate Reference System',2413,7302,'Beijing 1954 / 3GK zn 37',''),
(4583,'Coordinate Reference System',2414,7302,'Beijing 1954 / 3GK zn 38',''),
(4584,'Coordinate Reference System',2415,7302,'Beijing 1954 / 3GK zn 39',''),
(4585,'Coordinate Reference System',2416,7302,'Beijing 1954 / 3GK zn 40',''),
(4586,'Coordinate Reference System',2417,7302,'Beijing 1954 / 3GK zn 41',''),
(4587,'Coordinate Reference System',2418,7302,'Beijing 1954 / 3GK zn 42',''),
(4588,'Coordinate Reference System',2419,7302,'Beijing 1954 / 3GK zn 43',''),
(4589,'Coordinate Reference System',2420,7302,'Beijing 1954 / 3GK zn 44',''),
(4590,'Coordinate Reference System',2421,7302,'Beijing 1954 / 3GK zn 45',''),
(4591,'Coordinate Reference System',2422,7302,'Beijing 1954 / 3GK 75E',''),
(4592,'Coordinate Reference System',2423,7302,'Beijing 1954 / 3GK 78E',''),
(4593,'Coordinate Reference System',2424,7302,'Beijing 1954 / 3GK 81E',''),
(4594,'Coordinate Reference System',2425,7302,'Beijing 1954 / 3GK 84E',''),
(4595,'Coordinate Reference System',2426,7302,'Beijing 1954 / 3GK 87E',''),
(4596,'Coordinate Reference System',2427,7302,'Beijing 1954 / 3GK 90E',''),
(4597,'Coordinate Reference System',2428,7302,'Beijing 1954 / 3GK 93E',''),
(4598,'Coordinate Reference System',2429,7302,'Beijing 1954 / 3GK 96E',''),
(4599,'Coordinate Reference System',2430,7302,'Beijing 1954 / 3GK 99E',''),
(4600,'Coordinate Reference System',2431,7302,'Beijing 1954 / 3GK 102E',''),
(4601,'Coordinate Reference System',2432,7302,'Beijing 1954 / 3GK 105E',''),
(4602,'Coordinate Reference System',2433,7302,'Beijing 1954 / 3GK 108E',''),
(4603,'Coordinate Reference System',2434,7302,'Beijing 1954 / 3GK 111E',''),
(4604,'Coordinate Reference System',2435,7302,'Beijing 1954 / 3GK 114E',''),
(4605,'Coordinate Reference System',2436,7302,'Beijing 1954 / 3GK 117E',''),
(4606,'Coordinate Reference System',2437,7302,'Beijing 1954 / 3GK 120E',''),
(4607,'Coordinate Reference System',2438,7302,'Beijing 1954 / 3GK 123E',''),
(4608,'Coordinate Reference System',2439,7302,'Beijing 1954 / 3GK 126E',''),
(4609,'Coordinate Reference System',2440,7302,'Beijing 1954 / 3GK 129E',''),
(4610,'Coordinate Reference System',2441,7302,'Beijing 1954 / 3GK 132E',''),
(4611,'Coordinate Reference System',2442,7302,'Beijing 1954 / 3GK 135E',''),
(4612,'Coordinate Reference System',2443,7302,'JGD2000 / Japan zone 1',''),
(4613,'Coordinate Reference System',2444,7302,'JGD2000 / Japan zone 2',''),
(4614,'Coordinate Reference System',2445,7302,'JGD2000 / Japan zone 3',''),
(4615,'Coordinate Reference System',2446,7302,'JGD2000 / Japan zone 4',''),
(4616,'Coordinate Reference System',2447,7302,'JGD2000 / Japan zone 5',''),
(4617,'Coordinate Reference System',2448,7302,'JGD2000 / Japan zone 6',''),
(4618,'Coordinate Reference System',2449,7302,'JGD2000 / Japan zone 7',''),
(4619,'Coordinate Reference System',2450,7302,'JGD2000 / Japan zone 8',''),
(4620,'Coordinate Reference System',2451,7302,'JGD2000 / Japan zone 9',''),
(4621,'Coordinate Reference System',2452,7302,'JGD2000 / Japan zone 10',''),
(4622,'Coordinate Reference System',2453,7302,'JGD2000 / Japan zone 11',''),
(4623,'Coordinate Reference System',2454,7302,'JGD2000 / Japan zone 12',''),
(4624,'Coordinate Reference System',2455,7302,'JGD2000 / Japan zone 13',''),
(4625,'Coordinate Reference System',2456,7302,'JGD2000 / Japan zone 14',''),
(4626,'Coordinate Reference System',2457,7302,'JGD2000 / Japan zone 15',''),
(4627,'Coordinate Reference System',2458,7302,'JGD2000 / Japan zone 16',''),
(4628,'Coordinate Reference System',2459,7302,'JGD2000 / Japan zone 17',''),
(4629,'Coordinate Reference System',2460,7302,'JGD2000 / Japan zone 18',''),
(4630,'Coordinate Reference System',2461,7302,'JGD2000 / Japan zone 19',''),
(4631,'Coordinate Reference System',2462,7302,'Albanian 1987 / GK zn 4',''),
(4632,'Coordinate Reference System',2463,7302,'Pulkovo 1995 / 6GK 21E',''),
(4633,'Coordinate Reference System',2464,7302,'Pulkovo 1995 / 6GK 27E',''),
(4634,'Coordinate Reference System',2465,7302,'Pulkovo 1995 / 6GK 33E',''),
(4635,'Coordinate Reference System',2466,7302,'Pulkovo 1995 / 6GK 39E',''),
(4636,'Coordinate Reference System',2467,7302,'Pulkovo 1995 / 6GK 45E',''),
(4637,'Coordinate Reference System',2468,7302,'Pulkovo 1995 / 6GK 51E',''),
(4638,'Coordinate Reference System',2469,7302,'Pulkovo 1995 / 6GK 57E',''),
(4639,'Coordinate Reference System',2470,7302,'Pulkovo 1995 / 6GK 63E',''),
(4640,'Coordinate Reference System',2471,7302,'Pulkovo 1995 / 6GK 69E',''),
(4641,'Coordinate Reference System',2472,7302,'Pulkovo 1995 / 6GK 75E',''),
(4642,'Coordinate Reference System',2473,7302,'Pulkovo 1995 / 6GK 81E',''),
(4643,'Coordinate Reference System',2474,7302,'Pulkovo 1995 / 6GK 87E',''),
(4644,'Coordinate Reference System',2475,7302,'Pulkovo 1995 / 6GK 93E',''),
(4645,'Coordinate Reference System',2476,7302,'Pulkovo 1995 / 6GK 99E',''),
(4646,'Coordinate Reference System',2477,7302,'Pulkovo 1995 / 6GK 105E',''),
(4647,'Coordinate Reference System',2478,7302,'Pulkovo 1995 / 6GK 111E',''),
(4648,'Coordinate Reference System',2479,7302,'Pulkovo 1995 / 6GK 117E',''),
(4649,'Coordinate Reference System',2480,7302,'Pulkovo 1995 / 6GK 123E',''),
(4650,'Coordinate Reference System',2481,7302,'Pulkovo 1995 / 6GK 129E',''),
(4651,'Coordinate Reference System',2482,7302,'Pulkovo 1995 / 6GK 135E',''),
(4652,'Coordinate Reference System',2483,7302,'Pulkovo 1995 / 6GK 141E',''),
(4653,'Coordinate Reference System',2484,7302,'Pulkovo 1995 / 6GK 147E',''),
(4654,'Coordinate Reference System',2485,7302,'Pulkovo 1995 / 6GK 153E',''),
(4655,'Coordinate Reference System',2486,7302,'Pulkovo 1995 / 6GK 159E',''),
(4656,'Coordinate Reference System',2487,7302,'Pulkovo 1995 / 6GK 165E',''),
(4657,'Coordinate Reference System',2488,7302,'Pulkovo 1995 / 6GK 171E',''),
(4658,'Coordinate Reference System',2489,7302,'Pulkovo 1995 / 6GK 177E',''),
(4659,'Coordinate Reference System',2490,7302,'Pulkovo 1995 / 6GK 177W',''),
(4660,'Coordinate Reference System',2491,7302,'Pulkovo 1995 / 6GK 171W',''),
(4661,'Coordinate Reference System',2494,7302,'Pulkovo 1942 / 6GK 21E',''),
(4662,'Coordinate Reference System',2495,7302,'Pulkovo 1942 / 6GK 27E',''),
(4663,'Coordinate Reference System',2496,7302,'Pulkovo 1942 / 6GK 33E',''),
(4664,'Coordinate Reference System',2497,7302,'Pulkovo 1942 / 6GK 39E',''),
(4665,'Coordinate Reference System',2498,7302,'Pulkovo 1942 / 6GK 45E',''),
(4666,'Coordinate Reference System',2499,7302,'Pulkovo 1942 / 6GK 51E',''),
(4667,'Coordinate Reference System',2500,7302,'Pulkovo 1942 / 6GK 57E',''),
(4668,'Coordinate Reference System',2501,7302,'Pulkovo 1942 / 6GK 63E',''),
(4669,'Coordinate Reference System',2502,7302,'Pulkovo 1942 / 6GK 69E',''),
(4670,'Coordinate Reference System',2503,7302,'Pulkovo 1942 / 6GK 75E',''),
(4671,'Coordinate Reference System',2504,7302,'Pulkovo 1942 / 6GK 81E',''),
(4672,'Coordinate Reference System',2505,7302,'Pulkovo 1942 / 6GK 87E',''),
(4673,'Coordinate Reference System',2506,7302,'Pulkovo 1942 / 6GK 93E',''),
(4674,'Coordinate Reference System',2507,7302,'Pulkovo 1942 / 6GK 99E',''),
(4675,'Coordinate Reference System',2508,7302,'Pulkovo 1942 / 6GK 105E',''),
(4676,'Coordinate Reference System',2509,7302,'Pulkovo 1942 / 6GK 111E',''),
(4677,'Coordinate Reference System',2510,7302,'Pulkovo 1942 / 6GK 117E',''),
(4678,'Coordinate Reference System',2511,7302,'Pulkovo 1942 / 6GK 123E',''),
(4679,'Coordinate Reference System',2512,7302,'Pulkovo 1942 / 6GK 129E',''),
(4680,'Coordinate Reference System',2513,7302,'Pulkovo 1942 / 6GK 135E',''),
(4681,'Coordinate Reference System',2514,7302,'Pulkovo 1942 / 6GK 141E',''),
(4682,'Coordinate Reference System',2515,7302,'Pulkovo 1942 / 6GK 147E',''),
(4683,'Coordinate Reference System',2516,7302,'Pulkovo 1942 / 6GK 153E',''),
(4684,'Coordinate Reference System',2517,7302,'Pulkovo 1942 / 6GK 159E',''),
(4685,'Coordinate Reference System',2518,7302,'Pulkovo 1942 / 6GK 165E',''),
(4686,'Coordinate Reference System',2519,7302,'Pulkovo 1942 / 6GK 171E',''),
(4687,'Coordinate Reference System',2520,7302,'Pulkovo 1942 / 6GK 177E',''),
(4688,'Coordinate Reference System',2521,7302,'Pulkovo 1942 / 6GK 177W',''),
(4689,'Coordinate Reference System',2522,7302,'Pulkovo 1942 / 6GK 171W',''),
(4690,'Coordinate Reference System',2523,7302,'Pulkovo 1942 / 3GK zn 7',''),
(4691,'Coordinate Reference System',2524,7302,'Pulkovo 1942 / 3GK zn 8',''),
(4692,'Coordinate Reference System',2525,7302,'Pulkovo 1942 / 3GK zn 9',''),
(4693,'Coordinate Reference System',2526,7302,'Pulkovo 1942 / 3GK zn 10',''),
(4694,'Coordinate Reference System',2527,7302,'Pulkovo 1942 / 3GK zn 11',''),
(4695,'Coordinate Reference System',2528,7302,'Pulkovo 1942 / 3GK zn 12',''),
(4696,'Coordinate Reference System',2529,7302,'Pulkovo 1942 / 3GK zn 13',''),
(4697,'Coordinate Reference System',2530,7302,'Pulkovo 1942 / 3GK zn 14',''),
(4698,'Coordinate Reference System',2531,7302,'Pulkovo 1942 / 3GK zn 15',''),
(4699,'Coordinate Reference System',2532,7302,'Pulkovo 1942 / 3GK zn 16',''),
(4700,'Coordinate Reference System',2533,7302,'Pulkovo 1942 / 3GK zn 17',''),
(4701,'Coordinate Reference System',2534,7302,'Pulkovo 1942 / 3GK zn 18',''),
(4702,'Coordinate Reference System',2535,7302,'Pulkovo 1942 / 3GK zn 19',''),
(4703,'Coordinate Reference System',2536,7302,'Pulkovo 1942 / 3GK zn 20',''),
(4704,'Coordinate Reference System',2537,7302,'Pulkovo 1942 / 3GK zn 21',''),
(4705,'Coordinate Reference System',2538,7302,'Pulkovo 1942 / 3GK zn 22',''),
(4706,'Coordinate Reference System',2539,7302,'Pulkovo 1942 / 3GK zn 23',''),
(4707,'Coordinate Reference System',2540,7302,'Pulkovo 1942 / 3GK zn 24',''),
(4708,'Coordinate Reference System',2541,7302,'Pulkovo 1942 / 3GK zn 25',''),
(4709,'Coordinate Reference System',2542,7302,'Pulkovo 1942 / 3GK zn 26',''),
(4710,'Coordinate Reference System',2543,7302,'Pulkovo 1942 / 3GK zn 27',''),
(4711,'Coordinate Reference System',2544,7302,'Pulkovo 1942 / 3GK zn 28',''),
(4712,'Coordinate Reference System',2545,7302,'Pulkovo 1942 / 3GK zn 29',''),
(4713,'Coordinate Reference System',2546,7302,'Pulkovo 1942 / 3GK zn 30',''),
(4714,'Coordinate Reference System',2547,7302,'Pulkovo 1942 / 3GK zn 31',''),
(4715,'Coordinate Reference System',2548,7302,'Pulkovo 1942 / 3GK zn 32',''),
(4716,'Coordinate Reference System',2549,7302,'Pulkovo 1942 / 3GK zn 33',''),
(4717,'Coordinate Reference System',2551,7302,'Pulkovo 1942 / 3GK zn 34',''),
(4718,'Coordinate Reference System',2552,7302,'Pulkovo 1942 / 3GK zn 35',''),
(4719,'Coordinate Reference System',2553,7302,'Pulkovo 1942 / 3GK zn 36',''),
(4720,'Coordinate Reference System',2554,7302,'Pulkovo 1942 / 3GK zn 37',''),
(4721,'Coordinate Reference System',2555,7302,'Pulkovo 1942 / 3GK zn 38',''),
(4722,'Coordinate Reference System',2556,7302,'Pulkovo 1942 / 3GK zn 39',''),
(4723,'Coordinate Reference System',2557,7302,'Pulkovo 1942 / 3GK zn 40',''),
(4724,'Coordinate Reference System',2558,7302,'Pulkovo 1942 / 3GK zn 41',''),
(4725,'Coordinate Reference System',2559,7302,'Pulkovo 1942 / 3GK zn 42',''),
(4726,'Coordinate Reference System',2560,7302,'Pulkovo 1942 / 3GK zn 43',''),
(4727,'Coordinate Reference System',2561,7302,'Pulkovo 1942 / 3GK zn 44',''),
(4728,'Coordinate Reference System',2562,7302,'Pulkovo 1942 / 3GK zn 45',''),
(4729,'Coordinate Reference System',2563,7302,'Pulkovo 1942 / 3GK zn 46',''),
(4730,'Coordinate Reference System',2564,7302,'Pulkovo 1942 / 3GK zn 47',''),
(4731,'Coordinate Reference System',2565,7302,'Pulkovo 1942 / 3GK zn 48',''),
(4732,'Coordinate Reference System',2566,7302,'Pulkovo 1942 / 3GK zn 49',''),
(4733,'Coordinate Reference System',2567,7302,'Pulkovo 1942 / 3GK zn 50',''),
(4734,'Coordinate Reference System',2568,7302,'Pulkovo 1942 / 3GK zn 51',''),
(4735,'Coordinate Reference System',2569,7302,'Pulkovo 1942 / 3GK zn 52',''),
(4736,'Coordinate Reference System',2570,7302,'Pulkovo 1942 / 3GK zn 53',''),
(4737,'Coordinate Reference System',2571,7302,'Pulkovo 1942 / 3GK zn 54',''),
(4738,'Coordinate Reference System',2572,7302,'Pulkovo 1942 / 3GK zn 55',''),
(4739,'Coordinate Reference System',2573,7302,'Pulkovo 1942 / 3GK zn 56',''),
(4740,'Coordinate Reference System',2574,7302,'Pulkovo 1942 / 3GK zn 57',''),
(4741,'Coordinate Reference System',2575,7302,'Pulkovo 1942 / 3GK zn 58',''),
(4742,'Coordinate Reference System',2576,7302,'Pulkovo 1942 / 3GK zn 59',''),
(4743,'Coordinate Reference System',3389,7302,'Pulkovo 1942 / 3GK zn 60',''),
(4744,'Coordinate Reference System',2578,7302,'Pulkovo 1942 / 3GK zn 61',''),
(4745,'Coordinate Reference System',2579,7302,'Pulkovo 1942 / 3GK zn 62',''),
(4746,'Coordinate Reference System',2580,7302,'Pulkovo 1942 / 3GK zn 63',''),
(4747,'Coordinate Reference System',2581,7302,'Pulkovo 1942 / 3GK zn 64',''),
(4748,'Coordinate Reference System',2582,7302,'Pulkovo 1942 / 3GK 21E',''),
(4749,'Coordinate Reference System',2583,7302,'Pulkovo 1942 / 3GK 24E',''),
(4750,'Coordinate Reference System',2584,7302,'Pulkovo 1942 / 3GK 27E',''),
(4751,'Coordinate Reference System',2585,7302,'Pulkovo 1942 / 3GK 30E',''),
(4752,'Coordinate Reference System',2586,7302,'Pulkovo 1942 / 3GK 33E',''),
(4753,'Coordinate Reference System',2587,7302,'Pulkovo 1942 / 3GK 36E',''),
(4754,'Coordinate Reference System',2588,7302,'Pulkovo 1942 / 3GK 39E',''),
(4755,'Coordinate Reference System',2589,7302,'Pulkovo 1942 / 3GK 42E',''),
(4756,'Coordinate Reference System',2590,7302,'Pulkovo 1942 / 3GK 45E',''),
(4757,'Coordinate Reference System',2591,7302,'Pulkovo 1942 / 3GK 48E',''),
(4758,'Coordinate Reference System',2592,7302,'Pulkovo 1942 / 3GK 51E',''),
(4759,'Coordinate Reference System',2593,7302,'Pulkovo 1942 / 3GK 54E',''),
(4760,'Coordinate Reference System',2594,7302,'Pulkovo 1942 / 3GK 57E',''),
(4761,'Coordinate Reference System',2595,7302,'Pulkovo 1942 / 3GK 60E',''),
(4762,'Coordinate Reference System',2596,7302,'Pulkovo 1942 / 3GK 63E',''),
(4763,'Coordinate Reference System',2597,7302,'Pulkovo 1942 / 3GK 66E',''),
(4764,'Coordinate Reference System',2598,7302,'Pulkovo 1942 / 3GK 69E',''),
(4765,'Coordinate Reference System',2599,7302,'Pulkovo 1942 / 3GK 72E',''),
(4766,'Coordinate Reference System',2601,7302,'Pulkovo 1942 / 3GK 75E',''),
(4767,'Coordinate Reference System',2602,7302,'Pulkovo 1942 / 3GK 78E',''),
(4768,'Coordinate Reference System',2603,7302,'Pulkovo 1942 / 3GK 81E',''),
(4769,'Coordinate Reference System',2604,7302,'Pulkovo 1942 / 3GK 84E',''),
(4770,'Coordinate Reference System',2605,7302,'Pulkovo 1942 / 3GK 87E',''),
(4771,'Coordinate Reference System',2606,7302,'Pulkovo 1942 / 3GK 90E',''),
(4772,'Coordinate Reference System',2607,7302,'Pulkovo 1942 / 3GK 93E',''),
(4773,'Coordinate Reference System',2608,7302,'Pulkovo 1942 / 3GK 96E',''),
(4774,'Coordinate Reference System',2609,7302,'Pulkovo 1942 / 3GK 99E',''),
(4775,'Coordinate Reference System',2610,7302,'Pulkovo 1942 / 3GK 102E',''),
(4776,'Coordinate Reference System',2611,7302,'Pulkovo 1942 / 3GK 105E',''),
(4777,'Coordinate Reference System',2612,7302,'Pulkovo 1942 / 3GK 108E',''),
(4778,'Coordinate Reference System',2613,7302,'Pulkovo 1942 / 3GK 111E',''),
(4779,'Coordinate Reference System',2614,7302,'Pulkovo 1942 / 3GK 114E',''),
(4780,'Coordinate Reference System',2615,7302,'Pulkovo 1942 / 3GK 117E',''),
(4781,'Coordinate Reference System',2616,7302,'Pulkovo 1942 / 3GK 120E',''),
(4782,'Coordinate Reference System',2617,7302,'Pulkovo 1942 / 3GK 123E',''),
(4783,'Coordinate Reference System',2618,7302,'Pulkovo 1942 / 3GK 126E',''),
(4784,'Coordinate Reference System',2619,7302,'Pulkovo 1942 / 3GK 129E',''),
(4785,'Coordinate Reference System',2620,7302,'Pulkovo 1942 / 3GK 132E',''),
(4786,'Coordinate Reference System',2621,7302,'Pulkovo 1942 / 3GK 135E',''),
(4787,'Coordinate Reference System',2622,7302,'Pulkovo 1942 / 3GK 138E',''),
(4788,'Coordinate Reference System',2623,7302,'Pulkovo 1942 / 3GK 141E',''),
(4789,'Coordinate Reference System',2624,7302,'Pulkovo 1942 / 3GK 144E',''),
(4790,'Coordinate Reference System',2625,7302,'Pulkovo 1942 / 3GK 147E',''),
(4791,'Coordinate Reference System',2626,7302,'Pulkovo 1942 / 3GK 150E',''),
(4792,'Coordinate Reference System',2627,7302,'Pulkovo 1942 / 3GK 153E',''),
(4793,'Coordinate Reference System',2628,7302,'Pulkovo 1942 / 3GK 156E',''),
(4794,'Coordinate Reference System',2629,7302,'Pulkovo 1942 / 3GK 159E',''),
(4795,'Coordinate Reference System',2630,7302,'Pulkovo 1942 / 3GK 162E',''),
(4796,'Coordinate Reference System',2631,7302,'Pulkovo 1942 / 3GK 165E',''),
(4797,'Coordinate Reference System',2632,7302,'Pulkovo 1942 / 3GK 168E',''),
(4798,'Coordinate Reference System',2633,7302,'Pulkovo 1942 / 3GK 171E',''),
(4799,'Coordinate Reference System',2634,7302,'Pulkovo 1942 / 3GK 174E',''),
(4800,'Coordinate Reference System',2635,7302,'Pulkovo 1942 / 3GK 177E',''),
(4801,'Coordinate Reference System',2636,7302,'Pulkovo 1942 / 3GK 180E',''),
(4802,'Coordinate Reference System',2637,7302,'Pulkovo 1942 / 3GK 177W',''),
(4803,'Coordinate Reference System',2638,7302,'Pulkovo 1942 / 3GK 174W',''),
(4804,'Coordinate Reference System',2639,7302,'Pulkovo 1942 / 3GK 171W',''),
(4805,'Coordinate Reference System',2640,7302,'Pulkovo 1942 / 3GK 168W',''),
(4806,'Coordinate Reference System',2641,7302,'Pulkovo 1995 / 3GK zn 7',''),
(4807,'Coordinate Reference System',2642,7302,'Pulkovo 1995 / 3GK zn 8',''),
(4808,'Coordinate Reference System',2643,7302,'Pulkovo 1995 / 3GK zn 9',''),
(4809,'Coordinate Reference System',2644,7302,'Pulkovo 1995 / 3GK zn 10',''),
(4810,'Coordinate Reference System',2645,7302,'Pulkovo 1995 / 3GK zn 11',''),
(4811,'Coordinate Reference System',2646,7302,'Pulkovo 1995 / 3GK zn 12',''),
(4812,'Coordinate Reference System',2647,7302,'Pulkovo 1995 / 3GK zn 13',''),
(4813,'Coordinate Reference System',2648,7302,'Pulkovo 1995 / 3GK zn 14',''),
(4814,'Coordinate Reference System',2649,7302,'Pulkovo 1995 / 3GK zn 15',''),
(4815,'Coordinate Reference System',2650,7302,'Pulkovo 1995 / 3GK zn 16',''),
(4816,'Coordinate Reference System',2651,7302,'Pulkovo 1995 / 3GK zn 17',''),
(4817,'Coordinate Reference System',2652,7302,'Pulkovo 1995 / 3GK zn 18',''),
(4818,'Coordinate Reference System',2653,7302,'Pulkovo 1995 / 3GK zn 19',''),
(4819,'Coordinate Reference System',2654,7302,'Pulkovo 1995 / 3GK zn 20',''),
(4820,'Coordinate Reference System',2655,7302,'Pulkovo 1995 / 3GK zn 21',''),
(4821,'Coordinate Reference System',2656,7302,'Pulkovo 1995 / 3GK zn 22',''),
(4822,'Coordinate Reference System',2657,7302,'Pulkovo 1995 / 3GK zn 23',''),
(4823,'Coordinate Reference System',2658,7302,'Pulkovo 1995 / 3GK zn 24',''),
(4824,'Coordinate Reference System',2659,7302,'Pulkovo 1995 / 3GK zn 25',''),
(4825,'Coordinate Reference System',2660,7302,'Pulkovo 1995 / 3GK zn 26',''),
(4826,'Coordinate Reference System',2661,7302,'Pulkovo 1995 / 3GK zn 27',''),
(4827,'Coordinate Reference System',2662,7302,'Pulkovo 1995 / 3GK zn 28',''),
(4828,'Coordinate Reference System',2663,7302,'Pulkovo 1995 / 3GK zn 29',''),
(4829,'Coordinate Reference System',2664,7302,'Pulkovo 1995 / 3GK zn 30',''),
(4830,'Coordinate Reference System',2665,7302,'Pulkovo 1995 / 3GK zn 31',''),
(4831,'Coordinate Reference System',2666,7302,'Pulkovo 1995 / 3GK zn 32',''),
(4832,'Coordinate Reference System',2667,7302,'Pulkovo 1995 / 3GK zn 33',''),
(4833,'Coordinate Reference System',2668,7302,'Pulkovo 1995 / 3GK zn 34',''),
(4834,'Coordinate Reference System',2669,7302,'Pulkovo 1995 / 3GK zn 35',''),
(4835,'Coordinate Reference System',2670,7302,'Pulkovo 1995 / 3GK zn 36',''),
(4836,'Coordinate Reference System',2671,7302,'Pulkovo 1995 / 3GK zn 37',''),
(4837,'Coordinate Reference System',2672,7302,'Pulkovo 1995 / 3GK zn 38',''),
(4838,'Coordinate Reference System',2673,7302,'Pulkovo 1995 / 3GK zn 39',''),
(4839,'Coordinate Reference System',2674,7302,'Pulkovo 1995 / 3GK zn 40',''),
(4840,'Coordinate Reference System',2675,7302,'Pulkovo 1995 / 3GK zn 41',''),
(4841,'Coordinate Reference System',2676,7302,'Pulkovo 1995 / 3GK zn 42',''),
(4842,'Coordinate Reference System',2677,7302,'Pulkovo 1995 / 3GK zn 43',''),
(4843,'Coordinate Reference System',2678,7302,'Pulkovo 1995 / 3GK zn 44',''),
(4844,'Coordinate Reference System',2679,7302,'Pulkovo 1995 / 3GK zn 45',''),
(4845,'Coordinate Reference System',2680,7302,'Pulkovo 1995 / 3GK zn 46',''),
(4846,'Coordinate Reference System',2681,7302,'Pulkovo 1995 / 3GK zn 47',''),
(4847,'Coordinate Reference System',2682,7302,'Pulkovo 1995 / 3GK zn 48',''),
(4848,'Coordinate Reference System',2683,7302,'Pulkovo 1995 / 3GK zn 49',''),
(4849,'Coordinate Reference System',2684,7302,'Pulkovo 1995 / 3GK zn 50',''),
(4850,'Coordinate Reference System',2685,7302,'Pulkovo 1995 / 3GK zn 51',''),
(4851,'Coordinate Reference System',2686,7302,'Pulkovo 1995 / 3GK zn 52',''),
(4852,'Coordinate Reference System',2687,7302,'Pulkovo 1995 / 3GK zn 53',''),
(4853,'Coordinate Reference System',2688,7302,'Pulkovo 1995 / 3GK zn 54',''),
(4854,'Coordinate Reference System',2689,7302,'Pulkovo 1995 / 3GK zn 55',''),
(4855,'Coordinate Reference System',2690,7302,'Pulkovo 1995 / 3GK zn 56',''),
(4856,'Coordinate Reference System',2691,7302,'Pulkovo 1995 / 3GK zn 57',''),
(4857,'Coordinate Reference System',2692,7302,'Pulkovo 1995 / 3GK zn 58',''),
(4858,'Coordinate Reference System',2693,7302,'Pulkovo 1995 / 3GK zn 59',''),
(4859,'Coordinate Reference System',3390,7302,'Pulkovo 1995 / 3GK zn 60',''),
(4860,'Coordinate Reference System',2695,7302,'Pulkovo 1995 / 3GK zn 61',''),
(4861,'Coordinate Reference System',2696,7302,'Pulkovo 1995 / 3GK zn 62',''),
(4862,'Coordinate Reference System',2697,7302,'Pulkovo 1995 / 3GK zn 63',''),
(4863,'Coordinate Reference System',2698,7302,'Pulkovo 1995 / 3GK zn 64',''),
(4864,'Coordinate Reference System',2699,7302,'Pulkovo 1995 / 3GK 21E',''),
(4865,'Coordinate Reference System',2700,7302,'Pulkovo 1995 / 3GK 24E',''),
(4866,'Coordinate Reference System',2701,7302,'Pulkovo 1995 / 3GK 27E',''),
(4867,'Coordinate Reference System',2702,7302,'Pulkovo 1995 / 3GK 30E',''),
(4868,'Coordinate Reference System',2703,7302,'Pulkovo 1995 / 3GK 33E',''),
(4869,'Coordinate Reference System',2704,7302,'Pulkovo 1995 / 3GK 36E',''),
(4870,'Coordinate Reference System',2705,7302,'Pulkovo 1995 / 3GK 39E',''),
(4871,'Coordinate Reference System',2706,7302,'Pulkovo 1995 / 3GK 42E',''),
(4872,'Coordinate Reference System',2707,7302,'Pulkovo 1995 / 3GK 45E',''),
(4873,'Coordinate Reference System',2708,7302,'Pulkovo 1995 / 3GK 48E',''),
(4874,'Coordinate Reference System',2709,7302,'Pulkovo 1995 / 3GK 51E',''),
(4875,'Coordinate Reference System',2710,7302,'Pulkovo 1995 / 3GK 54E',''),
(4876,'Coordinate Reference System',2711,7302,'Pulkovo 1995 / 3GK 57E',''),
(4877,'Coordinate Reference System',2712,7302,'Pulkovo 1995 / 3GK 60E',''),
(4878,'Coordinate Reference System',2713,7302,'Pulkovo 1995 / 3GK 63E',''),
(4879,'Coordinate Reference System',2714,7302,'Pulkovo 1995 / 3GK 66E',''),
(4880,'Coordinate Reference System',2715,7302,'Pulkovo 1995 / 3GK 69E',''),
(4881,'Coordinate Reference System',2716,7302,'Pulkovo 1995 / 3GK 72E',''),
(4882,'Coordinate Reference System',2717,7302,'Pulkovo 1995 / 3GK 75E',''),
(4883,'Coordinate Reference System',2718,7302,'Pulkovo 1995 / 3GK 78E',''),
(4884,'Coordinate Reference System',2719,7302,'Pulkovo 1995 / 3GK 81E',''),
(4885,'Coordinate Reference System',2720,7302,'Pulkovo 1995 / 3GK 84E',''),
(4886,'Coordinate Reference System',2721,7302,'Pulkovo 1995 / 3GK 87E',''),
(4887,'Coordinate Reference System',2722,7302,'Pulkovo 1995 / 3GK 90E',''),
(4888,'Coordinate Reference System',2723,7302,'Pulkovo 1995 / 3GK 93E',''),
(4889,'Coordinate Reference System',2724,7302,'Pulkovo 1995 / 3GK 96E',''),
(4890,'Coordinate Reference System',2725,7302,'Pulkovo 1995 / 3GK 99E',''),
(4891,'Coordinate Reference System',2726,7302,'Pulkovo 1995 / 3GK 102E',''),
(4892,'Coordinate Reference System',2727,7302,'Pulkovo 1995 / 3GK 105E',''),
(4893,'Coordinate Reference System',2728,7302,'Pulkovo 1995 / 3GK 108E',''),
(4894,'Coordinate Reference System',2729,7302,'Pulkovo 1995 / 3GK 111E',''),
(4895,'Coordinate Reference System',2730,7302,'Pulkovo 1995 / 3GK 114E',''),
(4896,'Coordinate Reference System',2731,7302,'Pulkovo 1995 / 3GK 117E',''),
(4897,'Coordinate Reference System',2732,7302,'Pulkovo 1995 / 3GK 120E',''),
(4898,'Coordinate Reference System',2733,7302,'Pulkovo 1995 / 3GK 123E',''),
(4899,'Coordinate Reference System',2734,7302,'Pulkovo 1995 / 3GK 126E',''),
(4900,'Coordinate Reference System',2735,7302,'Pulkovo 1995 / 3GK 129E',''),
(4901,'Coordinate Reference System',2738,7302,'Pulkovo 1995 / 3GK 132E',''),
(4902,'Coordinate Reference System',2739,7302,'Pulkovo 1995 / 3GK 135E',''),
(4903,'Coordinate Reference System',2740,7302,'Pulkovo 1995 / 3GK 138E',''),
(4904,'Coordinate Reference System',2741,7302,'Pulkovo 1995 / 3GK 141E',''),
(4905,'Coordinate Reference System',2742,7302,'Pulkovo 1995 / 3GK 144E',''),
(4906,'Coordinate Reference System',2743,7302,'Pulkovo 1995 / 3GK 147E',''),
(4907,'Coordinate Reference System',2744,7302,'Pulkovo 1995 / 3GK 150E',''),
(4908,'Coordinate Reference System',2745,7302,'Pulkovo 1995 / 3GK 153E',''),
(4909,'Coordinate Reference System',2746,7302,'Pulkovo 1995 / 3GK 156E',''),
(4910,'Coordinate Reference System',2747,7302,'Pulkovo 1995 / 3GK 159E',''),
(4911,'Coordinate Reference System',2748,7302,'Pulkovo 1995 / 3GK 162E',''),
(4912,'Coordinate Reference System',2749,7302,'Pulkovo 1995 / 3GK 165E',''),
(4913,'Coordinate Reference System',2750,7302,'Pulkovo 1995 / 3GK 168E',''),
(4914,'Coordinate Reference System',2751,7302,'Pulkovo 1995 / 3GK 171E',''),
(4915,'Coordinate Reference System',2752,7302,'Pulkovo 1995 / 3GK 174E',''),
(4916,'Coordinate Reference System',2753,7302,'Pulkovo 1995 / 3GK 177E',''),
(4917,'Coordinate Reference System',2754,7302,'Pulkovo 1995 / 3GK 180E',''),
(4918,'Coordinate Reference System',2755,7302,'Pulkovo 1995 / 3GK 177W',''),
(4919,'Coordinate Reference System',2756,7302,'Pulkovo 1995 / 3GK 174W',''),
(4920,'Coordinate Reference System',2757,7302,'Pulkovo 1995 / 3GK 171W',''),
(4921,'Coordinate Reference System',2758,7302,'Pulkovo 1995 / 3GK 168W',''),
(4922,'Coordinate Reference System',2759,7302,'NAD83(HARN) / AL E (m)',''),
(4923,'Coordinate Reference System',2760,7302,'NAD83(HARN) / AL W (m)',''),
(4924,'Coordinate Reference System',2761,7302,'NAD83(HARN) / AZ E (m)',''),
(4925,'Coordinate Reference System',2762,7302,'NAD83(HARN) / AZ C (m)',''),
(4926,'Coordinate Reference System',2763,7302,'NAD83(HARN) / AZ W (m)',''),
(4927,'Coordinate Reference System',2764,7302,'NAD83(HARN) / AR N (m)',''),
(4928,'Coordinate Reference System',2765,7302,'NAD83(HARN) / AR S (m)',''),
(4929,'Coordinate Reference System',2766,7302,'NAD83(HARN) / CA 1 (m)',''),
(4930,'Coordinate Reference System',2767,7302,'NAD83(HARN) / CA 2 (m)',''),
(4931,'Coordinate Reference System',2768,7302,'NAD83(HARN) / CA 3 (m)',''),
(4932,'Coordinate Reference System',2769,7302,'NAD83(HARN) / CA 4 (m)',''),
(4933,'Coordinate Reference System',2770,7302,'NAD83(HARN) / CA 5 (m)',''),
(4934,'Coordinate Reference System',2771,7302,'NAD83(HARN) / CA 6 (m)',''),
(4935,'Coordinate Reference System',2772,7302,'NAD83(HARN) / CO N (m)',''),
(4936,'Coordinate Reference System',2773,7302,'NAD83(HARN) / CO C (m)',''),
(4937,'Coordinate Reference System',2774,7302,'NAD83(HARN) / CO S (m)',''),
(4938,'Coordinate Reference System',2775,7302,'NAD83(HARN) / CT (m)',''),
(4939,'Coordinate Reference System',2777,7302,'NAD83(HARN) / FL E (m)',''),
(4940,'Coordinate Reference System',2778,7302,'NAD83(HARN) / FL W (m)',''),
(4941,'Coordinate Reference System',2779,7302,'NAD83(HARN) / FL N (m)',''),
(4942,'Coordinate Reference System',2780,7302,'NAD83(HARN) / GA E (m)',''),
(4943,'Coordinate Reference System',2781,7302,'NAD83(HARN) / GA W (m)',''),
(4944,'Coordinate Reference System',2782,7302,'NAD83(HARN) / HI 1 (m)',''),
(4945,'Coordinate Reference System',2783,7302,'NAD83(HARN) / HI 2 (m)',''),
(4946,'Coordinate Reference System',2784,7302,'NAD83(HARN) / HI 3 (m)',''),
(4947,'Coordinate Reference System',2785,7302,'NAD83(HARN) / HI 4 (m)',''),
(4948,'Coordinate Reference System',2786,7302,'NAD83(HARN) / HI 5 (m)',''),
(4949,'Coordinate Reference System',2788,7302,'NAD83(HARN) / ID C (m)',''),
(4950,'Coordinate Reference System',2791,7302,'NAD83(HARN) / IL W (m)',''),
(4951,'Coordinate Reference System',2792,7302,'NAD83(HARN) / IN E (m)',''),
(4952,'Coordinate Reference System',2793,7302,'NAD83(HARN) / IN W (m)',''),
(4953,'Coordinate Reference System',2796,7302,'NAD83(HARN) / KS N (m)',''),
(4954,'Coordinate Reference System',2797,7302,'NAD83(HARN) / KS S (m)',''),
(4955,'Coordinate Reference System',2798,7302,'NAD83(HARN) / KY N (m)',''),
(4956,'Coordinate Reference System',2799,7302,'NAD83(HARN) / KY S (m)',''),
(4957,'Coordinate Reference System',2800,7302,'NAD83(HARN) / LA N (m)',''),
(4958,'Coordinate Reference System',2801,7302,'NAD83(HARN) / LA S (m)',''),
(4959,'Coordinate Reference System',2805,7302,'NAD83(HARN) / MA md (m)',''),
(4960,'Coordinate Reference System',2806,7302,'NAD83(HARN) / MA Is (m)',''),
(4961,'Coordinate Reference System',2807,7302,'NAD83(HARN) / MI N (m)',''),
(4962,'Coordinate Reference System',2808,7302,'NAD83(HARN) / MI C (m)',''),
(4963,'Coordinate Reference System',2809,7302,'NAD83(HARN) / MI S (m)',''),
(4964,'Coordinate Reference System',2810,7302,'NAD83(HARN) / MN N (m)',''),
(4965,'Coordinate Reference System',2811,7302,'NAD83(HARN) / MN C (m)',''),
(4966,'Coordinate Reference System',2812,7302,'NAD83(HARN) / MN S (m)',''),
(4967,'Coordinate Reference System',2813,7302,'NAD83(HARN) / MS E (m)',''),
(4968,'Coordinate Reference System',2814,7302,'NAD83(HARN) / MS W (m)',''),
(4969,'Coordinate Reference System',2815,7302,'NAD83(HARN) / MO E (m)',''),
(4970,'Coordinate Reference System',2816,7302,'NAD83(HARN) / MO C (m)',''),
(4971,'Coordinate Reference System',2817,7302,'NAD83(HARN) / MO W (m)',''),
(4972,'Coordinate Reference System',2820,7302,'NAD83(HARN) / NV E (m)',''),
(4973,'Coordinate Reference System',2821,7302,'NAD83(HARN) / NV C (m)',''),
(4974,'Coordinate Reference System',2822,7302,'NAD83(HARN) / NV W (m)',''),
(4975,'Coordinate Reference System',2823,7302,'NAD83(HARN) / NH (m)',''),
(4976,'Coordinate Reference System',2825,7302,'NAD83(HARN) / NM E (m)',''),
(4977,'Coordinate Reference System',2826,7302,'NAD83(HARN) / NM C (m)',''),
(4978,'Coordinate Reference System',2827,7302,'NAD83(HARN) / NM W (m)',''),
(4979,'Coordinate Reference System',2828,7302,'NAD83(HARN) / NY E (m)',''),
(4980,'Coordinate Reference System',2829,7302,'NAD83(HARN) / NY C (m)',''),
(4981,'Coordinate Reference System',2830,7302,'NAD83(HARN) / NY W (m)',''),
(4982,'Coordinate Reference System',2831,7302,'NAD83(HARN) / NY LI (m)',''),
(4983,'Coordinate Reference System',2832,7302,'NAD83(HARN) / ND N (m)',''),
(4984,'Coordinate Reference System',2833,7302,'NAD83(HARN) / ND S (m)',''),
(4985,'Coordinate Reference System',2836,7302,'NAD83(HARN) / OK N (m)',''),
(4986,'Coordinate Reference System',2837,7302,'NAD83(HARN) / OK S (m)',''),
(4987,'Coordinate Reference System',2838,7302,'NAD83(HARN) / OR N (m)',''),
(4988,'Coordinate Reference System',2839,7302,'NAD83(HARN) / OR S (m)',''),
(4989,'Coordinate Reference System',2840,7302,'NAD83(HARN) / RI (m)',''),
(4990,'Coordinate Reference System',2841,7302,'NAD83(HARN) / SD N (m)',''),
(4991,'Coordinate Reference System',2842,7302,'NAD83(HARN) / SD S (m)',''),
(4992,'Coordinate Reference System',2844,7302,'NAD83(HARN) / TX N (m)',''),
(4993,'Coordinate Reference System',2845,7302,'NAD83(HARN) / TX NC (m)',''),
(4994,'Coordinate Reference System',2846,7302,'NAD83(HARN) / TX C (m)',''),
(4995,'Coordinate Reference System',2847,7302,'NAD83(HARN) / TX SC (m)',''),
(4996,'Coordinate Reference System',2848,7302,'NAD83(HARN) / TX S (m)',''),
(4997,'Coordinate Reference System',2850,7302,'NAD83(HARN) / UT C (m)',''),
(4998,'Coordinate Reference System',2853,7302,'NAD83(HARN) / VA N (m)',''),
(4999,'Coordinate Reference System',2854,7302,'NAD83(HARN) / VA S (m)',''),
(5000,'Coordinate Reference System',2855,7302,'NAD83(HARN) / WA N (m)',''),
(5001,'Coordinate Reference System',2856,7302,'NAD83(HARN) / WA S (m)',''),
(5002,'Coordinate Reference System',2857,7302,'NAD83(HARN) / WV N (m)',''),
(5003,'Coordinate Reference System',2858,7302,'NAD83(HARN) / WV S (m)',''),
(5004,'Coordinate Reference System',2859,7302,'NAD83(HARN) / WI N (m)',''),
(5005,'Coordinate Reference System',2860,7302,'NAD83(HARN) / WI C (m)',''),
(5006,'Coordinate Reference System',2861,7302,'NAD83(HARN) / WI S (m)',''),
(5007,'Coordinate Reference System',2862,7302,'NAD83(HARN) / WY E (m)',''),
(5008,'Coordinate Reference System',2863,7302,'NAD83(HARN) / WY EC (m)',''),
(5009,'Coordinate Reference System',2864,7302,'NAD83(HARN) / WY WC (m)',''),
(5010,'Coordinate Reference System',2865,7302,'NAD83(HARN) / WY W (m)',''),
(5011,'Coordinate Reference System',2866,7302,'NAD83(HARN) / PR and VI',''),
(5012,'Coordinate Reference System',2867,7302,'NAD83(HARN) / AZ E (ft)',''),
(5013,'Coordinate Reference System',2868,7302,'NAD83(HARN) / AZ C (ft)',''),
(5014,'Coordinate Reference System',2869,7302,'NAD83(HARN) / AZ W (ft)',''),
(5015,'Coordinate Reference System',2870,7302,'NAD83(HARN) / CA 1 (ftUS)',''),
(5016,'Coordinate Reference System',2871,7302,'NAD83(HARN) / CA 2 (ftUS)',''),
(5017,'Coordinate Reference System',2872,7302,'NAD83(HARN) / CA 3 (ftUS)',''),
(5018,'Coordinate Reference System',2873,7302,'NAD83(HARN) / CA 4 (ftUS)',''),
(5019,'Coordinate Reference System',2874,7302,'NAD83(HARN) / CA 5 (ftUS)',''),
(5020,'Coordinate Reference System',2875,7302,'NAD83(HARN) / CA 6 (ftUS)',''),
(5021,'Coordinate Reference System',2876,7302,'NAD83(HARN) / CO N (ftUS)',''),
(5022,'Coordinate Reference System',2877,7302,'NAD83(HARN) / CO C (ftUS)',''),
(5023,'Coordinate Reference System',2878,7302,'NAD83(HARN) / CO S (ftUS)',''),
(5024,'Coordinate Reference System',2879,7302,'NAD83(HARN) / CT (ftUS)',''),
(5025,'Coordinate Reference System',2880,7302,'NAD83(HARN) / DE (ftUS)',''),
(5026,'Coordinate Reference System',2881,7302,'NAD83(HARN) / FL E (ftUS)',''),
(5027,'Coordinate Reference System',2882,7302,'NAD83(HARN) / FL W (ftUS)',''),
(5028,'Coordinate Reference System',2883,7302,'NAD83(HARN) / FL N (ftUS)',''),
(5029,'Coordinate Reference System',2884,7302,'NAD83(HARN) / GA E (ftUS)',''),
(5030,'Coordinate Reference System',2885,7302,'NAD83(HARN) / GA W (ftUS)',''),
(5031,'Coordinate Reference System',2886,7302,'NAD83(HARN) / ID E (ftUS)',''),
(5032,'Coordinate Reference System',2887,7302,'NAD83(HARN) / ID C (ftUS)',''),
(5033,'Coordinate Reference System',2888,7302,'NAD83(HARN) / ID W (ftUS)',''),
(5034,'Coordinate Reference System',2967,7302,'NAD83(HARN) / IN E (ftUS)',''),
(5035,'Coordinate Reference System',2968,7302,'NAD83(HARN) / IN W (ftUS)',''),
(5036,'Coordinate Reference System',2891,7302,'NAD83(HARN) / KY N (ftUS)',''),
(5037,'Coordinate Reference System',2892,7302,'NAD83(HARN) / KY S (ftUS)',''),
(5038,'Coordinate Reference System',2893,7302,'NAD83(HARN) / MD (ftUS)',''),
(5039,'Coordinate Reference System',2894,7302,'NAD83(HARN) / MA md (ftUS)',''),
(5040,'Coordinate Reference System',2895,7302,'NAD83(HARN) / MA Is (ftUS)',''),
(5041,'Coordinate Reference System',2896,7302,'NAD83(HARN) / MI N (ft)',''),
(5042,'Coordinate Reference System',2897,7302,'NAD83(HARN) / MI C (ft)',''),
(5043,'Coordinate Reference System',2898,7302,'NAD83(HARN) / MI S (ft)',''),
(5044,'Coordinate Reference System',2899,7302,'NAD83(HARN) / MS E (ftUS)',''),
(5045,'Coordinate Reference System',2900,7302,'NAD83(HARN) / MS W (ftUS)',''),
(5046,'Coordinate Reference System',2901,7302,'NAD83(HARN) / MT (ft)',''),
(5047,'Coordinate Reference System',2902,7302,'NAD83(HARN) / NM E (ftUS)',''),
(5048,'Coordinate Reference System',2903,7302,'NAD83(HARN) / NM C (ftUS)',''),
(5049,'Coordinate Reference System',2904,7302,'NAD83(HARN) / NM W (ftUS)',''),
(5050,'Coordinate Reference System',2905,7302,'NAD83(HARN) / NY E (ftUS)',''),
(5051,'Coordinate Reference System',2906,7302,'NAD83(HARN) / NY C (ftUS)',''),
(5052,'Coordinate Reference System',2907,7302,'NAD83(HARN) / NY W (ftUS)',''),
(5053,'Coordinate Reference System',2908,7302,'NAD83(HARN) / NY LI (ftUS)',''),
(5054,'Coordinate Reference System',2909,7302,'NAD83(HARN) / ND N (ft)',''),
(5055,'Coordinate Reference System',2910,7302,'NAD83(HARN) / ND S (ft)',''),
(5056,'Coordinate Reference System',2911,7302,'NAD83(HARN) / OK N (ftUS)',''),
(5057,'Coordinate Reference System',2912,7302,'NAD83(HARN) / OK S (ftUS)',''),
(5058,'Coordinate Reference System',2913,7302,'NAD83(HARN) / OR N (ft)',''),
(5059,'Coordinate Reference System',2914,7302,'NAD83(HARN) / OR S (ft)',''),
(5060,'Coordinate Reference System',2915,7302,'NAD83(HARN) / TN (ftUS)',''),
(5061,'Coordinate Reference System',2916,7302,'NAD83(HARN) / TX N (ftUS)',''),
(5062,'Coordinate Reference System',2917,7302,'NAD83(HARN) / TX NC (ftUS)',''),
(5063,'Coordinate Reference System',2918,7302,'NAD83(HARN) / TX C (ftUS)',''),
(5064,'Coordinate Reference System',2919,7302,'NAD83(HARN) / TX SC (ftUS)',''),
(5065,'Coordinate Reference System',2920,7302,'NAD83(HARN) / TX S (ftUS)',''),
(5066,'Coordinate Reference System',2921,7302,'NAD83(HARN) / UT N (ft)',''),
(5067,'Coordinate Reference System',2922,7302,'NAD83(HARN) / UT C (ft)',''),
(5068,'Coordinate Reference System',2923,7302,'NAD83(HARN) / UT S (ft)',''),
(5069,'Coordinate Reference System',2924,7302,'NAD83(HARN) / VA N (ftUS)',''),
(5070,'Coordinate Reference System',2925,7302,'NAD83(HARN) / VA S (ftUS)',''),
(5071,'Coordinate Reference System',2926,7302,'NAD83(HARN) / WA N (ftUS)',''),
(5072,'Coordinate Reference System',2927,7302,'NAD83(HARN) / WA S (ftUS)',''),
(5073,'Coordinate Reference System',2928,7302,'NAD83(HARN) / WI N (ftUS)',''),
(5074,'Coordinate Reference System',2929,7302,'NAD83(HARN) / WI C (ftUS)',''),
(5075,'Coordinate Reference System',2930,7302,'NAD83(HARN) / WI S (ftUS)',''),
(5076,'Coordinate Reference System',2932,7302,'QND95 / Qatar Nat Grid',''),
(5077,'Coordinate Reference System',2935,7302,'Pulkovo 1942 / CS63 A1',''),
(5078,'Coordinate Reference System',2936,7302,'Pulkovo 1942 / CS63 A2',''),
(5079,'Coordinate Reference System',2937,7302,'Pulkovo 1942 / CS63 A3',''),
(5080,'Coordinate Reference System',2938,7302,'Pulkovo 1942 / CS63 A4',''),
(5081,'Coordinate Reference System',2939,7302,'Pulkovo 1942 / CS63 K2',''),
(5082,'Coordinate Reference System',2940,7302,'Pulkovo 1942 / CS63 K3',''),
(5083,'Coordinate Reference System',2941,7302,'Pulkovo 1942 / CS63 K4',''),
(5084,'Coordinate Reference System',2942,7302,'Porto Santo / UTM 28N',''),
(5085,'Coordinate Reference System',2943,7302,'Selvagem Gr. / UTM 28N',''),
(5086,'Coordinate Reference System',2944,7302,'NAD83(CSRS) / SCoPQ 2',''),
(5087,'Coordinate Reference System',2952,7302,'NAD83(CSRS) / MTM zn 10',''),
(5088,'Coordinate Reference System',2953,7302,'NAD83(CSRS) / NB Stereo',''),
(5089,'Coordinate Reference System',2954,7302,'NAD83(CSRS) / PEI Stereo',''),
(5090,'Coordinate Reference System',2955,7302,'NAD83(CSRS) / UTM 11N',''),
(5091,'Coordinate Reference System',2956,7302,'NAD83(CSRS) / UTM 12N',''),
(5092,'Coordinate Reference System',2957,7302,'NAD83(CSRS) / UTM 13N',''),
(5093,'Coordinate Reference System',2958,7302,'NAD83(CSRS) / UTM 17N',''),
(5094,'Coordinate Reference System',2959,7302,'NAD83(CSRS) / UTM 18N',''),
(5095,'Coordinate Reference System',2960,7302,'NAD83(CSRS) / UTM 19N',''),
(5096,'Coordinate Reference System',2961,7302,'NAD83(CSRS) / UTM 20N',''),
(5097,'Coordinate Reference System',2962,7302,'NAD83(CSRS) / UTM 21N',''),
(5098,'Coordinate Reference System',2963,7302,'Lisbon 1890 / Bonne',''),
(5099,'Coordinate Reference System',2965,7302,'NAD83 / Indiana E (ftUS)',''),
(5100,'Coordinate Reference System',2966,7302,'NAD83 / Indiana W (ftUS)',''),
(5101,'Coordinate Reference System',2969,7302,'Fort Marigot / UTM 20N',''),
(5102,'Coordinate Reference System',2978,7302,'IGN72 Nuku Hiva / UTM 7S',''),
(5103,'Coordinate Reference System',2980,7302,'Combani 1950 / UTM 38S',''),
(5104,'Coordinate Reference System',2981,7302,'IGN56 Lifou / UTM zn 58S',''),
(5105,'Coordinate Reference System',2985,7302,'Petrels 1972 / Adelie St',''),
(5106,'Coordinate Reference System',2986,7302,'Perroud 1950 / Adelie St',''),
(5107,'Coordinate Reference System',2987,7302,'St. Pierre Miq / UTM 21N',''),
(5108,'Coordinate Reference System',2992,7302,'NAD83 / OR GIC Lam (ft)',''),
(5109,'Coordinate_Operation',6898,7302,'DLx to WGS 84 (5)',''),
(5110,'Coordinate Reference System',2994,7302,'NAD83(HARN) / OR GIC Lam (ft)',''),
(5111,'Coordinate Reference System',2995,7302,'IGN53 Mare / UTM zn 58S',''),
(5112,'Coordinate Reference System',2996,7302,'ST84 des Pins / UTM 58S',''),
(5113,'Coordinate Reference System',2997,7302,'ST71 Belep / UTM zn 58S',''),
(5114,'Coordinate Reference System',2998,7302,'NEA74 Noumea / UTM 58S',''),
(5115,'Coordinate Reference System',2999,7302,'Grand Comoros / UTM 38S',''),
(5116,'Coordinate Reference System',3031,7302,'WGS 84 / Antarctic PS',''),
(5117,'Coordinate Reference System',3032,7302,'WGS 84 / Aus Antarc PS',''),
(5118,'Coordinate Reference System',3033,7302,'WGS 84 / Aus Antarc LCC',''),
(5119,'Coordinate Reference System',3052,7302,'Reykjavik 1900 / Lambert',''),
(5120,'Coordinate Reference System',3053,7302,'Hjorsey 1955 / Lambert',''),
(5121,'Coordinate Reference System',3054,7302,'Hjorsey 1955 / UTM 26N',''),
(5122,'Coordinate Reference System',3055,7302,'Hjorsey 1955 / UTM 27N',''),
(5123,'Coordinate Reference System',3056,7302,'Hjorsey 1955 / UTM 28N',''),
(5124,'Coordinate Reference System',3058,7302,'Helle 1954 / Jan Mayen',''),
(5125,'Coordinate Reference System',3060,7302,'IGN72 Gr Terre / UTM 58S',''),
(5126,'Coordinate Reference System',3071,7302,'NAD83(HARN) / WTM 83',''),
(5127,'Coordinate Reference System',3072,7302,'NAD83 / Maine CS2000 E',''),
(5128,'Coordinate Reference System',3463,7302,'NAD83 / Maine CS2000 C',''),
(5129,'Coordinate Reference System',3074,7302,'NAD83 / Maine CS2000 W',''),
(5130,'Coordinate Reference System',3075,7302,'NAD83(HARN) / ME 2000 E',''),
(5131,'Coordinate Reference System',3464,7302,'NAD83(HARN) / ME 2000 C',''),
(5132,'Coordinate Reference System',3077,7302,'NAD83(HARN) / ME 2000 W',''),
(5133,'Coordinate Reference System',3086,7302,'NAD83 / FL GDL Albers',''),
(5134,'Coordinate Reference System',3087,7302,'NAD83(HARN) / FL GDL AEA',''),
(5135,'Coordinate Reference System',3102,7302,'American Samoa 62 / LCC',''),
(5136,'Coordinate_Operation',6898,1039,'LIS',''),
(5137,'Coordinate Reference System',3114,7302,'MAGNA-SIRGAS / Col FW',''),
(5138,'Coordinate Reference System',3115,7302,'MAGNA-SIRGAS / Col W',''),
(5139,'Coordinate Reference System',3116,7302,'MAGNA-SIRGAS / Col Bog',''),
(5140,'Coordinate Reference System',3117,7302,'MAGNA-SIRGAS / Col EC',''),
(5141,'Coordinate Reference System',3118,7302,'MAGNA-SIRGAS / Col E',''),
(5142,'Coordinate Reference System',3121,7302,'PRS92 / Philippines 1',''),
(5143,'Coordinate Reference System',3122,7302,'PRS92 / Philippines 2',''),
(5144,'Coordinate Reference System',3123,7302,'PRS92 / Philippines 3',''),
(5145,'Coordinate Reference System',3124,7302,'PRS92 / Philippines 4',''),
(5146,'Coordinate Reference System',3125,7302,'PRS92 / Philippines 5',''),
(5147,'Coordinate Reference System',3139,7302,'Vanua Levu 1915 / Cass',''),
(5148,'Coordinate Reference System',3140,7302,'Viti Levu 1912 / Cassini',''),
(5149,'Coordinate Reference System',3146,7302,'Pulkovo 1942 / 3GK zn 6',''),
(5150,'Coordinate Reference System',3147,7302,'Pulkovo 1942 / 3GK 18E',''),
(5151,'Coordinate Reference System',3148,7302,'Indian 1960 / UTM 48N',''),
(5152,'Coordinate Reference System',3149,7302,'Indian 1960 / UTM 49N',''),
(5153,'Coordinate Reference System',3150,7302,'Pulkovo 1995 / 3GK zn 6',''),
(5154,'Coordinate Reference System',3151,7302,'Pulkovo 1995 / 3GK 18E',''),
(5155,'Coordinate Reference System',3154,7302,'NAD83(CSRS) / UTM 7N',''),
(5156,'Coordinate Reference System',3155,7302,'NAD83(CSRS) / UTM 8N',''),
(5157,'Coordinate Reference System',3156,7302,'NAD83(CSRS) / UTM 9N',''),
(5158,'Coordinate Reference System',3157,7302,'NAD83(CSRS) / UTM 10N',''),
(5159,'Coordinate Reference System',3158,7302,'NAD83(CSRS) / UTM 14N',''),
(5160,'Coordinate Reference System',3159,7302,'NAD83(CSRS) / UTM 15N',''),
(5161,'Coordinate Reference System',3160,7302,'NAD83(CSRS) / UTM 16N',''),
(5162,'Coordinate Reference System',3161,7302,'NAD83 / Ontario MNR LCC',''),
(5163,'Coordinate Reference System',3162,7302,'NAD83(CSRS) / ON MNR LCC',''),
(5164,'Coordinate Reference System',3163,7302,'RGNC / LCC New Caledonia',''),
(5165,'Coordinate Reference System',3164,7302,'ST87 Ouvea / UTM 58S',''),
(5166,'Coordinate Reference System',3165,7302,'NEA74 Noumea / LCC',''),
(5167,'Coordinate Reference System',3166,7302,'NEA74 Noumea / LCC2',''),
(5168,'Coordinate Reference System',3167,7302,'Kertau (RSO) / RSO (ch)',''),
(5169,'Coordinate Reference System',3168,7302,'Kertau (RSO) / RSO (m)',''),
(5170,'Coordinate Reference System',3172,7302,'IGN53 Mare / UTM 59S',''),
(5171,'Coordinate Reference System',3174,7302,'NAD83 / GL Albers',''),
(5172,'Coordinate Reference System',3175,7302,'NAD83 / GL+SLS Albers',''),
(5173,'Coordinate_Operation',19839,7301,'DLTM',''),
(5174,'Coordinate_Operation',19839,7302,'Dubai Local TM',''),
(5175,'Coordinate Reference System',3997,7317,'WGS 84 / DLTM',''),
(5176,'Coordinate Reference System',3995,7302,'WGS 84 / Arctic PS',''),
(5177,'Coordinate Reference System',3996,7302,'WGS 84 / IBCAO PS',''),
(5178,'Coordinate Reference System',7410,7301,'PSD93 + PHD93',''),
(5179,'Coordinate Reference System',5725,7301,'Fahud Height Datum height',''),
(5180,'Coordinate Reference System',3190,7302,'LGD2006 / Libya TM 5',''),
(5181,'Coordinate Reference System',3191,7302,'LGD2006 / Libya TM 6',''),
(5182,'Coordinate Reference System',3192,7302,'LGD2006 / Libya TM 7',''),
(5183,'Coordinate Reference System',3193,7302,'LGD2006 / Libya TM 8',''),
(5184,'Coordinate Reference System',3194,7302,'LGD2006 / Libya TM 9',''),
(5185,'Coordinate Reference System',3195,7302,'LGD2006 / Libya TM 10',''),
(5186,'Coordinate Reference System',3196,7302,'LGD2006 / Libya TM 11',''),
(5187,'Coordinate Reference System',3197,7302,'LGD2006 / Libya TM 12',''),
(5188,'Coordinate Reference System',3198,7302,'LGD2006 / Libya TM 13',''),
(5189,'Coordinate Reference System',3204,7302,'WGS 84 / SCAR SP19-20',''),
(5190,'Coordinate Reference System',3205,7302,'WGS 84 / SCAR SP21-22',''),
(5191,'Coordinate_Operation',6906,1039,'ARF-G',''),
(5192,'Coordinate Reference System',6933,7302,'EASE-Grid 2.0 Global',''),
(5193,'Coordinate_Operation',6928,7302,'NSIDC EASE-Grid 2.0 Global',''),
(5194,'Coordinate_Operation',6929,7302,'NSIDC EASE-Grid 2.0 North',''),
(5195,'Coordinate_Operation',6930,7302,'NSIDC EASE-Grid 2.0 South',''),
(5196,'Coordinate Reference System',6931,7302,'EASE-Grid 2.0 North',''),
(5197,'Coordinate Reference System',6932,7302,'EASE-Grid 2.0 South',''),
(5198,'Datum',1107,7301,'Cais da Figueirinha - Angra do Herosmo',''),
(5199,'Coordinate Reference System',6184,7301,'Cais da Figueirinha - Angra do Herosmo height',''),
(5200,'Coordinate Reference System',3206,7302,'WGS 84 / SCAR SP23-24',''),
(5201,'Coordinate Reference System',3207,7302,'WGS 84 / SCAR SQ01-02',''),
(5202,'Coordinate Reference System',3208,7302,'WGS 84 / SCAR SQ19-20',''),
(5203,'Coordinate Reference System',3209,7302,'WGS 84 / SCAR SQ21-22',''),
(5204,'Coordinate Reference System',3210,7302,'WGS 84 / SCAR SQ37-38',''),
(5205,'Coordinate Reference System',3211,7302,'WGS 84 / SCAR SQ39-40',''),
(5206,'Coordinate Reference System',3212,7302,'WGS 84 / SCAR SQ41-42',''),
(5207,'Coordinate Reference System',3213,7302,'WGS 84 / SCAR SQ43-44',''),
(5208,'Coordinate Reference System',3214,7302,'WGS 84 / SCAR SQ45-46',''),
(5209,'Coordinate Reference System',3215,7302,'WGS 84 / SCAR SQ47-48',''),
(5210,'Coordinate Reference System',3216,7302,'WGS 84 / SCAR SQ49-50',''),
(5211,'Coordinate Reference System',3217,7302,'WGS 84 / SCAR SQ51-52',''),
(5212,'Coordinate Reference System',3218,7302,'WGS 84 / SCAR SQ53-54',''),
(5213,'Coordinate Reference System',3219,7302,'WGS 84 / SCAR SQ55-56',''),
(5214,'Coordinate Reference System',3220,7302,'WGS 84 / SCAR SQ57-58',''),
(5215,'Coordinate Reference System',3221,7302,'WGS 84 / SCAR SR13-14',''),
(5216,'Coordinate Reference System',3222,7302,'WGS 84 / SCAR SR15-16',''),
(5217,'Coordinate Reference System',3223,7302,'WGS 84 / SCAR SR17-18',''),
(5218,'Coordinate Reference System',3224,7302,'WGS 84 / SCAR SR19-20',''),
(5219,'Coordinate Reference System',3225,7302,'WGS 84 / SCAR SR27-28',''),
(5220,'Coordinate Reference System',3226,7302,'WGS 84 / SCAR SR29-30',''),
(5221,'Coordinate Reference System',3227,7302,'WGS 84 / SCAR SR31-32',''),
(5222,'Coordinate Reference System',3228,7302,'WGS 84 / SCAR SR33-34',''),
(5223,'Coordinate Reference System',3229,7302,'WGS 84 / SCAR SR35-36',''),
(5224,'Coordinate Reference System',3230,7302,'WGS 84 / SCAR SR37-38',''),
(5225,'Coordinate Reference System',3231,7302,'WGS 84 / SCAR SR39-40',''),
(5226,'Coordinate Reference System',3232,7302,'WGS 84 / SCAR SR41-42',''),
(5227,'Coordinate Reference System',3233,7302,'WGS 84 / SCAR SR43-44',''),
(5228,'Coordinate Reference System',3234,7302,'WGS 84 / SCAR SR45-46',''),
(5229,'Coordinate Reference System',3235,7302,'WGS 84 / SCAR SR47-48',''),
(5230,'Coordinate Reference System',3236,7302,'WGS 84 / SCAR SR49-50',''),
(5231,'Coordinate Reference System',3237,7302,'WGS 84 / SCAR SR51-52',''),
(5232,'Coordinate Reference System',3238,7302,'WGS 84 / SCAR SR53-54',''),
(5233,'Coordinate Reference System',3239,7302,'WGS 84 / SCAR SR55-56',''),
(5234,'Coordinate Reference System',3240,7302,'WGS 84 / SCAR SR57-58',''),
(5235,'Coordinate Reference System',3241,7302,'WGS 84 / SCAR SR59-60',''),
(5236,'Coordinate Reference System',3242,7302,'WGS 84 / SCAR SS04-06',''),
(5237,'Coordinate Reference System',3243,7302,'WGS 84 / SCAR SS07-09',''),
(5238,'Coordinate Reference System',3244,7302,'WGS 84 / SCAR SS10-12',''),
(5239,'Coordinate Reference System',3245,7302,'WGS 84 / SCAR SS13-15',''),
(5240,'Coordinate Reference System',3246,7302,'WGS 84 / SCAR SS16-18',''),
(5241,'Coordinate Reference System',3247,7302,'WGS 84 / SCAR SS19-21',''),
(5242,'Coordinate Reference System',3248,7302,'WGS 84 / SCAR SS25-27',''),
(5243,'Coordinate Reference System',3249,7302,'WGS 84 / SCAR SS28-30',''),
(5244,'Coordinate Reference System',3250,7302,'WGS 84 / SCAR SS31-33',''),
(5245,'Coordinate Reference System',3251,7302,'WGS 84 / SCAR SS34-36',''),
(5246,'Coordinate Reference System',3252,7302,'WGS 84 / SCAR SS37-39',''),
(5247,'Coordinate Reference System',3253,7302,'WGS 84 / SCAR SS40-42',''),
(5248,'Coordinate Reference System',3254,7302,'WGS 84 / SCAR SS43-45',''),
(5249,'Coordinate Reference System',3255,7302,'WGS 84 / SCAR SS46-48',''),
(5250,'Coordinate Reference System',3256,7302,'WGS 84 / SCAR SS49-51',''),
(5251,'Coordinate Reference System',3257,7302,'WGS 84 / SCAR SS52-54',''),
(5252,'Coordinate Reference System',3258,7302,'WGS 84 / SCAR SS55-57',''),
(5253,'Coordinate Reference System',3259,7302,'WGS 84 / SCAR SS58-60',''),
(5254,'Coordinate Reference System',3260,7302,'WGS 84 / SCAR ST01-04',''),
(5255,'Coordinate Reference System',3261,7302,'WGS 84 / SCAR ST05-08',''),
(5256,'Coordinate Reference System',3262,7302,'WGS 84 / SCAR ST09-12',''),
(5257,'Coordinate Reference System',3263,7302,'WGS 84 / SCAR ST13-16',''),
(5258,'Coordinate Reference System',3264,7302,'WGS 84 / SCAR ST17-20',''),
(5259,'Coordinate Reference System',3265,7302,'WGS 84 / SCAR ST21-24',''),
(5260,'Coordinate Reference System',3266,7302,'WGS 84 / SCAR ST25-28',''),
(5261,'Coordinate Reference System',3267,7302,'WGS 84 / SCAR ST29-32',''),
(5262,'Coordinate Reference System',3268,7302,'WGS 84 / SCAR ST33-36',''),
(5263,'Coordinate Reference System',3269,7302,'WGS 84 / SCAR ST37-40',''),
(5264,'Coordinate Reference System',3270,7302,'WGS 84 / SCAR ST41-44',''),
(5265,'Coordinate Reference System',3271,7302,'WGS 84 / SCAR ST45-48',''),
(5266,'Coordinate Reference System',3272,7302,'WGS 84 / SCAR ST49-52',''),
(5267,'Coordinate Reference System',3273,7302,'WGS 84 / SCAR ST53-56',''),
(5268,'Coordinate Reference System',3274,7302,'WGS 84 / SCAR ST57-60',''),
(5269,'Coordinate Reference System',3275,7302,'WGS 84 / SCAR SU01-05',''),
(5270,'Coordinate Reference System',3276,7302,'WGS 84 / SCAR SU06-10',''),
(5271,'Coordinate Reference System',3277,7302,'WGS 84 / SCAR SU11-15',''),
(5272,'Coordinate Reference System',3278,7302,'WGS 84 / SCAR SU16-20',''),
(5273,'Coordinate Reference System',3279,7302,'WGS 84 / SCAR SU21-25',''),
(5274,'Coordinate Reference System',3280,7302,'WGS 84 / SCAR SU26-30',''),
(5275,'Coordinate Reference System',3281,7302,'WGS 84 / SCAR SU31-35',''),
(5276,'Coordinate Reference System',3282,7302,'WGS 84 / SCAR SU36-40',''),
(5277,'Coordinate Reference System',3283,7302,'WGS 84 / SCAR SU41-45',''),
(5278,'Coordinate Reference System',3284,7302,'WGS 84 / SCAR SU46-50',''),
(5279,'Coordinate Reference System',3285,7302,'WGS 84 / SCAR SU51-55',''),
(5280,'Coordinate Reference System',3286,7302,'WGS 84 / SCAR SU56-60',''),
(5281,'Coordinate Reference System',3287,7302,'WGS 84 / SCAR SV01-10',''),
(5282,'Coordinate Reference System',3288,7302,'WGS 84 / SCAR SV11-20',''),
(5283,'Coordinate Reference System',3289,7302,'WGS 84 / SCAR SV21-30',''),
(5284,'Coordinate Reference System',3290,7302,'WGS 84 / SCAR SV31-40',''),
(5285,'Coordinate Reference System',3291,7302,'WGS 84 / SCAR SV41-50',''),
(5286,'Coordinate Reference System',3292,7302,'WGS 84 / SCAR SV51-60',''),
(5287,'Coordinate Reference System',3293,7302,'WGS 84 / SCAR SW01-60',''),
(5288,'Coordinate Reference System',3294,7302,'WGS 84 / Transantarctic',''),
(5289,'Coordinate Reference System',3302,7302,'IGN63 Hiva Oa / UTM 7S',''),
(5290,'Coordinate Reference System',3303,7302,'Fatu Iva 72 / UTM 7S',''),
(5291,'Coordinate Reference System',3307,7302,'Nakhl-e Ghanem / UTM 39N',''),
(5292,'Coordinate Reference System',3309,7302,'NAD27 / CA Albers',''),
(5293,'Coordinate Reference System',3310,7302,'NAD83 / CA Albers',''),
(5294,'Coordinate Reference System',3311,7302,'NAD83(HARN) / CA Albers',''),
(5295,'Coordinate Reference System',3314,7302,'Katanga 1955 / Lambert',''),
(5296,'Coordinate Reference System',3315,7302,'Katanga 1955 / TM',''),
(5297,'Coordinate Reference System',3316,7302,'Kasai 1953 / Congo TM 22',''),
(5298,'Coordinate Reference System',3317,7302,'Kasai 1953 / Congo TM 24',''),
(5299,'Coordinate Reference System',3318,7302,'IGC 1962 / Congo TM 12',''),
(5300,'Coordinate Reference System',3319,7302,'IGC 1962 / Congo TM 14',''),
(5301,'Coordinate Reference System',3320,7302,'IGC 1962 / Congo TM 16',''),
(5302,'Coordinate Reference System',3321,7302,'IGC 1962 / Congo TM 18',''),
(5303,'Coordinate Reference System',3322,7302,'IGC 1962 / Congo TM 20',''),
(5304,'Coordinate Reference System',3323,7302,'IGC 1962 / Congo TM 22',''),
(5305,'Coordinate Reference System',3324,7302,'IGC 1962 / Congo TM 24',''),
(5306,'Coordinate Reference System',3325,7302,'IGC 1962 / Congo TM 26',''),
(5307,'Coordinate Reference System',3326,7302,'IGC 1962 / Congo TM 28',''),
(5308,'Coordinate Reference System',3327,7302,'IGC 1962 / Congo TM 30',''),
(5309,'Coordinate Reference System',3329,7302,'Pulkovo 42(58) / 3GK zn5',''),
(5310,'Coordinate Reference System',3840,7302,'Pulkovo 42(58) / 3GKzn10',''),
(5311,'Coordinate Reference System',3837,7302,'Pulkovo 42(58) / 3GK zn3',''),
(5312,'Coordinate Reference System',3838,7302,'Pulkovo 42(58) / 3GK zn4',''),
(5313,'Coordinate Reference System',3330,7302,'Pulkovo 42(58) / 3GK zn6',''),
(5314,'Coordinate Reference System',3331,7302,'Pulkovo 42(58) / 3GK zn7',''),
(5315,'Coordinate Reference System',3332,7302,'Pulkovo 42(58) / 3GK zn8',''),
(5316,'Coordinate Reference System',3839,7302,'Pulkovo 42(58) / 3GK zn9',''),
(5317,'Coordinate Reference System',3841,7302,'Pulkovo 42(83) / 3GK zn6',''),
(5318,'Coordinate Reference System',3833,7302,'Pulkovo 42(58) / GK zn 2',''),
(5319,'Coordinate Reference System',3333,7302,'Pulkovo 42(58) / GK zn 3',''),
(5320,'Coordinate Reference System',3334,7302,'Pulkovo 42(58) / GK zn 4',''),
(5321,'Coordinate Reference System',3335,7302,'Pulkovo 42(58) / GK zn 5',''),
(5322,'Coordinate Reference System',3842,7302,'Pulkovo 42(83) / 3GK zn7',''),
(5323,'Coordinate Reference System',3843,7302,'Pulkovo 42(83) / 3GK zn8',''),
(5324,'Coordinate Reference System',3834,7302,'Pulkovo 42(83) / GK zn 2',''),
(5325,'Coordinate Reference System',3835,7302,'Pulkovo 42(83) / GK zn 3',''),
(5326,'Coordinate Reference System',3836,7302,'Pulkovo 42(83) / GK zn 4',''),
(5327,'Coordinate Reference System',3779,7302,'NAD83(CSRS) / AB 3TM 111',''),
(5328,'Coordinate Reference System',3780,7302,'NAD83(CSRS) / AB 3TM 114',''),
(5329,'Coordinate Reference System',3781,7302,'NAD83(CSRS) / AB 3TM 117',''),
(5330,'Coordinate Reference System',3802,7302,'NAD83(CSRS) / AB 3TM 120',''),
(5331,'Coordinate Reference System',26891,7302,'NAD83(CSRS) / MTM zn 11',''),
(5332,'Coordinate Reference System',26892,7302,'NAD83(CSRS) / MTM zn 12',''),
(5333,'Coordinate Reference System',26893,7302,'NAD83(CSRS) / MTM zn 13',''),
(5334,'Coordinate Reference System',26894,7302,'NAD83(CSRS) / MTM zn 14',''),
(5335,'Coordinate Reference System',26895,7302,'NAD83(CSRS) / MTM zn 15',''),
(5336,'Coordinate Reference System',26896,7302,'NAD83(CSRS) / MTM zn 16',''),
(5337,'Coordinate Reference System',26897,7302,'NAD83(CSRS) / MTM zn 17',''),
(5338,'Coordinate Reference System',3799,7302,'NAD83(CSRS) / MTQ LCC',''),
(5339,'Coordinate Reference System',3581,7302,'NAD83(CSRS) / NWT LCC',''),
(5340,'Coordinate Reference System',3761,7302,'NAD83(CSRS) / UTM 22N',''),
(5341,'Coordinate Reference System',3579,7302,'NAD83(CSRS) / YT Albers',''),
(5342,'Coordinate Reference System',3441,7302,'NAD83(HARN) / AR N (ftUS)',''),
(5343,'Coordinate Reference System',3442,7302,'NAD83(HARN) / AR S (ftUS)',''),
(5344,'Coordinate Reference System',3760,7302,'NAD83(HARN) / HI 3 (ftUS)',''),
(5345,'Coordinate Reference System',3443,7302,'NAD83(HARN) / IL E (ftUS)',''),
(5346,'Coordinate Reference System',3444,7302,'NAD83(HARN) / IL W (ftUS)',''),
(5347,'Coordinate Reference System',3425,7302,'NAD83(HARN) / IA N (ftUS)',''),
(5348,'Coordinate Reference System',3426,7302,'NAD83(HARN) / IA S (ftUS)',''),
(5349,'Coordinate Reference System',3427,7302,'NAD83(HARN) / KS N (ftUS)',''),
(5350,'Coordinate Reference System',3428,7302,'NAD83(HARN) / KS S (ftUS)',''),
(5351,'Coordinate Reference System',3456,7302,'NAD83(HARN) / LA N (ftUS)',''),
(5352,'Coordinate Reference System',3457,7302,'NAD83(HARN) / LA S (ftUS)',''),
(5353,'Coordinate Reference System',26855,7302,'NAD83(HARN) / ME E (ftUS)',''),
(5354,'Coordinate Reference System',26856,7302,'NAD83(HARN) / ME W (ftUS)',''),
(5355,'Coordinate Reference System',3079,7302,'NAD83(HARN) / MI Georef',''),
(5356,'Coordinate Reference System',26858,7302,'NAD83(HARN) / MN C (ftUS)',''),
(5357,'Coordinate Reference System',26857,7302,'NAD83(HARN) / MN N (ftUS)',''),
(5358,'Coordinate Reference System',26859,7302,'NAD83(HARN) / MN S (ftUS)',''),
(5359,'Coordinate Reference System',26860,7302,'NAD83(HARN) / NE (ftUS)',''),
(5360,'Coordinate Reference System',3430,7302,'NAD83(HARN) / NV C (ftUS)',''),
(5361,'Coordinate Reference System',3429,7302,'NAD83(HARN) / NV E (ftUS)',''),
(5362,'Coordinate Reference System',3431,7302,'NAD83(HARN) / NV W (ftUS)',''),
(5363,'Coordinate Reference System',3445,7302,'NAD83(HARN) / NH (ftUS)',''),
(5364,'Coordinate Reference System',3432,7302,'NAD83(HARN) / NJ (ftUS)',''),
(5365,'Coordinate Reference System',3358,7302,'NAD83(HARN) / NC (m)',''),
(5366,'Coordinate Reference System',3404,7302,'NAD83(HARN) / NC (ftUS)',''),
(5367,'Coordinate Reference System',3753,7302,'NAD83(HARN) / OH N (ftUS)',''),
(5368,'Coordinate Reference System',3754,7302,'NAD83(HARN) / OH S (ftUS)',''),
(5369,'Coordinate Reference System',3362,7302,'NAD83(HARN) / PA N (m)',''),
(5370,'Coordinate Reference System',3363,7302,'NAD83(HARN) / PA N (ftUS)',''),
(5371,'Coordinate Reference System',3364,7302,'NAD83(HARN) / PA S (m)',''),
(5372,'Coordinate Reference System',3365,7302,'NAD83(HARN) / PA S (ftUS)',''),
(5373,'Coordinate Reference System',3446,7302,'NAD83(HARN) / RI (ftUS)',''),
(5374,'Coordinate Reference System',3360,7302,'NAD83(HARN) / SC (m)',''),
(5375,'Coordinate Reference System',3361,7302,'NAD83(HARN) / SC (ftUS)',''),
(5376,'Coordinate Reference System',3458,7302,'NAD83(HARN) / SD N (ftUS)',''),
(5377,'Coordinate Reference System',3459,7302,'NAD83(HARN) / SD S (ftUS)',''),
(5378,'Coordinate Reference System',3569,7302,'NAD83(HARN) / UT C (ftUS)',''),
(5379,'Coordinate Reference System',3568,7302,'NAD83(HARN) / UT N (ftUS)',''),
(5380,'Coordinate Reference System',3570,7302,'NAD83(HARN) / UT S (ftUS)',''),
(5381,'Coordinate Reference System',3740,7302,'NAD83(HARN) / UTM 10N',''),
(5382,'Coordinate Reference System',3741,7302,'NAD83(HARN) / UTM 11N',''),
(5383,'Coordinate Reference System',3742,7302,'NAD83(HARN) / UTM 12N',''),
(5384,'Coordinate Reference System',3743,7302,'NAD83(HARN) / UTM 13N',''),
(5385,'Coordinate Reference System',3744,7302,'NAD83(HARN) / UTM 14N',''),
(5386,'Coordinate Reference System',3745,7302,'NAD83(HARN) / UTM 15N',''),
(5387,'Coordinate Reference System',3746,7302,'NAD83(HARN) / UTM 16N',''),
(5388,'Coordinate Reference System',3747,7302,'NAD83(HARN) / UTM 17N',''),
(5389,'Coordinate Reference System',3748,7302,'NAD83(HARN) / UTM 18N',''),
(5390,'Coordinate Reference System',3749,7302,'NAD83(HARN) / UTM 19N',''),
(5391,'Coordinate Reference System',3750,7302,'NAD83(HARN) / UTM 4N',''),
(5392,'Coordinate Reference System',3751,7302,'NAD83(HARN) / UTM 5N',''),
(5393,'Coordinate Reference System',26861,7302,'NAD83(HARN) / WV N (ftUS)',''),
(5394,'Coordinate Reference System',26862,7302,'NAD83(HARN) / WV S (ftUS)',''),
(5395,'Coordinate Reference System',3755,7302,'NAD83(HARN) / WY E (ftUS)',''),
(5396,'Coordinate Reference System',3756,7302,'NAD83(HARN) / WY EC (ftUS)',''),
(5397,'Coordinate Reference System',3758,7302,'NAD83(HARN) / WY W (ftUS)',''),
(5398,'Coordinate Reference System',3757,7302,'NAD83(HARN) / WY WC (ftUS)',''),
(5399,'Coordinate Reference System',3757,7301,'NAD83(HPGN) / Wyoming West Central (ftUS)',''),
(5400,'Coordinate Reference System',3758,7301,'NAD83(HPGN) / Wyoming West (ftUS)',''),
(5401,'Coordinate Reference System',3756,7301,'NAD83(HPGN) / Wyoming East Central (ftUS)',''),
(5402,'Coordinate Reference System',3755,7301,'NAD83(HPGN) / Wyoming East (ftUS)',''),
(5403,'Coordinate Reference System',3754,7301,'NAD83(HPGN) / Ohio South (ftUS)',''),
(5404,'Coordinate Reference System',3753,7301,'NAD83(HPGN) / Ohio North (ftUS)',''),
(5405,'Coordinate Reference System',3336,7302,'Kerguelen 62 / UTM 42S',''),
(5406,'Coordinate Reference System',3337,7302,'Le Pouce 34 / Mauritius',''),
(5407,'Coordinate Reference System',3339,7302,'IGCB 1955 / Congo TM 12',''),
(5408,'Coordinate Reference System',3340,7302,'IGCB 1955 / Congo TM 14',''),
(5409,'Coordinate Reference System',3341,7302,'IGCB 1955 / Congo TM 16',''),
(5410,'Coordinate Reference System',3343,7302,'Mauritania 99 / UTM 28N',''),
(5411,'Coordinate Reference System',3344,7302,'Mauritania 99 / UTM 29N',''),
(5412,'Coordinate Reference System',3345,7302,'Mauritania 99 / UTM 30N',''),
(5413,'Coordinate Reference System',3350,7302,'Pulkovo 1942 / CS63 C0',''),
(5414,'Coordinate Reference System',3351,7302,'Pulkovo 1942 / CS63 C1',''),
(5415,'Coordinate Reference System',3352,7302,'Pulkovo 1942 / CS63 C2',''),
(5416,'Coordinate Reference System',3354,7302,'Mhast offshore / UTM 32S',''),
(5417,'Coordinate Reference System',3353,7302,'Mhast onshore / UTM 32S',''),
(5418,'Coordinate Reference System',3356,7302,'G Cayman 1959 / UTM 17N',''),
(5419,'Coordinate Reference System',3357,7302,'L Cayman 1961 / UTM 17N',''),
(5420,'Coordinate Reference System',3367,7302,'IGN Astro 1960 / UTM 28N',''),
(5421,'Coordinate Reference System',3368,7302,'IGN Astro 1960 / UTM 29N',''),
(5422,'Coordinate Reference System',3369,7302,'IGN Astro 1960 / UTM 30N',''),
(5423,'Coordinate Reference System',3376,7302,'GDM2000 / E Malaysia RSO',''),
(5424,'Coordinate Reference System',3378,7302,'GDM2000 / Melaka Grid',''),
(5425,'Coordinate Reference System',3381,7302,'GDM2000 / Terengganu',''),
(5426,'Coordinate Reference System',3383,7302,'GDM2000 / Kedah Grid',''),
(5427,'Coordinate Reference System',3388,7302,'Pulkovo 1942 / Caspian',''),
(5428,'Coordinate_Operation',4114,7302,'Johor Grid',''),
(5429,'Datum',1141,7302,'ITRF2008 (2005.0)',''),
(5430,'Coordinate_Operation',4321,7302,'Perak Revised Grid',''),
(5431,'Coordinate Reference System',3396,7302,'PD/83 / 3GK zone 3',''),
(5432,'Coordinate Reference System',3397,7302,'PD/83 / 3GK zone 4',''),
(5433,'Coordinate Reference System',3398,7302,'RD/83 / 3GK zone 4',''),
(5434,'Coordinate Reference System',3399,7302,'RD/83 / 3GK zone 5',''),
(5435,'Coordinate Reference System',3403,7302,'NAD83(CSRS) / AB 10TM R',''),
(5436,'Coordinate Reference System',3402,7302,'NAD83(CSRS) / AB 10TM F',''),
(5437,'Coordinate Reference System',3401,7302,'NAD83 / AB 10TM Resource',''),
(5438,'Coordinate Reference System',3400,7302,'NAD83 / AB 10TM Forest',''),
(5439,'Coordinate Reference System',3407,7302,'Hong Kong 1963 Grid',''),
(5440,'Coordinate Reference System',3411,7302,'NSIDC Sea Ice PS North',''),
(5441,'Coordinate Reference System',3412,7302,'NSIDC Sea Ice PS South',''),
(5442,'Coordinate Reference System',3413,7302,'WGS 84 / NSIDC PS North',''),
(5443,'Coordinate Reference System',3417,7302,'NAD83 / Iowa N (ftUS)',''),
(5444,'Coordinate Reference System',3418,7302,'NAD83 / Iowa S (ftUS)',''),
(5445,'Coordinate Reference System',3419,7302,'NAD83 / Kansas N (ftUS)',''),
(5446,'Coordinate Reference System',3420,7302,'NAD83 / Kansas S (ftUS)',''),
(5447,'Coordinate Reference System',3421,7302,'NAD83 / Nevada E (ftUS)',''),
(5448,'Coordinate Reference System',3422,7302,'NAD83 / Nevada C (ftUS)',''),
(5449,'Coordinate Reference System',3423,7302,'NAD83 / Nevada W (ftUS)',''),
(5450,'Coordinate_Operation',7807,7301,'IGS08 to NAD83(2011) (1)',''),
(5451,'Coordinate Reference System',3433,7302,'NAD83 / Arkansas N (ftUS)',''),
(5452,'Coordinate Reference System',3434,7302,'NAD83 / Arkansas S (ftUS)',''),
(5453,'Coordinate Reference System',3435,7302,'NAD83 / Illinois E (ftUS)',''),
(5454,'Coordinate Reference System',3436,7302,'NAD83 / Illinois W (ftUS)',''),
(5455,'Coordinate Reference System',3437,7302,'NAD83 / NH (ftUS)',''),
(5456,'Coordinate Reference System',3438,7302,'NAD83 / RI (ftUS)',''),
(5457,'Coordinate Reference System',3448,7302,'JAD2001 / JA Metric Grid',''),
(5458,'Coordinate Reference System',3451,7302,'NAD83 / Louisiana N (ftUS)',''),
(5459,'Coordinate Reference System',3452,7302,'NAD83 / Louisiana S (ftUS)',''),
(5460,'Coordinate Reference System',3453,7302,'NAD83 / LA Offshore (ftUS)',''),
(5461,'Coordinate Reference System',3454,7302,'NAD83 / S Dakota N ftUS',''),
(5462,'Coordinate Reference System',3455,7302,'NAD83 / S Dakota S (ftUS)',''),
(5463,'Coordinate Reference System',3460,7302,'Fiji 1986 / Map Grid',''),
(5464,'Coordinate Reference System',3461,7302,'Dabola 1981 / UTM 28N',''),
(5465,'Coordinate Reference System',3462,7302,'Dabola 1981 / UTM 29N',''),
(5466,'Coordinate Reference System',3560,7302,'NAD83 / Utah North (ftUS)',''),
(5467,'Coordinate Reference System',3566,7302,'NAD83 / Utah Cen (ftUS)',''),
(5468,'Coordinate Reference System',3567,7302,'NAD83 / Utah South (ftUS)',''),
(5469,'Coordinate Reference System',3571,7302,'WGS 84 / LAEA Bering Sea',''),
(5470,'Coordinate Reference System',3572,7302,'WGS 84 / LAEA Alaska',''),
(5471,'Coordinate Reference System',3573,7302,'WGS 84 / LAEA Canada',''),
(5472,'Coordinate Reference System',3574,7302,'WGS 84 / LAEA Atlantic',''),
(5473,'Coordinate Reference System',3575,7302,'WGS 84 / LAEA Europe',''),
(5474,'Coordinate Reference System',3576,7302,'WGS 84 / LAEA Russia',''),
(5475,'Coordinate Reference System',3577,7302,'GDA94 / Aus Albers',''),
(5476,'Coordinate Reference System',3706,7302,'NAD83(NSRS) / UTM 59N',''),
(5477,'Coordinate Reference System',3707,7302,'NAD83(NSRS) / UTM 60N',''),
(5478,'Coordinate Reference System',3708,7302,'NAD83(NSRS) / UTM 1N',''),
(5479,'Coordinate Reference System',3709,7302,'NAD83(NSRS) / UTM 2N',''),
(5480,'Coordinate Reference System',3710,7302,'NAD83(NSRS) / UTM 3N',''),
(5481,'Coordinate Reference System',3711,7302,'NAD83(NSRS) / UTM 4N',''),
(5482,'Coordinate Reference System',3712,7302,'NAD83(NSRS) / UTM 5N',''),
(5483,'Coordinate Reference System',3713,7302,'NAD83(NSRS) / UTM 6N',''),
(5484,'Coordinate Reference System',3714,7302,'NAD83(NSRS) / UTM 7N',''),
(5485,'Coordinate Reference System',3715,7302,'NAD83(NSRS) / UTM 8N',''),
(5486,'Coordinate Reference System',3716,7302,'NAD83(NSRS) / UTM 9N',''),
(5487,'Coordinate Reference System',3717,7302,'NAD83(NSRS) / UTM 10N',''),
(5488,'Coordinate Reference System',3718,7302,'NAD83(NSRS) / UTM 11N',''),
(5489,'Coordinate Reference System',3719,7302,'NAD83(NSRS) / UTM 12N',''),
(5490,'Coordinate Reference System',3720,7302,'NAD83(NSRS) / UTM 13N',''),
(5491,'Coordinate Reference System',3721,7302,'NAD83(NSRS) / UTM 14N',''),
(5492,'Coordinate Reference System',3722,7302,'NAD83(NSRS) / UTM 15N',''),
(5493,'Coordinate Reference System',3723,7302,'NAD83(NSRS) / UTM 16N',''),
(5494,'Coordinate Reference System',3724,7302,'NAD83(NSRS) / UTM 17N',''),
(5495,'Coordinate Reference System',3725,7302,'NAD83(NSRS) / UTM 18N',''),
(5496,'Coordinate Reference System',3726,7302,'NAD83(NSRS) / UTM 19N',''),
(5497,'Coordinate Reference System',3734,7302,'NAD83 / Ohio N (ftUS)',''),
(5498,'Coordinate Reference System',3735,7302,'NAD83 / Ohio S (ftUS)',''),
(5499,'Coordinate Reference System',3736,7302,'NAD83 / Wyoming E (ftUS)',''),
(5500,'Coordinate Reference System',3737,7302,'NAD83 / Wyoming EC (ftUS)',''),
(5501,'Coordinate Reference System',3738,7302,'NAD83 / Wyoming WC (ftUS)',''),
(5502,'Coordinate Reference System',3739,7302,'NAD83 / Wyoming W (ftUS)',''),
(5503,'Coordinate Reference System',3759,7302,'NAD83 / Hawaii 3 (ftUS)',''),
(5504,'Coordinate Reference System',3762,7302,'WGS 84 / S Georgia LCC',''),
(5505,'Coordinate Reference System',3764,7302,'NZGD2000 / CI Circuit',''),
(5506,'Coordinate Reference System',3771,7302,'NAD27 / Alberta 3TM 111',''),
(5507,'Coordinate Reference System',3772,7302,'NAD27 / Alberta 3TM 114',''),
(5508,'Coordinate Reference System',3773,7302,'NAD27 / Alberta 3TM 117',''),
(5509,'Coordinate Reference System',3800,7302,'NAD27 / Alberta 3TM 112',''),
(5510,'Coordinate Reference System',3775,7302,'NAD83 / Alberta 3TM 111',''),
(5511,'Coordinate Reference System',3776,7302,'NAD83 / Alberta 3TM 114',''),
(5512,'Coordinate Reference System',3777,7302,'NAD83 / Alberta 3TM 117',''),
(5513,'Coordinate Reference System',3801,7302,'NAD83 / Alberta 3TM 120',''),
(5514,'Coordinate Reference System',3783,7302,'Pitcairn 2006 / TM',''),
(5515,'Coordinate Reference System',3784,7302,'Pitcairn 1967 / UTM 9S',''),
(5516,'Coordinate Reference System',3785,7302,'Popular Vis CRS / Merc',''),
(5517,'Coordinate Reference System',3786,7302,'World Equidistant Cyl',''),
(5518,'Coordinate Reference System',3829,7302,'Hu Tzu Shan / UTM 51N',''),
(5519,'Coordinate Reference System',3845,7302,'SWEREF99 / RT90 7.5 gon V',''),
(5520,'Coordinate Reference System',3846,7302,'SWEREF99 / RT90 5 gon V',''),
(5521,'Coordinate Reference System',3847,7302,'SWEREF99 / RT90 2.5 gon V',''),
(5522,'Coordinate Reference System',3848,7302,'SWEREF99 / RT90 0 gon',''),
(5523,'Coordinate Reference System',3849,7302,'SWEREF99 / RT90 2.5 gon O',''),
(5524,'Coordinate Reference System',3850,7302,'SWEREF99 / RT90 5 gon O',''),
(5525,'Coordinate Reference System',3920,7302,'Puerto Rico / UTM 20N',''),
(5526,'Coordinate_Operation',4320,7302,'Kedah and Perlis Grid',''),
(5527,'Coordinate Reference System',5607,7302,'Bora Bora 2001 height',''),
(5528,'Datum',5202,7302,'Bora Bora 2001',''),
(5529,'Datum',5124,7302,'Fahud HD',''),
(5530,'Datum',5132,7302,'DNN',''),
(5531,'Coordinate Reference System',5733,7301,'Dansk Normal Nul height',''),
(5532,'Coordinate Reference System',5736,7302,'YS56 height',''),
(5533,'Coordinate Reference System',5737,7302,'YS85 height',''),
(5534,'Datum',5138,7302,'ODN Orkney',''),
(5535,'Coordinate Reference System',5753,7301,'Nivellement General de Nouvelle Caledonie',''),
(5536,'Coordinate Reference System',5755,7301,'Nivellement General Guyanais 1977',''),
(5537,'Coordinate Reference System',20436,7302,'Ain el Abd / UTM 36N',''),
(5538,'Coordinate Reference System',20440,7302,'Ain el Abd / UTM 40N',''),
(5539,'Coordinate Reference System',20791,7302,'DLx','The same abbreviation is is also used for Lisbon / Portuguese Grid New (CRS code 5018).'),
(5540,'Coordinate Reference System',21453,7302,'Beijing 1954 / GK CM 75E',''),
(5541,'Coordinate Reference System',21454,7302,'Beijing 1954 / GK CM 81E',''),
(5542,'Coordinate Reference System',21455,7302,'Beijing 1954 / GK CM 87E',''),
(5543,'Coordinate Reference System',21456,7302,'Beijing 1954 / GK CM 93E',''),
(5544,'Coordinate Reference System',21457,7302,'Beijing 1954 / GK CM 99E',''),
(5545,'Coordinate Reference System',21458,7302,'Beijing 1954 / GK CM 105E',''),
(5546,'Coordinate Reference System',21459,7302,'Beijing 1954 / GK CM 111E',''),
(5547,'Coordinate Reference System',21460,7302,'Beijing 1954 / GK CM 117E',''),
(5548,'Coordinate Reference System',21461,7302,'Beijing 1954 / GK CM 123E',''),
(5549,'Coordinate Reference System',21462,7302,'Beijing 1954 / GK CM 129E',''),
(5550,'Coordinate Reference System',21463,7302,'Beijing 1954 / GK CM 135E',''),
(5551,'Coordinate Reference System',21818,7302,'Bogota 1975 / UTM 18N',''),
(5552,'Coordinate Reference System',22521,7302,'Corrego Alegre / UTM 21S',''),
(5553,'Coordinate Reference System',22522,7302,'Corrego Alegre / UTM 22S',''),
(5554,'Coordinate Reference System',22525,7302,'Corrego Alegre / UTM 25S',''),
(5555,'Coordinate Reference System',23830,7302,'DGN95 / Indonesia 46.2',''),
(5556,'Coordinate Reference System',23831,7302,'DGN95 / Indonesia 47.1',''),
(5557,'Coordinate Reference System',23832,7302,'DGN95 / Indonesia 47.2',''),
(5558,'Coordinate Reference System',23833,7302,'DGN95 / Indonesia 48.1',''),
(5559,'Coordinate Reference System',23834,7302,'DGN95 / Indonesia 48.2',''),
(5560,'Coordinate Reference System',23835,7302,'DGN95 / Indonesia 49.1',''),
(5561,'Coordinate Reference System',23836,7302,'DGN95 / Indonesia 49.2',''),
(5562,'Coordinate Reference System',23837,7302,'DGN95 / Indonesia 50.1',''),
(5563,'Coordinate Reference System',23838,7302,'DGN95 / Indonesia 50.2',''),
(5564,'Coordinate Reference System',23839,7302,'DGN95 / Indonesia 51.1',''),
(5565,'Coordinate Reference System',23840,7302,'DGN95 / Indonesia 51.2',''),
(5566,'Coordinate Reference System',23841,7302,'DGN95 / Indonesia 52.1',''),
(5567,'Coordinate Reference System',23842,7302,'DGN95 / Indonesia 52.2',''),
(5568,'Coordinate Reference System',23843,7302,'DGN95 / Indonesia 53.1',''),
(5569,'Coordinate Reference System',23844,7302,'DGN95 / Indonesia 53.2',''),
(5570,'Coordinate Reference System',23845,7302,'DGN95 / Indonesia 54.1',''),
(5571,'Coordinate Reference System',26847,7302,'NAD83 / Maine E (ftUS)',''),
(5572,'Coordinate Reference System',26848,7302,'NAD83 / Maine W (ftUS)',''),
(5573,'Coordinate Reference System',26849,7302,'NAD83 / Minnesota N (ftUS)',''),
(5574,'Coordinate Reference System',26850,7302,'NAD83 / Minnesota C (ftUS)',''),
(5575,'Coordinate Reference System',26851,7302,'NAD83 / Minnesota S (ftUS)',''),
(5576,'Coordinate Reference System',26853,7302,'NAD83 / WV North (ftUS)',''),
(5577,'Coordinate Reference System',26854,7302,'NAD83 / WV South (ftUS)',''),
(5578,'Coordinate Reference System',27037,7302,'Nahrwan 1967 / UTM 37N',''),
(5579,'Coordinate Reference System',27205,7302,'NZGD49 / Mount Eden',''),
(5580,'Coordinate Reference System',27206,7302,'NZGD49 / Bay of Plenty',''),
(5581,'Coordinate Reference System',27207,7302,'NZGD49 / Poverty Bay',''),
(5582,'Coordinate Reference System',27208,7302,'NZGD49 / Hawkes Bay',''),
(5583,'Coordinate Reference System',27209,7302,'NZGD49 / Taranaki',''),
(5584,'Coordinate Reference System',27210,7302,'NZGD49 / Tuhirangi',''),
(5585,'Coordinate Reference System',27211,7302,'NZGD49 / Wanganui',''),
(5586,'Coordinate Reference System',27212,7302,'NZGD49 / Wairarapa',''),
(5587,'Coordinate Reference System',27213,7302,'NZGD49 / Wellington',''),
(5588,'Coordinate Reference System',27214,7302,'NZGD49 / Collingwood',''),
(5589,'Coordinate Reference System',27220,7302,'NZGD49 / Marlborough',''),
(5590,'Coordinate Reference System',27221,7302,'NZGD49 / Hokitika',''),
(5591,'Coordinate Reference System',27223,7302,'NZGD49 / Jacksons Bay',''),
(5592,'Coordinate Reference System',27224,7302,'NZGD49 / Mount Pleasant',''),
(5593,'Coordinate Reference System',27227,7302,'NZGD49 / Lindis Peak',''),
(5594,'Coordinate Reference System',27228,7302,'NZGD49 / Mount Nicholas',''),
(5595,'Coordinate Reference System',27229,7302,'NZGD49 / Mount York',''),
(5596,'Coordinate Reference System',27230,7302,'NZGD49 / Observation Pt',''),
(5597,'Coordinate Reference System',27231,7302,'NZGD49 / North Taieri',''),
(5598,'Coordinate Reference System',27493,7302,'Datum 73 / Modified Grid',''),
(5599,'Coordinate Reference System',28404,7302,'Pulkovo 1942 / GK zone 4',''),
(5600,'Coordinate Reference System',28405,7302,'Pulkovo 1942 / GK zone 5',''),
(5601,'Coordinate Reference System',29901,7302,'OSNI 52 / Irish Nat Grid',''),
(5602,'Coordinate Reference System',30179,7302,'Tokyo / Japan zone XIX',''),
(5603,'Coordinate Reference System',30493,7302,'Voirol79 / N Algeria old',''),
(5604,'Coordinate Reference System',30494,7302,'Voirol79 / S Algeria old',''),
(5605,'Coordinate Reference System',31251,7302,'MGI (Ferro) / Aut GK W',''),
(5606,'Coordinate Reference System',31252,7302,'MGI (Ferro) / Aut GK C',''),
(5607,'Coordinate Reference System',31253,7302,'MGI (Ferro) / Aut GK E',''),
(5608,'Coordinate Reference System',31466,7302,'DHDN / 3GK zone 2',''),
(5609,'Coordinate Reference System',31467,7302,'DHDN / 3GK zone 3',''),
(5610,'Coordinate Reference System',31468,7302,'DHDN / 3GK zone 4',''),
(5611,'Coordinate Reference System',31469,7302,'DHDN / 3GK zone 5',''),
(5612,'Coordinate Reference System',31528,7302,'Conakry 1905 / UTM 28N',''),
(5613,'Coordinate Reference System',31529,7302,'Conakry 1905 / UTM 29N',''),
(5614,'Coordinate Reference System',31965,7302,'SIRGAS 2000 / UTM 11N',''),
(5615,'Coordinate Reference System',31966,7302,'SIRGAS 2000 / UTM 12N',''),
(5616,'Coordinate Reference System',31967,7302,'SIRGAS 2000 / UTM 13N',''),
(5617,'Coordinate Reference System',31968,7302,'SIRGAS 2000 / UTM 14N',''),
(5618,'Coordinate Reference System',31969,7302,'SIRGAS 2000 / UTM 15N',''),
(5619,'Coordinate Reference System',31970,7302,'SIRGAS 2000 / UTM 16N',''),
(5620,'Coordinate Reference System',31971,7302,'SIRGAS 2000 / UTM 17N',''),
(5621,'Coordinate Reference System',31972,7302,'SIRGAS 2000 / UTM 18N',''),
(5622,'Coordinate Reference System',31973,7302,'SIRGAS 2000 / UTM 19N',''),
(5623,'Coordinate Reference System',31974,7302,'SIRGAS 2000 / UTM 20N',''),
(5624,'Coordinate Reference System',31975,7302,'SIRGAS 2000 / UTM 21N',''),
(5625,'Coordinate Reference System',31976,7302,'SIRGAS 2000 / UTM 22N',''),
(5626,'Coordinate Reference System',31977,7302,'SIRGAS 2000 / UTM 17S',''),
(5627,'Coordinate Reference System',31978,7302,'SIRGAS 2000 / UTM 18S',''),
(5628,'Coordinate Reference System',31979,7302,'SIRGAS 2000 / UTM 19S',''),
(5629,'Coordinate Reference System',31980,7302,'SIRGAS 2000 / UTM 20S',''),
(5630,'Coordinate Reference System',31981,7302,'SIRGAS 2000 / UTM 21S',''),
(5631,'Coordinate Reference System',31982,7302,'SIRGAS 2000 / UTM 22S',''),
(5632,'Coordinate Reference System',31983,7302,'SIRGAS 2000 / UTM 23S',''),
(5633,'Coordinate Reference System',31984,7302,'SIRGAS 2000 / UTM 24S',''),
(5634,'Coordinate Reference System',31985,7302,'SIRGAS 2000 / UTM 25S',''),
(5635,'Coordinate Reference System',32099,7302,'NAD27 / Louisiana Off',''),
(5636,'Coordinate Reference System',32199,7302,'NAD83 / Louisiana Off m',''),
(5637,'Coordinate Reference System',32600,7302,'WGS 84 / UTM system N',''),
(5638,'Coordinate Reference System',32700,7302,'WGS 84 / UTM system S',''),
(5639,'Coordinate Reference System',32663,7302,'WGS 84 / Equidistant Cyl',''),
(5640,'Coordinate Reference System',3465,7302,'NAD83(NSRS) / AL E (m)',''),
(5641,'Coordinate Reference System',3466,7302,'NAD83(NSRS) / AL W (m)',''),
(5642,'Coordinate Reference System',3484,7302,'NAD83(NSRS) / AR N (m)',''),
(5643,'Coordinate Reference System',3485,7302,'NAD83(NSRS) / AR N (ftUS)',''),
(5644,'Coordinate Reference System',3486,7302,'NAD83(NSRS) / AR S (m)',''),
(5645,'Coordinate Reference System',3487,7302,'NAD83(NSRS) / AR S (ftUS)',''),
(5646,'Coordinate Reference System',3479,7302,'NAD83(NSRS) / AZ C (ft)',''),
(5647,'Coordinate Reference System',3478,7302,'NAD83(NSRS) / AZ C (m)',''),
(5648,'Coordinate Reference System',3481,7302,'NAD83(NSRS) / AZ E (ft)',''),
(5649,'Coordinate Reference System',3480,7302,'NAD83(NSRS) / AZ E (m)',''),
(5650,'Coordinate Reference System',3483,7302,'NAD83(NSRS) / AZ W (ft)',''),
(5651,'Coordinate Reference System',3482,7302,'NAD83(NSRS) / AZ W (m)',''),
(5652,'Coordinate Reference System',3489,7302,'NAD83(NSRS) / CA 1 (m)',''),
(5653,'Coordinate Reference System',3490,7302,'NAD83(NSRS) / CA 1 (ftUS)',''),
(5654,'Coordinate Reference System',3491,7302,'NAD83(NSRS) / CA 2 (m)',''),
(5655,'Coordinate Reference System',3492,7302,'NAD83(NSRS) / CA 2 (ftUS)',''),
(5656,'Coordinate Reference System',3493,7302,'NAD83(NSRS) / CA 3 (m)',''),
(5657,'Coordinate Reference System',3494,7302,'NAD83(NSRS) / CA 3 (ftUS)',''),
(5658,'Coordinate Reference System',3495,7302,'NAD83(NSRS) / CA 4 (m)',''),
(5659,'Coordinate Reference System',3496,7302,'NAD83(NSRS) / CA 4 (ftUS)',''),
(5660,'Coordinate Reference System',3497,7302,'NAD83(NSRS) / CA 5 (m)',''),
(5661,'Coordinate Reference System',3498,7302,'NAD83(NSRS) / CA 5 (ftUS)',''),
(5662,'Coordinate Reference System',3499,7302,'NAD83(NSRS) / CA 6 (m)',''),
(5663,'Coordinate Reference System',3500,7302,'NAD83(NSRS) / CA 6 (ftUS)',''),
(5664,'Coordinate Reference System',3488,7302,'NAD83(NSRS) / CA Albers',''),
(5665,'Coordinate Reference System',3501,7302,'NAD83(NSRS) / CO C (m)',''),
(5666,'Coordinate Reference System',3502,7302,'NAD83(NSRS) / CO C (ftUS)',''),
(5667,'Coordinate Reference System',3503,7302,'NAD83(NSRS) / CO N (m)',''),
(5668,'Coordinate Reference System',3504,7302,'NAD83(NSRS) / CO N (ftUS)',''),
(5669,'Coordinate Reference System',3505,7302,'NAD83(NSRS) / CO S (m)',''),
(5670,'Coordinate Reference System',3506,7302,'NAD83(NSRS) / CO S (ftUS)',''),
(5671,'Coordinate Reference System',3508,7302,'NAD83(NSRS) / CT (ftUS)',''),
(5672,'Coordinate Reference System',3507,7302,'NAD83(NSRS) / CT (m)',''),
(5673,'Coordinate Reference System',3510,7302,'NAD83(NSRS) / DE (ftUS)',''),
(5674,'Coordinate Reference System',3511,7302,'NAD83(NSRS) / FL E (m)',''),
(5675,'Coordinate Reference System',3512,7302,'NAD83(NSRS) / FL E (ftUS)',''),
(5676,'Coordinate Reference System',3513,7302,'NAD83(NSRS) / FL GDL AEA',''),
(5677,'Coordinate Reference System',3514,7302,'NAD83(NSRS) / FL N (m)',''),
(5678,'Coordinate Reference System',3515,7302,'NAD83(NSRS) / FL N (ftUS)',''),
(5679,'Coordinate Reference System',3516,7302,'NAD83(NSRS) / FL W (m)',''),
(5680,'Coordinate Reference System',3517,7302,'NAD83(NSRS) / FL W (ftUS)',''),
(5681,'Coordinate Reference System',3518,7302,'NAD83(NSRS) / GA E (m)',''),
(5682,'Coordinate Reference System',3519,7302,'NAD83(NSRS) / GA E (ftUS)',''),
(5683,'Coordinate Reference System',3520,7302,'NAD83(NSRS) / GA W (m)',''),
(5684,'Coordinate Reference System',3521,7302,'NAD83(NSRS) / GA W (ftUS)',''),
(5685,'Coordinate Reference System',3537,7302,'NAD83(NSRS) / IA N (ftUS)',''),
(5686,'Coordinate Reference System',3539,7302,'NAD83(NSRS) / IA S (ftUS)',''),
(5687,'Coordinate Reference System',3522,7302,'NAD83(NSRS) / ID C (m)',''),
(5688,'Coordinate Reference System',3523,7302,'NAD83(NSRS) / ID C (ftUS)',''),
(5689,'Coordinate Reference System',3525,7302,'NAD83(NSRS) / ID E (ftUS)',''),
(5690,'Coordinate Reference System',3527,7302,'NAD83(NSRS) / ID W (ftUS)',''),
(5691,'Coordinate Reference System',3528,7302,'NAD83(NSRS) / IL E (m)',''),
(5692,'Coordinate Reference System',3529,7302,'NAD83(NSRS) / IL E (ftUS)',''),
(5693,'Coordinate Reference System',3530,7302,'NAD83(NSRS) / IL W (m)',''),
(5694,'Coordinate Reference System',3531,7302,'NAD83(NSRS) / IL W (ftUS)',''),
(5695,'Coordinate Reference System',3532,7302,'NAD83(NSRS) / IN E (m)',''),
(5696,'Coordinate Reference System',3533,7302,'NAD83(NSRS) / IN E (ftUS)',''),
(5697,'Coordinate Reference System',3534,7302,'NAD83(NSRS) / IN W (m)',''),
(5698,'Coordinate Reference System',3535,7302,'NAD83(NSRS) / IN W (ftUS)',''),
(5699,'Coordinate Reference System',3540,7302,'NAD83(NSRS) / KS N (m)',''),
(5700,'Coordinate Reference System',3541,7302,'NAD83(NSRS) / KS N (ftUS)',''),
(5701,'Coordinate Reference System',3542,7302,'NAD83(NSRS) / KS S (m)',''),
(5702,'Coordinate Reference System',3543,7302,'NAD83(NSRS) / KS S (ftUS)',''),
(5703,'Coordinate Reference System',3544,7302,'NAD83(NSRS) / KY N (m)',''),
(5704,'Coordinate Reference System',3545,7302,'NAD83(NSRS) / KY N (ftUS)',''),
(5705,'Coordinate Reference System',3548,7302,'NAD83(NSRS) / KY S (m)',''),
(5706,'Coordinate Reference System',3549,7302,'NAD83(NSRS) / KY S (ftUS)',''),
(5707,'Coordinate Reference System',3546,7302,'NAD83(NSRS) / KY1Z (m)',''),
(5708,'Coordinate_Operation',4323,7302,'Kelantan Grid',''),
(5709,'Coordinate Reference System',3550,7302,'NAD83(NSRS) / LA N (m)',''),
(5710,'Coordinate Reference System',3551,7302,'NAD83(NSRS) / LA N (ftUS)',''),
(5711,'Coordinate Reference System',3552,7302,'NAD83(NSRS) / LA S (m)',''),
(5712,'Coordinate Reference System',3553,7302,'NAD83(NSRS) / LA S (ftUS)',''),
(5713,'Coordinate Reference System',3583,7302,'NAD83(NSRS) / MA Is (m)',''),
(5714,'Coordinate Reference System',3584,7302,'NAD83(NSRS) / MA Is (ftUS)',''),
(5715,'Coordinate Reference System',3585,7302,'NAD83(NSRS) / MA md (m)',''),
(5716,'Coordinate Reference System',3586,7302,'NAD83(NSRS) / MA md (ftUS)',''),
(5717,'Coordinate Reference System',3582,7302,'NAD83(NSRS) / MD (ftUS)',''),
(5718,'Coordinate Reference System',3554,7302,'NAD83(NSRS) / ME 2000 C',''),
(5719,'Coordinate Reference System',3555,7302,'NAD83(NSRS) / ME 2000 E',''),
(5720,'Coordinate Reference System',3556,7302,'NAD83(NSRS) / ME 2000 W',''),
(5721,'Coordinate Reference System',3557,7302,'NAD83(NSRS) / ME83 E (m)',''),
(5722,'Coordinate Reference System',26863,7302,'NAD83(NSRS) / ME E (ftUS)',''),
(5723,'Coordinate Reference System',3558,7302,'NAD83(NSRS) / ME83 W (m)',''),
(5724,'Coordinate Reference System',26864,7302,'NAD83(NSRS) / ME W (ftUS)',''),
(5725,'Coordinate Reference System',3588,7302,'NAD83(NSRS) / MI C (ft)',''),
(5726,'Coordinate Reference System',3587,7302,'NAD83(NSRS) / MI C (m)',''),
(5727,'Coordinate Reference System',3591,7302,'NAD83(NSRS) / MI Georef',''),
(5728,'Coordinate Reference System',3590,7302,'NAD83(NSRS) / MI N (ft)',''),
(5729,'Coordinate Reference System',3589,7302,'NAD83(NSRS) / MI N (m)',''),
(5730,'Coordinate Reference System',3593,7302,'NAD83(NSRS) / MI S (ft)',''),
(5731,'Coordinate Reference System',3592,7302,'NAD83(NSRS) / MI S (m)',''),
(5732,'Coordinate Reference System',3594,7302,'NAD83(NSRS) / MN C (m)',''),
(5733,'Coordinate Reference System',26866,7302,'NAD83(NSRS) / MN C (ftUS)',''),
(5734,'Coordinate Reference System',3595,7302,'NAD83(NSRS) / MN N (m)',''),
(5735,'Coordinate Reference System',26865,7302,'NAD83(NSRS) / MN N (ftUS)',''),
(5736,'Coordinate Reference System',3596,7302,'NAD83(NSRS) / MN S (m)',''),
(5737,'Coordinate Reference System',26867,7302,'NAD83(NSRS) / MN S (ftUS)',''),
(5738,'Coordinate Reference System',3601,7302,'NAD83(NSRS) / MO C (m)',''),
(5739,'Coordinate Reference System',3602,7302,'NAD83(NSRS) / MO E (m)',''),
(5740,'Coordinate Reference System',3603,7302,'NAD83(NSRS) / MO W (m)',''),
(5741,'Coordinate Reference System',3597,7302,'NAD83(NSRS) / MS E (m)',''),
(5742,'Coordinate Reference System',3598,7302,'NAD83(NSRS) / MS E (ftUS)',''),
(5743,'Coordinate Reference System',3599,7302,'NAD83(NSRS) / MS W (m)',''),
(5744,'Coordinate Reference System',3600,7302,'NAD83(NSRS) / MS W (ftUS)',''),
(5745,'Coordinate Reference System',3816,7302,'NAD83(NSRS) / MSTM',''),
(5746,'Coordinate Reference System',3605,7302,'NAD83(NSRS) / MT (ft)',''),
(5747,'Coordinate Reference System',3632,7302,'NAD83(NSRS) / NC (ftUS)',''),
(5748,'Coordinate Reference System',3631,7302,'NAD83(NSRS) / NC (m)',''),
(5749,'Coordinate Reference System',3634,7302,'NAD83(NSRS) / ND N (ft)',''),
(5750,'Coordinate Reference System',3633,7302,'NAD83(NSRS) / ND N (m)',''),
(5751,'Coordinate Reference System',3636,7302,'NAD83(NSRS) / ND S (ft)',''),
(5752,'Coordinate Reference System',3635,7302,'NAD83(NSRS) / ND S (m)',''),
(5753,'Coordinate Reference System',26868,7302,'NAD83(NSRS) / NE (ftUS)',''),
(5754,'Coordinate Reference System',3606,7302,'NAD83(NSRS) / NE (m)',''),
(5755,'Coordinate Reference System',3614,7302,'NAD83(NSRS) / NH (ftUS)',''),
(5756,'Coordinate Reference System',3613,7302,'NAD83(NSRS) / NH (m)',''),
(5757,'Coordinate Reference System',3616,7302,'NAD83(NSRS) / NJ (ftUS)',''),
(5758,'Coordinate Reference System',3617,7302,'NAD83(NSRS) / NM C (m)',''),
(5759,'Coordinate Reference System',3618,7302,'NAD83(NSRS) / NM C (ftUS)',''),
(5760,'Coordinate Reference System',3619,7302,'NAD83(NSRS) / NM E (m)',''),
(5761,'Coordinate Reference System',3620,7302,'NAD83(NSRS) / NM E (ftUS)',''),
(5762,'Coordinate Reference System',3621,7302,'NAD83(NSRS) / NM W (m)',''),
(5763,'Coordinate Reference System',3622,7302,'NAD83(NSRS) / NM W (ftUS)',''),
(5764,'Coordinate Reference System',3607,7302,'NAD83(NSRS) / NV C (m)',''),
(5765,'Coordinate Reference System',3608,7302,'NAD83(NSRS) / NV C (ftUS)',''),
(5766,'Coordinate Reference System',3609,7302,'NAD83(NSRS) / NV E (m)',''),
(5767,'Coordinate Reference System',3610,7302,'NAD83(NSRS) / NV E (ftUS)',''),
(5768,'Coordinate Reference System',3611,7302,'NAD83(NSRS) / NV W (m)',''),
(5769,'Coordinate Reference System',3612,7302,'NAD83(NSRS) / NV W (ftUS)',''),
(5770,'Coordinate Reference System',3623,7302,'NAD83(NSRS) / NY C (m)',''),
(5771,'Coordinate Reference System',3624,7302,'NAD83(NSRS) / NY C (ftUS)',''),
(5772,'Coordinate Reference System',3625,7302,'NAD83(NSRS) / NY E (m)',''),
(5773,'Coordinate Reference System',3626,7302,'NAD83(NSRS) / NY E (ftUS)',''),
(5774,'Coordinate Reference System',3627,7302,'NAD83(NSRS) / NY LI (m)',''),
(5775,'Coordinate Reference System',3628,7302,'NAD83(NSRS) / NY LI (ftUS)',''),
(5776,'Coordinate Reference System',3629,7302,'NAD83(NSRS) / NY W (m)',''),
(5777,'Coordinate Reference System',3630,7302,'NAD83(NSRS) / NY W (ftUS)',''),
(5778,'Coordinate Reference System',3728,7302,'NAD83(NSRS) / OH N (ftUS)',''),
(5779,'Coordinate Reference System',3729,7302,'NAD83(NSRS) / OH S (ftUS)',''),
(5780,'Coordinate Reference System',3639,7302,'NAD83(NSRS) / OK N (m)',''),
(5781,'Coordinate Reference System',3640,7302,'NAD83(NSRS) / OK N (ftUS)',''),
(5782,'Coordinate Reference System',3641,7302,'NAD83(NSRS) / OK S (m)',''),
(5783,'Coordinate Reference System',3642,7302,'NAD83(NSRS) / OK S (ftUS)',''),
(5784,'Coordinate Reference System',3646,7302,'NAD83(NSRS) / OR N (ft)',''),
(5785,'Coordinate Reference System',3645,7302,'NAD83(NSRS) / OR N (m)',''),
(5786,'Coordinate Reference System',3648,7302,'NAD83(NSRS) / OR S (ft)',''),
(5787,'Coordinate Reference System',3647,7302,'NAD83(NSRS) / OR S (m)',''),
(5788,'Coordinate Reference System',3644,7302,'NAD83(2007) / OR GIC Lam (ft)',''),
(5789,'Coordinate_Operation',4116,7302,'Pahang Grid',''),
(5790,'Coordinate Reference System',3649,7302,'NAD83(NSRS) / PA N (m)',''),
(5791,'Coordinate Reference System',3650,7302,'NAD83(NSRS) / PA N (ftUS)',''),
(5792,'Coordinate Reference System',3651,7302,'NAD83(NSRS) / PA S (m)',''),
(5793,'Coordinate Reference System',3652,7302,'NAD83(NSRS) / PA S (ftUS)',''),
(5794,'Coordinate Reference System',3654,7302,'NAD83(NSRS) / RI (ftUS)',''),
(5795,'Coordinate Reference System',3653,7302,'NAD83(NSRS) / RI (m)',''),
(5796,'Coordinate Reference System',3656,7302,'NAD83(NSRS) / SC (ft)',''),
(5797,'Coordinate Reference System',3655,7302,'NAD83(NSRS) / SC (m)',''),
(5798,'Coordinate Reference System',3657,7302,'NAD83(NSRS) / SD N (m)',''),
(5799,'Coordinate Reference System',3658,7302,'NAD83(NSRS) / SD N (ftUS)',''),
(5800,'Coordinate Reference System',3659,7302,'NAD83(NSRS) / SD S (m)',''),
(5801,'Coordinate Reference System',3660,7302,'NAD83(NSRS) / SD S (ftUS)',''),
(5802,'Coordinate Reference System',3662,7302,'NAD83(NSRS) / TN (ftUS)',''),
(5803,'Coordinate Reference System',3663,7302,'NAD83(NSRS) / TX C (m)',''),
(5804,'Coordinate Reference System',3664,7302,'NAD83(NSRS) / TX C ftUS',''),
(5805,'Coordinate Reference System',3667,7302,'NAD83(NSRS) / TX N (m)',''),
(5806,'Coordinate Reference System',3668,7302,'NAD83(NSRS) / TX N ftUS',''),
(5807,'Coordinate Reference System',3669,7302,'NAD83(NSRS) / TX NC (m)',''),
(5808,'Coordinate Reference System',3670,7302,'NAD83(NSRS) / TX NC ftUS',''),
(5809,'Coordinate Reference System',3671,7302,'NAD83(NSRS) / TX S (m)',''),
(5810,'Coordinate Reference System',3672,7302,'NAD83(NSRS) / TX S ftUS',''),
(5811,'Coordinate Reference System',3673,7302,'NAD83(NSRS) / TX SC (m)',''),
(5812,'Coordinate Reference System',3674,7302,'NAD83(NSRS) / TX SC ftUS',''),
(5813,'Coordinate Reference System',3676,7302,'NAD83(NSRS) / UT C (ft)',''),
(5814,'Coordinate Reference System',3675,7302,'NAD83(NSRS) / UT C (m)',''),
(5815,'Coordinate Reference System',3677,7302,'NAD83(NSRS) / UT C (ftUS)',''),
(5816,'Coordinate Reference System',3679,7302,'NAD83(NSRS) / UT N (ft)',''),
(5817,'Coordinate Reference System',3680,7302,'NAD83(NSRS) / UT N (ftUS)',''),
(5818,'Coordinate Reference System',3682,7302,'NAD83(NSRS) / UT S (ft)',''),
(5819,'Coordinate Reference System',3683,7302,'NAD83(NSRS) / UT S (ftUS)',''),
(5820,'Coordinate Reference System',3685,7302,'NAD83(NSRS) / VA N (m)',''),
(5821,'Coordinate Reference System',3686,7302,'NAD83(NSRS) / VA N (ftUS)',''),
(5822,'Coordinate Reference System',3687,7302,'NAD83(NSRS) / VA S (m)',''),
(5823,'Coordinate Reference System',3688,7302,'NAD83(NSRS) / VA S (ftUS)',''),
(5824,'Coordinate Reference System',3689,7302,'NAD83(NSRS) / WA N (m)',''),
(5825,'Coordinate Reference System',3690,7302,'NAD83(NSRS) / WA N (ftUS)',''),
(5826,'Coordinate Reference System',3691,7302,'NAD83(NSRS) / WA S (m)',''),
(5827,'Coordinate Reference System',3692,7302,'NAD83(NSRS) / WA S (ftUS)',''),
(5828,'Coordinate Reference System',3695,7302,'NAD83(NSRS) / WI C (m)',''),
(5829,'Coordinate Reference System',3696,7302,'NAD83(NSRS) / WI C (ftUS)',''),
(5830,'Coordinate Reference System',3697,7302,'NAD83(NSRS) / WI N (m)',''),
(5831,'Coordinate Reference System',3698,7302,'NAD83(NSRS) / WI N (ftUS)',''),
(5832,'Coordinate Reference System',3699,7302,'NAD83(NSRS) / WI S (m)',''),
(5833,'Coordinate Reference System',3700,7302,'NAD83(NSRS) / WI S (ftUS)',''),
(5834,'Coordinate Reference System',3701,7302,'NAD83(NSRS) / WTM 83',''),
(5835,'Coordinate Reference System',3693,7302,'NAD83(NSRS) / WV N (m)',''),
(5836,'Coordinate Reference System',26869,7302,'NAD83(NSRS) / WV N (ftUS)',''),
(5837,'Coordinate Reference System',3694,7302,'NAD83(NSRS) / WV S (m)',''),
(5838,'Coordinate Reference System',26870,7302,'NAD83(NSRS) / WV S (ftUS)',''),
(5839,'Coordinate Reference System',3702,7302,'NAD83(NSRS) / WY E (m)',''),
(5840,'Coordinate Reference System',3730,7302,'NAD83(NSRS) / WY E (ftUS)',''),
(5841,'Coordinate Reference System',3703,7302,'NAD83(NSRS) / WY EC (m)',''),
(5842,'Coordinate Reference System',3731,7302,'NAD83(NSRS) / WY EC (ftUS)',''),
(5843,'Coordinate Reference System',3705,7302,'NAD83(NSRS) / WY W (m)',''),
(5844,'Coordinate Reference System',3733,7302,'NAD83(NSRS) / WY W (ftUS)',''),
(5845,'Coordinate Reference System',3704,7302,'NAD83(NSRS) / WY WC (m)',''),
(5846,'Coordinate Reference System',3732,7302,'NAD83(NSRS) / WY WC (ftUS)',''),
(5847,'Coordinate Reference System',3467,7302,'NAD83(NSRS) / AK Alb',''),
(5848,'Coordinate Reference System',3468,7302,'NAD83(NSRS) / AK 1 (m)',''),
(5849,'Coordinate Reference System',3469,7302,'NAD83(NSRS) / AK 2 (m)',''),
(5850,'Coordinate Reference System',3470,7302,'NAD83(NSRS) / AK 3 (m)',''),
(5851,'Coordinate Reference System',3471,7302,'NAD83(NSRS) / AK 4 (m)',''),
(5852,'Coordinate Reference System',3472,7302,'NAD83(NSRS) / AK 5 (m)',''),
(5853,'Coordinate Reference System',3473,7302,'NAD83(NSRS) / AK 6 (m)',''),
(5854,'Coordinate Reference System',3474,7302,'NAD83(NSRS) / AK 7 (m)',''),
(5855,'Coordinate Reference System',3475,7302,'NAD83(NSRS) / AK 8 (m)',''),
(5856,'Coordinate Reference System',3476,7302,'NAD83(NSRS) / AK 9 (m)',''),
(5857,'Coordinate Reference System',3477,7302,'NAD83(NSRS) / AK 10 (m)',''),
(5858,'Coordinate Reference System',3509,7302,'NAD83(NSRS) / DE (m)',''),
(5859,'Coordinate Reference System',3524,7302,'NAD83(NSRS) / ID E (m)',''),
(5860,'Coordinate Reference System',3526,7302,'NAD83(NSRS) / ID W (m)',''),
(5861,'Coordinate Reference System',3536,7302,'NAD83(NSRS) / IA N (m)',''),
(5862,'Coordinate Reference System',3538,7302,'NAD83(NSRS) / IA S (m)',''),
(5863,'Coordinate Reference System',3559,7302,'NAD83(NSRS) / MD (m)',''),
(5864,'Coordinate Reference System',3604,7302,'NAD83(NSRS) / MT (m)',''),
(5865,'Coordinate Reference System',3615,7302,'NAD83(NSRS) / NJ (m)',''),
(5866,'Coordinate Reference System',3661,7302,'NAD83(NSRS) / TN (m)',''),
(5867,'Coordinate Reference System',3665,7302,'NAD83(NSRS) / TX Albers',''),
(5868,'Coordinate Reference System',3666,7302,'NAD83(NSRS) / TX LC',''),
(5869,'Coordinate Reference System',3678,7302,'NAD83(NSRS) / UT N (m)',''),
(5870,'Coordinate Reference System',3681,7302,'NAD83(NSRS) / UT S (m)',''),
(5871,'Coordinate Reference System',3684,7302,'NAD83(NSRS) / VT (m)',''),
(5872,'Coordinate Reference System',2790,7301,'NAD83(HARN) / Illinois East (m)',''),
(5873,'Coordinate Reference System',3084,7302,'NAD83(HARN) / TX LC',''),
(5874,'Coordinate Reference System',3083,7301,'TCMS/AEA','This alias is ambiguous as also used for NAD83(HARN) / Texas Centric Albers Equal Area.'),
(5875,'Coordinate Reference System',3082,7302,'NAD83 / TX LC',''),
(5876,'Coordinate Reference System',3085,7302,'NAD83(HARN) / TX Albers',''),
(5877,'Coordinate Reference System',3091,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(5878,'Coordinate Reference System',3090,7302,'NAD83(HARN) / KY1Z',''),
(5879,'Coordinate Reference System',3088,7302,'NAD83 / KY1Z (m)',''),
(5880,'Datum',5215,7302,'EVRF2007',''),
(5881,'Coordinate Reference System',7423,7301,'ETRF89 + EVRF2007 height',''),
(5882,'Coordinate_Operation',17964,7302,'NZCS2000',''),
(5883,'Coordinate_Operation',17966,7302,'DGLC2000',''),
(5884,'Coordinate_Operation',19841,7301,'Swiss Old Grid (Greenwich)',''),
(5885,'Coordinate_Operation',19922,7301,'Swiss New Grid',''),
(5886,'Coordinate_Operation',19923,7301,'Swiss Old Grid',''),
(5887,'Coordinate_Operation',19950,7302,'Landesvermessung 1995',''),
(5888,'Coordinate_Operation',4305,7302,'Pinang Grid',''),
(5889,'Coordinate_Operation',4117,7302,'Selangor Grid',''),
(5890,'Coordinate_Operation',4115,7302,'Sembilan and Melaka Grid',''),
(5891,'Coordinate_Operation',4177,7302,'Terengganu Grid',''),
(5892,'Coordinate_Operation',6937,7301,'AGD66 (Bevan Rapids) to PNG94 (2)',''),
(5893,'Coordinate_Operation',1235,1039,'ZAN',''),
(5894,'Coordinate_Operation',6938,7301,'AGD66 (Bevan Rapids) to PNG94 (3)',''),
(5895,'Coordinate_Operation',6939,7301,'AGD66 (Kutubu) to PNG94 (4)',''),
(5896,'Coordinate_Operation',6942,7301,'AGD66 (North Fly) to PNG94 (7)',''),
(5897,'Coordinate_Operation',6940,7301,'AGD66 (Kutubu) to PNG94 (5)',''),
(5898,'Coordinate_Operation',1234,1039,'YAC',''),
(5899,'Coordinate_Operation',6941,7301,'AGD66 (North Fly) to PNG94 (6)',''),
(5900,'Coordinate_Operation',15823,1039,'WAK',''),
(5901,'Coordinate_Operation',6944,7301,'AGD66 (Kutubu) to WGS 84 (22)',''),
(5902,'Coordinate_Operation',1294,1039,'VOI',''),
(5903,'Coordinate_Operation',6943,7301,'AGD66 (Bevan Rapids) to WGS 84 (21)',''),
(5904,'Coordinate_Operation',6945,7301,'AGD66 (North Fly) to WGS 84 (23)',''),
(5905,'Coordinate_Operation',15897,1039,'MVS',''),
(5906,'Coordinate_Operation',15816,1039,'TDC',''),
(5907,'Coordinate_Operation',1305,1039,'TOY-B',''),
(5908,'Coordinate_Operation',1233,1039,'TOY-C',''),
(5909,'Coordinate_Operation',1232,1039,'TOY-B',''),
(5910,'Coordinate_Operation',1231,1039,'TOY-A',''),
(5911,'Coordinate_Operation',1230,1039,'TOY-M',''),
(5912,'Coordinate_Operation',1956,1039,'IRL',''),
(5913,'Coordinate_Operation',1228,1039,'TIL',''),
(5914,'Coordinate_Operation',15795,1039,'TRN',''),
(5915,'Coordinate_Operation',1227,1039,'TAN',''),
(5916,'Coordinate_Operation',15750,1039,'FOT',''),
(5917,'Coordinate_Operation',15798,1039,'SHB',''),
(5918,'Coordinate_Operation',15813,1039,'ISG',''),
(5919,'Coordinate_Operation',15807,1039,'DOB',''),
(5920,'Coordinate_Operation',15805,1039,'GIZ',''),
(5921,'Coordinate_Operation',1581,1039,'SIR',''),
(5922,'Coordinate_Operation',15814,1039,'LCF',''),
(5923,'Coordinate_Operation',1614,1039,'SRL',''),
(5924,'Coordinate_Operation',1876,1039,'SAN-L',''),
(5925,'Coordinate_Operation',1897,1039,'GSE',''),
(5926,'Coordinate_Operation',1226,1039,'SCK',''),
(5927,'Coordinate_Operation',1225,1039,'SAP',''),
(5928,'Coordinate_Operation',15820,1039,'SAE',''),
(5929,'Coordinate_Operation',1864,1039,'SAN-M',''),
(5930,'Coordinate_Operation',1873,1039,'SAN-H',''),
(5931,'Coordinate_Operation',1874,1039,'SAN-I',''),
(5932,'Coordinate_Operation',1875,1039,'SAN-K',''),
(5933,'Coordinate_Operation',1865,1039,'SAN-A',''),
(5934,'Coordinate_Operation',1866,1039,'SAN-B',''),
(5935,'Coordinate_Operation',1867,1039,'SAN-C',''),
(5936,'Coordinate_Operation',1868,1039,'SAN-D',''),
(5937,'Coordinate_Operation',1869,1039,'SAN-E',''),
(5938,'Coordinate_Operation',1870,1039,'SAN-F',''),
(5939,'Coordinate_Operation',1871,1039,'SAN-J',''),
(5940,'Coordinate_Operation',1872,1039,'SAN-G',''),
(5941,'Coordinate_Operation',15751,1039,'REU',''),
(5942,'Coordinate_Operation',1797,1039,'QUO',''),
(5943,'Coordinate_Operation',1561,1039,'QAT',''),
(5944,'Coordinate_Operation',15999,1039,'SPK-F',''),
(5945,'Coordinate_Operation',15998,1039,'SPK-C',''),
(5946,'Coordinate_Operation',15997,1039,' SPK-B',''),
(5947,'Coordinate_Operation',15996,1039,'SPK-A',''),
(5948,'Coordinate_Operation',15497,1039,'SPK-G',''),
(5949,'Coordinate_Operation',1290,1039,'SPK-D',''),
(5950,'Coordinate_Operation',1291,1039,'SPK-E',''),
(5951,'Coordinate_Operation',1254,1039,'PUK',''),
(5952,'Coordinate_Operation',1893,1039,'PUR',''),
(5953,'Coordinate_Operation',1208,1039,'PRP-G',''),
(5954,'Coordinate_Operation',1209,1039,'PRP-H',''),
(5955,'Coordinate_Operation',1207,1039,'PRP-F',''),
(5956,'Coordinate_Operation',1206,1039,'PRP-E',''),
(5957,'Coordinate_Operation',1205,1039,'PRP-D',''),
(5958,'Coordinate_Operation',1204,1039,'PRP-C',''),
(5959,'Coordinate_Operation',1203,1039,'PRP-B',''),
(5960,'Coordinate_Operation',1202,1039,'PRP-A',''),
(5961,'Coordinate_Operation',1201,1039,'PRP-M',''),
(5962,'Coordinate_Operation',1888,1039,'POS',''),
(5963,'Coordinate_Operation',1200,1039,'PTN',''),
(5964,'Coordinate_Operation',1880,1039,'PTB',''),
(5965,'Coordinate_Operation',15819,1039,'PIT',''),
(5966,'Coordinate Reference System',3857,7301,'WGS 84 / Popular Visualisation Pseudo-Mercator',''),
(5967,'Coordinate_Operation',15815,1039,'PLN',''),
(5968,'Coordinate_Operation',15803,1039,'CAO',''),
(5969,'Coordinate_Operation',1195,1039,'OGB-M',''),
(5970,'Coordinate_Operation',1196,1039,'OGB-A',''),
(5971,'Coordinate_Operation',3856,7302,'Pseudo-Mercator',''),
(5972,'Coordinate_Operation',1197,1039,'OGB-B',''),
(5973,'Coordinate_Operation',1198,1039,'OGB-C',''),
(5974,'Coordinate_Operation',1199,1039,'OGB-D',''),
(5975,'Coordinate_Operation',15828,1039,'OHA-D',''),
(5976,'Coordinate_Operation',15827,1039,'OHA-C',''),
(5977,'Coordinate_Operation',6946,7302,'OS_Poly_NTv2',''),
(5978,'Coordinate_Operation',6946,7301,'TM75 to ETRF89 (1)',''),
(5979,'Coordinate_Operation',6947,7302,'OS_Poly_NTv2',''),
(5980,'Coordinate_Operation',6947,7301,'TM to ETRF89 (1)',''),
(5981,'Coordinate_Operation',15826,1039,'OHA-B',''),
(5982,'Coordinate_Operation',15825,1039,'OHA-A',''),
(5983,'Coordinate_Operation',15824,1039,'OHA-M',''),
(5984,'Coordinate_Operation',1151,1039,'GEO',''),
(5985,'Coordinate_Operation',1255,1039,'VOR',''),
(5986,'Coordinate_Operation',1253,1039,'NSD',''),
(5987,'Coordinate_Operation',1192,1039,'NAP','Note: this code has also been used for other transformations.'),
(5988,'Coordinate_Operation',1556,1039,'NAP','Note: this code has also been used for other transformations.'),
(5989,'Coordinate_Operation',1189,1039,'NAH-A',''),
(5990,'Coordinate_Operation',1190,1039,'NAH-B',''),
(5991,'Coordinate_Operation',6948,7301,'RD/83 to ETRF89 (2)',''),
(5992,'Coordinate_Operation',1191,1039,'NAH-C',''),
(5993,'Coordinate_Operation',1251,1039,'NAR-E',''),
(5994,'Coordinate_Operation',1252,1039,'NAR-H',''),
(5995,'Coordinate_Operation',1188,1039,'NAR-A, NAR-B, NAR-C AND NAR-D',''),
(5996,'Coordinate_Operation',1249,1039,'NAS-V',''),
(5997,'Coordinate_Operation',1250,1039,'NAS-W',''),
(5998,'Coordinate_Operation',1171,1039,'NAS-N',''),
(5999,'Coordinate_Operation',1178,1039,'NAS-R',''),
(6000,'Coordinate_Operation',1177,1039,'NAS-Q',''),
(6001,'Coordinate_Operation',1176,1039,'NAS-D',''),
(6002,'Coordinate_Operation',1175,1039,'NAS-B',''),
(6003,'Coordinate_Operation',1174,1039,'NAS-A',''),
(6004,'Coordinate_Operation',1173,1039,'NAS-C',''),
(6005,'Coordinate_Operation',1172,1039,'NAS-E',''),
(6006,'Coordinate_Operation',1170,1039,'NAS-P',''),
(6007,'Coordinate_Operation',1179,1039,'NAS-F',''),
(6008,'Coordinate_Operation',1180,1039,'NAS-H',''),
(6009,'Coordinate_Operation',1181,1039,'NAS-G',''),
(6010,'Coordinate_Operation',1187,1039,'NAS-L',''),
(6011,'Coordinate_Operation',1186,1039,'NAS-U',''),
(6012,'Coordinate_Operation',1184,1039,'NAS-O',''),
(6013,'Coordinate_Operation',1183,1039,'NAS-J',''),
(6014,'Coordinate_Operation',1185,1039,'NAS-T',''),
(6015,'Coordinate_Operation',1182,1039,'NAS-I',''),
(6016,'Coordinate_Operation',1163,1039,'MPO',''),
(6017,'Coordinate_Operation',1444,1039,'ASM',''),
(6018,'Coordinate_Operation',1169,1039,'MOD',''),
(6019,'Coordinate_Operation',1168,1039,'MIN-B',''),
(6020,'Coordinate_Operation',1167,1039,'MIN-A',''),
(6021,'Coordinate_Operation',15817,1039,'MID',''),
(6022,'Coordinate_Operation',15818,1039,'MID',''),
(6023,'Coordinate_Operation',3962,1039,'HER',''),
(6024,'Coordinate_Operation',1166,1039,'MER',''),
(6025,'Coordinate_Operation',1165,1039,'MAS',''),
(6026,'Coordinate_Operation',15822,1039,'ENW',''),
(6027,'Coordinate_Operation',15799,1039,'ASQ',''),
(6028,'Coordinate_Operation',1164,1039,'MIK',''),
(6029,'Coordinate_Operation',1162,1039,'LUZ-B',''),
(6030,'Coordinate_Operation',1161,1039,'LUZ-A',''),
(6031,'Coordinate_Operation',1160,1039,'LIB',''),
(6032,'Coordinate_Operation',1159,1039,'LEH',''),
(6033,'Coordinate_Operation',15810,1039,'KUS',''),
(6034,'Coordinate_Operation',15809,1039,'JOH',''),
(6035,'Coordinate_Operation',1247,1039,'IND-P',''),
(6036,'Coordinate_Operation',1158,1039,'KEA',''),
(6037,'Coordinate_Operation',1558,1039,'KGS',''),
(6038,'Coordinate_Operation',1157,1039,'KAN',''),
(6039,'Coordinate_Operation',1156,1039,'IND-I',''),
(6040,'Coordinate_Operation',15752,1039,'EUS',''),
(6041,'Coordinate_Operation',1155,1039,'IND-B',''),
(6042,'Datum',6743,7301,'Karbala 1979 (Polservice)',''),
(6043,'Coordinate_Operation',15796,1039,'ATF',''),
(6044,'Datum',5149,1024,'British Vertical Datum',''),
(6045,'Coordinate_Operation',1304,1039,'INH-A',''),
(6046,'Coordinate_Operation',1153,1039,'INF-A',''),
(6047,'Coordinate_Operation',1542,1039,'ING-A',''),
(6048,'Coordinate_Operation',1543,1039,'ING-B',''),
(6049,'Coordinate_Operation',15850,1039,'KEG',''),
(6050,'Coordinate_Operation',1248,1039,'IDN',''),
(6051,'Datum',1029,7317,'IGRS',''),
(6052,'Coordinate_Operation',1152,1039,'HTN',''),
(6053,'Coordinate Reference System',3886,7301,'National Elevation Network height',''),
(6054,'Coordinate_Operation',1154,1039,'INH-A',''),
(6055,'Coordinate_Operation',15842,1039,'HKD',''),
(6056,'Coordinate_Operation',1951,1039,'HJO',''),
(6057,'Coordinate_Operation',1892,1039,'HIT',''),
(6058,'Coordinate_Operation',1246,1039,'HEN',''),
(6059,'Coordinate_Operation',1070,1039,'GUA',''),
(6060,'Coordinate_Operation',15713,1039,'GAA',''),
(6061,'Coordinate_Operation',1256,1039,'FAH',''),
(6062,'Coordinate Reference System',3893,7302,'ED50 / Iraq Nat. Grid',''),
(6063,'Coordinate_Operation',1148,1039,'OEG',''),
(6064,'Coordinate Reference System',4743,7301,'Karbala 1979 (Polservice)',''),
(6065,'Coordinate_Operation',1141,1039,'EUR-H',''),
(6066,'Coordinate Reference System',3391,7301,'Karbala 1979 (Polservice) / UTM zone 37N',''),
(6067,'Coordinate_Operation',1140,1039,'EUR-B',''),
(6068,'Coordinate_Operation',1139,1039,'EUR-C',''),
(6069,'Coordinate Reference System',3392,7301,'Karbala 1979 (Polservice) / UTM zone 38N',''),
(6070,'Coordinate_Operation',1138,1039,'EUR-G',''),
(6071,'Coordinate Reference System',3393,7301,'Karbala 1979 (Polservice) / UTM zone 39N',''),
(6072,'Coordinate_Operation',1137,1039,'EUR-F',''),
(6073,'Coordinate_Operation',1136,1039,'EUR-E',''),
(6074,'Coordinate_Operation',1135,1039,'EUR-S',''),
(6075,'Coordinate_Operation',1134,1039,'EUR-A',''),
(6076,'Coordinate_Operation',1245,1039,'EUR-T',''),
(6077,'Coordinate_Operation',1145,1039,'EUR-D',''),
(6078,'Coordinate_Operation',1144,1039,'EUR-L',''),
(6079,'Coordinate_Operation',1143,1039,'EUR-J',''),
(6080,'Coordinate_Operation',1142,1039,'EUR-I',''),
(6081,'Coordinate_Operation',1133,1039,'EUR-M',''),
(6082,'Coordinate_Operation',15806,1039,'EAS',''),
(6083,'Coordinate_Operation',15808,1039,'IST',''),
(6084,'Coordinate_Operation',15812,1039,'DID',''),
(6085,'Coordinate_Operation',1518,1039,'DAL',''),
(6086,'Coordinate_Operation',1132,1039,'COA',''),
(6087,'Coordinate_Operation',15794,1039,'ANO',''),
(6088,'Coordinate_Operation',1080,1039,'CHI',''),
(6089,'Coordinate_Operation',1131,1039,'CHU',''),
(6090,'Coordinate_Operation',1130,1039,'CGE',''),
(6091,'Coordinate_Operation',1128,1039,'CAP',''),
(6092,'Coordinate_Operation',15804,1039,'CAC',''),
(6093,'Coordinate_Operation',1127,1039,'CAI',''),
(6094,'Coordinate_Operation',15802,1039,'CAZ',''),
(6095,'Coordinate_Operation',1126,1039,'BUR',''),
(6096,'Coordinate_Operation',1125,1039,'BOO',''),
(6097,'Coordinate_Operation',1547,1039,'BID',''),
(6098,'Coordinate_Operation',1124,1039,'BER',''),
(6099,'Coordinate_Operation',15801,1039,'IBE',''),
(6100,'Coordinate_Operation',1123,1039,'BAT',''),
(6101,'Coordinate_Operation',1885,1039,'SAO',''),
(6102,'Coordinate_Operation',1117,1039,'ARF-C',''),
(6103,'Coordinate_Operation',1887,1039,'FLO',''),
(6104,'Coordinate_Operation',1886,1039,'GRA',''),
(6105,'Coordinate_Operation',15800,1039,'PHA',''),
(6106,'Coordinate_Operation',15797,1039,'ASC',''),
(6107,'Coordinate_Operation',3998,1039,'ARF-H',''),
(6108,'Coordinate_Operation',1285,1039,'ARS-B',''),
(6109,'Coordinate_Operation',1284,1039,'ARS-A',''),
(6110,'Coordinate_Operation',1122,1039,'ARS-M',''),
(6111,'Coordinate_Operation',1121,1039,'ARF-G',''),
(6112,'Coordinate_Operation',1120,1039,'ARF-F',''),
(6113,'Coordinate_Operation',1118,1039,'ARF-D',''),
(6114,'Coordinate_Operation',1116,1039,'ARF-B',''),
(6115,'Coordinate_Operation',1114,1039,'ARF-A',''),
(6116,'Coordinate_Operation',1113,1039,'ARF-M',''),
(6117,'Coordinate_Operation',15811,1039,'AIA',''),
(6118,'Coordinate_Operation',1577,1039,'AMA',''),
(6119,'Coordinate_Operation',1111,1039,'AIN-B',''),
(6120,'Coordinate_Operation',1110,1039,'AIN-A',''),
(6121,'Coordinate_Operation',1109,1039,'AUG',''),
(6122,'Coordinate_Operation',1108,1039,'AUA',''),
(6123,'Coordinate_Operation',1107,1039,'AFG',''),
(6124,'Coordinate_Operation',1106,1039,'ADI-B',''),
(6125,'Coordinate_Operation',1105,1039,'ADI-D',''),
(6126,'Coordinate_Operation',1104,1039,'ADI-C',''),
(6127,'Coordinate_Operation',1103,1039,'ADI-A',''),
(6128,'Coordinate_Operation',1102,1039,'ADI-F',''),
(6129,'Coordinate_Operation',1101,1039,'ADI-E',''),
(6130,'Coordinate_Operation',1100,1039,'ADI-M',''),
(6131,'Coordinate_Operation',1916,1039,'MCX',''),
(6132,'Datum',6191,1038,'ALB86',''),
(6133,'Coordinate_Operation',1193,1039,'NTF',''),
(6134,'Coordinate_Operation',1923,1039,'SPX',''),
(6135,'Coordinate_Operation',6954,7302,'TM-3 zone 491',''),
(6136,'Coordinate Reference System',4191,1038,'ALB86',''),
(6137,'Coordinate Reference System',2462,1038,'ALB86 / GK zn 4',''),
(6138,'Coordinate_Operation',6952,7302,'TM-3 zone 481',''),
(6139,'Coordinate_Operation',6953,7302,'TM-3 zone 482',''),
(6140,'Coordinate_Operation',1307,1039,'NAP',''),
(6141,'Coordinate_Operation',1965,1039,'SGM',''),
(6142,'Coordinate Reference System',4129,7301,'Observatario Campos Rodrigues 1907',''),
(6143,'Coordinate Reference System',6984,7302,'IG05',''),
(6144,'Datum',6127,7301,'Tete 1960',''),
(6145,'Coordinate Reference System',6962,7302,'ETRS89 / Albania LCC',''),
(6146,'Coordinate Reference System',6991,7302,'IG05/12',''),
(6147,'Coordinate Reference System',6870,7302,'ETRS89 / Albania TM',''),
(6148,'Coordinate_Operation',6972,1039,'PRP-B2',''),
(6149,'Coordinate Reference System',2039,7301,'Israel / Israeli TM Grid',''),
(6150,'Datum',6201,7301,'Blue Nile 1958',''),
(6151,'Coordinate_Operation',6963,7301,'Albanian 1987 to KRGJSH-2010 (1)',''),
(6152,'Coordinate_Operation',6971,1039,'PRP-B1',''),
(6153,'Coordinate_Operation',6963,1038,'ALB86 to KRGJSH-2010 (1)',''),
(6154,'Coordinate Reference System',6796,7301,'NAD83(CORS96) / Oregon Bend-Vale zone (m)','Previous name.'),
(6155,'Coordinate_Operation',6973,1039,'PRP-B3',''),
(6156,'Coordinate Reference System',4141,7301,'Israel',''),
(6157,'Coordinate_Operation',6974,1039,'SAN-D1',''),
(6158,'Coordinate_Operation',6993,7301,'IGD05/12 to GRS80',''),
(6159,'Coordinate_Operation',6975,1039,'SAN-D2',''),
(6160,'Coordinate Reference System',2039,7301,'Israeli New Grid',''),
(6161,'Coordinate_Operation',6976,1039,'SAN-D3',''),
(6162,'Coordinate_Operation',6995,7302,'CCSF CS13 (ftUS)',''),
(6163,'Coordinate_Operation',6977,1039,'SAN-D4',''),
(6164,'Coordinate_Operation',6994,7302,'San Francisco CS13',''),
(6165,'Coordinate Reference System',6997,7302,'NAD83(2011) / CCSF-CS13 (ftUS)',''),
(6166,'Coordinate Reference System',5843,7301,'Abu Dhabi height',''),
(6167,'Coordinate_Operation',7008,7301,'Nahrwan 1934 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (1)',''),
(6168,'Coordinate Reference System',6996,7301,'NAD83(2011) / San Francisco CS13 (m)',''),
(6169,'Coordinate Reference System',6996,7302,'NAD83(2011) / CCSF-CS13',''),
(6170,'Coordinate_Operation',6999,7301,'ADCO ITRF2000 20131027',''),
(6171,'Coordinate_Operation',6964,1038,'ALB86 to WGS 84 (1)',''),
(6172,'Coordinate Reference System',7006,7302,'Nahrwan 1934 / UTM 38N',''),
(6173,'Coordinate_Operation',7015,7301,'Nahrwan 1934 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (8)',''),
(6174,'Coordinate Reference System',7007,7302,'Nahrwan 1934 / UTM 39N',''),
(6175,'Coordinate_Operation',7009,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (2)',''),
(6176,'Coordinate Reference System',4201,7301,'Blue Nile 1958',''),
(6177,'Coordinate_Operation',7010,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (3)',''),
(6178,'Coordinate_Operation',7016,7301,'Nahrwan 1934 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (9)',''),
(6179,'Coordinate_Operation',7011,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (4)',''),
(6180,'Coordinate Reference System',20135,7301,'Blue Nile 1958 / UTM zone 35N',''),
(6181,'Coordinate_Operation',7012,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (5)',''),
(6182,'Coordinate_Operation',7017,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (10)',''),
(6183,'Coordinate_Operation',7013,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (6)',''),
(6184,'Coordinate Reference System',20136,7301,'Blue Nile 1958 / UTM zone 36N',''),
(6185,'Coordinate_Operation',7014,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (7)',''),
(6186,'Coordinate_Operation',7018,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (11)',''),
(6187,'Coordinate Reference System',20137,7301,'Blue Nile 1958 / UTM zone 37N',''),
(6188,'Coordinate_Operation',7019,7301,'Nahrwan 1934 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (12)',''),
(6189,'Coordinate Reference System',20138,7301,'Blue Nile 1958 / UTM zone 38N',''),
(6190,'Coordinate_Operation',7020,7301,'Nahrwan 1934 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (13)',''),
(6191,'Coordinate_Operation',1100,7301,'Blue Nile 1958 to WGS 84 (1)',''),
(6192,'Coordinate_Operation',7021,7301,'Nahrwan 1934 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (14)',''),
(6193,'Coordinate_Operation',1101,7301,'Blue Nile 1958 to WGS 84 (2)',''),
(6194,'Coordinate_Operation',7022,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (15)',''),
(6195,'Coordinate_Operation',1102,7301,'Blue Nile 1958 to WGS 84 (3)',''),
(6196,'Coordinate_Operation',7023,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (16)',''),
(6197,'Coordinate_Operation',1103,7301,'Blue Nile 1958 to WGS 84 (4)',''),
(6198,'Coordinate_Operation',7024,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (17)',''),
(6199,'Coordinate_Operation',1104,7301,'Blue Nile 1958 to WGS 84 (5)',''),
(6200,'Coordinate_Operation',7025,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (18)',''),
(6201,'Coordinate_Operation',1105,7301,'Blue Nile 1958 to WGS 84 (6)',''),
(6202,'Coordinate_Operation',7026,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (19)',''),
(6203,'Coordinate_Operation',1106,7301,'Blue Nile 1958 to WGS 84 (7)',''),
(6204,'Coordinate_Operation',7027,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (20)',''),
(6205,'Coordinate_Operation',6308,1037,'Local Transverse Mercator (LTM)',''),
(6206,'Coordinate_Operation',7028,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (21)',''),
(6207,'Coordinate Reference System',6307,7302,'NAD83(CORS96) / PR and VI',''),
(6208,'Coordinate_Operation',7029,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (22)',''),
(6209,'Datum',1112,1037,'CGRS93',''),
(6210,'Coordinate_Operation',7030,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (23)',''),
(6211,'Coordinate Reference System',6312,1037,'CGRS93 / Local Transverse Mercator (LTM)',''),
(6212,'Coordinate_Operation',7031,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (24)',''),
(6213,'Coordinate Reference System',4171,7301,'RGF93 (lat-lon)',''),
(6214,'Coordinate_Operation',7032,7301,'Nahrwan 1934 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (25)',''),
(6215,'Coordinate Reference System',4965,7301,'RGF93 (lat-lon)',''),
(6216,'Coordinate Reference System',7057,7301,'NAD83(2011) / IaRCS zone 1 Spencer',''),
(6217,'Coordinate_Operation',7043,7302,'IaRCS zone 1',''),
(6218,'Coordinate_Operation',7044,7302,'IaRCS zone 2',''),
(6219,'Coordinate_Operation',7047,7302,'IaRCS zone 5',''),
(6220,'Coordinate_Operation',7045,7302,'IaRCS zone 3',''),
(6221,'Datum',1113,7302,'RGTAAF07',''),
(6222,'Coordinate_Operation',7046,7302,'IaRCS zone 4',''),
(6223,'Coordinate_Operation',7048,7302,'IaRCS zone 6',''),
(6224,'Coordinate Reference System',7058,7301,'NAD83(2011) / IaRCS zone 2 Mason City',''),
(6225,'Coordinate_Operation',7049,7302,'IaRCS zone 7',''),
(6226,'Datum',1113,7301,'Reseau Geodesique des TAAF 2007',''),
(6227,'Coordinate_Operation',7050,7302,'IaRCS zone 8',''),
(6228,'Coordinate Reference System',7059,7301,'NAD83(2011) / IaRCS zone 3 Elkader',''),
(6229,'Coordinate_Operation',7051,7302,'IaRCS zone 9',''),
(6230,'Coordinate Reference System',5489,7301,'RGAF09 (lat-lon)',''),
(6231,'Coordinate_Operation',7052,7302,'IaRCS zone 10',''),
(6232,'Coordinate Reference System',7060,7301,'NAD83(2011) / IaRCS zone 4 Sioux City-Iowa Falls',''),
(6233,'Coordinate_Operation',7053,7302,'IaRCS zone 11',''),
(6234,'Coordinate Reference System',4624,7301,'RGFG95 (lat-lon)',''),
(6235,'Coordinate_Operation',7054,7302,'IaRCS zone 12',''),
(6236,'Coordinate Reference System',7061,7301,'NAD83(2011) / IaRCS zone 5 Waterloo',''),
(6237,'Coordinate_Operation',7055,7302,'IaRCS zone 13',''),
(6238,'Coordinate Reference System',4627,7301,'RGR92 (lat-lon)',''),
(6239,'Coordinate_Operation',7056,7302,'IaRCS zone 14',''),
(6240,'Coordinate Reference System',7062,7301,'NAD83(2011) / IaRCS zone 6 Council Bluffs',''),
(6241,'Coordinate Reference System',4470,7301,'RGM04 (lat-lon)',''),
(6242,'Coordinate Reference System',7063,7301,'NAD83(2011) / IaRCS zone 7 Carroll-Atlantic',''),
(6243,'Coordinate Reference System',4463,7301,'RGSPM06 (lat-lon)',''),
(6244,'Coordinate Reference System',7064,7301,'NAD83(2011) / IaRCS zone 8 Ames-Des Moines',''),
(6245,'Coordinate Reference System',4466,7301,'RGSPM06 (lat-lon)',''),
(6246,'Coordinate Reference System',7065,7301,'NAD83(2011) / IaRCS zone 9 Newton',''),
(6247,'Coordinate Reference System',4469,7301,'RGM04 (lat-lon)',''),
(6248,'Coordinate Reference System',7066,7301,'NAD83(2011) / IaRCS zone 10 Cedar Rapids',''),
(6249,'Coordinate Reference System',4971,7301,'RGR92 (lat-lon)',''),
(6250,'Coordinate Reference System',7067,7301,'NAD83(2011) / IaRCS zone 11 Dubuque-Davenport',''),
(6251,'Coordinate Reference System',4967,7301,'RGFG95 (lat-lon)',''),
(6252,'Coordinate Reference System',7068,7301,'NAD83(2011) / IaRCS zone 12 Red Oak-Ottumwa',''),
(6253,'Coordinate Reference System',5488,7301,'RGAF09 (lat-lon)',''),
(6254,'Coordinate Reference System',7069,7301,'NAD83(2011) / IaRCS zone 13 Fairfield',''),
(6255,'Coordinate Reference System',7073,7301,'RGTAAF07 (lat-lon)',''),
(6256,'Coordinate Reference System',7070,7301,'NAD83(2011) / IaRCS zone 14 Burlington',''),
(6257,'Coordinate Reference System',7072,7301,'RGTAAF07',''),
(6258,'Coordinate_Operation',7089,7302,'RMTCRS St Mary',''),
(6259,'Datum',1147,7302,'ONGD14',''),
(6260,'Coordinate_Operation',7090,7302,'RMTCRS St Mary (ft)',''),
(6261,'Coordinate_Operation',7095,7302,'RMTCRS Fort Belknap',''),
(6262,'Coordinate_Operation',7091,7302,'RMTCRS Blackfeet',''),
(6263,'Coordinate_Operation',7103,7302,'RMTCRS Bobcat',''),
(6264,'Coordinate_Operation',7092,7302,'RMTCRS Blackfeet (ft)',''),
(6265,'Coordinate_Operation',7096,7302,'RMTCRS Fort Belknap (ft)',''),
(6266,'Coordinate_Operation',7093,7302,'RMTCRS Milk River',''),
(6267,'Coordinate Reference System',7109,7302,'NAD83(2011) / St Mary (m)',''),
(6268,'Coordinate_Operation',7094,7302,'RMTCRS Milk River (ft)',''),
(6269,'Coordinate_Operation',7097,7302,'RMTCRS Ft Peck Assiniboine',''),
(6270,'Coordinate_Operation',7104,7302,'RMTCRS Bobcat (ft)',''),
(6271,'Coordinate_Operation',7098,7302,'RMTCRS Ft Peck Assiniboine (ft)',''),
(6272,'Coordinate Reference System',7114,7302,'NAD83(2011) / Ft Peck Sx (m)',''),
(6273,'Coordinate_Operation',7099,7302,'RMTCRS Ft Peck Sioux',''),
(6274,'Coordinate_Operation',7105,7302,'RMTCRS Billings',''),
(6275,'Coordinate_Operation',7100,7302,'RMTCRS Ft Peck Sioux (ft)',''),
(6276,'Coordinate Reference System',7110,7302,'NAD83(2011) / Blackfeet (m)',''),
(6277,'Coordinate_Operation',7101,7302,'RMTCRS Crow',''),
(6278,'Coordinate_Operation',7106,7302,'RMTCRS Billings (ft)',''),
(6279,'Coordinate_Operation',7102,7302,'RMTCRS Crow (ft)',''),
(6280,'Coordinate Reference System',7125,7302,'NAD83(2011) / Crow (ft)',''),
(6281,'Coordinate_Operation',7107,7302,'RMTCRS Wind River',''),
(6282,'Coordinate Reference System',7111,7302,'NAD83(2011) / Milk R (m)',''),
(6283,'Coordinate_Operation',7108,7302,'RMTCRS Wind River (ftUS)',''),
(6284,'Coordinate Reference System',7115,7302,'NAD83(2011) / Crow (m)',''),
(6285,'Coordinate Reference System',7112,7302,'NAD83(2011) / Ft Belknap (m)',''),
(6286,'Coordinate Reference System',7278,7302,'InGCS 2011 11 (ftUS)',''),
(6287,'Coordinate Reference System',7113,7302,'NAD83(2011) / Ft Peck As (m)',''),
(6288,'Coordinate Reference System',7116,7302,'NAD83(2011) / Bobcat (m)',''),
(6289,'Coordinate Reference System',7126,7302,'NAD83(2011) / Bobcat (ft)',''),
(6290,'Coordinate Reference System',7117,7302,'NAD83(2011) / Billings (m)',''),
(6291,'Coordinate_Operation',7129,7302,'San Francisco CS13',''),
(6292,'Coordinate Reference System',7118,7302,'NAD83(2011) / Wind R (m)',''),
(6293,'Coordinate Reference System',7127,7302,'NAD83(2011) / Billings (ft)',''),
(6294,'Coordinate Reference System',7119,7302,'NAD83(2011) / St Mary (ft)',''),
(6295,'Coordinate_Operation',7151,7301,'InGCS Blackford (m)',''),
(6296,'Coordinate Reference System',7120,7302,'NAD83(2011) / Blackfeet (ft)',''),
(6297,'Coordinate Reference System',7128,7302,'NAD83(2011) / Wind R (ftUS)',''),
(6298,'Coordinate Reference System',7121,7302,'NAD83(2011) / Milk R (ft)',''),
(6299,'Coordinate_Operation',7151,7301,'InGCS Delaware (m)',''),
(6300,'Coordinate Reference System',7122,7302,'NAD83(2011) / Ft Belknap (ft)',''),
(6301,'Coordinate_Operation',7140,7301,'IGD05 to GRS80',''),
(6302,'Coordinate Reference System',7123,7302,'NAD83(2011) / Ft Peck As (ft)',''),
(6303,'Coordinate_Operation',7152,7301,'InGCS Blackford (ftUS)',''),
(6304,'Coordinate Reference System',7124,7302,'NAD83(2011) / Ft Peck Sx (ft)',''),
(6305,'Coordinate_Operation',7152,7301,'InGCS Delaware (ftUS)',''),
(6306,'Coordinate_Operation',7130,7302,'San Francisco CS13 (ftUS)',''),
(6307,'Coordinate Reference System',7279,7302,'InGCS 2011 12 (m)',''),
(6308,'Coordinate_Operation',7177,7301,'InGCS Dubois (m)',''),
(6309,'Coordinate_Operation',7162,7301,'InGCS Clark (ftUS)',''),
(6310,'Coordinate Reference System',7267,7302,'InGCS 2011 06-32 (m)',''),
(6311,'Coordinate_Operation',7154,7301,'InGCS Boone (ftUS)',''),
(6312,'Coordinate Reference System',7142,7302,'Palestine Grid modified',''),
(6313,'Coordinate Reference System',7267,7301,'NAD83(2011) / InGCS Boone (m)',''),
(6314,'Coordinate Reference System',7267,7301,'NAD83(2011) / InGCS Hendricks (m)',''),
(6315,'Coordinate_Operation',7154,7301,'InGCS Hendricks (ftUS)',''),
(6316,'Coordinate Reference System',7259,7302,'InGCS 2011 02 (m)',''),
(6317,'Coordinate Reference System',7323,7302,'InGCS 2011 39 (m)',''),
(6318,'Coordinate_Operation',7162,7301,'InGCS Floyd (ftUS)',''),
(6319,'Coordinate_Operation',7153,7301,'InGCS Boone (m)',''),
(6320,'Coordinate_Operation',7153,7301,'InGCS Hendricks (m)',''),
(6321,'Coordinate_Operation',7162,7301,'InGCS Scott (ftUS)',''),
(6322,'Coordinate_Operation',7177,7301,'InGCS Martin (m)',''),
(6323,'Coordinate_Operation',7183,7301,'InGCS Fountain (m)',''),
(6324,'Coordinate_Operation',7183,7301,'InGCS Warren (m)',''),
(6325,'Coordinate_Operation',7161,7301,'InGCS Clark (m)',''),
(6326,'Coordinate_Operation',7161,7301,'InGCS Floyd (m)',''),
(6327,'Coordinate_Operation',7167,7301,'InGCS Crawford (m)',''),
(6328,'Coordinate_Operation',7167,7301,'InGCS Lawrence (m)',''),
(6329,'Coordinate_Operation',7167,7301,'InGCS Orange (m)',''),
(6330,'Coordinate_Operation',7161,7301,'InGCS Scott (m)',''),
(6331,'Coordinate_Operation',7178,7301,'InGCS Dubois (ftUS)',''),
(6332,'Coordinate_Operation',7178,7301,'InGCS Martin (ftUS)',''),
(6333,'Coordinate_Operation',7193,7301,'InGCS Hancock (m)',''),
(6334,'Coordinate_Operation',7186,7301,'InGCS Fulton (ftUS)',''),
(6335,'Coordinate_Operation',7184,7301,'InGCS Fountain (ftUS)',''),
(6336,'Coordinate_Operation',7179,7301,'InGCS Elkhart (m)',''),
(6337,'Coordinate_Operation',7168,7301,'InGCS Crawford (ftUS)',''),
(6338,'Coordinate Reference System',7131,7301,'NAD83(2011) / San Francisco CS13 (m)',''),
(6339,'Coordinate_Operation',7168,7301,'InGCS Lawrence (ftUS)',''),
(6340,'Coordinate_Operation',7168,7301,'InGCS Orange (ftUS)',''),
(6341,'Coordinate_Operation',7179,7301,'InGCS Kosciusko (m)',''),
(6342,'Coordinate_Operation',7179,7301,'InGCS Wabash (m)',''),
(6343,'Coordinate Reference System',7131,7302,'NAD83(2011) / CCSF-CS13',''),
(6344,'Coordinate_Operation',7169,7301,'InGCS Daviess (m)',''),
(6345,'Coordinate_Operation',7169,7301,'InGCS Greene (m)',''),
(6346,'Coordinate_Operation',7184,7301,'InGCS Warren (ftUS)',''),
(6347,'Coordinate_Operation',7186,7301,'InGCS Marshall (ftUS)',''),
(6348,'Coordinate_Operation',7170,7301,'InGCS Daviess (ftUS)',''),
(6349,'Coordinate_Operation',7170,7301,'InGCS Greene (ftUS)',''),
(6350,'Coordinate_Operation',7186,7301,'InGCS St. Joseph (ftUS)',''),
(6351,'Coordinate_Operation',7180,7301,'InGCS Elkhart (ftUS)',''),
(6352,'Coordinate Reference System',7132,7302,'NAD83(2011) / CCSF-CS13 (ftUS)',''),
(6353,'Coordinate_Operation',7180,7301,'InGCS Kosciusko (ftUS)',''),
(6354,'Coordinate Reference System',3973,7302,'WGS 84 / NSIDC EA North',''),
(6355,'Coordinate_Operation',7171,7301,'InGCS Dearborn (m)',''),
(6356,'Coordinate_Operation',7171,7301,'InGCS Ohio (m)',''),
(6357,'Coordinate Reference System',3974,7302,'WGS 84 / NSIDC EA South',''),
(6358,'Coordinate_Operation',7171,7301,'InGCS Switzerland (m)',''),
(6359,'Coordinate_Operation',7180,7301,'InGCS Wabash (ftUS)',''),
(6360,'Coordinate_Operation',7193,7301,'InGCS Madison (m)',''),
(6361,'Coordinate_Operation',7185,7301,'InGCS Fulton (m)',''),
(6362,'Coordinate_Operation',7172,7301,'InGCS Dearborn (ftUS)',''),
(6363,'Coordinate Reference System',3975,7302,'WGS 84 / NSIDC EA Global',''),
(6364,'Coordinate_Operation',7172,7301,'InGCS Ohio (ftUS)',''),
(6365,'Coordinate_Operation',7172,7301,'InGCS Switzerland (ftUS)',''),
(6366,'Coordinate_Operation',7185,7301,'InGCS Marshall (m)',''),
(6367,'Coordinate Reference System',3976,7302,'WGS 84 / NSIDC PS South',''),
(6368,'Coordinate_Operation',7181,7301,'InGCS Fayette (m)',''),
(6369,'Coordinate_Operation',7173,7301,'InGCS Decatur (m)',''),
(6370,'Coordinate_Operation',7173,7301,'InGCS Rush (m)',''),
(6371,'Coordinate_Operation',7181,7301,'InGCS Franklin (m)',''),
(6372,'Coordinate_Operation',7181,7301,'InGCS Union (m)',''),
(6373,'Coordinate_Operation',7174,7301,'InGCS Decatur (ftUS)',''),
(6374,'Coordinate_Operation',7174,7301,'InGCS Rush (ftUS)',''),
(6375,'Coordinate Reference System',3979,7302,'NAD83(CSRS) / Canada LCC',''),
(6376,'Coordinate_Operation',7185,7301,'InGCS St. Joseph (m)',''),
(6377,'Coordinate_Operation',7199,7301,'InGCS Howard (m)',''),
(6378,'Coordinate_Operation',7191,7301,'InGCS Hamilton (m)',''),
(6379,'Coordinate_Operation',7182,7301,'InGCS Fayette (ftUS)',''),
(6380,'Coordinate_Operation',7182,7301,'InGCS Franklin (ftUS)',''),
(6381,'Coordinate_Operation',7182,7301,'InGCS Union (ftUS)',''),
(6382,'Coordinate_Operation',7191,7301,'InGCS Tipton (m)',''),
(6383,'Coordinate_Operation',7199,7301,'InGCS Miami (m)',''),
(6384,'Coordinate_Operation',7194,7301,'InGCS Hancock (ftUS)',''),
(6385,'Coordinate_Operation',3983,7302,'Katanga zone C',''),
(6386,'Coordinate_Operation',7192,7301,'InGCS Hamilton (ftUS)',''),
(6387,'Coordinate_Operation',7192,7301,'InGCS Tipton (ftUS)',''),
(6388,'Coordinate_Operation',7194,7301,'InGCS Madison (ftUS)',''),
(6389,'Coordinate_Operation',3984,7302,'Katanga zone D',''),
(6390,'Coordinate_Operation',7205,7301,'InGCS Jasper (m)',''),
(6391,'Coordinate_Operation',7205,7301,'InGCS Porter (m)',''),
(6392,'Coordinate_Operation',7195,7301,'InGCS Harrison (m)',''),
(6393,'Coordinate_Operation',7195,7301,'InGCS Washington (m)',''),
(6394,'Coordinate_Operation',7200,7301,'InGCS Howard (ftUS)',''),
(6395,'Coordinate_Operation',7200,7301,'InGCS Miami (ftUS)',''),
(6396,'Coordinate_Operation',7196,7301,'InGCS Harrison (ftUS)',''),
(6397,'Coordinate_Operation',7196,7301,'InGCS Washington (ftUS)',''),
(6398,'Coordinate_Operation',7213,7301,'InGCS Johnson (m)',''),
(6399,'Coordinate_Operation',7213,7301,'InGCS Marion (m)',''),
(6400,'Coordinate_Operation',3982,7302,'Katanga zone B',''),
(6401,'Coordinate_Operation',7201,7301,'InGCS Huntington (m)',''),
(6402,'Coordinate_Operation',3981,7302,'Katanga zone A',''),
(6403,'Coordinate_Operation',7201,7301,'InGCS Whitley (m)',''),
(6404,'Coordinate_Operation',7206,7301,'InGCS Jasper (ftUS)',''),
(6405,'Coordinate_Operation',7206,7301,'InGCS Porter (ftUS)',''),
(6406,'Coordinate_Operation',7202,7301,'InGCS Huntington (ftUS)',''),
(6407,'Coordinate_Operation',7202,7301,'InGCS Whitley (ftUS)',''),
(6408,'Coordinate Reference System',3986,7302,'Katanga 1955 / TM zone A',''),
(6409,'Coordinate_Operation',7229,7301,'InGCS Parke (m)',''),
(6410,'Coordinate_Operation',7229,7301,'InGCS Vermillion (m)',''),
(6411,'Coordinate_Operation',7214,7301,'InGCS Johnson (ftUS)',''),
(6412,'Coordinate_Operation',7214,7301,'InGCS Marion (ftUS)',''),
(6413,'Coordinate Reference System',3987,7302,'Katanga 1955 / TM zone B',''),
(6414,'Coordinate_Operation',7249,7301,'InGCS Tippecanoe (m)',''),
(6415,'Coordinate_Operation',7249,7301,'InGCS White (m)',''),
(6416,'Coordinate_Operation',7217,7301,'InGCS LaGrange (m)',''),
(6417,'Coordinate_Operation',7217,7301,'InGCS Noble (m)',''),
(6418,'Coordinate_Operation',7230,7301,'InGCS Parke (ftUS)',''),
(6419,'Coordinate_Operation',7230,7301,'InGCS Vermillion (ftUS)',''),
(6420,'Coordinate_Operation',7218,7301,'InGCS LaGrange (ftUS)',''),
(6421,'Coordinate_Operation',7218,7301,'InGCS Noble (ftUS)',''),
(6422,'Coordinate Reference System',7280,7302,'InGCS 2011 12 (ftUS)',''),
(6423,'Coordinate Reference System',7349,7302,'InGCS 2011 65 (m)',''),
(6424,'Coordinate_Operation',7219,7301,'InGCS Lake (m)',''),
(6425,'Coordinate_Operation',7219,7301,'InGCS Newton (m)',''),
(6426,'Coordinate_Operation',7233,7301,'InGCS Pike (m)',''),
(6427,'Coordinate_Operation',7233,7301,'InGCS Warrick (m)',''),
(6428,'Coordinate_Operation',7220,7301,'InGCS Lake (ftUS)',''),
(6429,'Coordinate_Operation',7220,7301,'InGCS Newton (ftUS)',''),
(6430,'Coordinate_Operation',7250,7301,'InGCS Tippecanoe (ftUS)',''),
(6431,'Coordinate_Operation',7250,7301,'InGCS White (ftUS)',''),
(6432,'Coordinate_Operation',7234,7301,'InGCS Pike (ftUS)',''),
(6433,'Coordinate_Operation',7221,7301,'InGCS LaPorte (m)',''),
(6434,'Coordinate_Operation',7221,7301,'InGCS Pulaski (m)',''),
(6435,'Coordinate_Operation',7221,7301,'InGCS Starke (m)',''),
(6436,'Coordinate_Operation',7234,7301,'InGCS Warrick (ftUS)',''),
(6437,'Coordinate Reference System',7268,7302,'InGCS 2011 06-32 (ftUS)',''),
(6438,'Coordinate Reference System',7268,7301,'NAD83(2011) / InGCS Boone (ftUS)',''),
(6439,'Coordinate_Operation',7222,7301,'InGCS LaPorte (ftUS)',''),
(6440,'Coordinate_Operation',7222,7301,'InGCS Pulaski (ftUS)',''),
(6441,'Coordinate_Operation',7222,7301,'InGCS Starke (ftUS)',''),
(6442,'Coordinate_Operation',7237,7301,'InGCS Randolph (m)',''),
(6443,'Coordinate_Operation',7237,7301,'InGCS Wayne (m)',''),
(6444,'Coordinate_Operation',7223,7301,'InGCS Monroe (m)',''),
(6445,'Coordinate_Operation',7223,7301,'InGCS Morgan (m)',''),
(6446,'Coordinate Reference System',7268,7301,'NAD83(2011) / InGCS Hendricks (ftUS)',''),
(6447,'Coordinate Reference System',7297,7302,'InGCS 2011 23-86 (m)',''),
(6448,'Coordinate_Operation',7224,7301,'InGCS Monroe (ftUS)',''),
(6449,'Coordinate Reference System',3906,7309,'D48',''),
(6450,'Coordinate_Operation',7224,7301,'InGCS Morgan (ftUS)',''),
(6451,'Coordinate_Operation',7238,7301,'InGCS Randolph (ftUS)',''),
(6452,'Coordinate_Operation',7238,7301,'InGCS Wayne (ftUS)',''),
(6453,'Coordinate_Operation',7225,7301,'InGCS Montgomery (m)',''),
(6454,'Coordinate_Operation',7225,7301,'InGCS Putnam (m)',''),
(6455,'Coordinate Reference System',7257,7302,'InGCS 2011 01 (m)',''),
(6456,'Coordinate Reference System',7294,7302,'InGCS 2011 20-43-85 (ftUS)',''),
(6457,'Coordinate_Operation',7226,7301,'InGCS Montgomery (ftUS)',''),
(6458,'Coordinate_Operation',7226,7301,'InGCS Putnam (ftUS)',''),
(6459,'Coordinate Reference System',7294,7301,'NAD83(2011) / InGCS Elkhart (ftUS)',''),
(6460,'Coordinate Reference System',7281,7302,'InGCS 2011 13-47-59 (m)',''),
(6461,'Coordinate Reference System',7260,7302,'InGCS 2011 02 (ftUS)',''),
(6462,'Coordinate Reference System',7269,7302,'InGCS 2011 07 (m)',''),
(6463,'Coordinate Reference System',7281,7301,'NAD83(2011) / InGCS Crawford (m)',''),
(6464,'Coordinate Reference System',7270,7302,'InGCS 2011 07 (ftUS)',''),
(6465,'Coordinate Reference System',7258,7302,'InGCS 2011 01 (ftUS)',''),
(6466,'Coordinate Reference System',7281,7301,'NAD83(2011) / InGCS Lawrence (m)',''),
(6467,'Coordinate Reference System',7281,7301,'NAD83(2011) / InGCS Orange (m)',''),
(6468,'Coordinate Reference System',7294,7301,'NAD83(2011) / InGCS Kosciusko (ftUS)',''),
(6469,'Coordinate Reference System',7294,7301,'NAD83(2011) / InGCS Wabash (ftUS)',''),
(6470,'Coordinate Reference System',7261,7302,'InGCS 2011 03 (m)',''),
(6471,'Coordinate Reference System',7271,7302,'InGCS 2011 08 (m)',''),
(6472,'Coordinate Reference System',7262,7302,'InGCS 2011 03 (ftUS)',''),
(6473,'Coordinate Reference System',7295,7302,'InGCS 2011 21-24-81 (m)',''),
(6474,'Coordinate Reference System',7263,7302,'InGCS 2011 04 (m)',''),
(6475,'Coordinate Reference System',7272,7302,'InGCS 2011 08 (ftUS)',''),
(6476,'Coordinate Reference System',7264,7302,'InGCS 2011 04 (ftUS)',''),
(6477,'Coordinate Reference System',7295,7301,'NAD83(2011) / InGCS Fayette (m)',''),
(6478,'Coordinate Reference System',7273,7302,'InGCS 2011 09 (m)',''),
(6479,'Coordinate Reference System',7282,7302,'InGCS 2011 13-47-59 (ftUS)',''),
(6480,'Coordinate Reference System',7274,7302,'InGCS 2011 09 (ftUS)',''),
(6481,'Datum',1031,7309,'D48',''),
(6482,'Coordinate Reference System',7265,7302,'InGCS 2011 05-18 (m)',''),
(6483,'Coordinate Reference System',7265,7301,'NAD83(2011) / InGCS Blackford (m)',''),
(6484,'Coordinate Reference System',7265,7301,'NAD83(2011) / InGCS Delaware (m)',''),
(6485,'Coordinate Reference System',7282,7301,'NAD83(2011) / InGCS Crawford (ftUS)',''),
(6486,'Coordinate Reference System',7282,7301,'NAD83(2011) / InGCS Lawrence (ftUS)',''),
(6487,'Coordinate Reference System',7282,7301,'NAD83(2011) / InGCS Orange (ftUS)',''),
(6488,'Coordinate Reference System',7295,7301,'NAD83(2011) / InGCS Franklin (m)',''),
(6489,'Coordinate_Operation',3963,7308,'HR1901 to ETRS89 (2)',''),
(6490,'Coordinate Reference System',7275,7302,'InGCS 2011 10-22-72 (m)',''),
(6491,'Coordinate_Operation',3964,7308,'HR1901 to WGS 84 (4)',''),
(6492,'Coordinate Reference System',7266,7302,'InGCS 2011 05-18 (ftUS)',''),
(6493,'Coordinate Reference System',7266,7301,'NAD83(2011) / InGCS Blackford (ftUS)',''),
(6494,'Coordinate Reference System',7266,7301,'NAD83(2011) / InGCS Delaware (ftUS)',''),
(6495,'Coordinate Reference System',7275,7301,'NAD83(2011) / InGCS Clark (m)',''),
(6496,'Datum',6805,7302,'MGI (Ferro)',''),
(6497,'Coordinate Reference System',7275,7301,'NAD83(2011) / InGCS Floyd (m)',''),
(6498,'Coordinate Reference System',7275,7301,'NAD83(2011) / InGCS Scott (m)',''),
(6499,'Coordinate Reference System',7295,7301,'NAD83(2011) / InGCS Union (m)',''),
(6500,'Coordinate Reference System',7297,7301,'NAD83(2011) / InGCS Fountain (m)',''),
(6501,'Coordinate Reference System',3043,7310,'ETRS89 / UTM zone 31','This is the EPSG name for CRS code 25831.'),
(6502,'Coordinate Reference System',7283,7302,'InGCS 2011 14-28 (m)',''),
(6503,'Coordinate Reference System',3043,7307,'DE_ETRS89 / UTM',''),
(6504,'Coordinate Reference System',7283,7301,'NAD83(2011) / InGCS Daviess (m)',''),
(6505,'Coordinate Reference System',3044,7307,'DE_ETRS89 / UTM',''),
(6506,'Coordinate Reference System',3044,7310,'ETRS89 / UTM zone 32','This is the EPSG name for CRS code 25832.'),
(6507,'Coordinate Reference System',7276,7302,'InGCS 2011 10-22-72 (ftUS)',''),
(6508,'Coordinate Reference System',7276,7301,'NAD83(2011) / InGCS Clark (ftUS)',''),
(6509,'Coordinate Reference System',3045,1025,'ETRS89 / UTM zone 3',''),
(6510,'Coordinate Reference System',7276,7301,'NAD83(2011) / InGCS Floyd (ftUS)',''),
(6511,'Coordinate Reference System',7276,7301,'NAD83(2011) / InGCS Scott (ftUS)',''),
(6512,'Coordinate Reference System',7283,7301,'NAD83(2011) / InGCS Greene (m)',''),
(6513,'Coordinate Reference System',7277,7302,'InGCS 2011 11 (m)',''),
(6514,'Coordinate Reference System',7297,7301,'NAD83(2011) / InGCS Warren (m)',''),
(6515,'Coordinate Reference System',7309,7302,'InGCS 2011 31-88 (m)',''),
(6516,'Coordinate Reference System',7309,7301,'NAD83(2011) / InGCS Harrison (m)',''),
(6517,'Coordinate Reference System',7284,7302,'InGCS 2011 14-28 (ftUS)',''),
(6518,'Coordinate Reference System',3045,7307,'DE_ETRS89 / UTM_BB',''),
(6519,'Coordinate Reference System',3045,7310,'ETRS89 / UTM zone 33','This is the EPSG name for CRS code 25833.'),
(6520,'Coordinate Reference System',7284,7301,'NAD83(2011) / InGCS Daviess (ftUS)',''),
(6521,'Coordinate Reference System',7284,7301,'NAD83(2011) / InGCS Greene (ftUS)',''),
(6522,'Coordinate Reference System',7296,7302,'InGCS 2011 21-24-81 (ftUS)',''),
(6523,'Coordinate Reference System',7296,7301,'NAD83(2011) / InGCS Fayette (ftUS)',''),
(6524,'Coordinate Reference System',7296,7301,'NAD83(2011) / InGCS Franklin (ftUS)',''),
(6525,'Coordinate Reference System',7296,7301,'NAD83(2011) / InGCS Union (ftUS)',''),
(6526,'Coordinate Reference System',7285,7302,'InGCS 2011 15-58-78 (m)',''),
(6527,'Coordinate Reference System',7285,7301,'NAD83(2011) / InGCS Dearborn (m)',''),
(6528,'Coordinate Reference System',7285,7301,'NAD83(2011) / InGCS Ohio (m)',''),
(6529,'Coordinate Reference System',7285,7301,'NAD83(2011) / InGCS Switzerland (m)',''),
(6530,'Coordinate Reference System',7309,7301,'NAD83(2011) / InGCS Washington (m)',''),
(6531,'Coordinate Reference System',7298,7302,'InGCS 2011 23-86 (ftUS)',''),
(6532,'Coordinate Reference System',7298,7301,'NAD83(2011) / InGCS Fountain (ftUS)',''),
(6533,'Coordinate Reference System',7298,7301,'NAD83(2011) / InGCS Warren (ftUS)',''),
(6534,'Coordinate Reference System',7286,7302,'InGCS 2011 15-58-78 (ftUS)',''),
(6535,'Coordinate Reference System',7286,7301,'NAD83(2011) / InGCS Dearborn (ftUS)',''),
(6536,'Coordinate Reference System',7286,7301,'NAD83(2011) / InGCS Ohio (ftUS)',''),
(6537,'Coordinate Reference System',7286,7301,'NAD83(2011) / InGCS Switzerland (ftUS)',''),
(6538,'Coordinate Reference System',7315,7302,'InGCS 2011 35-92 (m)',''),
(6539,'Coordinate Reference System',7315,7301,'NAD83(2011) / InGCS Huntington (m)',''),
(6540,'Coordinate Reference System',7315,7301,'NAD83(2011) / InGCS Whitley (m)',''),
(6541,'Coordinate Reference System',7287,7302,'InGCS 2011 16-70 (m)',''),
(6542,'Coordinate Reference System',7287,7301,'NAD83(2011) / InGCS Decatur (m)',''),
(6543,'Coordinate Reference System',7287,7301,'NAD83(2011) / InGCS Rush (m)',''),
(6544,'Coordinate Reference System',7310,7302,'InGCS 2011 31-88 (ftUS)',''),
(6545,'Coordinate Reference System',7299,7302,'InGCS 2011 25-50-71 (m)',''),
(6546,'Coordinate Reference System',7299,7301,'NAD83(2011) / InGCS Fulton (m)',''),
(6547,'Coordinate Reference System',7288,7302,'InGCS 2011 16-70 (ftUS)',''),
(6548,'Coordinate Reference System',7288,7301,'NAD83(2011) / InGCS Decatur (ftUS)',''),
(6549,'Coordinate Reference System',7288,7301,'NAD83(2011) / InGCS Rush (ftUS)',''),
(6550,'Coordinate Reference System',7299,7301,'NAD83(2011) / InGCS Marshall (m)',''),
(6551,'Coordinate Reference System',7289,7302,'InGCS 2011 17 (m)',''),
(6552,'Coordinate Reference System',7299,7301,'NAD83(2011) / InGCS St. Joseph (m)',''),
(6553,'Coordinate Reference System',7290,7302,'InGCS 2011 17 (ftUS)',''),
(6554,'Coordinate Reference System',7310,7301,'NAD83(2011) / InGCS Harrison (ftUS)',''),
(6555,'Coordinate Reference System',7310,7301,'NAD83(2011) / InGCS Washington (ftUS)',''),
(6556,'Coordinate Reference System',7324,7302,'InGCS 2011 39 (ftUS)',''),
(6557,'Coordinate Reference System',7291,7302,'InGCS 2011 19-51 (m)',''),
(6558,'Coordinate Reference System',7291,7301,'NAD83(2011) / InGCS Dubois (m)',''),
(6559,'Coordinate Reference System',7291,7301,'NAD83(2011) / InGCS Martin (m)',''),
(6560,'Coordinate Reference System',7311,7302,'InGCS 2011 33 (m)',''),
(6561,'Coordinate Reference System',7300,7302,'InGCS 2011 25-50-71 (ftUS)',''),
(6562,'Coordinate Reference System',7300,7301,'NAD83(2011) / InGCS Fulton (ftUS)',''),
(6563,'Coordinate Reference System',7292,7302,'InGCS 2011 19-51 (ftUS)',''),
(6564,'Coordinate Reference System',7292,7301,'NAD83(2011) / InGCS Dubois (ftUS)',''),
(6565,'Coordinate Reference System',7292,7301,'NAD83(2011) / InGCS Martin (ftUS)',''),
(6566,'Coordinate Reference System',7300,7301,'NAD83(2011) / InGCS Marshall (ftUS)',''),
(6567,'Coordinate Reference System',7300,7301,'NAD83(2011) / InGCS St. Joseph (ftUS)',''),
(6568,'Coordinate Reference System',7359,7302,'InGCS 2011 76 (m)',''),
(6569,'Coordinate Reference System',7301,7302,'InGCS 2011 26 (m)',''),
(6570,'Coordinate Reference System',7293,7302,'InGCS 2011 20-43-85 (m)',''),
(6571,'Coordinate Reference System',7293,7301,'NAD83(2011) / InGCS Elkhart (m)',''),
(6572,'Coordinate Reference System',7293,7301,'NAD83(2011) / InGCS Kosciusko (m)',''),
(6573,'Coordinate Reference System',7293,7301,'NAD83(2011) / InGCS Wabash (m)',''),
(6574,'Coordinate_Operation',3967,7302,'Virginia Lambert',''),
(6575,'Coordinate Reference System',7312,7302,'InGCS 2011 33 (ftUS)',''),
(6576,'Coordinate Reference System',7302,7302,'InGCS 2011 26 (ftUS)',''),
(6577,'Coordinate Reference System',7325,7302,'InGCS 2011 40 (m)',''),
(6578,'Coordinate Reference System',7303,7302,'InGCS 2011 27 (m)',''),
(6579,'Coordinate Reference System',3970,7302,'NAD83(NSRS) / VA LCC',''),
(6580,'Coordinate Reference System',7316,7302,'InGCS 2011 35-92 (ftUS)',''),
(6581,'Coordinate Reference System',3969,7302,'NAD83(HARN) / VA LCC',''),
(6582,'Coordinate Reference System',3969,7301,'NAD83(HPGN) / Virginia Lambert',''),
(6583,'Coordinate Reference System',7304,7302,'InGCS 2011 27 (ftUS)',''),
(6584,'Coordinate Reference System',7316,7301,'NAD83(2011) / InGCS Huntington (ftUS)',''),
(6585,'Coordinate Reference System',7313,7302,'InGCS 2011 34-52 (m)',''),
(6586,'Coordinate Reference System',7313,7301,'NAD83(2011) / InGCS Howard (m)',''),
(6587,'Coordinate Reference System',7305,7302,'InGCS 2011 29-80 (m)',''),
(6588,'Coordinate Reference System',7305,7301,'NAD83(2011) / InGCS Hamilton (m)',''),
(6589,'Coordinate Reference System',7305,7301,'NAD83(2011) / InGCS Tipton (m)',''),
(6590,'Coordinate Reference System',7313,7301,'NAD83(2011) / InGCS Miami (m)',''),
(6591,'Coordinate Reference System',7316,7301,'NAD83(2011) / InGCS Whitley (ftUS)',''),
(6592,'Coordinate Reference System',7333,7302,'InGCS 2011 45-56 (m)',''),
(6593,'Coordinate Reference System',7306,7302,'InGCS 2011 29-80 (ftUS)',''),
(6594,'Coordinate Reference System',7306,7301,'NAD83(2011) / InGCS Hamilton (ftUS)',''),
(6595,'Coordinate Reference System',7306,7301,'NAD83(2011) / InGCS Tipton (ftUS)',''),
(6596,'Coordinate Reference System',7317,7302,'InGCS 2011 36 (m)',''),
(6597,'Coordinate Reference System',7314,7302,'InGCS 2011 34-52 (ftUS)',''),
(6598,'Coordinate Reference System',7314,7301,'NAD83(2011) / InGCS Howard (ftUS)',''),
(6599,'Coordinate Reference System',7307,7302,'InGCS 2011 30-48 (m)',''),
(6600,'Coordinate Reference System',7307,7301,'NAD83(2011) / InGCS Hancock (m)',''),
(6601,'Coordinate_Operation',3999,7302,'Moldova TM',''),
(6602,'Coordinate Reference System',7307,7301,'NAD83(2011) / InGCS Madison (m)',''),
(6603,'Coordinate Reference System',7314,7301,'NAD83(2011) / InGCS Miami (ftUS)',''),
(6604,'Coordinate Reference System',7326,7302,'InGCS 2011 40 (ftUS)',''),
(6605,'Coordinate Reference System',7318,7302,'InGCS 2011 36 (ftUS)',''),
(6606,'Coordinate Reference System',7308,7302,'InGCS 2011 30-48 (ftUS)',''),
(6607,'Coordinate Reference System',7308,7301,'NAD83(2011) / InGCS Hancock (ftUS)',''),
(6608,'Coordinate Reference System',7308,7301,'NAD83(2011) / InGCS Madison (ftUS)',''),
(6609,'Coordinate Reference System',7333,7301,'NAD83(2011) / InGCS Lake (m)',''),
(6610,'Coordinate Reference System',7333,7301,'NAD83(2011) / InGCS Newton (m)',''),
(6611,'Coordinate Reference System',7339,7302,'InGCS 2011 54-67 (m)',''),
(6612,'Coordinate Reference System',7319,7302,'InGCS 2011 37-64 (m)',''),
(6613,'Coordinate Reference System',7319,7301,'NAD83(2011) / InGCS Jasper (m)',''),
(6614,'Coordinate Reference System',7319,7301,'NAD83(2011) / InGCS Porter (m)',''),
(6615,'Coordinate Reference System',7327,7302,'InGCS 2011 41-49 (m)',''),
(6616,'Coordinate Reference System',7327,7301,'NAD83(2011) / InGCS Johnson (m)',''),
(6617,'Coordinate Reference System',7327,7301,'NAD83(2011) / InGCS Marion (m)',''),
(6618,'Coordinate Reference System',7320,7302,'InGCS 2011 37-64 (ftUS)',''),
(6619,'Coordinate Reference System',7320,7301,'NAD83(2011) / InGCS Jasper (ftUS)',''),
(6620,'Coordinate Reference System',7320,7301,'NAD83(2011) / InGCS Porter (ftUS)',''),
(6621,'Coordinate Reference System',7339,7301,'NAD83(2011) / InGCS Montgomery (m)',''),
(6622,'Coordinate Reference System',7321,7302,'InGCS 2011 38 (m)',''),
(6623,'Coordinate Reference System',7339,7301,'NAD83(2011) / InGCS Putnam (m)',''),
(6624,'Coordinate Reference System',7322,7302,'InGCS 2011 38 (ftUS)',''),
(6625,'Coordinate Reference System',7334,7302,'InGCS 2011 45-56 (ftUS)',''),
(6626,'Coordinate Reference System',7328,7302,'InGCS 2011 41-49 (ftUS)',''),
(6627,'Coordinate Reference System',7328,7301,'NAD83(2011) / InGCS Johnson (ftUS)',''),
(6628,'Coordinate Reference System',7328,7301,'NAD83(2011) / InGCS Marion (ftUS)',''),
(6629,'Coordinate Reference System',7334,7301,'NAD83(2011) / InGCS Lake (ftUS)',''),
(6630,'Coordinate Reference System',7329,7302,'InGCS 2011 42 (m)',''),
(6631,'Coordinate Reference System',7334,7301,'NAD83(2011) / InGCS Newton (ftUS)',''),
(6632,'Coordinate Reference System',7330,7302,'InGCS 2011 42 (ftUS)',''),
(6633,'Coordinate Reference System',7343,7302,'InGCS 2011 61-83 (m)',''),
(6634,'Coordinate Reference System',7343,7301,'NAD83(2011) / InGCS Parke (m)',''),
(6635,'Coordinate Reference System',7343,7301,'NAD83(2011) / InGCS Vermillion (m)',''),
(6636,'Coordinate Reference System',7331,7302,'InGCS 2011 44-57 (m)',''),
(6637,'Coordinate Reference System',7331,7301,'NAD83(2011) / InGCS LaGrange (m)',''),
(6638,'Coordinate Reference System',7331,7301,'NAD83(2011) / InGCS Noble (m)',''),
(6639,'Coordinate Reference System',7340,7302,'InGCS 2011 54-67 (ftUS)',''),
(6640,'Coordinate Reference System',7335,7302,'InGCS 2011 46-66-75 (m)',''),
(6641,'Coordinate Reference System',7335,7301,'NAD83(2011) / InGCS LaPorte (m)',''),
(6642,'Datum',1033,7302,'RGRDC 2005',''),
(6643,'Coordinate Reference System',7332,7302,'InGCS 2011 44-57 (ftUS)',''),
(6644,'Coordinate Reference System',7332,7301,'NAD83(2011) / InGCS LaGrange (ftUS)',''),
(6645,'Coordinate Reference System',7332,7301,'NAD83(2011) / InGCS Noble (ftUS)',''),
(6646,'Coordinate Reference System',7335,7301,'NAD83(2011) / InGCS Pulaski (m)',''),
(6647,'Coordinate Reference System',7335,7301,'NAD83(2011) / InGCS Starke (m)',''),
(6648,'Coordinate Reference System',7340,7301,'NAD83(2011) / InGCS Montgomery (ftUS)',''),
(6649,'Coordinate Reference System',4049,7302,'RGRDC 2005 / Congo TM 14',''),
(6650,'Coordinate Reference System',7340,7301,'NAD83(2011) / InGCS Putnam (ftUS)',''),
(6651,'Coordinate Reference System',4048,7302,'RGRDC 2005 / Congo TM 12',''),
(6652,'Coordinate Reference System',7350,7302,'InGCS 2011 65 (ftUS)',''),
(6653,'Coordinate Reference System',7341,7302,'InGCS 2011 60 (m)',''),
(6654,'Coordinate Reference System',7336,7302,'InGCS 2011 46-66-75 (ftUS)',''),
(6655,'Coordinate Reference System',7336,7301,'NAD83(2011) / InGCS LaPorte (ftUS)',''),
(6656,'Coordinate Reference System',7336,7301,'NAD83(2011) / InGCS Pulaski (ftUS)',''),
(6657,'Coordinate Reference System',7336,7301,'NAD83(2011) / InGCS Starke (ftUS)',''),
(6658,'Coordinate_Operation',7378,7302,'WISCRS Ashland (m)',''),
(6659,'Coordinate Reference System',7342,7302,'InGCS 2011 60 (ftUS)',''),
(6660,'Coordinate Reference System',7360,7302,'InGCS 2011 76 (ftUS)',''),
(6661,'Coordinate Reference System',7337,7302,'InGCS 2011 53-55 (m)',''),
(6662,'Coordinate Reference System',7337,7301,'NAD83(2011) / InGCS Monroe (m)',''),
(6663,'Coordinate Reference System',7337,7301,'NAD83(2011) / InGCS Morgan (m)',''),
(6664,'Coordinate Reference System',7344,7302,'InGCS 2011 61-83 (ftUS)',''),
(6665,'Coordinate Reference System',7344,7301,'NAD83(2011) / InGCS Parke (ftUS)',''),
(6666,'Coordinate Reference System',7344,7301,'NAD83(2011) / InGCS Vermillion (ftUS)',''),
(6667,'Coordinate Reference System',7338,7302,'InGCS 2011 53-55 (ftUS)',''),
(6668,'Coordinate Reference System',7338,7301,'NAD83(2011) / InGCS Monroe (ftUS)',''),
(6669,'Coordinate Reference System',7338,7301,'NAD83(2011) / InGCS Morgan (ftUS)',''),
(6670,'Coordinate Reference System',6312,7302,'CGRS93 / Cyprus LTM',''),
(6671,'Coordinate Reference System',7345,7302,'InGCS 2011 62 (m)',''),
(6672,'Coordinate Reference System',7351,7302,'InGCS 2011 68-89 (m)',''),
(6673,'Coordinate Reference System',7346,7302,'InGCS 2011 62 (ftUS)',''),
(6674,'Coordinate Reference System',7351,7301,'NAD83(2011) / InGCS Randolph (m)',''),
(6675,'Coordinate Reference System',7351,7301,'NAD83(2011) / InGCS Wayne (m)',''),
(6676,'Coordinate Reference System',7361,7302,'InGCS 2011 77 (m)',''),
(6677,'Coordinate Reference System',7347,7302,'InGCS 2011 63-87 (m)',''),
(6678,'Coordinate Reference System',7347,7301,'NAD83(2011) / InGCS Pike (m)',''),
(6679,'Coordinate Reference System',7347,7301,'NAD83(2011) / InGCS Warrick (m)',''),
(6680,'Coordinate_Operation',7379,7302,'WISCRS Ashland (ftUS)',''),
(6681,'Coordinate Reference System',7362,7302,'InGCS 2011 77 (ftUS)',''),
(6682,'Coordinate Reference System',7352,7302,'InGCS 2011 68-89 (ftUS)',''),
(6683,'Coordinate Reference System',7348,7302,'InGCS 2011 63-87 (ftUS)',''),
(6684,'Coordinate Reference System',7348,7301,'NAD83(2011) / InGCS Pike (ftUS)',''),
(6685,'Coordinate Reference System',7348,7301,'NAD83(2011) / InGCS Warrick (ftUS)',''),
(6686,'Coordinate Reference System',7352,7301,'NAD83(2011) / InGCS Randolph (ftUS)',''),
(6687,'Coordinate Reference System',7352,7301,'NAD83(2011) / InGCS Wayne (ftUS)',''),
(6688,'Coordinate_Operation',7380,7302,'WISCRS Bayfield (m)',''),
(6689,'Coordinate Reference System',7353,7302,'InGCS 2011 69 (m)',''),
(6690,'Coordinate_Operation',7383,7302,'WISCRS Burnett (ftUS)',''),
(6691,'Coordinate Reference System',7354,7302,'InGCS 2011 69 (ftUS)',''),
(6692,'Coordinate_Operation',7381,7302,'WISCRS Bayfield (ftUS)',''),
(6693,'Coordinate Reference System',7355,7302,'InGCS 2011 73 (m)',''),
(6694,'Coordinate Reference System',7363,7302,'InGCS 2011 79-91 (m)',''),
(6695,'Coordinate Reference System',7356,7302,'InGCS 2011 73 (ftUS)',''),
(6696,'Coordinate Reference System',7363,7301,'NAD83(2011) / InGCS Tippecanoe (m)',''),
(6697,'Coordinate Reference System',7357,7302,'InGCS 2011 74 (m)',''),
(6698,'Coordinate Reference System',7363,7301,'NAD83(2011) / InGCS White (m)',''),
(6699,'Coordinate Reference System',7358,7302,'InGCS 2011 74 (ftUS)',''),
(6700,'Coordinate_Operation',7395,7302,'WISCRS Price (ftUS)',''),
(6701,'Coordinate_Operation',7382,7302,'WISCRS Burnett (m)',''),
(6702,'Coordinate_Operation',7384,7302,'WISCRS Douglas (m)',''),
(6703,'Coordinate Reference System',7364,7302,'InGCS 2011 79-91 (ftUS)',''),
(6704,'Coordinate Reference System',7364,7301,'NAD83(2011) / InGCS Tippecanoe (ftUS)',''),
(6705,'Coordinate Reference System',7364,7301,'NAD83(2011) / InGCS White (ftUS)',''),
(6706,'Coordinate Reference System',4037,7301,'WGS 84 / UTM zone 35N','This is the name usually used for a similar CRS but with axes transposed - see CRS code 32635.'),
(6707,'Coordinate_Operation',7428,7302,'WISCRS Brown (m)',''),
(6708,'Coordinate Reference System',7365,7302,'InGCS 2011 82 (m)',''),
(6709,'Coordinate Reference System',4038,7301,'WGS 84 / UTM zone 36N','This is the name usually used for a similar CRS but with axes transposed - see CRS code 32636.'),
(6710,'Coordinate_Operation',7385,7302,'WISCRS Douglas (ftUS)',''),
(6711,'Coordinate Reference System',7366,7302,'InGCS 2011 82 (ftUS)',''),
(6712,'Coordinate_Operation',7396,7302,'WISCRS Sawyer (m)',''),
(6713,'Coordinate Reference System',7367,7302,'InGCS 2011 84 (m)',''),
(6714,'Coordinate_Operation',7386,7302,'WISCRS Florence (m)',''),
(6715,'Coordinate Reference System',7368,7302,'InGCS 2011 84 (ftUS)',''),
(6716,'Coordinate_Operation',7434,7302,'WISCRS Clark (m)',''),
(6717,'Coordinate Reference System',7369,7302,'InGCS 2011 90 (m)',''),
(6718,'Coordinate_Operation',7387,7302,'WISCRS Florence (ftUS)',''),
(6719,'Coordinate Reference System',7370,7302,'InGCS 2011 90 (ftUS)',''),
(6720,'Coordinate_Operation',7397,7302,'WISCRS Sawyer (ftUS)',''),
(6721,'Coordinate_Operation',7388,7302,'WISCRS Forest (m)',''),
(6722,'Coordinate_Operation',7429,7302,'WISCRS Brown (ftUS)',''),
(6723,'Coordinate_Operation',7389,7302,'WISCRS Forest (ftUS)',''),
(6724,'Coordinate_Operation',7398,7302,'WISCRS Vilas (m)',''),
(6725,'Coordinate_Operation',7390,7302,'WISCRS Iron (m)',''),
(6726,'Coordinate_Operation',7441,7302,'WISCRS Eau Claire (ftUS)',''),
(6727,'Coordinate_Operation',7391,7302,'WISCRS Iron (ftUS)',''),
(6728,'Coordinate_Operation',7399,7302,'WISCRS Vilas (ftUS)',''),
(6729,'Coordinate_Operation',7392,7302,'WISCRS Oneida (m)',''),
(6730,'Coordinate_Operation',7430,7302,'WISCRS Buffalo (m)',''),
(6731,'Coordinate_Operation',7393,7302,'WISCRS Oneida (ftUS)',''),
(6732,'Coordinate_Operation',7424,7302,'WISCRS Washburn (m)',''),
(6733,'Coordinate_Operation',7394,7302,'WISCRS Price (m)',''),
(6734,'Coordinate_Operation',7435,7302,'WISCRS Clark (ftUS)',''),
(6735,'Coordinate_Operation',7425,7302,'WISCRS Washburn (ftUS)',''),
(6736,'Coordinate_Operation',7426,7302,'WISCRS Barron (m)',''),
(6737,'Coordinate_Operation',7431,7302,'WISCRS Buffalo (ftUS)',''),
(6738,'Coordinate_Operation',7427,7302,'WISCRS Barron (ftUS)',''),
(6739,'Coordinate Reference System',7535,7301,'NAD83(2011) / WISCRS Outagamie (m)',''),
(6740,'Coordinate_Operation',7432,7302,'WISCRS Chippewa (m)',''),
(6741,'Coordinate_Operation',7436,7302,'WISCRS Door (m)',''),
(6742,'Coordinate_Operation',7433,7302,'WISCRS Chippewa (ftUS)',''),
(6743,'Coordinate Reference System',7446,1037,'Cyprus vertical system',''),
(6744,'Coordinate_Operation',7437,7302,'WISCRS Door (ftUS)',''),
(6745,'Coordinate_Operation',7450,7302,'WISCRS Jackson (m)',''),
(6746,'Coordinate_Operation',7438,7302,'WISCRS Dunn (m)',''),
(6747,'Coordinate Reference System',7542,7302,'WISCRS Door (m)',''),
(6748,'Coordinate_Operation',7439,7302,'WISCRS Dunn (ftUS)',''),
(6749,'Coordinate_Operation',7453,7302,'WISCRS Langlade (ftUS)',''),
(6750,'Coordinate_Operation',7440,7302,'WISCRS Eau Claire (m)',''),
(6751,'Coordinate Reference System',7560,7302,'WISCRS Marinette (m)',''),
(6752,'Coordinate_Operation',7451,7302,'WISCRS Jackson (ftUS)',''),
(6753,'Coordinate_Operation',7463,7302,'WISCRS Oconto (ftUS)',''),
(6754,'Coordinate_Operation',7452,7302,'WISCRS Langlade (m)',''),
(6755,'Coordinate_Operation',7454,7302,'WISCRS Lincoln (m)',''),
(6756,'Coordinate_Operation',7471,7302,'WISCRS Rusk (ftUS)',''),
(6757,'Coordinate_Operation',7455,7302,'WISCRS Lincoln (ftUS)',''),
(6758,'Coordinate_Operation',7464,7302,'WISCRS Pepin-Pierce (m)',''),
(6759,'Coordinate_Operation',7456,7302,'WISCRS Marathon (m)',''),
(6760,'Coordinate_Operation',7464,7301,'WISCRS Pepin County (m)',''),
(6761,'Coordinate_Operation',7457,7302,'WISCRS Marathon (ftUS)',''),
(6762,'Coordinate_Operation',7464,7301,'WISCRS Pierce County (m)',''),
(6763,'Coordinate_Operation',7458,7302,'WISCRS Marinette (m)',''),
(6764,'Coordinate_Operation',7479,7302,'WISCRS Trempealeau (ftUS)',''),
(6765,'Coordinate_Operation',7459,7302,'WISCRS Marinette (ftUS)',''),
(6766,'Coordinate_Operation',7465,7302,'WISCRS Pepin-Pierce (ftUS)',''),
(6767,'Coordinate_Operation',7460,7302,'WISCRS Menominee (m)',''),
(6768,'Coordinate_Operation',7465,7301,'WISCRS Pepin County (ftUS)',''),
(6769,'Coordinate_Operation',7461,7302,'WISCRS Menominee (ftUS)',''),
(6770,'Coordinate_Operation',7465,7301,'WISCRS Pierce County (ftUS)',''),
(6771,'Coordinate_Operation',7462,7302,'WISCRS Oconto (m)',''),
(6772,'Coordinate_Operation',7472,7302,'WISCRS Shawano (m)',''),
(6773,'Coordinate_Operation',7466,7302,'WISCRS Polk (m)',''),
(6774,'Coordinate_Operation',7480,7302,'WISCRS Waupaca (m)',''),
(6775,'Coordinate_Operation',7467,7302,'WISCRS Polk (ftUS)',''),
(6776,'Coordinate_Operation',7473,7302,'WISCRS Shawano (ftUS)',''),
(6777,'Coordinate_Operation',7468,7302,'WISCRS Portage (m)',''),
(6778,'Coordinate_Operation',7499,7302,'WISCRS Green-Lafayette (ftUS)',''),
(6779,'Coordinate_Operation',7469,7302,'WISCRS Portage (ftUS)',''),
(6780,'Coordinate_Operation',7474,7302,'WISCRS St. Croix (m)',''),
(6781,'Coordinate_Operation',7470,7302,'WISCRS Rusk (m)',''),
(6782,'Coordinate_Operation',7481,7302,'WISCRS Waupaca (ftUS)',''),
(6783,'Coordinate_Operation',7475,7302,'WISCRS St. Croix (ftUS)',''),
(6784,'Coordinate_Operation',7499,7301,'WISCRS Green County (ftUS)',''),
(6785,'Coordinate_Operation',7476,7302,'WISCRS Taylor (m)',''),
(6786,'Coordinate_Operation',7482,7302,'WISCRS Wood (m)',''),
(6787,'Coordinate_Operation',7477,7302,'WISCRS Taylor (ftUS)',''),
(6788,'Coordinate_Operation',7495,7302,'WISCRS Dodge-Jefferson (ftUS)',''),
(6789,'Coordinate_Operation',7478,7302,'WISCRS Trempealeau (m)',''),
(6790,'Coordinate_Operation',7483,7302,'WISCRS Wood (ftUS)',''),
(6791,'Coordinate_Operation',7484,7302,'WISCRS Adams-Juneau (m)',''),
(6792,'Coordinate_Operation',7484,7301,'WISCRS Adams County (m)',''),
(6793,'Coordinate_Operation',7484,7301,'WISCRS Juneau County (m)',''),
(6794,'Coordinate_Operation',7495,7301,'WISCRS Dodge County (ftUS)',''),
(6795,'Coordinate_Operation',7487,7302,'WISCRS Out-Cal-Win-FdL (ftUS)',''),
(6796,'Coordinate_Operation',7487,7301,'WISCRS Calumet County (ftUS)',''),
(6797,'Coordinate_Operation',7485,7302,'WISCRS Adams-Juneau (ftUS)',''),
(6798,'Coordinate_Operation',7485,7301,'WISCRS Adams County (ftUS)',''),
(6799,'Coordinate_Operation',7485,7301,'WISCRS Juneau County (ftUS)',''),
(6800,'Coordinate_Operation',7487,7301,'WISCRS Fond du Lac County (ftUS)',''),
(6801,'Coordinate_Operation',7487,7301,'WISCRS Outagamie County (ftUS)',''),
(6802,'Coordinate_Operation',7487,7301,'WISCRS Winnebago County (ftUS)',''),
(6803,'Coordinate_Operation',7486,7302,'WISCRS Out-Cal-Win-FdL (m)',''),
(6804,'Coordinate_Operation',7486,7301,'WISCRS Calumet County (m)',''),
(6805,'Coordinate_Operation',7486,7301,'WISCRS Fond du Lac County (m)',''),
(6806,'Coordinate_Operation',7486,7301,'WISCRS Outagamie County (m)',''),
(6807,'Coordinate_Operation',7486,7301,'WISCRS Winnebago County (m)',''),
(6808,'Coordinate_Operation',7495,7301,'WISCRS Jefferson County (ftUS)',''),
(6809,'Coordinate_Operation',7496,7302,'WISCRS Grant(m)',''),
(6810,'Coordinate_Operation',7499,7301,'WISCRS Lafayette County (ftUS)',''),
(6811,'Coordinate_Operation',7488,7302,'WISCRS Columbia (m)',''),
(6812,'Coordinate_Operation',7503,7302,'WISCRS Iowa (ftUS)',''),
(6813,'Coordinate_Operation',7508,7302,'WISCRS La Crosse (m)',''),
(6814,'Coordinate_Operation',7514,7302,'WISCRS Rock (m)',''),
(6815,'Coordinate_Operation',7489,7302,'WISCRS Columbia (ftUS)',''),
(6816,'Coordinate_Operation',7500,7302,'WISCRS GreenLake-Marqt (m)',''),
(6817,'Coordinate_Operation',7490,7302,'WISCRS Crawford (m)',''),
(6818,'Coordinate_Operation',7497,7302,'WISCRS Grant (ftUS)',''),
(6819,'Coordinate_Operation',7491,7302,'WISCRS Crawford (ftUS)',''),
(6820,'Coordinate_Operation',7500,7301,'WISCRS Green Lake County (m)',''),
(6821,'Coordinate_Operation',7492,7302,'WISCRS Dane (m)',''),
(6822,'Coordinate_Operation',7500,7301,'WISCRS Marquette County (m)',''),
(6823,'Coordinate_Operation',7493,7302,'WISCRS Dane (ftUS)',''),
(6824,'Coordinate_Operation',7509,7302,'WISCRS La Crosse (ftUS)',''),
(6825,'Coordinate_Operation',7498,7302,'WISCRS Green-Lafayette (m)',''),
(6826,'Coordinate_Operation',7498,7301,'WISCRS Green County (m)',''),
(6827,'Coordinate_Operation',7494,7302,'WISCRS Dodge-Jefferson (m)',''),
(6828,'Coordinate_Operation',7494,7301,'WISCRS Dodge County (m)',''),
(6829,'Coordinate_Operation',7494,7301,'WISCRS Jefferson County (m)',''),
(6830,'Coordinate_Operation',7498,7301,'WISCRS Lafayette County (m)',''),
(6831,'Coordinate_Operation',7520,7302,'WISCRS Walworth (m)',''),
(6832,'Coordinate_Operation',7505,7302,'WISCRS Oz-Milw-Rac-Ken (ftUS)',''),
(6833,'Coordinate_Operation',7501,7302,'WISCRS GreenLake-Marqt (ftUS)',''),
(6834,'Coordinate_Operation',7501,7301,'WISCRS Green Lake County (ftUS)',''),
(6835,'Coordinate_Operation',7501,7301,'WISCRS Marquette County (ftUS)',''),
(6836,'Coordinate_Operation',7504,7302,'WISCRS Oz-Milw-Rac-Ken (m)',''),
(6837,'Coordinate_Operation',7502,7302,'WISCRS Iowa (m)',''),
(6838,'Coordinate_Operation',7504,7301,'WISCRS Kenosha County (m)',''),
(6839,'Coordinate_Operation',7504,7301,'WISCRS Milwaukee County (m)',''),
(6840,'Coordinate_Operation',7504,7301,'WISCRS Ozaukee County (m)',''),
(6841,'Coordinate_Operation',7504,7301,'WISCRS Racine County (m)',''),
(6842,'Coordinate_Operation',7505,7301,'WISCRS Kenosha County (ftUS)',''),
(6843,'Coordinate_Operation',7505,7301,'WISCRS Milwaukee County (ftUS)',''),
(6844,'Coordinate_Operation',7505,7301,'WISCRS Ozaukee County (ftUS)',''),
(6845,'Coordinate_Operation',7505,7301,'WISCRS Racine County (ftUS)',''),
(6846,'Coordinate_Operation',7510,7302,'WISCRS Monroe (m)',''),
(6847,'Coordinate_Operation',7515,7302,'WISCRS Rock (ftUS)',''),
(6848,'Coordinate_Operation',7511,7302,'WISCRS Monroe (ftUS)',''),
(6849,'Coordinate Reference System',7531,7302,'WISCRS Bayfield (m)',''),
(6850,'Coordinate_Operation',7512,7302,'WISCRS Richland (m)',''),
(6851,'Coordinate_Operation',7506,7302,'WISCRS Kew-Manit-Sheb (m)',''),
(6852,'Coordinate_Operation',7506,7301,'WISCRS Kewaunee County (m)',''),
(6853,'Coordinate_Operation',7506,7301,'WISCRS Manitowoc County (m)',''),
(6854,'Coordinate_Operation',7506,7301,'WISCRS Sheboygan County (m)',''),
(6855,'Coordinate_Operation',7516,7302,'WISCRS Sauk (m)',''),
(6856,'Coordinate_Operation',7513,7302,'WISCRS Richland (ftUS)',''),
(6857,'Coordinate_Operation',7521,7302,'WISCRS Walworth (ftUS)',''),
(6858,'Coordinate_Operation',7517,7302,'WISCRS Sauk (ftUS)',''),
(6859,'Coordinate Reference System',7535,7301,'NAD83(2011) / WISCRS Winnebago (m)',''),
(6860,'Coordinate_Operation',7518,7302,'WISCRS Vernon (m)',''),
(6861,'Coordinate_Operation',7507,7302,'WISCRS Kew-Manit-Sheb (ftUS)',''),
(6862,'Coordinate_Operation',7507,7301,'WISCRS Kewaunee County (ftUS)',''),
(6863,'Coordinate_Operation',7507,7301,'WISCRS Manitowoc County (ftUS)',''),
(6864,'Coordinate_Operation',7507,7301,'WISCRS Sheboygan County (ftUS)',''),
(6865,'Coordinate_Operation',7522,7302,'WISCRS Washington (m)',''),
(6866,'Coordinate_Operation',7519,7302,'WISCRS Vernon (ftUS)',''),
(6867,'Coordinate Reference System',7528,7302,'WISCRS Adams-Juneau (m)',''),
(6868,'Coordinate_Operation',7523,7302,'WISCRS Washington (ftUS)',''),
(6869,'Coordinate Reference System',7528,7301,'NAD83(2011) / WISCRS Adams (m)',''),
(6870,'Coordinate_Operation',7524,7302,'WISCRS Waukesha (m)',''),
(6871,'Coordinate Reference System',7528,7301,'NAD83(2011) / WISCRS Juneau (m)',''),
(6872,'Coordinate_Operation',7525,7302,'WISCRS Waukesha (ftUS)',''),
(6873,'Coordinate Reference System',7532,7302,'WISCRS Brown (m)',''),
(6874,'Coordinate_Operation',7526,7302,'WISCRS Waushara (m)',''),
(6875,'Coordinate Reference System',7546,7302,'WISCRS Florence (m)',''),
(6876,'Coordinate_Operation',7527,7302,'WISCRS Waushara (ftUS)',''),
(6877,'Coordinate Reference System',7533,7302,'WISCRS Buffalo (m)',''),
(6878,'Coordinate Reference System',7536,7302,'WISCRS Chippewa (m)',''),
(6879,'Coordinate Reference System',7529,7302,'WISCRS Ashland (m)',''),
(6880,'Coordinate Reference System',7534,7302,'WISCRS Burnett (m)',''),
(6881,'Coordinate Reference System',7563,7302,'WISCRS Oconto (m)',''),
(6882,'Coordinate Reference System',7537,7302,'WISCRS Clark (m)',''),
(6883,'Coordinate Reference System',7547,7302,'WISCRS Forest (m)',''),
(6884,'Coordinate Reference System',7535,7302,'WISCRS Out-Cal-Win-FdL (m)',''),
(6885,'Coordinate Reference System',7530,7302,'WISCRS Barron (m)',''),
(6886,'Coordinate Reference System',7535,7301,'NAD83(2011) / WISCRS Calumet (m)',''),
(6887,'Coordinate Reference System',7535,7301,'NAD83(2011) / WISCRS Fond du Lac (m)',''),
(6888,'Coordinate Reference System',7561,7302,'WISCRS Menominee (m)',''),
(6889,'Datum',6728,7301,'Pico de las Nieves',''),
(6890,'Coordinate Reference System',7548,7302,'WISCRS Grant (m)',''),
(6891,'Coordinate Reference System',4728,7301,'Pico de las Nieves',''),
(6892,'Coordinate Reference System',4728,7302,'PN84',''),
(6893,'Coordinate Reference System',7538,7302,'WISCRS Columbia (m)',''),
(6894,'Coordinate_Operation',15815,7313,'Pico de las Nieves to WGS 84',''),
(6895,'Coordinate_Operation',15815,7301,'PN84 to WGS 84',''),
(6896,'Coordinate Reference System',7580,7302,'WISCRS Walworth (m)',''),
(6897,'Coordinate Reference System',7562,7302,'WISCRS Monroe (m)',''),
(6898,'Coordinate Reference System',7564,7302,'WISCRS Oneida (m)',''),
(6899,'Coordinate Reference System',7539,7302,'WISCRS Crawford (m)',''),
(6900,'Coordinate Reference System',7549,7302,'WISCRS Green-Lafayette (m)',''),
(6901,'Coordinate Reference System',7540,7302,'WISCRS Dane (m)',''),
(6902,'Coordinate Reference System',7549,7301,'NAD83(2011) / WISCRS Green (m)',''),
(6903,'Coordinate Reference System',7549,7301,'NAD83(2011) / WISCRS Lafayette (m)',''),
(6904,'Coordinate Reference System',7589,7302,'WISCRS Barron (ftUS)',''),
(6905,'Coordinate Reference System',7541,7302,'WISCRS Dodge-Jefferson (m)',''),
(6906,'Coordinate Reference System',7541,7301,'NAD83(2011) / WISCRS Dodge (m)',''),
(6907,'Coordinate Reference System',7541,7301,'NAD83(2011) / WISCRS Jefferson (m)',''),
(6908,'Coordinate Reference System',7565,7302,'WISCRS Pepin-Pierce (m)',''),
(6909,'Coordinate Reference System',7565,7301,'NAD83(2011) / WISCRS Pepin (m)',''),
(6910,'Coordinate Reference System',7550,7302,'WISCRS Green Lake-Marquette (m)',''),
(6911,'Coordinate Reference System',7543,7302,'WISCRS Douglas (m)',''),
(6912,'Coordinate Reference System',7550,7301,'NAD83(2011) / WISCRS Green Lake (m)',''),
(6913,'Coordinate Reference System',7544,7302,'WISCRS Dunn (m)',''),
(6914,'Coordinate Reference System',7550,7301,'NAD83(2011) / WISCRS Marquette (m)',''),
(6915,'Coordinate Reference System',7545,7302,'WISCRS Eau Claire (m)',''),
(6916,'Coordinate_Operation',4078,7301,'ED87 to ETRF89 (1)',''),
(6917,'Coordinate Reference System',7565,7301,'NAD83(2011) / WISCRS Pierce (m)',''),
(6918,'Coordinate Reference System',7551,7302,'WISCRS Iowa (m)',''),
(6919,'Coordinate Reference System',7581,7302,'WISCRS Washburn (m)',''),
(6920,'Coordinate Reference System',7552,7302,'WISCRS Iron (m)',''),
(6921,'Coordinate Reference System',7566,7302,'WISCRS Polk (m)',''),
(6922,'Coordinate Reference System',7553,7302,'WISCRS Jackson (m)',''),
(6923,'Coordinate Reference System',7603,7302,'WISCRS Dunn (ftUS)',''),
(6924,'Coordinate Reference System',7567,7302,'WISCRS Portage (m)',''),
(6925,'Coordinate Reference System',7582,7302,'WISCRS Washington (m)',''),
(6926,'Coordinate Reference System',7568,7302,'WISCRS Price (m)',''),
(6927,'Coordinate Reference System',7590,7302,'WISCRS Bayfield (ftUS)',''),
(6928,'Coordinate Reference System',7554,7302,'WISCRS Oz-Milw-Rac-Ken (m)',''),
(6929,'Coordinate Reference System',7554,7301,'NAD83(2011) / WISCRS Kenosha(m)',''),
(6930,'Coordinate Reference System',7554,7301,'NAD83(2011) / WISCRS Milwaukee (m)',''),
(6931,'Coordinate Reference System',7554,7301,'NAD83(2011) / WISCRS Ozaukee (m)',''),
(6932,'Coordinate Reference System',7554,7301,'NAD83(2011) / WISCRS Racine (m)',''),
(6933,'Coordinate Reference System',7569,7302,'WISCRS Richland (m)',''),
(6934,'Coordinate Reference System',7583,7302,'WISCRS Waukesha (m)',''),
(6935,'Coordinate Reference System',7570,7302,'WISCRS Rock (m)',''),
(6936,'Coordinate Reference System',7619,7302,'WISCRS Marinette (ftUS)',''),
(6937,'Coordinate Reference System',7571,7302,'WISCRS Rusk (m)',''),
(6938,'Coordinate Reference System',7555,7302,'WISCRS Kew-Manit-Sheb (m)',''),
(6939,'Coordinate Reference System',7555,7301,'NAD83(2011) / WISCRS Kewaunee (m)',''),
(6940,'Coordinate Reference System',7555,7301,'NAD83(2011) / WISCRS Manitowoc (m)',''),
(6941,'Coordinate Reference System',7555,7301,'NAD83(2011) / WISCRS Sheboygan (m)',''),
(6942,'Coordinate Reference System',7584,7302,'WISCRS Waupaca (m)',''),
(6943,'Coordinate Reference System',7572,7302,'WISCRS Sauk (m)',''),
(6944,'Coordinate Reference System',7556,7302,'WISCRS La Crosse (m)',''),
(6945,'Coordinate Reference System',7591,7302,'WISCRS Brown (ftUS)',''),
(6946,'Coordinate Reference System',7557,7302,'WISCRS Langlade (m)',''),
(6947,'Coordinate Reference System',7573,7302,'WISCRS Sawyer (m)',''),
(6948,'Coordinate Reference System',7558,7302,'WISCRS Lincoln (m)',''),
(6949,'Coordinate Reference System',7585,7302,'WISCRS Waushara (m)',''),
(6950,'Coordinate Reference System',7559,7302,'WISCRS Marathon (m)',''),
(6951,'Coordinate Reference System',7574,7302,'WISCRS Shawano (m)',''),
(6952,'Coordinate Reference System',7604,7302,'WISCRS Eau Claire (ftUS)',''),
(6953,'Coordinate Reference System',7575,7302,'WISCRS St. Croix (m)',''),
(6954,'Coordinate Reference System',7586,7302,'WISCRS Wood (m)',''),
(6955,'Coordinate Reference System',7576,7302,'WISCRS Taylor (m)',''),
(6956,'Coordinate Reference System',7592,7302,'WISCRS Buffalo (ftUS)',''),
(6957,'Coordinate Reference System',7577,7302,'WISCRS Trempealeau (m)',''),
(6958,'Coordinate Reference System',7632,7302,'WISCRS Sawyer (ftUS)',''),
(6959,'Coordinate Reference System',7578,7302,'WISCRS Vernon (m)',''),
(6960,'Coordinate Reference System',7593,7302,'WISCRS Burnett (ftUS)',''),
(6961,'Coordinate Reference System',7579,7302,'WISCRS Vilas (m)',''),
(6962,'Coordinate Reference System',7587,7302,'WISCRS Adams-Juneau (ftUS)',''),
(6963,'Coordinate Reference System',7587,7301,'NAD83(2011) / WISCRS Adams (ftUS)',''),
(6964,'Coordinate Reference System',7587,7301,'NAD83(2011) / WISCRS Juneau (ftUS)',''),
(6965,'Coordinate Reference System',7605,7302,'WISCRS Florence (ftUS)',''),
(6966,'Coordinate Reference System',7588,7302,'WISCRS Ashland (ftUS)',''),
(6967,'Coordinate Reference System',7620,7302,'WISCRS Menominee (ftUS)',''),
(6968,'Coordinate Reference System',7606,7302,'WISCRS Forest (ftUS)',''),
(6969,'Coordinate Reference System',7594,7302,'WISCRS Out-Cal-Win-FdL (ftUS)',''),
(6970,'Coordinate Reference System',7594,7301,'NAD83(2011) / WISCRS Calumet (ftUS)',''),
(6971,'Datum',6728,7302,'PN84',''),
(6972,'Coordinate Reference System',7594,7301,'NAD83(2011) / WISCRS Fond du Lac (ftUS)',''),
(6973,'Coordinate Reference System',7594,7301,'NAD83(2011) / WISCRS Outagamie (ftUS)',''),
(6974,'Coordinate Reference System',7594,7301,'NAD83(2011) / WISCRS Winnebago (ftUS)',''),
(6975,'Datum',1027,7302,'EGM2008',''),
(6976,'Coordinate Reference System',7595,7302,'WISCRS Chippewa (ftUS)',''),
(6977,'Coordinate Reference System',7607,7302,'WISCRS Grant (ftUS)',''),
(6978,'Coordinate Reference System',7596,7302,'WISCRS Clark (ftUS)',''),
(6979,'Coordinate Reference System',7621,7302,'WISCRS Monroe (ftUS)',''),
(6980,'Coordinate Reference System',7633,7302,'WISCRS Shawano (ftUS)',''),
(6981,'Coordinate Reference System',7622,7302,'WISCRS Oconto (ftUS)',''),
(6982,'Coordinate Reference System',7597,7302,'WISCRS Columbia (ftUS)',''),
(6983,'Coordinate Reference System',3152,7301,'ST74 0 gon 65:-1',''),
(6984,'Coordinate Reference System',7608,7302,'WISCRS Green-Lafayette (ftUS)',''),
(6985,'Coordinate Reference System',7608,7301,'NAD83(2011) / WISCRS Green (ftUS)',''),
(6986,'Coordinate Reference System',7608,7301,'NAD83(2011) / WISCRS Lafayette (ftUS)',''),
(6987,'Coordinate Reference System',7598,7302,'WISCRS Crawford (ftUS)',''),
(6988,'Datum',1152,7302,'WGS 84 (G730)',''),
(6989,'Coordinate Reference System',7599,7302,'WISCRS Dane (ftUS)',''),
(6990,'Coordinate Reference System',7623,7302,'WISCRS Oneida (ftUS)',''),
(6991,'Coordinate Reference System',7634,7302,'WISCRS St. Croix (ftUS)',''),
(6992,'Coordinate Reference System',7609,7302,'WISCRS GreenLake-Marqt (ftUS)',''),
(6993,'Coordinate Reference System',7600,7302,'WISCRS Dodge-Jefferson (ftUS)',''),
(6994,'Coordinate Reference System',7600,7301,'NAD83(2011) / WISCRS Dodge (ftUS)',''),
(6995,'Coordinate Reference System',7600,7301,'NAD83(2011) / WISCRS Jefferson (ftUS)',''),
(6996,'Coordinate Reference System',7609,7301,'NAD83(2011) / WISCRS Green Lake (ftUS)',''),
(6997,'Coordinate Reference System',7601,7302,'WISCRS Door (ftUS)',''),
(6998,'Coordinate Reference System',7609,7301,'NAD83(2011) / WISCRS Marquette (ftUS)',''),
(6999,'Coordinate Reference System',7602,7302,'WISCRS Douglas (ftUS)',''),
(7000,'Coordinate Reference System',7624,7302,'WISCRS Pepin-Pierce (ftUS)',''),
(7001,'Coordinate Reference System',7610,7302,'WISCRS Iowa (ftUS)',''),
(7002,'Coordinate Reference System',7624,7301,'WISCRS Pepin (ftUS)',''),
(7003,'Coordinate Reference System',7611,7302,'WISCRS Iron (ftUS)',''),
(7004,'Coordinate Reference System',7624,7301,'WISCRS Pierce (ftUS)',''),
(7005,'Coordinate Reference System',7612,7302,'WISCRS Jackson (ftUS)',''),
(7006,'Datum',1153,7302,'WGS 84 (G873)',''),
(7007,'Coordinate Reference System',7625,7302,'WISCRS Polk (ftUS)',''),
(7008,'Coordinate Reference System',7635,7302,'WISCRS Taylor (ftUS)',''),
(7009,'Coordinate Reference System',7626,7302,'WISCRS Portage (ftUS)',''),
(7010,'Datum',5203,7302,'EGM84',''),
(7011,'Coordinate Reference System',7613,7302,'WISCRS Oz-Milw-Rac-Ken (ftUS)',''),
(7012,'Coordinate Reference System',7613,7301,'NAD83(2011) / WISCRS Kenosha (ftUS)',''),
(7013,'Coordinate Reference System',7613,7301,'NAD83(2011) / WISCRS Milwaukee (ftUS)',''),
(7014,'Coordinate Reference System',7613,7301,'NAD83(2011) / WISCRS Ozaukee (ftUS)',''),
(7015,'Coordinate Reference System',7613,7301,'NAD83(2011) / WISCRS Racine (ftUS)',''),
(7016,'Coordinate Reference System',7627,7302,'WISCRS Price (ftUS)',''),
(7017,'Coordinate Reference System',7636,7302,'WISCRS Trempealeau (ftUS)',''),
(7018,'Coordinate Reference System',7628,7302,'WISCRS Richland (ftUS)',''),
(7019,'Datum',1154,7302,'WGS 84 (G1150)',''),
(7020,'Coordinate Reference System',7629,7302,'WISCRS Rock (ftUS)',''),
(7021,'Coordinate Reference System',7614,7302,'WISCRS Kew-Manit-Sheb (ftUS)',''),
(7022,'Coordinate Reference System',7614,7301,'NAD83(2011) / WISCRS Kewaunee (ftUS)',''),
(7023,'Coordinate Reference System',7614,7301,'NAD83(2011) / WISCRS Manitowoc (ftUS)',''),
(7024,'Coordinate Reference System',7614,7301,'NAD83(2011) / WISCRS Sheboygan (ftUS)',''),
(7025,'Coordinate Reference System',7637,7302,'WISCRS Vernon (ftUS)',''),
(7026,'Coordinate Reference System',7630,7302,'WISCRS Rusk (ftUS)',''),
(7027,'Coordinate Reference System',7615,7302,'WISCRS La Crosse (ftUS)',''),
(7028,'Datum',5171,7302,'EGM96',''),
(7029,'Coordinate Reference System',7616,7302,'WISCRS Langlade (ftUS)',''),
(7030,'Coordinate Reference System',7631,7302,'WISCRS Sauk (ftUS)',''),
(7031,'Coordinate Reference System',7617,7302,'WISCRS Lincoln (ftUS)',''),
(7032,'Coordinate Reference System',7638,7302,'WISCRS Vilas (ftUS)',''),
(7033,'Coordinate Reference System',7618,7302,'WISCRS Marathon (ftUS)',''),
(7034,'Datum',1155,7302,'WGS 84 (G1674)',''),
(7035,'Coordinate Reference System',4093,7301,'ETRF89 / DKTM1',''),
(7036,'Coordinate Reference System',4093,7301,'EUREF89 / DKTM1',''),
(7037,'Coordinate Reference System',7639,7302,'WISCRS Walworth (ftUS)',''),
(7038,'Coordinate Reference System',4094,7301,'ETRF89 / DKTM2',''),
(7039,'Coordinate Reference System',4094,7301,'EUREF89 / DKTM2',''),
(7040,'Coordinate_Operation',1509,7301,'LV95-Parameters',''),
(7041,'Coordinate Reference System',4095,7301,'ETRF89 / DKTM3',''),
(7042,'Coordinate Reference System',4095,7301,'EUREF89 / DKTM3',''),
(7043,'Coordinate Reference System',4096,7301,'ETRF89 / DKTM4',''),
(7044,'Coordinate Reference System',4096,7301,'EUREF89 / DKTM4',''),
(7045,'Coordinate Reference System',7640,7302,'WISCRS Washburn (ftUS)',''),
(7046,'Datum',1156,7302,'WGS 84 (G1762)',''),
(7047,'Coordinate Reference System',7641,7302,'WISCRS Washington (ftUS)',''),
(7048,'Coordinate_Operation',1753,7301,'GRANIT87-Parameters',''),
(7049,'Coordinate Reference System',7642,7302,'WISCRS Waukesha (ftUS)',''),
(7050,'Unit of Measure',9103,1040,'angular minute',''),
(7051,'Coordinate Reference System',7643,7302,'WISCRS Waupaca (ftUS)',''),
(7052,'Datum',1157,7302,'PZ-90.02',''),
(7053,'Coordinate Reference System',7644,7302,'WISCRS Waushara (ftUS)',''),
(7054,'Unit of Measure',9104,1040,'angular second',''),
(7055,'Coordinate Reference System',7645,7302,'WISCRS Wood (ftUS)',''),
(7056,'Datum',1158,7302,'PZ-90.11',''),
(7057,'Unit of Measure',1031,1040,'angular millisecond',''),
(7058,'Coordinate_Operation',7711,7302,'ETRS89 to ODN (2)',''),
(7059,'Unit of Measure',9105,1040,'gon',''),
(7060,'Unit of Measure',9014,1040,'international fathom',''),
(7061,'Unit of Measure',9093,1040,'mile',''),
(7062,'Unit of Measure',1026,1040,'metre per second',''),
(7063,'Unit of Measure',9102,1040,'angular degree',''),
(7064,'Unit of Measure',9113,1040,'centesimal-second',''),
(7065,'Unit of Measure',9114,1040,'angular mil',''),
(7066,'Unit of Measure',1026,1041,'m/s',''),
(7067,'Coordinate Reference System',3857,7301,'Web Mercator',''),
(7068,'Unit of Measure',9112,1040,'centesimal-minute',''),
(7069,'Unit of Measure',1031,7306,'0.001 seca',''),
(7070,'Unit of Measure',1035,1040,'radian per second',''),
(7071,'Coordinate Reference System',4099,7301,'ETRF89 / DKTM3 + DVR90 height',''),
(7072,'Coordinate Reference System',4099,7301,'EUREF89 / DKTM3 + DVR90 height',''),
(7073,'Unit of Measure',9005,1040,'Clarke foot',''),
(7074,'Unit of Measure',9037,1040,'Clarke yard',''),
(7075,'Coordinate Reference System',4097,7301,'ETRF89 / DKTM1 + DVR90 height',''),
(7076,'Coordinate Reference System',4097,7301,'EUREF89 / DKTM1 + DVR90 height',''),
(7077,'Unit of Measure',9038,1040,'Clarke chain',''),
(7078,'Coordinate Reference System',4098,7301,'ETRF89 / DKTM2 + DVR90 height',''),
(7079,'Coordinate Reference System',4098,7301,'EUREF89 / DKTM2 + DVR90 height',''),
(7080,'Unit of Measure',9039,1040,'Clarke link',''),
(7081,'Unit of Measure',9201,1040,'euclid',''),
(7082,'Unit of Measure',9201,7306,'euc',''),
(7083,'Coordinate Reference System',4100,7301,'ETRF89 / DKTM4 + DVR90 height',''),
(7084,'Coordinate Reference System',4100,7301,'EUREF89 / DKTM4 + DVR90 height',''),
(7085,'Unit of Measure',9302,7306,'link[SeT]',''),
(7086,'Unit of Measure',9301,7306,'chain[SeT]',''),
(7087,'Unit of Measure',9300,7306,'ft[SeT]',''),
(7088,'Unit of Measure',9097,7306,'chain',''),
(7089,'Unit of Measure',9098,7306,'link',''),
(7090,'Unit of Measure',9099,7306,'yd[SeT]',''),
(7091,'Coordinate_Operation',7687,7301,'Kyrg06-68',''),
(7092,'Datum',1160,7302,'Kyrg-06',''),
(7093,'Coordinate Reference System',7692,7301,'Kyrg06-68',''),
(7094,'Coordinate_Operation',7688,7301,'Kyrg06-71',''),
(7095,'Coordinate_Operation',7713,7302,'ETRS89 to ODN (Offshore)(1)',''),
(7096,'Coordinate_Operation',7689,7301,'Kyrg06-74',''),
(7097,'Coordinate Reference System',7693,7301,'Kyrg06-71',''),
(7098,'Coordinate_Operation',7690,7301,'Kyrg06-77',''),
(7099,'Coordinate_Operation',7713,7301,'ETRF89 to Newlyn (Offshore) (1)',''),
(7100,'Coordinate_Operation',7691,7301,'Kyrg06-80',''),
(7101,'Coordinate Reference System',7694,7301,'Kyrg06-74',''),
(7102,'Coordinate_Operation',7711,7301,'ETRF89 to Newlyn (2)',''),
(7103,'Coordinate Reference System',7695,7301,'Kyrg06-77',''),
(7104,'Coordinate_Operation',7718,7301,'ETRS89 to Belfast Lough height (2)',''),
(7105,'Coordinate Reference System',7696,7301,'Kyrg06-80',''),
(7106,'Coordinate_Operation',7714,7301,'ETRF89 to Lerwick height (2)',''),
(7107,'Coordinate_Operation',7718,7301,'ETRF89 to Belfast height (2)',''),
(7108,'Coordinate_Operation',7701,7307,'LV_AMST2000 / NH to EVRF2007',''),
(7109,'Coordinate Reference System',7700,7301,'LAS-2000 height',''),
(7110,'Coordinate_Operation',7715,7301,'ETRF89 to Stornoway height (2)',''),
(7111,'Coordinate_Operation',7724,7302,'Arunachal Pradesh',''),
(7112,'Coordinate_Operation',7716,7301,'ETRF89 to St. Marys height (2)',''),
(7113,'Coordinate_Operation',7719,7301,'ETRF89 to Malin Head height (2)',''),
(7114,'Coordinate_Operation',7717,7301,'ETRF89 to Douglas height (2)',''),
(7115,'Coordinate_Operation',7727,7302,'Delhi',''),
(7116,'Coordinate_Operation',7725,7302,'Assam',''),
(7117,'Coordinate_Operation',7728,7302,'Gujarat',''),
(7118,'Coordinate_Operation',7726,7302,'Bihar',''),
(7119,'Coordinate_Operation',7735,7302,'Manipur',''),
(7120,'Coordinate_Operation',7729,7302,'Haryana',''),
(7121,'Coordinate_Operation',7752,7302,'Tamil Nadu',''),
(7122,'Coordinate_Operation',7730,7302,'Himachal Pradesh',''),
(7123,'Coordinate_Operation',7736,7302,'Meghalaya',''),
(7124,'Coordinate_Operation',7731,7302,'Jammu and Kashmir',''),
(7125,'Datum',1165,7302,'ITRF2014',''),
(7126,'Coordinate_Operation',7732,7302,'Jharkhand',''),
(7127,'Coordinate_Operation',7737,7302,'Nagaland',''),
(7128,'Coordinate_Operation',7733,7302,'Madhya Pradesh',''),
(7129,'Coordinate_Operation',7753,7302,'Tripura',''),
(7130,'Coordinate_Operation',7734,7302,'Maharashtra',''),
(7131,'Coordinate_Operation',7738,7302,'India Northeast',''),
(7133,'Coordinate_Operation',7739,7302,'Orissa',''),
(7134,'Coordinate_Operation',7754,7302,'West Bengal',''),
(7135,'Coordinate_Operation',7740,7302,'Punjab',''),
(7136,'Coordinate_Operation',7722,7301,'India NSF LCC',''),
(7137,'Coordinate_Operation',7741,7302,'Rajasthan',''),
(7139,'Coordinate_Operation',7742,7302,'Uttar Pradesh',''),
(7140,'Coordinate Reference System',7791,7301,'RDN2008 / UTM zone 32N (E-N)',''),
(7141,'Coordinate_Operation',7743,7302,'Uttaranchal',''),
(7143,'Coordinate_Operation',7744,7302,'Andaman and Nicobar',''),
(7144,'Coordinate Reference System',7792,7301,'RDN2008 / TM33 (E-N)',''),
(7145,'Coordinate_Operation',7745,7302,'Chhattisgarh',''),
(7147,'Coordinate_Operation',7746,7302,'Goa',''),
(7148,'Coordinate Reference System',7792,7301,'RDN2008 / UTM zone 33N (E-N)',''),
(7149,'Coordinate_Operation',7747,7302,'Karnataka',''),
(7150,'Coordinate Reference System',7791,7301,'RDN2008 / TM32 (E-N)',''),
(7151,'Coordinate_Operation',7748,7302,'Kerala',''),
(7152,'Coordinate Reference System',7793,7301,'RDN2008 / UTM zone 34N (E-N)',''),
(7153,'Coordinate_Operation',7749,7302,'Lakshadweep',''),
(7154,'Coordinate Reference System',7800,7302,'CS2005 zone 35',''),
(7155,'Coordinate_Operation',7750,7302,'Mizoram',''),
(7156,'Coordinate Reference System',7794,7301,'RDN2008 / Fuso Italia (E-N)',''),
(7157,'Coordinate_Operation',7751,7302,'Sikkim',''),
(7158,'Datum',1167,7302,'BGS2005',''),
(7159,'Coordinate Reference System',7795,7301,'RDN2008 / Fuso 12 (E-N)',''),
(7160,'Coordinate Reference System',7799,7302,'CS2005 zone 34',''),
(7161,'Coordinate Reference System',7799,7301,'Coordinate System 2005 zone 35',''),
(7162,'Coordinate Reference System',7815,7301,'WGS 84 (Original)',''),
(7163,'Coordinate Reference System',7800,7301,'Coordinate System 2005 zone 35',''),
(7164,'Datum',1166,7302,'WGS 84 (Transit)',''),
(7165,'Coordinate Reference System',7803,7301,'BGS2005 / UTM zone 34N (E-N)',''),
(7166,'Coordinate_Operation',7802,7302,'CCS2005',''),
(7167,'Coordinate Reference System',7816,7301,'WGS 84 (Original)',''),
(7168,'Coordinate_Operation',7808,7301,'IGS08 to NAD83(PA11) (1)',''),
(7169,'Coordinate Reference System',7804,7301,'BGS2005 / UTM zone 35 (E-N)',''),
(7170,'Coordinate Reference System',7825,7302,'Pulkovo 1942 / CS63 X1',''),
(7171,'Coordinate Reference System',7831,7302,'Pulkovo 1942 / CS63 X7',''),
(7172,'Coordinate Reference System',7826,7302,'Pulkovo 1942 / CS63 X2',''),
(7173,'Coordinate_Operation',7806,7301,'SC 1942/83 to SC2005(1)',''),
(7174,'Coordinate_Operation',7809,7301,'IGS08 to NAD83(MA11) (1)',''),
(7175,'Coordinate Reference System',7827,7302,'Pulkovo 1942 / CS63 X3',''),
(7176,'Area',2589,7301,'Indonesia - Irian Jaya - Tangguh',''),
(7177,'Coordinate Reference System',7828,7302,'Pulkovo 1942 / CS63 X4',''),
(7178,'Datum',6710,7301,'ASTRO DOS 71/4',''),
(7179,'Coordinate Reference System',7829,7302,'Pulkovo 1942 / CS63 X5',''),
(7180,'Coordinate_Operation',7833,7301,'Albanian 1987 to KRGJSH-2010 (1)',''),
(7181,'Coordinate Reference System',7830,7302,'Pulkovo 1942 / CS63 X6',''),
(7182,'Coordinate_Operation',7833,1038,'ALB86 to KRGJSH-2010 (1)',''),
(7183,'Datum',1168,7302,'GDA2020',''),
(7184,'Coordinate_Operation',7834,1038,'ALB86 to WGS 84 (1)',''),
(7185,'Datum',1169,7317,'NZVD2016',''),
(7186,'Coordinate Reference System',7845,7302,'GDA2020 / Geoscience Australia Lambert',''),
(7187,'Coordinate Reference System',4710,7301,'ASTRO DOS 71/4',''),
(7188,'Coordinate Reference System',4710,7301,'St. Helena 1971',''),
(7189,'Datum',6710,7301,'St. Helena 1971',''),
(7190,'Datum',1170,7302,'DHHN2016',''),
(7191,'Datum',1170,7301,'Deutsches Haupthhennetz 2016',''),
(7192,'Coordinate_Operation',15798,7301,'St. Helena 1971 to WGS 84 (1)',''),
(7193,'Coordinate Reference System',7837,7307,'DE_AMST_2016 / NH',''),
(7194,'Datum',1171,7302,'POM96',''),
(7195,'Coordinate_Operation',7838,7307,'DE_AMST_2016 / NH to EVRF2007',''),
(7196,'Coordinate_Operation',7875,7302,'SHLG71',''),
(7197,'Datum',1172,7302,'POM08',''),
(7198,'Datum',1174,7302,'SHGD2015',''),
(7199,'Coordinate_Operation',7876,7302,'SHLG(Tritan)',''),
(7200,'Datum',1173,7301,'WGS 84 Tritan St. Helena',''),
(7201,'Coordinate Reference System',7879,7301,'WGS 84 Tritan St. Helena',''),
(7202,'Coordinate Reference System',7878,7301,'St. Helena 1971 / UTM zone 30S',''),
(7203,'Coordinate Reference System',7880,7301,'WGS 84 Tritan St. Helena',''),
(7204,'Coordinate Reference System',7881,7301,'WGS 84 Tritan St. Helena',''),
(7205,'Datum',1177,7302,'SHVD2015',''),
(7206,'Coordinate Reference System',7882,7301,'WGS 84 Tritan St. Helena / SHLG(Tritan)',''),
(7207,'Coordinate_Operation',17361,7301,'Vicgrid94',''),
(7208,'Coordinate_Operation',17361,7301,'Vicgrid2020',''),
(7209,'Coordinate_Operation',7897,7301,'WGS 84 Tritan St Helena to SHGD2015 (1)',''),
(7210,'Coordinate_Operation',7898,7301,'WGS84 Tritan St. Helena to WGS 84 (1)',''),
(7211,'Coordinate Reference System',7899,7301,'GDA2020 / Vicgrid2020',''),
(7212,'Coordinate Reference System',3111,7301,'GDA94 / Vicgrid94',''),
(7213,'Coordinate Reference System',7908,7301,'IGS97','Used by IGS from 2000-06-04 to 2001-12-01. For most practical purposes IGS97 is equivalent to ITRF97.'),
(7218,'Coordinate Reference System',7909,7301,'IGS00','Used by IGS from 2001-01-02 to 2004-01-10. For most practical purposes IGS00 is equivalent to ITRF2000.'),
(7220,'Unit of Measure',9111,7301,'sexagesimal degree DDD.MMm',''),
(7222,'Unit of Measure',9121,7301,'sexagesimal degree DDDMMSS.sss',''),
(7224,'Coordinate Reference System',7909,7301,'IGb00','Used by IGS from 2004-01-11 to 2006-11-04. For most practical purposes IGb05 is equivalent to ITRF2000.'),
(7226,'Coordinate Reference System',7910,7301,'IGS05','Used by IGS from 2006-11-05 to 2011-04-16. For most practical purposes IGS05 is equivalent to ITRF2005.'),
(7228,'Coordinate Reference System',7911,7301,'IGS08','Used by IGS from 2011-04-17 to 2012-10-06. For most practical purposes IGS08 is equivalent to ITRF2008.'),
(7230,'Coordinate Reference System',7911,7301,'IGb08','Used by IGS from 2012-10-07. For most practical purposes IGb08 is equivalent to ITRF2008.'),
(7232,'Coordinate Reference System',5332,7301,'IGS08','Used by IGS from 2011-04-17 to 2012-10-06. For most practical purposes IGS08 is equivalent to ITRF2008.'),
(7233,'Coordinate Reference System',5332,7301,'IGb08','Used by IGS from 2012-10-07. For most practical purposes IGb08 is equivalent to ITRF2008.'),
(7234,'Coordinate Reference System',4896,7301,'IGS2005','Used by IGS from 2006-11-05 to 2011-04-16. For most practical purposes IGS05 is equivalent to ITRF2005.'),
(7235,'Coordinate Reference System',4919,7301,'IGS00','Used by IGS from 2001-01-02 to 2004-01-10. For most practical purposes IGS00 is equivalent to ITRF2000.'),
(7236,'Coordinate Reference System',4919,7301,'IGb00','Used by IGS from 2004-01-11 to 2006-11-04. For most practical purposes IGb00 is equivalent to ITRF2000.'),
(7237,'Coordinate Reference System',4918,7301,'IGS97','Used by IGS from 2000-06-04 to 2001-12-01. For most practical purposes IGS97 is equivalent to ITRF97.'),
(7238,'Datum',1176,7301,'MSL Tritan',''),
(7239,'Coordinate Reference System',7887,7301,'SHGD2015 / UTM zone 30S',''),
(7240,'Coordinate_Operation',7913,7301,'OSTN97',''),
(7241,'Coordinate_Operation',7913,7301,'ETRF89 to OSGB 1936 / British National Grid (1)',''),
(7242,'Coordinate Reference System',7887,7301,'St. Helena Map Grid 2015',''),
(7243,'Coordinate_Operation Method',9663,7301,'Geographic3D to GravityRelatedHeight (OSGM02-GB)','File format first introduced for OSGM02 geoid but subsequently also used for OSGM16.'),
(7244,'Coordinate_Operation',7952,7302,'OSTN02',''),
(7245,'Coordinate_Operation',7952,7301,'ETRF97 to OSGB 1936 / British National Grid (2)','At epoch 2001.553.'),
(7246,'Coordinate Reference System',7888,7301,'MSL 1971 height',''),
(7247,'Coordinate Reference System',7889,7301,'MSL Tritan height',''),
(7248,'Coordinate_Operation',7953,7302,'OSTN15',''),
(7249,'Coordinate_Operation',7953,7301,'ETRF97 to OSGB 1936 / British National Grid (3)','At epoch 2009.756.'),
(7250,'Datum',1175,7301,'MSL 1971',''),
(7251,'Datum',1176,7302,'St. Helena Tritan 2011',''),
(7252,'Coordinate Reference System',7877,7301,'St. Helena 1971 / SHLG71',''),
(7253,'Coordinate Reference System',7954,7301,'St. Helena 1971 / UTM zone 30S + Jamestown 1971 height',''),
(7254,'Coordinate_Operation',7893,7301,'St. Helena 1971 to SHGD2015 (1)',''),
(7255,'Coordinate_Operation',7894,7301,'St. Helena 1971 to WGS 84 (2)',''),
(7256,'Coordinate_Operation',7895,7301,'St. Helena 1971 to SHGD2015 (2)',''),
(7257,'Coordinate_Operation',7896,7301,'SHGD2015 to St. Helena 1971 (2)',''),
(7259,'Coordinate Reference System',22196,7301,'C Inchauspe /Argentina 6',''),
(7260,'Coordinate Reference System',22197,7301,'C Inchauspe /Argentina 7',''),
(7261,'Coordinate Reference System',22195,7301,'C Inchauspe /Argentina 5',''),
(7262,'Coordinate Reference System',22193,7301,'C Inchauspe /Argentina 3',''),
(7263,'Coordinate Reference System',22194,7301,'C Inchauspe /Argentina 4',''),
(7264,'Coordinate Reference System',22192,7301,'C Inchauspe /Argentina 2',''),
(7265,'Coordinate Reference System',22191,7301,'C Inchauspe /Argentina 1',''),
(7266,'Coordinate Reference System',2315,7301,'Campo Inchauspe /UTM 19S',''),
(7267,'Coordinate Reference System',2316,7301,'Campo Inchauspe /UTM 20S',''),
(7270,'Coordinate_Operation',7958,7301,'ETRS89 to Belfast Lough height (2)',''),
(7271,'Coordinate_Operation',7958,7301,'ETRF89 to Belfast height (2)',''),
(7273,'Coordinate_Operation',7959,7301,'ETRF89 to Malin Head height (2)',''),
(7431,'Coordinate_Operation',1068,1026,'Guam 1963 to Guam Geodetic Network 1993 (1)',''),
(7442,'Coordinate Reference System',4152,1026,'Guam Geodetic Network 1993','This alias is used only in Guam, where NAD83(HARN) is realised through GGN93.'),
(7448,'Coordinate Reference System',4152,1026,'GGN93','This abbreviation is used only in Guam, where NAD83(HARN) is realised through GGN93.'),
(7528,'Datum',6152,1026,'Guam Geodetic Network 1993','This alias is used only in Guam, where NAD83(HARN) is realised through GGN93.'),
(7530,'Coordinate Reference System',4957,1026,'Guam Geodetic Network 1993','This alias is used only in Guam, where NAD83(HARN) is realised through GGN93.'),
(7531,'Coordinate Reference System',4957,1026,'GGN93','This abbreviation is used only in Guam, where NAD83(HARN) is realised through GGN93.'),
(7535,'Coordinate Reference System',4956,1026,'Guam Geodetic Network 1993','This alias is used only in Guam, where NAD83(HARN) is realised through GGN93.'),
(7536,'Coordinate Reference System',4956,1026,'GGN93','This abbreviation is used only in Guam, where NAD83(HARN) is realised through GGN93.'),
(7538,'Coordinate_Operation',1068,1026,'Guam 1963 to GGN93',''),
(7559,'Coordinate Reference System',4417,7302,'Pulkovo 42(83) / 3GK zn7',''),
(7561,'Coordinate Reference System',4434,7302,'Pulkovo 42(83) / 3GK zn8',''),
(7576,'Coordinate Reference System',4152,1026,'NAD83','This alias is used only in Guam. The name is that of a different system applicable only in North America (see CRS code 4269).'),
(7602,'Coordinate Reference System',4414,7302,'GGN93 / Guam Map Grid',''),
(7603,'Coordinate Reference System',4414,7301,'Guam Geodetic Network 1993 / Guam Map Grid',''),
(7604,'Coordinate Reference System',4414,1026,'NAD83 / Guam Map Grid','The base geographic CRS alias NAD83 is used only in Guam. The name is that of a different system applicable only in North America (see CRS code 4269).'),
(7605,'Coordinate Reference System',4414,7301,'NAD83(HPGN) / Guam Map Grid',''),
(7609,'Datum',6152,1026,'NAD83','This alias is used only in Guam. The name is that of a different system applicable only in North America (see datum code 6269).'),
(7701,'Coordinate Reference System',4437,7302,'NAD83(NSRS) / PR and VI',''),
(7726,'Coordinate_Operation',4454,7302,'New York Long Island','This alias is ambiguous as also used for SPCS83 projection.'),
(7728,'Coordinate Reference System',4455,7302,'NAD27 / Pennsylvania S',''),
(7730,'Coordinate Reference System',4456,7302,'NAD27 / New York Long Is',''),
(7732,'Coordinate Reference System',4457,7302,'NAD83 / S Dakota N (ftUS)',''),
(7739,'Coordinate_Operation',4461,7301,'NAD83(HPGN) to NAD83(NSRS2007) (1)',''),
(7746,'Coordinate Reference System',3112,7302,'GDA94 / GA LCC',''),
(7747,'Coordinate Reference System',3112,7301,'GDA94 / Geoscience LCC',''),
(7752,'Coordinate_Operation',4436,7302,'Pennsylvania South','This alias is ambiguous as also used for SPCS83 projection.'),
(7757,'Coordinate_Operation',4464,7301,'Test alias 1','For testing Error #12 only'),
(7758,'Coordinate_Operation',4464,7300,'Test alias 2','For testing Error #12 only'),
(7812,'Coordinate Reference System',4474,7302,'Cadastre 1997 / UTM 38S',''),
(7817,'Datum',1036,7302,'RGM04',''),
(7819,'Datum',1038,7302,'RGSPM06',''),
(7964,'Datum',1039,7317,'NZVD2009',''),
(8029,'Coordinate Reference System',4458,7301,'Dunedin-Bluff height',''),
(8041,'Coordinate_Operation',4460,7301,'ACRESLC',''),
(8044,'Coordinate Reference System',4462,7317,'WGS 84 / ACRESLC',''),
(8047,'Coordinate_Operation',17362,7302,'GA LCC',''),
(8081,'Coordinate Reference System',4479,7302,'CGCS2000',''),
(8084,'Coordinate Reference System',4480,7302,'CGCS2000',''),
(8115,'Coordinate Reference System',4495,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 17','Part of the China National Coordinate System of 2000.'),
(8116,'Coordinate Reference System',4495,7302,'CGCS2000 / G-K zone 17',''),
(8121,'Coordinate Reference System',4492,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 14','Part of the China National Coordinate System of 2000.'),
(8122,'Coordinate Reference System',4492,7302,'CGCS2000 / G-K zone 14',''),
(8124,'Coordinate Reference System',4493,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 15','Part of the China National Coordinate System of 2000.'),
(8125,'Coordinate Reference System',4493,7302,'CGCS2000 / G-K zone 15',''),
(8132,'Coordinate Reference System',4496,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 18','Part of the China National Coordinate System of 2000.'),
(8133,'Coordinate Reference System',4496,7302,'CGCS2000 / G-K zone 18',''),
(8142,'Coordinate Reference System',4498,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 20','Part of the China National Coordinate System of 2000.'),
(8143,'Coordinate Reference System',4498,7302,'CGCS2000 / G-K zone 20',''),
(8147,'Coordinate Reference System',4499,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 21','Part of the China National Coordinate System of 2000.'),
(8148,'Coordinate Reference System',4499,7302,'CGCS2000 / G-K zone 21',''),
(8152,'Coordinate Reference System',4500,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 22','Part of the China National Coordinate System of 2000.'),
(8153,'Coordinate Reference System',4500,7302,'CGCS2000 / G-K zone 22',''),
(8157,'Coordinate Reference System',4501,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 23','Part of the China National Coordinate System of 2000.'),
(8158,'Coordinate Reference System',4501,7302,'CGCS2000 / G-K zone 23',''),
(8162,'Coordinate Reference System',4502,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 75E',''),
(8163,'Coordinate Reference System',4502,7302,'CGCS2000 / G-K CM 75E',''),
(8167,'Coordinate Reference System',4503,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 81E',''),
(8168,'Coordinate Reference System',4503,7302,'CGCS2000 / G-K CM 81E',''),
(8172,'Coordinate Reference System',4504,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 87E',''),
(8173,'Coordinate Reference System',4504,7302,'CGCS2000 / G-K CM 87E',''),
(8177,'Coordinate Reference System',4505,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 93E',''),
(8178,'Coordinate Reference System',4505,7302,'CGCS2000 / G-K CM 93E',''),
(8182,'Coordinate Reference System',4506,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 99E',''),
(8183,'Coordinate Reference System',4506,7302,'CGCS2000 / G-K CM 99E',''),
(8187,'Coordinate Reference System',4507,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 105E',''),
(8188,'Coordinate Reference System',4507,7302,'CGCS2000 / G-K CM 105E',''),
(8192,'Coordinate Reference System',4508,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 111E',''),
(8193,'Coordinate Reference System',4508,7302,'CGCS2000 / G-K CM 111E',''),
(8197,'Coordinate Reference System',4509,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 117E',''),
(8198,'Coordinate Reference System',4509,7302,'CGCS2000 / G-K CM 117E',''),
(8202,'Coordinate Reference System',4510,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 123E',''),
(8203,'Coordinate Reference System',4510,7302,'CGCS2000 / G-K CM 123E',''),
(8212,'Coordinate Reference System',4512,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 135E',''),
(8213,'Coordinate Reference System',4512,7302,'CGCS2000 / G-K CM 135E',''),
(8215,'Coordinate Reference System',4490,7302,'CGCS2000',''),
(8216,'Coordinate Reference System',3907,7308,'HDKS zone 5','HDKS = Hrvatski Drzavni Koordinatni Sustav'),
(8217,'Coordinate Reference System',3908,7308,'HDKS zone 6','HDKS = Hrvatski Drzavni Koordinatni Sustav'),
(8218,'Coordinate Reference System',3907,7309,'D48 zone 5',''),
(8219,'Coordinate_Operation',3963,7307,'HR_HDKS to ETRS89',''),
(8220,'Datum',1035,7302,'REGCAN95',''),
(8221,'Coordinate_Operation',3962,7313,'Hermannskogel to WGS 84',''),
(8222,'Coordinate Reference System',3907,7307,'HR_HDKS / HR_TM','This same identifier used for both of zones 5 and 6.'),
(8223,'Coordinate Reference System',3908,7307,'HR_HDKS / HR_TM','This same identifier used for both of zones 5 and 6.'),
(8224,'Coordinate Reference System',3911,7307,'SI_D48 / SI_TM',''),
(8225,'Coordinate Reference System',3911,7309,'D48 / Slovenia Grid',''),
(8226,'Coordinate_Operation',3914,7307,'SI_D48 to ETRS89',''),
(8227,'Coordinate_Operation',3914,7309,'D48 to ETRS89 (3)',''),
(8228,'Coordinate_Operation',3915,7309,'D48 to WGS 84 (5)',''),
(8229,'Coordinate_Operation',3897,7302,'NSIDC EASE-grid north projection',''),
(8230,'Coordinate_Operation',3898,7302,'NSIDC EASE-grid south projection',''),
(8231,'Coordinate_Operation',3914,7301,'MGI 1901 to ETRF89 (3)',''),
(8232,'Datum',6761,7308,'HTRS96',''),
(8233,'Coordinate Reference System',3912,7309,'D48 / GK',''),
(8234,'Coordinate_Operation',3929,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (1)',''),
(8235,'Coordinate_Operation',3930,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (2)',''),
(8236,'Coordinate_Operation',3931,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (3)',''),
(8237,'Coordinate_Operation',3932,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (4)',''),
(8238,'Coordinate_Operation',3933,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (5)',''),
(8239,'Coordinate_Operation',3934,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (6)',''),
(8240,'Coordinate_Operation',3935,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (7)',''),
(8241,'Coordinate_Operation',3936,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (8)',''),
(8242,'Coordinate_Operation',3937,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (9)',''),
(8243,'Coordinate_Operation',3938,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (10)',''),
(8244,'Coordinate_Operation',3939,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (11)',''),
(8245,'Coordinate_Operation',3940,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (12)',''),
(8246,'Coordinate_Operation',3941,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (13)',''),
(8247,'Coordinate_Operation',3951,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (14)',''),
(8248,'Coordinate_Operation',3952,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (15)',''),
(8249,'Coordinate_Operation',3953,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (16)',''),
(8250,'Coordinate_Operation',3954,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (17)',''),
(8251,'Coordinate_Operation',3955,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (18)',''),
(8252,'Coordinate_Operation',3956,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (19)',''),
(8253,'Coordinate_Operation',3957,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (20)',''),
(8254,'Coordinate_Operation',3958,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (21)',''),
(8255,'Coordinate_Operation',3959,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (22)',''),
(8256,'Coordinate_Operation',3960,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (23)',''),
(8257,'Coordinate_Operation',3961,7301,'MGI 1901 / Slovene National Grid to Slovenia 1996 / Slovene National Grid (24)',''),
(8258,'Coordinate_Operation',3916,7309,'D48 to D96 (1)',''),
(8259,'Coordinate_Operation',3917,7309,'D48 to WGS 84 (9)',''),
(8260,'Coordinate_Operation',3918,7309,'D48 to D96 (2)',''),
(8261,'Coordinate_Operation',3919,7309,'D48 to D96 (3)',''),
(8262,'Coordinate_Operation',3921,7309,'D48 to D96 (4)',''),
(8263,'Coordinate_Operation',3922,7309,'D48 to D96 (5)',''),
(8264,'Coordinate_Operation',3923,7309,'D48 to D96 (6)',''),
(8265,'Coordinate_Operation',3924,7309,'D48 to D96 (7)',''),
(8266,'Coordinate_Operation',3925,7309,'D48 to D96 (8)',''),
(8267,'Coordinate_Operation',3926,7309,'D48 to D96 (9)',''),
(8268,'Coordinate_Operation',3927,7309,'D48 to D96 (10)',''),
(8269,'Coordinate_Operation',3928,7309,'D48 to D96 (11)',''),
(8270,'Coordinate Reference System',3985,7302,'Katanga 1955 / Lambert',''),
(8271,'Coordinate Reference System',4050,7302,'RGRDC 2005 / Congo TM 16',''),
(8272,'Coordinate Reference System',4051,7302,'RGRDC 2005 / Congo TM 18',''),
(8273,'Coordinate Reference System',4056,7302,'RGRDC 2005 / Congo TM 20',''),
(8274,'Coordinate Reference System',4057,7302,'RGRDC 2005 / Congo TM 22',''),
(8275,'Coordinate Reference System',4058,7302,'RGRDC 2005 / Congo TM 24',''),
(8276,'Coordinate Reference System',4059,7302,'RGRDC 2005 / Congo TM 26',''),
(8277,'Coordinate Reference System',4060,7302,'RGRDC 2005 / Congo TM 28',''),
(8278,'Coordinate Reference System',4061,7302,'RGRDC 2005 / UTM 33S',''),
(8279,'Coordinate Reference System',4062,7302,'RGRDC 2005 / UTM 34S',''),
(8280,'Coordinate Reference System',4063,7302,'RGRDC 2005 / UTM 35S',''),
(8284,'Ellipsoid',7049,7301,'Xian 1980',''),
(8387,'Coordinate Reference System',4541,7302,'CGCS2000 / 3GK CM 96E',''),
(8389,'Coordinate Reference System',4534,7302,'CGCS2000 / 3GK CM 75E',''),
(8391,'Coordinate Reference System',4535,7302,'CGCS2000 / 3GK CM 78E',''),
(8393,'Coordinate Reference System',4536,7302,'CGCS2000 / 3GK CM 81E',''),
(8395,'Coordinate Reference System',4537,7302,'CGCS2000 / 3GK CM 84E',''),
(8399,'Coordinate Reference System',4538,7302,'CGCS2000 / 3GK CM 87E',''),
(8401,'Coordinate Reference System',4539,7302,'CGCS2000 / 3GK CM 90E',''),
(8403,'Coordinate Reference System',4540,7302,'CGCS2000 / 3GK CM 93E',''),
(8406,'Coordinate Reference System',4542,7302,'CGCS2000 / 3GK CM 99E',''),
(8409,'Coordinate Reference System',4543,7302,'CGCS2000 / 3GK CM 102E',''),
(8412,'Coordinate Reference System',4544,7302,'CGCS2000 / 3GK CM 105E',''),
(8415,'Coordinate Reference System',4545,7302,'CGCS2000 / 3GK CM 108E',''),
(8418,'Coordinate Reference System',4546,7302,'CGCS2000 / 3GK CM 111E',''),
(8421,'Coordinate Reference System',4547,7302,'CGCS2000 / 3GK CM 114E',''),
(8424,'Coordinate Reference System',4548,7302,'CGCS2000 / 3GK CM 117E',''),
(8427,'Coordinate Reference System',4549,7302,'CGCS2000 / 3GK CM 120E',''),
(8430,'Coordinate Reference System',4550,7302,'CGCS2000 / 3GK CM 123E',''),
(8433,'Coordinate Reference System',4551,7302,'CGCS2000 / 3GK CM 126E',''),
(8436,'Coordinate Reference System',4552,7302,'CGCS2000 / 3GK CM 129E',''),
(8439,'Coordinate Reference System',4553,7302,'CGCS2000 / 3GK CM 132E',''),
(8442,'Coordinate Reference System',4554,7302,'CGCS2000 / 3GK CM 135E',''),
(8463,'Datum',1047,7302,'RRAF91',''),
(8480,'Coordinate_Operation',4561,7301,'RRAF 1991 to IGN 1987 (1)',''),
(8482,'Coordinate_Operation',4562,7301,'RRAF 1991 to IGN 1988 (1)',''),
(8549,'Coordinate Reference System',4568,7301,'New Beijing / 6-degree Gauss-Kruger zone 13',''),
(8551,'Coordinate Reference System',4568,7302,'New Beijing / G-K zone 13',''),
(8553,'Coordinate Reference System',4569,7301,'New Beijing / 6-degree Gauss-Kruger zone 14',''),
(8555,'Coordinate Reference System',4569,7302,'New Beijing / G-K zone 14',''),
(8558,'Coordinate Reference System',4570,7301,'New Beijing / 6-degree Gauss-Kruger zone 15',''),
(8559,'Coordinate Reference System',4570,7302,'New Beijing / G-K zone 15',''),
(8565,'Coordinate Reference System',4571,7302,'New Beijing / G-K zone 16',''),
(8566,'Coordinate Reference System',4571,7301,'New Beijing / 6-degree Gauss-Kruger zone 16',''),
(8568,'Coordinate Reference System',4572,7301,'New Beijing / 6-degree Gauss-Kruger zone 17',''),
(8570,'Coordinate Reference System',4572,7302,'New Beijing / G-K zone 17',''),
(8573,'Coordinate Reference System',4573,7301,'New Beijing / 6-degree Gauss-Kruger zone 18',''),
(8574,'Coordinate Reference System',4573,7302,'New Beijing / G-K zone 18',''),
(8577,'Coordinate Reference System',4574,7302,'New Beijing / G-K zone 19',''),
(8578,'Coordinate Reference System',4574,7301,'New Beijing / 6-degree Gauss-Kruger zone 19',''),
(8581,'Coordinate Reference System',4575,7302,'New Beijing / G-K zone 20',''),
(8582,'Coordinate Reference System',4575,7301,'New Beijing / 6-degree Gauss-Kruger zone 20',''),
(8584,'Coordinate Reference System',4576,7301,'New Beijing / 6-degree Gauss-Kruger zone 21',''),
(8586,'Coordinate Reference System',4576,7302,'New Beijing / G-K zone 21',''),
(8588,'Coordinate Reference System',4577,7301,'New Beijing / 6-degree Gauss-Kruger zone 22',''),
(8590,'Coordinate Reference System',4577,7302,'New Beijing / G-K zone 22',''),
(8593,'Coordinate Reference System',4578,7302,'New Beijing / G-K zone 23',''),
(8594,'Coordinate Reference System',4578,7301,'New Beijing / 6-degree Gauss-Kruger zone 23',''),
(8596,'Coordinate Reference System',2333,7302,'Xian 1980 / G-K zone 19',''),
(8598,'Coordinate Reference System',4497,7302,'CGCS2000 / G-K zone 19',''),
(8599,'Coordinate Reference System',4497,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 19','Part of the China National Coordinate System of 2000.'),
(8605,'Coordinate Reference System',4579,7301,'New Beijing / 6-degree Gauss-Kruger CM 75E',''),
(8606,'Coordinate Reference System',4579,7302,'New Beijing / G-K CM 75E',''),
(8610,'Coordinate Reference System',4580,7301,'New Beijing / 6-degree Gauss-Kruger CM 81E',''),
(8611,'Coordinate Reference System',4580,7302,'New Beijing / G-K CM 81E',''),
(8615,'Coordinate Reference System',4581,7301,'New Beijing / 6-degree Gauss-Kruger CM 87E',''),
(8616,'Coordinate Reference System',4581,7302,'New Beijing / G-K CM 87E',''),
(8620,'Coordinate Reference System',4582,7301,'New Beijing / 6-degree Gauss-Kruger CM 93E',''),
(8621,'Coordinate Reference System',4582,7302,'New Beijing / G-K CM 93E',''),
(8625,'Coordinate Reference System',4583,7301,'New Beijing / 6-degree Gauss-Kruger CM 99E',''),
(8626,'Coordinate Reference System',4583,7302,'New Beijing / G-K CM 99E',''),
(8630,'Coordinate Reference System',4584,7301,'New Beijing / 6-degree Gauss-Kruger CM 105E',''),
(8631,'Coordinate Reference System',4584,7302,'New Beijing / G-K CM 105E',''),
(8635,'Coordinate Reference System',4585,7301,'New Beijing / 6-degree Gauss-Kruger CM 111E',''),
(8636,'Coordinate Reference System',4585,7302,'New Beijing / G-K CM 111E',''),
(8640,'Coordinate Reference System',4586,7301,'New Beijing / 6-degree Gauss-Kruger CM 117E',''),
(8641,'Coordinate Reference System',4586,7302,'New Beijing / G-K CM 117E',''),
(8645,'Coordinate Reference System',4587,7301,'New Beijing / 6-degree Gauss-Kruger CM 123E',''),
(8646,'Coordinate Reference System',4587,7302,'New Beijing / G-K CM 123E',''),
(8650,'Coordinate Reference System',4588,7301,'New Beijing / 6-degree Gauss-Kruger CM 129E',''),
(8651,'Coordinate Reference System',4588,7302,'New Beijing / G-K CM 129E',''),
(8655,'Coordinate Reference System',4589,7301,'New Beijing / 6-degree Gauss-Kruger CM 135E',''),
(8656,'Coordinate Reference System',4589,7302,'New Beijing / G-K CM 135E',''),
(8759,'Coordinate_Operation Method',9603,7301,'Geocentric Translations','This name is ambiguous as it makes no distinction of the domain of the source and target CRSs to which it is applied. See also methods 1032 and 10xx.'),
(8874,'Coordinate_Operation Method',9606,7301,'Position Vector 7-param. transformation','This name is ambiguous as it makes no distinction of the domain of the source and target CRSs to which it is applied. See also methods 1032 and 10xx.'),
(8885,'Coordinate Reference System',4491,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 13','Part of the China National Coordinate System of 2000.'),
(8886,'Coordinate Reference System',4491,7302,'CGCS2000 / G-K zone 13',''),
(8911,'Coordinate_Operation Method',9607,7301,'Coordinate Frame Rotation','This names is ambiguous as it makes no distinction between the domain of the source and target CRSs. See also methods 1032 and 10xx.'),
(8925,'Coordinate_Operation Method',9636,7301,'Molodensky-Badekas 10-parameter transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(8999,'Coordinate Reference System',4511,7301,'CGCS2000 / 6-degree Gauss-Kruger CM 129E',''),
(9000,'Coordinate Reference System',4511,7302,'CGCS2000 / G-K CM 129E',''),
(9006,'Coordinate Reference System',4531,7302,'CGCS2000 / 3GK zone 43',''),
(9007,'Coordinate Reference System',4533,7302,'CGCS2000 / 3GK zone 45',''),
(9010,'Coordinate Reference System',4532,7302,'CGCS2000 / 3GK zone 44',''),
(9014,'Coordinate Reference System',4530,7302,'CGCS2000 / 3GK zone 42',''),
(9018,'Coordinate Reference System',4528,7302,'CGCS2000 / 3GK zone 40',''),
(9022,'Coordinate Reference System',4526,7302,'CGCS2000 / 3GK zone 38',''),
(9024,'Coordinate Reference System',4494,7301,'CGCS2000 / 6-degree Gauss-Kruger zone 16','Part of the China National Coordinate System of 2000.'),
(9025,'Coordinate Reference System',4494,7302,'CGCS2000 / G-K zone 16',''),
(9029,'Coordinate Reference System',4527,7302,'CGCS2000 / 3GK zone 39',''),
(9031,'Coordinate Reference System',4525,7302,'CGCS2000 / 3GK zone 37',''),
(9035,'Coordinate Reference System',4524,7302,'CGCS2000 / 3GK zone 36',''),
(9037,'Coordinate Reference System',4523,7302,'CGCS2000 / 3GK zone 35',''),
(9039,'Coordinate Reference System',4522,7302,'CGCS2000 / 3GK zone 34',''),
(9041,'Coordinate Reference System',4521,7302,'CGCS2000 / 3GK zone 33',''),
(9043,'Coordinate Reference System',4520,7302,'CGCS2000 / 3GK zone 32',''),
(9045,'Coordinate Reference System',4519,7302,'CGCS2000 / 3GK zone 31',''),
(9047,'Coordinate Reference System',4518,7302,'CGCS2000 / 3GK zone 30',''),
(9049,'Coordinate Reference System',4517,7302,'CGCS2000 / 3GK zone 29',''),
(9051,'Coordinate Reference System',4516,7302,'CGCS2000 / 3GK zone 28',''),
(9053,'Coordinate Reference System',4515,7302,'CGCS2000 / 3GK zone 27',''),
(9057,'Coordinate Reference System',4514,7302,'CGCS2000 / 3GK zone 26',''),
(9059,'Coordinate Reference System',4513,7302,'CGCS2000 / 3GK zone 25',''),
(9138,'Coordinate_Operation',4651,7307,'GB_NEWL / OH to EVRF2000',''),
(9204,'Coordinate Reference System',4782,7302,'New Beijing / 3GK CM 75E',''),
(9207,'Coordinate Reference System',4783,7302,'New Beijing / 3GK CM 78E',''),
(9210,'Coordinate Reference System',4784,7302,'New Beijing / 3GK CM 81E',''),
(9213,'Coordinate Reference System',4785,7302,'New Beijing / 3GK CM 84E',''),
(9216,'Coordinate Reference System',4786,7302,'New Beijing / 3GK CM 87E',''),
(9219,'Coordinate Reference System',4787,7302,'New Beijing / 3GK CM 90E',''),
(9230,'Coordinate Reference System',4788,7302,'New Beijing / 3GK CM 93E',''),
(9233,'Coordinate Reference System',4789,7302,'New Beijing / 3GK CM 96E',''),
(9236,'Coordinate Reference System',4790,7302,'New Beijing / 3GK CM 99E',''),
(9239,'Coordinate Reference System',4791,7302,'New Beijing / 3GK CM 102E',''),
(9242,'Coordinate Reference System',4792,7302,'New Beijing / 3GK CM 105E',''),
(9245,'Coordinate Reference System',4793,7302,'New Beijing / 3GK CM 108E',''),
(9248,'Coordinate Reference System',4794,7302,'New Beijing / 3GK CM 111E',''),
(9251,'Coordinate Reference System',4795,7302,'New Beijing / 3GK CM 114E',''),
(9254,'Coordinate Reference System',4796,7302,'New Beijing / 3GK CM 117E',''),
(9257,'Coordinate Reference System',4797,7302,'New Beijing / 3GK CM 120E',''),
(9260,'Coordinate Reference System',4798,7302,'New Beijing / 3GK CM 123E',''),
(9263,'Coordinate Reference System',4799,7302,'New Beijing / 3GK CM 126E',''),
(9266,'Coordinate Reference System',4800,7302,'New Beijing / 3GK CM 129E',''),
(9269,'Coordinate Reference System',4812,7302,'New Beijing / 3GK CM 132E',''),
(9271,'Coordinate Reference System',4822,7302,'New Beijing / 3GK CM 135E',''),
(9276,'Coordinate Reference System',4652,7302,'New Beijing / 3GK zone 25',''),
(9278,'Coordinate Reference System',4653,7302,'New Beijing / 3GK zone 26',''),
(9280,'Coordinate Reference System',4654,7302,'New Beijing / 3GK zone 27',''),
(9282,'Coordinate Reference System',4655,7302,'New Beijing / 3GK zone 28',''),
(9292,'Coordinate Reference System',4656,7302,'New Beijing / 3GK zone 29',''),
(9294,'Coordinate Reference System',4766,7302,'New Beijing / 3GK zone 30',''),
(9296,'Coordinate Reference System',4767,7302,'New Beijing / 3GK zone 31',''),
(9298,'Coordinate Reference System',4768,7302,'New Beijing / 3GK zone 32',''),
(9300,'Coordinate Reference System',4769,7302,'New Beijing / 3GK zone 33',''),
(9302,'Coordinate Reference System',4770,7302,'New Beijing / 3GK zone 34',''),
(9304,'Coordinate Reference System',4771,7302,'New Beijing / 3GK zone 35',''),
(9306,'Coordinate Reference System',4772,7302,'New Beijing / 3GK zone 36',''),
(9308,'Coordinate Reference System',4773,7302,'New Beijing / 3GK zone 37',''),
(9310,'Coordinate Reference System',4774,7302,'New Beijing / 3GK zone 38',''),
(9312,'Coordinate Reference System',4775,7302,'New Beijing / 3GK zone 39',''),
(9320,'Coordinate Reference System',4778,7302,'New Beijing / 3GK zone 42',''),
(9322,'Coordinate Reference System',4779,7302,'New Beijing / 3GK zone 43',''),
(9324,'Coordinate Reference System',4780,7302,'New Beijing / 3GK zone 44',''),
(9326,'Coordinate Reference System',4781,7302,'New Beijing / 3GK zone 45',''),
(9328,'Coordinate Reference System',4529,7302,'CGCS2000 / 3GK zone 41',''),
(9350,'Coordinate_Operation',4825,7301,'Cape Verde New',''),
(9374,'Coordinate Reference System',4776,7302,'New Beijing / 3GK zone 40',''),
(9376,'Coordinate Reference System',4777,7302,'New Beijing / 3GK zone 41',''),
(9435,'Coordinate Reference System',4826,7301,'WGS 84 / Cape Verde New',''),
(9517,'Coordinate_Operation Method',1037,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Coordinate Frame rotation method (code 1038).'),
(9518,'Coordinate_Operation Method',1037,7301,'Position Vector 7-param. transformation','This name is ambiguous as it makes no distinction of the domain of the source and target CRSs to which it is applied. See also methods 1033 and 9607.'),
(9520,'Coordinate_Operation Method',1033,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Coordinate Frame rotation method (code 1032).'),
(9521,'Coordinate_Operation Method',1033,7301,'Position Vector 7-param. transformation','This names is ambiguous as it makes no distinction between the domain of the source and target CRSs. See also methods 1037 and 9606.'),
(9522,'Coordinate_Operation Method',1033,7301,'Helmert transformation',''),
(9524,'Coordinate_Operation Method',1039,7301,'Molodenski-Badekas transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(9525,'Coordinate_Operation Method',1039,7301,'Molodensky-Badekas 10-parameter transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(9527,'Coordinate_Operation Method',1034,7301,'Molodenski-Badekas transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(9528,'Coordinate_Operation Method',1034,7301,'Molodensky-Badekas 10-parameter transformation','This alias is ambiguous as it gives no indication of the source and target CRS domain nor of the rotation convention used.'),
(9530,'Coordinate_Operation Method',1035,7301,'Geocentric Translations','This name is ambiguous as it makes no distinction of the domain of the source and target CRSs to which it is applied. See also methods 1031 and 9603.'),
(9532,'Coordinate_Operation Method',1031,7301,'Geocentric translations','This name is ambiguous as it makes no distinction between the domain of the source and target CRSs. See also methods 1035 and 9603.'),
(9534,'Coordinate_Operation Method',1038,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Position Vector 7-param. Transformation method (code 9606).'),
(9535,'Coordinate_Operation Method',1038,7301,'Coordinate Frame Rotation','This names is ambiguous as it makes no distinction between the domain of the source and target CRSs. See also methods 1032 and 9607.'),
(9537,'Coordinate_Operation Method',1032,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Position Vector Transformation method (code 1033).'),
(9538,'Coordinate_Operation Method',1032,7301,'Coordinate Frame rotation','This names is ambiguous as it makes no distinction between the domain of the source and target CRSs. See also methods 1038 and 9607.'),
(9543,'Coordinate Reference System',4647,7310,'ETRS89 / UTM zone 32N','This is the EPSG name for CRS code 25832.'),
(9559,'Coordinate_Operation',4829,7307,'SK_S-JTSK to ETRS89','This identifier is also used for other transformations between S-JTSK and ERTS89.'),
(9560,'Coordinate_Operation',4829,7301,'S-JTSK to ETRF89 (3)',''),
(9562,'Coordinate_Operation',4827,7307,'SK_S-JTSK to ETRS89',''),
(9563,'Coordinate_Operation',4827,7301,'S-JTSK to ETRF89 (4)',''),
(9565,'Coordinate_Operation',4649,7302,'DHDN / 3GK zone 3 to ETRS89 / zone TM32 (1)',''),
(9566,'Coordinate_Operation',4649,7310,'DHDN / Gauss-Kruger zone 3 to ETRS89 / zone TM32 (1)',''),
(9568,'Coordinate_Operation',4650,7302,'DHDN / 3GK zone 4 to ETRS89 / zone TM32 (1)',''),
(9569,'Coordinate_Operation',4650,7310,'DHDN / Gauss-Kruger zone 4 to ETRS89 / zone TM32 (1)',''),
(9594,'Coordinate_Operation',4831,7301,'Amersfoort to ETRF89 (6)',''),
(9602,'Coordinate_Operation',4830,7301,'Amersfoort to ETRF89 (5)',''),
(9733,'Coordinate Reference System',4824,7301,'Morro do Papagaio',''),
(9734,'Coordinate Reference System',4824,7301,'Island of Principe datum',''),
(9739,'Coordinate Reference System',4823,7301,'Fortaleza',''),
(9740,'Coordinate Reference System',4823,7301,'Island of Sao Tome datum',''),
(9772,'Coordinate_Operation',4832,7301,'Red Geodesica Nacional ITRF92 to WGS 84 (1)',''),
(9836,'Coordinate Reference System',4481,1028,'Red Geodesica Nacional ITRF92',''),
(9839,'Coordinate Reference System',4482,1028,'Red Geodesica Nacional ITRF92',''),
(9842,'Coordinate Reference System',4483,1028,'Red Geodesica Nacional ITRF92',''),
(9847,'Datum',1042,1028,'Red Geodesica Nacional 1992',''),
(9860,'Datum',1046,7301,'Morro do Papagaio',''),
(9861,'Datum',1046,7301,'Island of Principe datum',''),
(9863,'Datum',1044,7301,'Fortaleza',''),
(9864,'Datum',1044,7301,'Island of Sao Tome datum',''),
(9923,'Coordinate_Operation',1656,7301,'Lisbon 1937 to WGS 84 (1)',''),
(9924,'Coordinate_Operation',1656,7302,'DLx to WGS 84 (1)',''),
(9928,'Coordinate_Operation',1658,7302,'D73 to WGS 84 (1)',''),
(10001,'Coordinate Reference System',3034,7302,'ETRS89 / LCC',''),
(10003,'Coordinate Reference System',3034,1029,'ETRS89-LCC',''),
(10005,'Coordinate_Operation',19985,1029,'LCC',''),
(10007,'Coordinate Reference System',3038,7301,'ETRS89 / ETRS-TM26',''),
(10008,'Coordinate Reference System',3038,1029,'ETRS89-TM26',''),
(10083,'Coordinate Reference System',4411,7301,'NAD27 / UTM zone 11N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 11N (code 26711). UTM is a metric system so strictly this is not UTM.'),
(10085,'Coordinate Reference System',4412,7301,'NAD27 / UTM zone 12N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 12N (code 26712). UTM is a metric system so strictly this is not UTM.'),
(10087,'Coordinate Reference System',4413,7301,'NAD27 / UTM zone 13N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 13N (code 26713). UTM is a metric system so strictly this is not UTM.'),
(10090,'Coordinate Reference System',4419,7301,'NAD27 / UTM zone 19N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 19N (code 26719). UTM is a metric system so strictly this is not UTM.'),
(10092,'Coordinate Reference System',4401,7301,'NAD27 / UTM zone 1N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 1N (code 26701). UTM is a metric system so strictly this is not UTM.'),
(10095,'Coordinate Reference System',4402,7301,'NAD27 / UTM zone 2N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 2N (code 26702). UTM is a metric system so strictly this is not UTM.'),
(10100,'Coordinate Reference System',4403,7301,'NAD27 / UTM zone 3N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 3N (code 26703). UTM is a metric system so strictly this is not UTM.'),
(10102,'Coordinate Reference System',4404,7301,'NAD27 / UTM zone 4N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 4N (code 26704). UTM is a metric system so strictly this is not UTM.'),
(10106,'Coordinate Reference System',4405,7301,'NAD27 / UTM zone 5N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 5N (code 26705). UTM is a metric system so strictly this is not UTM.'),
(10115,'Coordinate Reference System',4407,7301,'NAD27 / UTM zone 7N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 7N (code 26707). UTM is a metric system so strictly this is not UTM.'),
(10117,'Coordinate Reference System',4408,7301,'NAD27 / UTM zone 8N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 8N (code 26708). UTM is a metric system so strictly this is not UTM.'),
(10119,'Coordinate Reference System',4409,7301,'NAD27 / UTM zone 9N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 9N (code 26709). UTM is a metric system so strictly this is not UTM.'),
(10121,'Coordinate Reference System',4430,7301,'NAD83 / UTM zone 10N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 10N (code 26910). UTM is a metric system so strictly this is not UTM.'),
(10124,'Coordinate Reference System',4431,7301,'NAD83 / UTM zone 11N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 11N (code 26911). UTM is a metric system so strictly this is not UTM.'),
(10126,'Coordinate Reference System',4432,7301,'NAD83 / UTM zone 12N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 12N (code 26912). UTM is a metric system so strictly this is not UTM.'),
(10128,'Coordinate Reference System',4433,7301,'NAD83 / UTM zone 13N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 13N (code 26913). UTM is a metric system so strictly this is not UTM.'),
(10130,'Coordinate Reference System',4438,7301,'NAD83 / UTM zone 18N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 18N (code 26918). UTM is a metric system so strictly this is not UTM.'),
(10132,'Coordinate Reference System',4439,7301,'NAD83 / UTM zone 19N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 19N (code 26919). UTM is a metric system so strictly this is not UTM.'),
(10134,'Coordinate Reference System',4421,7301,'NAD83 / UTM zone 1N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 1N (code 26901). UTM is a metric system so strictly this is not UTM.'),
(10136,'Coordinate Reference System',4422,7301,'NAD83 / UTM zone 2N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 2N (code 26902). UTM is a metric system so strictly this is not UTM.'),
(10138,'Coordinate Reference System',4423,7301,'NAD83 / UTM zone 3N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 3N (code 26903). UTM is a metric system so strictly this is not UTM.'),
(10140,'Coordinate Reference System',4424,7301,'NAD83 / UTM zone 4N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 4N (code 26904). UTM is a metric system so strictly this is not UTM.'),
(10144,'Coordinate Reference System',4425,7301,'NAD83 / UTM zone 5N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 5N (code 26905). UTM is a metric system so strictly this is not UTM.'),
(10152,'Coordinate Reference System',4426,7301,'NAD83 / UTM zone 6N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 6N (code 26906). UTM is a metric system so strictly this is not UTM.'),
(10154,'Coordinate Reference System',4427,7301,'NAD83 / UTM zone 7N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 7N (code 26907). UTM is a metric system so strictly this is not UTM.'),
(10156,'Coordinate Reference System',4428,7301,'NAD83 / UTM zone 8N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 8N (code 26908). UTM is a metric system so strictly this is not UTM.'),
(10158,'Coordinate Reference System',4429,7301,'NAD83 / UTM zone 9N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 9N (code 26909). UTM is a metric system so strictly this is not UTM.'),
(10160,'Coordinate Reference System',4410,7301,'NAD27 / UTM zone 10N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 10N (code 26710). UTM is a metric system so strictly this is not UTM.'),
(10163,'Coordinate Reference System',4418,7301,'NAD27 / UTM zone 18N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 18N (code 26718). UTM is a metric system so strictly this is not UTM.'),
(10165,'Coordinate Reference System',4406,7301,'NAD27 / UTM zone 6N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 6N (code 26706). UTM is a metric system so strictly this is not UTM.'),
(10168,'Coordinate Reference System',4399,7301,'NAD27 / UTM zone 59N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 59N (code 3370). UTM is a metric system so strictly this is not UTM.'),
(10173,'Coordinate Reference System',4217,7301,'NAD83 / UTM zone 59N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 59N (code 3372). UTM is a metric system so strictly this is not UTM.'),
(10175,'Coordinate Reference System',4420,7301,'NAD83 / UTM zone 60N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 60N (code 3373). UTM is a metric system so strictly this is not UTM.'),
(10177,'Coordinate Reference System',4400,7301,'NAD27 / UTM zone 60N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 60N (code 3371). UTM is a metric system so strictly this is not UTM.'),
(10494,'Coordinate_Operation',4845,7317,'NTM zone 5',''),
(10496,'Coordinate_Operation',4846,7317,'NTM zone 6',''),
(10498,'Coordinate_Operation',4847,7317,'NTM zone 7',''),
(10500,'Coordinate_Operation',4848,7317,'NTM zone 8',''),
(10502,'Coordinate_Operation',4849,7317,'NTM zone 9',''),
(10504,'Coordinate_Operation',5010,7317,'NTM zone 30',''),
(10506,'Coordinate_Operation',5009,7317,'NTM zone 29',''),
(10508,'Coordinate_Operation',5008,7317,'NTM zone 28',''),
(10510,'Coordinate_Operation',5007,7317,'NTM zone 27',''),
(10512,'Coordinate_Operation',5006,7317,'NTM zone 26',''),
(10514,'Coordinate_Operation',5005,7317,'NTM zone 25',''),
(10516,'Coordinate_Operation',5004,7317,'NTM zone 24',''),
(10520,'Coordinate_Operation',5003,7317,'NTM zone 23',''),
(10522,'Coordinate_Operation',5002,7317,'NTM zone 22',''),
(10524,'Coordinate_Operation',5001,7317,'NTM zone 21',''),
(10528,'Coordinate_Operation',5000,7317,'NTM zone 20',''),
(10530,'Coordinate_Operation',4881,7317,'NTM zone 19',''),
(10532,'Coordinate_Operation',4844,7317,'NTM zone 18',''),
(10534,'Coordinate_Operation',4842,7317,'NTM zone 16',''),
(10536,'Coordinate_Operation',4841,7317,'NTM zone 15',''),
(10538,'Coordinate_Operation',4854,7317,'NTM zone 14',''),
(10540,'Coordinate_Operation',4853,7317,'NTM zone 13',''),
(10542,'Coordinate_Operation',4852,7317,'NTM zone 12',''),
(10544,'Coordinate_Operation',4851,7317,'NTM zone 11',''),
(10546,'Coordinate_Operation',4850,7317,'NTM zone 10',''),
(10551,'Coordinate_Operation',4843,7317,'NTM zone 17',''),
(10555,'Coordinate Reference System',3035,7302,'ETRS89 / LAEA',''),
(10556,'Coordinate Reference System',3035,1029,'ETRS89-LAEA',''),
(10566,'Coordinate Reference System',3039,7301,'ETRS89 / ETRS-TM27',''),
(10567,'Coordinate Reference System',3039,1029,'ETRS89-TM27',''),
(10570,'Coordinate Reference System',3051,7301,'ETRS89 / ETRS-TM39',''),
(10571,'Coordinate Reference System',3051,1029,'ETRS89-TM39',''),
(10574,'Coordinate Reference System',3050,7301,'ETRS89 / ETRS-TM38',''),
(10575,'Coordinate Reference System',3050,1029,'ETRS89-TM38',''),
(10577,'Coordinate Reference System',3049,7301,'ETRS89 / TM37',''),
(10578,'Coordinate Reference System',3049,1029,'ETRS89-TM37',''),
(10581,'Coordinate Reference System',3048,7301,'ETRS89 / TM36',''),
(10582,'Coordinate Reference System',3048,1029,'ETRS89-TM36',''),
(10584,'Coordinate Reference System',3047,7301,'ETRS89 / TM35',''),
(10585,'Coordinate Reference System',3047,1029,'ETRS89-TM35',''),
(10587,'Coordinate Reference System',3046,7301,'ETRS89 / TM34',''),
(10588,'Coordinate Reference System',3046,1029,'ETRS89-TM34',''),
(10590,'Coordinate Reference System',3045,7301,'ETRS89 / TM33',''),
(10591,'Coordinate Reference System',3045,1029,'ETRS89-TM33',''),
(10593,'Coordinate Reference System',3044,7301,'ETRS89 / TM32',''),
(10594,'Coordinate Reference System',3044,1029,'ETRS89-TM32',''),
(10596,'Coordinate Reference System',3043,7301,'ETRS89 / TM31',''),
(10597,'Coordinate Reference System',3043,1029,'ETRS89-TM31',''),
(10599,'Coordinate Reference System',3042,7301,'ETRS89 / TM30',''),
(10600,'Coordinate Reference System',3042,1029,'ETRS89-TM30',''),
(10602,'Coordinate Reference System',3041,7301,'ETRS89 / TM29',''),
(10603,'Coordinate Reference System',3041,1029,'ETRS89-TM29',''),
(10606,'Coordinate Reference System',3040,1029,'ETRS89-TM28',''),
(10635,'Coordinate Reference System',4936,1029,'ETRS89-XYZ',''),
(10639,'Coordinate Reference System',4937,1029,'ETRS89-GRS80h',''),
(10641,'Coordinate Reference System',4258,1029,'ETRS89-GRS80',''),
(10643,'Coordinate_Operation',19985,7302,'LCC Europe',''),
(10645,'Coordinate_Operation',19986,7302,'LAEA Europe',''),
(10676,'Coordinate_Operation',4838,7310,'LCC-DE',''),
(10678,'Coordinate Reference System',4839,7310,'ETRS89-LCC-DE(N-E)',''),
(10686,'Coordinate Reference System',4855,7301,'ETRF89 / NTM zone 5',''),
(10687,'Coordinate Reference System',4855,7301,'EUREF89 / NTM zone 5',''),
(10689,'Coordinate Reference System',4856,7301,'ETRF89 / NTM zone 6',''),
(10690,'Coordinate Reference System',4856,7301,'EUREF89 / NTM zone 6',''),
(10692,'Coordinate Reference System',4857,7301,'ETRF89 / NTM zone 7',''),
(10693,'Coordinate Reference System',4857,7301,'EUREF89 / NTM zone 7',''),
(10695,'Coordinate Reference System',4858,7301,'ETRF89 / NTM zone 8',''),
(10696,'Coordinate Reference System',4858,7301,'EUREF89 / NTM zone 8',''),
(10698,'Coordinate Reference System',4859,7301,'ETRF89 / NTM zone 9',''),
(10699,'Coordinate Reference System',4859,7301,'EUREF89 / NTM zone 9',''),
(10701,'Coordinate Reference System',4880,7301,'ETRF89 / NTM zone 30',''),
(10702,'Coordinate Reference System',4880,7301,'EUREF89 / NTM zone 30',''),
(10704,'Coordinate Reference System',4879,7301,'ETRF89 / NTM zone 29',''),
(10705,'Coordinate Reference System',4879,7301,'EUREF89 / NTM zone 29',''),
(10707,'Coordinate Reference System',4878,7301,'ETRF89 / NTM zone 28',''),
(10708,'Coordinate Reference System',4878,7301,'EUREF89 / NTM zone 28',''),
(10710,'Coordinate Reference System',4877,7301,'ETRF89 / NTM zone 27',''),
(10711,'Coordinate Reference System',4877,7301,'EUREF89 / NTM zone 27',''),
(10713,'Coordinate Reference System',4876,7301,'ETRF89 / NTM zone 26',''),
(10714,'Coordinate Reference System',4876,7301,'EUREF89 / NTM zone 26',''),
(10716,'Coordinate Reference System',4875,7301,'ETRF89 / NTM zone 25',''),
(10717,'Coordinate Reference System',4875,7301,'EUREF89 / NTM zone 25',''),
(10719,'Coordinate Reference System',4874,7301,'ETRF89 / NTM zone 24',''),
(10720,'Coordinate Reference System',4874,7301,'EUREF89 / NTM zone 24',''),
(10722,'Coordinate Reference System',4873,7301,'ETRF89 / NTM zone 23',''),
(10723,'Coordinate Reference System',4873,7301,'EUREF89 / NTM zone 23',''),
(10728,'Coordinate Reference System',4872,7301,'ETRF89 / NTM zone 22',''),
(10729,'Coordinate Reference System',4872,7301,'EUREF89 / NTM zone 22',''),
(10731,'Coordinate Reference System',4871,7301,'ETRF89 / NTM zone 21',''),
(10732,'Coordinate Reference System',4871,7301,'EUREF89 / NTM zone 21',''),
(10734,'Coordinate Reference System',4870,7301,'ETRF89 / NTM zone 20',''),
(10735,'Coordinate Reference System',4870,7301,'EUREF89 / NTM zone 20',''),
(10737,'Coordinate Reference System',4869,7301,'ETRF89 / NTM zone 19',''),
(10738,'Coordinate Reference System',4869,7301,'EUREF89 / NTM zone 19',''),
(10740,'Coordinate Reference System',4868,7301,'ETRF89 / NTM zone 18',''),
(10741,'Coordinate Reference System',4868,7301,'EUREF89 / NTM zone 18',''),
(10742,'Coordinate Reference System',4867,7301,'ETRF89 / NTM zone 17',''),
(10743,'Coordinate Reference System',4867,7301,'EUREF89 / NTM zone 17',''),
(10746,'Coordinate Reference System',4866,7301,'ETRF89 / NTM zone 16',''),
(10747,'Coordinate Reference System',4866,7301,'EUREF89 / NTM zone 16',''),
(10752,'Coordinate Reference System',4865,7301,'ETRF89 / NTM zone 15',''),
(10753,'Coordinate Reference System',4865,7301,'EUREF89 / NTM zone 15',''),
(10755,'Coordinate Reference System',4864,7301,'ETRF89 / NTM zone 14',''),
(10756,'Coordinate Reference System',4864,7301,'EUREF89 / NTM zone 14',''),
(10758,'Coordinate Reference System',4863,7301,'ETRF89 / NTM zone 13',''),
(10759,'Coordinate Reference System',4863,7301,'EUREF89 / NTM zone 13',''),
(10761,'Coordinate Reference System',4862,7301,'ETRF89 / NTM zone 12',''),
(10762,'Coordinate Reference System',4862,7301,'EUREF89 / NTM zone 12',''),
(10764,'Coordinate Reference System',4861,7301,'ETRF89 / NTM zone 11',''),
(10765,'Coordinate Reference System',4861,7301,'EUREF89 / NTM zone 11',''),
(10767,'Coordinate Reference System',4860,7301,'ETRF89 / NTM zone 10',''),
(10768,'Coordinate Reference System',4860,7301,'EUREF89 / NTM zone 10',''),
(10777,'Coordinate Reference System',4160,7302,'Chos Malal',''),
(10779,'Coordinate Reference System',4254,7302,'Hito XVIII',''),
(10783,'Coordinate Reference System',2082,7302,'Pampa Cas / Argentina 2',''),
(10784,'Coordinate Reference System',2082,7301,'Pampa del Castillo / Argentina zone 2',''),
(10786,'Coordinate Reference System',4161,7302,'Pampa Cas',''),
(10788,'Coordinate Reference System',22181,7301,'POSGAR 94 / Gauss-Kruger zone 1',''),
(10790,'Coordinate Reference System',22182,7301,'POSGAR 94 / Gauss-Kruger zone 2',''),
(10792,'Coordinate Reference System',22183,7301,'POSGAR 94 / Gauss-Kruger zone 3',''),
(10794,'Coordinate Reference System',22184,7301,'POSGAR 94 / Gauss-Kruger zone 4',''),
(10796,'Coordinate Reference System',22185,7301,'POSGAR 94 / Gauss-Kruger zone 5',''),
(10800,'Coordinate Reference System',22187,7301,'POSGAR 94 / Gauss-Kruger zone 7',''),
(10802,'Coordinate Reference System',22172,7301,'POSGAR 98 / Gauss-Kruger zone 2',''),
(10804,'Coordinate Reference System',22171,7301,'POSGAR 98 / Gauss-Kruger zone 1',''),
(10806,'Coordinate Reference System',22173,7301,'POSGAR 98 / Gauss-Kruger zone 3',''),
(10808,'Coordinate Reference System',22174,7301,'POSGAR 98 / Gauss-Kruger zone 4',''),
(10810,'Coordinate Reference System',22175,7301,'POSGAR 98 / Gauss-Kruger zone 5',''),
(10812,'Coordinate Reference System',22176,7301,'POSGAR 98 / Gauss-Kruger zone 6',''),
(10814,'Coordinate Reference System',22177,7301,'POSGAR 98 / Gauss-Kruger zone 7',''),
(10816,'Coordinate Reference System',22186,7301,'POSGAR 94 / Gauss-Kruger zone 6',''),
(10827,'Coordinate_Operation',4102,7301,'BLM zone 2N in feet',''),
(10828,'Coordinate_Operation',4102,7302,'BLM 2N (ftUS)',''),
(10830,'Coordinate_Operation',4103,7301,'BLM zone 3N in feet',''),
(10831,'Coordinate_Operation',4103,7302,'BLM 3N (ftUS)',''),
(10837,'Coordinate_Operation',4101,7301,'BLM zone 1N in feet',''),
(10838,'Coordinate_Operation',4101,7302,'BLM 1N (ftUS)',''),
(10846,'Coordinate_Operation',4104,7302,'BLM 4N (ftUS)',''),
(10847,'Coordinate_Operation',4104,7301,'BLM zone 4N in feet',''),
(10849,'Coordinate_Operation',4186,7301,'BLM zone 59N in feet',''),
(10850,'Coordinate_Operation',4186,7302,'BLM 59N (ftUS)',''),
(10852,'Coordinate_Operation',4109,7301,'BLM zone 9N in feet',''),
(10853,'Coordinate_Operation',4109,7302,'BLM 9N (ftUS)',''),
(10855,'Coordinate_Operation',4108,7302,'BLM 8N (ftUS)',''),
(10856,'Coordinate_Operation',4108,7301,'BLM zone 8N in feet',''),
(10858,'Coordinate_Operation',4107,7301,'BLM zone 7N in feet',''),
(10859,'Coordinate_Operation',4107,7302,'BLM 7N (ftUS)',''),
(10861,'Coordinate_Operation',4106,7302,'BLM 6N (ftUS)',''),
(10862,'Coordinate_Operation',4106,7301,'BLM zone 6N in feet',''),
(10864,'Coordinate_Operation',4187,7302,'BLM 60N (ftUS)',''),
(10865,'Coordinate_Operation',4187,7301,'BLM zone 60N in feet',''),
(10867,'Coordinate_Operation',4105,7301,'BLM zone 5N in feet',''),
(10868,'Coordinate_Operation',4105,7302,'BLM 5N (ftUS)',''),
(10870,'Coordinate_Operation',4119,7301,'BLM zone 19N in feet',''),
(10871,'Coordinate_Operation',4119,7302,'BLM 19N (ftUS)',''),
(10873,'Coordinate_Operation',4118,7301,'BLM zone 18N in feet',''),
(10874,'Coordinate_Operation',4118,7302,'BLM 18N (ftUS)',''),
(10876,'Coordinate_Operation',4113,7301,'BLM zone 13N in feet',''),
(10877,'Coordinate_Operation',4113,7302,'BLM 13N (ftUS)',''),
(10879,'Coordinate_Operation',4112,7301,'BLM zone 12N in feet',''),
(10880,'Coordinate_Operation',4112,7302,'BLM 12N (ftUS)',''),
(10882,'Coordinate_Operation',4111,7301,'BLM zone 11N in feet',''),
(10883,'Coordinate_Operation',4111,7302,'BLM 11N (ftUS)',''),
(10885,'Coordinate_Operation',4110,7301,'BLM zone 10N in feet',''),
(10886,'Coordinate_Operation',4110,7302,'BLM 10N (ftUS)',''),
(11201,'Coordinate Reference System',5017,7317,'BB DLx',''),
(11343,'Coordinate Reference System',5018,7302,'DLx','The same abbreviation is also used for Lisbon (Lisbon) / Portuguese Grid (CRS code 20791).'),
(11344,'Coordinate Reference System',5018,7301,'Lisbon 1937 / Portuguese Grid New',''),
(11601,'Coordinate_Operation',3872,7302,'GK31FIN',''),
(11603,'Coordinate_Operation',3860,7302,'GK19FIN',''),
(11606,'Coordinate_Operation',3862,7302,'GK21FIN',''),
(11609,'Coordinate_Operation',3864,7302,'GK23FIN',''),
(11612,'Coordinate_Operation',3866,7302,'GK25FIN',''),
(11614,'Coordinate_Operation',3867,7302,'GK26FIN',''),
(11616,'Coordinate_Operation',3868,7302,'GK27FIN',''),
(11618,'Coordinate_Operation',3869,7302,'GK28FIN',''),
(11620,'Coordinate_Operation',3870,7302,'GK29FIN',''),
(11622,'Coordinate_Operation',3871,7302,'GK30FIN',''),
(11685,'Area',3696,1031,'SEAL',''),
(11689,'Area',2963,1031,'BC',''),
(11691,'Area',2964,1031,'ES',''),
(11715,'Area',3700,1031,'BS',''),
(11775,'Area',3697,1031,'PEPB',''),
(12038,'Coordinate_Operation',4072,7301,'Karbala 1979 (Polservice) / UTM zone 38N to IGRS / UTM zone 38N (1)',''),
(12064,'Coordinate_Operation',5044,7301,'S-42 to WGS 84 (20)','S-42 is ambiguous as it is used as a name for several CRSs.'),
(12074,'Coordinate_Operation',5043,7301,'CS95 to WGS 84 (2)',''),
(12103,'Area',3693,1031,'BTUC',''),
(12120,'Coordinate_Operation',5050,1031,'Aratu-BS',''),
(12122,'Coordinate_Operation',5052,1031,'Aratu-BC',''),
(12124,'Coordinate_Operation',5054,1031,'Aratu-ES',''),
(12125,'Coordinate_Operation',5056,1031,'Aratu-BSUL',''),
(12128,'Coordinate_Operation',5058,1031,'Aratu-BREC',''),
(12130,'Coordinate_Operation',5060,1031,'Aratu-BTUC',''),
(12132,'Coordinate_Operation',5062,1031,'Aratu-SEAL',''),
(12134,'Coordinate_Operation',5064,1031,'Aratu-PEPB',''),
(12136,'Coordinate_Operation',5066,1031,'Aratu-RNCE',''),
(12149,'Coordinate_Operation',5067,1031,'Aratu-RNCE',''),
(12151,'Coordinate_Operation',5065,1031,'Aratu-PEPB',''),
(12153,'Area',3692,1031,'BREC',''),
(12155,'Coordinate_Operation',5063,1031,'Aratu-SEAL',''),
(12157,'Coordinate_Operation',5061,1031,'Aratu-BTUC',''),
(12159,'Coordinate_Operation',5059,1031,'Aratu-BREC',''),
(12161,'Coordinate_Operation',5057,1031,'Aratu-BSUL',''),
(12163,'Coordinate_Operation',5055,1031,'Aratu-ES',''),
(12167,'Coordinate_Operation',5051,1031,'Aratu-BS',''),
(12169,'Coordinate_Operation',5053,1031,'Aratu-BC',''),
(12186,'Datum',1041,7302,'PTRA08',''),
(12193,'Coordinate_Operation',5027,7301,'Base SW to PTRA08 (1)',''),
(12195,'Coordinate_Operation',5028,7301,'Base SW to PTRA08 (2)',''),
(12197,'Coordinate_Operation',5029,7301,'Base SW to PTRA08 (3)',''),
(12199,'Coordinate_Operation',5030,7301,'Base SW to PTRA08 (4)',''),
(12203,'Coordinate_Operation',5031,7301,'Base SW to PTRA08 (5)',''),
(12205,'Coordinate_Operation',5032,7301,'Base SW to PTRA08 (6)',''),
(12213,'Coordinate_Operation',5024,7301,'Sao Braz to PTRA08 (1)',''),
(12215,'Coordinate_Operation',5025,7301,'Sao Braz to PTRA08 (2)',''),
(12217,'Coordinate_Operation',5026,7301,'Sao Braz to PTRA08 (3)',''),
(12219,'Coordinate_Operation',5036,7302,'D73 to ETRS89(4)',''),
(12220,'Coordinate_Operation',5036,7301,'Datum 73 to ETRF89 (4)',''),
(12222,'Coordinate_Operation',5037,7302,'D73 to ETRS89(5)',''),
(12223,'Coordinate_Operation',5037,7301,'Datum 73 to ETRF89 (5)',''),
(12224,'Coordinate_Operation',5040,7301,'ED50 to ETRF89 (13)',''),
(12232,'Coordinate_Operation',5039,7302,'B DLx to ETRS89(1)',''),
(12233,'Coordinate_Operation',5039,7301,'Lisbon 1890 to ETRF89 (1)',''),
(12235,'Coordinate_Operation',5038,7302,'DLx to ETRS89(3)',''),
(12236,'Coordinate_Operation',5038,7301,'Lisbon to ETRF89 (3)',''),
(12237,'Coordinate_Operation',5038,7301,'Lisbon 1937 to ETRS89 (3)',''),
(12239,'Coordinate_Operation',5021,7301,'Base SE to PTRA08 (1)',''),
(12241,'Coordinate_Operation',5022,7301,'Base SE to PTRA08 (2)',''),
(12243,'Coordinate_Operation',5023,7301,'Base SE to PTRA08 (3)',''),
(12264,'Coordinate_Operation',5033,7301,'Observatorio Flores to PTRA08 (1)',''),
(12266,'Coordinate_Operation',5034,7301,'Observatorio Flores to PTRA08 (2)',''),
(12268,'Coordinate_Operation',5035,7301,'Observatorio Flores to PTRA08 (3)',''),
(12272,'Coordinate_Operation',5078,7301,'Karbala 1979 (Polservice) to WGS 84 (2)',''),
(12274,'Coordinate_Operation',5077,7301,'Karbala 1979 (Polservice) to IGRS (1)',''),
(12280,'Coordinate_Operation',5082,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (5)',''),
(12282,'Coordinate_Operation',5083,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (6)',''),
(12284,'Coordinate_Operation',5084,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (7)',''),
(12286,'Coordinate_Operation',5097,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (25)',''),
(12290,'Coordinate_Operation',5096,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (24)',''),
(12296,'Coordinate_Operation',5080,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (2)',''),
(12306,'Coordinate_Operation',5091,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (16)',''),
(12309,'Coordinate_Operation',5088,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (11)',''),
(12311,'Coordinate_Operation',5087,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (10)',''),
(12313,'Coordinate_Operation',5086,7301,'Nahrwan 1967 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (9)',''),
(12315,'Coordinate_Operation',5085,7301,'Nahrwan 1967 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (8)',''),
(12319,'Coordinate_Operation',5079,7301,'Nahrwan 1967 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (1)',''),
(12321,'Coordinate_Operation',5090,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (15)',''),
(12323,'Coordinate_Operation',5095,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (21)',''),
(12324,'Coordinate Reference System',2083,7302,'Hito XVIII / Argentina 2',''),
(12326,'Coordinate Reference System',2081,7302,'Chos Malal / Argentina 2',''),
(12333,'Coordinate_Operation',5081,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (3)',''),
(12335,'Coordinate_Operation',5089,7301,'Nahrwan 1967 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (14)',''),
(12337,'Coordinate_Operation',5045,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (4)',''),
(12340,'Coordinate_Operation',5046,7301,'Nahrwan 1967 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (12)',''),
(12343,'Coordinate_Operation',5047,7301,'Nahrwan 1967 / UTM zone 37N to Karbala 1979 (Polservice) / UTM zone 37N (13)',''),
(12346,'Coordinate_Operation',5076,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (18)',''),
(12348,'Coordinate_Operation',5092,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (17)',''),
(12351,'Coordinate_Operation',5098,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (22)',''),
(12353,'Coordinate_Operation',5093,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (19)',''),
(12356,'Coordinate_Operation',5099,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (23)',''),
(12358,'Coordinate_Operation',5094,7301,'Nahrwan 1967 / UTM zone 38N to Karbala 1979 (Polservice) / UTM zone 38N (20)',''),
(12367,'Coordinate_Operation',15872,7301,'Karbala 1979 (Polservice) to WGS 84 (1)',''),
(12370,'Coordinate Reference System',2393,1030,'YKG','Yhteniskoordinaatisto, Uniform Coordinate System.'),
(12372,'Coordinate Reference System',7405,7301,'OSGB36 / British National Grid + ODN height',''),
(12440,'Coordinate Reference System',3067,7301,'ETRS89 / TM35FIN',''),
(12441,'Coordinate Reference System',3067,1030,'ETRS89-TM35FIN(E,N)',''),
(12442,'Coordinate Reference System',3067,1030,'ETRS-TM35FIN(E,N)',''),
(12449,'Coordinate Reference System',3873,7301,'ETRF89 / GK19FIN',''),
(12450,'Coordinate Reference System',3873,1030,'ETRS89-GK19FIN',''),
(12451,'Coordinate Reference System',3873,1030,'ETRS-GK19FIN',''),
(12454,'Coordinate Reference System',3874,7301,'ETRF89 / GK20FIN',''),
(12455,'Coordinate Reference System',3874,1030,'ETRS89-GK20FIN',''),
(12456,'Coordinate Reference System',3874,1030,'ETRS-GK20FIN',''),
(12458,'Coordinate Reference System',3875,1030,'ETRS89-GK21FIN',''),
(12459,'Coordinate Reference System',3875,7301,'ETRF89 / GK21FIN',''),
(12460,'Coordinate Reference System',3875,1030,'ETRS-GK21FIN',''),
(12462,'Coordinate Reference System',3876,7301,'ETRF89 / GK22FIN',''),
(12463,'Coordinate Reference System',3876,1030,'ETRS89-GK22FIN',''),
(12464,'Coordinate Reference System',3876,1030,'ETRS-GK22FIN',''),
(12466,'Coordinate Reference System',3877,7301,'ETRF89 / GK23FIN',''),
(12467,'Coordinate Reference System',3877,1030,'ETRS89-GK23FIN',''),
(12468,'Coordinate Reference System',3877,1030,'ETRS-GK23FIN',''),
(12470,'Coordinate Reference System',3878,7301,'ETRF89 / GK24FIN',''),
(12471,'Coordinate Reference System',3878,1030,'ETRS89-GK24FIN',''),
(12472,'Coordinate Reference System',3878,1030,'ETRS-GK24FIN',''),
(12474,'Coordinate Reference System',3879,1030,'ETRS89-GK25FIN',''),
(12475,'Coordinate Reference System',3879,7301,'ETRF89 / GK25FIN',''),
(12476,'Coordinate Reference System',3879,1030,'ETRS-GK25FIN',''),
(12478,'Coordinate Reference System',3880,7301,'ETRF89 / GK26FIN',''),
(12479,'Coordinate Reference System',3880,1030,'ETRS89-GK26FIN',''),
(12480,'Coordinate Reference System',3880,1030,'ETRS-GK26FIN',''),
(12482,'Coordinate Reference System',3881,7301,'ETRF89 / GK27FIN',''),
(12483,'Coordinate Reference System',3881,1030,'ETRS89-GK27FIN',''),
(12484,'Coordinate Reference System',3881,1030,'ETRS-GK27FIN',''),
(12486,'Coordinate Reference System',3882,7301,'ETRF89 / GK28FIN',''),
(12487,'Coordinate Reference System',3882,1030,'ETRS89-GK28FIN',''),
(12488,'Coordinate Reference System',3882,1030,'ETRS-GK28FIN',''),
(12490,'Coordinate Reference System',3883,7301,'ETRF89 / GK29FIN',''),
(12491,'Coordinate Reference System',3883,1030,'ETRS89-GK29FIN',''),
(12492,'Coordinate Reference System',3883,1030,'ETRS-GK29FIN',''),
(12494,'Coordinate Reference System',3884,7301,'ETRF89 / GK30FIN',''),
(12495,'Coordinate Reference System',3884,1030,'ETRS89-GK30FIN',''),
(12496,'Coordinate Reference System',3884,1030,'ETRS-GK30FIN',''),
(12497,'Coordinate Reference System',3885,1030,'ETRS-GK31FIN',''),
(12498,'Coordinate Reference System',3885,7301,'ETRF89 / GK31FIN',''),
(12499,'Coordinate Reference System',3885,1030,'ETRS89-GK31FIN',''),
(12505,'Coordinate Reference System',3903,1030,'ETRS-TM35FIN(N,E)/N2000',''),
(12506,'Coordinate Reference System',3903,1030,'ETRS89-TM35FIN(N,E)/N2000',''),
(12515,'Coordinate Reference System',3901,1030,'YKJ/N60',''),
(12516,'Coordinate Reference System',3901,7301,'YKJ + N60 height',''),
(12518,'Coordinate Reference System',3900,1030,'N2000',''),
(12520,'Coordinate Reference System',5717,1030,'N60',''),
(12545,'Coordinate Reference System',5048,7301,'ETRF89 / TM35FIN(N,E)',''),
(12546,'Coordinate Reference System',5048,1030,'ETRS89-TM35FIN(N,E)',''),
(12547,'Coordinate Reference System',5048,1030,'ETRS-TM35FIN(N,E)',''),
(12565,'Coordinate_Operation',3861,7302,'GK20FIN',''),
(12567,'Coordinate_Operation',3863,7302,'GK22FIN',''),
(12569,'Coordinate_Operation',3865,7302,'GK24FIN',''),
(12572,'Coordinate Reference System',3902,1030,'ETRS89-TM35FIN(N,E)/N60',''),
(12573,'Coordinate Reference System',3902,1030,'ETRS-TM35FIN(N,E)/N60',''),
(12857,'Coordinate_Operation',5136,7317,'NTM zone 6',''),
(12878,'Coordinate_Operation',5140,7317,'NTM zone 10',''),
(12881,'Coordinate_Operation',5141,7317,'NTM zone 11',''),
(12884,'Coordinate_Operation',5142,7317,'NTM zone 12',''),
(12887,'Coordinate_Operation',5143,7317,'NTM zone 13',''),
(12890,'Coordinate_Operation',5144,7317,'NTM zone 14',''),
(12893,'Coordinate_Operation',5145,7317,'NTM zone 15',''),
(12896,'Coordinate_Operation',5146,7317,'NTM zone 16',''),
(12899,'Coordinate_Operation',5147,7317,'NTM zone 17',''),
(12902,'Coordinate_Operation',5148,7317,'NTM zone 18',''),
(12905,'Coordinate_Operation',5149,7317,'NTM zone 19',''),
(12908,'Coordinate_Operation',5150,7317,'NTM zone 20',''),
(12911,'Coordinate_Operation',5151,7317,'NTM zone 21',''),
(12914,'Coordinate_Operation',5152,7317,'NTM zone 22',''),
(12917,'Coordinate_Operation',5153,7317,'NTM zone 23',''),
(12920,'Coordinate_Operation',5154,7317,'NTM zone 24',''),
(12923,'Coordinate_Operation',5155,7317,'NTM zone 25',''),
(12926,'Coordinate_Operation',5156,7317,'NTM zone 26',''),
(12929,'Coordinate_Operation',5157,7317,'NTM zone 27',''),
(12932,'Coordinate_Operation',5158,7317,'NTM zone 28',''),
(12935,'Coordinate_Operation',5159,7317,'NTM zone 29',''),
(12938,'Coordinate_Operation',5160,7317,'NTM zone 30',''),
(12989,'Coordinate Reference System',5120,7301,'ETRF89 / NTM zone 20',''),
(12990,'Coordinate Reference System',5120,7301,'EUREF89 / NTM zone 20',''),
(12998,'Coordinate Reference System',5123,7301,'ETRF89 / NTM zone 23',''),
(12999,'Coordinate Reference System',5123,7301,'EUREF89 / NTM zone 23',''),
(13000,'Coordinate Reference System',5124,7301,'ETRF89 / NTM zone 24',''),
(13001,'Coordinate Reference System',5124,7301,'EUREF89 / NTM zone 24',''),
(13004,'Coordinate Reference System',5125,7301,'ETRF89 / NTM zone 25',''),
(13005,'Coordinate Reference System',5125,7301,'EUREF89 / NTM zone 25',''),
(13007,'Coordinate Reference System',5126,7301,'ETRF89 / NTM zone 26',''),
(13008,'Coordinate Reference System',5126,7301,'EUREF89 / NTM zone 26',''),
(13016,'Coordinate Reference System',5129,7301,'ETRF89 / NTM zone 29',''),
(13017,'Coordinate Reference System',5129,7301,'EUREF89 / NTM zone 29',''),
(13019,'Coordinate Reference System',5130,7301,'ETRF89 / NTM zone 30',''),
(13020,'Coordinate Reference System',5130,7301,'EUREF89 / NTM zone 30',''),
(13022,'Coordinate Reference System',5105,7301,'ETRF89 / NTM zone 5',''),
(13023,'Coordinate Reference System',5105,7301,'EUREF89 / NTM zone 5',''),
(13025,'Coordinate Reference System',5106,7301,'ETRF89 / NTM zone 6',''),
(13026,'Coordinate Reference System',5106,7301,'EUREF89 / NTM zone 6',''),
(13028,'Coordinate Reference System',5107,7301,'ETRF89 / NTM zone 7',''),
(13029,'Coordinate Reference System',5107,7301,'EUREF89 / NTM zone 7',''),
(13031,'Coordinate Reference System',5108,7301,'ETRF89 / NTM zone 8',''),
(13032,'Coordinate Reference System',5108,7301,'EUREF89 / NTM zone 8',''),
(13034,'Coordinate Reference System',5109,7301,'ETRF89 / NTM zone 9',''),
(13035,'Coordinate Reference System',5109,7301,'EUREF89 / NTM zone 9',''),
(13037,'Coordinate Reference System',5110,7301,'ETRF89 / NTM zone 10',''),
(13038,'Coordinate Reference System',5110,7301,'EUREF89 / NTM zone 10',''),
(13040,'Coordinate Reference System',5111,7301,'ETRF89 / NTM zone 11',''),
(13041,'Coordinate Reference System',5111,7301,'EUREF89 / NTM zone 11',''),
(13043,'Coordinate Reference System',5112,7301,'ETRF89 / NTM zone 12',''),
(13044,'Coordinate Reference System',5112,7301,'EUREF89 / NTM zone 12',''),
(13046,'Coordinate Reference System',5113,7301,'ETRF89 / NTM zone 13',''),
(13047,'Coordinate Reference System',5113,7301,'EUREF89 / NTM zone 13',''),
(13049,'Coordinate Reference System',5114,7301,'ETRF89 / NTM zone 14',''),
(13050,'Coordinate Reference System',5114,7301,'EUREF89 / NTM zone 14',''),
(13052,'Coordinate Reference System',5115,7301,'ETRF89 / NTM zone 15',''),
(13053,'Coordinate Reference System',5115,7301,'EUREF89 / NTM zone 15',''),
(13055,'Coordinate Reference System',5116,7301,'ETRF89 / NTM zone 16',''),
(13056,'Coordinate Reference System',5116,7301,'EUREF89 / NTM zone 16',''),
(13058,'Coordinate Reference System',5117,7301,'ETRF89 / NTM zone 17',''),
(13059,'Coordinate Reference System',5117,7301,'EUREF89 / NTM zone 17',''),
(13061,'Coordinate Reference System',5118,7301,'ETRF89 / NTM zone 18',''),
(13062,'Coordinate Reference System',5118,7301,'EUREF89 / NTM zone 18',''),
(13064,'Coordinate Reference System',5119,7301,'ETRF89 / NTM zone 19',''),
(13065,'Coordinate Reference System',5119,7301,'EUREF89 / NTM zone 19',''),
(13067,'Coordinate Reference System',5121,7301,'ETRF89 / NTM zone 21',''),
(13068,'Coordinate Reference System',5121,7301,'EUREF89 / NTM zone 21',''),
(13070,'Coordinate Reference System',5122,7301,'ETRF89 / NTM zone 22',''),
(13071,'Coordinate Reference System',5122,7301,'EUREF89 / NTM zone 22',''),
(13073,'Coordinate Reference System',5127,7301,'ETRF89 / NTM zone 27',''),
(13074,'Coordinate Reference System',5127,7301,'EUREF89 / NTM zone 27',''),
(13076,'Coordinate Reference System',5128,7301,'ETRF89 / NTM zone 28',''),
(13077,'Coordinate Reference System',5128,7301,'EUREF89 / NTM zone 28',''),
(13079,'Coordinate_Operation',5135,7317,'NTM zone 5',''),
(13081,'Coordinate_Operation',5137,7317,'NTM zone 7',''),
(13083,'Coordinate_Operation',5139,7317,'NTM zone 9',''),
(13091,'Coordinate_Operation',5138,7317,'NTM zone 8',''),
(13101,'Datum',6301,7301,'Tokyo 1918',''),
(13277,'Coordinate Reference System',5781,7307,'RO_CONST / NH',''),
(13279,'Coordinate Reference System',5705,7307,'LT_KRON / NH',''),
(13280,'Coordinate Reference System',5705,7307,'CZ_KRON / NH',''),
(13285,'Coordinate_Operation',18251,7302,'East Belt','Care! This same name is also used for the new (2010) projection.'),
(13293,'Coordinate_Operation',5131,7302,'Central Belt Jeju',''),
(13295,'Coordinate_Operation',5162,7302,'Modified Central Belt',''),
(13297,'Coordinate_Operation',5163,7301,'Modified Central Belt Jeju',''),
(13299,'Coordinate_Operation',5164,7302,'Modified East Belt',''),
(13301,'Coordinate_Operation',5165,7302,'Modified East Sea Belt',''),
(13303,'Coordinate_Operation',5161,7302,'Modified West Belt',''),
(13309,'Coordinate_Operation',5103,7301,'New East Belt',''),
(13310,'Coordinate_Operation',5103,7302,'East Belt 2010',''),
(13311,'Coordinate_Operation',5103,7301,'East Belt','Care! This same name is also used for the old projection.'),
(13314,'Coordinate_Operation',5102,7301,'Central Belt','Care! This same name is also used for the old projection.'),
(13315,'Coordinate_Operation',5102,7302,'Central Belt 2010',''),
(13316,'Coordinate_Operation',5102,7301,'New Central Belt',''),
(13318,'Coordinate_Operation',5104,7301,'New East Sea Belt',''),
(13319,'Coordinate_Operation',5104,7302,'East Sea Belt 2010',''),
(13320,'Coordinate_Operation',5104,7301,'East Sea Belt','Care! This same name is also used for the old projection.'),
(13322,'Coordinate_Operation',5101,7301,'New West Belt',''),
(13323,'Coordinate_Operation',5101,7302,'West Belt 2010',''),
(13324,'Coordinate_Operation',5101,7301,'West Belt','Care! This same name is also used for the old projection.'),
(13327,'Coordinate Reference System',5181,7302,'Korea 2000 / Central',''),
(13331,'Coordinate Reference System',5182,7302,'Korea 2000 / Jeju',''),
(13336,'Coordinate Reference System',5184,7302,'Korea 2000 / East Sea',''),
(13339,'Coordinate Reference System',5185,7302,'Korea 2000 / West 2010',''),
(13341,'Coordinate Reference System',5186,7302,'Korea 2000 / Central 2010',''),
(13343,'Coordinate Reference System',5187,7302,'Korea 2000 / East 2010',''),
(13345,'Coordinate Reference System',5188,7302,'Korea 2000 / E Sea 2010',''),
(13349,'Coordinate Reference System',5168,7302,'Korean 1985 / Jeju Belt',''),
(13351,'Coordinate Reference System',5167,7302,'Korean 1985 / East Sea',''),
(13353,'Coordinate Reference System',5174,7302,'Korean 1985 / Mod Cen',''),
(13354,'Coordinate Reference System',5175,7302,'Korean 1985 / Mod Jeju',''),
(13359,'Coordinate Reference System',5177,7302,'Korean 1985 / Mod E Sea',''),
(13363,'Coordinate_Operation',5100,7301,'Unified CS',''),
(13377,'Coordinate Reference System',4301,7301,'Tokyo 1918',''),
(13380,'Coordinate Reference System',5173,7302,'Korean 1985 / Mod West',''),
(13382,'Coordinate Reference System',5176,7302,'Korean 1985 / Mod East',''),
(13445,'Coordinate_Operation',18252,7302,'Central Belt','Care! This same name is also used for the new (2010) projection.'),
(13447,'Coordinate_Operation',18253,7302,'West Belt','Care! This same name is also used for the new (2010) projection.'),
(13465,'Coordinate_Operation',5049,7302,'East Sea Belt','Care! This same name is also used for the new (2010) projection.'),
(13470,'Coordinate Reference System',5132,7301,'Tokyo 1898',''),
(13472,'Datum',1048,7301,'Tokyo 1898',''),
(13477,'Coordinate Reference System',5169,7301,'Tokyo / Korea West Belt','This name is ambiguous as it is also used for the Tokyo 1918 system.'),
(13478,'Coordinate Reference System',5169,7302,'Tokyo 1892 / Korea West',''),
(13479,'Coordinate Reference System',5169,7301,'Tokyo 1898 / Korea West Belt',''),
(13492,'Coordinate Reference System',5170,7301,'Tokyo / Korea Central Belt','This name is ambiguous as it is also used for the Tokyo 1918 system.'),
(13493,'Coordinate Reference System',5170,7302,'Tokyo 1892 / Korea Cen',''),
(13494,'Coordinate Reference System',5170,7301,'Tokyo 1898 / Korea Central Belt',''),
(13496,'Coordinate Reference System',5171,7301,'Tokyo / Korea East Belt','This name is ambiguous as it is also used for the Tokyo 1918 system.'),
(13497,'Coordinate Reference System',5171,7302,'Tokyo 1892 / Korea East',''),
(13498,'Coordinate Reference System',5171,7301,'Tokyo 1898 / Korea East Belt',''),
(13500,'Coordinate Reference System',5172,7301,'Tokyo / Korea East Sea Belt','This name is ambiguous as it is also used for the Tokyo 1918 system.'),
(13501,'Coordinate Reference System',5172,7302,'Tokyo 1892 / Korea E Sea',''),
(13502,'Coordinate Reference System',5172,7301,'Tokyo 1898 / Korea East Sea Belt',''),
(13504,'Coordinate_Operation',5192,7301,'Tokyo 1898 to WGS 84 (1)',''),
(13506,'Coordinate_Operation',5133,7301,'Tokyo 1898 to Tokyo 1918 (1)',''),
(13507,'Coordinate_Operation',5133,7301,'Tokyo 1892 to Tokyo 1918 (1)',''),
(13509,'Coordinate_Operation',5134,7301,'Tokyo 1898 to Korean 1985 (1)',''),
(13511,'Coordinate_Operation',5190,7301,'Tokyo 1898 to Korea 2000 (1)',''),
(13513,'Coordinate_Operation',5166,1032,'100800400','Code used by ICC for ED50 to ETRS89 transformation.'),
(13514,'Coordinate_Operation',5166,1032,'800100400','Code used by ICC for ETRS89 to ED50 transformation.'),
(13546,'Coordinate_Operation',5436,7307,'EE_KRON / NH to EVRF2000',''),
(13548,'Coordinate_Operation',5437,7307,'LT_KRON / NH to EVRF2000',''),
(13575,'Coordinate Reference System',5613,7307,'SE_AMST2000 / NH',''),
(13585,'Coordinate_Operation',5200,7307,'BG_KRON / NH to EVRF2007',''),
(13587,'Coordinate_Operation',5196,7307,'HR_HRVD71 / NOH to EVRF2000',''),
(13589,'Coordinate_Operation',5197,7307,'HR_HRVD71 / NOH to EVRF2007',''),
(13593,'Coordinate_Operation',5199,7307,'BE_OOST / UNCOR to EVRF2007',''),
(13595,'Coordinate_Operation',5198,7307,'BE_OOST / UNCOR to EVRF2000',''),
(13649,'Coordinate_Operation',5201,7307,'CZ_KRON / NH to EVRF2000',''),
(13651,'Coordinate_Operation',5209,7307,'LV_KRON / NH to EVRF2000',''),
(13653,'Coordinate_Operation',5202,7307,'CZ_KRON / NH to EVRF2007',''),
(13655,'Coordinate_Operation',5203,7307,'EE_KRON / NH to EVRF2007',''),
(13657,'Coordinate_Operation',5204,7307,'LT_KRON / NH to EVRF2007',''),
(13661,'Coordinate_Operation',5205,7307,'RO_CONST / NH to EVRF2000',''),
(13663,'Coordinate_Operation',5206,7307,'RO_CONST / NH to EVRF2007',''),
(13665,'Coordinate_Operation',5210,7307,'LV_KRON / NH to EVRF2007',''),
(13667,'Coordinate_Operation',5212,7307,'DE_AMST / NOH to EVRF2007',''),
(13669,'Coordinate_Operation',5211,7307,'DE_AMST / NH to EVRF2007',''),
(13672,'Coordinate Reference System',5214,7307,'IT_GENO / OH',''),
(13674,'Coordinate_Operation',5213,7307,'IT_GENO / OH (peninsular part) to EVRF2000',''),
(13676,'Coordinate_Operation',5216,7307,'IT_GENO / OH (Sicily) to EVRF2000',''),
(13680,'Coordinate_Operation',5215,7307,'IT_GENO / OH (peninsular part) to EVRF2007',''),
(13682,'Coordinate_Operation',5217,7307,'IT_GENO / OH (Sicily) to EVRF2007',''),
(13684,'Coordinate_Operation',5207,7307,'CH_MARS / UNCOR to EVRF2007',''),
(13686,'Coordinate_Operation',5208,7307,'SE_AMST2000 / NH to EVRF2007',''),
(13689,'Coordinate Reference System',5195,7307,'Hr_TRIE / NOH',''),
(13893,'Datum',1054,7302,'SLVD',''),
(13897,'Datum',1053,7317,'SLD99',''),
(14107,'Coordinate_Operation',5239,7301,'S-JTSK to ETRF89 (5)',''),
(14136,'Coordinate Reference System',5243,7310,'ETRS89-LCC-DE(E-N)',''),
(14180,'Datum',1057,7317,'TUREF',''),
(14199,'Coordinate Reference System',5254,7301,'TUREF / 3-degree Gauss-Kruger CM 30E',''),
(14200,'Coordinate Reference System',5254,7307,'TR_TUREF / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(14215,'Coordinate Reference System',5256,7301,'TUREF / 3-degree Gauss-Kruger CM 36E',''),
(14216,'Coordinate Reference System',5256,7307,'TR_TUREF / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(14220,'Coordinate Reference System',5257,7301,'TUREF / 3-degree Gauss-Kruger CM 39E',''),
(14221,'Coordinate Reference System',5257,7307,'TR_TUREF / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(14225,'Coordinate Reference System',5258,7301,'TUREF / 3-degree Gauss-Kruger CM 42E',''),
(14226,'Coordinate Reference System',5258,7307,'TR_TUREF / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(14230,'Coordinate Reference System',5259,7301,'TUREF / 3-degree Gauss-Kruger CM 45E',''),
(14231,'Coordinate Reference System',5259,7307,'TR_TUREF / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(14232,'Coordinate_Operation',5260,7301,'TUREF to ETRF89 (1)',''),
(14239,'Datum',1058,7317,'DRUKREF 03',''),
(14254,'Coordinate Reference System',5269,7317,'TUREF / Turkey zone 9',''),
(14257,'Coordinate Reference System',5270,7317,'TUREF / Turkey zone 10',''),
(14260,'Coordinate Reference System',5271,7317,'TUREF / Turkey zone 11',''),
(14263,'Coordinate Reference System',5272,7317,'TUREF / Turkey zone 12',''),
(14266,'Coordinate Reference System',5273,7317,'TUREF / Turkey zone 13',''),
(14269,'Coordinate Reference System',5274,7317,'TUREF / Turkey zone 14',''),
(14272,'Coordinate Reference System',5275,7317,'TUREF / Turkey zone 15',''),
(14302,'Coordinate Reference System',5255,7301,'TUREF / 3-degree Gauss-Kruger CM 33E',''),
(14303,'Coordinate Reference System',5255,7307,'TR_TUREF / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(14305,'Coordinate Reference System',5253,7301,'TUREF / 3-degree Gauss-Kruger CM 27E',''),
(14306,'Coordinate Reference System',5253,7307,'TR_TUREF / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(14320,'Coordinate_Operation',19894,7301,'East Malaysia BRSO',''),
(14321,'Coordinate_Operation',19894,7301,'Brunei BRSO',''),
(14324,'Coordinate Reference System',5247,7302,'GDBD2009 / Brunei RSO',''),
(14369,'Datum',1056,7317,'GDBD2009',''),
(14371,'Coordinate_Operation',5248,7301,'Timbalai 1968 to GDBD2009 (1)',''),
(14372,'Coordinate_Operation',5248,7301,'BT68 to GDBD2009 (1)',''),
(14373,'Coordinate_Operation',5248,7301,'BT48 to GDBD2009 (1)',''),
(14375,'Coordinate_Operation',5249,7301,'Timbalai 1968 to WGS 84 (5)',''),
(14376,'Coordinate_Operation',5249,7301,'BT68 to WGS 84 (5)',''),
(14437,'Coordinate_Operation Method',9804,7301,'Mercator (1SP)','This was the method name used prior to October 2010.'),
(14480,'Coordinate_Operation',5226,7301,'S-JTSK/05 to ETRF89 (1)',''),
(14509,'Datum',6674,7301,'Sistema de Referencia Geocentrico para America del Sur 2000','Name of pre-February 2001 still used by some.'),
(14520,'Coordinate Reference System',4484,7302,'Mexico 1992 / UTM 11N',''),
(14521,'Coordinate Reference System',4484,1028,'Red Geodesica Nacional ITRF92 / UTM 11N',''),
(14523,'Coordinate Reference System',4485,7302,'Mexico 1992 / UTM 12N',''),
(14524,'Coordinate Reference System',4485,1028,'Red Geodesica Nacional ITRF92 / UTM 12N',''),
(14526,'Coordinate Reference System',4486,7302,'Mexico 1992 / UTM 13N',''),
(14527,'Coordinate Reference System',4486,1028,'Red Geodesica Nacional ITRF92 / UTM 13N',''),
(14529,'Coordinate Reference System',4487,7302,'Mexico 1992 / UTM 14N',''),
(14530,'Coordinate Reference System',4487,1028,'Red Geodesica Nacional ITRF92 / UTM 14N',''),
(14532,'Coordinate Reference System',4488,7302,'Mexico 1992 / UTM 15N',''),
(14533,'Coordinate Reference System',4488,1028,'Red Geodesica Nacional ITRF92 / UTM 15N',''),
(14554,'Coordinate Reference System',4489,1028,'Red Geodesica Nacional ITRF92 / UTM 16N',''),
(14555,'Coordinate Reference System',4489,7302,'Mexico 1992 / UTM 16N',''),
(14619,'Datum',6818,7302,'S-JTSK (Ferro)',''),
(14713,'Coordinate Reference System',5266,7302,'DRUKREF 03 / Bhutan NG',''),
(14717,'Coordinate Reference System',5302,7302,'DRUKREF 03 / S Jong TM',''),
(14724,'Coordinate Reference System',5309,7302,'DRUKREF 03 / Wangdue TM',''),
(14726,'Coordinate Reference System',5300,7302,'DRUKREF 03 / P-Gatsh TM',''),
(14728,'Coordinate Reference System',5306,7302,'DRUKREF 03 / T-Gang TM',''),
(14779,'Coordinate Reference System',5318,7301,'ETRF89 / Faroe TM + FVR09 height',''),
(14781,'Datum',1059,7302,'FVR09',''),
(14790,'Coordinate_Operation',5315,7302,'Faroe TM',''),
(14791,'Coordinate_Operation',5315,7301,'FOTM',''),
(14805,'Coordinate Reference System',5316,7301,'ETRS89 / FOTM',''),
(14806,'Coordinate Reference System',5316,7301,'ETRF89 / Faroe TM',''),
(14812,'Datum',1052,7302,'S-JTSK/05',''),
(14813,'Datum',1052,7300,'Systm Jednotn Trigonometrick Ste Katastrln/05',''),
(14815,'Datum',1055,7302,'S-JTSK/05 (Ferro)',''),
(14816,'Datum',1055,7300,'Systm Jednotn Trigonometrick Ste Katastrln/05 (Ferro)',''),
(14827,'Coordinate Reference System',5224,7302,'S-JTSK/05F / ModKrovak','Uses Ferro meridian.'),
(14829,'Coordinate Reference System',5225,7302,'S-JTSK/05F / ModKrovakEN','Uses Ferro meridian.'),
(14833,'Coordinate Reference System',5221,7302,'S-JTSK (F) / Krovak EN','Uses Greenwich meridian.'),
(14851,'Coordinate_Operation Method',9812,7301,'Hotine Oblique Mercator','This was the method name used prior to October 2010.'),
(14853,'Coordinate_Operation Method',9815,7301,'Rectified Skew Orthomorphic (RSO)','This same name is also used for variant A.'),
(14854,'Coordinate_Operation Method',9815,7301,'Oblique Mercator','This was the method name used prior to October 2010.'),
(14857,'Coordinate_Operation Method',9813,7301,'Laborde Madagascar','This was the method name used prior to October 2010.'),
(14882,'Coordinate_Operation Method',9805,7301,'Mercator (2SP)','This was the method name used prior to October 2010. However it is ambiguous as it is also applicable to variant C (method code 1044).'),
(14893,'Coordinate Reference System',5320,7302,'NAD83 / Teranet LC',''),
(14895,'Coordinate Reference System',5321,7302,'NAD83(CSRS) / Teranet LC',''),
(14946,'Coordinate_Operation',19989,7302,'Lambert 1993',''),
(14950,'Coordinate_Operation',5326,7302,'Lambert 2004',''),
(14958,'Datum',1060,7302,'ISN2004',''),
(14966,'Coordinate_Operation',5328,7302,'NEIEZ Jkt',''),
(14980,'Coordinate Reference System',5330,7302,'Batavia (Jkt) / NEIEZ',''),
(14985,'Coordinate Reference System',5331,7302,'Makassar (Jkt) / NEIEZ',''),
(15039,'Datum',1061,7302,'ITRF2008',''),
(15048,'Coordinate Reference System',4248,7301,'La Canoa','Alias used within Venezuela.'),
(15059,'Coordinate_Operation',5334,7301,'ETRS89 to Belfast Lough height (1)',''),
(15060,'Coordinate_Operation',5334,7301,'ETRF89 to Belfast height (1)',''),
(15063,'Coordinate_Operation',5335,7301,'ETRF89 to Malin Head height (1)',''),
(15156,'Coordinate_Operation',1232,7301,'Tokyo 1918 to WGS 84 (3)',''),
(15158,'Coordinate_Operation',1305,7301,'Tokyo 1918 to WGS 84 (5)',''),
(15501,'Datum',6152,7301,'NAD83 (High Accuracy Regional Network)',''),
(15516,'Coordinate_Operation',5338,7302,'OSTN02_NTv2',''),
(15517,'Coordinate_Operation',5338,7301,'OSGB 1936 to ETRF89 (1)',''),
(15570,'Coordinate Reference System',31254,7307,'AT_MGI / Austria GK','This same identifier used for each of West, Central and East zones.'),
(15573,'Coordinate Reference System',31256,7307,'AT_MGI / Austria GK','This same identifier used for each of West, Central and East zones.'),
(15575,'Coordinate Reference System',31255,7307,'AT_MGI / Austria GK','This same identifier used for each of West, Central and East zones.'),
(15578,'Coordinate Reference System',3416,7307,'AT_ETRS89 / Austria Lambert',''),
(15599,'Area',3807,7301,'Curaao',''),
(15605,'Area',3823,7301,'Curaao - onshore',''),
(15852,'Coordinate_Operation',1234,1034,'ROU-USAMS to WGS 84 (1)',''),
(15873,'Coordinate_Operation',5386,1034,'ROU-USAMS to WGS 84 (2)',''),
(16041,'Coordinate_Operation',5385,1034,'ROU-USAMS to SIRGAS-ROU98 (1)',''),
(16142,'Coordinate Reference System',5459,7302,'Ocotepeque / Guatemala S',''),
(16143,'Coordinate Reference System',5458,7302,'Ocotepeque / Guatemala N',''),
(16151,'Coordinate Reference System',5460,7302,'Ocotepeque / El Salvador',''),
(16154,'Coordinate Reference System',5461,7302,'Ocotepeque / Nicaragua N',''),
(16157,'Coordinate Reference System',5462,7302,'Ocotepeque / Nicaragua S',''),
(16279,'Coordinate Reference System',5396,7302,'SIRGAS 2000 / UTM 26S',''),
(16282,'Coordinate Reference System',5466,7302,'Sibun Gorge / Colony Grd',''),
(16302,'Coordinate Reference System',5469,7302,'Panama-Colon / Lambert',''),
(16314,'Coordinate_Operation',5470,7302,'Ocotepeque to WGS 84 (1)',''),
(16318,'Coordinate_Operation',5474,7302,'Ocotepeque to NAD27 (1)',''),
(16331,'Datum',1069,7301,'Red Geodsica Bsica Nacional de El Salvador',''),
(16344,'Coordinate_Operation',5375,7302,'SIRGAS-Chl to WGS 84 (1)',''),
(16348,'Coordinate_Operation',5377,7302,'M SOLIS to WGS 84 (1)',''),
(16354,'Coordinate Reference System',5382,7302,'SIRGAS-ROU98 / UTM 21S',''),
(16356,'Coordinate Reference System',5383,7302,'SIRGAS-ROU98 / UTM 22S',''),
(16381,'Datum',1067,7301,'Sistema Geodsico Nacional','This name is ambiguous as the same name is used for several South American geodetic datums.'),
(16394,'Coordinate_Operation',5384,7302,'ROU98 to WGS 84 (1)',''),
(16399,'Datum',6309,1034,'ROU-USAMS',''),
(16401,'Coordinate Reference System',4309,1034,'ROU-USAMS',''),
(16410,'Coordinate_Operation',5366,7302,'CRTM05',''),
(16419,'Datum',1065,7317,'CR05','Name as used in Costa Rica.'),
(16432,'Datum',1063,7302,'MARGEN',''),
(16443,'Coordinate Reference System',5362,7302,'SIRGAS-Chile / UTM 18S',''),
(16445,'Coordinate Reference System',5361,7302,'SIRGAS-Chile / UTM 19S',''),
(16451,'Datum',1066,7301,'MACARIO SOLIS',''),
(16476,'Coordinate_Operation',5478,7302,'RSPS2000',''),
(16491,'Coordinate_Operation',5475,7302,'MSLC2000',''),
(16493,'Coordinate_Operation',5476,7302,'BCLC2000',''),
(16499,'Coordinate_Operation',5477,7302,'PCLC2000',''),
(16574,'Datum',1073,7302,'RGAF09',''),
(16614,'Datum',1062,7302,'POSGAR 2007',''),
(16615,'Datum',1062,7301,'POSGAR','This alias is ambiguous, used for POSGAR 94, POSGAR 98 and POSGAR 2007.'),
(16616,'Datum',1062,7300,'Posiciones Geodsicas Argentinas 2007',''),
(16630,'Coordinate Reference System',5341,1033,'Marco de Referencia Geodsico Nacional Oficial','Name is ambiguous (outside of Argentina) as similar names will exist for all Latin American countries.'),
(16632,'Coordinate Reference System',5342,1033,'Marco de Referencia Geodsico Nacional Oficial','Name is ambiguous (outside of Argentina) as similar names will exist for all Latin American countries.'),
(16634,'Coordinate Reference System',5340,1033,'Marco de Referencia Geodsico Nacional Oficial','Name is ambiguous (outside of Argentina) as similar names will exist for all Latin American countries.'),
(16659,'Coordinate_Operation',5350,7302,'C I to POSGAR 2007 (1)',''),
(16673,'Coordinate_Operation',1774,7301,'POSGAR 98 to SIRGAS (1)',''),
(16677,'Coordinate Reference System',5349,7302,'POSGAR 07 / Argentina 7',''),
(16678,'Coordinate Reference System',5349,7301,'POSGAR 2007 / Gauss-Kruger zone 7',''),
(16680,'Coordinate Reference System',5348,7302,'POSGAR 07 / Argentina 6',''),
(16681,'Coordinate Reference System',5348,7301,'POSGAR 2007 / Gauss-Kruger zone 6',''),
(16683,'Coordinate Reference System',5347,7302,'POSGAR 07 / Argentina 5',''),
(16684,'Coordinate Reference System',5347,7301,'POSGAR 2007 / Gauss-Kruger zone 5',''),
(16686,'Coordinate Reference System',5346,7302,'POSGAR 07 / Argentina 4',''),
(16687,'Coordinate Reference System',5346,7301,'POSGAR 2007 / Gauss-Kruger zone 4',''),
(16689,'Coordinate Reference System',5345,7302,'POSGAR 07 / Argentina 3',''),
(16690,'Coordinate Reference System',5345,7301,'POSGAR 2007 / Gauss-Kruger zone 3',''),
(16693,'Coordinate Reference System',5344,7301,'POSGAR 2007 / Gauss-Kruger zone 2',''),
(16694,'Coordinate Reference System',5344,7302,'POSGAR 07 / Argentina 2',''),
(16749,'Coordinate Reference System',5343,7302,'POSGAR 07 / Argentina 1',''),
(16750,'Coordinate Reference System',5343,7301,'POSGAR 2007 / Gauss-Kruger zone 1',''),
(16766,'Coordinate Reference System',5456,7302,'Ocotepeque / Costa Rica N',''),
(16768,'Coordinate Reference System',5457,7302,'Ocotepeque / C R Sur',''),
(16782,'Datum',1072,7301,'Balboa',''),
(16783,'Datum',1072,7301,'Panam-Coln 1911',''),
(17060,'Coordinate_Operation',5483,7302,'LUREF to ETRS89 (4)',''),
(17061,'Coordinate_Operation',5483,7301,'Luxembourg 1930 to ETRF89 (4)',''),
(17063,'Coordinate_Operation',5485,7302,'LUREF to ETRS89 (3)',''),
(17064,'Coordinate_Operation',5485,7301,'Luxembourg 1930 to ETRF89 (3)',''),
(17076,'Coordinate_Operation',5484,7301,'LUREF to WGS 84 (4)',''),
(17078,'Coordinate_Operation',5486,7301,'LUREF to WGS 84 (3)',''),
(17435,'Coordinate_Operation',5502,7301,'RGAF09 to IGN 1987 (1)',''),
(17437,'Coordinate_Operation',5503,7301,'RGAF09 to IGN 1988 (1)',''),
(17476,'Coordinate_Operation',5491,7301,'Fort Desaix to RGAF09 (1)',''),
(17482,'Coordinate_Operation',5492,7301,'Sainte Anne to RGAF09 (1)',''),
(17483,'Coordinate_Operation',5493,7301,'Fort Marigot to RGAF09 (1)',''),
(17793,'Coordinate Reference System',5515,7302,'S-JTSK/05 / ModKrovak','Uses Greenwich meridian.'),
(17795,'Coordinate Reference System',5516,7302,'S-JTSK/05 / ModKrovakEN','Uses Greenwich meridian.'),
(17802,'Coordinate Reference System',5514,7302,'S-JTSK / Krovak EN (G)','Uses Greenwich meridian.'),
(17837,'Coordinate Reference System',5518,7302,'CI1971 / CIMG',''),
(17848,'Coordinate_Operation',5517,7301,'Chatham Islands Circuit',''),
(17849,'Coordinate_Operation',5517,7302,'CIMG',''),
(17961,'Coordinate Reference System',32183,7301,'NAD83 / SCoPQ zone 3',''),
(17974,'Coordinate Reference System',32184,7301,'NAD83 / SCoPQ zone 4',''),
(17976,'Coordinate Reference System',32185,7301,'NAD83 / SCoPQ zone 5',''),
(17978,'Coordinate Reference System',32186,7301,'NAD83 / SCoPQ zone 6',''),
(17980,'Coordinate Reference System',32187,7301,'NAD83 / SCoPQ zone 7',''),
(17982,'Coordinate Reference System',32188,7301,'NAD83 / SCoPQ zone 8',''),
(17984,'Coordinate Reference System',32189,7301,'NAD83 / SCoPQ zone 9',''),
(17986,'Coordinate Reference System',32190,7301,'NAD83 / SCoPQ zone 10',''),
(18009,'Coordinate Reference System',5519,7302,'CI1979 / CIMG',''),
(18043,'Coordinate Reference System',5520,7302,'DHDN / 3GK zone 1',''),
(18411,'Coordinate Reference System',4646,7301,'IGN50',''),
(18414,'Coordinate_Operation',5521,7301,'IGN50 to WGS 84 (1)',''),
(18556,'Coordinate_Operation',5222,7302,'Gabon TM',''),
(18557,'Coordinate_Operation',5222,7301,'GTM',''),
(18562,'Coordinate_Operation',5522,7302,'Gabon TM 2011',''),
(18563,'Coordinate_Operation',5522,7301,'GTM 2011',''),
(18565,'Coordinate Reference System',5523,7301,'WGS 84 / GTM 2011',''),
(18569,'Coordinate Reference System',5223,7301,'WGS 84 / GTM',''),
(18609,'Datum',6225,7301,'Corrego Alegre',''),
(18614,'Coordinate Reference System',4225,7301,'Corrego Alegre',''),
(18623,'Coordinate_Operation',1132,7301,'Corrego Alegre to WGS 84 (1)',''),
(18629,'Coordinate Reference System',22524,7301,'Corrego Alegre / UTM zone 24S',''),
(18631,'Coordinate Reference System',22523,7301,'Corrego Alegre / UTM zone 23S',''),
(18633,'Coordinate Reference System',22522,7301,'Corrego Alegre / UTM zone 22S',''),
(18639,'Coordinate Reference System',22521,7301,'Corrego Alegre / UTM zone 21S',''),
(18641,'Coordinate Reference System',22525,7301,'Corrego Alegre / UTM zone 25S',''),
(18704,'Coordinate Reference System',5536,7302,'Corrego Aleg61 / UTM 21S',''),
(18707,'Coordinate Reference System',5537,7302,'Corrego Aleg61 / UTM 22S',''),
(18710,'Coordinate Reference System',5538,7302,'Corrego Aleg61 / UTM 23S',''),
(18713,'Coordinate Reference System',5539,7302,'Corrego Aleg61 / UTM 24S',''),
(18769,'Coordinate_Operation',5547,7302,'PNGMG94 zone 54',''),
(18771,'Coordinate_Operation',5548,7302,'PNGMG94 zone 55',''),
(18773,'Coordinate_Operation',5549,7302,'PNGMG94 zone 56',''),
(18782,'Datum',1076,7302,'PNG94',''),
(18942,'Coordinate Reference System',5472,7302,'Panama-Colon / Polyconic',''),
(18975,'Coordinate_Operation',5525,1035,'Corrego Alegre 1961 to SIRGAS2000 (1)',''),
(18979,'Coordinate_Operation',5526,1035,'Corrego Alegre 1970-72 to SIRGAS2000 (1)',''),
(18981,'Coordinate_Operation',5529,1035,'SAD69(96) to SIRGAS2000 (1)',''),
(18983,'Coordinate_Operation',5528,1035,'SAD69 to SIRGAS2000 (2)',''),
(18986,'Coordinate_Operation',5050,1035,'Aratu to SIRGAS2000 (1)',''),
(18988,'Coordinate_Operation',5052,1035,'Aratu to SIRGAS2000 (2)',''),
(18990,'Coordinate_Operation',5054,1035,'Aratu to SIRGAS2000 (3)',''),
(18995,'Coordinate_Operation',5060,1035,'Aratu to SIRGAS2000 (6)',''),
(18997,'Coordinate_Operation',5062,1035,'Aratu to SIRGAS2000 (7)',''),
(18999,'Coordinate_Operation',5064,1035,'Aratu to SIRGAS2000 (8)',''),
(19001,'Coordinate_Operation',5066,1035,'Aratu to SIRGAS2000 (9)',''),
(19003,'Coordinate_Operation',4069,1035,'Chua to SIRGAS2000 (1)',''),
(19005,'Coordinate_Operation',15894,1035,'SIRGAS2000 to WGS 84 (1)',''),
(19007,'Coordinate Reference System',4674,1035,'SIRGAS2000',''),
(19009,'Coordinate Reference System',4988,1035,'SIRGAS2000',''),
(19011,'Coordinate Reference System',4989,1035,'SIRGAS2000',''),
(19013,'Coordinate Reference System',5396,1035,'SIRGAS2000 / UTM zone 26S',''),
(19015,'Coordinate Reference System',31985,1035,'SIRGAS2000 / UTM zone 25S',''),
(19017,'Coordinate Reference System',31984,1035,'SIRGAS2000 / UTM zone 24S',''),
(19019,'Coordinate Reference System',31983,1035,'SIRGAS2000 / UTM zone 23S',''),
(19021,'Coordinate Reference System',31982,1035,'SIRGAS2000 / UTM zone 22S',''),
(19023,'Coordinate Reference System',31981,1035,'SIRGAS2000 / UTM zone 21S',''),
(19025,'Coordinate Reference System',31980,1035,'SIRGAS2000 / UTM zone 20S',''),
(19027,'Coordinate Reference System',31979,1035,'SIRGAS2000 / UTM zone 19S',''),
(19029,'Coordinate Reference System',31978,1035,'SIRGAS2000 / UTM zone 18S',''),
(19031,'Datum',6674,1035,'SIRGAS2000',''),
(19033,'Coordinate_Operation',5058,1035,'Aratu to SIRGAS 2000 (5)',''),
(19066,'Coordinate_Operation',5473,7302,'Ocotepeque to WGS 84 (2)',''),
(19590,'Datum',5182,7301,'Deutsches Haupthhennetz 1985',''),
(19592,'Datum',5181,7301,'Deutsches Haupthhennetz 1992',''),
(19606,'Coordinate Reference System',5559,7302,'Ocotepeque / Guatemala N',''),
(19865,'Coordinate_Operation',5584,7301,'MOLDREF99 to ETRF89 (1)',''),
(19868,'Coordinate_Operation',5587,7302,'NB Stereographic NAD27',''),
(19875,'Coordinate Reference System',5589,7302,'Sibun Gorge / Colony Grd',''),
(19891,'Coordinate Reference System',5566,7301,'UCS-2000 / 6-degree Gauss-Kruger CM 21E',''),
(19892,'Coordinate Reference System',5566,7302,'UCS-2000 / 6GK 21E',''),
(19894,'Coordinate Reference System',5567,7301,'UCS-2000 / 6-degree Gauss-Kruger CM 27E',''),
(19895,'Coordinate Reference System',5567,7302,'UCS-2000 / 6GK 27E',''),
(19897,'Coordinate Reference System',5568,7301,'UCS-2000 / 6-degree Gauss-Kruger CM 33E',''),
(19898,'Coordinate Reference System',5568,7302,'UCS-2000 / 6GK 33E',''),
(19903,'Coordinate Reference System',5569,7301,'UCS-2000 / 6-degree Gauss-Kruger CM 39E',''),
(19904,'Coordinate Reference System',5569,7302,'UCS-2000 / 6GK 39E',''),
(19920,'Coordinate Reference System',5583,7302,'UCS-2000 / 3GK 39E',''),
(19922,'Coordinate Reference System',5582,7302,'UCS-2000 / 3GK 36E',''),
(19924,'Coordinate Reference System',5581,7302,'UCS-2000 / 3GK 33E',''),
(19926,'Coordinate Reference System',5580,7302,'UCS-2000 / 3GK 30E',''),
(19928,'Coordinate Reference System',5578,7302,'UCS-2000 / 3GK 24E',''),
(19932,'Coordinate Reference System',5579,7302,'UCS-2000 / 3GK 27E',''),
(19948,'Coordinate Reference System',5570,7302,'UCS-2000 / 3GK zn 7',''),
(19950,'Coordinate Reference System',5571,7302,'UCS-2000 / 3GK zn 8',''),
(19952,'Coordinate Reference System',5572,7302,'UCS-2000 / 3GK zn 9',''),
(19954,'Coordinate Reference System',5573,7302,'UCS-2000 / 3GK zn 10',''),
(19956,'Coordinate Reference System',5574,7302,'UCS-2000 / 3GK zn 11',''),
(19958,'Coordinate Reference System',5575,7302,'UCS-2000 / 3GK zn 12',''),
(19960,'Coordinate Reference System',5576,7302,'UCS-2000 / 3GK zn 13',''),
(19961,'Coordinate Reference System',5562,7301,'UCS-2000 / 6-degree Gauss-Kruger zone 4',''),
(19962,'Coordinate Reference System',5562,7302,'UCS-2000 zone 4','UCS-2000 is ambiguous as it is also used for other CRSs.'),
(19964,'Coordinate Reference System',5563,7301,'UCS-2000 / 6-degree Gauss-Kruger zone 5',''),
(19965,'Coordinate Reference System',5563,7302,'UCS-2000 zone 5','UCS-2000 is ambiguous as it is also used for other CRSs.'),
(19967,'Coordinate Reference System',5564,7301,'UCS-2000 / 6-degree Gauss-Kruger zone 6',''),
(19968,'Coordinate Reference System',5564,7302,'UCS-2000 zone 6','UCS-2000 is ambiguous as it is also used for other CRSs.'),
(19970,'Coordinate Reference System',5565,7301,'UCS-2000 / 6-degree Gauss-Kruger zone 7',''),
(19971,'Coordinate Reference System',5565,7302,'UCS-2000 zone 7','UCS-2000 is ambiguous as it is also used for other CRSs.'),
(20000,'Coordinate Reference System',5577,7302,'UCS-2000 / 3GK 21E',''),
(20015,'Coordinate Reference System',5588,7302,'NAD27 / NB Stereographic',''),
(20048,'Datum',1078,7302,'FEH10',''),
(20058,'Coordinate Reference System',5596,7301,'Fehmarnbelt Coordinate System',''),
(20059,'Coordinate Reference System',5596,7302,'FCS',''),
(20061,'Datum',1079,7302,'FCSVR10',''),
(20065,'Coordinate Reference System',5598,7301,'FCS + FCSVR10 height',''),
(20109,'Coordinate_Operation',5586,7301,'S-42 to UCS-2000 (1)','Both S-42 and UCS-2000 are ambiguous as they are both used as the name for several CRSs.'),
(20124,'Coordinate Reference System',5624,7302,'NAD27 / Michigan Old Cen',''),
(20279,'Coordinate Reference System',3040,7301,'ETRS89 / TM28',''),
(20302,'Coordinate Reference System',4647,7301,'ETRF89 / UTM zone 32N (zE-N)',''),
(20465,'Coordinate Reference System',5646,7302,'NAD83 / VT (ftUS)',''),
(20469,'Coordinate Reference System',5654,7301,'NAD83(HPGN) / Vermont (ftUS)',''),
(20470,'Coordinate Reference System',5654,7302,'NAD83(HARN) / VT (ftUS)',''),
(20473,'Coordinate Reference System',5655,7302,'NAD83(NSRS) / VT (ftUS)',''),
(20581,'Coordinate_Operation',5645,7301,'Vermont CS83 (ftUS)',''),
(20592,'Coordinate_Operation',5557,7307,'AT_TRIE / NOH to EVRF2007',''),
(22090,'Coordinate Reference System',5680,7302,'DHDN / 3GK zone 1',''),
(22099,'Coordinate Reference System',5676,7310,'DHDN / Gauss-Kruger zone 2',''),
(22100,'Coordinate Reference System',5676,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22101,'Coordinate Reference System',5676,7302,'DHDN / 3GK zone 2',''),
(22103,'Coordinate Reference System',5677,7310,'DHDN / Gauss-Kruger zone 3',''),
(22104,'Coordinate Reference System',5677,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22105,'Coordinate Reference System',5677,7302,'DHDN / 3GK zone 3',''),
(22107,'Coordinate Reference System',5678,7310,'DHDN / Gauss-Kruger zone 4',''),
(22108,'Coordinate Reference System',5678,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22109,'Coordinate Reference System',5678,7302,'DHDN / 3GK zone 4',''),
(22111,'Coordinate Reference System',5679,7310,'DHDN / Gauss-Kruger zone 5',''),
(22112,'Coordinate Reference System',5679,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22113,'Coordinate Reference System',5679,7302,'DHDN / 3GK zone 5',''),
(22115,'Coordinate Reference System',5666,7301,'DHDN / 3GK zone 3','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(22116,'Coordinate Reference System',5666,7307,'DE_PD/83 / GK_3','This EuroGeographics identifier is used for both of zones 3 and 4. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22117,'Coordinate Reference System',5666,7310,'PD/83 / Gauss-Kruger zone 3',''),
(22118,'Coordinate Reference System',5666,7302,'PD/83 / 3GK zone 3',''),
(22120,'Coordinate Reference System',5667,7301,'DHDN / 3GK zone 4','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(22121,'Coordinate Reference System',5667,7307,'DE_PD/83 / GK_3','This EuroGeographics identifier is used for both of zones 3 and 4. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22122,'Coordinate Reference System',5667,7310,'PD/83 / Gauss-Kruger zone 4',''),
(22123,'Coordinate Reference System',5667,7302,'PD/83 / 3GK zone 4',''),
(22125,'Coordinate Reference System',5670,7302,'Pulkovo 42(58) / 3GK zn3',''),
(22127,'Coordinate Reference System',5671,7302,'Pulkovo 42(58) / 3GK zn4',''),
(22129,'Coordinate Reference System',5672,7314,'System 1942/15 (3)',''),
(22130,'Coordinate Reference System',5672,7302,'Pulkovo 42(58) / 3GK zn5',''),
(22132,'Coordinate Reference System',5631,7301,'Pulkovo 1942(58) / 6-degree Gauss-Kruger zone 2',''),
(22133,'Coordinate Reference System',5631,7301,'S-42 zone 2','This name is ambiguous as it is also used for several CRSs.'),
(22134,'Coordinate Reference System',5631,7302,'Pulkovo 42(58) / GK zn 2',''),
(22136,'Coordinate Reference System',5663,7314,'System 1942/15 (6)',''),
(22137,'Coordinate Reference System',5663,7301,'S-42 zone 3','This name is ambiguous as it is also used for several CRSs.'),
(22138,'Coordinate Reference System',5663,7301,'Pulkovo 1942(58) / 6-degree Gauss-Kruger zone 3',''),
(22139,'Coordinate Reference System',5663,7302,'Pulkovo 42(58) / GK zn 3',''),
(22141,'Coordinate Reference System',5673,7310,'Pulkovo 1942(83) / Gauss-Kruger zone 3',''),
(22142,'Coordinate Reference System',5673,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22143,'Coordinate Reference System',5673,7302,'Pulkovo 42(83) / 3GK zn3',''),
(22145,'Coordinate Reference System',5674,7310,'Pulkovo 1942(83) / Gauss-Kruger zone 4',''),
(22146,'Coordinate Reference System',5674,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22147,'Coordinate Reference System',5674,7302,'Pulkovo 42(83) / 3GK zn4',''),
(22149,'Coordinate Reference System',5675,7310,'Pulkovo 1942(83) / Gauss-Kruger zone 5',''),
(22150,'Coordinate Reference System',5675,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22151,'Coordinate Reference System',5675,7302,'Pulkovo 42(83) / 3GK zn5',''),
(22153,'Coordinate Reference System',5664,7301,'Pulkovo 1942(83) / 6-degree Gauss-Kruger zone 2',''),
(22154,'Coordinate Reference System',5664,7301,'S-42 zone 2','This name is ambiguous as it is also used for several CRSs.'),
(22155,'Coordinate Reference System',5664,7302,'Pulkovo 42(83) / GK zn 2',''),
(22157,'Coordinate Reference System',5665,7301,'Pulkovo 1942(83) / 6-degree Gauss-Kruger zone 3',''),
(22158,'Coordinate Reference System',5665,7302,'S-42 zone 3','This name is ambiguous as it is also used for several CRSs.'),
(22159,'Coordinate Reference System',5665,7302,'Pulkovo 42(83) / GK zn 3',''),
(22161,'Coordinate Reference System',5668,7301,'DHDN / Gauss-Kruger zone 4','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(22162,'Coordinate Reference System',5668,7307,'DE_RD/83 / GK_3','This EuroGeographics identifier is used for both of zones 4 and 5. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22163,'Coordinate Reference System',5668,7310,'RD/83 / Gauss-Kruger zone 4',''),
(22164,'Coordinate Reference System',5668,7302,'RD/83 / 3GK zone 4',''),
(22166,'Coordinate Reference System',5669,7301,'DHDN / Gauss-Kruger zone 5','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(22167,'Coordinate Reference System',5669,7307,'DE_RD/83 / GK_3','This EuroGeographics identifier is used for both of zones 4 and 5. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(22168,'Coordinate Reference System',5669,7310,'RD/83 / Gauss-Kruger zone 5',''),
(22169,'Coordinate Reference System',5669,7302,'RD/83 / 3GK zone 5',''),
(22411,'Coordinate_Operation',5823,7302,'UCS-2000 to WGS 84 (1)',''),
(22430,'Coordinate_Operation',5642,7302,'SPBA Lambert',''),
(22455,'Coordinate Reference System',5825,7301,'AGD66 / ACT SGC',''),
(22457,'Coordinate_Operation',5824,7302,'ACT Grid',''),
(22580,'Coordinate Reference System',5683,7302,'DB_REF / 3GK zone 3 E-N',''),
(22590,'Coordinate Reference System',5682,7302,'DB_REF / 3GK zone 2 E-N',''),
(22596,'Coordinate Reference System',5684,7302,'DB_REF / 3GK zone 4 E-N',''),
(22599,'Coordinate Reference System',5685,7302,'DB_REF / 3GK zone 5 E-N',''),
(22672,'Datum',1081,7302,'DB_REF',''),
(22744,'Coordinate Reference System',5836,7302,'Yemen NGN96 / UTM 37N',''),
(22747,'Coordinate Reference System',5837,7302,'Yemen NGN96 / UTM 40N',''),
(22863,'Coordinate_Operation',5838,7301,'Lisbon 1937 (Lisbon) to WGS 84 (2)',''),
(23255,'Coordinate Reference System',30791,1036,'Nord Sahara 1959 / Lambert Algerie Nord',''),
(23256,'Coordinate Reference System',30791,1036,'Nord Sahara 1959 / LAN',''),
(23258,'Coordinate Reference System',30792,1036,'Nord Sahara 1959 / Lambert Algerie Sud',''),
(23259,'Coordinate Reference System',30792,1036,'Nord Sahara 1959 / LAS',''),
(23268,'Coordinate Reference System',30791,7301,'Nord Sahara 1959 / Voirol Unifie Nord','Voirol Unifie 1960 is NOT a geodetic datum nor GeogCRS. It is two Lambert projected coordinate reference systems based on Nord Sahara 1959 Datum. See also CRS code 30792.'),
(23270,'Coordinate Reference System',30792,7301,'Nord Sahara 1959 / Voirol Unifie Sud','Voirol Unifie 1960 is NOT a geodetic datum nor GeogCRS. It is two Lambert projected coordinate reference systems based on Nord Sahara 1959 Datum. See also CRS code 30791.'),
(23294,'Coordinate Reference System',5659,7301,'Monte Mario / UTMRER',''),
(23300,'Coordinate_Operation',5658,7301,'UTMRER',''),
(23326,'Coordinate_Operation',5661,7301,'ED50 to ETRF89 (14)',''),
(24145,'Coordinate_Operation',5661,1032,'100800401','Code used by ICC for ED50 to ETRS89 NTv2 transformation.'),
(24146,'Coordinate_Operation',5661,1032,'800100401','Code used by ICC for ETRS89 to ED50 NTv2 transformation.'),
(24372,'Coordinate Reference System',5844,7302,'RGRDC 2005 / Congo TM 30',''),
(24973,'Datum',5113,7301,'Sea Level',''),
(25025,'Coordinate Reference System',5715,7301,'msl depth',''),
(25027,'Coordinate Reference System',5714,7301,'msl height',''),
(25122,'Coordinate Reference System',5868,7301,'Mean High Water height',''),
(25135,'Coordinate Reference System',5869,7301,'Mean Higher High Water height',''),
(25140,'Coordinate Reference System',5870,7301,'Mean High Water Spring Tides height',''),
(25143,'Coordinate Reference System',5871,7301,'Higher High Water Large Tide height',''),
(25146,'Coordinate Reference System',5872,7301,'Highest Astronomic Tide height',''),
(25199,'Datum',1084,7302,'HHWLT',''),
(25209,'Datum',1082,7302,'HAT',''),
(25211,'Datum',1085,7302,'ISLW',''),
(25212,'Datum',1085,7301,'Indian Tidal Plane',''),
(25225,'Datum',1083,7302,'LLWLT',''),
(25227,'Datum',1080,7302,'LAT',''),
(25229,'Datum',1090,7302,'MHHW',''),
(25233,'Datum',1092,7302,'MHW',''),
(25235,'Datum',1088,7302,'MHWS',''),
(25236,'Datum',1088,7301,'Spring High Water',''),
(25238,'Datum',1089,7302,'MLLW',''),
(25245,'Datum',1086,7302,'MLLWS',''),
(25249,'Datum',1091,7302,'MLW',''),
(25251,'Datum',1087,7302,'MLWS',''),
(25252,'Datum',1087,7301,'Spring Low Water',''),
(25306,'Coordinate Reference System',5829,7301,'sea level height',''),
(25314,'Coordinate Reference System',5865,7301,'Mean Low Water Spring Tides depth',''),
(25316,'Coordinate Reference System',5867,7301,'Mean Low Water depth',''),
(25318,'Coordinate Reference System',5864,7301,'Mean Lower Low Water Spring Tides depth',''),
(25320,'Coordinate Reference System',5866,7301,'Mean Lower Low Water depth',''),
(25322,'Coordinate Reference System',5831,7301,'sea level depth',''),
(25324,'Coordinate Reference System',5863,7301,'Indian Spring Low Water depth',''),
(25325,'Coordinate Reference System',5863,7301,'Indian Tidal Plane depth',''),
(25327,'Coordinate Reference System',5861,7301,'Lowest Astronomic Tide depth',''),
(25329,'Coordinate Reference System',5862,7301,'Lower Low Water Large Tide depth',''),
(25333,'Coordinate Reference System',5874,7301,'High Tide height',''),
(25339,'Datum',1093,7301,'Low tide',''),
(25341,'Coordinate Reference System',5873,7301,'Low Tide depth',''),
(25343,'Datum',1094,7301,'High Tide',''),
(25370,'Coordinate Reference System',5649,7310,'ETRS89 / UTM zone 31','This is the EPSG name for CRS code 25831.'),
(25371,'Coordinate Reference System',5649,7301,'ETRF89 / UTM zone 31N (zE-N)',''),
(25373,'Coordinate Reference System',5651,7310,'ETRS89 / UTM zone 31','This is the EPSG name for CRS code 25831.'),
(25374,'Coordinate Reference System',5651,7301,'ETRF89 / UTM zone 31N (N-zE)',''),
(25376,'Coordinate Reference System',5652,7301,'ETRF89 / UTM zone 32N (N-zE)',''),
(25377,'Coordinate Reference System',5652,7310,'ETRS89 / UTM zone 32N','This is the EPSG name for CRS code 25832.'),
(25380,'Coordinate Reference System',5650,7301,'ETRF89 / UTM zone 33N (zE-N)',''),
(25381,'Coordinate Reference System',5650,7310,'ETRS89 / UTM zone 33N','This is the EPSG name for CRS code 25833.'),
(25383,'Coordinate Reference System',5653,7301,'ETRF89 / UTM zone 33N (N-zE)',''),
(25384,'Coordinate Reference System',5653,7310,'ETRS89 / UTM zone 33N','This is the EPSG name for CRS code 25833.'),
(25411,'Coordinate Reference System',4839,7301,'ETRF89 / LCC Germany (N-E)',''),
(25452,'Coordinate_Operation',5878,7301,'Timbalai 1968 to GDBD2009 (1)',''),
(25453,'Coordinate_Operation',5878,7301,'BT68 to GDBD2009 (1)',''),
(25454,'Coordinate_Operation',5878,7301,'BT48 to GDBD2009 (1)',''),
(25496,'Coordinate Reference System',5879,7302,'Cadastre 1997 / UTM 38S',''),
(25575,'Coordinate_Operation',5883,7302,'TMG',''),
(25588,'Datum',1095,7302,'TGD2005',''),
(25635,'Coordinate Reference System',5887,7302,'TGD2005 / TMG',''),
(25639,'Coordinate_Operation',5889,7301,'JAXA Snow Depth PS north',''),
(25643,'Coordinate Reference System',5890,7302,'JAXA Snow Depth PS North',''),
(25877,'Coordinate_Operation',5906,7302,'EPSG Arctic A1',''),
(25879,'Coordinate_Operation',5907,7302,'EPSG Arctic A2',''),
(25881,'Coordinate_Operation',5908,7302,'EPSG Arctic A3',''),
(25883,'Coordinate_Operation',5909,7302,'EPSG Arctic A4',''),
(25885,'Coordinate_Operation',5910,7302,'EPSG Arctic A5',''),
(25887,'Coordinate_Operation',5911,7302,'EPSG Arctic B1',''),
(25889,'Coordinate_Operation',5912,7302,'EPSG Arctic B2',''),
(25891,'Coordinate_Operation',5913,7302,'EPSG Arctic B3',''),
(25893,'Coordinate_Operation',5905,7302,'EPSG Russia PS',''),
(25895,'Coordinate_Operation',5904,7302,'EPSG Norway PS',''),
(25897,'Coordinate_Operation',5903,7302,'EPSG Alaska PS',''),
(25903,'Coordinate_Operation',5916,7302,'EPSG Arctic C1',''),
(25905,'Coordinate_Operation',5914,7302,'EPSG Arctic B4',''),
(25979,'Coordinate Reference System',5932,7302,'WGS 84 / EPSG Arctic C2',''),
(25981,'Coordinate Reference System',5931,7302,'WGS 84 / EPSG Arctic C1',''),
(25984,'Coordinate Reference System',5933,7302,'WGS 84 / EPSG Arctic C3',''),
(25987,'Coordinate Reference System',5934,7302,'WGS 84 / EPSG Arctic C4',''),
(25990,'Coordinate Reference System',5935,7302,'WGS 84 / EPSG Arctic C5',''),
(25992,'Coordinate Reference System',5921,7302,'WGS 84 / EPSG Arctic A1',''),
(25994,'Coordinate Reference System',5922,7302,'WGS 84 / EPSG Arctic A2',''),
(25996,'Coordinate Reference System',5923,7302,'WGS 84 / EPSG Arctic A3',''),
(25998,'Coordinate Reference System',5924,7302,'WGS 84 / EPSG Arctic A4',''),
(26002,'Coordinate Reference System',5925,7302,'WGS 84 / EPSG Arctic A5',''),
(26004,'Coordinate Reference System',5926,7302,'WGS 84 / EPSG Arctic B1',''),
(26006,'Coordinate Reference System',5927,7302,'WGS 84 / EPSG Arctic B2',''),
(26010,'Coordinate Reference System',5928,7302,'WGS 84 / EPSG Arctic B3',''),
(26012,'Coordinate Reference System',5929,7302,'WGS 84 / EPSG Arctic B4',''),
(26027,'Coordinate_Operation',5901,7302,'EPSG Alaska PS',''),
(26029,'Coordinate_Operation',5902,7302,'EPSG Canada PS',''),
(26041,'Coordinate Reference System',5936,7302,'WGS 84 / EPSG Alaska PS',''),
(26046,'Coordinate Reference System',5937,7302,'WGS 84 / EPSG Canada PS',''),
(26049,'Coordinate Reference System',5938,7302,'WGS 84 / EPSG Greenland PS',''),
(26054,'Coordinate Reference System',5939,7302,'WGS 84 / EPSG Norway PS',''),
(26057,'Coordinate Reference System',5940,7302,'WGS 84 / EPSG Russia PS',''),
(26062,'Coordinate_Operation',5915,7302,'EPSG Arctic B5',''),
(26064,'Coordinate_Operation',5920,7302,'EPSG Arctic C5',''),
(26066,'Coordinate_Operation',5919,7302,'EPSG Arctic C4',''),
(26070,'Coordinate_Operation',5917,7302,'EPSG Arctic C2',''),
(26074,'Coordinate Reference System',5930,7302,'WGS 84 / EPSG Arctic B5',''),
(26180,'Coordinate Reference System',5945,7301,'ETRF89 / NTM zone 5 + NN2000 height',''),
(26181,'Coordinate Reference System',5945,7301,'EUREF89 / NTM zone 5 + NN2000 height',''),
(26186,'Coordinate Reference System',5946,7301,'ETRF89 / NTM zone 6 + NN2000 height',''),
(26187,'Coordinate Reference System',5946,7301,'EUREF89 / NTM zone 6 + NN2000 height',''),
(26191,'Coordinate Reference System',5947,7301,'ETRF89 / NTM zone 7 + NN2000 height',''),
(26192,'Coordinate Reference System',5947,7301,'EUREF89 / NTM zone 7 + NN2000 height',''),
(26201,'Coordinate Reference System',5949,7301,'ETRF89 / NTM zone 9 + NN2000 height',''),
(26202,'Coordinate Reference System',5949,7301,'EUREF89 / NTM zone 9 + NN2000 height',''),
(26206,'Coordinate Reference System',5950,7301,'ETRF89 / NTM zone 10 + NN2000 height',''),
(26207,'Coordinate Reference System',5950,7301,'EUREF89 / NTM zone 10 + NN2000 height',''),
(26211,'Coordinate Reference System',5951,7301,'ETRF89 / NTM zone 11 + NN2000 height',''),
(26212,'Coordinate Reference System',5951,7301,'EUREF89 / NTM zone 11 + NN2000 height',''),
(26216,'Coordinate Reference System',5952,7301,'ETRF89 / NTM zone 12 + NN2000 height',''),
(26217,'Coordinate Reference System',5952,7301,'EUREF89 / NTM zone 12 + NN2000 height',''),
(26221,'Coordinate Reference System',5953,7301,'ETRF89 / NTM zone 13 + NN2000 height',''),
(26222,'Coordinate Reference System',5953,7301,'EUREF89 / NTM zone 13 + NN2000 height',''),
(26226,'Coordinate Reference System',5954,7301,'ETRF89 / NTM zone 14 + NN2000 height',''),
(26227,'Coordinate Reference System',5954,7301,'EUREF89 / NTM zone 14 + NN2000 height',''),
(26231,'Coordinate Reference System',5955,7301,'ETRF89 / NTM zone 15 + NN2000 height',''),
(26232,'Coordinate Reference System',5955,7301,'EUREF89 / NTM zone 15 + NN2000 height',''),
(26236,'Coordinate Reference System',5956,7301,'ETRF89 / NTM zone 16 + NN2000 height',''),
(26237,'Coordinate Reference System',5956,7301,'EUREF89 / NTM zone 16 + NN2000 height',''),
(26241,'Coordinate Reference System',5957,7301,'ETRF89 / NTM zone 17 + NN2000 height',''),
(26242,'Coordinate Reference System',5957,7301,'EUREF89 / NTM zone 17 + NN2000 height',''),
(26246,'Coordinate Reference System',5958,7301,'ETRF89 / NTM zone 18 + NN2000 height',''),
(26247,'Coordinate Reference System',5958,7301,'EUREF89 / NTM zone 18 + NN2000 height',''),
(26251,'Coordinate Reference System',5959,7301,'ETRF89 / NTM zone 19 + NN2000 height',''),
(26252,'Coordinate Reference System',5959,7301,'EUREF89 / NTM zone 19 + NN2000 height',''),
(26256,'Coordinate Reference System',5960,7301,'ETRF89 / NTM zone 20 + NN2000 height',''),
(26257,'Coordinate Reference System',5960,7301,'EUREF89 / NTM zone 20 + NN2000 height',''),
(26261,'Coordinate Reference System',5961,7301,'ETRF89 / NTM zone 21 + NN2000 height',''),
(26262,'Coordinate Reference System',5961,7301,'EUREF89 / NTM zone 21 + NN2000 height',''),
(26266,'Coordinate Reference System',5962,7301,'ETRF89 / NTM zone 22 + NN2000 height',''),
(26267,'Coordinate Reference System',5962,7301,'EUREF89 / NTM zone 22 + NN2000 height',''),
(26271,'Coordinate Reference System',5963,7301,'ETRF89 / NTM zone 23 + NN2000 height',''),
(26272,'Coordinate Reference System',5963,7301,'EUREF89 / NTM zone 23 + NN2000 height',''),
(26276,'Coordinate Reference System',5964,7301,'ETRF89 / NTM zone 24 + NN2000 height',''),
(26277,'Coordinate Reference System',5964,7301,'EUREF89 / NTM zone 24 + NN2000 height',''),
(26281,'Coordinate Reference System',5965,7301,'ETRF89 / NTM zone 25 + NN2000 height',''),
(26282,'Coordinate Reference System',5965,7301,'EUREF89 / NTM zone 25 + NN2000 height',''),
(26291,'Coordinate Reference System',5967,7301,'ETRF89 / NTM zone 27 + NN2000 height',''),
(26292,'Coordinate Reference System',5967,7301,'EUREF89 / NTM zone 27 + NN2000 height',''),
(26294,'Coordinate Reference System',5966,7301,'ETRF89 / NTM zone 26 + NN2000 height',''),
(26295,'Coordinate Reference System',5966,7301,'EUREF89 / NTM zone 26 + NN2000 height',''),
(26299,'Coordinate Reference System',5968,7301,'ETRF89 / NTM zone 28 + NN2000 height',''),
(26300,'Coordinate Reference System',5968,7301,'EUREF89 / NTM zone 28 + NN2000 height',''),
(26304,'Coordinate Reference System',5969,7301,'ETRF89 / NTM zone 29 + NN2000 height',''),
(26305,'Coordinate Reference System',5969,7301,'EUREF89 / NTM zone 29 + NN2000 height',''),
(26309,'Coordinate Reference System',5970,7301,'ETRF89 / NTM zone 30 + NN2000 height',''),
(26310,'Coordinate Reference System',5970,7301,'EUREF89 / NTM zone 30 + NN2000 height',''),
(26330,'Coordinate Reference System',5973,7301,'ETRF89 / UTM zone 33 + NN2000 height',''),
(26331,'Coordinate Reference System',5973,7301,'EUREF89 / UTM zone 33 + NN2000 height',''),
(26341,'Coordinate Reference System',5975,7301,'ETRF89 / UTM zone 35 + NN2000 height',''),
(26342,'Coordinate Reference System',5975,7301,'EUREF89 / UTM zone 35 + NN2000 height',''),
(26344,'Coordinate Reference System',5974,7301,'ETRF89 / UTM zone 34 + NN2000 height',''),
(26345,'Coordinate Reference System',5974,7301,'EUREF89 / UTM zone 34 + NN2000 height',''),
(26349,'Coordinate Reference System',5976,7301,'ETRF89 / UTM zone 36 + NN2000 height',''),
(26350,'Coordinate Reference System',5976,7301,'EUREF89 / UTM zone 36 + NN2000 height',''),
(26381,'Coordinate Reference System',5972,7301,'ETRF89 / UTM zone 32 + NN2000 height',''),
(26382,'Coordinate Reference System',5972,7301,'EUREF89 / UTM zone 32 + NN2000 height',''),
(26387,'Coordinate Reference System',5971,7301,'ETRF89 / UTM zone 31 + NN2000 height',''),
(26388,'Coordinate Reference System',5971,7301,'EUREF89 / UTM zone 31 + NN2000 height',''),
(26731,'Datum',1098,7302,'LCVD61',''),
(26734,'Datum',1099,7302,'CBVD61',''),
(26736,'Datum',1097,7302,'GCVD54',''),
(26739,'Datum',6723,7302,'GCGD59',''),
(26742,'Datum',6726,7302,'SIGD61',''),
(26743,'Datum',6726,7301,'Little Cayman Geodetic Datum 1961','Name given by EPSG prior to January 2013. Not recognised locally.'),
(26746,'Datum',1100,7302,'CIGD11',''),
(26795,'Coordinate Reference System',6050,7302,'GR96 / EPSG Arctic 1-25',''),
(26801,'Coordinate Reference System',6051,7302,'GR96 / EPSG Arctic 2-18',''),
(26804,'Coordinate Reference System',6052,7302,'GR96 / EPSG Arctic 2-20',''),
(26807,'Coordinate Reference System',6053,7302,'GR96 / EPSG Arctic 3-29',''),
(26810,'Coordinate Reference System',6054,7302,'GR96 / EPSG Arctic 3-31',''),
(26813,'Coordinate Reference System',6055,7302,'GR96 / EPSG Arctic 3-33',''),
(26816,'Coordinate Reference System',6056,7302,'GR96 / EPSG Arctic 4-20',''),
(26825,'Coordinate Reference System',6059,7302,'GR96 / EPSG Arctic 5-41',''),
(26828,'Coordinate Reference System',6060,7302,'GR96 / EPSG Arctic 5-43',''),
(26831,'Coordinate Reference System',6061,7302,'GR96 / EPSG Arctic 5-45',''),
(26834,'Coordinate Reference System',6062,7302,'GR96 / EPSG Arctic 6-26',''),
(26837,'Coordinate Reference System',6063,7302,'GR96 / EPSG Arctic 6-28',''),
(26849,'Coordinate Reference System',6067,7302,'GR96 / EPSG Arctic 8-20',''),
(26852,'Coordinate Reference System',6068,7302,'GR96 / EPSG Arctic 8-22',''),
(26856,'Coordinate Reference System',6070,7302,'ETRS89 / EPSG Arctic 3-11',''),
(26857,'Coordinate Reference System',6070,7301,'EUREF89 / EPSG Arctic zone 3-11',''),
(26858,'Coordinate Reference System',6070,7301,'ETRF89 / EPSG Arctic zone 3-11',''),
(26864,'Coordinate Reference System',6071,7302,'ETRS89 / EPSG Arctic 4-26',''),
(26865,'Coordinate Reference System',6071,7301,'EUREF89 / EPSG Arctic zone 4-26',''),
(26866,'Coordinate Reference System',6071,7301,'ETRF89 / EPSG Arctic zone 4-26',''),
(26878,'Coordinate Reference System',6073,7302,'ETRS89 / EPSG Arctic 5-11',''),
(26879,'Coordinate Reference System',6073,7301,'EUREF89 / EPSG Arctic zone 5-11',''),
(26880,'Coordinate Reference System',6073,7301,'ETRF89 / EPSG Arctic zone 5-11',''),
(26885,'Coordinate Reference System',6074,7302,'ETRS89 / EPSG Arctic 5-13',''),
(26886,'Coordinate Reference System',6074,7301,'EUREF89 / EPSG Arctic zone 5-13',''),
(26887,'Coordinate Reference System',6074,7301,'ETRF89 / EPSG Arctic zone 5-13',''),
(26892,'Coordinate Reference System',6075,7302,'WGS 84 / EPSG Arctic 2-24',''),
(26895,'Coordinate Reference System',6076,7302,'WGS 84 / EPSG Arctic 2-26',''),
(26898,'Coordinate Reference System',6077,7302,'WGS 84 / EPSG Arctic 3-13',''),
(26901,'Coordinate Reference System',6078,7302,'WGS 84 / EPSG Arctic 3-15',''),
(26904,'Coordinate Reference System',6079,7302,'WGS 84 / EPSG Arctic 3-17',''),
(26909,'Coordinate Reference System',6069,7302,'ETRS89 / EPSG Arctic 2-22',''),
(26910,'Coordinate Reference System',6069,7301,'EUREF89 / EPSG Arctic zone 2-22',''),
(26911,'Coordinate Reference System',6069,7301,'ETRF89 / EPSG Arctic zone 2-22',''),
(26924,'Coordinate Reference System',6080,7302,'WGS 84 / EPSG Arctic 3-19',''),
(26949,'Coordinate Reference System',6087,7302,'WGS 84 / EPSG Arctic 5-15',''),
(26952,'Coordinate Reference System',6088,7302,'WGS 84 / EPSG Arctic 5-17',''),
(26955,'Coordinate Reference System',6089,7302,'WGS 84 / EPSG Arctic 5-19',''),
(26958,'Coordinate Reference System',6090,7302,'WGS 84 / EPSG Arctic 5-21',''),
(26961,'Coordinate Reference System',6091,7302,'WGS 84 / EPSG Arctic 5-23',''),
(26964,'Coordinate Reference System',6092,7302,'WGS 84 / EPSG Arctic 5-25',''),
(26968,'Coordinate Reference System',6093,7302,'WGS 84 / EPSG Arctic 5-27',''),
(26976,'Coordinate Reference System',6095,7302,'NAD83(NSRS2007) / EPSG Arctic 5-31',''),
(26979,'Coordinate Reference System',6096,7302,'NAD83(NSRS2007) / EPSG Arctic 6-14',''),
(26982,'Coordinate Reference System',6097,7302,'NAD83(NSRS2007) / EPSG Arctic 6-16',''),
(26988,'Coordinate Reference System',6098,7302,'NAD83(CSRS) / EPSG Arctic 1-23',''),
(26992,'Coordinate Reference System',6099,7302,'NAD83(CSRS) / EPSG Arctic 2-14',''),
(26995,'Coordinate Reference System',6100,7302,'NAD83(CSRS) / EPSG Arctic 2-16',''),
(26998,'Coordinate Reference System',6101,7302,'NAD83(CSRS) / EPSG Arctic 3-25',''),
(27001,'Coordinate Reference System',6102,7302,'NAD83(CSRS) / EPSG Arctic 3-27',''),
(27004,'Coordinate Reference System',6103,7302,'NAD83(CSRS) / EPSG Arctic 3-29',''),
(27011,'Coordinate Reference System',6105,7302,'NAD83(CSRS) / EPSG Arctic 4-16',''),
(27017,'Coordinate Reference System',6106,7302,'NAD83(CSRS) / EPSG Arctic 4-18',''),
(27021,'Coordinate Reference System',6107,7302,'NAD83(CSRS) / EPSG Arctic 5-33',''),
(27024,'Coordinate Reference System',6108,7302,'NAD83(CSRS) / EPSG Arctic 5-35',''),
(27027,'Coordinate Reference System',6109,7302,'NAD83(CSRS) / EPSG Arctic 5-37',''),
(27030,'Coordinate Reference System',6110,7302,'NAD83(CSRS) / EPSG Arctic 5-39',''),
(27034,'Coordinate Reference System',6111,7302,'NAD83(CSRS) / EPSG Arctic 6-18',''),
(27037,'Coordinate Reference System',6112,7302,'NAD83(CSRS) / EPSG Arctic 6-20',''),
(27040,'Coordinate Reference System',6113,7302,'NAD83(CSRS) / EPSG Arctic 6-22',''),
(27043,'Coordinate Reference System',6114,7302,'NAD83(CSRS) / EPSG Arctic 6-24',''),
(27048,'Coordinate Reference System',6115,7302,'WGS 84 / EPSG Arctic 1-27',''),
(27051,'Coordinate Reference System',6116,7302,'WGS 84 / EPSG Arctic 1-29',''),
(27054,'Coordinate Reference System',6117,7302,'WGS 84 / EPSG Arctic 1-31',''),
(27057,'Coordinate Reference System',6118,7302,'WGS 84 / EPSG Arctic 1-21',''),
(27060,'Coordinate Reference System',6119,7302,'WGS 84 / EPSG Arctic 2-28',''),
(27093,'Coordinate Reference System',6121,7302,'WGS 84 / EPSG Arctic 2-12',''),
(27100,'Coordinate Reference System',6120,7302,'WGS 84 / EPSG Arctic 2-10',''),
(27109,'Coordinate Reference System',6122,7302,'WGS 84 / EPSG Arctic 3-21',''),
(27113,'Coordinate Reference System',6123,7302,'WGS 84 / EPSG Arctic 3-23',''),
(27165,'Coordinate_Operation',16304,7301,'6-degree Gauss-Kruger CM 21E',''),
(27171,'Coordinate Reference System',6064,7302,'GR96 / EPSG Arctic 6-30',''),
(27179,'Coordinate Reference System',6065,7302,'GR96 / EPSG Arctic 7-11',''),
(27181,'Coordinate Reference System',6066,7302,'GR96 / EPSG Arctic 7-13',''),
(27242,'Coordinate Reference System',6128,7302,'GCNG59',''),
(27248,'Coordinate Reference System',6129,7302,'SING61',''),
(27297,'Coordinate_Operation',5918,7302,'EPSG Arctic C3',''),
(27305,'Coordinate Reference System',6086,7302,'WGS 84 / EPSG Arctic 4-40',''),
(27307,'Coordinate Reference System',6085,7302,'WGS 84 / EPSG Arctic 4-38',''),
(27309,'Coordinate Reference System',6084,7302,'WGS 84 / EPSG Arctic 4-36',''),
(27311,'Coordinate Reference System',6083,7302,'WGS 84 / EPSG Arctic 4-34',''),
(27313,'Coordinate Reference System',6082,7302,'WGS 84 / EPSG Arctic 4-32',''),
(27315,'Coordinate Reference System',6081,7302,'WGS 84 / EPSG Arctic 4-30',''),
(27321,'Coordinate Reference System',6124,7302,'WGS 84 / EPSG Arctic 4-12',''),
(27334,'Coordinate Reference System',5948,7301,'ETRF89 / NTM zone 8 + NN2000 height',''),
(27336,'Coordinate Reference System',5948,7301,'EUREF89 / NTM zone 8 + NN2000 height',''),
(27340,'Datum',1096,7302,'NN2000',''),
(27344,'Coordinate Reference System',6125,7301,'ETRF89 / EPSG Arctic zone 5-47',''),
(27345,'Coordinate Reference System',6125,7302,'ETRS89 / EPSG Arctic 5-47',''),
(27346,'Coordinate Reference System',6125,7301,'EUREF89 / EPSG Arctic zone 5-47',''),
(27349,'Coordinate Reference System',6072,7302,'ETRS89 / EPSG Arctic 4-28',''),
(27350,'Coordinate Reference System',6072,7301,'EUREF89 / EPSG Arctic zone 4-28',''),
(27351,'Coordinate Reference System',6072,7301,'ETRF89 / EPSG Arctic zone 4-28',''),
(27355,'Coordinate Reference System',6104,7302,'NAD83(CSRS) / EPSG Arctic 4-14',''),
(27364,'Coordinate_Operation',5977,7302,'EPSG Arctic 1-21',''),
(27366,'Coordinate_Operation',5978,7302,'EPSG Arctic 1-23',''),
(27368,'Coordinate_Operation',5979,7302,'EPSG Arctic 1-25',''),
(27370,'Coordinate_Operation',5980,7302,'EPSG Arctic 1-27',''),
(27372,'Coordinate_Operation',5981,7302,'EPSG Arctic 1-29',''),
(27374,'Coordinate_Operation',5982,7302,'EPSG Arctic 1-31',''),
(27376,'Coordinate_Operation',5983,7302,'EPSG Arctic 2-10',''),
(27378,'Coordinate_Operation',5984,7302,'EPSG Arctic 2-12',''),
(27380,'Coordinate_Operation',5985,7302,'EPSG Arctic 2-14',''),
(27382,'Coordinate_Operation',5986,7302,'EPSG Arctic 2-16',''),
(27384,'Coordinate_Operation',5987,7302,'EPSG Arctic 2-18',''),
(27386,'Coordinate_Operation',5988,7302,'EPSG Arctic 2-20',''),
(27388,'Coordinate_Operation',5989,7302,'EPSG Arctic 2-22',''),
(27390,'Coordinate_Operation',5990,7302,'EPSG Arctic 2-24',''),
(27392,'Coordinate_Operation',5991,7302,'EPSG Arctic 2-26',''),
(27394,'Coordinate_Operation',5992,7302,'EPSG Arctic 2-28',''),
(27396,'Coordinate_Operation',5993,7302,'EPSG Arctic 3-11',''),
(27398,'Coordinate_Operation',5994,7302,'EPSG Arctic 3-13',''),
(27400,'Coordinate_Operation',5995,7302,'EPSG Arctic 3-15',''),
(27402,'Coordinate_Operation',5996,7302,'EPSG Arctic 3-17',''),
(27404,'Coordinate_Operation',5997,7302,'EPSG Arctic 3-19',''),
(27406,'Coordinate_Operation',5998,7302,'EPSG Arctic 3-21',''),
(27408,'Coordinate_Operation',5999,7302,'EPSG Arctic 3-23',''),
(27410,'Coordinate_Operation',6000,7302,'EPSG Arctic 3-25',''),
(27412,'Coordinate_Operation',6001,7302,'EPSG Arctic 3-27',''),
(27416,'Coordinate_Operation',6002,7302,'EPSG Arctic 3-29',''),
(27418,'Coordinate_Operation',6003,7302,'EPSG Arctic 3-31',''),
(27420,'Coordinate_Operation',6004,7302,'EPSG Arctic 3-33',''),
(27422,'Coordinate_Operation',6005,7302,'EPSG Arctic 4-12',''),
(27424,'Coordinate_Operation',6006,7302,'EPSG Arctic 4-14',''),
(27426,'Coordinate_Operation',6007,7302,'EPSG Arctic 4-16',''),
(27428,'Coordinate_Operation',6008,7302,'EPSG Arctic 4-18',''),
(27430,'Coordinate_Operation',6009,7302,'EPSG Arctic 4-20',''),
(27432,'Coordinate_Operation',6010,7302,'EPSG Arctic 4-22',''),
(27436,'Coordinate_Operation',6011,7302,'EPSG Arctic 4-24',''),
(27438,'Coordinate_Operation',6012,7302,'EPSG Arctic 4-26',''),
(27442,'Coordinate_Operation',6013,7302,'EPSG Arctic 4-28',''),
(27446,'Coordinate_Operation',6014,7302,'EPSG Arctic 4-30',''),
(27448,'Coordinate_Operation',6015,7302,'EPSG Arctic 4-32',''),
(27454,'Coordinate_Operation',6016,7302,'EPSG Arctic 4-34',''),
(27456,'Coordinate_Operation',6017,7302,'EPSG Arctic 4-36',''),
(27458,'Coordinate_Operation',6018,7302,'EPSG Arctic 4-38',''),
(27460,'Coordinate_Operation',6019,7302,'EPSG Arctic 4-40',''),
(27462,'Coordinate_Operation',6020,7302,'EPSG Arctic 5-11',''),
(27464,'Coordinate_Operation',6021,7302,'EPSG Arctic 5-13',''),
(27472,'Coordinate_Operation',5944,7302,'EPSG Arctic 8-22',''),
(27474,'Coordinate_Operation',6022,7302,'EPSG Arctic 5-15',''),
(27476,'Coordinate_Operation',6023,7302,'EPSG Arctic 5-17',''),
(27478,'Coordinate_Operation',6024,7302,'EPSG Arctic 5-19',''),
(27480,'Coordinate_Operation',6025,7302,'EPSG Arctic 5-21',''),
(27484,'Coordinate_Operation',6026,7302,'EPSG Arctic 5-23',''),
(27486,'Coordinate_Operation',6027,7302,'EPSG Arctic 5-25',''),
(27488,'Coordinate_Operation',6028,7302,'EPSG Arctic 5-27',''),
(27496,'Coordinate_Operation',6030,7302,'EPSG Arctic 5-31',''),
(27498,'Coordinate_Operation',6031,7302,'EPSG Arctic 5-33',''),
(27500,'Coordinate_Operation',6032,7302,'EPSG Arctic 5-35',''),
(27504,'Coordinate_Operation',6033,7302,'EPSG Arctic 5-37',''),
(27506,'Coordinate_Operation',6034,7302,'EPSG Arctic 5-39',''),
(27508,'Coordinate_Operation',6035,7302,'EPSG Arctic 5-41',''),
(27512,'Coordinate_Operation',6036,7302,'EPSG Arctic 5-43',''),
(27514,'Coordinate_Operation',6037,7302,'EPSG Arctic 5-45',''),
(27516,'Coordinate_Operation',6038,7302,'EPSG Arctic 5-47',''),
(27518,'Coordinate_Operation',6039,7302,'EPSG Arctic 6-14',''),
(27520,'Coordinate_Operation',6040,7302,'EPSG Arctic 6-16',''),
(27522,'Coordinate_Operation',6041,7302,'EPSG Arctic 6-18',''),
(27524,'Coordinate_Operation',6042,7302,'EPSG Arctic 6-20',''),
(27526,'Coordinate_Operation',6043,7302,'EPSG Arctic 6-22',''),
(27528,'Coordinate_Operation',6044,7302,'EPSG Arctic 6-24',''),
(27530,'Coordinate_Operation',6045,7302,'EPSG Arctic 6-26',''),
(27534,'Coordinate_Operation',6046,7302,'EPSG Arctic 6-28',''),
(27536,'Coordinate_Operation',6047,7302,'EPSG Arctic 6-30',''),
(27543,'Coordinate_Operation',6126,7302,'CI LCC (ft)',''),
(27545,'Coordinate_Operation',6127,7302,'CI TM (ft)',''),
(27549,'Coordinate Reference System',6141,7302,'CING11',''),
(27554,'Coordinate Reference System',4723,7301,'Grand Cayman 1959','Name given by EPSG prior to January 2013.'),
(27556,'Coordinate Reference System',4726,7301,'Little Cayman 1961','Name given by EPSG prior to January 2013. Not recognised locally.'),
(27560,'Datum',6723,7301,'Grand Cayman 1959',''),
(27576,'Coordinate_Operation',15814,7301,'Little Cayman 1961 to WGS 84 (1)','Name given by EPSG prior to January 2013. Not recognised locally.'),
(27581,'Coordinate_Operation',15829,7301,'Little Cayman 1961 to WGS 84 (2)','Name given by EPSG prior to January 2013. Not recognised locally.'),
(27583,'Coordinate_Operation',15830,7301,'Grand Cayman 1959 to WGS 84 (1)','Name given by EPSG prior to January 2013.'),
(27607,'Coordinate Reference System',5942,7301,'ETRF89 + NN2000 height',''),
(27608,'Coordinate Reference System',5942,7301,'EUREF89 + NN2000 height',''),
(27618,'Coordinate Reference System',6147,7301,'ETRF89 / NTM zone 7 + NN54 height',''),
(27619,'Coordinate Reference System',6147,7301,'EUREF89 / NTM zone 7 + NN54 height',''),
(27769,'Coordinate Reference System',6148,7301,'ETRF89 / NTM zone 8 + NN54 height',''),
(27770,'Coordinate Reference System',6148,7301,'EUREF89 / NTM zone 8 + NN54 height',''),
(27772,'Coordinate Reference System',6149,7301,'ETRF89 / NTM zone 9 + NN54 height',''),
(27773,'Coordinate Reference System',6149,7301,'EUREF89 / NTM zone 9 + NN54 height',''),
(27775,'Coordinate Reference System',6146,7301,'ETRF89 / NTM zone 6 + NN54 height',''),
(27776,'Coordinate Reference System',6146,7301,'EUREF89 / NTM zone 6 + NN54 height',''),
(27778,'Coordinate Reference System',6145,7301,'ETRF89 / NTM zone 5 + NN54 height',''),
(27779,'Coordinate Reference System',6145,7301,'EUREF89 / NTM zone 5 + NN54 height',''),
(27781,'Coordinate Reference System',6170,7301,'ETRF89 / NTM zone 30 + NN54 height',''),
(27782,'Coordinate Reference System',6170,7301,'EUREF89 / NTM zone 30 + NN54 height',''),
(27784,'Coordinate Reference System',6169,7301,'ETRF89 / NTM zone 29 + NN54 height',''),
(27785,'Coordinate Reference System',6169,7301,'EUREF89 / NTM zone 29 + NN54 height',''),
(27787,'Coordinate Reference System',6168,7301,'ETRF89 / NTM zone 28 + NN54 height',''),
(27788,'Coordinate Reference System',6168,7301,'EUREF89 / NTM zone 28 + NN54 height',''),
(27790,'Coordinate Reference System',6167,7301,'ETRF89 / NTM zone 27 + NN54 height',''),
(27791,'Coordinate Reference System',6167,7301,'EUREF89 / NTM zone 27 + NN54 height',''),
(27793,'Coordinate Reference System',6166,7301,'ETRF89 / NTM zone 26 + NN54 height',''),
(27794,'Coordinate Reference System',6166,7301,'EUREF89 / NTM zone 26 + NN54 height',''),
(27796,'Coordinate Reference System',6165,7301,'ETRF89 / NTM zone 25 + NN54 height',''),
(27797,'Coordinate Reference System',6165,7301,'EUREF89 / NTM zone 25 + NN54 height',''),
(27799,'Coordinate Reference System',6164,7301,'ETRF89 / NTM zone 24 + NN54 height',''),
(27800,'Coordinate Reference System',6164,7301,'EUREF89 / NTM zone 24 + NN54 height',''),
(27802,'Coordinate Reference System',6163,7301,'ETRF89 / NTM zone 23 + NN54 height',''),
(27803,'Coordinate Reference System',6163,7301,'EUREF89 / NTM zone 23 + NN54 height',''),
(27805,'Coordinate Reference System',6162,7301,'ETRF89 / NTM zone 22 + NN54 height',''),
(27806,'Coordinate Reference System',6162,7301,'EUREF89 / NTM zone 22 + NN54 height',''),
(27808,'Coordinate Reference System',6161,7301,'ETRF89 / NTM zone 21 + NN54 height',''),
(27809,'Coordinate Reference System',6161,7301,'EUREF89 / NTM zone 21 + NN54 height',''),
(27811,'Coordinate Reference System',6160,7301,'ETRF89 / NTM zone 20 + NN54 height',''),
(27812,'Coordinate Reference System',6160,7301,'EUREF89 / NTM zone 20 + NN54 height',''),
(27814,'Coordinate Reference System',6159,7301,'ETRF89 / NTM zone 19 + NN54 height',''),
(27815,'Coordinate Reference System',6159,7301,'EUREF89 / NTM zone 19 + NN54 height',''),
(27817,'Coordinate Reference System',6158,7301,'ETRF89 / NTM zone 18 + NN54 height',''),
(27818,'Coordinate Reference System',6158,7301,'EUREF89 / NTM zone 18 + NN54 height',''),
(27820,'Coordinate Reference System',6157,7301,'ETRF89 / NTM zone 17 + NN54 height',''),
(27821,'Coordinate Reference System',6157,7301,'EUREF89 / NTM zone 17 + NN54 height',''),
(27823,'Coordinate Reference System',6156,7301,'ETRF89 / NTM zone 16 + NN54 height',''),
(27824,'Coordinate Reference System',6156,7301,'EUREF89 / NTM zone 16 + NN54 height',''),
(27826,'Coordinate Reference System',6155,7301,'ETRF89 / NTM zone 15 + NN54 height',''),
(27827,'Coordinate Reference System',6155,7301,'EUREF89 / NTM zone 15 + NN54 height',''),
(27829,'Coordinate Reference System',6154,7301,'ETRF89 / NTM zone 14 + NN54 height',''),
(27830,'Coordinate Reference System',6154,7301,'EUREF89 / NTM zone 14 + NN54 height',''),
(27832,'Coordinate Reference System',6153,7301,'ETRF89 / NTM zone 13 + NN54 height',''),
(27833,'Coordinate Reference System',6153,7301,'EUREF89 / NTM zone 13 + NN54 height',''),
(27835,'Coordinate Reference System',6152,7301,'ETRF89 / NTM zone 12 + NN54 height',''),
(27836,'Coordinate Reference System',6152,7301,'EUREF89 / NTM zone 12 + NN54 height',''),
(27838,'Coordinate Reference System',6151,7301,'ETRF89 / NTM zone 11 + NN54 height',''),
(27839,'Coordinate Reference System',6151,7301,'EUREF89 / NTM zone 11 + NN54 height',''),
(27841,'Coordinate Reference System',6150,7301,'ETRF89 / NTM zone 10 + NN54 height',''),
(27842,'Coordinate Reference System',6150,7301,'EUREF89 / NTM zone 10 + NN54 height',''),
(27844,'Coordinate Reference System',6171,7301,'ETRF89 / UTM zone 31 + NN54 height',''),
(27845,'Coordinate Reference System',6171,7301,'EUREF89 / UTM zone 31 + NN54 height',''),
(27847,'Coordinate Reference System',6172,7301,'ETRF89 / UTM zone 32 + NN54 height',''),
(27848,'Coordinate Reference System',6172,7301,'EUREF89 / UTM zone 32 + NN54 height',''),
(27850,'Coordinate Reference System',6173,7301,'ETRF89 / UTM zone 33 + NN54 height',''),
(27851,'Coordinate Reference System',6173,7301,'EUREF89 / UTM zone 33 + NN54 height',''),
(27853,'Coordinate Reference System',6174,7301,'ETRF89 / UTM zone 34 + NN54 height',''),
(27854,'Coordinate Reference System',6174,7301,'EUREF89 / UTM zone 34 + NN54 height',''),
(27856,'Coordinate Reference System',6175,7301,'ETRF89 / UTM zone 35 + NN54 height',''),
(27857,'Coordinate Reference System',6175,7301,'EUREF89 / UTM zone 35 + NN54 height',''),
(27859,'Coordinate Reference System',6176,7301,'ETRF89 / UTM zone 36 + NN54 height',''),
(27860,'Coordinate Reference System',6176,7301,'EUREF89 / UTM zone 36 + NN54 height',''),
(27862,'Coordinate Reference System',6144,7301,'ETRF89 + NN54 height',''),
(27863,'Coordinate Reference System',6144,7301,'EUREF89 + NN54 height',''),
(28001,'Coordinate Reference System',5710,7307,'BE_OOST / UNCOR',''),
(28005,'Datum',5110,7301,'Oostende',''),
(28008,'Coordinate Reference System',5710,7301,'Oostende height',''),
(28021,'Coordinate_Operation',5943,7302,'EPSG Arctic 8-20',''),
(28023,'Coordinate Reference System',6057,7302,'GR96 / EPSG Arctic 4-22',''),
(28025,'Coordinate Reference System',6058,7302,'GR96 / EPSG Arctic 4-24',''),
(28046,'Coordinate_Operation',6029,7302,'EPSG Arctic 5-29',''),
(28048,'Coordinate Reference System',6094,7302,'NAD83(NSRS2007) / EPSG Arctic 5-29',''),
(28050,'Coordinate_Operation',6048,7302,'EPSG Arctic 7-11',''),
(28052,'Coordinate_Operation',6049,7302,'EPSG Arctic 7-13',''),
(28104,'Coordinate_Operation',6188,7301,'Lisbon 1937 to ETRS89 (4)',''),
(28105,'Coordinate_Operation',6188,7301,'Lisbon to ETRF89 (2)',''),
(28106,'Coordinate_Operation',6188,7302,'DLx to ETRS89 (4)',''),
(28108,'Coordinate_Operation',6189,7302,'D73 to ETRS89(6)',''),
(28109,'Coordinate_Operation',6189,7301,'Datum 73 to ETRF89 (6)',''),
(28144,'Coordinate_Operation Parameter',1038,7302,'K',''),
(28183,'Coordinate_Operation',6198,7302,'Michigan Central','This alias is ambiguous as also used for SPCS83 projection.'),
(28185,'Coordinate_Operation',6197,7302,'Michigan North','This alias is ambiguous as also used for SPCS83 projection.'),
(28187,'Coordinate_Operation',6199,7302,'Michigan South','This alias is ambiguous as also used for SPCS83 projection.'),
(28262,'Coordinate Reference System',6210,7302,'SIRGAS 2000 / UTM 23N',''),
(28264,'Coordinate Reference System',6211,7302,'SIRGAS 2000 / UTM 24N',''),
(28358,'Coordinate Reference System',6244,7302,'MAGNA-SIRGAS / Arauca',''),
(28361,'Coordinate Reference System',6245,7302,'MAGNA-SIRGAS / Armenia',''),
(28367,'Coordinate Reference System',6247,7302,'MAGNA-SIRGAS / Bogota DC',''),
(28370,'Coordinate Reference System',6248,7302,'MAGNA-SIRGAS / Bucaramanga',''),
(28379,'Coordinate Reference System',6251,7302,'MAGNA-SIRGAS / Cucuta',''),
(28381,'Coordinate Reference System',6250,7302,'MAGNA-SIRGAS / Cartagena',''),
(28384,'Coordinate Reference System',6252,7302,'MAGNA-SIRGAS / Florencia',''),
(28387,'Coordinate Reference System',6253,7302,'MAGNA-SIRGAS / Ibague',''),
(28390,'Coordinate Reference System',6254,7302,'MAGNA-SIRGAS / Inirida',''),
(28393,'Coordinate Reference System',6255,7302,'MAGNA-SIRGAS / Leticia',''),
(28396,'Coordinate Reference System',6256,7302,'MAGNA-SIRGAS / Manizales',''),
(28399,'Coordinate Reference System',6257,7302,'MAGNA-SIRGAS / Medellin',''),
(28402,'Coordinate Reference System',6258,7302,'MAGNA-SIRGAS / Mitu',''),
(28405,'Coordinate Reference System',6259,7302,'MAGNA-SIRGAS / Mocoa',''),
(28408,'Coordinate Reference System',6260,7302,'MAGNA-SIRGAS / Monteria',''),
(28411,'Coordinate Reference System',6261,7302,'MAGNA-SIRGAS / Neiva',''),
(28414,'Coordinate Reference System',6262,7302,'MAGNA-SIRGAS / Pasto',''),
(28417,'Coordinate Reference System',6263,7302,'MAGNA-SIRGAS / Pereira',''),
(28420,'Coordinate Reference System',6264,7302,'MAGNA-SIRGAS / Popayan',''),
(28423,'Coordinate Reference System',6265,7302,'MAGNA-SIRGAS / Puerto Carreno',''),
(28426,'Coordinate Reference System',6266,7302,'MAGNA-SIRGAS / Quibdo',''),
(28429,'Coordinate Reference System',6267,7302,'MAGNA-SIRGAS / Riohacha',''),
(28432,'Coordinate Reference System',6268,7302,'MAGNA-SIRGAS / San Andres',''),
(28435,'Coordinate Reference System',6269,7302,'MAGNA-SIRGAS / San Jose',''),
(28438,'Coordinate Reference System',6270,7302,'MAGNA-SIRGAS / Santa Marta',''),
(28441,'Coordinate Reference System',6271,7302,'MAGNA-SIRGAS / Sucre',''),
(28444,'Coordinate Reference System',6272,7302,'MAGNA-SIRGAS / Tunja',''),
(28447,'Coordinate Reference System',6273,7302,'MAGNA-SIRGAS / Valledupar',''),
(28450,'Coordinate Reference System',6274,7302,'MAGNA-SIRGAS / Villavicencio',''),
(28453,'Coordinate Reference System',6275,7302,'MAGNA-SIRGAS / Yopal',''),
(28458,'Coordinate Reference System',6249,7302,'MAGNA-SIRGAS / Cali',''),
(28461,'Coordinate Reference System',6246,7302,'MAGNA-SIRGAS / Barranquilla',''),
(28502,'Coordinate_Operation Parameter',8605,7302,'tX',''),
(28505,'Coordinate_Operation Parameter',8606,7302,'tY',''),
(28508,'Coordinate_Operation Parameter',8607,7302,'tZ',''),
(28510,'Coordinate_Operation Parameter',8608,7302,'rX',''),
(28512,'Coordinate_Operation Parameter',8609,7302,'rY',''),
(28515,'Coordinate_Operation Parameter',8610,7302,'rZ',''),
(28517,'Coordinate_Operation Parameter',8611,7302,'dS',''),
(29161,'Unit of Measure',1040,1041,'s',''),
(29186,'Unit of Measure',1026,7300,'meters per second','Spelling used in US.'),
(29189,'Unit of Measure',1035,1041,'rad/s',''),
(29217,'Unit of Measure',1028,7302,'ppb',''),
(29218,'Unit of Measure',1028,7301,'nm/m',''),
(29228,'Unit of Measure',9202,7301,'m/m',''),
(29265,'Unit of Measure',1043,7301,'sec/yr',''),
(29267,'Unit of Measure',1043,7302,'sec/a',''),
(29269,'Unit of Measure',1034,7300,'centimeters per year','Spelling used in US'),
(29270,'Unit of Measure',1034,7301,'cm/yr',''),
(29271,'Unit of Measure',1034,7302,'cm/a',''),
(29276,'Unit of Measure',1042,7300,'meters per year','Spelling used in US'),
(29277,'Unit of Measure',1042,7302,'m/a',''),
(29278,'Unit of Measure',1042,7301,'m/yr',''),
(29280,'Unit of Measure',1031,7302,'msec',''),
(29281,'Unit of Measure',1031,7301,'mas',''),
(29283,'Unit of Measure',1032,7301,'msec/yr',''),
(29284,'Unit of Measure',1032,7301,'mas/yr',''),
(29285,'Unit of Measure',1032,7302,'msec/a',''),
(29290,'Unit of Measure',1027,7300,'millimeters per year','Spelling used in US'),
(29291,'Unit of Measure',1027,7302,'mm/a',''),
(29292,'Unit of Measure',1027,7301,'mm/yr',''),
(29301,'Unit of Measure',1030,7302,'ppb/a',''),
(29302,'Unit of Measure',1030,7301,'nm/m/a',''),
(29303,'Unit of Measure',1030,7301,'ppb/yr',''),
(29309,'Unit of Measure',1041,7302,'ppm/a',''),
(29310,'Unit of Measure',1041,7301,'ppm/yr',''),
(29311,'Unit of Measure',1041,7301,'m/m/a',''),
(29391,'Unit of Measure',1033,1041,'cm',''),
(29392,'Unit of Measure',1033,7300,'centimeter','Spelling used in US.'),
(29412,'Unit of Measure',1025,1041,'mm',''),
(29413,'Unit of Measure',1025,7300,'millimeter','Spelling used in US.'),
(29422,'Coordinate_Operation',6205,7301,'MSCS to ETRS89 (5)',''),
(29426,'Coordinate_Operation',6206,7301,'MSCS to WGS 84 (10)',''),
(29430,'Coordinate Reference System',6204,7301,'MGI 1901 / Macedonia GK',''),
(29431,'Coordinate Reference System',6204,7301,'MGI 1901 / Macedonia Gauss-Kruger',''),
(29432,'Coordinate Reference System',6204,7302,'MSCS',''),
(29434,'Coordinate Reference System',6316,7301,'Macedonia State Coordinate System','This is the name of a system with different easting values.'),
(29435,'Coordinate Reference System',6316,7302,'MSCS zone 7',''),
(29530,'Datum',1116,7302,'NAD83(2011)',''),
(29537,'Datum',1117,7302,'NAD83(PA11)',''),
(29615,'Coordinate Reference System',6351,7302,'NAD83(2011) / EPSG Arctic 5-29',''),
(29618,'Coordinate Reference System',6352,7302,'NAD83(2011) / EPSG Arctic 5-31',''),
(29621,'Coordinate Reference System',6353,7302,'NAD83(2011) / EPSG Arctic 6-14',''),
(29624,'Coordinate Reference System',6354,7302,'NAD83(2011) / EPSG Arctic 6-16',''),
(29627,'Datum',1118,7302,'NAD83(MA11)',''),
(29719,'Coordinate_Operation Parameter',1046,7302,'d(dS)',''),
(29721,'Coordinate_Operation Parameter',1041,7302,'d(tY)',''),
(29723,'Coordinate_Operation Parameter',1045,7302,'d(rZ)',''),
(29739,'Coordinate_Operation Parameter',1042,7302,'d(tZ)',''),
(29743,'Coordinate_Operation Parameter',1043,7302,'d(rX)',''),
(29750,'Coordinate_Operation Parameter',1040,7302,'d(tX)',''),
(29757,'Coordinate_Operation Parameter',1044,7302,'d(rY)',''),
(29803,'Coordinate_Operation Method',1056,7301,'Time-dependent Coordinate Frame rotation (geocentric domain)',''),
(29805,'Coordinate_Operation Method',1057,7301,'Time-dependent Coordinate Frame rotation (geog2D domain)',''),
(29807,'Coordinate_Operation Method',1058,7301,'Time-dependent Coordinate Frame rotation (geog3D domain)',''),
(29809,'Coordinate_Operation Method',1053,7301,'Time-dependent Position Vector transformation (geocentric domain)',''),
(29811,'Coordinate_Operation Method',1054,7301,'Time-dependent Position Vector transformation (geog2D domain)',''),
(29813,'Coordinate_Operation Method',1055,7301,'Time-dependent Position Vector transformation (geog3D domain)',''),
(29856,'Coordinate Reference System',6357,7301,'North American Vertical Datum of 1988 depth (m)',''),
(29870,'Coordinate Reference System',6359,7301,'National Geodetic Vertical Datum of 1929 depth (ftUS)',''),
(29881,'Coordinate Reference System',6360,7301,'North American Vertical Datum of 1988 height (ftUS)',''),
(29885,'Coordinate Reference System',6358,7301,'North American Vertical Datum of 1988 depth (ftUS)',''),
(29900,'Datum',1042,7301,'Mexican Datum of 1993','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29902,'Coordinate Reference System',4481,7301,'Mexican Datum of 1993','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29904,'Coordinate Reference System',4482,7301,'Mexican Datum of 1993','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29907,'Coordinate Reference System',4483,7301,'Mexican Datum of 1993','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29912,'Coordinate Reference System',4484,7301,'Mexican Datum of 1993 / UTM zone 11N','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29915,'Coordinate Reference System',4485,7301,'Mexican Datum of 1993 / UTM zone 12N','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29919,'Coordinate Reference System',4486,7301,'Mexican Datum of 1993 / UTM zone 13N','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29922,'Coordinate Reference System',4487,7301,'Mexican Datum of 1993 / UTM zone 14N','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29928,'Coordinate Reference System',4489,7301,'Mexican Datum of 1993 / UTM zone 16N','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29931,'Coordinate Reference System',4488,7301,'Mexican Datum of 1993 / UTM zone 15N','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(29986,'Coordinate Reference System',6365,1028,'Red Geodesica Nacional ITRF2008',''),
(30068,'Coordinate Reference System',6371,1028,'Red Geodesica Nacional ITRF2008 / UTM 16N',''),
(30069,'Coordinate Reference System',6371,7302,'Mexico 2008 / UTM 16N',''),
(30071,'Coordinate Reference System',6370,7302,'Mexico 2008 / UTM 15N',''),
(30072,'Coordinate Reference System',6370,1028,'Red Geodesica Nacional ITRF2008 / UTM 15N',''),
(30074,'Coordinate Reference System',6369,7302,'Mexico 2008 / UTM 14N',''),
(30075,'Coordinate Reference System',6369,1028,'Red Geodesica Nacional ITRF2008 / UTM 14N',''),
(30077,'Coordinate Reference System',6368,7302,'Mexico 2008 / UTM 13N',''),
(30078,'Coordinate Reference System',6368,1028,'Red Geodesica Nacional ITRF2008 / UTM 13N',''),
(30083,'Coordinate Reference System',6367,7302,'Mexico 2008 / UTM 12N',''),
(30084,'Coordinate Reference System',6367,1028,'Red Geodesica Nacional ITRF2008 / UTM 12N',''),
(30086,'Coordinate Reference System',6366,7302,'Mexico 2008 / UTM 11N',''),
(30087,'Coordinate Reference System',6366,1028,'Red Geodesica Nacional ITRF2008 / UTM 11N',''),
(30091,'Coordinate Reference System',6364,1028,'Red Geodesica Nacional ITRF2008',''),
(30093,'Coordinate Reference System',6363,1028,'Red Geodesica Nacional ITRF2008',''),
(30095,'Datum',1120,1028,'Red Geodesica Nacional 2008',''),
(30096,'Coordinate_Operation',4832,7301,'Mexican Datum of 1993 to WGS 84 (1)','Previous EPSG name, the 1993 reflecting the date of implementation.'),
(30105,'Coordinate_Operation',6373,7301,'Red Geodesica Nacional ITRF2008 to WGS 84 (1)',''),
(30122,'Coordinate_Operation',6374,7301,'Ukraine 3-degree Gauss-Kruger CM 21E',''),
(30124,'Coordinate_Operation',6375,7301,'Ukraine 3-degree Gauss-Kruger CM 24E',''),
(30127,'Coordinate_Operation',6376,7301,'Ukraine 3-degree Gauss-Kruger CM 27E',''),
(30130,'Coordinate_Operation',6377,7301,'Ukraine 3-degree Gauss-Kruger CM 30E',''),
(30133,'Coordinate_Operation',6378,7301,'Ukraine 3-degree Gauss-Kruger CM 33E',''),
(30136,'Coordinate_Operation',6379,7301,'Ukraine 3-degree Gauss-Kruger CM 36E',''),
(30139,'Coordinate_Operation',6380,7301,'Ukraine 3-degree Gauss-Kruger CM 39E',''),
(30148,'Coordinate Reference System',6381,7302,'UCS-2000 / 3GK 21E',''),
(30151,'Coordinate Reference System',6382,7302,'UCS-2000 / 3GK 24E',''),
(30157,'Coordinate Reference System',6384,7302,'UCS-2000 / 3GK 30E',''),
(30159,'Coordinate Reference System',6383,7302,'UCS-2000 / 3GK 27E',''),
(30162,'Coordinate Reference System',6385,7302,'UCS-2000 / 3GK 33E',''),
(30165,'Coordinate Reference System',6386,7302,'UCS-2000 / 3GK 36E',''),
(30168,'Coordinate Reference System',6387,7302,'UCS-2000 / 3GK 39E',''),
(30171,'Coordinate Reference System',6362,1028,'Red Geodesica Nacional ITRF92 / CCL',''),
(30173,'Coordinate Reference System',6372,1028,'Red Geodesica Nacional ITRF2008 / CCL',''),
(30192,'Coordinate_Operation',6388,7302,'Ocotepeque to NAD27 (1)',''),
(30202,'Coordinate_Operation',6390,7302,'CI LCC (ft)',''),
(30205,'Coordinate Reference System',6391,7302,'CING11',''),
(30321,'Coordinate Reference System',6395,7301,'NAD83(2011) / Alaska zone 2 (m)',''),
(30322,'Coordinate Reference System',6395,7302,'NAD83(2011) / AK 2 (m)',''),
(30324,'Coordinate Reference System',6355,7301,'NAD83(2011) / Alabama East (m)',''),
(30325,'Coordinate Reference System',6355,7302,'NAD83(2011) / AL E (m)',''),
(30327,'Coordinate Reference System',6356,7301,'NAD83(2011) / Alabama West (m)',''),
(30328,'Coordinate Reference System',6356,7302,'NAD83(2011) / AL W (m)',''),
(30330,'Coordinate Reference System',6393,7302,'NAD83(2011) / AK Alb',''),
(30332,'Coordinate Reference System',6394,7301,'NAD83(2011) / Alaska zone 1 (m)',''),
(30333,'Coordinate Reference System',6394,7302,'NAD83(2011) / AK 1 (m)',''),
(30337,'Coordinate Reference System',6396,7301,'NAD83(2011) / Alaska zone 3 (m)',''),
(30338,'Coordinate Reference System',6396,7302,'NAD83(2011) / AK 3 (m)',''),
(30342,'Coordinate Reference System',6397,7301,'NAD83(2011) / Alaska zone 4 (m)',''),
(30343,'Coordinate Reference System',6397,7302,'NAD83(2011) / AK 4 (m)',''),
(30347,'Coordinate Reference System',6398,7301,'NAD83(2011) / Alaska zone 5 (m)',''),
(30348,'Coordinate Reference System',6398,7302,'NAD83(2011) / AK 5 (m)',''),
(30352,'Coordinate Reference System',6399,7301,'NAD83(2011) / Alaska zone 6 (m)',''),
(30353,'Coordinate Reference System',6399,7302,'NAD83(2011) / AK 6 (m)',''),
(30357,'Coordinate Reference System',6400,7301,'NAD83(2011) / Alaska zone 7 (m)',''),
(30358,'Coordinate Reference System',6400,7302,'NAD83(2011) / AK 7 (m)',''),
(30362,'Coordinate Reference System',6401,7301,'NAD83(2011) / Alaska zone 8 (m)',''),
(30363,'Coordinate Reference System',6401,7302,'NAD83(2011) / AK 8 (m)',''),
(30367,'Coordinate Reference System',6402,7301,'NAD83(2011) / Alaska zone 9 (m)',''),
(30368,'Coordinate Reference System',6402,7302,'NAD83(2011) / AK 9 (m)',''),
(30372,'Coordinate Reference System',6403,7301,'NAD83(2011) / Alaska zone 10 (m)',''),
(30373,'Coordinate Reference System',6403,7302,'NAD83(2011) / AK 10 (m)',''),
(30377,'Coordinate Reference System',6404,7301,'NAD83(2011) / Arizona Central (m)',''),
(30378,'Coordinate Reference System',6404,7302,'NAD83(2011) / AZ C (m)',''),
(30381,'Coordinate Reference System',6405,7302,'NAD83(2011) / AZ C (ft)',''),
(30385,'Coordinate Reference System',6406,7301,'NAD83(2011) / Arizona East (m)',''),
(30386,'Coordinate Reference System',6406,7302,'NAD83(2011) / AZ E (m)',''),
(30389,'Coordinate Reference System',6407,7302,'NAD83(2011) / AZ E (ft)',''),
(30393,'Coordinate Reference System',6408,7301,'NAD83(2011) / Arizona West (m)',''),
(30394,'Coordinate Reference System',6408,7302,'NAD83(2011) / AZ W (m)',''),
(30397,'Coordinate Reference System',6409,7302,'NAD83(2011) / AZ W (ft)',''),
(30401,'Coordinate Reference System',6410,7301,'NAD83(2011) / Arkansas North (m)',''),
(30402,'Coordinate Reference System',6410,7302,'NAD83(2011) / AR N (m)',''),
(30405,'Coordinate Reference System',6411,7302,'NAD83(2011) / AR N (ftUS)',''),
(30409,'Coordinate Reference System',6412,7301,'NAD83(2011) / Arkansas South (m)',''),
(30410,'Coordinate Reference System',6412,7302,'NAD83(2011) / AR S (m)',''),
(30413,'Coordinate Reference System',6413,7302,'NAD83(2011) / AR S (ftUS)',''),
(30416,'Coordinate Reference System',6414,7302,'NAD83(2011) / CA Albers',''),
(30426,'Coordinate Reference System',6416,7302,'NAD83(2011) / CA 1 (ftUS)',''),
(30428,'Coordinate Reference System',6415,7301,'NAD83(2011) / California zone 1 (m)',''),
(30429,'Coordinate Reference System',6415,7302,'NAD83(2011) / CA 1 (m)',''),
(30436,'Coordinate Reference System',6417,7301,'NAD83(2011) / California zone 2 (m)',''),
(30437,'Coordinate Reference System',6417,7302,'NAD83(2011) / CA 2 (m)',''),
(30440,'Coordinate Reference System',6418,7302,'NAD83(2011) / CA 2 (ftUS)',''),
(30444,'Coordinate Reference System',6419,7301,'NAD83(2011) / California zone 3 (m)',''),
(30445,'Coordinate Reference System',6419,7302,'NAD83(2011) / CA 3 (m)',''),
(30448,'Coordinate Reference System',6420,7302,'NAD83(2011) / CA 3 (ftUS)',''),
(30452,'Coordinate Reference System',6421,7301,'NAD83(2011) / California zone 4 (m)',''),
(30453,'Coordinate Reference System',6421,7302,'NAD83(2011) / CA 4 (m)',''),
(30459,'Coordinate Reference System',6422,7302,'NAD83(2011) / CA 4 (ftUS)',''),
(30463,'Coordinate Reference System',6423,7301,'NAD83(2011) / California zone 5 (m)',''),
(30464,'Coordinate Reference System',6423,7302,'NAD83(2011) / CA 5 (m)',''),
(30467,'Coordinate Reference System',6424,7302,'NAD83(2011) / CA 5 (ftUS)',''),
(30476,'Coordinate Reference System',6425,7301,'NAD83(2011) / California zone 6 (m)',''),
(30477,'Coordinate Reference System',6425,7302,'NAD83(2011) / CA 6 (m)',''),
(30480,'Coordinate Reference System',6426,7302,'NAD83(2011) / CA 6 (ftUS)',''),
(30484,'Coordinate Reference System',6427,7301,'NAD83(2011) / Colorado Central (m)',''),
(30485,'Coordinate Reference System',6427,7302,'NAD83(2011) / CO C (m)',''),
(30488,'Coordinate Reference System',6428,7302,'NAD83(2011) / CO C (ftUS)',''),
(30492,'Coordinate Reference System',6429,7301,'NAD83(2011) / Colorado North (m)',''),
(30493,'Coordinate Reference System',6429,7302,'NAD83(2011) / CO N (m)',''),
(30496,'Coordinate Reference System',6430,7302,'NAD83(2011) / CO N (ftUS)',''),
(30500,'Coordinate Reference System',6431,7301,'NAD83(2011) / Colorado South (m)',''),
(30501,'Coordinate Reference System',6431,7302,'NAD83(2011) / CO S (m)',''),
(30504,'Coordinate Reference System',6432,7302,'NAD83(2011) / CO S (ftUS)',''),
(30511,'Coordinate Reference System',6433,7301,'NAD83(2011) / Connecticut (m)',''),
(30512,'Coordinate Reference System',6433,7302,'NAD83(2011) / CT (m)',''),
(30515,'Coordinate Reference System',6434,7302,'NAD83(2011) / CT (ftUS)',''),
(30519,'Coordinate Reference System',6435,7301,'NAD83(2011) / Delaware (m)',''),
(30520,'Coordinate Reference System',6435,7302,'NAD83(2011) / DE (m)',''),
(30523,'Coordinate Reference System',6436,7302,'NAD83(2011) / DE (ftUS)',''),
(30527,'Coordinate Reference System',6437,7301,'NAD83(2011) / Florida East (m)',''),
(30528,'Coordinate Reference System',6437,7302,'NAD83(2011) / FL E (m)',''),
(30531,'Coordinate Reference System',6438,7302,'NAD83(2011) / FL E (ftUS)',''),
(30534,'Coordinate Reference System',6439,7302,'NAD83(2011) / FL GDL AEA',''),
(30538,'Coordinate Reference System',6440,7301,'NAD83(2011) / Florida North (m)',''),
(30539,'Coordinate Reference System',6440,7302,'NAD83(2011) / FL N (m)',''),
(30542,'Coordinate Reference System',6441,7302,'NAD83(2011) / FL N (ftUS)',''),
(30546,'Coordinate Reference System',6442,7301,'NAD83(2011) / Florida West (m)',''),
(30547,'Coordinate Reference System',6442,7302,'NAD83(2011) / FL W (m)',''),
(30550,'Coordinate Reference System',6443,7302,'NAD83(2011) / FL W (ftUS)',''),
(30554,'Coordinate Reference System',6444,7301,'NAD83(2011) / Georgia East (m)',''),
(30555,'Coordinate Reference System',6444,7302,'NAD83(2011) / GA E (m)',''),
(30558,'Coordinate Reference System',6445,7302,'NAD83(2011) / GA E (ftUS)',''),
(30562,'Coordinate Reference System',6446,7301,'NAD83(2011) / Georgia West (m)',''),
(30563,'Coordinate Reference System',6446,7302,'NAD83(2011) / GA W (m)',''),
(30566,'Coordinate Reference System',6447,7302,'NAD83(2011) / GA W (ftUS)',''),
(30570,'Coordinate Reference System',6448,7301,'NAD83(2011) / Idaho Central (m)',''),
(30571,'Coordinate Reference System',6448,7302,'NAD83(2011) / ID C (m)',''),
(30574,'Coordinate Reference System',6449,7302,'NAD83(2011) / ID C (ftUS)',''),
(30578,'Coordinate Reference System',6450,7301,'NAD83(2011) / Idaho East (m)',''),
(30579,'Coordinate Reference System',6450,7302,'NAD83(2011) / ID E (m)',''),
(30582,'Coordinate Reference System',6451,7302,'NAD83(2011) / ID E (ftUS)',''),
(30586,'Coordinate Reference System',6452,7301,'NAD83(2011) / Idaho West (m)',''),
(30587,'Coordinate Reference System',6452,7302,'NAD83(2011) / ID W (m)',''),
(30590,'Coordinate Reference System',6453,7302,'NAD83(2011) / ID W (ftUS)',''),
(30594,'Coordinate Reference System',6454,7301,'NAD83(2011) / Illinois East (m)',''),
(30595,'Coordinate Reference System',6454,7302,'NAD83(2011) / IL E (m)',''),
(30598,'Coordinate Reference System',6455,7302,'NAD83(2011) / IL E (ftUS)',''),
(30602,'Coordinate Reference System',6456,7301,'NAD83(2011) / Illinois West (m)',''),
(30603,'Coordinate Reference System',6456,7302,'NAD83(2011) / IL W (m)',''),
(30606,'Coordinate Reference System',6457,7302,'NAD83(2011) / IL W (ftUS)',''),
(30610,'Coordinate Reference System',6458,7301,'NAD83(2011) / Indiana East (m)',''),
(30611,'Coordinate Reference System',6458,7302,'NAD83(2011) / IN E (m)',''),
(30614,'Coordinate Reference System',6459,7302,'NAD83(2011) / IN E (ftUS)',''),
(30618,'Coordinate Reference System',6460,7301,'NAD83(2011) / Indiana West (m)',''),
(30619,'Coordinate Reference System',6460,7302,'NAD83(2011) / IN W (m)',''),
(30622,'Coordinate Reference System',6461,7302,'NAD83(2011) / IN W (ftUS)',''),
(30626,'Coordinate Reference System',6462,7301,'NAD83(2011) / Iowa North (m)',''),
(30627,'Coordinate Reference System',6462,7302,'NAD83(2011) / IA N (m)',''),
(30636,'Coordinate Reference System',6464,7301,'NAD83(2011) / Iowa South (m)',''),
(30637,'Coordinate Reference System',6464,7302,'NAD83(2011) / IA S (m)',''),
(30644,'Coordinate Reference System',6466,7301,'NAD83(2011) / Kansas North (m)',''),
(30645,'Coordinate Reference System',6466,7302,'NAD83(2011) / KS N (m)',''),
(30652,'Coordinate Reference System',6468,7301,'NAD83(2011) / Kansas South (m)',''),
(30653,'Coordinate Reference System',6468,7302,'NAD83(2011) / KS S (m)',''),
(30660,'Coordinate Reference System',6470,7301,'NAD83(2011) / Kentucky North (m)',''),
(30661,'Coordinate Reference System',6470,7302,'NAD83(2011) / KY N (m)',''),
(30671,'Coordinate Reference System',6471,7302,'NAD83(2011) / KY N (ftUS)',''),
(30676,'Coordinate Reference System',6472,7301,'NAD83(2011) / Kentucky Single Zone (m)',''),
(30677,'Coordinate Reference System',6472,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(30678,'Coordinate Reference System',6472,7302,'NAD83(2011) / KY1Z (m)',''),
(30682,'Coordinate Reference System',6473,7302,'NAD83(2011) / KY1Z (ftUS)',''),
(30683,'Coordinate Reference System',6473,7301,'KY1Z','This alias is ambiguous as it is also used for the same projection associated with different datums and coordinate systems.'),
(30687,'Coordinate Reference System',6474,7301,'NAD83(2011) / Kentucky South (m)',''),
(30688,'Coordinate Reference System',6474,7302,'NAD83(2011) / KY S (m)',''),
(30691,'Coordinate Reference System',6475,7302,'NAD83(2011) / KY S (ftUS)',''),
(30695,'Coordinate Reference System',6476,7301,'NAD83(2011) / Louisiana North (m)',''),
(30696,'Coordinate Reference System',6476,7302,'NAD83(2011) / LA N (m)',''),
(30699,'Coordinate Reference System',6477,7302,'NAD83(2011) / LA N (ftUS)',''),
(30703,'Coordinate Reference System',6478,7301,'NAD83(2011) / Louisiana South (m)',''),
(30704,'Coordinate Reference System',6478,7302,'NAD83(2011) / LA S (m)',''),
(30707,'Coordinate Reference System',6479,7302,'NAD83(2011) / LA S (ftUS)',''),
(30712,'Coordinate Reference System',6480,7301,'NAD83(2011) / Maine CS2000 Central (m)',''),
(30713,'Coordinate Reference System',6480,7301,'Maine Coordinate System of 2000 Central Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 Central zone projection.'),
(30714,'Coordinate Reference System',6480,7302,'NAD83(2011) / ME 2000 C',''),
(30719,'Coordinate Reference System',6481,7301,'NAD83(2011) / Maine CS2000 East (m)',''),
(30720,'Coordinate Reference System',6481,7301,'Maine Coordinate System of 2000 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 East zone projection.'),
(30721,'Coordinate Reference System',6481,7302,'NAD83(2011) / ME 2000 E',''),
(30726,'Coordinate Reference System',6482,7301,'NAD83(2011) / Maine CS2000 West (m)',''),
(30727,'Coordinate Reference System',6482,7301,'Maine Coordinate System of 2000 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS2000 West zone projection.'),
(30728,'Coordinate Reference System',6482,7302,'NAD83(2011) / ME 2000 W',''),
(30733,'Coordinate Reference System',6483,7301,'NAD83(2011) / Maine CS83 East (m)',''),
(30734,'Coordinate Reference System',6483,7301,'Maine Coordinate System of 1983 East Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 East zone projection.'),
(30735,'Coordinate Reference System',6483,7302,'NAD83(2011) / ME83 E (m)',''),
(30739,'Coordinate Reference System',6484,7301,'NAD83(2011) / Maine CS83 East (ftUS)',''),
(30740,'Coordinate Reference System',6484,7302,'NAD83(2011) / ME E (ftUS)',''),
(30745,'Coordinate Reference System',6485,7301,'NAD83(2011) / Maine West (m)',''),
(30746,'Coordinate Reference System',6485,7301,'Maine Coordinate System of 1983 West Zone','This alias is ambiguous as also used for other realisations of NAD83 datum with Maine CS83 West zone projection.'),
(30747,'Coordinate Reference System',6485,7302,'NAD83(2011) / ME83 W (m)',''),
(30751,'Coordinate Reference System',6486,7301,'NAD83(2011) / Maine CS83 West (ftUS)',''),
(30752,'Coordinate Reference System',6486,7302,'NAD83(2011) / ME W (ftUS)',''),
(30756,'Coordinate Reference System',6487,7301,'NAD83(2011) / Maryland (m)',''),
(30757,'Coordinate Reference System',6487,7302,'NAD83(2011) / MD (m)',''),
(30760,'Coordinate Reference System',6488,7302,'NAD83(2011) / MD (ftUS)',''),
(30764,'Coordinate Reference System',6489,7301,'NAD83(2011) / Massachusetts Island (m)',''),
(30765,'Coordinate Reference System',6489,7302,'NAD83(2011) / MA Is (m)',''),
(30768,'Coordinate Reference System',6490,7302,'NAD83(2011) / MA Is (ftUS)',''),
(30772,'Coordinate Reference System',6491,7301,'NAD83(2011) / Massachusetts Mainland (m)',''),
(30773,'Coordinate Reference System',6491,7302,'NAD83(2011) / MA md (m)',''),
(30776,'Coordinate Reference System',6492,7302,'NAD83(2011) / MA md (ftUS)',''),
(30780,'Coordinate Reference System',6493,7301,'NAD83(2011) / Michigan Central (m)',''),
(30781,'Coordinate Reference System',6493,7302,'NAD83(2011) / MI C (m)',''),
(30784,'Coordinate Reference System',6494,7302,'NAD83(2011) / MI C (ft)',''),
(30788,'Coordinate Reference System',6495,7301,'NAD83(2011) / Michigan North (m)',''),
(30789,'Coordinate Reference System',6495,7302,'NAD83(2011) / MI N (m)',''),
(30795,'Coordinate Reference System',6496,7302,'NAD83(2011) / MI N (ft)',''),
(30798,'Coordinate Reference System',6497,7302,'NAD83(2011) / MI Georef',''),
(30802,'Coordinate Reference System',6498,7301,'NAD83(2011) / Michigan South (m)',''),
(30803,'Coordinate Reference System',6498,7302,'NAD83(2011) / MI S (m)',''),
(30806,'Coordinate Reference System',6499,7302,'NAD83(2011) / MI S (ft)',''),
(30813,'Coordinate Reference System',6500,7301,'NAD83(2011) / Minnesota Central (m)',''),
(30814,'Coordinate Reference System',6500,7302,'NAD83(2011) / MN C (m)',''),
(30817,'Coordinate Reference System',6501,7302,'NAD83(2011) / MN C (ftUS)',''),
(30828,'Coordinate Reference System',6502,7301,'NAD83(2011) / Minnesota North (m)',''),
(30829,'Coordinate Reference System',6502,7302,'NAD83(2011) / MN N (m)',''),
(30832,'Coordinate Reference System',6503,7302,'NAD83(2011) / MN N (ftUS)',''),
(30836,'Coordinate Reference System',6504,7301,'NAD83(2011) / Minnesota South (m)',''),
(30837,'Coordinate Reference System',6504,7302,'NAD83(2011) / MN S (m)',''),
(30840,'Coordinate Reference System',6505,7302,'NAD83(2011) / MN S (ftUS)',''),
(30844,'Coordinate Reference System',6506,7301,'NAD83(2011) / Mississippi East (m)',''),
(30845,'Coordinate Reference System',6506,7302,'NAD83(2011) / MS E (m)',''),
(30848,'Coordinate Reference System',6507,7302,'NAD83(2011) / MS E (ftUS)',''),
(30852,'Coordinate Reference System',6508,7302,'NAD83(2011) / MSTM',''),
(30859,'Coordinate Reference System',6509,7301,'NAD83(2011) / Mississippi West (m)',''),
(30860,'Coordinate Reference System',6509,7302,'NAD83(2011) / MS W (m)',''),
(30863,'Coordinate Reference System',6510,7302,'NAD83(2011) / MS W (ftUS)',''),
(30867,'Coordinate Reference System',6511,7301,'NAD83(2011) / Missouri Central (m)',''),
(30868,'Coordinate Reference System',6511,7302,'NAD83(2011) / MO C (m)',''),
(30872,'Coordinate Reference System',6512,7301,'NAD83(2011) / Missouri East (m)',''),
(30873,'Coordinate Reference System',6512,7302,'NAD83(2011) / MO E (m)',''),
(30877,'Coordinate Reference System',6513,7301,'NAD83(2011) / Missouri West (m)',''),
(30878,'Coordinate Reference System',6513,7302,'NAD83(2011) / MO W (m)',''),
(30882,'Coordinate Reference System',6514,7301,'NAD83(2011) / Montana (m)',''),
(30883,'Coordinate Reference System',6514,7302,'NAD83(2011) / MT (m)',''),
(30886,'Coordinate Reference System',6515,7302,'NAD83(2011) / MT (ft)',''),
(30898,'Coordinate Reference System',6518,7301,'NAD83(2011) / Nevada Central (m)',''),
(30899,'Coordinate Reference System',6518,7302,'NAD83(2011) / NV C (m)',''),
(30906,'Coordinate Reference System',6520,7301,'NAD83(2011) / Nevada East (m)',''),
(30907,'Coordinate Reference System',6520,7302,'NAD83(2011) / NV E (m)',''),
(30914,'Coordinate Reference System',6522,7301,'NAD83(2011) / Nevada West (m)',''),
(30915,'Coordinate Reference System',6522,7302,'NAD83(2011) / NV W (m)',''),
(30922,'Coordinate Reference System',6524,7301,'NAD83(2011) / New Hampshire (m)',''),
(30923,'Coordinate Reference System',6524,7302,'NAD83(2011) / NH (m)',''),
(30926,'Coordinate Reference System',6525,7302,'NAD83(2011) / NH (ftUS)',''),
(30930,'Coordinate Reference System',6526,7301,'NAD83(2011) / New Jersey (m)',''),
(30931,'Coordinate Reference System',6526,7302,'NAD83(2011) / NJ (m)',''),
(30938,'Coordinate Reference System',6528,7301,'NAD83(2011) / New Mexico Central (m)',''),
(30939,'Coordinate Reference System',6528,7302,'NAD83(2011) / NM C (m)',''),
(30942,'Coordinate Reference System',6529,7302,'NAD83(2011) / NM C (ftUS)',''),
(30946,'Coordinate Reference System',6530,7301,'NAD83(2011) / New Mexico East (m)',''),
(30947,'Coordinate Reference System',6530,7302,'NAD83(2011) / NM E (m)',''),
(30950,'Coordinate Reference System',6531,7302,'NAD83(2011) / NM E (ftUS)',''),
(30954,'Coordinate Reference System',6532,7301,'NAD83(2011) / New Mexico West (m)',''),
(30955,'Coordinate Reference System',6532,7302,'NAD83(2011) / NM W (m)',''),
(30958,'Coordinate Reference System',6533,7302,'NAD83(2011) / NM W (ftUS)',''),
(30962,'Coordinate Reference System',6534,7301,'NAD83(2011) / New York Central (m)',''),
(30963,'Coordinate Reference System',6534,7302,'NAD83(2011) / NY C (m)',''),
(30966,'Coordinate Reference System',6535,7302,'NAD83(2011) / NY C (ftUS)',''),
(30970,'Coordinate Reference System',6536,7301,'NAD83(2011) / New York East (m)',''),
(30971,'Coordinate Reference System',6536,7302,'NAD83(2011) / NY E (m)',''),
(30974,'Coordinate Reference System',6537,7302,'NAD83(2011) / NY E (ftUS)',''),
(30978,'Coordinate Reference System',6538,7301,'NAD83(2011) / New York Long Island (m)',''),
(30979,'Coordinate Reference System',6538,7302,'NAD83(2011) / NY LI (m)',''),
(30987,'Coordinate Reference System',6539,7302,'NAD83(2011) / NY LI (ftUS)',''),
(30991,'Coordinate Reference System',6540,7301,'NAD83(2011) / New York West (m)',''),
(30992,'Coordinate Reference System',6540,7302,'NAD83(2011) / NY W (m)',''),
(30995,'Coordinate Reference System',6541,7302,'NAD83(2011) / NY W (ftUS)',''),
(31000,'Coordinate Reference System',6542,7301,'NAD83(2011) / North Carolina (m)',''),
(31001,'Coordinate Reference System',6542,7302,'NAD83(2011) / NC (m)',''),
(31004,'Coordinate Reference System',6543,7302,'NAD83(2011) / NC (ftUS)',''),
(31008,'Coordinate Reference System',6544,7301,'NAD83(2011) / North Dakota North (m)',''),
(31009,'Coordinate Reference System',6544,7302,'NAD83(2011) / ND N (m)',''),
(31012,'Coordinate Reference System',6545,7302,'NAD83(2011) / ND N (ft)',''),
(31016,'Coordinate Reference System',6546,7301,'NAD83(2011) / North Dakota South (m)',''),
(31017,'Coordinate Reference System',6546,7302,'NAD83(2011) / ND S (m)',''),
(31020,'Coordinate Reference System',6547,7302,'NAD83(2011) / ND S (ft)',''),
(31023,'Coordinate Reference System',6548,7301,'NAD83(2011) / Ohio North (m)',''),
(31026,'Coordinate Reference System',6549,7302,'NAD83(2011) / OH N (ftUS)',''),
(31029,'Coordinate Reference System',6550,7301,'NAD83(2011) / Ohio South (m)',''),
(31032,'Coordinate Reference System',6551,7302,'NAD83(2011) / OH S (ftUS)',''),
(31036,'Coordinate Reference System',6552,7301,'NAD83(2011) / Oklahoma North (m)',''),
(31037,'Coordinate Reference System',6552,7302,'NAD83(2011) / OK N (m)',''),
(31040,'Coordinate Reference System',6553,7302,'NAD83(2011) / OK N (ftUS)',''),
(31044,'Coordinate Reference System',6554,7301,'NAD83(2011) / Oklahoma South (m)',''),
(31045,'Coordinate Reference System',6554,7302,'NAD83(2011) / OK S (m)',''),
(31048,'Coordinate Reference System',6555,7302,'NAD83(2011) / OK S (ftUS)',''),
(31056,'Coordinate Reference System',6557,7302,'NAD83(2011) / OR GIC Lam (ft)',''),
(31064,'Coordinate Reference System',6558,7301,'NAD83(2011) / Oregon North (m)',''),
(31065,'Coordinate Reference System',6558,7302,'NAD83(2011) / OR N (m)',''),
(31068,'Coordinate Reference System',6559,7302,'NAD83(2011) / OR N (ft)',''),
(31072,'Coordinate Reference System',6560,7301,'NAD83(2011) / Oregon South (m)',''),
(31073,'Coordinate Reference System',6560,7302,'NAD83(2011) / OR S (m)',''),
(31076,'Coordinate Reference System',6561,7302,'NAD83(2011) / OR S (ft)',''),
(31080,'Coordinate Reference System',6562,7301,'NAD83(2011) / Pennsylvania North (m)',''),
(31081,'Coordinate Reference System',6562,7302,'NAD83(2011) / PA N (m)',''),
(31084,'Coordinate Reference System',6563,7302,'NAD83(2011) / PA N (ftUS)',''),
(31088,'Coordinate Reference System',6564,7301,'NAD83(2011) / Pennsylvania South (m)',''),
(31089,'Coordinate Reference System',6564,7302,'NAD83(2011) / PA S (m)',''),
(31092,'Coordinate Reference System',6565,7302,'NAD83(2011) / PA S (ftUS)',''),
(31095,'Coordinate Reference System',6566,7302,'NAD83(2011) / PR and VI',''),
(31106,'Coordinate Reference System',6567,7301,'NAD83(2011) / Rhode Island (m)',''),
(31108,'Coordinate Reference System',6567,7302,'NAD83(2011) / RI (m)',''),
(31111,'Coordinate Reference System',6568,7302,'NAD83(2011) / RI (ftUS)',''),
(31115,'Coordinate Reference System',6569,7301,'NAD83(2011) / South Carolina (m)',''),
(31116,'Coordinate Reference System',6569,7302,'NAD83(2011) / SC (m)',''),
(31119,'Coordinate Reference System',6570,7302,'NAD83(2011) / SC (ft)',''),
(31123,'Coordinate Reference System',6571,7301,'NAD83(2011) / South Dakota North (m)',''),
(31124,'Coordinate Reference System',6571,7302,'NAD83(2011) / SD N (m)',''),
(31127,'Coordinate Reference System',6572,7302,'NAD83(2011) / SD N (ftUS)',''),
(31131,'Coordinate Reference System',6573,7301,'NAD83(2011) / South Dakota South (m)',''),
(31132,'Coordinate Reference System',6573,7302,'NAD83(2011) / SD S (m)',''),
(31138,'Coordinate Reference System',6574,7302,'NAD83(2011) / SD S (ftUS)',''),
(31142,'Coordinate Reference System',6575,7301,'NAD83(2011) / Tennessee (m)',''),
(31143,'Coordinate Reference System',6575,7302,'NAD83(2011) / TN (m)',''),
(31146,'Coordinate Reference System',6576,7302,'NAD83(2011) / TN (ftUS)',''),
(31150,'Coordinate Reference System',6577,7301,'NAD83(2011) / Texas Central (m)',''),
(31151,'Coordinate Reference System',6577,7302,'NAD83(2011) / TX C (m)',''),
(31154,'Coordinate Reference System',6578,7302,'NAD83(2011) / TX C (ftUS)',''),
(31157,'Coordinate Reference System',6579,7302,'NAD83(2011) / TX Albers',''),
(31160,'Coordinate Reference System',6580,7302,'NAD83(2011) / TX LC',''),
(31164,'Coordinate Reference System',6581,7301,'NAD83(2011) / Texas North (m)',''),
(31165,'Coordinate Reference System',6581,7302,'NAD83(2011) / TX N (m)',''),
(31168,'Coordinate Reference System',6582,7302,'NAD83(2011) / TX N (ftUS)',''),
(31172,'Coordinate Reference System',6583,7301,'NAD83(2011) / Texas North Central (m)',''),
(31173,'Coordinate Reference System',6583,7302,'NAD83(2011) / TX NC (m)',''),
(31179,'Coordinate Reference System',6584,7302,'NAD83(2011) / TX NC (ftUS)',''),
(31183,'Coordinate Reference System',6585,7301,'NAD83(2011) / Texas South (m)',''),
(31184,'Coordinate Reference System',6585,7302,'NAD83(2011) / TX S (m)',''),
(31187,'Coordinate Reference System',6586,7302,'NAD83(2011) / TX S (ftUS)',''),
(31191,'Coordinate Reference System',6587,7301,'NAD83(2011) / Texas South Central (m)',''),
(31192,'Coordinate Reference System',6587,7302,'NAD83(2011) / TX SC (m)',''),
(31195,'Coordinate Reference System',6588,7302,'NAD83(2011) / TX SC (ftUS)',''),
(31199,'Coordinate Reference System',6589,7301,'NAD83(2011) / Vermont (m)',''),
(31200,'Coordinate Reference System',6589,7302,'NAD83(2011) / VT (m)',''),
(31203,'Coordinate Reference System',6590,7302,'NAD83(2011) / VT (ftUS)',''),
(31206,'Coordinate Reference System',6591,7302,'NAD83(2011) / VA LCC',''),
(31216,'Coordinate Reference System',6592,7301,'NAD83(2011) / Virginia North (m)',''),
(31217,'Coordinate Reference System',6592,7302,'NAD83(2011) / VA N (m)',''),
(31219,'Coordinate Reference System',6593,7302,'NAD83(2011) / VA N (ftUS)',''),
(31223,'Coordinate Reference System',6594,7301,'NAD83(2011) / Virginia South (m)',''),
(31224,'Coordinate Reference System',6594,7302,'NAD83(2011) / VA S (m)',''),
(31227,'Coordinate Reference System',6595,7302,'NAD83(2011) / VA S (ftUS)',''),
(31231,'Coordinate Reference System',6596,7301,'NAD83(2011) / Washington North (m)',''),
(31232,'Coordinate Reference System',6596,7302,'NAD83(2011) / WA N (m)',''),
(31235,'Coordinate Reference System',6597,7302,'NAD83(2011) / WA N (ftUS)',''),
(31239,'Coordinate Reference System',6598,7301,'NAD83(2011) / Washington South (m)',''),
(31240,'Coordinate Reference System',6598,7302,'NAD83(2011) / WA S (m)',''),
(31243,'Coordinate Reference System',6599,7302,'NAD83(2011) / WA S (ftUS)',''),
(31250,'Coordinate Reference System',6600,7301,'NAD83(2011) / West Virginia North (m)',''),
(31251,'Coordinate Reference System',6600,7302,'NAD83(2011) / WV N (m)',''),
(31254,'Coordinate Reference System',6601,7302,'NAD83(2011) / WV N (ftUS)',''),
(31258,'Coordinate Reference System',6602,7301,'NAD83(2011) / West Virginia South (m)',''),
(31259,'Coordinate Reference System',6602,7302,'NAD83(2011) / WV S (m)',''),
(31276,'Coordinate Reference System',6603,7302,'NAD83(2011) / WV S (ftUS)',''),
(31280,'Coordinate Reference System',6604,7301,'NAD83(2011) / Wisconsin Central (m)',''),
(31281,'Coordinate Reference System',6604,7302,'NAD83(2011) / WI C (m)',''),
(31284,'Coordinate Reference System',6605,7302,'NAD83(2011) / WI C (ftUS)',''),
(31288,'Coordinate Reference System',6606,7301,'NAD83(2011) / Wisconsin North (m)',''),
(31289,'Coordinate Reference System',6606,7302,'NAD83(2011) / WI N (m)',''),
(31292,'Coordinate Reference System',6607,7302,'NAD83(2011) / WI N (ftUS)',''),
(31296,'Coordinate Reference System',6608,7301,'NAD83(2011) / Wisconsin South (m)',''),
(31297,'Coordinate Reference System',6608,7302,'NAD83(2011) / WI S (m)',''),
(31300,'Coordinate Reference System',6609,7302,'NAD83(2011) / WI S (ftUS)',''),
(31304,'Coordinate Reference System',6610,7302,'NAD83(2011) / WTM 83',''),
(31309,'Coordinate Reference System',6611,7301,'NAD83(2011) / Wyoming East (m)',''),
(31310,'Coordinate Reference System',6611,7302,'NAD83(2011) / WY E (m)',''),
(31313,'Coordinate Reference System',6612,7302,'NAD83(2011) / WY E (ftUS)',''),
(31317,'Coordinate Reference System',6613,7301,'NAD83(2011) / Wyoming East Central (m)',''),
(31318,'Coordinate Reference System',6613,7302,'NAD83(2011) / WY EC (m)',''),
(31321,'Coordinate Reference System',6614,7302,'NAD83(2011) / WY EC (ftUS)',''),
(31325,'Coordinate Reference System',6615,7301,'NAD83(2011) / Wyoming West (m)',''),
(31326,'Coordinate Reference System',6615,7302,'NAD83(2011) / WY W (m)',''),
(31345,'Coordinate Reference System',6618,7302,'NAD83(2011) / WY WC (ftUS)',''),
(31348,'Coordinate Reference System',6616,7302,'NAD83(2011) / WY W (ftUS)',''),
(31387,'Coordinate Reference System',6628,7301,'NAD83(PA11) / Hawaii zone 1 (m)',''),
(31388,'Coordinate Reference System',6628,7302,'NAD83(PA11) / HI 1 (m)',''),
(31394,'Coordinate Reference System',6629,7301,'NAD83(PA11) / Hawaii zone 2 (m)',''),
(31395,'Coordinate Reference System',6629,7302,'NAD83(PA11) / HI 2 (m)',''),
(31401,'Coordinate Reference System',6630,7301,'NAD83(PA11) / Hawaii zone 3 (m)',''),
(31402,'Coordinate Reference System',6630,7302,'NAD83(PA11) / HI 3 (m)',''),
(31408,'Coordinate Reference System',6631,7301,'NAD83(PA11) / Hawaii zone 4 (m)',''),
(31409,'Coordinate Reference System',6631,7302,'NAD83(PA11) / HI 4 (m)',''),
(31420,'Coordinate Reference System',6633,7301,'NAD83(PA11) / Hawaii zone 3 (ftUS)',''),
(31421,'Coordinate Reference System',6633,7302,'NAD83(PA11) / HI 3 (ftUS)',''),
(31426,'Coordinate Reference System',6634,7302,'NAD83(PA11) / UTM 4N',''),
(31431,'Coordinate Reference System',6632,7301,'NAD83(PA11) / Hawaii zone 5 (m)',''),
(31432,'Coordinate Reference System',6632,7302,'NAD83(PA11) / HI 5 (m)',''),
(31437,'Coordinate Reference System',6635,7302,'NAD83(PA11) / UTM 5N',''),
(31442,'Coordinate Reference System',6636,7302,'NAD83(PA11) / UTM 2S',''),
(31448,'Coordinate Reference System',6637,7302,'GGN93 / Guam Map Grid',''),
(31449,'Coordinate Reference System',6637,7301,'Guam Geodetic Network 1993 / Guam Map Grid',''),
(31450,'Coordinate Reference System',6637,1026,'NAD83 / Guam Map Grid','The base geographic CRS alias NAD83 is used only in Guam. The name is that of a different system applicable only in North America (see CRS code 4269).'),
(31451,'Coordinate Reference System',6637,7301,'NAD83(MA11) / Guam Map Grid',''),
(31469,'Datum',1119,7302,'NMVD03',''),
(31503,'Coordinate Reference System',6640,7301,'Northern Marianas Vertical Datum of 2003 height (m)',''),
(31519,'Coordinate Reference System',6642,7301,'Virgin Island Vertical Datum of 2009 height (m)',''),
(31535,'Coordinate Reference System',6643,7301,'American Samoa Vertical Datum of 2002 height (m)',''),
(31537,'Coordinate Reference System',6638,7301,'Tutuila Vertical Datum of 1962 height (m)',''),
(31551,'Coordinate Reference System',6644,7301,'Guam Vertical Datum of 2004 height (m)',''),
(31588,'Datum',1122,7302,'GUVD63',''),
(31590,'Coordinate Reference System',6639,7301,'Guam Vertical Datum of 1963 height (m)',''),
(31592,'Datum',1126,7302,'GUVD04',''),
(31594,'Datum',1125,7302,'ASVD02',''),
(31596,'Datum',1121,7302,'Tutuila62',''),
(31598,'Datum',1124,7302,'VIVD09',''),
(31610,'Datum',1123,7302,'PRVD02',''),
(31612,'Coordinate Reference System',6641,7301,'Puerto Rico Vertical Datum of 2002 height (m)',''),
(31630,'Coordinate Reference System',6619,7301,'NAD83(2011) / Utah Central (m)',''),
(31631,'Coordinate Reference System',6619,7302,'NAD83(2011) / UT C (m)',''),
(31633,'Coordinate Reference System',6620,7301,'NAD83(2011) / Utah North (m)',''),
(31634,'Coordinate Reference System',6620,7302,'NAD83(2011) / UT N (m)',''),
(31636,'Coordinate Reference System',6621,7301,'NAD83(2011) / Utah South (m)',''),
(31637,'Coordinate Reference System',6621,7302,'NAD83(2011) / UT S (m)',''),
(31651,'Coordinate Reference System',6625,7302,'NAD83(2011) / UT C (ftUS)',''),
(31653,'Coordinate Reference System',6626,7302,'NAD83(2011) / UT N (ftUS)',''),
(31655,'Coordinate Reference System',6627,7302,'NAD83(2011) / UT S (ftUS)',''),
(31705,'Coordinate Reference System',6463,7302,'NAD83(2011) / IA N (ftUS)',''),
(31707,'Coordinate Reference System',6465,7302,'NAD83(2011) / IA S (ftUS)',''),
(31711,'Coordinate Reference System',6467,7302,'NAD83(2011) / KS N (ftUS)',''),
(31713,'Coordinate Reference System',6469,7302,'NAD83(2011) / KS S (ftUS)',''),
(31715,'Coordinate Reference System',6516,7301,'NAD83(2011) / Nebraska (m)',''),
(31716,'Coordinate Reference System',6516,7302,'NAD83(2011) / NE (m)',''),
(31718,'Coordinate Reference System',6517,7302,'NAD83(2011) / NE (ftUS)',''),
(31720,'Coordinate Reference System',6519,7302,'NAD83(2011) / NV C (ftUS)',''),
(31722,'Coordinate Reference System',6521,7302,'NAD83(2011) / NV E (ftUS)',''),
(31726,'Coordinate Reference System',6523,7302,'NAD83(2011) / NV W (ftUS)',''),
(31728,'Coordinate Reference System',6527,7302,'NAD83(2011) / NJ (ftUS)',''),
(31730,'Coordinate Reference System',6617,7301,'NAD83(2011) / Wyoming West Central (m)',''),
(31731,'Coordinate Reference System',6617,7302,'NAD83(2011) / WY WC (m)',''),
(31803,'Coordinate Reference System',6646,7301,'Karbala 1979 (Polservice) / Iraq National Grid',''),
(31804,'Coordinate Reference System',6646,7302,'Karbala / Iraq Nat. Grid',''),
(31883,'Datum',1127,7302,'CGVD2013',''),
(31885,'Coordinate Reference System',6647,7301,'Canadian Geodetic Vertical Datum of 2013 height',''),
(32060,'Coordinate Reference System',6669,7302,'JGD2011 / Japan zone 1',''),
(32062,'Coordinate Reference System',6670,7302,'JGD2011 / Japan zone 2',''),
(32064,'Coordinate Reference System',6671,7302,'JGD2011 / Japan zone 3',''),
(32066,'Coordinate Reference System',6672,7302,'JGD2011 / Japan zone 4',''),
(32068,'Coordinate Reference System',6673,7302,'JGD2011 / Japan zone 5',''),
(32070,'Coordinate Reference System',6674,7302,'JGD2011 / Japan zone 6',''),
(32072,'Coordinate Reference System',6675,7302,'JGD2011 / Japan zone 7',''),
(32074,'Coordinate Reference System',6676,7302,'JGD2011 / Japan zone 8',''),
(32076,'Coordinate Reference System',6678,7302,'JGD2011 / Japan zone 10',''),
(32078,'Coordinate Reference System',6679,7302,'JGD2011 / Japan zone 11',''),
(32080,'Coordinate Reference System',6680,7302,'JGD2011 / Japan zone 12',''),
(32082,'Coordinate Reference System',6681,7302,'JGD2011 / Japan zone 13',''),
(32084,'Coordinate Reference System',6682,7302,'JGD2011 / Japan zone 14',''),
(32086,'Coordinate Reference System',6687,7302,'JGD2011 / Japan zone 19',''),
(32088,'Coordinate Reference System',6683,7302,'JGD2011 / Japan zone 15',''),
(32090,'Coordinate Reference System',6684,7302,'JGD2011 / Japan zone 16',''),
(32092,'Coordinate Reference System',6685,7302,'JGD2011 / Japan zone 17',''),
(32094,'Coordinate Reference System',6686,7302,'JGD2011 / Japan zone 18',''),
(32101,'Coordinate Reference System',5723,7301,'JSLD height','This alias is ambiguous as it is used for all realisations.'),
(32168,'Datum',1128,7302,'JGD2011',''),
(32176,'Datum',1131,7302,'JGD2011 (vertical)',''),
(32218,'Datum',1130,7302,'JGD2000 (vertical)',''),
(32274,'Coordinate Reference System',6677,7302,'JGD2011 / Japan zone 9',''),
(32318,'Coordinate Reference System',6693,7301,'Japan Levelling Datum height','This alias is ambiguous as it is used for all realisations.'),
(32319,'Coordinate Reference System',6693,7301,'Japanese Standard Levelling Datum height','This alias is ambiguous as it is used for all realisations.'),
(32320,'Coordinate Reference System',6693,7301,'JSLD height','This alias is ambiguous as it is used for all realisations.'),
(32327,'Datum',1129,7302,'JSLD72',''),
(32452,'Coordinate Reference System',6707,7301,'RDN2008 / TM32',''),
(32454,'Coordinate Reference System',6708,7301,'RDN2008 / TM33',''),
(32460,'Coordinate Reference System',6709,7301,'RDN2008 / TM34',''),
(32465,'Datum',1132,7302,'RDN2008',''),
(32546,'Coordinate_Operation',6718,7302,'CKIG92',''),
(32547,'Coordinate_Operation',6718,7301,'Cocos (Keeling) Island Grid 1992',''),
(32573,'Coordinate_Operation',6717,7302,'CIG94',''),
(32575,'Coordinate_Operation',6716,7302,'CIG92',''),
(32582,'Coordinate_Operation',6719,7302,'CKIG94',''),
(32583,'Coordinate_Operation',6719,7301,'Cocos (Keeling) Island Grid 1994',''),
(32633,'Coordinate_Operation',6725,7302,'MGA zone 41',''),
(32636,'Coordinate_Operation',6726,7302,'MGA zone 42',''),
(32639,'Coordinate_Operation',6727,7302,'MGA zone 43',''),
(32642,'Coordinate_Operation',6728,7302,'MGA zone 44',''),
(32645,'Coordinate_Operation',6729,7302,'MGA zone 46',''),
(32648,'Coordinate_Operation',6730,7302,'MGA zone 47',''),
(32670,'Coordinate_Operation',6731,7302,'MGA zone 59',''),
INSERT INTO EPSG_AREA VALUES
(1024,'Afghanistan','Afghanistan.',29.4,38.48,60.5,74.92,'urn:ogc:def:extent-polygon:EPSG::1024','AF','AFG',4,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.040 2014.025',0),
(1025,'Albania','Albania - onshore and offshore.',39.63,42.67,18.46,21.06,'urn:ogc:def:extent-polygon:EPSG::1025','AL','ALB',8,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1026,'Algeria','Algeria - onshore and offshore.',18.97,38.8,-8.67,11.99,'urn:ogc:def:extent-polygon:EPSG::1026','DZ','DZA',12,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1027,'American Samoa','American Samoa - onshore and offshore.',-17.56,-10.02,-173.75,-165.2,'urn:ogc:def:extent-polygon:EPSG::1027','AS','ASM',16,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2011-07-27','2002.341 2005.890 2011.068',0),
(1028,'Andorra','Andorra.',42.43,42.66,1.42,1.79,'urn:ogc:def:extent-polygon:EPSG::1028','AD','AND',20,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.095 2014.025',0),
(1029,'Angola','Angola - onshore and offshore.',-18.02,-4.38,8.2,24.09,'urn:ogc:def:extent-polygon:EPSG::1029','AO','AGO',24,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.042 2014.025',0),
(1030,'Anguilla','Anguilla - onshore and offshore.',17.94,21.93,-63.9,-60.68,'urn:ogc:def:extent-polygon:EPSG::1030','AI','AIA',660,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1031,'Antarctica','Antarctica.',-90,-60,-180,180,'urn:ogc:def:extent-polygon:EPSG::1031','AQ','ATA',10,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2002-06-22','2002.341',0),
(1032,'Antigua and Barbuda','Antigua and Barbuda - Antigua, Barbuda and Redonda.',16.61,20.88,-62.76,-58.37,'urn:ogc:def:extent-polygon:EPSG::1032','AG','ATG',28,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1033,'Argentina','Argentina - onshore and offshore.',-58.41,-21.78,-73.59,-52.63,'urn:ogc:def:extent-polygon:EPSG::1033','AR','ARG',32,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.025',0),
(1034,'Armenia','Armenia.',38.84,41.3,43.45,46.63,'urn:ogc:def:extent-polygon:EPSG::1034','AM','ARM',51,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.095 2014.025',0),
(1035,'Aruba','Aruba - onshore and offshore.',12.14,15.42,-70.42,-69.31,'urn:ogc:def:extent-polygon:EPSG::1035','AW','ABW',533,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.025',0),
(1036,'Australia - onshore and EEZ','Australia - onshore and offshore to 200 nautical mile EEZ boundary. Includes Lord Howe Island, Ashmore and Cartier Islands.',-47.2,-8.88,109.23,163.2,'urn:ogc:def:extent-polygon:EPSG::1036','','',NULL,'','OGP','IOGP','2016-12-15','2002.341 2005.890 2012.027 2014.005 2016.054',0),
(1037,'Austria','Austria.',46.4,49.02,9.53,17.17,'urn:ogc:def:extent-polygon:EPSG::1037','AT','AUT',40,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2014.025',0),
(1038,'Azerbaijan','Azerbaijan - onshore and offshore.',37.89,42.59,44.77,51.73,'urn:ogc:def:extent-polygon:EPSG::1038','AZ','AZE',31,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1039,'Bahamas','Bahamas - onshore and offshore.',20.36,30.36,-81.22,-70.63,'urn:ogc:def:extent-polygon:EPSG::1039','BS','BHS',44,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1040,'Bahrain','Bahrain - onshore and offshore.',25.53,27.17,50.26,51.13,'urn:ogc:def:extent-polygon:EPSG::1040','BH','BHR',48,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.025',0),
(1041,'Bangladesh','Bangladesh - onshore and offshore.',18.56,26.63,88.04,92.67,'urn:ogc:def:extent-polygon:EPSG::1041','BD','BGD',50,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2012.062 2014.025',0),
(1042,'Barbados','Barbados - onshore and offshore.',10.68,16,-60.39,-55.99,'urn:ogc:def:extent-polygon:EPSG::1042','BB','BRB',52,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1043,'Belarus','Belarus.',51.25,56.17,23.16,32.75,'urn:ogc:def:extent-polygon:EPSG::1043','BY','BLR',112,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.095 2014.025',0),
(1044,'Belgium','Belgium - onshore and offshore.',49.5,51.88,2.23,6.4,'urn:ogc:def:extent-polygon:EPSG::1044','BE','BEL',56,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1045,'Belize','Belize - onshore and offshore.',15.88,18.49,-89.22,-86.11,'urn:ogc:def:extent-polygon:EPSG::1045','BZ','BLZ',84,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1046,'Benin','Benin - onshore and offshore.',2.99,12.4,0.77,3.86,'urn:ogc:def:extent-polygon:EPSG::1046','BJ','BEN',204,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1047,'Bermuda','Bermuda - onshore and offshore.',28.91,35.73,-68.83,-60.7,'urn:ogc:def:extent-polygon:EPSG::1047','BM','BMU',60,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1048,'Bhutan','Bhutan.',26.7,28.33,88.75,92.12,'urn:ogc:def:extent-polygon:EPSG::1048','BT','BTN',64,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2010.086 2012.060 2014.025',0),
(1049,'Bolivia','Bolivia.',-22.91,-9.67,-69.66,-57.52,'urn:ogc:def:extent-polygon:EPSG::1049','BO','BOL',68,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.037 2014.025',0),
(1050,'Bosnia and Herzegovina','Bosnia and Herzegovina.',42.56,45.27,15.74,19.62,'urn:ogc:def:extent-polygon:EPSG::1050','BA','BIH',70,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2008.045 2008.053 2008.054 2011.095 2014.025',0),
(1051,'Botswana','Botswana.',-26.88,-17.78,19.99,29.38,'urn:ogc:def:extent-polygon:EPSG::1051','BW','BWA',72,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2014.025',0),
(1052,'Bouvet Island','Bouvet Island - onshore and offshore.',-57.8,-51.06,-2.38,9.21,'urn:ogc:def:extent-polygon:EPSG::1052','BV','BVT',74,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.023 2014.025',0),
(1053,'Brazil','Brazil - onshore and offshore. Includes Rocas, Fernando de Noronha archipelago, Trindade, Ihlas Martim Vaz and Sao Pedro e Sao Paulo.',-35.71,7.04,-74.01,-25.28,'urn:ogc:def:extent-polygon:EPSG::1053','BR','BRA',76,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2012.044 2014.025',0),
(1054,'British Indian Ocean Territory','British Indian Ocean Territory - onshore and offshore - Chagos Archipelago.',-10.8,-2.28,67.88,75.86,'urn:ogc:def:extent-polygon:EPSG::1054','IO','IOT',86,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1055,'Brunei','Brunei Darussalam - onshore and offshore.',4.01,6.31,112.37,115.37,'urn:ogc:def:extent-polygon:EPSG::1055','BN','BRN',96,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2010.084 2012.040 2014.025',0),
(1056,'Bulgaria','Bulgaria - onshore and offshore.',41.24,44.23,22.36,31.35,'urn:ogc:def:extent-polygon:EPSG::1056','BG','BGR',100,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1057,'Burkina Faso','Burkina Faso.',9.39,15.09,-5.53,2.4,'urn:ogc:def:extent-polygon:EPSG::1057','BF','BFA',854,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2014.025',0),
(1058,'Burundi','Burundi.',-4.45,-2.3,28.98,30.86,'urn:ogc:def:extent-polygon:EPSG::1058','BI','BDI',108,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1059,'Cambodia','Cambodia - onshore and offshore.',8.78,14.71,101.33,107.64,'urn:ogc:def:extent-polygon:EPSG::1059','KH','KHM',116,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-04-18','2002.341 2005.890 2012.040',0),
(1060,'Cameroon','Cameroon - onshore and offshore.',1.65,13.09,8.32,16.21,'urn:ogc:def:extent-polygon:EPSG::1060','CM','CMR',120,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1061,'Canada','Canada - onshore and offshore - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Newfoundland and Labrador; Northwest Territories (NWT); Nova Scotia (NS); Nunavut; Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan; Yukon.',40.04,86.46,-141.01,-47.74,'urn:ogc:def:extent-polygon:EPSG::1061','CA','CAN',124,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2006.463 2011.068 2014.025',0),
(1062,'Cape Verde','Cape Verde - onshore and offshore. Includes Boa Vista, Brava, Fogo, Maio, Sal, Santo Antao, Sao Nicolau, Sao Tiago, Sao Vicente.',11.47,20.54,-28.85,-19.53,'urn:ogc:def:extent-polygon:EPSG::1062','CV','CPV',132,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1063,'Cayman Islands','Cayman Islands - onshore and offshore. Includes Grand Cayman, Little Cayman and Cayman Brac.',17.58,20.68,-83.6,-78.72,'urn:ogc:def:extent-polygon:EPSG::1063','KY','CYM',136,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1064,'Central African Republic','Central African Republic.',2.22,11.01,14.41,27.46,'urn:ogc:def:extent-polygon:EPSG::1064','CF','CAF',140,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1065,'Chad','Chad.',7.45,23.46,13.46,24.01,'urn:ogc:def:extent-polygon:EPSG::1065','TD','TCD',148,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2006.540 2012.049 2014.025',0),
(1066,'Chile','Chile - onshore and offshore. Includes Easter Island, Juan Fernandez Islands, San Felix, and Sala y Gomez.',-59.87,-17.5,-113.21,-65.72,'urn:ogc:def:extent-polygon:EPSG::1066','CL','CHL',152,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.025',0),
(1067,'China','China - onshore and offshore.',16.7,53.56,73.62,134.77,'urn:ogc:def:extent-polygon:EPSG::1067','CN','CHN',156,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.050 2014.025',0),
(1068,'Christmas Island','Christmas Island - onshore and offshore.',-13.92,-8.87,102.14,109.03,'urn:ogc:def:extent-polygon:EPSG::1068','CX','CXR',162,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','IOGP','2016-12-15','2002.341 2005.890 2012.027 2014.025 2016.054',0),
(1069,'Cocos (Keeling) Islands - onshore','Cocos (Keeling) Islands - onshore.',-12.25,-12.08,96.76,96.92,'urn:ogc:def:extent-polygon:EPSG::1069','','',NULL,'','OGP','OGP','2014-05-01','2002.341 2005.890 2012.007 2012.027 2014.025',0),
(1070,'Colombia','Colombia - onshore and offshore. Includes San Andres y Providencia, Malpelo Islands, Roncador Bank, Serrana Bank and Serranilla Bank.',-4.23,15.51,-84.77,-66.87,'urn:ogc:def:extent-polygon:EPSG::1070','CO','COL',170,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2012.044 2014.025',0),
(1071,'Comoros','Comoros - onshore and offshore. Includes Anjouan, Grande Comore, Moheli and other islands.',-14.43,-8.01,41.93,45.79,'urn:ogc:def:extent-polygon:EPSG::1071','KM','COM',174,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1072,'Congo','Congo - onshore and offshore.',-6.91,3.72,8.84,18.65,'urn:ogc:def:extent-polygon:EPSG::1072','CG','COG',178,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1073,'Cook Islands','Cook Islands - onshore and offshore.',-25.28,-5.85,-168.53,-154.8,'urn:ogc:def:extent-polygon:EPSG::1073','CK','COK',184,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1074,'Costa Rica','Costa Rica - onshore and offshore.',2.15,11.77,-90.45,-81.43,'urn:ogc:def:extent-polygon:EPSG::1074','CR','CRI',188,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1075,'Cote d''Ivoire (Ivory Coast)','Cte d''Ivoire (Ivory Coast) - onshore and offshore.',1.02,10.74,-8.61,-2.48,'urn:ogc:def:extent-polygon:EPSG::1075','CI','CIV',384,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1076,'Croatia','Croatia - onshore and offshore.',41.62,46.54,13,19.43,'urn:ogc:def:extent-polygon:EPSG::1076','HR','HRV',191,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2007.077 2011.095 2014.025',0),
(1077,'Cuba','Cuba - onshore and offshore.',18.83,25.51,-87.01,-73.57,'urn:ogc:def:extent-polygon:EPSG::1077','CU','CUB',192,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1078,'Cyprus','Cyprus - onshore and offshore.',32.88,36.21,29.95,35.2,'urn:ogc:def:extent-polygon:EPSG::1078','CY','CYP',196,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1079,'Czech Republic','Czech Republic.',48.58,51.06,12.09,18.86,'urn:ogc:def:extent-polygon:EPSG::1079','CZ','CZE',203,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.095 2014.025',0),
(1080,'Denmark','Denmark - onshore and offshore.',54.36,58.27,3.24,16.51,'urn:ogc:def:extent-polygon:EPSG::1080','DK','DNK',208,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1081,'Djibouti','Djibouti - onshore and offshore.',10.94,12.72,41.75,44.15,'urn:ogc:def:extent-polygon:EPSG::1081','DJ','DJI',262,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1082,'Dominica','Dominica - onshore and offshore.',14.48,16.62,-62.82,-57.52,'urn:ogc:def:extent-polygon:EPSG::1082','DM','DMA',212,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1083,'Dominican Republic','Dominican Republic - onshore and offshore.',14.96,22.42,-73.46,-66.82,'urn:ogc:def:extent-polygon:EPSG::1083','DO','DOM',214,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2011.069 2014.025',0),
(1084,'East Timor','Timor-Leste (East Timor) - onshore and offshore. Includes enclave of Oe-Cussi (Okusi).',-10.47,-7.97,123.92,127.97,'urn:ogc:def:extent-polygon:EPSG::1084','TL','TLS',626,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','IOGP','2016-12-15','2002.341 2005.890 2008.070 2012.057 2014.025 2016.054',0),
(1085,'Ecuador','Ecuador - onshore and offshore. Includes Galapagos Islands (Archipelago de Colon).',-5.01,5,-95.35,-75.21,'urn:ogc:def:extent-polygon:EPSG::1085','EC','ECU',218,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.025',0),
(1086,'Egypt','Egypt - onshore and offshore.',21.89,33.82,24.7,37.91,'urn:ogc:def:extent-polygon:EPSG::1086','EG','EGY',818,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.042 2014.025',0),
(1087,'El Salvador','El Salvador - onshore and offshore.',9.97,14.44,-91.43,-87.65,'urn:ogc:def:extent-polygon:EPSG::1087','SV','SLV',222,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1088,'Equatorial Guinea','Equatorial Guinea - onshore and offshore. Includes Rio Muni, Bioko, Annobon, Corisco, Elobey Chico, and Ebony Grande.',-4.8,4.13,2.26,11.36,'urn:ogc:def:extent-polygon:EPSG::1088','GQ','GNQ',226,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1089,'Eritrea','Eritrea - onshore and offshore.',12.36,18.1,36.44,43.31,'urn:ogc:def:extent-polygon:EPSG::1089','ER','ERI',232,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1090,'Estonia','Estonia - onshore and offshore.',57.52,60,20.37,28.2,'urn:ogc:def:extent-polygon:EPSG::1090','EE','EST',233,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1091,'Ethiopia','Ethiopia.',3.4,14.89,32.99,47.99,'urn:ogc:def:extent-polygon:EPSG::1091','ET','ETH',231,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1092,'Falkland Islands','Falkland Islands (Malvinas) - onshore and offshore.',-56.25,-47.68,-65.01,-52.31,'urn:ogc:def:extent-polygon:EPSG::1092','FK','FLK',238,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2011.037 2014.025',0),
(1093,'Faroe Islands','Faroe Islands - onshore and offshore.',59.94,65.7,-13.91,-0.48,'urn:ogc:def:extent-polygon:EPSG::1093','FO','FRO',234,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1094,'Fiji - onshore','Fiji - onshore. Includes Viti Levu, Vanua Levu, Taveuni, the Yasawa Group, the Kadavu Group, the Lau Islands and Rotuma Islands.',-20.81,-12.42,176.81,-178.15,'urn:ogc:def:extent-polygon:EPSG::1094','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2014-05-01','2002.341 2005.890 2006.500 2012.025 2012.048 2014.025',0),
(1095,'Finland','Finland - onshore and offshore.',58.84,70.09,19.08,31.59,'urn:ogc:def:extent-polygon:EPSG::1095','FI','FIN',246,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.112 2011.095 2014.025',0),
(1096,'France','France - onshore and offshore, mainland and Corsica.',41.15,51.56,-9.86,10.38,'urn:ogc:def:extent-polygon:EPSG::1096','FR','FRA',250,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-01-05','2002.341 2005.890 2008.030 2011.095',0),
(1097,'French Guiana','French Guiana - onshore and offshore.',2.11,8.88,-54.6,-49.46,'urn:ogc:def:extent-polygon:EPSG::1097','GF','GUF',254,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2011-05-09','2002.341 2005.890 2011.037',0),
(1098,'French Polynesia','French Polynesia - onshore and offshore. Includes Society archipelago, Tuamotu archipelago, Marquesas Islands, Gambier Islands and Austral Islands.',-31.24,-4.52,-158.13,-131.97,'urn:ogc:def:extent-polygon:EPSG::1098','PF','PYF',258,'Clipperton Island included in ISO 3166 area excluded for this OGP area as geodetically unrelated and from 2007 administrative responsibility moved to Paris.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.032 2012.048 2014.025',0),
(1099,'French Southern Territories','French Southern Territories - onshore and offshore. Includes Amsterdam and St Paul, Bassas da India, Crozet, Europa, Glorieuses, Juan de Nova, Kerguelen and Tromelin.',-53.24,-10.65,37.55,81.83,'urn:ogc:def:extent-polygon:EPSG::1099','TF','ATF',260,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.045 2012.032 2012.048 2014.025',0),
(1100,'Gabon','Gabon - onshore and offshore.',-6.37,2.32,7.03,14.52,'urn:ogc:def:extent-polygon:EPSG::1100','GA','GAB',266,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-05-08','2002.341 2005.890 2012.042',0),
(1101,'Gambia','Gambia - onshore and offshore.',13.05,13.83,-20.19,-13.79,'urn:ogc:def:extent-polygon:EPSG::1101','GM','GMB',270,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1102,'Georgia','Georgia - onshore and offshore.',41.04,43.59,38.97,46.72,'urn:ogc:def:extent-polygon:EPSG::1102','GE','GEO',268,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1103,'Germany','Germany - onshore and offshore.',47.27,55.92,3.34,15.04,'urn:ogc:def:extent-polygon:EPSG::1103','DE','DEU',276,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1104,'Ghana','Ghana - onshore and offshore.',1.4,11.16,-3.79,2.1,'urn:ogc:def:extent-polygon:EPSG::1104','GH','GHA',288,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-04-18','2002.341 2005.890 2012.049',0),
(1105,'Gibraltar','Gibraltar - onshore and offshore.',36,36.16,-5.42,-4.89,'urn:ogc:def:extent-polygon:EPSG::1105','GI','GIB',292,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1106,'Greece','Greece - onshore and offshore. Includes Aegean Islands, Ionian Islands, Dodecanese Islands, Crete, and Mount Athos.',33.26,41.75,18.26,30.23,'urn:ogc:def:extent-polygon:EPSG::1106','GR','GRC',300,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1107,'Greenland','Greenland - onshore and offshore.',56.38,87.03,-75,8.12,'urn:ogc:def:extent-polygon:EPSG::1107','GL','GRL',304,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1108,'Grenada','Grenada and southern Grenadine Islands - onshore and offshore.',11.36,13.4,-63.28,-60.82,'urn:ogc:def:extent-polygon:EPSG::1108','GD','GRD',308,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1109,'Guadeloupe','Guadeloupe - onshore and offshore. Includes Grande Terre, Basse Terre, Marie Galante, Les Saintes, Iles de la Petite Terre, La Desirade; St Barthlemy, and northern St Martin.',15.06,18.54,-63.66,-57.54,'urn:ogc:def:extent-polygon:EPSG::1109','GP','GLP',312,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2011.051 2011.068 2014.025',0),
(1110,'Guam','Guam - onshore and offshore.',10.95,15.91,141.19,148.18,'urn:ogc:def:extent-polygon:EPSG::1110','GU','GUM',316,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1111,'Guatemala','Guatemala - onshore and offshore.',10.6,17.83,-94.57,-88.16,'urn:ogc:def:extent-polygon:EPSG::1111','GT','GTM',320,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1112,'Guinea','Guinea - onshore and offshore.',7.19,12.68,-18.26,-7.65,'urn:ogc:def:extent-polygon:EPSG::1112','GN','GIN',324,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-04-18','2002.341 2005.890 2012.049',0),
(1113,'Guinea-Bissau','Guinea-Bissau - onshore and offshore.',8.64,12.69,-19.8,-13.64,'urn:ogc:def:extent-polygon:EPSG::1113','GW','GNB',624,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1114,'Guyana','Guyana - onshore and offshore.',1.18,10.7,-61.39,-55.77,'urn:ogc:def:extent-polygon:EPSG::1114','GY','GUY',328,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.025',0),
(1115,'Haiti','Haiti - onshore and offshore.',14.73,20.72,-75.73,-71.62,'urn:ogc:def:extent-polygon:EPSG::1115','HT','HTI',332,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1116,'Heard Island and McDonald Islands','Heard Island and McDonald Islands - onshore and offshore.',-59.02,-49.5,62.92,83.57,'urn:ogc:def:extent-polygon:EPSG::1116','HM','HMD',334,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-02-15','2002.341 2005.890 2012.048 2014.005',0),
(1117,'Honduras','Honduras - onshore and offshore. Includes Swan Islands.',12.98,19.59,-89.36,-79.87,'urn:ogc:def:extent-polygon:EPSG::1117','HN','HND',340,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1118,'China - Hong Kong','China - Hong Kong - onshore and offshore.',22.13,22.58,113.76,114.51,'urn:ogc:def:extent-polygon:EPSG::1118','HK','HKG',344,'"Hong Kong" in ISO 3166.','OGP','OGP','2014-05-01','2002.160 2005.890 2012.057 2014.025',0),
(1119,'Hungary','Hungary.',45.74,48.58,16.11,22.9,'urn:ogc:def:extent-polygon:EPSG::1119','HU','HUN',348,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.095 2014.025',0),
(1120,'Iceland','Iceland - onshore and offshore.',59.96,69.59,-30.87,-5.55,'urn:ogc:def:extent-polygon:EPSG::1120','IS','ISL',352,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.095 2014.025',0),
(1121,'India','India - onshore and offshore. Includes Amandivis, Laccadives, Minicoy, Andaman Islands, Nicobar Islands, and Sikkim.',3.87,35.51,65.6,97.39,'urn:ogc:def:extent-polygon:EPSG::1121','IN','IND',356,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.041 2014.025',0),
(1122,'Indonesia','Indonesia - onshore and offshore.',-13.95,7.79,92.01,141.46,'urn:ogc:def:extent-polygon:EPSG::1122','ID','IDN',360,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','IOGP','2016-12-15','2002.341 2005.890 2012.040 2014.025 2016.054',0),
(1123,'Iran','Iran - onshore and offshore.',23.34,39.78,44.03,63.34,'urn:ogc:def:extent-polygon:EPSG::1123','IR','IRN',364,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.025',0),
(1124,'Iraq','Iraq - onshore and offshore.',29.06,37.39,38.79,48.75,'urn:ogc:def:extent-polygon:EPSG::1124','IQ','IRQ',368,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.025',0),
(1125,'Ireland','Ireland - onshore and offshore.',48.18,56.57,-16.1,-5.24,'urn:ogc:def:extent-polygon:EPSG::1125','IE','IRL',372,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.025',0),
(1126,'Israel','Israel - onshore and offshore.',29.45,33.53,32.99,35.69,'urn:ogc:def:extent-polygon:EPSG::1126','IL','ISR',376,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.025',0),
(1127,'Italy','Italy - onshore and offshore.',34.76,47.1,5.93,18.99,'urn:ogc:def:extent-polygon:EPSG::1127','IT','ITA',380,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1128,'Jamaica','Jamaica - onshore and offshore. Includes Morant Cays and Pedro Cays.',14.08,19.36,-80.6,-74.51,'urn:ogc:def:extent-polygon:EPSG::1128','JM','JAM',388,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1129,'Japan','Japan - onshore and offshore.',17.09,46.05,122.38,157.65,'urn:ogc:def:extent-polygon:EPSG::1129','JP','JPN',392,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.050 2014.025',0),
(1130,'Jordan','Jordan.',29.18,33.38,34.88,39.31,'urn:ogc:def:extent-polygon:EPSG::1130','JO','JOR',400,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.057 2014.025',0),
(1131,'Kazakhstan','Kazakhstan - onshore including Caspian Sea.',40.59,55.45,46.49,87.35,'urn:ogc:def:extent-polygon:EPSG::1131','KZ','KAZ',398,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1132,'Kenya','Kenya - onshore and offshore.',-4.9,4.63,33.9,44.28,'urn:ogc:def:extent-polygon:EPSG::1132','KE','KEN',404,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1133,'Kiribati','Kiribati - onshore and offshore. Includes Fanning Island, Washington Island and Christmas in the Line Islands, Ocean Islands, Phoenix Islands.',-13.84,7.92,167.81,-146.82,'urn:ogc:def:extent-polygon:EPSG::1133','KI','KIR',296,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1134,'Korea, Democratic People''s Republic of (North Korea)','Democratic People''s Republic of Korea (North Korea) - onshore and offshore.',37.1,43.01,123.54,132.82,'urn:ogc:def:extent-polygon:EPSG::1134','KP','PRK',408,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2012.050 2014.025',0),
(1135,'Korea, Republic of (South Korea)','Republic of Korea (South Korea) - onshore and offshore.',28.6,40.27,122.71,134.28,'urn:ogc:def:extent-polygon:EPSG::1135','KR','KOR',410,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2012.057 2014.025',0),
(1136,'Kuwait','Kuwait - onshore and offshore.',28.53,30.09,46.54,49.53,'urn:ogc:def:extent-polygon:EPSG::1136','KW','KWT',414,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.025',0),
(1137,'Kyrgyzstan','Kyrgyzstan.',39.19,43.22,69.24,80.29,'urn:ogc:def:extent-polygon:EPSG::1137','KG','KGZ',417,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.112 2014.025',0),
(1138,'Laos','Laos.',13.92,22.5,100.09,107.7,'urn:ogc:def:extent-polygon:EPSG::1138','LA','LAO',418,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.040 2014.025',0),
(1139,'Latvia','Latvia - onshore and offshore.',55.67,58.09,19.06,28.24,'urn:ogc:def:extent-polygon:EPSG::1139','LV','LVA',428,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1140,'Lebanon','Lebanon - onshore and offshore.',33.06,34.84,33.75,36.63,'urn:ogc:def:extent-polygon:EPSG::1140','LB','LBN',422,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.025',0),
(1141,'Lesotho','Lesotho.',-30.66,-28.57,27.01,29.46,'urn:ogc:def:extent-polygon:EPSG::1141','LS','LSO',426,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1142,'Liberia','Liberia - onshore and offshore.',1.02,8.52,-13.59,-7.36,'urn:ogc:def:extent-polygon:EPSG::1142','LR','LBR',430,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1143,'Libya','Libya - onshore and offshore.',19.5,35.23,9.31,26.21,'urn:ogc:def:extent-polygon:EPSG::1143','LY','LBY',434,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-04-18','2002.341 2005.890 2012.049',0),
(1144,'Liechtenstein','Liechtenstein.',47.05,47.28,9.47,9.64,'urn:ogc:def:extent-polygon:EPSG::1144','LI','LIE',438,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.112 2014.025',0),
(1145,'Lithuania','Lithuania - onshore and offshore.',53.89,56.45,19.02,26.82,'urn:ogc:def:extent-polygon:EPSG::1145','LT','LTU',440,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1146,'Luxembourg','Luxembourg.',49.44,50.19,5.73,6.53,'urn:ogc:def:extent-polygon:EPSG::1146','LU','LUX',442,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.112 2014.025',0),
(1147,'China - Macao','China - Macao - onshore and offshore.',22.06,22.23,113.52,113.68,'urn:ogc:def:extent-polygon:EPSG::1147','MO','MAC',446,'"Macao" in ISO 3166.','OGP','OGP','2014-05-01','2002.341 2005.890 2007.072 2012.050 2014.025',0),
(1148,'Macedonia','The Former Yugoslav Republic of Macedonia.',40.85,42.36,20.45,23.04,'urn:ogc:def:extent-polygon:EPSG::1148','MK','MKD',807,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2008.070 2011.112 2014.025',0),
(1149,'Madagascar - onshore and nearshore','Madagascar - onshore and nearshore.',-26.59,-11.69,42.53,51.03,'urn:ogc:def:extent-polygon:EPSG::1149','','',NULL,'','OGP','OGP','2012-04-18','2002.341 2005.890 2012.025 2012.048',0),
(1150,'Malawi','Malawi.',-17.14,-9.37,32.68,35.93,'urn:ogc:def:extent-polygon:EPSG::1150','MW','MWI',454,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1151,'Malaysia','Malaysia - onshore and offshore. Includes peninsular Malayasia, Sabah and Sarawak.',0.85,7.81,98.02,119.61,'urn:ogc:def:extent-polygon:EPSG::1151','MY','MYS',458,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2006.253 2012.040 2014.025',0),
(1152,'Maldives','Maldives - onshore and offshore.',-3.47,8.1,69.29,77.08,'urn:ogc:def:extent-polygon:EPSG::1152','MV','MDV',462,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1153,'Mali','Mali.',10.14,25.01,-12.25,4.26,'urn:ogc:def:extent-polygon:EPSG::1153','ML','MLI',466,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1154,'Malta','Malta - onshore and offshore.',34.49,36.56,13.41,18.06,'urn:ogc:def:extent-polygon:EPSG::1154','MT','MLT',470,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1155,'Marshall Islands','Marshall Islands - onshore and offshore.',1.77,17.88,157.47,175.52,'urn:ogc:def:extent-polygon:EPSG::1155','MH','MHL',584,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2013.022 2014.025',0),
(1156,'Martinique','Martinique - onshore and offshore.',14.08,16.36,-62.82,-57.52,'urn:ogc:def:extent-polygon:EPSG::1156','MQ','MTQ',474,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1157,'Mauritania','Mauritania - onshore and offshore.',14.72,27.3,-20.04,-4.8,'urn:ogc:def:extent-polygon:EPSG::1157','MR','MRT',478,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1158,'Mauritius','Mauritius - onshore and offshore. Includes Rodrigues, Agalega Islands, and Cargados Carajos.',-23.81,-8.43,53.8,67.05,'urn:ogc:def:extent-polygon:EPSG::1158','MU','MUS',480,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1159,'Mayotte','Mayotte - onshore and offshore.',-14.49,-11.33,43.68,46.7,'urn:ogc:def:extent-polygon:EPSG::1159','YT','MYT',175,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1160,'Mexico','Mexico - onshore and offshore.',12.1,32.72,-122.19,-84.64,'urn:ogc:def:extent-polygon:EPSG::1160','MX','MEX',484,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1161,'Micronesia','Federated States of Micronesia - onshore and offshore. Includes Caroline Islands, Yap, Truk, Ponape, Kosrae.',-1.19,13.43,135.27,165.68,'urn:ogc:def:extent-polygon:EPSG::1161','FM','FSM',583,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.054 2008.070 2012.048 2014.025',0),
(1162,'Moldova','Moldova.',45.44,48.47,26.63,30.13,'urn:ogc:def:extent-polygon:EPSG::1162','MD','MDA',498,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2008.070 2009.026 2011.112 2014.025',0),
(1163,'Monaco','Monaco - onshore and offshore.',42.94,43.77,7.39,7.76,'urn:ogc:def:extent-polygon:EPSG::1163','MC','MCO',492,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1164,'Mongolia','Mongolia.',41.58,52.15,87.76,119.94,'urn:ogc:def:extent-polygon:EPSG::1164','MN','MNG',496,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.050 2014.025',0),
(1165,'Montserrat','Montserrat - onshore and offshore.',15.84,17.04,-63.05,-61.82,'urn:ogc:def:extent-polygon:EPSG::1165','MS','MSR',500,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1166,'Morocco','Morocco - onshore and offshore.',27.66,36,-13.86,-1.01,'urn:ogc:def:extent-polygon:EPSG::1166','MA','MAR',504,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1167,'Mozambique','Mozambique - onshore and offshore.',-27.71,-10.09,30.21,43.03,'urn:ogc:def:extent-polygon:EPSG::1167','MZ','MOZ',508,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1168,'Myanmar (Burma)','Myanmar (Burma) - onshore and offshore.',9.48,28.55,89.61,101.17,'urn:ogc:def:extent-polygon:EPSG::1168','MM','MMR',104,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/isoISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2014.025',0),
(1169,'Namibia','Namibia - onshore and offshore.',-30.64,-16.95,8.24,25.27,'urn:ogc:def:extent-polygon:EPSG::1169','NA','NAM',516,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1170,'Nauru','Nauru - onshore and offshore.',-3.91,2.69,163.58,168.6,'urn:ogc:def:extent-polygon:EPSG::1170','NR','NRU',520,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1171,'Nepal','Nepal.',26.36,30.43,80.05,88.2,'urn:ogc:def:extent-polygon:EPSG::1171','NP','NPL',524,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.050 2014.025',0),
(1172,'Netherlands','Netherlands - onshore and offshore.',50.75,55.77,2.53,7.22,'urn:ogc:def:extent-polygon:EPSG::1172','NL','NLD',528,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.082 2014.025',0),
(1173,'Netherlands Antilles','Netherlands Antilles - onshore and offshore. Includes Bonaire, Curacao, Saba, St Eustatius, and southern St Martin',11.67,18.07,-69.59,-62.82,'','AN','ANT',530,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2006-02-01','2002.341 2005.890 2011.015',1),
(1174,'New Caledonia','New Caledonia - onshore and offshore. Isle de Pins, Loyalty Islands, Huon Islands, Belep archipelago, Chesterfield Islands, and Walpole.',-26.45,-14.83,156.25,174.28,'urn:ogc:def:extent-polygon:EPSG::1174','NC','NCL',540,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','IOGP','2016-12-15','2002.341 2005.890 2012.048 2014.025 2016.054',0),
(1175,'New Zealand','New Zealand - onshore and offshore. Includes Antipodes Islands, Auckland Islands, Bounty Islands, Chatham Islands, Cambell Island, Kermadec Islands, Raoul Island and Snares Islands.',-55.95,-25.88,160.6,-171.2,'urn:ogc:def:extent-polygon:EPSG::1175','NZ','NZL',554,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso and Land Information New Zealand.','IOGP','2016-12-15','2002.341 2005.890 2008.023 2012.027 2014.025 2016.054',0),
(1176,'Nicaragua','Nicaragua - onshore and offshore.',9.75,16.26,-89.43,-79.76,'urn:ogc:def:extent-polygon:EPSG::1176','NI','NIC',558,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1177,'Niger','Niger.',11.69,23.53,0.16,16,'urn:ogc:def:extent-polygon:EPSG::1177','NE','NER',562,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1178,'Nigeria','Nigeria - onshore and offshore.',1.92,13.9,2.66,14.65,'urn:ogc:def:extent-polygon:EPSG::1178','NG','NGA',566,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.025',0),
(1179,'Niue','Niue - onshore and offshore.',-22.49,-16.58,-172.01,-166.31,'urn:ogc:def:extent-polygon:EPSG::1179','NU','NIU',570,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1180,'Norfolk Island','Norfolk Island - onshore and offshore.',-32.48,-25.61,163.36,173.35,'urn:ogc:def:extent-polygon:EPSG::1180','NF','NFK',574,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','IOGP','2016-12-15','2002.341 2005.890 2012.048 2014.005 2016.054',0),
(1181,'Northern Mariana Islands','Northern Mariana Islands - onshore and offshore.',12.38,23.9,141.33,149.55,'urn:ogc:def:extent-polygon:EPSG::1181','MP','MNP',580,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1182,'Norway','Norway including Svalbard - onshore and offshore.',56.08,84.17,-3.7,39.65,'urn:ogc:def:extent-polygon:EPSG::1182','NO','NOR',578,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1183,'Oman','Oman - onshore and offshore.',14.33,26.74,51.99,63.38,'urn:ogc:def:extent-polygon:EPSG::1183','OM','OMN',512,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.042 2012.051 2014.025',0),
(1184,'Pakistan','Pakistan - onshore and offshore.',21.05,37.07,60.86,77.83,'urn:ogc:def:extent-polygon:EPSG::1184','PK','PAK',586,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2014.025',0),
(1185,'Palau','Palau - onshore and offshore.',1.64,11.45,129.48,136.98,'urn:ogc:def:extent-polygon:EPSG::1185','PW','PLW',585,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1186,'Panama','Panama - onshore and offshore.',5,12.51,-84.32,-77.04,'urn:ogc:def:extent-polygon:EPSG::1186','PA','PAN',591,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.025',0),
(1187,'Papua New Guinea','Papua New Guinea - onshore and offshore. Includes Bismark archipelago, Louisade archipelago, Admiralty Islands, d''Entrecasteaux Islands, northern Solomon Islands, Trobriand Islands, New Britain, New Ireland, Woodlark, and associated islands.',-14.75,2.58,139.2,162.81,'urn:ogc:def:extent-polygon:EPSG::1187','PG','PNG',598,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','IOGP','2016-12-15','2002.341 2005.890 2011.059 2012.027 2014.025 2016.054',0),
(1188,'Paraguay','Paraguay.',-27.59,-19.29,-62.65,-54.24,'urn:ogc:def:extent-polygon:EPSG::1188','PY','PRY',600,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.037 2014.025',0),
(1189,'Peru','Peru - onshore and offshore.',-21.05,-0.03,-84.68,-68.67,'urn:ogc:def:extent-polygon:EPSG::1189','PE','PER',604,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2012.044 2014.025',0),
(1190,'Philippines','Philippines - onshore and offshore.',3,22.18,116.04,129.95,'urn:ogc:def:extent-polygon:EPSG::1190','PH','PHL',608,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2014.025',0),
(1191,'Pitcairn','Pitcairn - Pitcairn Island, Henderson Island, Ducie Island and Oeno Atoll.',-28.41,-20.58,-133.43,-121.11,'urn:ogc:def:extent-polygon:EPSG::1191','PN','PCN',612,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.025',0),
(1192,'Poland','Poland - onshore and offshore.',49,55.93,14.14,24.15,'urn:ogc:def:extent-polygon:EPSG::1192','PL','POL',616,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.025',0),
(1193,'Portugal','Portugal - mainland, Azores and Madeira, onshore and offshore.',29.24,43.07,-35.58,-6.19,'urn:ogc:def:extent-polygon:EPSG::1193','PT','PRT',620,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.025',0),
(1194,'Puerto Rico','Puerto Rico - onshore and offshore.',14.92,21.86,-68.49,-65.04,'urn:ogc:def:extent-polygon:EPSG::1194','PR','PRI',630,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2009.063 2011.068 2014.025',0),
(1195,'Qatar','Qatar - onshore and offshore.',24.55,27.05,50.55,53.04,'urn:ogc:def:extent-polygon:EPSG::1195','QA','QAT',634,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.025',0),
(1196,'Reunion','Reunion - onshore and offshore - Reunion island, Ile Europa, Bassas da India, Juan de Nova, Iles Glorieuses, and Ile Tromelin.',-25.92,-10.6,37.58,58.27,'','RE','REU',638,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2006-02-01','2002.341 2005.890 2012.025',1),
(1197,'Romania','Romania - onshore and offshore.',43.44,48.27,20.26,31.41,'urn:ogc:def:extent-polygon:EPSG::1197','RO','ROU',642,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.025',0),
(1198,'Russia','Russian Federation - onshore and offshore.',39.87,85.2,18.92,-168.97,'urn:ogc:def:extent-polygon:EPSG::1198','RU','RUS',643,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.062 2011.087 2014.025',0),
(1199,'Rwanda','Rwanda.',-2.83,-1.05,28.85,30.9,'urn:ogc:def:extent-polygon:EPSG::1199','RW','RWA',646,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.025',0),
(1200,'St Kitts and Nevis','St Kitts and Nevis - onshore and offshore.',16.34,17.67,-63.63,-62.2,'urn:ogc:def:extent-polygon:EPSG::1200','KN','KNA',659,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.024',0),
(1201,'St Lucia','St Lucia - onshore and offshore.',13.23,14.28,-62.5,-59.99,'urn:ogc:def:extent-polygon:EPSG::1201','LC','LCA',662,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2011.068 2014.024',0),
(1202,'St Vincent and the Grenadines','St Vincent and the northern Grenadine Islands - onshore and offshore.',12.03,14.09,-63.38,-60.28,'urn:ogc:def:extent-polygon:EPSG::1202','VC','VCT',670,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2011.068 2014.024',0),
(1203,'Samoa','Samoa - onshore and offshore.',-15.84,-10.94,-174.54,-170.51,'urn:ogc:def:extent-polygon:EPSG::1203','WS','WSM',882,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2012.048 2014.024',0),
(1204,'San Marino','San Marino.',43.89,43.99,12.4,12.52,'urn:ogc:def:extent-polygon:EPSG::1204','SM','SMR',674,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.112 2014.024',0),
(1205,'Sao Tome and Principe','Sao Tome and Principe - onshore and offshore.',-1.49,2.72,3.2,8.56,'urn:ogc:def:extent-polygon:EPSG::1205','ST','STP',678,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1206,'Saudi Arabia','Saudi Arabia - onshore and offshore.',15.61,32.16,34.44,55.67,'urn:ogc:def:extent-polygon:EPSG::1206','SA','SAU',682,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.024',0),
(1207,'Senegal','Senegal - onshore and offshore.',10.64,16.7,-20.22,-11.36,'urn:ogc:def:extent-polygon:EPSG::1207','SN','SEN',686,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1208,'Seychelles','Seychelles - onshore and offshore - Alphonse, Bijoutier, St Francois Islands, St Pierre islet, Cosmoledo Islands, Amirantes, Aldabra, Farquhar, and Desroches.',-12.72,-0.37,43.19,59.66,'urn:ogc:def:extent-polygon:EPSG::1208','SC','SYC',690,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.024',0),
(1209,'Sierra Leone','Sierra Leone - onshore and offshore.',4.22,10,-16.57,-10.26,'urn:ogc:def:extent-polygon:EPSG::1209','SL','SLE',694,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1210,'Singapore','Singapore - onshore and offshore.',1.13,1.47,103.59,104.07,'urn:ogc:def:extent-polygon:EPSG::1210','SG','SGP',702,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2014.024',0),
(1211,'Slovakia','Slovakia.',47.73,49.61,16.84,22.56,'urn:ogc:def:extent-polygon:EPSG::1211','SK','SVK',703,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2008.070 2011.113 2014.024',0),
(1212,'Slovenia','Slovenia - onshore and offshore.',45.42,46.88,13.38,16.61,'urn:ogc:def:extent-polygon:EPSG::1212','SI','SVN',705,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.024',0),
(1213,'Solomon Islands - onshore main islands','Solomon Islands - onshore southern Solomon Islands, primarily Guadalcanal, Malaita, San Cristobel, Santa Isobel, Choiseul, Makira-Ulawa.',-10.9,-6.55,155.62,162.44,'urn:ogc:def:extent-polygon:EPSG::1213','','',NULL,'','OGP','OGP','2014-05-01','2002.341 2005.890 2012.025 2012.058 2014.024',0),
(1214,'Somalia','Somalia - onshore and offshore.',-3.61,13.5,40.98,54.43,'urn:ogc:def:extent-polygon:EPSG::1214','SO','SOM',706,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1215,'South Africa','South Africa - onshore and offshore, including Marion Island, and Prince Edward Island.',-50.32,-22.13,13.33,42.85,'urn:ogc:def:extent-polygon:EPSG::1215','ZA','ZAF',710,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1216,'South Georgia and the South Sandwich Islands','South Georgia and the South Sandwich Islands - onshore and offshore.',-62.79,-50.15,-48.06,-19.84,'urn:ogc:def:extent-polygon:EPSG::1216','GS','SGS',239,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.023 2014.024',0),
(1217,'Spain','Spain - mainland, Balearic Islands, Canary Islands, Ceuta and Melila - onshore and offshore.',24.6,46.26,-21.93,6.3,'urn:ogc:def:extent-polygon:EPSG::1217','ES','ESP',724,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.024',0),
(1218,'Sri Lanka','Sri Lanka - onshore and offshore.',2.58,11.45,77.02,85.24,'urn:ogc:def:extent-polygon:EPSG::1218','LK','LKA',144,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2014.024',0),
(1219,'St Helena, Ascension and Tristan da Cunha','St Helena, Ascension and Tristan da Cunha archipelago (Gough, Inaccessible, Nightingale and Stoltenhoff Islands) - onshore and offshore.',-43.71,-4.55,-17.79,-2.16,'urn:ogc:def:extent-polygon:EPSG::1219','SH','SHN',654,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2011.015 2012.023 2014.024',0),
(1220,'St Pierre and Miquelon','St Pierre and Miquelon - onshore and offshore.',43.41,47.37,-57.1,-55.9,'urn:ogc:def:extent-polygon:EPSG::1220','PM','SPM',666,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2011.068 2014.024',0),
(1221,'Sudan','Sudan - onshore and offshore.',8.64,22.24,21.82,39.76,'urn:ogc:def:extent-polygon:EPSG::1221','SD','SDN',729,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.001 2012.049 2014.024',0),
(1222,'Suriname','Suriname - onshore and offshore.',1.83,9.35,-58.08,-52.66,'urn:ogc:def:extent-polygon:EPSG::1222','SR','SUR',740,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.024',0),
(1223,'Svalbard and Jan Mayen','Svalbard and Jan Mayen - onshore and offshore. Includes Bear Island.',66.24,85.05,-16.22,35.02,'','SJ','SJM',744,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2006-02-01','2002.341 2005.890 2011.112',1),
(1224,'Swaziland','Swaziland',-27.32,-25.72,30.79,32.14,'urn:ogc:def:extent-polygon:EPSG::1224','SZ','SWZ',748,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.024',0),
(1225,'Sweden','Sweden - onshore and offshore.',54.96,69.07,10.03,24.17,'urn:ogc:def:extent-polygon:EPSG::1225','SE','SWE',752,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.112 2014.024',0),
(1226,'Switzerland','Switzerland.',45.82,47.81,5.96,10.49,'urn:ogc:def:extent-polygon:EPSG::1226','CH','CHE',756,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.113 2014.024',0),
(1227,'Syria','Syria - onshore and offshore.',32.31,37.3,34.96,42.38,'urn:ogc:def:extent-polygon:EPSG::1227','SY','SYR',760,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.024',0),
(1228,'Taiwan','Taiwan, Republic of China - onshore and offshore - Taiwan Island, Penghu (Pescadores) Islands.',17.36,26.96,114.32,123.61,'urn:ogc:def:extent-polygon:EPSG::1228','TW','TWN',158,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.017 2008.070 2012.050 2014.024',0),
(1229,'Tajikistan','Tajikistan.',36.67,41.05,67.36,75.19,'urn:ogc:def:extent-polygon:EPSG::1229','TJ','TJK',762,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-01-05','2002.341 2011.113',0),
(1230,'Tanzania','Tanzania - onshore and offshore.',-11.75,-0.99,29.34,43.29,'urn:ogc:def:extent-polygon:EPSG::1230','TZ','TZA',834,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1231,'Thailand','Thailand - onshore and offshore.',5.63,20.46,95.52,105.64,'urn:ogc:def:extent-polygon:EPSG::1231','TH','THA',764,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2014.024',0),
(1232,'Togo','Togo - onshore and offshore.',2.91,11.14,-0.15,2.42,'urn:ogc:def:extent-polygon:EPSG::1232','TG','TGO',768,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1233,'Tokelau','Tokelau - onshore and offshore.',-11.04,-6.46,-175.86,-167.98,'urn:ogc:def:extent-polygon:EPSG::1233','TK','TKL',772,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.024',0),
(1234,'Tonga','Tonga - onshore and offshore.',-25.68,-14.14,-179.08,-171.28,'urn:ogc:def:extent-polygon:EPSG::1234','TO','TON',776,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.058 2014.024',0),
(1235,'Trinidad and Tobago','Trinidad and Tobago - onshore and offshore.',9.83,12.34,-62.09,-57.28,'urn:ogc:def:extent-polygon:EPSG::1235','TT','TTO',780,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.024',0),
(1236,'Tunisia','Tunisia - onshore and offshore.',30.23,38.41,7.49,13.67,'urn:ogc:def:extent-polygon:EPSG::1236','TN','TUN',788,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1237,'Turkey','Turkey - onshore and offshore.',34.42,43.45,25.62,44.83,'urn:ogc:def:extent-polygon:EPSG::1237','TR','TUR',792,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.024',0),
(1238,'Turkmenistan','Turkmenistan - onshore and offshore.',35.14,42.8,51.3,66.68,'urn:ogc:def:extent-polygon:EPSG::1238','TM','TKM',795,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.024',0),
(1239,'Turks and Caicos Islands','Turks and Caicos Islands - onshore and offshore.',20.54,25.07,-72.82,-67.66,'urn:ogc:def:extent-polygon:EPSG::1239','TC','TCA',796,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.068 2014.024',0),
(1240,'Tuvalu','Tuvalu - onshore and offshore. Funafuti, Nanumanga, Nui, Nanomea, Nurakita, Niutao, Nukufetau, Nukulaelae, and Vaitupu.',-13.24,-4,172.73,-176.71,'urn:ogc:def:extent-polygon:EPSG::1240','TV','TUV',798,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.024',0),
(1241,'Uganda','Uganda.',-1.48,4.23,29.57,35.01,'urn:ogc:def:extent-polygon:EPSG::1241','UG','UGA',800,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.024',0),
(1242,'Ukraine','Ukraine - onshore and offshore.',43.18,52.38,22.15,40.18,'urn:ogc:def:extent-polygon:EPSG::1242','UA','UKR',804,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.113 2014.024',0),
(1243,'UAE','United Arab Emirates (UAE) - onshore and offshore. Abu Dhabi, Dubai, Sharjah, Umm al Qaywayn, Al Fujairah, Ras al Khaymah.',22.63,26.27,51.5,57.13,'urn:ogc:def:extent-polygon:EPSG::1243','AE','ARE',784,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2007.010 2008.070 2012.047 2014.024',0),
(1244,'UK','United Kingdom (UK) - onshore and offshore - England, Scotland including Orkney and Shetland Islands, Wales, Northern Ireland (Ulster).',47.42,63.89,-14.89,3.4,'urn:ogc:def:extent-polygon:EPSG::1244','GB','GBR',826,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','IOGP','2016-07-13','2002.341 2005.890 2007.072 2008.070 2011.113 2015.069',0),
(1245,'USA','United States (USA) - onshore and offshore.',15.56,74.71,167.65,-65.69,'urn:ogc:def:extent-polygon:EPSG::1245','US','USA',840,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2008.070 2011.068 2014.024',0),
(1246,'United States Minor Outlying Islands','United States Minor Outlying Islands - onshore and offshore - Baker Island, Howland Islands, Jarvis Island, Johnston Atoll, Kingman Reef, Midway Islands, Palmyra Islands, and Wake Island.',-3.74,31.8,163.07,-157.41,'urn:ogc:def:extent-polygon:EPSG::1246','UM','UMI',581,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2012-04-18','2002.341 2005.890 2012.048',0),
(1247,'Uruguay','Uruguay - onshore and offshore.',-37.77,-30.09,-58.49,-50.01,'urn:ogc:def:extent-polygon:EPSG::1247','UY','URY',858,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2014.024',0),
(1248,'Uzbekistan','Uzbekistan.',37.18,45.58,55.99,73.17,'urn:ogc:def:extent-polygon:EPSG::1248','UZ','UZB',860,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.113 2014.024',0),
(1249,'Vanuatu','Vanuatu - onshore and offshore.',-21.65,-12.27,163.16,173.59,'urn:ogc:def:extent-polygon:EPSG::1249','VU','VUT',548,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2006.510 2012.032 2012.048 2014.024',0),
(1250,'Holy See (Vatican City State)','Holy See (Vatican City State).',41.9,41.91,12.44,12.46,'urn:ogc:def:extent-polygon:EPSG::1250','VA','VAT',336,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2011.112 2014.024',0),
(1251,'Venezuela','Venezuela - onshore and offshore.',0.64,16.75,-73.38,-58.95,'urn:ogc:def:extent-polygon:EPSG::1251','VE','VEN',862,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2011.037 2012.044 2014.024',0),
(1252,'Vietnam','Vietnam - onshore and offshore.',5.67,23.33,102.14,112.55,'urn:ogc:def:extent-polygon:EPSG::1252','VN','VNM',704,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.040 2014.024',0),
(1253,'Virgin Islands, British','British Virgin Islands - onshore and offshore - Anegada, Jost Van Dyke, Tortola, and Virgin Gorda.',17.96,22.09,-65.85,-63.29,'urn:ogc:def:extent-polygon:EPSG::1253','VG','VGB',92,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2009.063 2011.068 2014.024',0),
(1254,'Virgin Islands, US','US Virgin Islands - onshore and offshore - St Croix, St John, and St Thomas.',16.22,21.83,-66.05,-63.88,'urn:ogc:def:extent-polygon:EPSG::1254','VI','VIR',850,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2009.063 2011.068 2014.024',0),
(1255,'Wallis and Futuna','Wallis and Futuna - onshore and offshore - Uvea, Futuna, and Alofi.',-15.94,-9.84,179.49,-174.27,'urn:ogc:def:extent-polygon:EPSG::1255','WF','WLF',876,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.048 2014.024',0),
(1256,'Western Sahara','Western Sahara - onshore and offshore.',18.98,27.67,-20.68,-8.66,'urn:ogc:def:extent-polygon:EPSG::1256','EH','ESH',732,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.049 2014.024',0),
(1257,'Yemen','Yemen - onshore and offshore.',8.95,19,41.08,57.96,'urn:ogc:def:extent-polygon:EPSG::1257','YE','YEM',887,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.051 2014.024',0),
(1258,'Yugoslavia - Serbia and Montenegro','Yugoslavia - Union of Serbia and Montenegro - onshore and offshore.',41.82,46.23,18.44,23.05,'','YU','YUG',891,'','OGP','OGP','2006-02-01','2002.341 2003.060 2005.890',1),
(1259,'Congo DR (Zaire)','The Democratic Republic of the Congo (Zaire) - onshore and offshore.',-13.46,5.39,11.79,31.31,'urn:ogc:def:extent-polygon:EPSG::1259','CD','COD',180,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2005.890 2012.042 2014.024',0),
(1260,'Zambia','Zambia.',-18.08,-8.19,21.99,33.71,'urn:ogc:def:extent-polygon:EPSG::1260','ZM','ZMB',894,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.024',0),
(1261,'Zimbabwe','Zimbabwe.',-22.42,-15.61,25.23,33.08,'urn:ogc:def:extent-polygon:EPSG::1261','ZW','ZWE',716,'','ISO 3166 Maintenance Agency. ftp://ftp.fu-berlin.de/pub/doc/iso','OGP','2014-05-01','2002.341 2012.049 2014.024',0),
(1262,'World','World.',-90,90,-180,180,'urn:ogc:def:extent-polygon:EPSG::1262','','',NULL,'','OGP','OGP','2001-06-05','',0),
(1263,'Not specified','Not specified.',-90,90,-180,180,'','','',NULL,'','OGP','OGP','2000-06-23','',0),
(1264,'UK - Great Britain; Isle of Man','United Kingdom (UK) - Great Britain - England and Wales onshore, Scotland onshore and Western Isles nearshore; Isle of Man onshore.',49.79,60.94,-8.82,1.92,'urn:ogc:def:extent-polygon:EPSG::1264','','',NULL,'','OGP','IOGP','2016-07-13','2005.880 2008.070 2010.019 2011.062 2011.082 2014.024 2015.069',0),
(1265,'Argentina - Comodoro Rivadavia','Argentina - Comodoro Rivadavia area.',-46.7,-45.19,-69.5,-67.1,'urn:ogc:def:extent-polygon:EPSG::1265','','',NULL,'','OGP','OGP','2014-05-01','2005.890 2014.024',0),
(1266,'Venezuela - Puerto La Cruz','Venezuela - Puerto La Cruz area.',10,10.31,-64.7,-64.5,'urn:ogc:def:extent-polygon:EPSG::1266','','',NULL,'','OGP','OGP','2011-05-09','2011.037',0),
(1267,'Venezuela - Barinas','Venezuela - Barinas area.',7.31,9.07,-71.49,-67.58,'urn:ogc:def:extent-polygon:EPSG::1267','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.024',0),
(1268,'Venezuela - Falcon state','Venezuela - Falcon state.',10.3,12.25,-71.3,-68.19,'urn:ogc:def:extent-polygon:EPSG::1268','','',NULL,'','OGP','OGP','2011-05-09','2011.037',0),
(1269,'Venezuela - Pedregal area of Falcon state','Venezuela - Pedregal area of Falcon state.',10.8,11.26,-70.4,-69.69,'urn:ogc:def:extent-polygon:EPSG::1269','','',NULL,'','OGP','OGP','2014-05-01','2014.024',0),
(1270,'Venezuela - Maracaibo south','Venezuela - south Maracaibo area.',8.72,10.01,-72.4,-70.78,'urn:ogc:def:extent-polygon:EPSG::1270','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.024',0),
(1271,'Africa - Eritrea, Ethiopia, South Sudan and Sudan','Eritrea; Ethiopia; South Sudan; Sudan.',3.4,22.24,21.82,47.99,'urn:ogc:def:extent-polygon:EPSG::1271','','',NULL,'','OGP','OGP','2014-05-01','2002.810 2012.001 2014.024',0),
(1272,'Asia - Middle East - Bahrain, Kuwait and Saudi Arabia','Bahrain, Kuwait and Saudi Arabia - onshore.',15.61,32.16,34.51,55.67,'urn:ogc:def:extent-polygon:EPSG::1272','','',NULL,'','OGP','OGP','2014-05-01','2006.090 2012.051 2014.024',0),
(1273,'Antigua - onshore','Antigua island - onshore.',16.94,17.22,-61.95,-61.61,'urn:ogc:def:extent-polygon:EPSG::1273','','',NULL,'','OGP','OGP','2014-05-01','2011.068 2011.069 2014.024',0),
(1274,'Brazil - Aratu','Brazil - offshore south and east of a line intersecting the coast at 255''S; onshore Tucano basin.',-35.71,4.26,-53.38,-26,'urn:ogc:def:extent-polygon:EPSG::1274','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2010.039 2010.046 2011.037 2014.024',0),
(1275,'Netherlands - onshore','Netherlands - onshore, including Waddenzee, Dutch Wadden Islands and 12-mile offshore coastal zone.',50.75,53.7,3.2,7.22,'urn:ogc:def:extent-polygon:EPSG::1275','','',NULL,'','OGP','OGP','2014-05-01','2009.046 2011.082 2012.013 2014.024',0),
(1276,'Africa - Botswana, Malawi, Zambia, Zimbabwe','Botswana; Malawi; Zambia; Zimbabwe.',-26.88,-8.19,19.99,35.93,'urn:ogc:def:extent-polygon:EPSG::1276','','',NULL,'','OGP','OGP','2014-05-01','2014.024',0),
(1277,'Africa - Kenya, Tanzania and Uganda','Kenya; Tanzania; Uganda.',-11.75,4.63,29.34,41.91,'urn:ogc:def:extent-polygon:EPSG::1277','','',NULL,'','OGP','OGP','2014-05-01','2014.024',0),
(1278,'Antarctica - Australian sector','Antarctica between 45E and 136E and between 142E and 160E - Australian sector.',-90,-60,45,160,'urn:ogc:def:extent-polygon:EPSG::1278','','',NULL,'','OGP','OGP','2012-05-26','2012.023 2012.060',0),
(1279,'Australasia - Australia and PNG - AGD66','Australia - onshore and offshore. Papua New Guinea - onshore.',-47.2,-1.3,109.23,163.2,'urn:ogc:def:extent-polygon:EPSG::1279','','',NULL,'This area is the union of areas 1036 and 3291.','OGP','IOGP','2016-12-15','2009.106 2012.015 2014.024 2016.054',0),
(1280,'Australia - Western Australia','Australia - Western Australia.',-35.19,-13.67,112.85,129.01,'urn:ogc:def:extent-polygon:EPSG::1280','','',NULL,'','OGP','OGP','2014-05-01','2012.027 2014.024',0),
(1281,'Australia - mainland','Australia - Australian Capital Territory; New South Wales; Northern Territory; Queensland; South Australia; Western Australia; Victoria.',-39.2,-10.65,112.85,153.69,'urn:ogc:def:extent-polygon:EPSG::1281','','',NULL,'','OGP','OGP','2014-05-01','2007.009 2012.027 2014.024',0),
(1282,'Australia - Tasmania','Australia - Tasmania including islands - onshore.',-43.7,-39.52,143.77,148.55,'urn:ogc:def:extent-polygon:EPSG::1282','','',NULL,'','OGP','OGP','2014-05-01','2007.052 2012.007 2012.027 2014.024',0),
(1283,'Canada - Maritime Provinces','Canada - New Brunswick; Nova Scotia; Prince Edward Island.',43.41,48.07,-69.05,-59.73,'urn:ogc:def:extent-polygon:EPSG::1283','','',NULL,'','OGP','OGP','2014-05-01','2011.068 2014.024',0),
(1284,'Europe - FSU, Czechoslovakia - onshore','Armenia; Azerbaijan; Belarus; Czech Republic; Estonia - onshore; Georgia - onshore; Kazakhstan; Kyrgyzstan; Latvia - onshore; Lithuania - onshore; Moldova; Russian Federation - onshore; Slovakia; Tajikistan; Turkmenistan; Ukraine - onshore; Uzbekistan.',35.14,77.79,12.09,-169.57,'urn:ogc:def:extent-polygon:EPSG::1284','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2014-05-01','2006.380 2008.054 2010.064 2011.055 2011.082 2012.013 2014.024',0),
(1285,'Indonesia - Java and Bali onshore','Indonesia - onshore Java and Bali.',-8.91,-5.83,105.06,115.77,'urn:ogc:def:extent-polygon:EPSG::1285','','',NULL,'','OGP','OGP','2014-05-01','2012.032 2012.057 2014.024',0),
(1286,'Europe - Liechtenstein and Switzerland','Liechtenstein; Switzerland.',45.82,47.81,5.96,10.49,'urn:ogc:def:extent-polygon:EPSG::1286','','',NULL,'','OGP','OGP','2014-05-01','2014.024',0),
(1287,'Indonesia - Banga & Belitung Islands','Indonesia - Banga and Belitung Islands.',-3.3,-1.44,105.07,108.35,'urn:ogc:def:extent-polygon:EPSG::1287','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.040 2014.024',0),
(1288,'Angola - Angola proper','Angola - Angola proper - onshore and offshore.',-18.02,-5.82,8.2,24.09,'urn:ogc:def:extent-polygon:EPSG::1288','','',NULL,'','OGP','OGP','2014-05-01','2012.042 2014.024',0),
(1289,'Canada - CGVD28','Canada - onshore - Alberta; British Columbia; Manitoba south of 57N; New Brunswick; Northwest Territories south west of a line between 60N, 110W and the coast at 132W; Nova Scotia; Ontario south of 52N; Prince Edward Island; Quebec - mainland west of 66W and south of 55N; Saskatchewan south of 55N; Yukon.',41.67,69.8,-141.01,-59.73,'urn:ogc:def:extent-polygon:EPSG::1289','','',NULL,'','OGP','OGP','2014-05-01','2011.051 2011.069 2012.091 2013.064 2014.024',0),
(1290,'Africa - Botswana, Lesotho, South Africa and Swaziland','Botswana; Lesotho; South Africa - mainland; Swaziland.',-34.88,-17.78,16.45,32.95,'urn:ogc:def:extent-polygon:EPSG::1290','','',NULL,'','OGP','OGP','2014-05-01','2011.078 2012.042 2014.024',0),
(1291,'Asia - FSU - Caspian Sea','Azerbaijan - offshore; Kazakhstan - offshore; Russian Federation - Caspian Sea; Turkmenistan - offshore.',37.35,46.97,46.95,53.93,'urn:ogc:def:extent-polygon:EPSG::1291','','',NULL,'','OGP','OGP','2014-05-01','2011.082 2014.024',0),
(1292,'Argentina - Neuquen province','Argentina - Neuquen province.',-41.1,-36.14,-71.96,-68.01,'urn:ogc:def:extent-polygon:EPSG::1292','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.024',0),
(1293,'Brazil - Corrego Alegre 1970-1972','Brazil - onshore - west of 54W and south of 18S; also south of 15S between 54W and 42W; also east of 42W.',-33.78,-2.68,-58.16,-34.74,'urn:ogc:def:extent-polygon:EPSG::1293','','',NULL,'','Ajustamento da Rede Planimetrica do SGB, IBGE.','OGP','2011-07-27','2005.841 2008.045 2010.046 2011.037 2011.053',0),
(1294,'Portugal - mainland - onshore','Portugal - mainland - onshore.',36.95,42.16,-9.56,-6.19,'urn:ogc:def:extent-polygon:EPSG::1294','','',NULL,'','OGP','OGP','2014-05-01','2007.096 2011.113 2014.024',0),
(1295,'Germany - DHDN','Germany - onshore - Baden-Wurtemberg, Bayern, Hessen, Niedersachsen, Nordrhein-Westfalen, Rheinland-Pfalz, Saarland, Schleswig-Holstein. Also former DDR states of Sachsen and Thuringen by transformation.',47.27,55.06,5.87,15.03,'','','',NULL,'','OGP','OGP','2001-06-05','',1),
(1296,'Europe - ED50 by country','Europe - west: Andorra; Cyprus; Denmark - onshore and offshore; Faroe Islands - onshore; France - offshore; Germany - offshore North Sea; Gibraltar; Greece - offshore; Israel - offshore; Italy including San Marino and Vatican City State; Ireland offshore; Malta; Netherlands - offshore; North Sea; Norway including Svalbard - onshore and offshore; Portugal - mainland - offshore; Spain - onshore; Turkey - onshore and offshore; United Kingdom UKCS offshore east of 6W including Channel Islands (Guernsey and Jersey). Egypt - Western Desert; Iraq - onshore; Jordan.',25.71,84.17,-16.1,48.61,'urn:ogc:def:extent-polygon:EPSG::1296','','',NULL,'','OGP','OGP','2014-05-01','2003.141 2004.150 2004.630 2005.460 2005.471 2005.890 2007.096 2009.033 2011.004 2011.055 2011.082 2014.024',0),
(1297,'Europe - west','Europe - west.',34.88,71.21,-10.56,31.59,'urn:ogc:def:extent-polygon:EPSG::1297','','',NULL,'','OGP','OGP','2014-05-01','2005.890 2011.082 2014.024',0),
(1298,'Europe - ETRS89','Europe - onshore and offshore: Albania; Andorra; Austria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia; Cyprus; Czech Republic; Denmark; Estonia; Faroe Islands; Finland; France; Germany; Gibraltar; Greece; Hungary; Ireland; Italy; Latvia; Liechtenstein; Lithuania; Luxembourg; Macedonia; Malta; Moldova; Monaco; Montenegro; Netherlands; Norway including Svalbard and Jan Mayen; Poland; Portugal; Romania; San Marino; Serbia; Slovakia; Slovenia; Spain; Sweden; Switzerland; Ukraine; United Kingdom (UK) including Channel Islands and Isle of Man; Vatican City State.',32.88,84.17,-16.1,40.18,'urn:ogc:def:extent-polygon:EPSG::1298','','',NULL,'','OGP','IOGP','2016-12-15','2005.890 2007.072 2011.004 2011.082 2014.024 2016.058',0),
(1299,'Europe - EVRF2000','Europe - onshore - Andorra; Austria; Belgium; Bosnia and Herzegovina; Croatia; Czech Republic; Denmark; Estonia; Finland; France - mainland; Germany; Gibraltar; Hungary; Italy - mainland and Sicily; Latvia; Liechtenstein; Lithuania; Luxembourg; Netherlands; Norway; Poland; Portugal; Romania; San Marino; Slovakia; Slovenia; Spain - mainland; Sweden; Switzerland; United Kingdom (UK) - Great Britain mainland; Vatican City State.',35.95,71.21,-9.56,31.59,'urn:ogc:def:extent-polygon:EPSG::1299','','',NULL,'','OGP','OGP','2015-01-28','2005.890 2011.055 2011.082 2012.013 2014.024 2014.095',0),
(1300,'Iran - FD58','Iran - Arwaz area and onshore Gulf coast west of 54E.',26.74,33.22,47.13,53.61,'urn:ogc:def:extent-polygon:EPSG::1300','','',NULL,'','OGP','OGP','2014-05-01','2012.032 2012.051 2014.024',0),
(1301,'Portugal - Azores C - onshore','Portugal - central Azores onshore - Faial, Graciosa, Pico, Sao Jorge, Terceira.',38.32,39.14,-28.9,-26.97,'urn:ogc:def:extent-polygon:EPSG::1301','','',NULL,'Superset of areas 2872, 2873, 2874, 2875 and 3681.','OGP','OGP','2012-01-05','2010.006 2011.062 2011.113',0),
(1302,'Asia - Cambodia and Vietnam - mainland','Cambodia - mainland onshore; Vietnam - mainland onshore.',8.5,23.33,102.14,109.52,'urn:ogc:def:extent-polygon:EPSG::1302','','',NULL,'','OGP','OGP','2014-05-01','2012.046 2014.024',0),
(1303,'South America - Tierra del Fuego','Argentina and Chile - Tierra del Fuego, onshore.',-55.96,-51.99,-74.83,-65.05,'urn:ogc:def:extent-polygon:EPSG::1303','','',NULL,'','OGP','OGP','2014-11-19','2011.037 2014.024 2014.082',0),
(1304,'Asia - Myanmar and Thailand onshore','Myanmar (Burma) - onshore; Thailand - onshore.',5.63,28.55,92.2,105.64,'urn:ogc:def:extent-polygon:EPSG::1304','','',NULL,'','OGP','OGP','2011-01-25','2011.004',0),
(1305,'Europe - Ireland (Republic and Ulster) - onshore','Ireland - onshore. United Kingdom (UK) - Northern Ireland (Ulster) - onshore.',51.39,55.43,-10.56,-5.34,'urn:ogc:def:extent-polygon:EPSG::1305','','',NULL,'','OGP','OGP','2014-05-01','2011.082 2014.024',0),
(1306,'Europe - Czechoslovakia','Czech Republic; Slovakia.',47.73,51.06,12.09,22.56,'urn:ogc:def:extent-polygon:EPSG::1306','','',NULL,'','OGP','OGP','2014-05-01','2014.024',0),
(1307,'Asia - Bangladesh; India; Myanmar; Pakistan - onshore','Bangladesh - onshore; India - mainland onshore; Myanmar (Burma) - onshore; Pakistan - onshore.',8.02,37.07,60.86,101.17,'urn:ogc:def:extent-polygon:EPSG::1307','','',NULL,'','OGP','OGP','2014-05-01','2004.290 2012.041 2014.024',0),
(1308,'Asia - Bangladesh; India; Pakistan - onshore','Bangladesh - onshore; India - mainland onshore; Pakistan - onshore.',8.02,37.07,60.86,97.39,'urn:ogc:def:extent-polygon:EPSG::1308','','',NULL,'','OGP','OGP','2014-05-01','2012.041 2014.024',0),
(1309,'Asia - Malaysia (west) and Singapore','Malaysia - West Malaysia; Singapore.',1.13,6.72,99.59,104.6,'urn:ogc:def:extent-polygon:EPSG::1309','','',NULL,'','OGP','OGP','2014-05-01','2012.040 2014.024',0),
(1310,'Kuwait - Kuwait City','Kuwait - Kuwait City.',29.17,29.45,47.78,48.16,'urn:ogc:def:extent-polygon:EPSG::1310','','',NULL,'','OGP','OGP','2014-05-01','2012.051 2014.024',0),
(1311,'Venezuela - Cabimas','Venezuela - Cabimas area.',10.14,10.61,-71.55,-71.29,'urn:ogc:def:extent-polygon:EPSG::1311','','',NULL,'','OGP','OGP','2014-05-01','2011.004 2014.024',0),
(1312,'Venezuela - Lake Maracaibo','Venezuela - Lake Maracaibo area, onshore and offshore in lake.',8.72,11.04,-72.4,-70.78,'urn:ogc:def:extent-polygon:EPSG::1312','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.024',0),
(1313,'Venezuela - north of 745''N','Venezuela - onshore north of approximately 745''N.',7.75,12.25,-73.38,-59.8,'urn:ogc:def:extent-polygon:EPSG::1313','','',NULL,'','OGP','OGP','2013-07-21','2010.097 2011.037 2012.044',0),
(1314,'Portugal - Madeira archipelago onshore','Portugal - Madeira, Porto Santo and Desertas islands - onshore.',32.35,33.15,-17.31,-16.23,'urn:ogc:def:extent-polygon:EPSG::1314','','',NULL,'','OGP','OGP','2014-05-01','2010.006 2011.062 2011.064 2011.113 2014.024',0),
(1315,'Mozambique - west - Tete province','Mozambique - west - Tete province.',-17.76,-14.01,30.21,35.37,'urn:ogc:def:extent-polygon:EPSG::1315','','',NULL,'','OGP','OGP','2012-04-18','2012.049',0),
(1316,'Indonesia - Sulawesi SW','Indonesia - south west Sulawesi.',-6.54,-1.88,118.71,120.78,'urn:ogc:def:extent-polygon:EPSG::1316','','',NULL,'','OGP','OGP','2014-05-01','2012.040 2014.024',0),
(1317,'Angola - Cabinda offshore','Angola - Cabinda offshore.',-6.04,-5.05,10.53,12.18,'urn:ogc:def:extent-polygon:EPSG::1317','','',NULL,'','OGP','OGP','2014-05-01','2012.042 2014.024',0),
(1318,'Angola - Cabinda','Angola - Cabinda.',-6.04,-4.38,10.53,13.1,'urn:ogc:def:extent-polygon:EPSG::1318','','',NULL,'','OGP','OGP','2014-05-01','2012.042 2014.024',0),
(1319,'Venezuela - Maracaibo area','Venezuela - Maracaibo area, onshore and offshore in lake.',10,11,-72.25,-71.5,'urn:ogc:def:extent-polygon:EPSG::1319','','',NULL,'','OGP','OGP','2011-05-09','2011.037',0),
(1320,'Venezuela - Maturin','Venezuela - Maturin area.',9.1,10.13,-64.3,-63,'urn:ogc:def:extent-polygon:EPSG::1320','','',NULL,'','OGP','OGP','2000-03-07','',0),
(1321,'Europe - Austria and former Yugoslavia onshore','Austria. Bosnia and Herzegovina. Croatia - onshore. FYR Macedonia. Montenegro - onshore. Serbia. Slovenia - onshore.',40.85,49.02,9.53,23.04,'urn:ogc:def:extent-polygon:EPSG::1321','','',NULL,'','OGP','OGP','2014-05-01','2007.072 2008.045 2008.053 2008.054 2011.055 2011.082 2014.024',0),
(1322,'Trinidad and Tobago - Tobago - onshore','Trinidad and Tobago - Tobago - onshore.',11.09,11.4,-60.9,-60.47,'urn:ogc:def:extent-polygon:EPSG::1322','','',NULL,'','OGP','OGP','2014-05-01','2009.106 2011.037 2014.024',0),
(1323,'USA - CONUS - onshore','United States (USA) - onshore - Alabama; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',24.41,49.38,-124.79,-66.91,'urn:ogc:def:extent-polygon:EPSG::1323','','',NULL,'','OGP','IOGP','2016-12-15','2008.070 2011.043 2011.069 2014.024 2016.056',0),
(1324,'USA (all states)','United States (USA) - onshore and offshore - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Hawaii; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',15.56,74.71,167.65,-65.69,'urn:ogc:def:extent-polygon:EPSG::1324','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2014-05-01','2008.070 2011.043 2014.024',0),
(1325,'North America - Canada and USA (CONUS, Alaska mainland)','North America - onshore and offshore: Canada - Alberta; British Columbia; Manitoba; New Brunswick; Newfoundland and Labrador; Northwest Territories; Nova Scotia; Nunavut; Ontario; Prince Edward Island; Quebec; Saskatchewan; Yukon. United States (USA) - Alabama; Alaska (mainland); Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',23.81,86.46,-172.54,-47.74,'urn:ogc:def:extent-polygon:EPSG::1325','','',NULL,'','OGP','OGP','2014-05-01','2006.462 2006.463 2007.028 2009.108 2011.043 2014.024',0),
(1326,'France - mainland onshore','France - mainland onshore.',42.33,51.14,-4.87,8.23,'urn:ogc:def:extent-polygon:EPSG::1326','','',NULL,'','OGP','OGP','2012-01-05','2011.055 2011.095',0),
(1327,'France - Corsica onshore','France - Corsica onshore.',41.31,43.07,8.5,9.63,'urn:ogc:def:extent-polygon:EPSG::1327','','',NULL,'','OGP','OGP','2014-05-01','2011.055 2011.095 2014.024',0),
(1328,'Indonesia - Kalimantan - Mahakam delta','Indonesia - east Kalimantan - Mahakam delta coastal and offshore shelf areas.',-1.24,0,116.72,117.99,'urn:ogc:def:extent-polygon:EPSG::1328','','',NULL,'','OGP','OGP','2014-05-01','2012.032 2012.040 2012.060 2014.024',0),
(1329,'Mozambique - south','Mozambique - south.',-26.87,-19.84,31.29,35.65,'urn:ogc:def:extent-polygon:EPSG::1329','','',NULL,'','OGP','OGP','2014-05-01','2012.049 2014.024',0),
(1330,'USA - Alaska','United States (USA) - Alaska.',51.3,71.4,172.42,-129.99,'urn:ogc:def:extent-polygon:EPSG::1330','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2014-05-01','2008.070 2011.068 2014.024',0),
(1331,'USA - Alaska - St. George Island','United States (USA) - Alaska - Pribilof Islands - St George Island.',56.49,56.67,-169.88,-169.38,'urn:ogc:def:extent-polygon:EPSG::1331','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.068 2014.024',0),
(1332,'USA - Alaska - St. Lawrence Island','United States (USA) - Alaska - St Lawrence Island.',62.89,63.84,-171.97,-168.59,'urn:ogc:def:extent-polygon:EPSG::1332','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.068 2014.024',0),
(1333,'USA - Alaska - St. Paul Island','United States (USA) - Alaska - Pribilof Islands - St Paul Island.',57.06,57.28,-170.51,-170.04,'urn:ogc:def:extent-polygon:EPSG::1333','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.068 2014.024',0),
(1334,'USA - Hawaii - onshore','United States (USA) - Hawaii - main islands onshore.',18.87,22.29,-160.3,-154.74,'urn:ogc:def:extent-polygon:EPSG::1334','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.043 2014.024',0),
(1335,'Caribbean - Puerto Rico and Virgin Islands - onshore','Puerto Rico, US Virgin Islands and British Virgin Islands - onshore.',17.62,18.78,-67.97,-64.25,'urn:ogc:def:extent-polygon:EPSG::1335','','',NULL,'This area is an aggregation of discontinuous areas codes 3294, 3329 and 3330.','OGP','OGP','2014-05-01','2009.063 2011.068 2014.024',0),
(1336,'Canada - CSRS98','Canada - Alberta; New Brunswick; Saskatchewan; Prince Edward Island; and Quebec.',44.61,62.56,-120,-57.1,'','','',NULL,'','OGP','OGP','2000-10-19','',1),
(1337,'USA - HARN','Onshore only: American Samoa - Tutuila, Aunu''u, Ofu, Olesega, Ta''u and Rose islands. Guam. Puerto Rico. United States (USA) - Alabama; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Hawaii; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming. US Virgin Islands.',-14.59,49.38,144.58,-64.51,'urn:ogc:def:extent-polygon:EPSG::1337','','',NULL,'Area crosses 180-degree meridian. This area is an aggregation of discontinuous areas codes 3110, 3255, 3294, 3330, 1323 and 1334.','National Geodetic Survey','IOGP','2016-12-15','2001.600 2004.230 2004.750 2005.230 2005.891 2008.070 2009.044 2011.043 2014.024 2016.056',0),
(1338,'Iran - Taheri refinery','Iran - Taheri refinery site.',27.39,27.61,52.5,52.71,'urn:ogc:def:extent-polygon:EPSG::1338','','',NULL,'','OGP','OGP','2014-05-01','2014.024',0),
(1339,'Trinidad and Tobago - Trinidad','Trinidad and Tobago - Trinidad - onshore and offshore.',9.83,11.51,-62.09,-60,'urn:ogc:def:extent-polygon:EPSG::1339','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.024',0),
(1340,'Yemen - South Yemen - mainland','Yemen - South Yemen onshore mainland.',12.54,19,43.37,53.14,'urn:ogc:def:extent-polygon:EPSG::1340','','',NULL,'','OGP','OGP','2014-05-01','2012.022 2012.051 2014.024',0),
(1341,'South America by country','South America - Argentina, Brazil, Bolivia, Chile, Colombia, Ecuador, French Guiana, Guyana, Paraguay, Peru, Suriname, Uruguay, Venezuela.',-56.15,13,-82,-34,'','','',NULL,'','OGP','OGP','2000-10-19','2011.021',1),
(1342,'Sierra Leone - Freetown Peninsula','Sierra Leone - Freetown Peninsula.',8.32,8.55,-13.34,-13.13,'urn:ogc:def:extent-polygon:EPSG::1342','','',NULL,'','OGP','OGP','2014-05-01','2012.049 2014.024',0),
(1343,'Germany - East Germany all states','Germany - states of former East Germany - Berlin, Brandenburg; Mecklenburg-Vorpommern; Sachsen; Sachsen-Anhalt; Thuringen.',50.2,54.74,9.92,15.04,'urn:ogc:def:extent-polygon:EPSG::1343','','',NULL,'','OGP','OGP','2014-05-01','2011.012 2011.082 2014.024',0),
(1344,'Portugal - Azores W - onshore','Portugal - western Azores onshore - Flores, Corvo.',39.3,39.77,-31.34,-31.02,'urn:ogc:def:extent-polygon:EPSG::1344','','',NULL,'Superset of areas 3684 and 3685.','OGP','OGP','2014-05-01','2010.006 2011.062 2011.113 2014.024',0),
(1345,'Portugal - Azores E - onshore','Portugal - eastern Azores onshore - Sao Miguel, Santa Maria, Formigas.',36.87,37.96,-25.92,-24.62,'urn:ogc:def:extent-polygon:EPSG::1345','','',NULL,'Superset of areas 2871 and 3683.','OGP','OGP','2014-05-01','2010.006 2011.062 2011.113 2013.010 2014.024',0),
(1346,'Qatar - onshore','Qatar - onshore.',24.55,26.2,50.69,51.68,'urn:ogc:def:extent-polygon:EPSG::1346','','',NULL,'','OGP','OGP','2014-05-01','2012.051 2014.024',0),
(1347,'Belgium - onshore','Belgium - onshore.',49.5,51.51,2.5,6.4,'urn:ogc:def:extent-polygon:EPSG::1347','','',NULL,'','OGP','OGP','2014-05-01','2011.095 2014.024',0),
(1348,'South America - PSAD56 by country','Aruba - onshore; Bolivia; Bonaire - onshore; Brazil - offshore - Amazon Cone shelf; Chile - onshore north of 4330''S; Curacao - onshore; Ecuador - mainland onshore; Guyana - onshore; Peru - onshore; Venezuela - onshore.',-43.5,12.68,-81.41,-47.99,'urn:ogc:def:extent-polygon:EPSG::1348','','',NULL,'','OGP','OGP','2014-11-21','2005.144 2006.480 2010.097 2011.037 2012.044 2014.024 2014.082 2014.083',0),
(1349,'North America - NAD27','North and central America: Antigua and Barbuda. Bahamas. Belize. British Virgin Islands. Canada - Alberta; British Columbia; Manitoba; New Brunswick; Newfoundland and Labrador; Northwest Territories; Nova Scotia; Nunavut; Ontario; Prince Edward Island; Quebec; Saskatchewan; Yukon. Cuba. El Salvador. Guatemala. Honduras. Puerto Rico. Mexico. Nicaragua. United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming. US Virgin Islands. Usage shall be onshore only except that onshore and offshore shall apply to Canada east coast (New Brunswick; Newfoundland and Labrador; Prince Edward Island; Quebec). Cuba. Mexico (Gulf of Mexico and Caribbean coasts only). USA Alaska. USA Gulf of Mexico (Alabama; Florida; Louisiana; Mississippi; Texas). USA East Coast. Bahamas onshore plus offshore over internal continental shelf only.',7.98,83.17,167.65,-47.74,'urn:ogc:def:extent-polygon:EPSG::1349','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2014-05-01','2006.463 2007.028 2009.063 2010.088 2011.043 2014.024',0),
(1350,'North America - NAD83','North America - onshore and offshore: Canada - Alberta; British Columbia; Manitoba; New Brunswick; Newfoundland and Labrador; Northwest Territories; Nova Scotia; Nunavut; Ontario; Prince Edward Island; Quebec; Saskatchewan; Yukon. Puerto Rico. United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Hawaii; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming. US Virgin Islands. British Virgin Islands.',14.92,86.46,167.65,-47.74,'urn:ogc:def:extent-polygon:EPSG::1350','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2014-05-01','2006.462 2006.463 2006.464 2007.028 2009.064 2011.043 2014.024',0),
(1351,'Asia - Middle East - Qatar offshore and UAE','Arabian Gulf; Qatar - offshore; United Arab Emirates (UAE) - Abu Dhabi; Dubai; Sharjah; Ajman; Fujairah; Ras Al Kaimah; Umm Al Qaiwain - onshore and offshore.',22.63,27.05,50.55,57.13,'urn:ogc:def:extent-polygon:EPSG::1351','','',NULL,'Adjustment included Gulf coast area of Saudi Arabia but geodetic entities not in use there.','OGP','OGP','2015-02-12','2006.340 2012.004 2012.051 2014.024 2014.070',0),
(1352,'Norway - onshore','Norway - onshore.',57.93,71.21,4.68,31.22,'urn:ogc:def:extent-polygon:EPSG::1352','','',NULL,'','OGP','OGP','2014-05-01','2009.105 2011.112 2014.024',0),
(1353,'France - onshore','France - onshore.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2000-03-07','',1),
(1354,'Europe - British Isles - UK and Ireland onshore','Ireland - onshore. United Kingdom (UK) - onshore - England; Scotland; Wales; Northern Ireland. Isle of Man.',49.81,60.9,-10.56,1.84,'urn:ogc:def:extent-polygon:EPSG::1354','','',NULL,'','OGP','OGP','2014-05-01','2011.055 2011.082 2014.024',0),
(1355,'Indonesia - Sumatra','Indonesia - Sumatra.',-5.99,5.97,95.16,106.13,'urn:ogc:def:extent-polygon:EPSG::1355','','',NULL,'','OGP','OGP','2014-05-01','2012.040 2014.024',0),
(1356,'Asia - Middle East - Israel, Jordan and Palestine onshore','Israel - onshore; Jordan; Palestine Territory - onshore.',29.18,33.38,34.17,39.31,'urn:ogc:def:extent-polygon:EPSG::1356','','',NULL,'','OGP','OGP','2014-05-01','2002.340 2011.004 2012.051 2014.024',0),
(1357,'Europe - eastern and FSU','Albania; Bulgaria; Czech Republic; Germany (former DDR); Hungary; Poland; Romania; Slovakia. Armenia; Azerbaijan; Belarus; Estonia; Georgia; Kazakhstan; Kyrgyzstan; Latvia; Lithuania; Moldova; Russian Federation; Tajikistan; Turkmenistan; Ukraine; Uzbekistan.',35.1,78,9.87,-169.73,'','','',NULL,'Countries forming the former Warsaw Pact and FSU. Area crosses 180-degree meridian.','OGP','OGP','2008-09-24','2006.380 2008.011 2009.060',1),
(1358,'South America - SAD69 by country','Brazil - onshore and offshore. In rest of South America - onshore north of approximately 45S and Tierra del Fuego.',-55.96,12.52,-81.41,-25.28,'urn:ogc:def:extent-polygon:EPSG::1358','','',NULL,'','OGP','OGP','2014-11-21','2008.045 2010.097 2011.037 2011.053 2012.070 2014.024 2014.082 2014.083',0),
(1359,'Indonesia - Kalimantan SE','Indonesia - Kalimantan - onshore southeast coastal area including Mahakam delta coastal and offshore shelf areas.',-4.24,0,114.55,117.99,'urn:ogc:def:extent-polygon:EPSG::1359','','',NULL,'','OGP','OGP','2014-05-01','2012.032 2012.040 2014.024',0),
(1360,'Indonesia - Kalimantan E','Indonesia - Kalimantan - onshore east coastal area including Mahakam delta coastal and offshore shelf areas.',-4.24,4.29,114.55,119.06,'urn:ogc:def:extent-polygon:EPSG::1360','','',NULL,'','OGP','OGP','2014-05-01','2012.032 2012.040 2014.024',0),
(1361,'Sudan - south','Sudan - south.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','1995-06-02','',1),
(1362,'Asia - Brunei and East Malaysia','Brunei - onshore and offshore; Malaysia - East Malaysia (Sabah; Sarawak) - onshore and offshore.',0.85,7.67,109.31,119.61,'urn:ogc:def:extent-polygon:EPSG::1362','','',NULL,'','OGP','OGP','2014-05-01','2012.040 2014.024',0),
(1363,'UAE - Abu Dhabi and Dubai - onshore','United Arab Emirates (UAE) - Abu Dhabi onshore and Dubai onshore.',22.63,25.34,51.56,56.03,'urn:ogc:def:extent-polygon:EPSG::1363','','',NULL,'','OGP','OGP','2015-02-12','2007.010 2008.070 2012.047 2014.024 2012.056',0),
(1364,'Asia - Japan and Korea','Japan - onshore; North Korea - onshore; South Korea - onshore.',20.37,45.54,122.83,154.05,'urn:ogc:def:extent-polygon:EPSG::1364','','',NULL,'','OGP','OGP','2014-05-01','2012.050 2014.024',0),
(1365,'Algeria - north of 32N','Algeria - onshore north of 32N.',31.99,37.14,-2.95,9.09,'urn:ogc:def:extent-polygon:EPSG::1365','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.024',0),
(1366,'Africa - Algeria, Morocco and Tunisia','Algeria; Morocco; Tunisia.',18.98,37.34,-13.17,11.99,'','','',NULL,'','OGP','OGP','2000-10-19','2011.004',1),
(1367,'Canada - Ontario','Canada - Ontario.',41.67,56.9,-95.16,-74.35,'urn:ogc:def:extent-polygon:EPSG::1367','','',NULL,'','OGP','OGP','2014-05-01','2011.068 2014.024',0),
(1368,'Canada - Quebec','Canada - Quebec.',44.99,62.62,-79.85,-57.1,'urn:ogc:def:extent-polygon:EPSG::1368','','',NULL,'','OGP','OGP','2014-05-01','2011.069 2014.024',0),
(1369,'France - Alsace','France - Alsace.',47.42,49.07,6.84,8.23,'urn:ogc:def:extent-polygon:EPSG::1369','','',NULL,'','OGP','OGP','2014-05-01','2011.095 2014.024',0),
(1370,'Venezuela - Deltana','Venezuela - Deltana area.',7.89,10.46,-62.8,-59.8,'urn:ogc:def:extent-polygon:EPSG::1370','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.024',0),
(1371,'Venezuela - Guarico state','Venezuela - Guarico state.',7.54,10.03,-68,-64.76,'urn:ogc:def:extent-polygon:EPSG::1371','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.024',0),
(1372,'USA - Alabama','United States (USA) - Alabama.',30.14,35.02,-88.48,-84.89,'urn:ogc:def:extent-polygon:EPSG::1372','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1373,'USA - Arizona','United States (USA) - Arizona.',31.33,37.01,-114.81,-109.04,'urn:ogc:def:extent-polygon:EPSG::1373','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1374,'USA - Arkansas','United States (USA) - Arkansas.',33.01,36.5,-94.62,-89.64,'urn:ogc:def:extent-polygon:EPSG::1374','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1375,'USA - California','United States (USA) - California.',32.53,42.01,-124.45,-114.12,'urn:ogc:def:extent-polygon:EPSG::1375','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1376,'USA - Colorado','United States (USA) - Colorado.',36.98,41.01,-109.06,-102.03,'urn:ogc:def:extent-polygon:EPSG::1376','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1377,'USA - Connecticut','United States (USA) - Connecticut - counties of Fairfield; Hartford; Litchfield; Middlesex; New Haven; New London; Tolland; Windham.',40.98,42.05,-73.73,-71.78,'urn:ogc:def:extent-polygon:EPSG::1377','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1378,'USA - Delaware','United States (USA) - Delaware - counties of Kent; New Castle; Sussex.',38.44,39.85,-75.8,-74.97,'urn:ogc:def:extent-polygon:EPSG::1378','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1379,'USA - Florida','United States (USA) - Florida.',24.41,31.01,-87.63,-79.97,'urn:ogc:def:extent-polygon:EPSG::1379','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1380,'USA - Georgia','United States (USA) - Georgia.',30.36,35.01,-85.61,-80.77,'urn:ogc:def:extent-polygon:EPSG::1380','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1381,'USA - Idaho','United States (USA) - Idaho.',41.99,49.01,-117.24,-111.04,'urn:ogc:def:extent-polygon:EPSG::1381','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1382,'USA - Illinois','United States (USA) - Illinois.',36.98,42.51,-91.52,-87.02,'urn:ogc:def:extent-polygon:EPSG::1382','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2011.069 2014.024 2015.029',0),
(1383,'USA - Indiana','United States (USA) - Indiana.',37.77,41.77,-88.06,-84.78,'urn:ogc:def:extent-polygon:EPSG::1383','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2012.060 2014.024 2015.029',0),
(1384,'USA - Iowa','United States (USA) - Iowa.',40.37,43.51,-96.65,-90.14,'urn:ogc:def:extent-polygon:EPSG::1384','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2014.024 2015.044',0),
(1385,'USA - Kansas','United States (USA) - Kansas.',36.98,40.01,-102.06,-94.6,'urn:ogc:def:extent-polygon:EPSG::1385','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1386,'USA - Kentucky','United States (USA) - Kentucky.',36.49,39.15,-89.57,-81.95,'urn:ogc:def:extent-polygon:EPSG::1386','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2011.069 2014.024 2015.029',0),
(1387,'USA - Louisiana','United States (USA) - Louisiana.',28.85,33.03,-94.05,-88.75,'urn:ogc:def:extent-polygon:EPSG::1387','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1388,'USA - Maine','United States (USA) - Maine.',43.04,47.47,-71.09,-66.91,'urn:ogc:def:extent-polygon:EPSG::1388','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1389,'USA - Maryland','United States (USA) - Maryland - counties of Allegany; Anne Arundel; Baltimore; Calvert; Caroline; Carroll; Cecil; Charles; Dorchester; Frederick; Garrett; Harford; Howard; Kent; Montgomery; Prince Georges; Queen Annes; Somerset; St Marys; Talbot; Washington; Wicomico; Worcester.',37.97,39.73,-79.49,-74.97,'urn:ogc:def:extent-polygon:EPSG::1389','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1390,'USA - Massachusetts','United States (USA) - Massachusetts.',41.19,42.89,-73.5,-69.86,'urn:ogc:def:extent-polygon:EPSG::1390','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1391,'USA - Michigan','United States (USA) - Michigan.',41.69,48.32,-90.42,-82.13,'urn:ogc:def:extent-polygon:EPSG::1391','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2014.024 2015.029',0),
(1392,'USA - Minnesota','United States (USA) - Minnesota.',43.49,49.38,-97.22,-89.49,'urn:ogc:def:extent-polygon:EPSG::1392','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2012.060 2014.024 2015.044',0),
(1393,'USA - Mississippi','United States (USA) - Mississippi.',30.01,35.01,-91.65,-88.09,'urn:ogc:def:extent-polygon:EPSG::1393','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.024',0),
(1394,'USA - Missouri','United States (USA) - Missouri.',35.98,40.61,-95.77,-89.1,'urn:ogc:def:extent-polygon:EPSG::1394','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1395,'USA - Montana','United States (USA) - Montana - counties of Beaverhead; Big Horn; Blaine; Broadwater; Carbon; Carter; Cascade; Chouteau; Custer; Daniels; Dawson; Deer Lodge; Fallon; Fergus; Flathead; Gallatin; Garfield; Glacier; Golden Valley; Granite; Hill; Jefferson; Judith Basin; Lake; Lewis and Clark; Liberty; Lincoln; Madison; McCone; Meagher; Mineral; Missoula; Musselshell; Park; Petroleum; Phillips; Pondera; Powder River; Powell; Prairie; Ravalli; Richland; Roosevelt; Rosebud; Sanders; Sheridan; Silver Bow; Stillwater; Sweet Grass; Teton; Toole; Treasure; Valley; Wheatland; Wibaux; Yellowstone.',44.35,49.01,-116.07,-104.04,'urn:ogc:def:extent-polygon:EPSG::1395','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2012.060 2014.024',0),
(1396,'USA - Nebraska','United States (USA) - Nebraska - counties of Adams; Antelope; Arthur; Banner; Blaine; Boone; Box Butte; Boyd; Brown; Buffalo; Burt; Butler; Cass; Cedar; Chase; Cherry; Cheyenne; Clay; Colfax; Cuming; Custer; Dakota; Dawes; Dawson; Deuel; Dixon; Dodge; Douglas; Dundy; Fillmore; Franklin; Frontier; Furnas; Gage; Garden; Garfield; Gosper; Grant; Greeley; Hall; Hamilton; Harlan; Hayes; Hitchcock; Holt; Hooker; Howard; Jefferson; Johnson; Kearney; Keith; Keya Paha; Kimball; Knox; Lancaster; Lincoln; Logan; Loup; Madison; McPherson; Merrick; Morrill; Nance; Nemaha; Nuckolls; Otoe; Pawnee; Perkins; Phelps; Pierce; Platte; Polk; Red Willow; Richardson; Rock; Saline; Sarpy; Saunders; Scotts Bluff; Seward; Sheridan; Sherman; Sioux; Stanton; Thayer; Thomas; Thurston; Valley; Washington; Wayne; Webster; Wheeler; York.',39.99,43.01,-104.06,-95.3,'urn:ogc:def:extent-polygon:EPSG::1396','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1397,'USA - Nevada','United States (USA) - Nevada.',34.99,42,-120,-114.03,'urn:ogc:def:extent-polygon:EPSG::1397','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1398,'USA - New Hampshire','United States (USA) - New Hampshire - counties of Belknap; Carroll; Cheshire; Coos; Grafton; Hillsborough; Merrimack; Rockingham; Strafford; Sullivan.',42.69,45.31,-72.56,-70.63,'urn:ogc:def:extent-polygon:EPSG::1398','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.024',0),
(1399,'USA - New Jersey','United States (USA) - New Jersey - counties of Atlantic; Bergen; Burlington; Camden; Cape May; Cumberland; Essex; Gloucester; Hudson; Hunterdon; Mercer; Middlesex; Monmouth; Morris; Ocean; Passaic; Salem; Somerset; Sussex; Union; Warren.',38.87,41.36,-75.6,-73.88,'urn:ogc:def:extent-polygon:EPSG::1399','','',NULL,'','OGP','IOGP','2016-12-15','2008.070 2011.069 2014.024 2016.056',0),
(1400,'USA - New Mexico','United States (USA) - New Mexico.',31.33,37,-109.06,-102.99,'urn:ogc:def:extent-polygon:EPSG::1400','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1401,'USA - New York','United States (USA) - New York.',40.47,45.02,-79.77,-71.8,'urn:ogc:def:extent-polygon:EPSG::1401','','',NULL,'','OGP','IOGP','2016-12-15','2008.070 2011.069 2014.023 2016.056',0),
(1402,'USA - North Carolina','United States (USA) - North Carolina - counties of Alamance; Alexander; Alleghany; Anson; Ashe; Avery; Beaufort; Bertie; Bladen; Brunswick; Buncombe; Burke; Cabarrus; Caldwell; Camden; Carteret; Caswell; Catawba; Chatham; Cherokee; Chowan; Clay; Cleveland; Columbus; Craven; Cumberland; Currituck; Dare; Davidson; Davie; Duplin; Durham; Edgecombe; Forsyth; Franklin; Gaston; Gates; Graham; Granville; Greene; Guilford; Halifax; Harnett; Haywood; Henderson; Hertford; Hoke; Hyde; Iredell; Jackson; Johnston; Jones; Lee; Lenoir; Lincoln; Macon; Madison; Martin; McDowell; Mecklenburg; Mitchell; Montgomery; Moore; Nash; New Hanover; Northampton; Onslow; Orange; Pamlico; Pasquotank; Pender; Perquimans; Person; Pitt; Polk; Randolph; Richmond; Robeson; Rockingham; Rowan; Rutherford; Sampson; Scotland; Stanly; Stokes; Surry; Swain; Transylvania; Tyrrell; Union; Vance; Wake; Warren; Washington; Watauga; Wayne; Wilkes; Wilson; Yadkin; Yancey.',33.83,36.59,-84.33,-75.38,'urn:ogc:def:extent-polygon:EPSG::1402','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.023',0),
(1403,'USA - North Dakota','United States (USA) - North Dakota.',45.93,49.01,-104.07,-96.55,'urn:ogc:def:extent-polygon:EPSG::1403','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1404,'USA - Ohio','United States (USA) - Ohio.',38.4,42.33,-84.83,-80.51,'urn:ogc:def:extent-polygon:EPSG::1404','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2014.023 2015.029',0),
(1405,'USA - Oklahoma','United States (USA) - Oklahoma.',33.62,37.01,-103,-94.42,'urn:ogc:def:extent-polygon:EPSG::1405','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1406,'USA - Oregon','United States (USA) - Oregon.',41.98,46.26,-124.6,-116.47,'urn:ogc:def:extent-polygon:EPSG::1406','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.023',0),
(1407,'USA - Pennsylvania','United States (USA) - Pennsylvania.',39.71,42.53,-80.53,-74.7,'urn:ogc:def:extent-polygon:EPSG::1407','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1408,'USA - Rhode Island','United States (USA) - Rhode Island - counties of Bristol; Kent; Newport; Providence; Washington.',41.13,42.02,-71.85,-71.08,'urn:ogc:def:extent-polygon:EPSG::1408','','',NULL,'','OGP','IOGP','2016-12-15','2008.070 2011.069 2014.023 2016.056',0),
(1409,'USA - South Carolina','United States (USA) - South Carolina - counties of Abbeville; Aiken; Allendale; Anderson; Bamberg; Barnwell; Beaufort; Berkeley; Calhoun; Charleston; Cherokee; Chester; Chesterfield; Clarendon; Colleton; Darlington; Dillon; Dorchester; Edgefield; Fairfield; Florence; Georgetown; Greenville; Greenwood; Hampton; Horry; Jasper; Kershaw; Lancaster; Laurens; Lee; Lexington; Marion; Marlboro; McCormick; Newberry; Oconee; Orangeburg; Pickens; Richland; Saluda; Spartanburg; Sumter; Union; Williamsburg; York.',32.05,35.21,-83.36,-78.52,'urn:ogc:def:extent-polygon:EPSG::1409','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.023',0),
(1410,'USA - South Dakota','United States (USA) - South Dakota.',42.48,45.95,-104.07,-96.43,'urn:ogc:def:extent-polygon:EPSG::1410','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1411,'USA - Tennessee','United States (USA) - Tennessee - counties of Anderson; Bedford; Benton; Bledsoe; Blount; Bradley; Campbell; Cannon; Carroll; Carter; Cheatham; Chester; Claiborne; Clay; Cocke; Coffee; Crockett; Cumberland; Davidson; De Kalb; Decatur; Dickson; Dyer; Fayette; Fentress; Franklin; Gibson; Giles; Grainger; Greene; Grundy; Hamblen; Hamilton; Hancock; Hardeman; Hardin; Hawkins; Haywood; Henderson; Henry; Hickman; Houston; Humphreys; Jackson; Jefferson; Johnson; Knox; Lake; Lauderdale; Lawrence; Lewis; Lincoln; Loudon; Macon; Madison; Marion; Marshall; Maury; McMinn; McNairy; Meigs; Monroe; Montgomery; Moore; Morgan; Obion; Overton; Perry; Pickett; Polk; Putnam; Rhea; Roane; Robertson; Rutherford; Scott; Sequatchie; Sevier; Shelby; Smith; Stewart; Sullivan; Sumner; Tipton; Trousdale; Unicoi; Union; Van Buren; Warren; Washington; Wayne; Weakley; White; Williamson; Wilson.',34.98,36.68,-90.31,-81.65,'urn:ogc:def:extent-polygon:EPSG::1411','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1412,'USA - Texas','United States (USA) - Texas.',25.83,36.5,-106.66,-93.5,'urn:ogc:def:extent-polygon:EPSG::1412','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1413,'USA - Utah','United States (USA) - Utah.',36.99,42.01,-114.05,-109.04,'urn:ogc:def:extent-polygon:EPSG::1413','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1414,'USA - Vermont','United States (USA) - Vermont - counties of Addison; Bennington; Caledonia; Chittenden; Essex; Franklin; Grand Isle; Lamoille; Orange; Orleans; Rutland; Washington; Windham; Windsor.',42.72,45.03,-73.44,-71.5,'urn:ogc:def:extent-polygon:EPSG::1414','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.023',0),
(1415,'USA - Virginia','United States (USA) - Virginia.',36.54,39.46,-83.68,-75.31,'urn:ogc:def:extent-polygon:EPSG::1415','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.023',0),
(1416,'USA - Washington','United States (USA) - Washington.',45.54,49.05,-124.79,-116.91,'urn:ogc:def:extent-polygon:EPSG::1416','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.069 2014.023',0),
(1417,'USA - West Virginia','United States (USA) - West Virginia.',37.2,40.64,-82.65,-77.72,'urn:ogc:def:extent-polygon:EPSG::1417','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1418,'USA - Wisconsin','United States (USA) - Wisconsin.',42.48,47.31,-92.89,-86.25,'urn:ogc:def:extent-polygon:EPSG::1418','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2014.023 2015.044',0),
(1419,'USA - Wyoming','United States (USA) - Wyoming.',40.99,45.01,-111.06,-104.05,'urn:ogc:def:extent-polygon:EPSG::1419','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2014.023',0),
(1420,'Canada - Quebec - east of 57W','Canada - Quebec - east of 57W.',46.6,53.76,-57,-54,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045 2011.051',1),
(1421,'Canada - Quebec - 60W to 57W','Canada - Quebec - between 60W and 57W.',50.1,52,-60,-57.1,'','','',NULL,'','OGP','OGP','2008-07-05','2008.045 2008.054 2011.051',1),
(1422,'Canada - Quebec - 63W to 60W','Canada - Quebec - between 63W and 60W.',47.16,52.01,-63,-60,'urn:ogc:def:extent-polygon:EPSG::1422','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.068 2014.023',0),
(1423,'Canada - Quebec - 66W to 63W','Canada - Quebec - between 66W and 63W.',47.95,60.42,-66,-63,'urn:ogc:def:extent-polygon:EPSG::1423','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.068 2014.023',0),
(1424,'Canada - Quebec - 69W to 66W','Canada - Quebec - between 69W and 66W.',47.31,59,-69,-66,'urn:ogc:def:extent-polygon:EPSG::1424','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.068 2014.023',0),
(1425,'Canada - Quebec - 72W to 69W','Canada - Quebec - between 72W and 69W.',45.01,61.8,-72,-69,'urn:ogc:def:extent-polygon:EPSG::1425','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.068 2014.023',0),
(1426,'Canada - Quebec - 75W to 72W','Canada - Quebec - between 75W and 72W.',44.99,62.53,-75,-72,'urn:ogc:def:extent-polygon:EPSG::1426','','',NULL,'','OGP','OGP','2011-08-17','2008.045 2008.054 2011.069',0),
(1427,'Canada - Quebec - 78W to 75W','Canada - Quebec - between 78W and 75W.',45.37,62.62,-78,-75,'urn:ogc:def:extent-polygon:EPSG::1427','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.068 2011.069 2014.023',0),
(1428,'Canada - Quebec - west of 78W','Canada - Quebec - west of 78W.',46.23,62.45,-79.85,-78,'urn:ogc:def:extent-polygon:EPSG::1428','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.069 2014.023',0),
(1429,'Canada - Ontario - east of 75W','Canada - Ontario - east of 75W.',44.98,45.65,-75,-74.35,'urn:ogc:def:extent-polygon:EPSG::1429','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1430,'Canada - Ontario - 78W to 75W','Canada - Ontario - between 78W and 75W.',43.63,46.25,-78,-75,'urn:ogc:def:extent-polygon:EPSG::1430','','',NULL,'','OGP','OGP','2011-07-27','2008.045 2011.068',0),
(1431,'Canada - Ontario - MTM zone 10','Canada - Ontario - between 81W and 78W: south of 46N in area to west of 8015''W, south of 47N in area between 8015''W and 7930''W, entire province between 7930''W and 78W.',42.26,47.33,-81,-77.99,'urn:ogc:def:extent-polygon:EPSG::1431','','',NULL,'','OGP','OGP','2014-05-01','2004.540 2008.045 2011.069 2014.023',0),
(1432,'Canada - Ontario - MTM zone 11','Canada - Ontario - south of 46N and west of 81W.',41.67,46,-83.6,-81,'urn:ogc:def:extent-polygon:EPSG::1432','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1433,'Canada - Ontario - MTM zone 12','Canada - Ontario - between 8230''W and 7930''W: north of 46N in area between 8230''W and 8015''W, north of 47N in area between 8015''W and 7930''W.',46,55.21,-82.5,-79.5,'urn:ogc:def:extent-polygon:EPSG::1433','','',NULL,'','OGP','OGP','2011-07-27','2004.540 2008.045 2011.068',0),
(1434,'Canada - Ontario - MTM zone 13','Canada - Ontario - between 8530''W and 8230''W and north of 46N.',46,55.59,-85.5,-82.5,'urn:ogc:def:extent-polygon:EPSG::1434','','',NULL,'','OGP','OGP','2011-07-27','2008.045 2011.068',0),
(1435,'Canada - Ontario - 88.5W to 85.5W','Canada - Ontario - between 8830''W and 8530''W.',47.17,56.7,-88.5,-85.5,'urn:ogc:def:extent-polygon:EPSG::1435','','',NULL,'','OGP','OGP','2011-07-27','2008.045 2011.068',0),
(1436,'Canada - Ontario - 91.5W to 88.5W','Canada - Ontario - between 9130''W and 8830''W.',47.97,56.9,-91.5,-88.5,'urn:ogc:def:extent-polygon:EPSG::1436','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1437,'Canada - Ontario - 94.5W to 91.5W','Canada - Ontario - between 9430''W and 9130''W.',48.06,55.2,-94.5,-91.5,'urn:ogc:def:extent-polygon:EPSG::1437','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1438,'Canada - Ontario - west of 94.5W','Canada - Ontario - west of 9430''W.',48.69,53.24,-95.16,-94.5,'urn:ogc:def:extent-polygon:EPSG::1438','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2011.069 2014.023',0),
(1439,'Canada - Ontario - west of 90W','Canada - Ontario - west of 90W.',48.03,56.2,-95.17,-90,'urn:ogc:def:extent-polygon:EPSG::1439','','',NULL,'','OGP','OGP','2011-06-30','2008.045 2011.051',0),
(1440,'Canada - Ontario - 90W to 84W','Canada - Ontario - between 90W and 84W.',46.11,56.9,-90,-84,'urn:ogc:def:extent-polygon:EPSG::1440','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.069 2014.023',0),
(1441,'Canada - Ontario - 84W to 78W','Canada - Ontario - between 84W and 78W.',41.67,55.37,-84,-78,'urn:ogc:def:extent-polygon:EPSG::1441','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1442,'Canada - Ontario - east of 78W','Canada - Ontario - east of 78W.',43.63,46.25,-78,-74.35,'urn:ogc:def:extent-polygon:EPSG::1442','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1443,'Canada - Quebec - 78W to 72W','Canada - Quebec - between 78W and 72W.',44.99,62.62,-78,-72,'urn:ogc:def:extent-polygon:EPSG::1443','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.069 2014.023',0),
(1444,'Canada - Quebec - 72W to 66W','Canada - Quebec - between 72W and 66W.',45.01,61.8,-72,-66,'urn:ogc:def:extent-polygon:EPSG::1444','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1445,'Canada - Quebec - 66W to 60W','Canada - Quebec - between 66W and 60W.',47.16,60.42,-66,-60,'urn:ogc:def:extent-polygon:EPSG::1445','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1446,'Canada - Quebec - east of 60W','Canada - Quebec - east of 60W.',50.2,52.01,-60,-57.1,'urn:ogc:def:extent-polygon:EPSG::1446','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1447,'Canada - New Brunswick','Canada - New Brunswick.',44.56,48.07,-69.05,-63.7,'urn:ogc:def:extent-polygon:EPSG::1447','','',NULL,'','OGP','OGP','2014-05-01','2011.068 2014.023',0),
(1448,'Canada - 72W to 66W, south of 62N','Canada south of 60N and between 72W and 66W - New Brunswick (NB), Labrador, Nova Scotia (NS), Quebec.',44.6,61.5,-72,-66,'','','',NULL,'','OGP','OGP','2008-06-23','2006.462 2008.045',1),
(1449,'Canada - 66W to 60W, south of 60N','Canada south of 60N and between 66W and 60W - New Brunswick (NB), Labrador, Nova Scotia (NS), Prince Edward Island (PEI), Quebec.',43.2,60,-66,-60,'','','',NULL,'','OGP','OGP','2008-06-23','2002.410 2006.462 2008.045',1),
(1450,'Cote d''Ivoire (Ivory Coast) - east of 6W','Cte d''Ivoire (Ivory Coast) east of 6W.',4.92,10.46,-6,-2.48,'urn:ogc:def:extent-polygon:EPSG::1450','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1451,'Cote d''Ivoire (Ivory Coast) - west of 6W','Cte d''Ivoire (Ivory Coast) west of 6W.',4.29,10.74,-8.61,-6,'urn:ogc:def:extent-polygon:EPSG::1451','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1452,'Vietnam - west of 108E onshore','Vietnam - onshore west of 108E.',8.5,23.33,102.14,108,'urn:ogc:def:extent-polygon:EPSG::1452','','',NULL,'','OGP','OGP','2014-11-21','2008.045 2012.032 2012.040 2014.023 2014.077',0),
(1453,'Vietnam - east of 108E onshore','Vietnam - onshore east of 108E.',10.42,21.56,108,109.52,'urn:ogc:def:extent-polygon:EPSG::1453','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.032 2012.040 2014.023',0),
(1454,'Namibia - Walvis Bay','Namibia - Walvis Bay.',-23.15,-22.68,14.35,14.6,'urn:ogc:def:extent-polygon:EPSG::1454','','',NULL,'','OGP','OGP','2014-05-01','2005.890 2012.042 2014.023',0),
(1455,'South Africa - west of 18E','South Africa - onshore west of 18E.',-33.1,-28.03,16.45,18,'urn:ogc:def:extent-polygon:EPSG::1455','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1456,'South Africa - 18E to 20E','South Africa - onshore between 18E and 20E.',-34.88,-28.38,17.99,20,'urn:ogc:def:extent-polygon:EPSG::1456','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1457,'South Africa - 20E to 22E','South Africa - onshore between 20E and 22E.',-34.88,-24.76,19.99,22.01,'urn:ogc:def:extent-polygon:EPSG::1457','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1458,'South Africa - 22E to 24E','South Africa - onshore between 22E and 24E.',-34.26,-25.26,22,24.01,'urn:ogc:def:extent-polygon:EPSG::1458','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1459,'South Africa - 24E to 26E','South Africa - onshore between 24E and 26E.',-34.26,-24.71,24,26.01,'urn:ogc:def:extent-polygon:EPSG::1459','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.035 2012.049 2014.023',0),
(1460,'South Africa - 26E to 28E','Lesotho - west of 28E. South Africa - onshore between 26E and 28E.',-33.83,-22.92,26,28,'urn:ogc:def:extent-polygon:EPSG::1460','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.035 2012.049 2014.023',0),
(1461,'South Africa - 28E to 30E','Lesotho - east of 28E. South Africa - onshore between 28E and 30E.',-33.03,-22.13,27.99,30,'urn:ogc:def:extent-polygon:EPSG::1461','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.035 2012.049 2014.023',0),
(1462,'South Africa - 30E to 32E','South Africa - onshore between 30E and 32E. Swaziland.',-31.38,-22.22,29.99,32.02,'urn:ogc:def:extent-polygon:EPSG::1462','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1463,'South Africa - east of 32E','South Africa - east of 32E.',-28.94,-26.8,31.95,32.95,'urn:ogc:def:extent-polygon:EPSG::1463','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1464,'Iran - west of 48E','Iran - west of 48E.',30.99,39.78,44.03,48,'urn:ogc:def:extent-polygon:EPSG::1464','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.051 2014.023',0),
(1465,'Iran - 48E to 54E','Iran - onshore and offshore between 48E and 54E.',25.47,39.71,48,54,'urn:ogc:def:extent-polygon:EPSG::1465','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2011.004 2012.051',0),
(1466,'Iran - 54E to 60E','Iran - onshore between 54E and 60E, Gulf offshore between of 54E and Strait of Hormuz.',25.32,38.29,54,60,'urn:ogc:def:extent-polygon:EPSG::1466','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2011.004 2012.004 2012.051',0),
(1467,'Iran - east of 60E onshore','Iran - onshore east of 60E.',25.02,37.06,60,63.34,'urn:ogc:def:extent-polygon:EPSG::1467','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.004 2012.051 2014.023',0),
(1468,'Guinea - west of 12W','Guinea - onshore west of 12W.',9.01,12.68,-15.13,-12,'urn:ogc:def:extent-polygon:EPSG::1468','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.049',0),
(1469,'Guinea - east of 12W','Guinea - east of 12W.',7.19,12.51,-12,-7.65,'urn:ogc:def:extent-polygon:EPSG::1469','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1470,'Libya - west of 10E','Libya - west of 10E.',25.37,30.49,9.31,10.01,'urn:ogc:def:extent-polygon:EPSG::1470','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1471,'Libya - 10E to 12E onshore','Libya - onshore between 10E and 12E.',23.51,33.23,10,12,'urn:ogc:def:extent-polygon:EPSG::1471','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1472,'Libya - 12E to 14E onshore','Libya - onshore between 12E and 14E.',22.8,33.06,12,14,'urn:ogc:def:extent-polygon:EPSG::1472','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1473,'Libya - 14E to 16E onshore','Libya - onshore between 14E and 16E.',22.61,32.79,14,16,'urn:ogc:def:extent-polygon:EPSG::1473','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.049',0),
(1474,'Libya - 16E to 18E onshore','Libya - onshore between 16E and 18E.',22.51,31.34,16,18.01,'urn:ogc:def:extent-polygon:EPSG::1474','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1475,'Libya - 18E to 20E onshore','Libya - onshore between 18E and 20E.',21.54,32.17,18,20,'urn:ogc:def:extent-polygon:EPSG::1475','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1476,'Libya - 20E to 22E onshore','Libya - onshore between 20E and 22E.',20.54,33,20,22,'urn:ogc:def:extent-polygon:EPSG::1476','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1477,'Libya - 22E to 24E onshore','Libya - onshore between 22E and 24E.',19.5,32.97,22,24,'urn:ogc:def:extent-polygon:EPSG::1477','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1478,'Libya - east of 24E onshore','Libya - onshore east of 24E.',19.99,32.15,24,25.21,'urn:ogc:def:extent-polygon:EPSG::1478','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.005 2012.049 2012.062 2014.023',0),
(1479,'Libya - west of 12E onshore','Libya - onshore west of 12E.',23.51,33.23,9.31,12,'urn:ogc:def:extent-polygon:EPSG::1479','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.005 2012.049 2014.023',0),
(1480,'Libya - 12E to 18E onshore','Libya - onshore between 12E and 18E.',22.51,33.06,12,18.01,'urn:ogc:def:extent-polygon:EPSG::1480','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.005 2012.049 2014.023',0),
(1481,'Libya - 18E to 24E onshore','Libya - onshore between 18E and 24E.',19.5,33,18,24,'urn:ogc:def:extent-polygon:EPSG::1481','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.005 2012.049 2014.023',0),
(1482,'Libya - west of 15E onshore','Libya - onshore west of 15E.',22.61,33.23,9.31,15,'urn:ogc:def:extent-polygon:EPSG::1482','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1483,'Argentina - Neuquen province east of 70.5W','Argentina - Neuquen province east of 7030''W.',-40.54,-36.14,-70.51,-68.01,'urn:ogc:def:extent-polygon:EPSG::1483','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.004 2011.037 2014.023',0),
(1484,'Argentina - Comodoro Rivadavia - west of 67.5W','Argentina - Comodoro Rivadavia area west of 6730''W.',-46.7,-45.19,-69.5,-67.5,'urn:ogc:def:extent-polygon:EPSG::1484','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.023',0),
(1485,'Argentina - Tierra del Fuego onshore west of 67.5W','Argentina - Tierra del Fuego onshore west of 6730''W.',-54.9,-52.59,-68.64,-67.5,'urn:ogc:def:extent-polygon:EPSG::1485','','',NULL,'','OGP','OGP','2011-05-09','2008.045 2011.037',0),
(1486,'Argentina - Tierra del Fuego offshore','Argentina - Tierra del Fuego offshore Atlantic.',-54.93,-51.36,-68.62,-61.49,'urn:ogc:def:extent-polygon:EPSG::1486','','',NULL,'','OGP','OGP','2014-05-01','2011.021 2011.037 2014.023',0),
(1487,'Cuba - onshore north of 2130''N','Cuba - onshore north of 2130''N but also including all of Isla de la Juventud.',21.38,23.25,-85.01,-76.91,'urn:ogc:def:extent-polygon:EPSG::1487','','',NULL,'','OGP','OGP','2014-05-01','2008.024 2008.045 2011.061 2011.067 2011.069 2014.023',0),
(1488,'Cuba - onshore south of 2130''N','Cuba - onshore south of 2130''N and east of 80W .',19.77,21.5,-78.69,-74.07,'urn:ogc:def:extent-polygon:EPSG::1488','','',NULL,'','OGP','OGP','2014-05-01','2008.024 2008.045 2011.004 2011.061 2011.067 2011.069 2014.023',0),
(1489,'Tunisia - offshore','Tunisia - offshore.',33.22,38.41,7.81,13.67,'urn:ogc:def:extent-polygon:EPSG::1489','','',NULL,'','OGP','OGP','2014-05-01','2012.049 2014.023',0),
(1490,'Yemen - 42E to 48E','Yemen - between 42E and 48E, onshore and offshore.',11.57,17.53,42,48,'urn:ogc:def:extent-polygon:EPSG::1490','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.022 2012.051 2014.023',0),
(1491,'Yemen - 48E to 54E','Yemen - between 48E and 54E, onshore and offshore.',9.45,19,48,54,'urn:ogc:def:extent-polygon:EPSG::1491','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.022 2012.051',0),
(1492,'Yemen - South Yemen - mainland west of 48E','Yemen - South Yemen onshore mainland west of 48E.',12.54,17.44,43.37,48,'urn:ogc:def:extent-polygon:EPSG::1492','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.022 2012.051 2014.023',0),
(1493,'Yemen - South Yemen - mainland east of 48E','Yemen - South Yemen onshore mainland east of 48E.',13.94,19,48,53.14,'urn:ogc:def:extent-polygon:EPSG::1493','','',NULL,'Excludes Socotra and other islands.','OGP','OGP','2014-05-01','2008.045 2012.022 2012.051 2014.023',0),
(1494,'Vietnam - onshore Vung Tau area','Vietnam - onshore Vung Tau area.',9.02,11.03,105.49,107.59,'urn:ogc:def:extent-polygon:EPSG::1494','','',NULL,'','OGP','OGP','2014-05-01','2012.046 2014.023',0),
(1495,'Vietnam - offshore Cuu Long basin','Vietnam - offshore - Cuu Long basin and northwestern part of Nam Con Son basin.',7.99,11.15,106.54,110,'urn:ogc:def:extent-polygon:EPSG::1495','','',NULL,'','OGP','OGP','2014-05-01','2012.032 2012.040 2014.023',0),
(1496,'Korea, Republic of (South Korea) - east of 128E onshore','Republic of Korea (South Korea) - onshore east of 128E.',34.49,38.64,128,129.65,'urn:ogc:def:extent-polygon:EPSG::1496','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2008.070 2010.050 2012.050',0),
(1497,'Korea, Republic of (South Korea) - 126E to 128E onshore','Republic of Korea (South Korea) - onshore between 126E and 128E.',33.14,38.33,126,128,'urn:ogc:def:extent-polygon:EPSG::1497','','',NULL,'Superset of areas 3730 and 3721.','OGP','OGP','2014-05-01','2008.045 2008.070 2010.050 2012.050 2014.023',0),
(1498,'Korea, Republic of (South Korea) - 124E to 126E onshore','Republic of Korea (South Korea) - onshore between 124E and 126E.',33.99,38.04,124.53,126,'urn:ogc:def:extent-polygon:EPSG::1498','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.070 2012.032 2012.050 2014.023',0),
(1499,'Venezuela - Maracaibo - blocks I II and III','Venezuela - Maracaibo area offshore blocks I, II and III.',10,10.51,-71.5,-71.17,'urn:ogc:def:extent-polygon:EPSG::1499','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.023',0),
(1500,'New Zealand - North Island','New Zealand - North Island.',-41.67,-34.1,171.99,178.63,'urn:ogc:def:extent-polygon:EPSG::1500','','',NULL,'','OGP','OGP','2014-05-01','2012.027 2014.023',0),
(1501,'New Zealand - South Island','New Zealand - South Island.',-46.86,-40.44,166.37,174.46,'urn:ogc:def:extent-polygon:EPSG::1501','','',NULL,'','OGP','OGP','2014-05-01','2012.027 2012.060 2014.023',0),
(1502,'New Zealand - offshore 162E to168E','New Zealand - offshore between 162E and 168E.',-55.89,-39.68,162,168,'urn:ogc:def:extent-polygon:EPSG::1502','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.007 2012.027 2014.023 2016.054',0),
(1503,'New Zealand - offshore 168E to 174E','New Zealand - offshore between 168E and 174E.',-55.95,-30.78,168,174,'urn:ogc:def:extent-polygon:EPSG::1503','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.023 2016.054',0),
(1504,'New Zealand - offshore 174E to 180E','New Zealand - offshore between 174E and 180E.',-54.32,-26.42,174,180,'urn:ogc:def:extent-polygon:EPSG::1504','','',NULL,'','OGP','OGP','2012-02-19','2008.045 2012.007 2012.027',0),
(1505,'Ghana - offshore','Ghana - offshore.',1.4,6.06,-3.79,2.1,'urn:ogc:def:extent-polygon:EPSG::1505','','',NULL,'','OGP','OGP','2012-04-18','2012.049',0),
(1506,'Canada - 108W to 102W, south of 60N','Canada south of 60N and between 108E and 102W - Saskatchewan.',49,60,-108,-102,'','','',NULL,'','OGP','OGP','2008-06-23','2006.462 2008.045',1),
(1507,'Canada - 114W to 108W, south of 60N','Canada south of 60N and between 114E and 108W - Alberta, Saskatchewan.',49,60,-114,-108,'','','',NULL,'','OGP','OGP','2008-06-23','2006.462 2008.045',1),
(1508,'Canada - 120W to 114W, south of 60N','Canada south of 60N and between 120E and 114W - Alberta, British Columbia (BC).',49,60,-120,-114,'','','',NULL,'','OGP','OGP','2008-06-23','2006.462 2008.045',1),
(1509,'Sierra Leone - west of 12W','Sierra Leone - onshore west of 12W.',7.15,9.94,-13.35,-12,'urn:ogc:def:extent-polygon:EPSG::1509','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1510,'Sierra Leone - east of 12W','Sierra Leone - onshore east of 12W.',6.88,10,-12,-10.26,'urn:ogc:def:extent-polygon:EPSG::1510','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.049',0),
(1511,'USA - CONUS and Alaska; PRVI','Puerto Rico - onshore and offshore. United States (USA) onshore and offshore - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming. US Virgin Islands - onshore and offshore.',14.92,74.71,167.65,-63.88,'urn:ogc:def:extent-polygon:EPSG::1511','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2014-05-01','2008.070 2009.064 2010.007 2011.043 2014.023',0),
(1512,'Germany - East Germany - west of 10.5E','Germany - states of former East Germany - west of 1030''E - Thuringen.',50.35,51.56,9.92,10.5,'urn:ogc:def:extent-polygon:EPSG::1512','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.082',0),
(1513,'Europe - 10.5E to 13.5E onshore by country','Czech Republic - west of 1330''E. Germany - states of former East Germany onshore - between 1030''E and 1330''E - Brandenburg; Mecklenburg-Vorpommern; Sachsen; Sachsen-Anhalt; Thuringen.',48.97,54.74,10.5,13.5,'urn:ogc:def:extent-polygon:EPSG::1513','','',NULL,'','OGP','OGP','2014-05-01','2008.011 2008.045 2011.055 2011.082 2014.023',0),
(1514,'Europe - 13.5E to 16.5E onshore and S-42(83) by country','Czech Republic - between 1330''E and 1630''E. Germany - states of former East Germany onshore east of 1330''E - Brandenburg; Mecklenburg-Vorpommern; Sachsen. Hungary - west of 1630''E.',46.54,54.72,13.5,16.5,'urn:ogc:def:extent-polygon:EPSG::1514','','',NULL,'','OGP','OGP','2014-05-01','2008.011 2008.045 2011.055 2011.082 2014.023',0),
(1515,'Poland - zone I','Poland - southeast - south of 5220''N and east of 18E.',49,52.34,18,24.15,'urn:ogc:def:extent-polygon:EPSG::1515','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1516,'Poland - zone II','Poland - northeast - onshore north of 5120''N and east of 19E.',51.33,54.51,19,23.95,'urn:ogc:def:extent-polygon:EPSG::1516','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1517,'Poland - zone III','Poland - northwest - onshore north of 5210''N and west of 20E.',52.16,54.89,14.14,20,'urn:ogc:def:extent-polygon:EPSG::1517','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1518,'Poland - zone IV','Poland - southwest - south of 5320''N and west of 1905''E.',49.39,53.34,14.14,19.09,'urn:ogc:def:extent-polygon:EPSG::1518','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1519,'Poland - zone V','Poland - south central - between 4920''N and 5120''N, 1820''E and 1940''E.',49.39,51.34,18.33,19.67,'urn:ogc:def:extent-polygon:EPSG::1519','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1520,'Poland - west of 16.5E','Poland - onshore and offshore west of 1630''E.',50.26,55.35,14.14,16.5,'urn:ogc:def:extent-polygon:EPSG::1520','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1521,'Poland - 16.5E to 19.5E','Poland - onshore and offshore between 1630''E and 1930''E.',49.39,55.93,16.5,19.5,'urn:ogc:def:extent-polygon:EPSG::1521','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1522,'Poland - 19.5E to 22.5E','Poland - onshore and offshore between 1930''E and 2230''E.',49.09,54.55,19.5,22.5,'urn:ogc:def:extent-polygon:EPSG::1522','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1523,'Poland - east of 22.5E','Poland - east of 2230''E.',49,54.41,22.5,24.15,'urn:ogc:def:extent-polygon:EPSG::1523','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.023',0),
(1524,'Turkey - west of 28.5E onshore','Turkey west of 2830''E, onshore.',36.5,42.11,25.62,28.5,'urn:ogc:def:extent-polygon:EPSG::1524','','',NULL,'','OGP','OGP','2012-02-13','2008.045 2011.113 2012.013',0),
(1525,'Turkey - 28.5E to 31.5E onshore','Turkey between 2830''E and 3130''E, onshore.',36.06,41.46,28.5,31.5,'urn:ogc:def:extent-polygon:EPSG::1525','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.113 2012.013 2014.023',0),
(1526,'Turkey - 31.5E to 34.5E onshore','Turkey between 3130''E and 3430''E, onshore.',35.97,42.07,31.5,34.5,'urn:ogc:def:extent-polygon:EPSG::1526','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.113 2012.013 2014.023',0),
(1527,'Turkey - 34.5E to 37.5E onshore','Turkey between 3430''E and 3730''E, onshore.',35.81,42.15,34.5,37.5,'urn:ogc:def:extent-polygon:EPSG::1527','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.113 2012.013 2014.023',0),
(1528,'Turkey - 37.5E to 40.5E onshore','Turkey between 3730''E and 4030''E, onshore.',36.66,41.19,37.5,40.5,'urn:ogc:def:extent-polygon:EPSG::1528','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.113 2012.013 2014.023',0),
(1529,'Turkey - 40.5E to 43.5E onshore','Turkey between 4030''E and 4330''E, onshore.',37.02,41.6,40.5,43.5,'urn:ogc:def:extent-polygon:EPSG::1529','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.113 2012.013 2014.023',0),
(1530,'Turkey - east of 43.5E','Turkey east of 4330''E.',36.97,41.02,43.5,44.83,'urn:ogc:def:extent-polygon:EPSG::1530','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.113 2014.023',0),
(1531,'Canada - Maritime Provinces - west of 66W','Canada - New Brunswick and Nova Scotia - west of 66W.',43.64,48.07,-69,-66,'urn:ogc:def:extent-polygon:EPSG::1531','','',NULL,'','OGP','OGP','2011-08-17','2006.463 2008.045 2011.068 2011.069',0),
(1532,'Canada - Maritime Provinces - east of 66W','Canada - New Brunswick and Nova Scotia east of 66W; Prince Edward Island.',43.41,47.98,-66,-59.73,'urn:ogc:def:extent-polygon:EPSG::1532','','',NULL,'','OGP','OGP','2014-05-01','2006.463 2008.045 2011.069 2014.023',0),
(1533,'Canada - Prince Edward Island','Canada - Prince Edward Island.',45.9,47.09,-64.49,-61.9,'urn:ogc:def:extent-polygon:EPSG::1533','','',NULL,'','OGP','OGP','2014-05-01','2011.068 2014.023',0),
(1534,'Canada - Nova Scotia - east of 63W','Canada - Nova Scotia - east of 63W.',44.64,47.08,-63,-59.73,'urn:ogc:def:extent-polygon:EPSG::1534','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2011.069 2014.023',0),
(1535,'Canada - Nova Scotia - west of 63W','Canada - Nova Scotia - west of 63W.',43.41,46.02,-66.28,-63,'urn:ogc:def:extent-polygon:EPSG::1535','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.068 2014.023',0),
(1536,'Finland - 19.5E to 22.5E onshore','Finland - onshore between 1930''E and 2230''E.',59.76,69.33,19.5,22.5,'urn:ogc:def:extent-polygon:EPSG::1536','','',NULL,'','OGP','OGP','2014-05-01','2006.270 2008.045 2011.055 2011.095 2012.013 2014.023',0),
(1537,'Finland - 22.5E to 25.5E onshore','Finland - onshore between 2230''E and 2530''E.',59.75,68.9,22.5,25.5,'urn:ogc:def:extent-polygon:EPSG::1537','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.055 2011.095 2012.013 2014.023',0),
(1538,'Finland - 25.5E to 28.5E onshore. Also all country.','Finland - onshore between 2530''E and 2830''E for Basic Coordinate System and all onshore Finland for Uniform Coordinate System.',59.75,70.09,19.24,31.59,'urn:ogc:def:extent-polygon:EPSG::1538','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.055 2011.095 2012.013 2014.023',0),
(1539,'Finland - 28.5E to 31.5E','Finland - between 2830''E and 3130''E.',60.94,69.81,28.5,31.5,'urn:ogc:def:extent-polygon:EPSG::1539','','',NULL,'','OGP','OGP','2014-05-01','2006.270 2008.045 2011.095 2014.023',0),
(1540,'Mozambique - onshore west of 36E','Mozambique - onshore west of 36E.',-26.87,-11.41,30.21,36,'urn:ogc:def:extent-polygon:EPSG::1540','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.001 2012.049 2014.023',0),
(1541,'Mozambique - onshore east of 36E','Mozambique - onshore east of 36E.',-18.98,-10.42,35.99,40.9,'urn:ogc:def:extent-polygon:EPSG::1541','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.001 2012.049 2014.023',0),
(1542,'Asia - Cambodia and Vietnam - west of 108E','Cambodia; Vietnam west of 108E.',8.5,23.33,102.14,108,'urn:ogc:def:extent-polygon:EPSG::1542','','',NULL,'','OGP','OGP','2014-11-21','2008.045 2012.040 2014.023 2014.077',0),
(1543,'Austria - Styria','Austria - Styria.',46.64,47.84,13.58,16.17,'urn:ogc:def:extent-polygon:EPSG::1543','','',NULL,'','OGP','OGP','2014-05-01','2011.095 2014.023',0),
(1544,'Oman - onshore west of 54E','Oman - onshore west of 54E.',16.59,19.67,51.99,54,'urn:ogc:def:extent-polygon:EPSG::1544','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.042 2012.051 2014.023',0),
(1545,'Oman - onshore east of 54E','Oman - onshore east of 54E. Includes Musandam and the Kuria Muria (Al Hallaniyah) islands.',16.89,26.58,54,59.91,'urn:ogc:def:extent-polygon:EPSG::1545','','',NULL,'Excludes Masirah island.','OGP','OGP','2014-05-01','2008.045 2011.042 2012.051 2014.023',0),
(1546,'USA - Hawaii - island of Hawaii - onshore','United States (USA) - Hawaii - island of Hawaii - onshore.',18.87,20.33,-156.1,-154.74,'urn:ogc:def:extent-polygon:EPSG::1546','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.043 2014.023',0),
(1547,'USA - Hawaii - Maui; Kahoolawe; Lanai; Molokai - onshore','United States (USA) - Hawaii - Maui; Kahoolawe; Lanai; Molokai - onshore.',20.45,21.26,-157.36,-155.93,'urn:ogc:def:extent-polygon:EPSG::1547','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.043 2014.023',0),
(1548,'USA - Hawaii - Oahu - onshore','United States (USA) - Hawaii - Oahu - onshore.',21.2,21.75,-158.33,-157.61,'urn:ogc:def:extent-polygon:EPSG::1548','','',NULL,'','OGP','OGP','2014-05-01','2006.670 2008.070 2011.043 2014.023',0),
(1549,'USA - Hawaii - Kauai - onshore','United States (USA) - Hawaii - Kauai - onshore.',21.81,22.29,-159.85,-159.23,'urn:ogc:def:extent-polygon:EPSG::1549','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.043 2014.023',0),
(1550,'USA - Hawaii - Niihau - onshore','United States (USA) - Hawaii - Niihau - onshore.',21.73,22.07,-160.3,-159.99,'urn:ogc:def:extent-polygon:EPSG::1550','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.043 2014.023',0),
(1551,'Grenada and southern Grenadines - onshore','Grenada and southern Grenadine Islands - onshore.',11.94,12.57,-61.84,-61.35,'urn:ogc:def:extent-polygon:EPSG::1551','','',NULL,'','OGP','OGP','2014-05-01','2005.890 2011.068 2014.023',0),
(1552,'Africa - Eritrea, Ethiopia and Sudan - 36E to 42E','Eritrea. Ethiopia - between 36E and 42E. Sudan - east of 36E.',3.4,22.01,36,42,'urn:ogc:def:extent-polygon:EPSG::1552','','',NULL,'','OGP','OGP','2014-05-01','2002.810 2008.045 2012.049 2014.023',0),
(1553,'Ethiopia - east of 42E','Ethiopia - east of 42E.',4.11,12.85,42,47.99,'urn:ogc:def:extent-polygon:EPSG::1553','','',NULL,'','OGP','OGP','2014-05-01','2002.810 2008.045 2012.049 2014.023',0),
(1554,'Somalia - 42E to 48E, N hemisphere onshore','Somalia - onshore north of equator and between 42E and 48E.',0,11.52,42,48,'urn:ogc:def:extent-polygon:EPSG::1554','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.001 2012.042 2014.023',0),
(1555,'Somalia - onshore east of 48E','Somalia - onshore east of 48E.',4.44,12.03,48,51.47,'urn:ogc:def:extent-polygon:EPSG::1555','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.001 2012.049 2014.023',0),
(1556,'Australia - 102E to 108E','Australia - between 102E and 108E.',-56,-10,102,108,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045 2012.007',1),
(1557,'Australia - 108E to 114E (EEZ)','Australia - onshore and offshore to 200 nautical mile EEZ boundary between 108E and 114E.',-37.84,-17.19,109.23,114,'urn:ogc:def:extent-polygon:EPSG::1557','','',NULL,'','OGP','OGP','2014-02-15','2008.045 2012.027 2014.005',0),
(1558,'Australia - 114E to 120E (EEZ)','Australia - onshore and offshore to 200 nautical mile EEZ boundary between 114E and 120E.',-38.53,-12.61,114,120,'urn:ogc:def:extent-polygon:EPSG::1558','','',NULL,'','OGP','OGP','2014-02-15','2008.045 2012.027 2014.005',0),
(1559,'Australia - 120E to 126E','Australia - onshore and offshore between 120E and 126E.',-38.07,-10.46,120,126.01,'urn:ogc:def:extent-polygon:EPSG::1559','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.023 2016.054',0),
(1560,'Australia - 126E to 132E','Australia - onshore and offshore between 126E and 132E.',-37.38,-9.1,125.99,132,'urn:ogc:def:extent-polygon:EPSG::1560','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.005 2016.054',0),
(1561,'Australia - 132E to 138E','Australia - onshore and offshore between 132E and 138E.',-40.71,-8.88,132,138.01,'urn:ogc:def:extent-polygon:EPSG::1561','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2016.054',0),
(1562,'Australia - 138E to 144E','Australia - onshore and offshore between 138E and 144E.',-48.19,-9.08,138,144.01,'urn:ogc:def:extent-polygon:EPSG::1562','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.005 2016.054',0),
(1563,'Australia - 144E to 150E','Australia - onshore and offshore between 144E and 150E.',-50.89,-9.23,144,150.01,'urn:ogc:def:extent-polygon:EPSG::1563','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.005 2016.054',0),
(1564,'Australia - 150E to 156E','Australia - onshore and offshore between 150E and 156E.',-58.96,-13.87,150,156,'urn:ogc:def:extent-polygon:EPSG::1564','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.005 2016.054',0),
(1565,'Australia - 156E to 162E','Australia including Lord Howe Island - onshore and offshore between 156E and 162E.',-35.13,-14.08,156,162.01,'urn:ogc:def:extent-polygon:EPSG::1565','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.005 2014.023 2016.054',0),
(1566,'Australia - EEZ east of 162E','Australia - offshore east of 162E to 200 nautical mile EEZ boundary.',-34.22,-27.25,162,163.2,'urn:ogc:def:extent-polygon:EPSG::1566','','',NULL,'','OGP','OGP','2014-02-15','2008.045 2012.027 2014.005',0),
(1567,'Australasia - Australia and PNG - 138E to 144E','Australia - onshore and offshore between 138E and 144E. Papua New Guinea - onshore west of 144E.',-46.63,-2.53,138,144.01,'urn:ogc:def:extent-polygon:EPSG::1567','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2012.060 2014.023 2016.054',0),
(1568,'Australasia - Australia and PNG - 144E to 150E','Australia - onshore and offshore between 144E and 150E. Papua New Guinea (PNG) - onshore between 144E and 150E.',-47.2,-1.3,144,150.01,'urn:ogc:def:extent-polygon:EPSG::1568','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2012.027 2014.023 2016.054',0),
(1569,'Saudi Arabia - 36E to 42E','Saudi Arabia - onshore between 36E and 42E.',16.59,32.16,36,42,'urn:ogc:def:extent-polygon:EPSG::1569','','',NULL,'','OGP','OGP','2014-05-01','2005.110 2008.045 2012.051 2014.023',0),
(1570,'Asia - Middle East - Kuwait and Saudi - 48E to 54E','Kuwait - onshore east of 48E. Saudi Arabia - onshore between 48E and 54E.',17.43,30.04,48,54.01,'urn:ogc:def:extent-polygon:EPSG::1570','','',NULL,'','OGP','OGP','2014-05-01','2005.110 2008.045 2012.051 2014.023',0),
(1571,'Asia - Middle East - Kuwait and Saudi - 42E to 48E','Kuwait - west of 48E. Saudi Arabia - between of 42E and 48E.',15.61,31.15,42,48,'urn:ogc:def:extent-polygon:EPSG::1571','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.051 2014.023',0),
(1572,'Brazil - 54W to 48W and Aratu','Brazil - offshore between 54W and 48W, including Pelotas basin.',-35.71,-25.01,-53.38,-47.99,'urn:ogc:def:extent-polygon:EPSG::1572','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2010.097 2011.037 2011.053 2014.023',0),
(1573,'Brazil - 48W to 42W and Aratu','Brazil - offshore areas south of intersection of parallel of 255''S with coast and between 48W and 42W including Santos basin.',-33.5,0,-48.01,-41.99,'urn:ogc:def:extent-polygon:EPSG::1573','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2010.097 2011.037 2011.053 2014.023',0),
(1574,'Brazil - 42W to 36W and Aratu','Brazil - between 42W and 36W, southern hemisphere offshore including Campos and Espirito Santo basins; onshore Tucano basin area.',-26.35,0.01,-42.01,-36,'urn:ogc:def:extent-polygon:EPSG::1574','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2010.097 2011.037 2011.053 2014.023',0),
(1575,'Africa - Botswana and Zambia - west of 24E','Botswana and Zambia - west of 24E.',-26.88,-10.86,19.99,24,'urn:ogc:def:extent-polygon:EPSG::1575','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1576,'Africa - Botswana, Zambia and Zimbabwe - 24E to 30E','Botswana - east of 24E; Zambia - between 24E and 30E; Zimbabwe - west of 30E .',-25.84,-8.31,24,30,'urn:ogc:def:extent-polygon:EPSG::1576','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.049 2014.023',0),
(1577,'Africa - Malawi, Zambia and Zimbabwe - east of 30E','Malawi. Zambia and Zimbabwe - east of 30E.',-22.42,-8.19,30,35.93,'urn:ogc:def:extent-polygon:EPSG::1577','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.023',0),
(1578,'Uganda - north of equator and west of 30E','Uganda - north of equator and west of 30E.',0,0.86,29.71,30,'urn:ogc:def:extent-polygon:EPSG::1578','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1579,'Africa - Tanzania and Uganda - south of equator and west of 30E','Tanzania - west of 30E; Uganda - south of equator and west of 30E.',-6.81,0,29.34,30,'urn:ogc:def:extent-polygon:EPSG::1579','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.049 2014.023',0),
(1580,'Africa - Kenya and Uganda - north of equator and 30E to 36E','Kenya - north of equator and west of 36E; Uganda - north of equator and east of 30E.',0,4.63,29.99,36,'urn:ogc:def:extent-polygon:EPSG::1580','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2014.023',0),
(1581,'Africa - Kenya, Tanzania and Uganda - south of equator and 30E to 36E','Kenya - south of equator and west of 36E; Tanzania - 30E to 36E; Uganda - south of equator and east of 30E.',-11.61,0.01,29.99,36,'urn:ogc:def:extent-polygon:EPSG::1581','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.049 2014.023',0),
(1582,'Kenya - north of equator and east of 36E','Kenya - north of equator and east of 36E.',0,4.49,36,41.91,'urn:ogc:def:extent-polygon:EPSG::1582','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1583,'Africa - Kenya and Tanzania - south of equator and east of 36E','Kenya - south of equator and east of 36E; Tanzania - east of 36E.',-11.75,0,36,41.6,'urn:ogc:def:extent-polygon:EPSG::1583','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.023',0),
(1584,'Indonesia - Java and Java Sea - west of 108E','Indonesia - onshore Java and offshore southern Java Sea west of 108E.',-7.79,-4.07,105.06,108,'urn:ogc:def:extent-polygon:EPSG::1584','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.032 2012.040 2014.023',0),
(1585,'Indonesia - Java and Java Sea - east of 114E','Indonesia - onshore Java and Bali, offshore southern Java Sea, Madura Strait and western Bali Sea - east of 114E.',-8.91,-5.33,114,117.01,'urn:ogc:def:extent-polygon:EPSG::1585','','',NULL,'Subset of area 3666.','OGP','OGP','2014-05-01','2008.045 2012.032 2012.040 2014.023',0),
(1586,'Indonesia - Java and Java Sea - 108E to 114E','Indonesia - onshore Java and Madura and offshore southern Java Sea and Madura Strait - between 108E and 114E.',-8.67,-4.27,108,114,'urn:ogc:def:extent-polygon:EPSG::1586','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.032 2012.040 2014.023',0),
(1587,'China - west of 78E','China - west of 78E.',35.43,41.07,73.62,78,'urn:ogc:def:extent-polygon:EPSG::1587','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.023',0),
(1588,'China - 78E to 84E','China - between 78E and 84E.',29.16,47.23,78,84,'urn:ogc:def:extent-polygon:EPSG::1588','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.023',0),
(1589,'China - 84E to 90E','China - between 84E and 90E.',27.32,49.18,84,90,'urn:ogc:def:extent-polygon:EPSG::1589','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.023',0),
(1590,'China - 90E to 96E','China - between 90E and 96E.',27.72,47.9,90,96,'urn:ogc:def:extent-polygon:EPSG::1590','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.023',0),
(1591,'China - 96E to 102E','China - between 96E and 102E.',21.13,43.18,96,102,'urn:ogc:def:extent-polygon:EPSG::1591','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.023',0),
(1592,'China - 102E to 108E onshore','China - onshore between 102E and 108E.',21.53,42.47,102,108,'urn:ogc:def:extent-polygon:EPSG::1592','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.103 2014.023',0),
(1593,'China - 108E to 114E onshore','China - onshore between 108E and 114E.',18.11,45.11,108,114,'urn:ogc:def:extent-polygon:EPSG::1593','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.103 2012.050 2014.023',0),
(1594,'China - 114E to 120E onshore','China - onshore between 114E and 120E.',22.14,51.52,114,120,'urn:ogc:def:extent-polygon:EPSG::1594','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2011.103 2012.050',0),
(1595,'China - 120E to 126E onshore','China - onshore between 120E and 126E.',26.34,53.56,120,126,'urn:ogc:def:extent-polygon:EPSG::1595','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.103 2012.050 2014.023',0),
(1596,'China - 126E to 132E onshore','China - onshore between 126E and 132E.',40.89,52.79,126,132,'urn:ogc:def:extent-polygon:EPSG::1596','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.103 2014.023',0),
(1597,'China - east of 132E','China - east of 132E.',45.02,48.4,132,134.77,'urn:ogc:def:extent-polygon:EPSG::1597','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.023',0),
(1598,'Colombia - west of 7535''W','Colombia - mainland onshore west of 130''W of Bogota (7534''51.30"W of Greenwich).',0.03,10.21,-79.1,-75.58,'urn:ogc:def:extent-polygon:EPSG::1598','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.037 2014.023',0),
(1599,'Colombia - 7535''W to 7235''W','Colombia - onshore between 130''W and 130''E of Bogota (7535''W and 7235''W of Greenwich).',-2.51,11.82,-75.59,-72.58,'urn:ogc:def:extent-polygon:EPSG::1599','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.023',0),
(1600,'Colombia - 7235''W to 6935''W','Colombia - onshore between 130''E and 430''E of Bogota (7235''W and 6934''W of Greenwich).',-4.23,12.52,-72.59,-69.58,'urn:ogc:def:extent-polygon:EPSG::1600','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2012.044 2014.022',0),
(1601,'Colombia - east of 6935''W','Colombia - east of 430''E of Bogota (6934''51.3"W of Greenwich).',-2.25,6.31,-69.59,-66.87,'urn:ogc:def:extent-polygon:EPSG::1601','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.037 2012.044 2014.022',0),
(1602,'Colombia - offshore west of 78W','Colombia - offshore west of 78W of Greenwich.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1603,'Colombia - offshore Caribbean west of 72W','Colombia - offshore Caribbean west of 72W of Greenwich.',7.9,13.68,-77.37,-72,'urn:ogc:def:extent-polygon:EPSG::1603','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2009.106 2011.037 2014.022',0),
(1604,'Angola - Angola proper - offshore','Angola - Angola proper - offshore.',-17.26,-6.01,8.2,13.86,'urn:ogc:def:extent-polygon:EPSG::1604','','',NULL,'','OGP','OGP','2014-05-01','2012.042 2014.022',0),
(1605,'Angola - offshore block 15','Angola - offshore block 15.',-6.59,-6.03,10.83,11.67,'urn:ogc:def:extent-polygon:EPSG::1605','','',NULL,'','OGP','OGP','2014-05-01','2007.066 2012.042 2014.022',0),
(1606,'Angola - Angola proper - offshore - west of 12E','Angola - Angola proper - offshore - west of 12E.',-17.26,-6.03,8.2,12,'urn:ogc:def:extent-polygon:EPSG::1606','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.042 2014.022',0),
(1607,'Angola - 12E to 18E','Angola - Angola proper between 12E and 18E.',-17.44,-5.82,12,18,'urn:ogc:def:extent-polygon:EPSG::1607','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.042 2014.022',0),
(1608,'Argentina - west of 70.5W','Argentina - west of 7030''W.',-52,-36.16,-73.59,-70.5,'urn:ogc:def:extent-polygon:EPSG::1608','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1609,'Argentina - 70.5W to 67.5W onshore','Argentina - between 7030''W and 6730''W, onshore.',-54.9,-24.08,-70.5,-67.49,'urn:ogc:def:extent-polygon:EPSG::1609','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1610,'Argentina - 67.5W to 64.5W onshore','Argentina - between 6730''W and 6430''W, onshore.',-55.11,-21.78,-67.5,-64.49,'urn:ogc:def:extent-polygon:EPSG::1610','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1611,'Argentina - 64.5W to 61.5W onshore','Argentina - between 6430''W and 6130''W, onshore.',-54.91,-21.99,-64.5,-61.5,'urn:ogc:def:extent-polygon:EPSG::1611','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1612,'Argentina - 61.5W to 58.5W onshore','Argentina - between 6130''W and 5830''W onshore.',-39.06,-23.37,-61.51,-58.5,'urn:ogc:def:extent-polygon:EPSG::1612','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1613,'Argentina - 58.5W to 55.5W onshore','Argentina - between 5830''W and 5530''W, onshore.',-38.59,-24.84,-58.5,-55.49,'urn:ogc:def:extent-polygon:EPSG::1613','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1614,'Argentina - east of 55.5W onshore','Argentina - east of 5530''W, onshore.',-28.11,-25.49,-55.5,-53.65,'urn:ogc:def:extent-polygon:EPSG::1614','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1615,'Botswana - west of 24E','Botswana - west of 24E.',-26.88,-17.99,19.99,24,'urn:ogc:def:extent-polygon:EPSG::1615','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.004 2012.049 2014.022',0),
(1616,'Botswana - 21E to 27E','Botswana - between 21E and 27E.',-26.88,-17.78,21,27,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045 2011.004',1),
(1617,'Botswana - east of 24E','Botswana - east of 24E.',-25.84,-17.78,24,29.38,'urn:ogc:def:extent-polygon:EPSG::1617','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.004 2012.049 2014.022',0),
(1618,'Tunisia - onshore','Tunisia - onshore.',30.23,37.4,7.49,11.59,'urn:ogc:def:extent-polygon:EPSG::1618','','',NULL,'','OGP','OGP','2014-05-01','2012.049 2014.022',0),
(1619,'Tunisia - north of 3439''N','Tunisia - onshore north of 38.5 grads North (3439''N).',34.65,37.4,8.18,11.37,'urn:ogc:def:extent-polygon:EPSG::1619','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1620,'Tunisia - south of 3439''N','Tunisia - onshore south of 38.5 grads North (3439''N) .',30.23,34.66,7.49,11.59,'urn:ogc:def:extent-polygon:EPSG::1620','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1621,'Brazil - Corrego Alegre - west of 42W','Brazil - NE coastal area between 45W and 42W.',-3.9,-1.5,-45,-42,'','','',NULL,'','OGP','OGP','2008-06-23','2005.841 2008.045',1),
(1622,'Brazil - Corrego Alegre - east of 42W','Brazil - NE coastal area between 42W and 40W.',-4,-2.7,-42,-40,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1623,'Asia - Middle East - Lebanon and Syria onshore','Lebanon - onshore. Syrian Arab Republic - onshore.',32.31,37.3,35.04,42.38,'urn:ogc:def:extent-polygon:EPSG::1623','','',NULL,'','OGP','OGP','2014-05-01','2011.004 2012.051 2014.022',0),
(1624,'Germany - West Germany - west of 7.5E','Germany - former West Germany onshore west of 730''E - states of Niedersachsen, Nordrhein-Westfalen, Rheinland-Pfalz, Saarland.',49.11,53.81,5.86,7.5,'urn:ogc:def:extent-polygon:EPSG::1624','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.012 2011.095 2014.022',0),
(1625,'Germany - West-Germany - 7.5E to 10.5E','Germany - former West Germany onshore between 730''E and 1030''E - states of Baden-Wurtemberg, Bayern, Bremen, Hamberg, Hessen, Niedersachsen, Nordrhein-Westfalen, Rhineland-Pfalz, Schleswig-Holstein.',47.27,55.09,7.5,10.51,'urn:ogc:def:extent-polygon:EPSG::1625','','',NULL,'','OGP','OGP','2014-05-01','2006.410 2008.045 2011.012 2011.095 2014.022',0),
(1626,'Germany - West Germany - 10.5E to 13.5E','Germany - former West Germany onshore between 1030''E and 1330''E - states of Bayern, Berlin, Niedersachsen, Schleswig-Holstein.',47.39,54.59,10.5,13.51,'urn:ogc:def:extent-polygon:EPSG::1626','','',NULL,'','OGP','OGP','2014-05-01','2006.410 2008.045 2011.012 2011.095 2014.022',0),
(1627,'Germany - West Germany - east of 13.5E','Germany - former West Germany onshore east of 1330''E - state of Bayern.',48.51,48.98,13.5,13.84,'urn:ogc:def:extent-polygon:EPSG::1627','','',NULL,'','OGP','OGP','2014-05-01','2006.410 2008.045 2011.012 2011.095 2012.013 2014.022',0),
(1628,'Germany - west of 4.5E','Germany - onshore - west of 430''E.',NULL,NULL,NULL,NULL,'','','',NULL,'Not valid - do not use !','OGP','OGP','2008-06-23','2008.045',1),
(1629,'UK - offshore - North Sea','United Kingdom (UK) - offshore - North Sea.',51.03,62.03,-5.05,3.4,'urn:ogc:def:extent-polygon:EPSG::1629','','',NULL,'','OGP','OGP','2014-05-01','2008.070 2011.113 2014.022',0),
(1630,'Netherlands - offshore','Netherlands - offshore North Sea.',51.45,55.77,2.53,6.41,'urn:ogc:def:extent-polygon:EPSG::1630','','',NULL,'','OGP','OGP','2014-05-01','2011.082 2012.013 2014.022',0),
(1631,'Europe - 18W to 12W and ED50 by country','Europe - between 18W and 12W - Ireland offshore.',48.43,56.57,-16.1,-12,'urn:ogc:def:extent-polygon:EPSG::1631','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2009.033 2011.055 2011.082 2014.022',0),
(1632,'Europe - 12W to 6W and ED50 by country','Europe - between 12W and 6W - Faroe Islands - onshore; Spain - mainland onshore; Ireland offshore.',36.13,62.41,-12,-6,'urn:ogc:def:extent-polygon:EPSG::1632','','',NULL,'','OGP','OGP','2012-01-05','2005.140 2005.471 2008.045 2011.082',0),
(1633,'Europe - 6W to 0W and ED50 by country','Europe - between 6W and 0W - Channel Islands (Jersey, Guernsey); France offshore; Gibraltar; Ireland offshore; Norway including Svalbard - offshore; Spain - onshore; United Kingdom - UKCS offshore.',35.26,80.53,-6,0,'urn:ogc:def:extent-polygon:EPSG::1633','','',NULL,'','OGP','OGP','2012-01-05','2005.140 2005.460 2008.045 2011.082',0),
(1634,'Europe - 0E to 6E and ED50 by country','Europe - between 0E and 6E - Andorra; Denmark (North Sea); Germany offshore; Netherlands offshore; Norway including Svalbard - onshore and offshore; Spain - onshore (mainland and Balearic Islands); United Kingdom (UKCS) offshore.',38.56,82.41,0,6.01,'urn:ogc:def:extent-polygon:EPSG::1634','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2011.082 2014.022',0),
(1635,'Europe - 6E to 12E and ED50 by country','Europe - between 6E and 12E - Denmark - onshore and offshore; France - offshore; Germany offshore; Italy - onshore and offshore; Netherlands offshore; Norway including Svalbard - onshore and offshore.',36.53,83.92,5.99,12,'urn:ogc:def:extent-polygon:EPSG::1635','','',NULL,'','OGP','OGP','2014-05-01','2003.141 2005.140 2008.045 2011.082 2014.022',0),
(1636,'Europe - 12E to 18E and ED50 by country','Europe - between 12E and 18E onshore and offshore - Denmark (including Bornholm); Italy including San Marino and Vatican City State; Malta; Norway including Svalbard.',34.49,84,12,18,'urn:ogc:def:extent-polygon:EPSG::1636','','',NULL,'','OGP','OGP','2014-05-01','2003.141 2005.140 2005.890 2008.045 2011.082 2014.022',0),
(1637,'Europe - 18E to 24E and ED50 by country','Europe - between 18E and 24E - Greece - offshore; Italy - onshore and offshore; Norway including Svalbard - onshore and offshore.',33.59,84,18,24,'urn:ogc:def:extent-polygon:EPSG::1637','','',NULL,'','OGP','OGP','2012-01-05','2003.141 2005.140 2008.045 2011.082',0),
(1638,'Europe - 24E to 30E and ED50 by country','Europe - between 24E and 30E - Greece - offshore; Norway including Svalbard - onshore and offshore; Turkey - onshore and offshore. Egypt - Western Desert.',25.71,84.01,24,30,'urn:ogc:def:extent-polygon:EPSG::1638','','',NULL,'','OGP','OGP','2014-05-01','2003.141 2005.140 2008.045 2011.082 2014.022',0),
(1639,'Europe - 30E to 36E and ED50 by country','Europe - between 30E and 36E - Israel - offshore; Jordan; Norway including Svalbard - onshore and offshore; Turkey - onshore and offshore.',29.19,83.89,29.99,36,'urn:ogc:def:extent-polygon:EPSG::1639','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2008.054 2011.082 2014.022',0),
(1640,'Europe - 36E to 42E and ED50 by country','Europe - between 36E and 42E - Jordan; Norway including Svalbard - offshore; Turkey onshore and offshore.',29.18,79.09,36,42,'urn:ogc:def:extent-polygon:EPSG::1640','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2011.082 2014.022',0),
(1641,'Europe - 42E to 48E and ED50 by country','Europe - between 42E and 48E - Turkey.',36.97,41.6,42,44.83,'urn:ogc:def:extent-polygon:EPSG::1641','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2011.082 2014.022',0),
(1642,'Egypt - east of 33E onshore','Egypt - east of 33E - onshore plus offshore Gulf of Suez.',21.97,31.36,33,36.95,'urn:ogc:def:extent-polygon:EPSG::1642','','',NULL,'','OGP','OGP','2014-05-01','2012.042 2014.022',0),
(1643,'Egypt - 29E to 33E','Egypt  onshore between 29E and 33E, offshore Mediterranean east of 29E and offshore Gulf of Suez.',21.99,33.82,29,34.27,'urn:ogc:def:extent-polygon:EPSG::1643','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.042 2014.022',0),
(1644,'Egypt - west of 29E; north of 2811''N','Egypt - onshore west of 29E and north of approximately 2811''N.',28.18,31.68,24.7,29,'urn:ogc:def:extent-polygon:EPSG::1644','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.042 2014.022',0),
(1645,'Egypt - west of 29E; south of 2811''N','Egypt - west of 29E; south of approximately 2811''N.',21.99,28.19,24.99,29.01,'urn:ogc:def:extent-polygon:EPSG::1645','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2014.022',0),
(1646,'Europe - Estonia; Latvia; Lithuania','Estonia, Latvia and Lithuania - onshore and offshore.',53.89,60,19.02,28.24,'urn:ogc:def:extent-polygon:EPSG::1646','','',NULL,'','OGP','OGP','2014-05-01','2011.055 2011.095 2014.022',0),
(1647,'Indonesia - west of 96E, N hemisphere','Indonesia - north of equator and west of 96E - onshore and offshore.',0,7.79,92.01,96,'urn:ogc:def:extent-polygon:EPSG::1647','','',NULL,'','OGP','OGP','2014-05-01','2007.053 2008.045 2011.006 2012.032 2012.040 2014.022',0),
(1648,'Indonesia - west of 96E, S hemisphere','Indonesia - south of equator and west of 96E.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1649,'Indonesia - 96E to 102E, N hemisphere','Indonesia - north of equator and between 96E and 102E - onshore and offshore.',0,7.49,96,102,'urn:ogc:def:extent-polygon:EPSG::1649','','',NULL,'','OGP','OGP','2014-05-01','2007.053 2008.045 2011.006 2012.040 2014.022',0),
(1650,'Indonesia - 96E to 102E, S hemisphere','Indonesia - south of equator and between 96E and 102E - onshore and offshore.',-8.86,0,96,102,'urn:ogc:def:extent-polygon:EPSG::1650','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.006 2012.040 2014.022',0),
(1651,'Indonesia - 102E to 108E, N hemisphere','Indonesia - north of equator and between 102E and 108E - onshore and offshore.',0,6.94,102,108,'urn:ogc:def:extent-polygon:EPSG::1651','','',NULL,'','OGP','OGP','2012-04-18','2007.053 2008.045 2011.006 2012.040',0),
(1652,'Indonesia - 102E to 108E, S hemisphere','Indonesia - south of equator and between 102E and 108E - onshore and offshore.',-10.73,0,102,108.01,'urn:ogc:def:extent-polygon:EPSG::1652','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2011.006 2012.040 2014.022 2016.054',0),
(1653,'Indonesia - 108E to 114E, N hemisphere','Indonesia - north of equator and between 108E and 114E - onshore and offshore.',0,7.37,108,114,'urn:ogc:def:extent-polygon:EPSG::1653','','',NULL,'','OGP','OGP','2014-05-01','2007.053 2008.045 2011.006 2012.040 2014.022',0),
(1654,'Indonesia - 108E to 114E, S hemisphere','Indonesia - south of equator and between 108E and 114E - onshore and offshore.',-12.07,0,108,114,'urn:ogc:def:extent-polygon:EPSG::1654','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2011.006 2012.040 2016.054',0),
(1655,'Indonesia - 114E to 120E, N hemisphere','Indonesia - north of equator and between 114E and 120E - onshore and offshore.',0,4.37,114,120,'urn:ogc:def:extent-polygon:EPSG::1655','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2011.006 2012.040',0),
(1656,'Indonesia - 114E to 120E, S hemisphere','Indonesia - south of equator and between 114E and 120E - onshore and offshore.',-13.06,0,114,120.01,'urn:ogc:def:extent-polygon:EPSG::1656','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2011.006 2012.040 2016.054',0),
(1657,'Indonesia - 120E to 126E, N hemisphere','Indonesia - north of equator and between 120E and 126E - onshore and offshore.',0,5.48,120,126,'urn:ogc:def:extent-polygon:EPSG::1657','','',NULL,'','OGP','OGP','2012-04-18','2007.053 2008.045 2011.006 2012.040',0),
(1658,'Indonesia - 120E to 126E, S hemisphere','Indonesia - south of equator and between 120E and 126E - onshore and offshore.',-13.95,0.01,120,126.01,'urn:ogc:def:extent-polygon:EPSG::1658','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2011.006 2012.040 2014.022 2016.054',0),
(1659,'Indonesia - 126E to 132E, N hemisphere','Indonesia - north of equator and between 126E and 132E - onshore and offshore.',0,6.68,126,132,'urn:ogc:def:extent-polygon:EPSG::1659','','',NULL,'','OGP','OGP','2014-05-01','2007.053 2008.045 2011.006 2012.040 2014.022',0),
(1660,'Indonesia - 126E to 132E, S hemisphere','Indonesia - south of equator and between 126E and 132E - onshore and offshore.',-9.45,0,126,132,'urn:ogc:def:extent-polygon:EPSG::1660','','',NULL,'','OGP','IOGP','2016-12-15','2007.053 2008.045 2011.006 2012.040 2016.054',0),
(1661,'Indonesia - 132E to 138E, N hemisphere','Indonesia - north of equator and east of 132E.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1662,'Indonesia - 132E to 138E, S hemisphere','Indonesia - south of equator and between 132E and 138E - onshore and offshore.',-10.06,0,132,138.01,'urn:ogc:def:extent-polygon:EPSG::1662','','',NULL,'','OGP','IOGP','2016-12-15','2008.045 2011.006 2012.040 2016.054',0),
(1663,'Indonesia - east of 138E, S hemisphere','Indonesia - south of equator and east of 138E - onshore and offshore.',-10.84,0,138,141.46,'urn:ogc:def:extent-polygon:EPSG::1663','','',NULL,'','OGP','IOGP','2016-12-15','2007.053 2008.045 2011.006 2012.032 2012.040 2014.022 2016.054',0),
(1664,'Myanmar (Burma) - onshore west of 96E','Myanmar (Burma) - onshore west of 96E.',15.66,27.15,92.2,96.01,'urn:ogc:def:extent-polygon:EPSG::1664','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.040 2014.022',0),
(1665,'Asia - Myanmar and Thailand - 96E to 102E','Myanmar (Burma) - onshore east of 96E; Thailand - onshore west of 102E.',5.63,28.55,96,102.01,'urn:ogc:def:extent-polygon:EPSG::1665','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.004 2014.022',0),
(1666,'Thailand - east of 102E','Thailand - onshore and offshore east of 102E.',6.02,18.44,102,105.64,'urn:ogc:def:extent-polygon:EPSG::1666','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.004 2012.032 2012.040 2014.022',0),
(1667,'Thailand - onshore and GoT 96E to102E','Thailand - onshore west of 102E plus offshore Gulf of Thailand west of 102E.',5.63,20.46,97.34,102.01,'urn:ogc:def:extent-polygon:EPSG::1667','','',NULL,'Excludes offshore Indian Ocean.','OGP','OGP','2014-05-01','2008.045 2011.004 2012.032 2012.040 2014.022',0),
(1668,'Pakistan - north of 3535''N','Pakistan - north of 3535''N.',35.58,37.07,71.18,77.01,'urn:ogc:def:extent-polygon:EPSG::1668','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.040 2014.022',0),
(1669,'Asia - India; Pakistan - 28N to 3535''N','India - north of 28N; Pakistan - between 28N and 3535''N.',28,35.59,60.86,81.65,'urn:ogc:def:extent-polygon:EPSG::1669','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.032 2012.041 2014.022',0),
(1670,'Asia - India; Pakistan - onshore 21N to 28N and west of 82E','India - onshore between 21N and 28N and west of 82E; Pakistan - onshore south of 28N.',21,28.01,61.59,82,'urn:ogc:def:extent-polygon:EPSG::1670','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1671,'Asia - Bangladesh; India; Myanmar; Pakistan - zone Ilb','Bangladesh - onshore north of 21N; India - onshore north of 21N and east of 82E; Myanmar (Burma) - north of 21N.',21,29.47,82,101.17,'urn:ogc:def:extent-polygon:EPSG::1671','','',NULL,'','OGP','OGP','2014-05-01','2004.290 2008.045 2012.041 2014.022',0),
(1672,'India - onshore 15N to 21N','India - onshore between 15N and 21N.',15,21,70.15,87.08,'urn:ogc:def:extent-polygon:EPSG::1672','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1673,'India - mainland south of 15N','India - mainland onshore south of 15N.',8.02,15,73.94,80.41,'urn:ogc:def:extent-polygon:EPSG::1673','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1674,'Bangladesh - onshore west of 90E','Bangladesh - onshore west of 90E.',21.59,26.63,88.04,90,'urn:ogc:def:extent-polygon:EPSG::1674','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.040',0),
(1675,'Bangladesh - onshore east of 90E','Bangladesh - onshore east of 90E.',20.52,25.28,90,92.67,'urn:ogc:def:extent-polygon:EPSG::1675','','',NULL,'','OGP','OGP','2012-06-01','2008.045 2012.040 2012.062',0),
(1676,'India - north of 28N','India - north of 28N.',28,35.51,70.34,81.65,'urn:ogc:def:extent-polygon:EPSG::1676','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.032 2012.041 2014.022',0),
(1677,'India - onshore 21N to 28N and west of 82E','India - onshore between 21N and 28N and west of 82E.',21,28,68.08,82,'urn:ogc:def:extent-polygon:EPSG::1677','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1678,'India - onshore north of 21N and east of 82E','India - onshore north of 21N and east of 82E.',21,29.47,82,97.39,'urn:ogc:def:extent-polygon:EPSG::1678','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1679,'India - onshore west of 72E','India - onshore west of 72E.',20.64,28.23,68.08,72,'urn:ogc:def:extent-polygon:EPSG::1679','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1680,'India - mainland 72E to 78E','India - mainland onshore between 72E and 78E.',8.02,35.51,72,78,'urn:ogc:def:extent-polygon:EPSG::1680','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1681,'India - onshore 78E to 84E','India - onshore between 78E and 84E.',8.28,35.51,78,84,'urn:ogc:def:extent-polygon:EPSG::1681','','',NULL,'','OGP','OGP','2012-05-08','2008.045 2012.041',0),
(1682,'India - onshore 84E to 90E','India - onshore between 84E and 90E.',18.18,28.12,84,90,'urn:ogc:def:extent-polygon:EPSG::1682','','',NULL,'','OGP','OGP','2012-05-08','2008.045 2012.041',0),
(1683,'India - mainland 90E to 96E','India - mainland onshore between 90E and 96E.',21.98,29.43,90,96,'urn:ogc:def:extent-polygon:EPSG::1683','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1684,'India - east of 96E','India - east of 96E.',27.08,29.47,96,97.39,'urn:ogc:def:extent-polygon:EPSG::1684','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.041 2014.022',0),
(1685,'Pakistan - 28N to 3535''N','Pakistan - between 28N and 3535''N.',28,35.59,60.86,77.83,'urn:ogc:def:extent-polygon:EPSG::1685','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.032 2012.040 2014.022',0),
(1686,'Pakistan - onshore south of 28N','Pakistan - onshore south of 28N.',23.64,28,61.59,71.91,'urn:ogc:def:extent-polygon:EPSG::1686','','',NULL,'','OGP','OGP','2014-05-01','2007.047 2008.045 2012.040 2014.022',0),
(1687,'Pakistan - onshore west of 66E','Pakistan - onshore west of 66E.',24.98,29.87,60.86,66,'urn:ogc:def:extent-polygon:EPSG::1687','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.040 2014.022',0),
(1688,'Pakistan - onshore 66E to 72E','Pakistan - onshore between 66E and 72E.',23.64,36.56,66,72,'urn:ogc:def:extent-polygon:EPSG::1688','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.040',0),
(1689,'Pakistan - east of 72E','Pakistan - east of 72E.',28.22,37.07,72,77.83,'urn:ogc:def:extent-polygon:EPSG::1689','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.040 2014.022',0),
(1690,'Malaysia - West Malaysia - onshore','Malaysia - West Malaysia onshore.',1.21,6.72,99.59,104.6,'urn:ogc:def:extent-polygon:EPSG::1690','','',NULL,'','OGP','OGP','2014-05-01','2012.004 2012.032 2012.040 2014.022',0),
(1691,'Malaysia - West Malaysia - onshore west of 102E','Malaysia - West Malaysia onshore west of 102E.',2.29,6.72,99.59,102.01,'urn:ogc:def:extent-polygon:EPSG::1691','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.032 2012.040 2014.022',0),
(1692,'Malaysia - West Malaysia - east of 102E','Malaysia - onshore West Malaysia east of 102E and offshore east coast.',1.21,7.81,102,105.82,'urn:ogc:def:extent-polygon:EPSG::1692','','',NULL,'','OGP','OGP','2014-11-21','2008.045 2012.032 2012.040 2014.022 2014.071',0),
(1693,'Venezuela - west of 72W','Venezuela - west of 72W.',7.02,11.62,-73.38,-71.99,'urn:ogc:def:extent-polygon:EPSG::1693','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2012.044 2014.022',0),
(1694,'Venezuela - 72W and 66W onshore','Venezuela - between 72W and 66W, onshore.',0.73,12.25,-72,-66,'urn:ogc:def:extent-polygon:EPSG::1694','','',NULL,'','OGP','OGP','2013-07-21','2008.045 2009.002 2011.037 2012.044',0),
(1695,'Venezuela - east of 66W onshore','Venezuela - onshore east of 66W.',0.64,11.23,-66,-59.8,'urn:ogc:def:extent-polygon:EPSG::1695','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1696,'Gabon - north of equator and west of 12E onshore','Gabon - onshore north of equator and west of 12E.',0,2.32,9.25,12,'urn:ogc:def:extent-polygon:EPSG::1696','','',NULL,'','OGP','OGP','2012-05-08','2008.054 2012.042',0),
(1697,'Gabon - west of 12E','Gabon - west of 12E - onshore and offshore.',-6.37,2.32,7.03,12.01,'urn:ogc:def:extent-polygon:EPSG::1697','','',NULL,'','OGP','IOGP','2015-11-25','2012.042 2014.022 2015.048',0),
(1698,'Philippines - zone I','Philippines - west of 118E onshore and offshore.',6.21,18.64,116.04,118,'urn:ogc:def:extent-polygon:EPSG::1698','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.004 2012.040 2014.022',0),
(1699,'Philippines - zone II','Philippines - approximately between 118E and 120E - Palawan; Calamian Islands - onshore and offshore.',3.02,20.42,118,120.07,'urn:ogc:def:extent-polygon:EPSG::1699','','',NULL,'','OGP','OGP','2014-05-01','2012.004 2012.040 2014.022',0),
(1700,'Philippines - zone III','Philippines - approximately between 120E and 122E, onshore and offshore. Luzon (west of 122E); Mindoro.',3,21.62,119.7,122.21,'urn:ogc:def:extent-polygon:EPSG::1700','','',NULL,'','OGP','OGP','2014-05-01','2012.004 2012.040 2014.022',0),
(1701,'Philippines - zone IV','Philippines - approximately between 122E and 124E onshore and offshore - southeast Luzon (east of 122E); Tablas; Masbate; Panay; Cebu; Negros; west Mindanao (west of 122E).',3.44,22.18,121.74,124.29,'urn:ogc:def:extent-polygon:EPSG::1701','','',NULL,'','OGP','OGP','2014-05-01','2012.004 2012.040 2014.022',0),
(1702,'Philippines - zone V','Philippines - approximately between 124E and 126E, onshore and offshore - east Mindanao (east of 124E); Bohol; Samar.',4.76,21.97,123.73,126.65,'urn:ogc:def:extent-polygon:EPSG::1702','','',NULL,'','OGP','OGP','2012-04-18','2012.004 2012.040',0),
(1703,'Morocco - north of 31.5N','Morocco onshore north of 35 grads North (3130''N).',31.49,35.97,-9.85,-1.01,'urn:ogc:def:extent-polygon:EPSG::1703','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1704,'Morocco - 27.9N to 31.5N','Morocco between 31 grads and 35 grads North (2754''N and 3130''N).',27.9,31.5,-13,-3.5,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1705,'Morocco - south of 27.9N','Morocco south of 31 grads North (2754''N).',21.06,27.9,-17,-8.67,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1706,'Austria - west of 1150''E','Austria west of 1150''E of Greenwich (2930''E of Ferro).',46.77,47.61,9.53,11.84,'urn:ogc:def:extent-polygon:EPSG::1706','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.095 2014.022',0),
(1707,'Austria - 1150''E to 1450''E','Austria between 1150''E and 1450''E of Greenwich (2930''E and 3230''E of Ferro).',46.4,48.79,11.83,14.84,'urn:ogc:def:extent-polygon:EPSG::1707','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.095 2014.022',0),
(1708,'Austria - east of 1450''E','Austria east of 1450''E of Greenwich (3230''E of Ferro).',46.56,49.02,14.83,17.17,'urn:ogc:def:extent-polygon:EPSG::1708','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.095 2014.022',0),
(1709,'Europe - former Yugoslavia onshore west of 16.5E','Bosnia and Herzegovina west of 1630''E; Croatia - onshore west of 1630''E; Slovenia - onshore.',42.95,46.88,13.38,16.5,'urn:ogc:def:extent-polygon:EPSG::1709','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.053 2008.054 2011.055 2011.112 2014.022',0),
(1710,'Europe - former Yugoslavia onshore 16.5E to 19.5E','Bosnia and Herzegovina east of 1630''E; Croatia - onshore east of 1630''E; Montenegro - onshore west of 1930''E and Serbia - west of 1930''E.',41.79,46.55,16.5,19.51,'urn:ogc:def:extent-polygon:EPSG::1710','','',NULL,'','OGP','OGP','2014-05-01','2007.072 2008.045 2008.053 2008.054 2011.055 2011.112 2014.022',0),
(1711,'Europe - former Yugoslavia onshore - 19.5E to 22.5E','FYR Macedonia west of 2230''E; Montenegro - east of 1930''E; Serbia - between 1930''E and 2230''E.',40.85,46.19,19.5,22.51,'urn:ogc:def:extent-polygon:EPSG::1711','','',NULL,'','OGP','OGP','2014-05-01','2007.072 2008.045 2011.055 2014.022',0),
(1712,'Europe - former Yugoslavia onshore - east of 22.5E','FYR Macedonia and Serbia - east of 2230''E.',41.11,44.7,22.5,23.04,'urn:ogc:def:extent-polygon:EPSG::1712','','',NULL,'','OGP','OGP','2014-05-01','2007.072 2008.045 2011.055 2014.022',0),
(1713,'Nigeria - east of 10.5E','Nigeria east of 1030''E.',6.43,13.72,10.49,14.65,'urn:ogc:def:extent-polygon:EPSG::1713','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.042 2014.022',0),
(1714,'Nigeria - 6.5E to 10.5E','Nigeria between 630''E and 1030''E, onshore and offshore shelf.',3.57,13.53,6.5,10.51,'urn:ogc:def:extent-polygon:EPSG::1714','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2012.042 2014.022',0),
(1715,'Nigeria - west of 6.5E','Nigeria - onshore west of 630''E, onshore and offshore shelf.',3.57,13.9,2.69,6.5,'urn:ogc:def:extent-polygon:EPSG::1715','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2012.042 2014.022',0),
(1716,'Nigeria - offshore deep water - west of 6E','Nigeria - offshore beyond continental shelf west of 6E.',1.92,6.14,2.66,6,'urn:ogc:def:extent-polygon:EPSG::1716','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1717,'Nigeria - offshore deep water','Nigeria - offshore beyond continental shelf.',1.92,6.14,2.66,7.82,'urn:ogc:def:extent-polygon:EPSG::1717','','',NULL,'','OGP','OGP','2014-05-01','2012.042 2014.022',0),
(1718,'Italy - west of 12E','Italy - onshore and offshore - west of 12E.',36.53,47.04,5.94,12,'urn:ogc:def:extent-polygon:EPSG::1718','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.004 2011.112',0),
(1719,'Italy - east of 12E','Italy - onshore and offshore - east of 12E including San Marino and Vatican City State.',34.76,47.1,12,18.99,'urn:ogc:def:extent-polygon:EPSG::1719','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.004 2011.112 2014.022',0),
(1720,'USA - Michigan - SPCS - E','United States (USA) - Michigan - counties of Alcona; Alpena; Arenac; Bay; Cheboygan; Chippewa; Clinton; Crawford; Genesee; Gladwin; Gratiot; Hillsdale; Huron; Ingham; Iosco; Jackson; Lapeer; Lenawee; Livingston; Macomb; Midland; Monroe; Montmorency; Oakland; Ogemaw; Oscoda; Otsego; Presque Isle; Roscommon; Saginaw; Sanilac; Shiawassee; St Clair; Tuscola; Washtenaw; Wayne.',41.69,46.04,-84.87,-82.13,'urn:ogc:def:extent-polygon:EPSG::1720','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2009.057 2011.068 2014.022 2015.029',0),
(1721,'USA - Michigan - SPCS - old central','United States (USA) - Michigan - counties of Alger; Allegan; Antrim; Barry; Benzie; Berrien; Branch; Calhoun; Cass; Charlevoix; Clare; Delta; Eaton; Emmet; Grand Traverse; Ionia; Isabella; Kalamazoo; Kalkaska; Kent; Lake; Leelanau; Luce; Mackinac; Manistee; Mason; Mecosta; Missaukee; Montcalm; Muskegon; Newaygo; Oceana; Osceola; Ottawa; St Joseph; Schoolcraft; Van Buren; Wexford.',41.75,46.11,-87.61,-84.6,'urn:ogc:def:extent-polygon:EPSG::1721','','',NULL,'','OGP','IOGP','2015-09-21','2008.070 2009.057 2011.068 2014.022 2015.029',0),
(1722,'USA - Michigan - SPCS - W','United States (USA) - Michigan - counties of Alger; Baraga; Chippewa; Delta; Dickinson; Gogebic; Houghton; Iron; Keweenaw; Luce; Mackinac; Marquette; Menominee; Ontonagon; Schoolcraft.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-09-24','2008.070 2009.057',1),
(1723,'USA - Michigan - SPCS - N','United States (USA) - Michigan north of approximately 4545''N - counties of Alger; Baraga; Chippewa; Delta; Dickinson; Gogebic; Houghton; Iron; Keweenaw; Luce; Mackinac; Marquette; Menominee; Ontonagon; Schoolcraft.',45.08,48.32,-90.42,-83.44,'urn:ogc:def:extent-polygon:EPSG::1723','','',NULL,'','OGP','IOGP','2015-09-21','2008.045 2008.070 2011.068 2014.022 2015.044',0),
(1724,'USA - Michigan - SPCS - C','United States (USA) - Michigan - counties of Alcona; Alpena; Antrim; Arenac; Benzie; Charlevoix; Cheboygan; Clare; Crawford; Emmet; Gladwin; Grand Traverse; Iosco; Kalkaska; Lake; Leelanau; Manistee; Mason; Missaukee; Montmorency; Ogemaw; Osceola; Oscoda; Otsego; Presque Isle; Roscommon; Wexford.',43.8,45.92,-87.06,-82.27,'urn:ogc:def:extent-polygon:EPSG::1724','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.070 2011.068 2014.022',0),
(1725,'USA - Michigan - SPCS - S','United States (USA) - Michigan - counties of Allegan; Barry; Bay; Berrien; Branch; Calhoun; Cass; Clinton; Eaton; Genesee; Gratiot; Hillsdale; Huron; Ingham; Ionia; Isabella; Jackson; Kalamazoo; Kent; Lapeer; Lenawee; Livingston; Macomb; Mecosta; Midland; Monroe; Montcalm; Muskegon; Newaygo; Oakland; Oceana; Ottawa; Saginaw; Sanilac; Shiawassee; St Clair; St Joseph; Tuscola; Van Buren; Washtenaw; Wayne.',41.69,44.22,-87.2,-82.13,'urn:ogc:def:extent-polygon:EPSG::1725','','',NULL,'','OGP','IOGP','2015-09-21','2008.045 2008.070 2011.068 2014.022 2015.029',0),
(1726,'Mozambique - offshore','Mozambique - offshore.',-27.71,-10.09,32.64,43.03,'urn:ogc:def:extent-polygon:EPSG::1726','','',NULL,'','OGP','OGP','2014-05-01','2012.049 2014.022',0),
(1727,'Suriname - offshore','Suriname - offshore.',5.34,9.35,-57.25,-52.66,'urn:ogc:def:extent-polygon:EPSG::1727','','',NULL,'','OGP','OGP','2014-05-01','2011.037 2014.022',0),
(1728,'Algeria - north of 3439''N','Algeria - onshore north of 38.5 grads North (3439''N).',34.64,37.14,-2.22,8.64,'urn:ogc:def:extent-polygon:EPSG::1728','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1729,'Algeria - 3130''N to 3439''N','Algeria - 35 grads to 38.5 grads North (3130''N to 3439''N).',31.49,34.66,-3.85,9.22,'urn:ogc:def:extent-polygon:EPSG::1729','','',NULL,'','OGP','OGP','2014-05-01','2005.143 2008.045 2012.049 2014.022',0),
(1730,'North America - NAVD88','North America: Canada - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Newfoundland and Labrador; Northwest Territories (NWT); Nova Scotia (NS); Nunavut; Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan; Yukon. United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',25,58,-168,-52,'','','',NULL,'','OGP','OGP','2007-02-19','2006.463 2007.028',1),
(1731,'France - mainland north of 48.15N','France mainland onshore north of 53.5 grads North (4809''N).',48.14,51.14,-4.87,8.23,'urn:ogc:def:extent-polygon:EPSG::1731','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.055 2011.095 2014.022',0),
(1732,'France - mainland 45.45N to 48.15N','France mainland onshore between 50.5 grads and 53.5 grads North (4527''N to 4809''N).',45.44,48.15,-4.8,7.63,'urn:ogc:def:extent-polygon:EPSG::1732','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.055 2011.095 2014.022',0),
(1733,'France - mainland south of 45.45N','France - mainland onshore south of 50.5 grads North (4527''N).',42.33,45.45,-1.79,7.71,'urn:ogc:def:extent-polygon:EPSG::1733','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2009.106 2011.055 2011.095 2014.022',0),
(1734,'France - mainland 45.45N to 48.15N. Also all mainland.','France mainland onshore between 50.5 grads and 53.5 grads North (4527''N to 4809''N). Also used over all onshore mainland France.',42.33,51.14,-4.87,8.23,'urn:ogc:def:extent-polygon:EPSG::1734','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.055 2011.095',0),
(1735,'Algeria - west of 6W','Algeria - west of 6W (of Greenwich).',25.73,29.85,-8.67,-6,'urn:ogc:def:extent-polygon:EPSG::1735','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.049',0),
(1736,'Algeria - 6W to 0W onshore','Algeria - onshore between 6W and 0W (of Greenwich).',21.82,35.96,-6,0,'urn:ogc:def:extent-polygon:EPSG::1736','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.005 2012.049 2014.022',0),
(1737,'Algeria - 0E to 6E onshore','Algeria - onshore between 0E and 6E (of Greenwich).',18.97,36.97,0,6.01,'urn:ogc:def:extent-polygon:EPSG::1737','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.005 2012.049 2014.022',0),
(1738,'Algeria - east of 6E onshore','Algeria - onshore east of 6E (of Greenwich).',19.6,37.14,6,11.99,'urn:ogc:def:extent-polygon:EPSG::1738','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.005 2012.049 2014.022',0),
(1739,'Kuwait - west of 48E onshore','Kuwait - onshore west of 48E.',28.53,30.09,46.54,48,'urn:ogc:def:extent-polygon:EPSG::1739','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.051 2014.022',0),
(1740,'Kuwait - east of 48E onshore','Kuwait - onshore east of 48E.',28.54,30.04,48,48.48,'urn:ogc:def:extent-polygon:EPSG::1740','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.051 2014.022',0),
(1741,'Norway - zone I','Norway - west of 330''W of Oslo (713''22.5"E of Greenwich).',57.93,63.06,4.68,7.23,'urn:ogc:def:extent-polygon:EPSG::1741','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.054 2011.112 2014.022',0),
(1742,'Norway - zone II','Norway - between 330''W and 110'' W of Oslo (713''22.5"E and 933''22.5"E of Greenwich).',57.95,63.87,7.22,9.56,'urn:ogc:def:extent-polygon:EPSG::1742','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.022',0),
(1743,'Norway - zone III','Norway - between 110''W and 115''E of Oslo (933''22.5"E and 1158''22.5"E of Greenwich).',58.84,65.76,9.55,11.98,'urn:ogc:def:extent-polygon:EPSG::1743','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.022',0),
(1744,'Norway - zone IV','Norway - between 115''E and 420''E of Oslo (1158''22.5"E and 1503''22.5"E of Greenwich).',59.88,69.06,11.97,15.06,'urn:ogc:def:extent-polygon:EPSG::1744','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.022',0),
(1745,'Norway - zone V','Norway - between 420''E and 810''E of Oslo (1503''22.5"E and 1853''22.5"E of Greenwich).',66.15,70.19,15.05,18.89,'urn:ogc:def:extent-polygon:EPSG::1745','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.022',0),
(1746,'Norway - zone VI','Norway - between 810''E and 1210''E of Oslo (1853''22.5"E and 2253''22.5"E of Greenwich).',68.33,70.81,18.88,22.89,'urn:ogc:def:extent-polygon:EPSG::1746','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.022',0),
(1747,'Norway - zone VII','Norway - between 1210''E and 1615''E of Oslo (2253''22.5"E and 2658''22.5"E of Greenwich).',68.58,71.21,22.88,26.98,'urn:ogc:def:extent-polygon:EPSG::1747','','',NULL,'','OGP','OGP','2014-05-01','2007.047 2008.045 2011.112 2014.022',0),
(1748,'Norway - zone VIII','Norway - east of 1615''E of Oslo (2658''22.5"E of Greenwich).',69.02,71.17,26.97,31.22,'urn:ogc:def:extent-polygon:EPSG::1748','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.112 2014.022',0),
(1749,'Asia - Middle East - Qatar offshore and UAE west of 54E','Qatar - offshore. United Arab Emirates (UAE) - Abu Dhabi - onshore and offshore west of 54E.',22.76,27.05,50.55,54.01,'urn:ogc:def:extent-polygon:EPSG::1749','','',NULL,'','OGP','OGP','2015-02-12','2006.340 2008.045 2012.004 2012.051 2014.022 2014.070',0),
(1750,'UAE - east of 54E','United Arab Emirates (UAE) onshore and offshore east of 54E - Abu Dhabi; Dubai; Sharjah; Ajman; Fujairah; Ras Al Kaimah; Umm Al Qaiwain.',22.63,26.27,54,57.13,'urn:ogc:def:extent-polygon:EPSG::1750','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2008.070 2012.047 2014.022',0),
(1751,'Peru - east of 73W','Peru - east of 73W, onshore.',-18.39,-2.14,-73,-68.67,'urn:ogc:def:extent-polygon:EPSG::1751','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2012.044 2014.022',0),
(1752,'Peru - 79W to 73W','Peru - between 79W and 73W, onshore.',-16.57,-0.03,-79,-73,'urn:ogc:def:extent-polygon:EPSG::1752','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1753,'Peru - west of 79W','Peru - west of 79W.',-8.32,-3.38,-81.41,-79,'urn:ogc:def:extent-polygon:EPSG::1753','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2014.022',0),
(1754,'Brazil - Amazon cone shelf','Brazil - offshore shelf - Amazon cone.',-1.05,5.6,-51.64,-48,'urn:ogc:def:extent-polygon:EPSG::1754','','',NULL,'','OGP','OGP','2014-05-01','2011.004 2011.037 2014.022',0),
(1755,'South America - 84W to 78W, S hemisphere and PSAD56 by country','South America (Ecuador and Peru) between 84W and 78W, southern hemisphere, onshore.',-10.53,0,-81.41,-78,'urn:ogc:def:extent-polygon:EPSG::1755','','',NULL,'','OGP','OGP','2014-05-01','2005.144 2008.045 2010.097 2011.037 2012.060 2014.022',0),
(1756,'South America - 78W to 72W, N hemisphere and PSAD56 by country','South America (Ecuador; Venezuela) between 78W and 72W, northern hemisphere, onshore.',0,11.62,-78,-71.99,'urn:ogc:def:extent-polygon:EPSG::1756','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2012.044 2014.022',0),
(1757,'South America - 78W to 72W, S hemisphere and PSAD56 by country','South America (Chile - north of 45S; Ecuador; Peru) between 78W and 72W, southern hemisphere, onshore.',-45,0,-78,-72,'urn:ogc:def:extent-polygon:EPSG::1757','','',NULL,'','OGP','OGP','2011-05-09','2005.140 2008.045 2010.097 2011.037',0),
(1758,'South America - 72W to 66W, N hemisphere and PSAD56 by country','South America (Aruba; Bonaire; Curacao; Venezuela) between 72W and 66W, northern hemisphere, onshore.',0.73,12.68,-72,-66,'urn:ogc:def:extent-polygon:EPSG::1758','','',NULL,'','OGP','OGP','2013-07-21','2005.140 2008.045 2010.097 2011.037 2012.044',0),
(1759,'South America - 72W to 66W, S hemisphere and PSAD56 by country','South America (Bolivia; Chile - north of 45S; Peru) between 72W and 66W, southern hemisphere, onshore.',-45,-2.14,-72,-66,'urn:ogc:def:extent-polygon:EPSG::1759','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2012.044 2014.022',0),
(1760,'South America - 66W to 60W, N hemisphere and PSAD56 by country','South America (Guyana; Venezuela) onshore between 66W and 60W, northern hemisphere.',0.64,11.23,-66,-59.99,'urn:ogc:def:extent-polygon:EPSG::1760','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1761,'Bolivia - 66W to 60W','Bolivia between 66W and 60W.',-22.87,-9.67,-66,-60,'urn:ogc:def:extent-polygon:EPSG::1761','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2011.018 2011.037 2014.022',0),
(1762,'South America - 60W to 54W, N hemisphere and PSAD56 by country','South America (Guyana) onshore between 60W and 54W, northern hemisphere.',1.18,8.58,-60,-56.47,'urn:ogc:def:extent-polygon:EPSG::1762','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.074 2011.037 2014.022',0),
(1763,'Russia - west of 24E onshore','Russian Federation - onshore west of 24E - Kaliningrad.',54.32,55.32,19.57,22.87,'urn:ogc:def:extent-polygon:EPSG::1763','','',NULL,'','OGP','OGP','2014-05-01','2006.590 2008.045 2011.087 2014.022',0),
(1764,'Russia - 24E to 30E onshore','Russian Federation - onshore between 24E and 30E.',55.69,69.47,26.61,30,'urn:ogc:def:extent-polygon:EPSG::1764','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2012.013 2014.022',0),
(1765,'Russia - 30E to 36E onshore','Russian Federation - onshore between 30E and 36E.',50.34,70.02,30,36,'urn:ogc:def:extent-polygon:EPSG::1765','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1766,'Russia - 36E to 42E onshore','Russian Federation - onshore between 36E and 42E.',43.18,69.23,36,42.01,'urn:ogc:def:extent-polygon:EPSG::1766','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1767,'Russia - 42E to 48E onshore','Russian Federation - onshore between 42E and 48E.',41.19,80.91,42,48,'urn:ogc:def:extent-polygon:EPSG::1767','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1768,'Russia - 48E to 54E onshore','Russian Federation - onshore between 48E and 54E.',41.39,81.4,48,54,'urn:ogc:def:extent-polygon:EPSG::1768','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1769,'Russia - 54E to 60E onshore','Russian Federation - onshore between 54E and 60E.',50.47,81.91,54,60,'urn:ogc:def:extent-polygon:EPSG::1769','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1770,'Russia - 60E to 66E onshore','Russian Federation - onshore between 60E and 66E.',50.66,81.77,60,66,'urn:ogc:def:extent-polygon:EPSG::1770','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1771,'Russia - 66E to 72E onshore','Russian Federation - onshore between 66E and 72E .',54.1,77.07,66,72,'urn:ogc:def:extent-polygon:EPSG::1771','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1772,'Russia - 72E to 78E onshore','Russian Federation - onshore between 72E and 78E.',53.17,79.71,72,78,'urn:ogc:def:extent-polygon:EPSG::1772','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1773,'Russia - 78E to 84E onshore','Russian Federation - onshore between 78E and 84E.',50.69,81.03,78,84,'urn:ogc:def:extent-polygon:EPSG::1773','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1774,'Russia - 84E to 90E onshore','Russian Federation - onshore between 84E and 90E.',49.07,81.27,84,90,'urn:ogc:def:extent-polygon:EPSG::1774','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1775,'Russia - 90E to 96E onshore','Russian Federation - onshore between 90E and 96E.',49.89,81.35,90,96,'urn:ogc:def:extent-polygon:EPSG::1775','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1776,'Russia - 96E to 102E onshore','Russian Federation - onshore between 96E and 102E.',49.73,81.32,96,102,'urn:ogc:def:extent-polygon:EPSG::1776','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1777,'Russia - 102E to 108E onshore','Russian Federation - onshore between 102E and 108E.',49.64,79.48,102,108,'urn:ogc:def:extent-polygon:EPSG::1777','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1778,'Russia - 108E to 114E onshore','Russian Federation - onshore between 108E and 114E.',49.14,76.81,108,114,'urn:ogc:def:extent-polygon:EPSG::1778','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1779,'Russia - 114E to 120E onshore','Russian Federation - onshore between 114E and 120E.',49.51,75.96,114,120,'urn:ogc:def:extent-polygon:EPSG::1779','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1780,'Russia - 120E to 126E onshore','Russian Federation - onshore between 120E and 126E.',51.51,74,120,126,'urn:ogc:def:extent-polygon:EPSG::1780','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1781,'Russia - 126E to 132E onshore','Russian Federation - onshore between 126E and 132E.',42.25,73.61,126,132,'urn:ogc:def:extent-polygon:EPSG::1781','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1782,'Russia - 132E to 138E onshore','Russian Federation - onshore between 132E and 138E.',42.63,76.15,132,138,'urn:ogc:def:extent-polygon:EPSG::1782','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1783,'Russia - 138E to 144E onshore','Russian Federation - onshore between 138E and 144E.',45.84,76.27,138,144,'urn:ogc:def:extent-polygon:EPSG::1783','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1784,'Russia - 144E to 150E onshore','Russian Federation - onshore between 144E and 150E.',43.6,76.82,144,150,'urn:ogc:def:extent-polygon:EPSG::1784','','',NULL,'','OGP','OGP','2012-01-05','2008.045 2011.087',0),
(1785,'Russia - 150E to 156E onshore','Russian Federation - onshore between 150E and 156E.',45.77,76.26,150,156,'urn:ogc:def:extent-polygon:EPSG::1785','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1786,'Russia - 156E to 162E onshore','Russian Federation - onshore between 156E and 162E.',50.27,77.2,156,162,'urn:ogc:def:extent-polygon:EPSG::1786','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1787,'Russia - 162E to 168E onshore','Russian Federation - onshore between 162E and 168E.',54.47,70.03,162,168,'urn:ogc:def:extent-polygon:EPSG::1787','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1788,'Russia - 168E to 174E onshore','Russian Federation - onshore between 168E and 174E.',54.45,70.19,168,174,'urn:ogc:def:extent-polygon:EPSG::1788','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1789,'Russia - 174E to 180E onshore','Russian Federation - onshore between 174E and 180E .',61.65,71.59,174,180,'urn:ogc:def:extent-polygon:EPSG::1789','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1790,'Russia - 180 to 174W onshore','Russian Federation - onshore between 180E and 174W.',64.35,71.65,-180,-174,'urn:ogc:def:extent-polygon:EPSG::1790','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1791,'Russia - east of 174W onshore','Russian Federation - onshore east of 174W.',64.2,67.18,-174,-168.97,'urn:ogc:def:extent-polygon:EPSG::1791','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.087 2014.022',0),
(1792,'Europe - 12E to 18E onshore and S-42(58) by country','Germany (former DDR) - onshore east of 12E. Poland - onshore west of 18E. Czech Republic, Hungary and Slovakia - west of 18E.',45.78,54.89,12,18,'urn:ogc:def:extent-polygon:EPSG::1792','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2005.590 2008.045 2011.055 2011.082 2014.022',0),
(1793,'Europe - FSU onshore 18E to 24E and S-42 by country','Belarus, Estonia, Latvia, Lithuania and Ukraine - onshore west of 24E. Russian Federation - Kaliningrad onshore.',47.95,59.44,19.57,24,'urn:ogc:def:extent-polygon:EPSG::1793','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2005.590 2006.590 2008.011 2008.045 2011.082 2014.022',0),
(1794,'Europe - FSU onshore 24E to 30E and S-42 by country','Estonia; Latvia and Lithuania - onshore east of 24E; Belarus, Moldova, Russian Federation and Ukraine - onshore 24E to 30E.',45.18,69.47,24,30.01,'urn:ogc:def:extent-polygon:EPSG::1794','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2008.045 2011.082 2014.022',0),
(1795,'Europe - FSU onshore 30E to 36E','Belarus and Moldova - east of 30E; Russian Federation and Ukraine - onshore 30E to 36E.',44.32,70.02,30,36,'urn:ogc:def:extent-polygon:EPSG::1795','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2006.590 2008.045 2008.054 2011.082 2014.022',0),
(1796,'Europe - FSU onshore 36E to 42E','Georgia - onshore west of 36E; Russian Federation - onshore 36E to 42E; Ukraine - onshore east of 36E.',41.43,69.23,36,42,'urn:ogc:def:extent-polygon:EPSG::1796','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2008.045 2011.082 2014.022',0),
(1797,'Europe - FSU onshore 42E to 48E','Armenia - west of 48E; Azerbaijan - west of 48E; Georgia - east of 42E; Kazakhstan - west of 48E; Russian Federation - onshore 42E to 48E.',38.84,80.91,42,48.01,'urn:ogc:def:extent-polygon:EPSG::1797','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2006.590 2008.045 2011.082 2014.022',0),
(1798,'Asia - FSU onshore 48E to 54E','Azerbaijan - east of 48E; Kazakhstan - 48E to 54E; Russian Federation - 48E to 54E; Turkmenistan - west of 54E. Includes Caspian Sea (considered a lake rather than offshore).',37.34,81.4,48,54,'urn:ogc:def:extent-polygon:EPSG::1798','','',NULL,'','OGP','OGP','2012-01-05','2002.361 2006.590 2008.045 2011.082',0),
(1799,'Asia - FSU onshore 54E to 60E','Kazakhstan; Russian Federation - onshore; Turkmenistan - 54E to 60E; Uzbekistan - west of 60E.',37.05,81.91,54,60,'urn:ogc:def:extent-polygon:EPSG::1799','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2008.045 2011.082 2014.022',0),
(1800,'Asia - FSU onshore 60E to 66E','Kazakhstan; Russian Federation - onshore; Uzbekistan - 60E to 66E; Turkmenistan - east of 60E.',35.14,81.77,60,66,'urn:ogc:def:extent-polygon:EPSG::1800','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2008.045 2011.082 2014.022',0),
(1801,'Asia - FSU onshore 66E to 72E','Kazakhstan, Russian Federation onshore and Uzbekistan - 66E to 72E; Kyrgyzstan and Tajikistan - west of 72E.',36.67,77.07,66,72,'urn:ogc:def:extent-polygon:EPSG::1801','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2006.380 2006.590 2008.045 2011.082 2014.022',0),
(1802,'Asia - FSU onshore 72E to 78E','Kazakhstan; Kyrgyzstan; Russian Federation onshore - 72E to 78E; Tajikistan and Uzbekistan - east of 72E.',36.79,79.71,72,78,'urn:ogc:def:extent-polygon:EPSG::1802','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2006.380 2006.590 2008.045 2011.082 2014.022',0),
(1803,'Asia - FSU onshore 78E to 84E','Kazakhstan and Russian Federation onshore - 78E to 84E; Kyrgyzstan - east of 78E.',41.04,81.03,78,84.01,'urn:ogc:def:extent-polygon:EPSG::1803','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2008.045 2011.082 2014.022',0),
(1804,'Asia - FSU onshore 84E to 90E','Kazakhstan - east of 84E; Russian Federation - onshore 84E to 90E.',46.82,81.27,84,90,'urn:ogc:def:extent-polygon:EPSG::1804','','',NULL,'','OGP','OGP','2014-05-01','2002.361 2008.045 2011.082 2014.022',0),
(1805,'Europe - 6E to 12E and Pulkovo by country','Czech Republic and Germany (former DDR) - west of 12E.',50.21,54.18,9.93,12,'','','',NULL,'','OGP','OGP','2008-06-23','2002.361 2008.045 2009.060',1),
(1806,'South America - UTM 17S and SAD69 by country','South America - between 84W and 78W; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1807,'South America - UTM 18N and SAD69 by country','South America - between 78W and 72W; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1808,'South America - UTM 18S and SAD69 by country','South America - between 78W and 72W; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1809,'South America - UTM 19N and SAD69 by country','South America - between 72W and 66W; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1810,'South America - UTM 19S and SAD69 by country','South America - between 72W and 66W; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1811,'South America - UTM 20N and SAD69 by country','South America - between 66W and 60W; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1812,'South America - UTM 20S and SAD69 by country','South America - between 66W and 60W; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1813,'South America - UTM 21N and SAD69','South America - between 60W and 54W; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2005.140 2008.045',1),
(1814,'South America - 60W to 54W, S hemisphere and SAD69 by country','Brazil - between 60W and 54W, northern and southern hemispheres. In rest of South America between 60W and 54W southern hemisphere, onshore.',-38.91,4.51,-60,-53.99,'urn:ogc:def:extent-polygon:EPSG::1814','','',NULL,'','OGP','OGP','2014-05-01','2005.144 2005.841 2008.045 2010.097 2011.021 2011.037 2012.070 2014.022',0),
(1815,'South America - 54W to 48W, N hemisphere and SAD69 by country','Brazil - offshore deep water - Amazon cone. In remainder of South America, between 54W and 48W, northern hemisphere onshore but excluding most of the area southeast of a line between approximately 2N, 54W and 4N, 52W.',1.68,5.81,-54,-46.65,'urn:ogc:def:extent-polygon:EPSG::1815','','',NULL,'','OGP','OGP','2014-05-01','2005.144 2011.004 2010.097 2011.037 2014.022',0),
(1816,'South America - 54W to 48W, S hemisphere and SAD69 by country','Brazil - onshore and offshore northern and southern hemispheres between 54W and 48W. In remainder of South America - between 54W and 48W, southern hemisphere, onshore.',-35.71,7.04,-54,-47.99,'urn:ogc:def:extent-polygon:EPSG::1816','','',NULL,'','OGP','OGP','2014-05-01','2005.144 2008.045 2010.097 2011.037 2011.053 2014.022',0),
(1817,'Brazil - 48W to 42W','Brazil - between 48W and 42W.',-26.3,0,-48,-42,'','','',NULL,'','OGP','OGP','2008-06-23','2005.144 2008.045 2010.097',1),
(1818,'Brazil - 42W to 36W onshore','Brazil - between 42W and 36W, onshore.',-22.96,-2.68,-42,-36,'urn:ogc:def:extent-polygon:EPSG::1818','','',NULL,'','OGP','OGP','2011-05-09','2005.144 2008.045 2010.097 2011.037',0),
(1819,'Brazil - 36W to 30W','Brazil - between 36W and 30W.',-10.05,-5.15,-36,-30,'','','',NULL,'','OGP','OGP','2008-06-23','2005.144 2008.044 2008.045 2011.004',1),
(1820,'Falkland Islands - onshore west of 60W','Falkland Islands (Malvinas) - onshore west of 60W.',-52.33,-50.96,-61.55,-59.99,'urn:ogc:def:extent-polygon:EPSG::1820','','',NULL,'','OGP','OGP','2014-05-01','2007.047 2008.045 2011.037 2013.069 2014.022',0),
(1821,'Falkland Islands - onshore east of 60W','Falkland Islands (Malvinas) - onshore east of 60W.',-52.51,-51.13,-60,-57.6,'urn:ogc:def:extent-polygon:EPSG::1821','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2011.037 2013.069 2014.022',0),
(1822,'Namibia - offshore','Namibia - offshore.',-30.64,-17.24,8.24,16.46,'urn:ogc:def:extent-polygon:EPSG::1822','','',NULL,'','OGP','OGP','2014-05-01','2012.049 2014.022',0),
(1823,'South America - 84W to 78W, N hemisphere and SIRGAS95 by country','South America between 84W and 78W, northern hemisphere, onshore and offshore.',0.9,15.51,-84,-78,'urn:ogc:def:extent-polygon:EPSG::1823','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1824,'South America - 84W to 78W, S hemisphere','South America between 84W and 78W, southern hemisphere, onshore and offshore.',-56.45,0,-84,-78,'urn:ogc:def:extent-polygon:EPSG::1824','','',NULL,'','OGP','OGP','2011-05-09','2005.140 2008.045 2010.097 2011.037',0),
(1825,'South America - 78W to 72W, N hemisphere','South America between 78W and 72W, northern hemisphere, onshore and offshore.',0,15.04,-78,-72,'urn:ogc:def:extent-polygon:EPSG::1825','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1826,'South America - 78W to 72W, S hemisphere and SIRGAS 1995 by country','South America between 78W and 72W, southern hemisphere, onshore and offshore.',-59.36,0,-78,-71.99,'urn:ogc:def:extent-polygon:EPSG::1826','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1827,'South America - 72W to 66W, N hemisphere','South America between 72W and 66W, northern hemisphere, onshore and offshore.',0,15.64,-72,-66,'urn:ogc:def:extent-polygon:EPSG::1827','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1828,'South America - 72W to 66W, S hemisphere','South America between 72W and 66W, southern hemisphere, onshore and offshore.',-59.87,0,-72,-66,'urn:ogc:def:extent-polygon:EPSG::1828','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1829,'South America - 66W to 60W, N hemisphere','South America between 66W and 60W, northern hemisphere, onshore and offshore.',0,16.75,-66,-60,'urn:ogc:def:extent-polygon:EPSG::1829','','',NULL,'','OGP','OGP','2011-05-09','2005.140 2008.045 2010.097 2011.037',0),
(1830,'South America - 66W to 60W, S hemisphere','South America between 66W and 60W, southern hemisphere, onshore and offshore.',-58.39,0,-66,-60,'urn:ogc:def:extent-polygon:EPSG::1830','','',NULL,'','OGP','OGP','2011-05-09','2005.140 2008.045 2010.097 2011.037',0),
(1831,'South America - 60W to 54W, N hemisphere','South America between 60W and 54W, northern hemisphere, onshore and offshore.',0,10.7,-60,-54,'urn:ogc:def:extent-polygon:EPSG::1831','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1832,'South America - 60W to 54W, S hemisphere','South America onshore and offshore, southern hemisphere between 60W and 54W.',-44.82,0,-60,-54,'urn:ogc:def:extent-polygon:EPSG::1832','','',NULL,'','OGP','OGP','2011-05-09','2005.140 2008.045 2010.097 2011.037',0),
(1833,'South America - 54W to 48W, N hemisphere','South America between 54W and 48W, northern hemisphere, onshore and offshore.',0,9.24,-54,-48,'urn:ogc:def:extent-polygon:EPSG::1833','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2013.007 2014.022',0),
(1834,'South America - 54W to 48W, S hemisphere','South America between 54W and 48W, southern hemisphere, onshore and offshore.',-39.95,0,-54,-48,'urn:ogc:def:extent-polygon:EPSG::1834','','',NULL,'','OGP','OGP','2011-05-09','2005.140 2008.045 2010.097 2011.037',0),
(1835,'South America - 48W to 42W','South America - between 48W and 42W, southern hemisphere, onshore and offshore.',-33.5,0,-48,-42,'urn:ogc:def:extent-polygon:EPSG::1835','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1836,'South America - 42W to 36W','South America - between 42W and 36W, southern hemisphere, onshore and offshore.',-26.35,0,-42,-36,'urn:ogc:def:extent-polygon:EPSG::1836','','',NULL,'','OGP','OGP','2011-05-09','2005.140 2008.045 2010.097 2011.037',0),
(1837,'South America - 36W to 30W','South America - between 36W and 30W, southern hemisphere, onshore and offshore.',-20.11,0,-36,-30,'urn:ogc:def:extent-polygon:EPSG::1837','','',NULL,'','OGP','OGP','2014-05-01','2005.140 2008.045 2010.097 2011.037 2014.022',0),
(1838,'Namibia - west of 12E','Namibia - onshore west of 12E.',-18.53,-17.15,11.66,12,'urn:ogc:def:extent-polygon:EPSG::1838','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1839,'Namibia - 12E to 14E','Namibia - onshore between 12E and 14E.',-21.9,-16.95,12,14.01,'urn:ogc:def:extent-polygon:EPSG::1839','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1840,'Namibia - 14E to 16E','Namibia - onshore between 14E and 16E.',-28.3,-17.38,14,16,'urn:ogc:def:extent-polygon:EPSG::1840','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1841,'Namibia - 16E to 18E','Namibia - onshore between 16E and 18E.',-28.83,-17.38,15.99,18.01,'urn:ogc:def:extent-polygon:EPSG::1841','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1842,'Namibia - 18E to 20E','Namibia - between 18E and 20E.',-28.97,-17.38,18,20,'urn:ogc:def:extent-polygon:EPSG::1842','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1843,'Namibia - 20E to 22E','Namibia - between 20E and 22E.',-22.01,-17.85,19.99,22,'urn:ogc:def:extent-polygon:EPSG::1843','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1844,'Namibia - 22E to 24E','Namibia - between 22E and 24E.',-18.49,-17.52,21.99,24,'urn:ogc:def:extent-polygon:EPSG::1844','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1845,'Namibia - east of 24E','Namibia - east of 24E.',-18.18,-17.47,24,25.27,'urn:ogc:def:extent-polygon:EPSG::1845','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.049 2014.022',0),
(1846,'Sudan - south - west of 30E','Sudan south - west of 30E.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1847,'Sudan - south - east of 30E','Sudan south - east of 30E.',NULL,NULL,NULL,NULL,'','','',NULL,'','OGP','OGP','2008-06-23','2008.045',1),
(1848,'Madagascar - nearshore - west of 48E','Madagascar - nearshore west of 48E.',-26.59,-13,42.53,48,'urn:ogc:def:extent-polygon:EPSG::1848','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.025 2012.048 2014.022',0),
(1849,'Madagascar - nearshore - east of 48E','Madagascar - nearshore east of 48E.',-24.21,-11.69,48,51.03,'urn:ogc:def:extent-polygon:EPSG::1849','','',NULL,'','OGP','OGP','2012-04-18','2008.045 2012.025 2012.048',0),
(1850,'UAE - Abu Dhabi - onshore west of 54E','United Arab Emirates (UAE) - Abu Dhabi onshore west of 54E.',22.76,24.32,51.56,54.01,'urn:ogc:def:extent-polygon:EPSG::1850','','',NULL,'','OGP','OGP','2015-02-12','2007.010 2008.045 2008.070 2012.047 2014.022 2012.056',0),
(1851,'Malaysia - East Malaysia onshore','Malaysia - onshore East Malaysia (Sabah; Sarawak).',0.85,7.41,109.54,119.33,'urn:ogc:def:extent-polygon:EPSG::1851','','',NULL,'','OGP','OGP','2014-05-01','2012.004 2012.040 2014.022',0),
(1852,'Asia - Brunei and East Malaysia - 108E to 114E','Brunei - offshore west of 114E; Malaysia - East Malaysia (Sarawak) onshore and offshore west of 114E).',0.85,7.37,109.31,114,'urn:ogc:def:extent-polygon:EPSG::1852','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.040 2014.022',0),
(1853,'Asia - Brunei and East Malaysia - 114E to 120E','Brunei - onshore and offshore east of 114E; Malaysia - East Malaysia (Sabah, Sarawak) onshore and offshore east of 114E).',1.43,7.67,114,119.61,'urn:ogc:def:extent-polygon:EPSG::1853','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.040 2014.022',0),
(1854,'Japan - zone I','Japan - onshore - Kyushu west of approximately 130E - Nagasaki-ken; islands of Kagoshima-ken between 27N and 32N and between 12818''E and 130E (between 12818''E and 3013''E for Amami islands).',26.96,34.74,128.17,130.46,'urn:ogc:def:extent-polygon:EPSG::1854','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1855,'Japan - zone II','Japan - onshore - Kyushu east of approximately 130E - Fukuoka-ken; Saga-ken; Kumamoto-ken; Oita-ken; Miyazaki-ken; Kagoshima-ken (except for area within Japan Plane Rectangular Coordinate System zone I).',30.18,33.99,129.76,132.05,'urn:ogc:def:extent-polygon:EPSG::1855','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1856,'Japan - zone III','Japan - onshore - Honshu west of approximately 13315''E - Yamaguchi-ken; Shimane-ken; Hiroshima-ken.',33.72,36.38,130.81,133.49,'urn:ogc:def:extent-polygon:EPSG::1856','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1857,'Japan - zone IV','Japan - onshore - Shikoku - Kagawa-ken; Ehime-ken; Tokushima-ken; Kochi-ken.',32.69,34.45,131.95,134.81,'urn:ogc:def:extent-polygon:EPSG::1857','','',NULL,'','OGP','OGP','2014-05-01','2012.050 2014.022',0),
(1858,'Japan - zone V','Japan - onshore - Honshu between approximately 13315''E and 13510''E - Hyogo-ken; Tottori-ken; Okayama-ken.',34.13,35.71,133.13,135.47,'urn:ogc:def:extent-polygon:EPSG::1858','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1859,'Japan - zone VI','Japan - onshore - Honshu between approximately 13510''E and 13645''E - Kyoto-fu; Osaka-fu; Fukui-ken; Shiga-ken; Mie-ken; Nara-ken; Wakayama-ken.',33.4,36.33,134.86,136.99,'urn:ogc:def:extent-polygon:EPSG::1859','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1860,'Japan - zone VII','Japan - onshore - Honshu between approximately 13615''E and 13745''E - Ishikawa-ken; Toyama-ken; Gifu-ken; Aichi-ken.',34.51,37.58,136.22,137.84,'urn:ogc:def:extent-polygon:EPSG::1860','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1861,'Japan - zone VIII','Japan - onshore - Honshu between approximately 13745''E and 139E - Niigata-ken; Nagano-ken; Yamanashi-ken; Shizuoka-ken.',34.54,38.58,137.32,139.91,'urn:ogc:def:extent-polygon:EPSG::1861','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1862,'Japan - zone IX','Japan - onshore - Honshu - Tokyo-to. (Excludes offshore island areas of Tokyo-to covered by Japan Plane Rectangular Coordinate System zones XIV, XVIII and XIX).',29.31,37.98,138.4,141.11,'urn:ogc:def:extent-polygon:EPSG::1862','','',NULL,'','OGP','OGP','2014-05-01','2012.050 2014.022',0),
(1863,'Japan - zone X','Japan - onshore - Honshu north of 38N approximately - Aomori-ken; Akita-ken; Yamagata-ken; Iwate-ken; Miyagi-ken.',37.73,41.58,139.49,142.14,'urn:ogc:def:extent-polygon:EPSG::1863','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1864,'Japan - zone XI','Japan - onshore - Hokkaido west of approximately 141E - Otaru city; Hakodate city; Date city; Usu-gun and Abuta-gun of Iburi-shicho; Hiyama-shicho; Shiribeshi-shicho; Oshima-shicho.',41.34,43.42,139.34,141.46,'urn:ogc:def:extent-polygon:EPSG::1864','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2013.063',0),
(1865,'Japan - zone XII','Japan - onshore - Hokkaido between approximately 141E and 143E - Sapporo city; Asahikawa city; Wakkanai city; Rumoi city; Bibai city; Yubari city; Iwamizawa city; Tomakomai city; Muroran city; Shibetsu city; Nayoro city; Ashibetsu city; Akabira city; Mikasa city; Takikawa city; Sunagawa city; Ebetsu city; Chitose city; Utashinai city; Fukagawa city; Monbetsu city; Furano city; Noboribetsu city; Eniwa city; Ishikari-shicho; Monbetsu-gun of Abashiri-shicho; Kamikawa-shicho; Soya-shicho; Hidaka-shicho; Iburi-shicho (except Usu-gun and Abuta-gun); Sorachi-shicho; Rumoi-shicho.',42.15,45.54,140.89,143.61,'urn:ogc:def:extent-polygon:EPSG::1865','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2013.063',0),
(1866,'Japan - zone XIII','Japan - onshore - Hokkaido east of approximately 143E - Kitami city; Obihiro city; Kushiro city; Abashiri city; Nemuro city; Nemuro-shicho; Kushiro-shicho; Abashiri-shicho (except Monbetsu-gun); Tokachi-shicho.',41.87,44.4,142.61,145.87,'urn:ogc:def:extent-polygon:EPSG::1866','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2013.063',0),
(1867,'Japan - zone XIV','Japan - onshore - Tokyo-to south of 28N and between 14030''E and 143E.',24.67,27.8,141.2,142.33,'urn:ogc:def:extent-polygon:EPSG::1867','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1868,'Japan - zone XV','Japan - onshore - Okinawa-ken between 126E and 130E.',26.02,26.91,126.63,128.4,'urn:ogc:def:extent-polygon:EPSG::1868','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1869,'Japan - zone XVI','Japan - onshore - Okinawa-ken west of 126E.',23.98,24.94,122.83,125.51,'urn:ogc:def:extent-polygon:EPSG::1869','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1870,'Japan - zone XVII','Japan - onshore Okinawa-ken east of 130E.',24.4,26.01,131.12,131.38,'urn:ogc:def:extent-polygon:EPSG::1870','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1871,'Japan - zone XVIII','Japan - onshore - Tokyo-to south of 28N and west of 14030''E.',20.37,20.48,136.02,136.16,'urn:ogc:def:extent-polygon:EPSG::1871','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.050 2014.022',0),
(1872,'Japan - Minamitori-shima (Marcus Island) - onshore','Japan - onshore - Tokyo-to south of 28N and east of 143E - Minamitori-shima (Marcus Island).',24.22,24.35,153.91,154.05,'urn:ogc:def:extent-polygon:EPSG::1872','','',NULL,'','OGP','OGP','2014-05-01','2008.045 2012.032 2012.050 2014.022',0),
(1873,'World - N hemisphere - 180W to 174W','Between 180W and 174W, northern hemisphere between equator and 84N, onshore and offshore.',0,84,-180,-174,'urn:ogc:def:extent-polygon:EPSG::1873','','',NULL,'','OGP','OGP','2011-05-09','2002.341 2005.144 2008.045 2011.022 2011.040',0),
(1874,'World - S hemisphere - 180W to 174W','Between 180W to 174W, southern hemisphere between 80S and equator, onshore and offshore.',-80,0,-180,-174,'urn:ogc:def:extent-polygon:EPSG::1874','','',NULL,'','OGP','OGP','2011-05-09','2002.341 2005.144 2008.045 2011.022 2011.040',0),
(1875,'World - N hemisphere - 174W to 168W','Between 174W and 168W, northern hemisphere between equator and 84N, onshore and offshore.',0,84,-174,-168,'urn:ogc:def:extent-polygon:EPSG::1875','','',NULL,'','OGP','OGP','2011-05-09','2002.341 2005.144 2008.045 2011.022 2011.040',0),
(1876,'World - S hemisphere - 174W to 168W','Between 174W and 168W, southern hemisphere between 80S and equator, onshore and offshore.',-80,0,-174,-168,'urn:ogc:def:extent-polygon:EPSG::1876','','',NULL,'','OGP','OGP','2011-05-09','2002.341 2005.144 2008.045 2011.022 2011.040',0),
(1877,'World - N hemisphere - 168W to 162W','Between 168W and 162W, northern hemisphere between equator and 84N, onshore and offshore.',0,84,-168,-162,'urn:ogc:def:extent-polygon:EPSG::1877','','',NULL,'','OGP','OGP','2011-05-09','2002.341 2005.144 2008.045 2011.022 2011.040',0),
(1878,'World - S hemisphere - 168W to 162W','Between 168W and 162W, southern hemisphere between 80S and equator, onshore and offshore.',-80,0,-168,-162,'urn:ogc:def:extent-polygon:EPSG::1878','','',NULL,'','OGP','OGP','2