package scripting;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;



/**
 * 
 * Utility functions to manage gvSIG geometries
 */
public class geom {
    
    // GeometryTypes
    public static final int AGGREGATE = Geometry.TYPES.AGGREGATE;
    public static final int ARC = Geometry.TYPES.ARC;
    public static final int CIRCLE = Geometry.TYPES.CIRCLE;
    public static final int CURVE = Geometry.TYPES.CURVE;
    public static final int ELLIPSE = Geometry.TYPES.ELLIPSE;
    public static final int ELLIPTICARC = Geometry.TYPES.ELLIPTICARC;
    public static final int GEOMETRY = Geometry.TYPES.GEOMETRY;
    public static final int MULTICURVE = Geometry.TYPES.MULTICURVE;
    public static final int MULTIPOINT = Geometry.TYPES.MULTIPOINT;
    public static final int MULTISOLID = Geometry.TYPES.MULTISOLID;
    public static final int MULTISURFACE = Geometry.TYPES.MULTISURFACE;
    public static final int NULL = Geometry.TYPES.NULL;
    public static final int POINT = Geometry.TYPES.POINT;
    public static final int SOLID =  Geometry.TYPES.SOLID;
    public static final int SPLINE = Geometry.TYPES.SPLINE;
    public static final int SURFACE = Geometry.TYPES.SURFACE;

    // Common named geometry types
    public static final int POLYGON = Geometry.TYPES.SURFACE;
    public static final int LINE = Geometry.TYPES.CURVE;
    public static final int MULTILINE = Geometry.TYPES.MULTICURVE;
    public static final int MULTIPOLYGON = Geometry.TYPES.MULTISURFACE;

    // geometrySubTypes 
    public static final int D2 = Geometry.SUBTYPES.GEOM2D;
    public static final int D2M = Geometry.SUBTYPES.GEOM2DM;
    public static final int D3 = Geometry.SUBTYPES.GEOM3D;
    public static final int D3M = Geometry.SUBTYPES.GEOM3DM;
    public static final int UNKNOWN = Geometry.SUBTYPES.UNKNOWN;

    /**
     * Returns a new geometry with a concrete type and subtype or None if can't
     * create geometry.
     *
     * @param type: geometry type
     * @type type: int
     * @param subtype, optional: geometry subtype
     * @type subtype: int
     * @return geometry
     * @rtype geometry
     *
     */
    public static Geometry createGeometry(int type, int subtype) {
        return null;
    }
  
    /**
     * Create a Point2D. If values of x and y are None, it will create an
     * empty Point2D geometry
     *
     * @param vertexes, optional: vertexes of a new line
     * @type vertexes, list of coordinates or list of geometry points
     * @return line geometry
     */
    public static Geometry createPoint2D(double x, double y, int subtype) {
        return null;
    }

    /**
     * Create a Line2D. If vertexes value is None it will 
     * create an empty Line2D geometry.
     *
     * @param vertexes, optional: vertexes of a new line
     * @type vertexes, list of coordinates or list of geometry points
     * @return line geometry
     */
    public static Geometry createLine2D(Object vertexes) {
        return null;
    }
    
    /**
     * Create a Polygon2D. If vertexes value is None it will 
     * create an empty Polygon2D.
     *
     * @param vertexes, optional: vertexes of a new line
     * @type vertexes, list of coordinates or list of geometry points
     * @return line geometry
     */
    public static Geometry createPolygon2D(Object vertexes) {
        return null;
    }
    
    /**
     * 
     * Returns a new point with a subtype and sets the value for the X, Y, Z and M
     * coordinates (default 0,0,0,0) or None if can't create point or none coordinates
     * are established.
     * 
     * If you pass a point geometry as a parameter, it will return the same geometry point.
     *
     *
     * Examples:
     *     createPoint(D2, 1, 2) -> Point2D(1, 2)
     *     createPoint(D2, [1, 2]) -> Point2D(1, 2)
     *
     *     createPoint(D3, 1, 2, 3) -> Point3D(1,2,3)
     *     createPoint(D2M, 1, 2, 4) -> Point (1, 2, 4)
     *     createPoint(D3M, 1, 2, 3, 4) -> Point (1, 2, 3, 4)
     *
     *     createPoint(D2, Point2D(1, 2) -> Point2D(1, 2)
     *     
     *
     * @param subtype, geometry subtype
     * @type subtype: int
     * @param coords, list of coordinates or points
     * @return 
     */
    public static Geometry createPoint(int subtype, double... coords)  {
        return null;
    }  
    
    /**
     * 
     * Returns a new multipoint with a subtype from a list of Points instancesor list
     * of coordinates.
     * If points are None, returns an empty multipoint geometry. If it can't create
     * the geometry, return None.
     *
     * @param subtype, geometry subtype
     * @type subtype, int
     * @param points, list of coordinates or points
     * @return 
     */
    public static Geometry createMultiPoint(int subtype, Object points) {
        return null;
    }

    /**
     * 
     * Returns a new polygon with a subtype from a list of Points instances or list
     * of tuples/lists like [[x1, y1], [x2, y2], ...., [xn, yn]] are
     * allowed. If points are None, returns an empty polygon geometry. If it can't create
     * the geometry, return None.
     *
     * Example:
     * createPolygon( D2, [point1, point2, [10, 10], point1])
     *
     * @param subtype, geometry subtype
     * @type subtype, int
     * @param vertexes, list of coordinates or points
     * @return 
     */
    public static Geometry createPolygon(int subtype, Object vertexes) {
        return null;
    }

    /**
     * 
     * Returns a new multipolygon with a subtype from a list of Polygon instances or list
     * of coordinates.
     * If polygons are None, returns an empty multipolygon geometry. If it can't create
     * the geometry, return None.
     *
     * Example:
     * createMultiPolygon( D2, [polygon1, [[0,0],[10,0],point1,[0,0]], polygon3])
     *
     * @param subtype, geometry subtype
     * @type subtype, int
     * @param polygons, list of polygons.
     * @return 
     */
    public static Geometry createMultiPolygon(int subtype, Object polygons) {
        return null;        
    }  
    
    /**
     * 
     * Returns a new line with a subtype from a list of Points instances or list 
     * of coordinates as tuples/lists like ([x1, y1], [x2, y2], ...., [xn, yn]) are
     * allowed. If points are None, returns an empty line geometry. If it can't create
     * the geometry, return None.
     *
     * Example:
     * createLine( D2, [point0, [10,0], [10, 10], point0]) 
     *
     * @param subtype, geometry subtype
     * @type subtype, int
     * @param vertexes, list of coordinates or points
     * @return 
     */
    public static Geometry createLine(int subtype, Object vertexes) {
        return null;        
    }  
    
    /**
     * 
     * Returns a new multiline with a subtype from a list of Line instances or list
     * of coordinates.
     * If polygons are None, returns an empty multipolygon geometry. If it can't create
     * the geometry, return None.
     *
     * Example:
     * createMultiLine( D2, [line1, [[0,0],[10,0],point1], line3])
     *
     * @param subtype, geometry subtype
     * @type subtype, int
     * @param lines, list of lines.
     * @return 
     */
    public static Geometry createMultiLine(int subtype, Object lines) {
        return null;        
    }  
    

    /**
     * Returns envelope as a minimum bounding box or rectangle. This envelope is
     * equivalent to the GM_Envelope specified in ISO 19107. If points are None it will
     * create an empty Envelope
     *
     * @param pointMax, optional, None by default
     * @type pointMax, list of coordinates or geometry point
     * @param pointMin, optional, None by default
     * @type pointMin, list of coordinates or geometry point
     * @param dimension
     * @return 
     */
    public static Envelope createEnvelope(Object pointMax, Object pointMin, int dimension) {
        return null;        
    }  
        
    /**
     * Create geometry from WKT (Well Known Text)
     *
     * @param WKT
     * @type WKT, string
     * @return 
     */
    public static Geometry createGeometryFromWKT(String WKT) {
        return null;
    }  
    
    
    
}
