package scripting;

import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.scripting.app.extension.ScriptingExtension;

/**
 * Representa al modulo python "gvsig".
 *
 * Es el modulo base que nos facilita el acceso a todos los componentes de
 * gvSIG.
 *
 */
public class gvsig {

    public static int LOGGER_INFO = ScriptingExtension.INFO;
    public static int LOGGER_WARN = ScriptingExtension.WARN;
    public static int LOGGER_ERROR = ScriptingExtension.ERROR;

    /**
     * Returns a new and empty attributes definition.
     *
     * @return the new FeatureType
     */
    public static FeatureType createFeatureType() {
        return null;
    }

    /**
     * Returns a new and empty attributes definition based in an existing
     * FeatureType.
     *
     * All attributes in the feature type pased as parameters are created in the
     * new definition
     *
     * @param featureType from the new attributes are copied
     * @return The new FeatureType
     */
    public static FeatureType createFeatureType(FeatureType featureType) {
        return null;
    }

    /**
     * Create a new layer with the specified parameters.
     *
     * The paramaters are used to connect to the server type and create the
     * layer. These parameters are specific of each type of layer.
     *
     * Valid values of server type are:
     * <ul>
     * <li>FilesystemExplorer</li>
     * <li>PostgreSQLExplorer</li>
     * <li>WFSServerExplorer</li>
     * <li>Wms Store</li>
     * <li>...</li>
     * </ul>
     *
     * Valid values of layer type are:
     * <ul>
     * <li>Shape</li>
     * <li>Dbf</li>
     * <li>DXF</li>
     * <li>DGN</li>
     * <li>DWG</li>
     * <li>JExcel</li>
     * <li>PostgreSQL</li>
     * <li>WFSStore</li>
     * <li>Gdal Store</li>
     * <li>...</li>
     * </ul>
     *
     * Excamples of use:<br>
     * <code>
     * layer = createLayer(schema=schema,
     *                   servertype="FilesystemExplorer",
     *                   layertype="Shape",
     *                   shpFile="/home/osc/temp/test1.shp",
     *                   CRS="EPSG:25830",
     *                   geometryType=POINT
     *                   )
     * </code>
     *
     * @param schema the schema to use to create la layer.
     * @param serverType The server type (filesystem, BBDD, ...)
     * @param layerType The layer type to create (Shape, ...)
     * @param parameters the specific parameters to create the new layer
     * @return the new created layer
     *
     */
    public static FLayer createLayer(FeatureType schema, String serverType, String layerType, Object... parameters) {
        return null;
    }

    /**
     * Create a new layer with the specified parameters.
     *
     * Use as default serverType the "FilesystemExplorer".
     *
     * @param schema
     * @param layerType
     * @param parameters
     * @return
     */
    public static FLayer createLayer(FeatureType schema, String layerType, Object... parameters) {
        return null;
    }

    /**
     * Create a new shape with the specified parameters. If filename is not established, a temp filename will be set.
     * If CRS is None, it will be created with the CRS of the current view.
     *
     * Example:
     *     schema = createSchema()
     *     schema.append("ID", "INTEGER", 10)
     *     schema.append("GEOMETRY", "GEOMETRY")
     *     schema.get("GEOMETRY").setGeometryType(POINT, D2)
     *     newshape = createShape(schema, prefixname="newshape")
     *
     *
     * @param schema
     * @param filename, string, optional
     * @param geometryType, optional, integer, established in the schema
     * @param CRS, optional, string epsg code
     * @param prefixname, optional, string layer name with a prefix if filename is not established
     * @return
     */
    public static FLayer createShape(FeatureType schema, Object... parameters) {
        return null;
    }

    /**
     * Create a new table with the specified parameters.
     *
     * Use as default serverType the "FilesystemExplorer".
     *
     * @param schema
     * @param servertype
     * @param layerType
     * @param parameters
     * @return
     */
    public static FLayer createTable(FeatureType schema, String servertype, String layerType, Object... parameters) {
        return null;
    }
    
    /*
     * Create a new table with the specified parameters. If DbfFile is not established, a temp filename will be set.
     *
     * Example:
     *     schema = createSchema()
     *     schema.append("ID", "INTEGER", 10)
     *     newdbf = createDBF(schema, prefixname="newshape")
     *
     *
     * @param schema
     * @param DbfFile, optional, string
     * @param prefixname, optional, string layer name with a prefix if filename is not established
     * @return
     */
    public static FLayer createDBF(FeatureType schema, Object... parameters) {
        return null;
    }

    /**
     * Load an existing table file.
     *
     * @param dbffile, string, path to the table file to load
     * @return
     *
     */
    public static FLayer loadDBF(String dbffile) {
        return null;
    }

     /**
     * Load an existing table file.
     *
     * Example:
     *       table = loadTable(format="DBF",DbfFile=dbffile)
     *
     * @param format, string
     * @param path, string, path to the table file to load
     * @return
     *
     */
    public static FLayer loadTable(String format, Object... parameters) {
        return null;
    }

    /**
     * Load an existing shape file in the current view.
     *
     * @param path path to the shape file to load
     * @param projection to use to load the shape file
     * @return
     *
     */
    public static FLayer loadShapeFile(String path, String projection) {
        return null;
    }

    /**
     * Load an existing shape file in the current view.
     *
     * Use as default projection "CRS:84"
     *
     * @param path path to the shape file to load
     * @return
     *
     */
    public static FLayer loadShapeFile(String path) {
        return null;
    }

    /**
     * Load an existing raster file in the current view.
     *
     * @param path path to the raster file to load
     * @param projection to use to load the raster file
     * @return
     *
     */
    public static FLayer loadRasterFile(String path, String projection) {
        return null;
    }

    /**
     * Load an existing raster file in the current view.
     *
     * Use as default projection "CRS:84"
     *
     * @param path path to the raster file to load
     * @return
     *
     */
    public static FLayer loadRasterFile(String path) {
        return null;
    }

    /**
     * Load an existing layer and return it.
     *
     * Valid values of layer type are: 
     * - Shape 
     * - Gdal Store
     * - TODO
     *
     * Examples:
     *     loadLayer("Shape", shpFile=xfile, CRS="EPSG:25830")
     *     loadLayer("Gdal Store", uri=raster_uri)
     *
     * @param layerType
     * @param parameters
     * @return
     *
     */
    public static FLayer loadLayer(String layerType, Object... parameters) {
        return null;
    }

    /**
     * Send a message to the log system.
     *
     * The values of mode are:
     * <ul>
     * <li>LOGGER_INFO</li>
     * <li>LOGGER_WARN</li>
     * <li>LOGGER_ERROR</li>
     * </ul>
     *
     * @param msg to send to log
     * @param mode message type, is optional with default of LOGGER_INFO.
     * @param exception an exception to log, is optional.
     */
    public static void logger(String msg, int mode, Throwable exception) {

    }

    /**
     * Create the path to a resource.
     *
     * This function runs like the os.path.join, but if the first argument is a
     * full path name to a file, it only get the dirname of it.
     *
     * This is usefull to use with the variable __file__ as the first argument
     * to get a path name to a resource relative to the current module.
     *
     * Explample:<br>
     * <code>
     *  pathname = getResource(__file__,"data","icon.png")
     * </code>
     *
     * @param parameters parts of path to the resource.
     * @return the path name to the resource.
     */
    public String getResource(String... parameters) {
        return null;
    }

    /**
     * Open an existen data store an return it.
     *
     * The type of store depened of store to be opened. It can be:
     * <ul>
     * <li>Shape</li>
     * <li>Dbf</li>
     * <li>DXF</li>
     * <li>DGN</li>
     * <li>DWG</li>
     * <li>JExcel</li>
     * <li>PostgreSQL</li>
     * <li>WFSStore</li>
     * <li>Gdal Store</li>
     * </ul>
     *
     * Example with PostgreSQL connection:
     * <code>
     * from gvsig.utils import openStore
     *
     * os = openStore('PostgreSQL',_entity_='Persistence%3APostgreSQLStoreParameters',
     *                             port='5432',
     *                             JDBCDriverClass='org.postgresql.Driver',
     *                             UseSSL='false',
     *                             Schema='public',
     *                             Catalog='',
     *                             URL='jdbc%3Apostgresql%3A%2F%2Flocalhost%3A5432%2Fej1',
     *                             BaseOrder='',
     *                             Workingarea=None,
     *                             CRS='EPSG:23030',
     *                             PKFields='gid',
     *                             BaseFilter='',
     *                             DefaultGeometryField='geom',
     *                             Fields='gid%2Cnombre%2Cpoblacion%2Cgeom',
     *                             Table='ciudades',
     *                             SQL='',
     *                             password='postgres',
     *                             dbname='ej1',
     *                             host='localhost',
     *                             dbuser='postgres',
     *                             ProviderName='PostgreSQL')
     * </code>
     *
     * @param storeType the type of store to open.
     * @param parameters to open the store.
     * @return the opened data store
     */
    public DataStore openStore(String storeType, Object... parameters) {
        return null;
    }
    
    /**
     * Create a new projectionobject associated with the passed name of 
     * the projection.
     * 
     * Usually, the name is the abbreviation of the projection.
     * 
     * Is preferable to use this method <code>CRSFactory.getCRS(name)</code> instead.
     * 
     * @param name abbreviation of the projection
     * @return the projection object associated with the name
     */
    public IProjection getCRS(String name) {
        return null;
    }
    
    /**
     * Return the default data folder of gvSIG.
     * This is configured in the preferences of gvSIG.
     * 
     * @return the data folder of gvSIG
     */
    public String getDataFolder() {
        return null;
    }
    
    /**
     * Return the default projects folder of gvSIG.
     * This is configured in the preferences of gvSIG.
     * 
     * @return the projects folder of gvSIG.
     */
    public String getProjectsFolder() {
        return null;
    }
}
