
def relpath(path, start):
    """Return a relative version of a path"""
    if not path:
        raise ValueError("no path specified")
    import posixpath
    from posixpath import curdir, sep, pardir, join
    start_list = posixpath.abspath(start).split(sep)
    path_list = posixpath.abspath(path).split(sep)
    # Work out how much of the filepath is shared by start and path.
    i = len(posixpath.commonprefix([start_list, path_list]))
    rel_list = [pardir] * (len(start_list)-i) + path_list[i:]
    if not rel_list:
        return curdir
    return join(*rel_list)

