
from gvsig.uselib import use_plugin

use_plugin("org.gvsig.app.document.layout2.app.mainplugin")

from gvsig import *
from org.gvsig.app.project.documents.layout import DefaultLayoutManager
from javax.imageio import ImageIO

def main(*args):

  # Obtenemos la capa activa de la vista activa
  capa = currentLayer()

  # Obtenemos el primer elemento seleccionado de la capa
  seleccion = list()
  seleccion.extend(capa.getSelection())
  entidad = seleccion[0]

  # Obtenemos el encuadre del elemento seleccionado,
  # el rotulo y el logo a mostrar en el mapa.
  encuadre = entidad.geometry().getEnvelope()
  titulo = "Provincias de %s %s" % (entidad.NAMEUNIT, entidad.NATCODE[2:4])
  logo = ImageIO.read(script.getResource("datos/logos/"+ entidad.NATCODE[2:4]+".png"))
  
  # Obtenemos el objeto que se corresponde con el proyecto.
  proyecto = currentProject()() # Ojo con los dobles perentesis

  # Localizamos el mapa de nombre "Plantilla" de entre los documentos del proyecto
  plantilla = proyecto.getDocument("Plantilla",DefaultLayoutManager.TYPENAME )

  context = plantilla.getLayoutContext()

  # Nos recorremos todos los elementos del mapa buscando los que hemos etiquetado
  for elemento in  context.getAllFFrames():
    if elemento.getTag() == "Vista":
      # Ajustamos el encuadre de la vista al del elemento seleccionado
      mapContext = elemento.getMapContext()
      mapContext.getViewPort().setEnvelope(encuadre)
      mapContext.invalidate()
      
    elif elemento.getTag() == "Titulo":
      # Cambiamos el rotulo del texto que habiamos etiquetado en el mapa  
      elemento.clearText() 
      elemento.addText(titulo)

    elif elemento.getTag() == "Logotipo":
      # Cambiamos la imagen del logotipo
      elemento.setImage(logo)

  context.fullRefresh() 
  
