/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.demo;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.MediaSpec;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Term;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.CSSUnits;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.InlineElement;
import org.fit.cssbox.layout.Viewport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BoxBrowser {
    protected DefaultMutableTreeNode root;
    protected DefaultMutableTreeNode domRoot;
    protected BrowserConfig config = new BrowserConfig();
    public static BoxBrowser browser;
    protected JFrame mainWindow = null;
    protected JPanel mainPanel = null;
    protected JPanel urlPanel = null;
    protected JPanel contentPanel = null;
    protected JPanel structurePanel = null;
    protected JPanel statusPanel = null;
    protected JTextField statusText = null;
    protected JLabel jLabel = null;
    protected JTextField urlText = null;
    protected JButton okButton = null;
    protected JScrollPane contentScroll = null;
    protected JPanel contentCanvas = null;
    protected JSplitPane mainSplitter = null;
    protected JToolBar showToolBar = null;
    protected JButton redrawButton = null;
    protected JPanel toolPanel = null;
    protected JScrollPane boxScroll = null;
    protected JTree boxTree = null;
    protected JSplitPane infoSplitter = null;
    protected JPanel infoPanel = null;
    protected JScrollPane infoScroll = null;
    protected JTable infoTable = null;
    protected JTabbedPane treeTabs = null;
    protected JPanel DOMPanel = null;
    protected JScrollPane domScroll = null;
    protected JTree domTree = null;
    private JList styleList;
    private JScrollPane styleScroll;

    public BrowserConfig getConfig() {
        return this.config;
    }

    public URL displayURL(String urlstring) {
        try {
            if (!(urlstring.startsWith("http:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:"))) {
                urlstring = "http://" + urlstring;
            }
            DefaultDocumentSource docSource = new DefaultDocumentSource(urlstring);
            this.urlText.setText(((DocumentSource)docSource).getURL().toString());
            DefaultDOMSource parser = new DefaultDOMSource(docSource);
            Document doc = ((DOMSource)parser).parse();
            String encoding = parser.getCharset();
            MediaSpec media = new MediaSpec("screen");
            this.updateCurrentMedia(media);
            DOMAnalyzer da = new DOMAnalyzer(doc, ((DocumentSource)docSource).getURL());
            if (encoding == null) {
                encoding = da.getCharacterEncoding();
            }
            da.setDefaultEncoding(encoding);
            da.setMediaSpec(media);
            da.attributesToStyles();
            da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.getStyleSheets();
            this.contentCanvas = new BrowserCanvas(da.getRoot(), da, ((DocumentSource)docSource).getURL());
            ((BrowserCanvas)this.contentCanvas).setConfig(this.config);
            ((BrowserCanvas)this.contentCanvas).createLayout(this.contentScroll.getSize(), this.contentScroll.getVisibleRect());
            ((DocumentSource)docSource).close();
            this.contentCanvas.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("Click: " + e.getX() + ":" + e.getY());
                    BoxBrowser.this.canvasClick(e.getX(), e.getY());
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.contentScroll.setViewportView(this.contentCanvas);
            Viewport viewport = ((BrowserCanvas)this.contentCanvas).getViewport();
            this.root = this.createBoxTree(viewport);
            this.boxTree.setModel(new DefaultTreeModel(this.root));
            this.domRoot = this.createDomTree(doc);
            this.domTree.setModel(new DefaultTreeModel(this.domRoot));
            return ((DocumentSource)docSource).getURL();
        }
        catch (Exception e) {
            System.err.println("*** Error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    protected void updateCurrentMedia(MediaSpec media) {
        Dimension size = this.getContentScroll().getViewport().getSize();
        Dimension deviceSize = Toolkit.getDefaultToolkit().getScreenSize();
        ColorModel colors = Toolkit.getDefaultToolkit().getColorModel();
        media.setDimensions((float)size.width, (float)size.height);
        media.setDeviceDimensions((float)deviceSize.width, (float)deviceSize.height);
        media.setColor(colors.getComponentSize()[0]);
        if (colors instanceof IndexColorModel) {
            media.setColorIndex(((IndexColorModel)colors).getMapSize());
        }
        media.setResolution((float)Toolkit.getDefaultToolkit().getScreenResolution());
    }

    protected DefaultMutableTreeNode createBoxTree(Box root) {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode(root);
        if (root instanceof ElementBox) {
            ElementBox el = (ElementBox)root;
            for (int i = el.getStartChild(); i < el.getEndChild(); ++i) {
                ret.add(this.createBoxTree(el.getSubBox(i)));
            }
        }
        return ret;
    }

    protected DefaultMutableTreeNode createDomTree(Node root) {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode(root){
            private static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                Object o = this.getUserObject();
                if (o instanceof Element) {
                    Element el = (Element)this.getUserObject();
                    String ret = "<" + el.getNodeName();
                    NamedNodeMap attrs = el.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        ret = ret + " " + attrs.item(i).getNodeName() + "=\"" + attrs.item(i).getNodeValue() + "\"";
                    }
                    ret = ret + ">";
                    return ret;
                }
                if (o instanceof Text) {
                    return ((Text)o).getNodeValue();
                }
                return super.toString();
            }
        };
        NodeList child = root.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            ret.add(this.createDomTree(child.item(i)));
        }
        return ret;
    }

    private DefaultMutableTreeNode locateBox(DefaultMutableTreeNode root, int x, int y) {
        DefaultMutableTreeNode found = null;
        Box box = (Box)root.getUserObject();
        Rectangle bounds = box.getAbsoluteBounds();
        if (bounds.contains(x, y)) {
            found = root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode inside = this.locateBox((DefaultMutableTreeNode)root.getChildAt(i), x, y);
            if (inside == null) continue;
            if (found == null) {
                found = inside;
                continue;
            }
            Box fbox = (Box)found.getUserObject();
            Box ibox = (Box)inside.getUserObject();
            if (ibox.getAbsoluteBounds().width * ibox.getAbsoluteBounds().height >= fbox.getAbsoluteBounds().width * fbox.getAbsoluteBounds().height) continue;
            found = inside;
        }
        return found;
    }

    private DefaultMutableTreeNode locateObjectInTree(DefaultMutableTreeNode root, Object obj) {
        if (root.getUserObject().equals(obj)) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode ret = this.locateObjectInTree((DefaultMutableTreeNode)root.getChildAt(i), obj);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void canvasClick(int x, int y) {
        DefaultMutableTreeNode node = this.locateBox(this.root, x, y);
        if (node != null) {
            DefaultMutableTreeNode dt;
            Node domNode;
            TreePath select = new TreePath(node.getPath());
            this.boxTree.setSelectionPath(select);
            this.boxTree.expandPath(select);
            this.boxTree.scrollPathToVisible(select);
            if (node.getUserObject() instanceof Box && (domNode = ((Box)node.getUserObject()).getNode()) != null && (dt = this.locateObjectInTree(this.domRoot, domNode)) != null) {
                TreePath dselect = new TreePath(dt.getPath());
                this.domTree.setSelectionPath(dselect);
                this.domTree.expandPath(dselect);
                this.domTree.scrollPathToVisible(dselect);
            }
        }
    }

    private void displayBoxInfo(Box box) {
        Inline ib;
        ElementBox eb;
        Vector<String> cols = this.infoTableData("Property", "Value");
        Vector<Vector<String>> vals = new Vector<Vector<String>>();
        vals.add(this.infoTableData("ID", box.getOrder() + " (" + box.getSplitId() + ")"));
        vals.add(this.infoTableData("Parent", box.getParent() == null ? "- none -" : box.getParent().toString()));
        vals.add(this.infoTableData("Cont. block", box.getContainingBlock() == null ? "- none -" : box.getContainingBlock().toString()));
        vals.add(this.infoTableData("Clip. block", box.getClipBlock() == null ? "- none -" : box.getClipBlock().toString()));
        vals.add(this.infoTableData("S. parent", box.getStackingParent() == null ? "- none -" : box.getStackingParent().toString()));
        vals.add(this.infoTableData("Class", box.getClass().getSimpleName()));
        vals.add(this.infoTableData("Displayed", "" + box.isDisplayed()));
        vals.add(this.infoTableData("Visible", "" + box.isVisible()));
        vals.add(this.infoTableData("Empty", "" + box.isEmpty()));
        vals.add(this.infoTableData("Whitespace", "" + box.isWhitespace()));
        vals.add(this.infoTableData("Bounds", this.boundString(box.getBounds())));
        vals.add(this.infoTableData("AbsBounds", this.boundString(box.getAbsoluteBounds())));
        vals.add(this.infoTableData("Content", this.boundString(box.getContentBounds())));
        vals.add(this.infoTableData("Color", box.getVisualContext().getColor().toString()));
        vals.add(this.infoTableData("Font name", box.getVisualContext().getFont().getFontName() + " : " + box.getVisualContext().getFont().getName()));
        vals.add(this.infoTableData("Font size", box.getVisualContext().getFontSize() + "pt (" + CSSUnits.pixels(box.getVisualContext().getFontSize()) + "px)"));
        vals.add(this.infoTableData("Text decor", box.getVisualContext().getTextDecorationString()));
        vals.add(this.infoTableData("Min width", String.valueOf(box.getMinimalWidth())));
        vals.add(this.infoTableData("Max width", String.valueOf(box.getMaximalWidth())));
        if (box instanceof ElementBox) {
            eb = (ElementBox)box;
            vals.add(this.infoTableData("Display", eb.getDisplayString().toString()));
            vals.add(this.infoTableData("BgColor", eb.getBgcolor() == null ? "" : eb.getBgcolor().toString()));
            vals.add(this.infoTableData("Margin", eb.getMargin().toString()));
            vals.add(this.infoTableData("EMargin", eb.getEMargin().toString()));
            vals.add(this.infoTableData("Padding", eb.getPadding().toString()));
            vals.add(this.infoTableData("Border", eb.getBorder().toString()));
            vals.add(this.infoTableData("LineH", String.valueOf(eb.getLineHeight()) + "px"));
            vals.add(this.infoTableData("Position", eb.getPositionString()));
            vals.add(this.infoTableData("Coords", eb.getCoords().toString()));
            vals.add(this.infoTableData("ZIndex", eb.hasZIndex() ? String.valueOf(eb.getZIndex()) : "(auto)"));
        }
        if (box instanceof Inline) {
            ib = (Inline)((Object)box);
            vals.add(this.infoTableData("MaxLineH", String.valueOf(ib.getMaxLineHeight())));
            vals.add(this.infoTableData("TotalLine", String.valueOf(ib.getTotalLineHeight())));
            vals.add(this.infoTableData("Baseline", String.valueOf(ib.getBaselineOffset())));
            vals.add(this.infoTableData("Below base", String.valueOf(ib.getBelowBaseline())));
            vals.add(this.infoTableData("Half Lead", String.valueOf(ib.getHalfLead())));
        }
        if (box instanceof InlineElement) {
            ib = (InlineElement)((Object)box);
            vals.add(this.infoTableData("LineboxOfs", String.valueOf(ib.getLineboxOffset()) + "px"));
            vals.add(this.infoTableData("VAlign", ib.getVerticalAlign().toString()));
        }
        if (box instanceof BlockBox) {
            eb = (BlockBox)box;
            vals.add(this.infoTableData("Content layout", ((BlockBox)eb).containsBlocks() ? "blocks" : "inline"));
            vals.add(this.infoTableData("Float", ((BlockBox)eb).getFloatingString()));
            vals.add(this.infoTableData("Overflow", ((BlockBox)eb).getOverflowString()));
            vals.add(this.infoTableData("Clear", ((BlockBox)eb).getClearingString()));
            vals.add(this.infoTableData("Reference", ((BlockBox)eb).getAbsReference() == null ? "- none -" : ((BlockBox)eb).getAbsReference().toString()));
            vals.add(this.infoTableData("DOM parent", ((BlockBox)eb).getDomParent() == null ? "- none -" : ((BlockBox)eb).getDomParent().toString()));
            vals.add(this.infoTableData("floatY", String.valueOf(((BlockBox)eb).getFloatY())));
            vals.add(this.infoTableData("prefWidth", String.valueOf(((BlockBox)eb).getPreferredWidth())));
            vals.add(this.infoTableData("Indent", String.valueOf(((BlockBox)eb).getIndent())));
        }
        DefaultTableModel tab = new DefaultTableModel(vals, cols);
        this.infoTable.setModel(tab);
        if (box instanceof ElementBox) {
            NodeData style = ((ElementBox)box).getStyle();
            ArrayList names = new ArrayList(style.getPropertyNames());
            Collections.sort(names);
            StyleListItem[] items = new StyleListItem[names.size()];
            int i = 0;
            for (String name : names) {
                CSSProperty prop = style.getProperty(name);
                Term value = style.getValue(name, true);
                Declaration d = style.getSourceDeclaration(name);
                String text = name + ": ";
                text = value != null ? text + value.toString() : text + prop.toString();
                String srcd = d == null ? "???" : d.toString();
                String src = d != null && d.getSource() != null ? d.getSource().toString() : "<unknown>";
                items[i++] = new StyleListItem(text, src + " - " + srcd);
            }
            this.styleList.setListData(items);
        }
    }

    private Vector<String> infoTableData(String prop, String value) {
        Vector<String> cols = new Vector<String>(2);
        cols.add(prop);
        cols.add(value);
        return cols;
    }

    private String boundString(Rectangle rect) {
        return "[" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "]";
    }

    public BrowserCanvas getBrowserCanvas() {
        return (BrowserCanvas)this.contentCanvas;
    }

    public JFrame getMainWindow() {
        if (this.mainWindow == null) {
            this.mainWindow = new JFrame();
            this.mainWindow.setTitle("Box Browser");
            this.mainWindow.setVisible(true);
            this.mainWindow.setBounds(new Rectangle(0, 0, 583, 251));
            this.mainWindow.setContentPane(this.getMainPanel());
            this.mainWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    BoxBrowser.this.mainWindow.setVisible(false);
                    System.exit(0);
                }
            });
        }
        return this.mainWindow;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = -1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = -1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.weightx = 1.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridy = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 1;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getJPanel3(), gridBagConstraints2);
            this.mainPanel.add((Component)this.getUrlPanel(), gridBagConstraints);
            this.mainPanel.add((Component)this.getMainSplitter(), gridBagConstraints11);
            this.mainPanel.add((Component)this.getStatusPanel(), gridBagConstraints3);
        }
        return this.mainPanel;
    }

    private JPanel getUrlPanel() {
        if (this.urlPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.insets = new Insets(4, 0, 5, 7);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.anchor = 10;
            gridBagConstraints5.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints5.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Location :");
            this.urlPanel = new JPanel();
            this.urlPanel.setLayout(new GridBagLayout());
            this.urlPanel.add((Component)this.jLabel, gridBagConstraints5);
            this.urlPanel.add((Component)this.getUrlText(), gridBagConstraints6);
            this.urlPanel.add((Component)this.getOkButton(), gridBagConstraints7);
        }
        return this.urlPanel;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(1);
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(gridLayout1);
            this.contentPanel.add((Component)this.getContentScroll(), null);
        }
        return this.contentPanel;
    }

    private JPanel getStructurePanel() {
        if (this.structurePanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.structurePanel = new JPanel();
            this.structurePanel.setPreferredSize(new Dimension(200, 408));
            this.structurePanel.setLayout(gridLayout);
            this.structurePanel.add((Component)this.getBoxScroll(), null);
        }
        return this.structurePanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(0, 7, 0, 0);
            gridBagConstraints4.gridy = 2;
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new GridBagLayout());
            this.statusPanel.add((Component)this.getStatusText(), gridBagConstraints4);
        }
        return this.statusPanel;
    }

    private JTextField getStatusText() {
        if (this.statusText == null) {
            this.statusText = new JTextField();
            this.statusText.setEditable(false);
            this.statusText.setText("Browser ready.");
        }
        return this.statusText;
    }

    private JTextField getUrlText() {
        if (this.urlText == null) {
            this.urlText = new JTextField();
            this.urlText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BoxBrowser.this.displayURL(BoxBrowser.this.urlText.getText());
                }
            });
        }
        return this.urlText;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Go!");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BoxBrowser.this.displayURL(BoxBrowser.this.urlText.getText());
                }
            });
        }
        return this.okButton;
    }

    private JScrollPane getContentScroll() {
        if (this.contentScroll == null) {
            this.contentScroll = new JScrollPane();
            this.contentScroll.setViewportView(this.getContentCanvas());
            this.contentScroll.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (BoxBrowser.this.contentCanvas != null && BoxBrowser.this.contentCanvas instanceof BrowserCanvas) {
                        ((BrowserCanvas)BoxBrowser.this.contentCanvas).createLayout(BoxBrowser.this.contentScroll.getSize(), BoxBrowser.this.contentScroll.getViewport().getViewRect());
                        BoxBrowser.this.contentScroll.repaint();
                        BoxBrowser.this.root = BoxBrowser.this.createBoxTree(((BrowserCanvas)BoxBrowser.this.contentCanvas).getViewport());
                        BoxBrowser.this.boxTree.setModel(new DefaultTreeModel(BoxBrowser.this.root));
                    }
                }
            });
        }
        return this.contentScroll;
    }

    private JPanel getContentCanvas() {
        if (this.contentCanvas == null) {
            this.contentCanvas = new JPanel();
        }
        return this.contentCanvas;
    }

    private JSplitPane getMainSplitter() {
        if (this.mainSplitter == null) {
            this.mainSplitter = new JSplitPane();
            this.mainSplitter.setLeftComponent(this.getTreeTabs());
            this.mainSplitter.setRightComponent(this.getInfoSplitter());
        }
        return this.mainSplitter;
    }

    private JToolBar getShowToolBar() {
        if (this.showToolBar == null) {
            this.showToolBar = new JToolBar();
            this.showToolBar.add(this.getRedrawButton());
        }
        return this.showToolBar;
    }

    private JButton getRedrawButton() {
        if (this.redrawButton == null) {
            this.redrawButton = new JButton();
            this.redrawButton.setText("Clear");
            this.redrawButton.setMnemonic(0);
            this.redrawButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((BrowserCanvas)BoxBrowser.this.contentCanvas).redrawBoxes();
                    BoxBrowser.this.contentCanvas.repaint();
                }
            });
        }
        return this.redrawButton;
    }

    private JPanel getJPanel3() {
        if (this.toolPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.toolPanel = new JPanel();
            this.toolPanel.setLayout(flowLayout);
            this.toolPanel.add((Component)this.getShowToolBar(), null);
        }
        return this.toolPanel;
    }

    private JScrollPane getBoxScroll() {
        if (this.boxScroll == null) {
            this.boxScroll = new JScrollPane();
            this.boxScroll.setViewportView(this.getBoxTree());
        }
        return this.boxScroll;
    }

    private JTree getBoxTree() {
        if (this.boxTree == null) {
            this.boxTree = new JTree();
            this.boxTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("(box tree)")));
            this.boxTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    Box box;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)BoxBrowser.this.boxTree.getLastSelectedPathComponent();
                    if (node != null && (box = (Box)node.getUserObject()) != null) {
                        DefaultMutableTreeNode dt;
                        box.drawExtent(((BrowserCanvas)BoxBrowser.this.contentCanvas).getImageGraphics());
                        BoxBrowser.this.contentCanvas.repaint();
                        BoxBrowser.this.displayBoxInfo(box);
                        if (box.getNode() != null && (dt = BoxBrowser.this.locateObjectInTree(BoxBrowser.this.domRoot, box.getNode())) != null) {
                            TreePath dselect = new TreePath(dt.getPath());
                            BoxBrowser.this.domTree.setSelectionPath(dselect);
                            BoxBrowser.this.domTree.expandPath(dselect);
                            BoxBrowser.this.domTree.scrollPathToVisible(dselect);
                        }
                    }
                }
            });
        }
        return this.boxTree;
    }

    private JSplitPane getInfoSplitter() {
        if (this.infoSplitter == null) {
            this.infoSplitter = new JSplitPane();
            this.infoSplitter.setResizeWeight(1.0);
            this.infoSplitter.setDividerLocation(800);
            this.infoSplitter.setLeftComponent(this.getContentPanel());
            this.infoSplitter.setRightComponent(this.getInfoPanel());
        }
        return this.infoSplitter;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.setRows(2);
            gridLayout2.setColumns(1);
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(gridLayout2);
            this.infoPanel.add((Component)this.getInfoScroll(), null);
            this.infoPanel.add(this.getStyleScroll());
        }
        return this.infoPanel;
    }

    private JScrollPane getInfoScroll() {
        if (this.infoScroll == null) {
            this.infoScroll = new JScrollPane();
            this.infoScroll.setViewportView(this.getInfoTable());
        }
        return this.infoScroll;
    }

    private JTable getInfoTable() {
        if (this.infoTable == null) {
            this.infoTable = new JTable();
        }
        return this.infoTable;
    }

    private JTabbedPane getTreeTabs() {
        if (this.treeTabs == null) {
            this.treeTabs = new JTabbedPane();
            this.treeTabs.addTab("Box Tree", this.getStructurePanel());
            this.treeTabs.addTab("DOM Tree", null, this.getDOMPanel(), null);
        }
        return this.treeTabs;
    }

    private JList getStyleList() {
        if (this.styleList == null) {
            this.styleList = new JList(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    int index = this.locationToIndex(e.getPoint());
                    if (-1 < index) {
                        StyleListItem item = (StyleListItem)this.getModel().getElementAt(index);
                        return item.getToolTipText();
                    }
                    return null;
                }
            };
        }
        return this.styleList;
    }

    private JScrollPane getStyleScroll() {
        if (this.styleScroll == null) {
            this.styleScroll = new JScrollPane();
            this.styleScroll.setViewportView(this.getStyleList());
        }
        return this.styleScroll;
    }

    private JPanel getDOMPanel() {
        if (this.DOMPanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.weightx = 1.0;
            this.DOMPanel = new JPanel();
            this.DOMPanel.setLayout(new GridBagLayout());
            this.DOMPanel.add((Component)this.getDomScroll(), gridBagConstraints8);
        }
        return this.DOMPanel;
    }

    private JScrollPane getDomScroll() {
        if (this.domScroll == null) {
            this.domScroll = new JScrollPane();
            this.domScroll.setViewportView(this.getDomTree());
        }
        return this.domScroll;
    }

    private JTree getDomTree() {
        if (this.domTree == null) {
            this.domTree = new JTree();
            this.domTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                }
            });
        }
        return this.domTree;
    }

    public static void main(String[] args) {
        browser = new BoxBrowser();
        JFrame main = browser.getMainWindow();
        main.setSize(1200, 600);
        main.setVisible(true);
    }

    class StyleListItem {
        private String text;
        private String tooltip;

        public StyleListItem(String text, String tooltip) {
            this.text = text;
            this.tooltip = tooltip;
        }

        public String getToolTipText() {
            return this.tooltip;
        }

        public String toString() {
            return this.text;
        }
    }
}

