/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.gui.beans.DefaultBean;

public class Pager
extends DefaultBean {
    private static final long serialVersionUID = 1997136221292929382L;
    private JPanel buttonsPanel = null;
    private JButton btnFastBackward = null;
    private JButton btnBackward = null;
    private JTextField txtItemCountDisplay = null;
    private JButton btnForward = null;
    private JButton btnFastForward = null;
    private JPanel sliderPanel = null;
    private JSlider slider = null;
    private int itemCount;
    private int lowLimit;
    private int currentValue = -1;
    private int orientation;
    private boolean refreshing = false;
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;

    public Pager(int orientation) {
        this.orientation = orientation;
        this.initialize(0, 0);
    }

    public Pager(int lowIndex, int itemCount, int orientation) {
        this.orientation = orientation;
        this.initialize(lowIndex, itemCount);
    }

    private void initialize(int lowIndex, int itemCount) {
        this.setItemCount(itemCount);
        this.lowLimit = lowIndex;
        this.setLayout(null);
        if (this.orientation == VERTICAL) {
            this.setSize(45, 305);
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
            this.setPreferredSize(new Dimension(40, 300));
        } else {
            this.setSize(240, 50);
            this.setPreferredSize(new Dimension(190, 50));
        }
        this.add((Component)this.getSliderPanel(), null);
        this.add((Component)this.getButtonsPanel(), null);
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(null);
            this.buttonsPanel.setName("buttonsPanel");
            this.buttonsPanel.setPreferredSize(new Dimension(173, 50));
            if (this.orientation == VERTICAL) {
                this.buttonsPanel.setBounds(3, 182, 35, 115);
            } else {
                this.buttonsPanel.setBounds(5, 25, 240, 25);
            }
            this.buttonsPanel.add((Component)this.getBtnFastBackward(), null);
            this.buttonsPanel.add((Component)this.getBtnBackward(), null);
            this.buttonsPanel.add((Component)this.getTxtItemCountDisplay(), null);
            this.buttonsPanel.add((Component)this.getBtnForward(), null);
            this.buttonsPanel.add((Component)this.getBtnFastForward(), null);
        }
        return this.buttonsPanel;
    }

    private JButton getBtnFastBackward() {
        if (this.btnFastBackward == null) {
            this.btnFastBackward = new JButton();
            if (this.orientation == VERTICAL) {
                this.btnFastBackward.setBounds(7, 1, 20, 24);
            } else {
                this.btnFastBackward.setBounds(2, 1, 20, 24);
            }
            this.btnFastBackward.setEnabled(this.itemCount != 0);
            this.btnFastBackward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Pager.this.currentValue != Pager.this.lowLimit) {
                        Pager.this.setValue(Pager.this.lowLimit, true);
                    }
                }
            });
            this.btnFastBackward.setIcon(new ImageIcon(this.getClass().getResource("images/fastbackward.png")));
        }
        return this.btnFastBackward;
    }

    private JButton getBtnBackward() {
        if (this.btnBackward == null) {
            this.btnBackward = new JButton();
            if (this.orientation == VERTICAL) {
                this.btnBackward.setBounds(7, 21, 20, 24);
            } else {
                this.btnBackward.setBounds(21, 1, 20, 24);
            }
            this.btnBackward.setEnabled(this.itemCount != 0);
            this.btnBackward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Pager.this.currentValue > Pager.this.lowLimit) {
                        Pager.this.setValue(Pager.this.currentValue - 1, true);
                    }
                }
            });
            this.btnBackward.setIcon(new ImageIcon(this.getClass().getResource("images/backward.png")));
        }
        return this.btnBackward;
    }

    private JTextField getTxtItemCountDisplay() {
        if (this.txtItemCountDisplay == null) {
            this.txtItemCountDisplay = new JTextField();
            this.txtItemCountDisplay.setEnabled(this.itemCount != 0);
            this.txtItemCountDisplay.setHorizontalAlignment(0);
            if (this.orientation == VERTICAL) {
                this.txtItemCountDisplay.setBounds(2, 43, 33, 23);
            } else {
                this.txtItemCountDisplay.setBounds(43, 2, 144, 23);
            }
            this.txtItemCountDisplay.setText(this.lowLimit + " / " + this.itemCount);
            this.txtItemCountDisplay.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Pager.this.txtItemCountDisplay.setText(Pager.this.currentValue + "");
                    Pager.this.txtItemCountDisplay.setSelectionStart(0);
                    Pager.this.txtItemCountDisplay.setSelectionEnd(Pager.this.txtItemCountDisplay.getText().length());
                }
            });
            this.txtItemCountDisplay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        int v = Integer.parseInt(Pager.this.txtItemCountDisplay.getText());
                        v = v > Pager.this.itemCount ? Pager.this.itemCount : v;
                        Pager.this.setValue(v, true);
                    }
                    catch (Exception ex) {
                        Pager.this.refreshText(Pager.this.currentValue);
                    }
                    Pager.this.txtItemCountDisplay.transferFocusDownCycle();
                }
            });
            this.txtItemCountDisplay.setEnabled(false);
        }
        return this.txtItemCountDisplay;
    }

    public void setValue(int number, boolean fireEvent) {
        if (number < this.lowLimit) {
            number = this.lowLimit;
        }
        if (number > this.itemCount - 1) {
            number = this.itemCount;
        }
        if (number != this.currentValue) {
            this.currentValue = number;
            this.refreshControls();
            if (fireEvent) {
                this.callValueChanged(this.currentValue);
            }
        }
    }

    private void refreshControls() {
        int normalizedValue = (int)((float)this.currentValue / (float)this.itemCount * 100.0f);
        this.refreshSlider(normalizedValue);
        this.refreshText(this.currentValue);
    }

    private void refreshSlider(int normalizedValue) {
        this.refreshing = true;
        this.getSlider().setValue(normalizedValue);
        this.refreshing = false;
    }

    private void refreshText(int value) {
        String newText = value + 1 + " / " + this.itemCount;
        if (!this.getTxtItemCountDisplay().getText().equals(newText)) {
            this.getTxtItemCountDisplay().setText(newText);
        }
    }

    private JButton getBtnForward() {
        if (this.btnForward == null) {
            this.btnForward = new JButton();
            if (this.orientation == VERTICAL) {
                this.btnForward.setBounds(7, 67, 20, 24);
            } else {
                this.btnForward.setBounds(189, 1, 20, 24);
            }
            this.btnForward.setEnabled(this.itemCount != 0);
            this.btnForward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Pager.this.currentValue < Pager.this.itemCount - 1) {
                        Pager.this.setValue(Pager.this.currentValue + 1, true);
                    }
                }
            });
            this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("images/forward.png")));
        }
        return this.btnForward;
    }

    private JButton getBtnFastForward() {
        if (this.btnFastForward == null) {
            this.btnFastForward = new JButton();
            if (this.orientation == VERTICAL) {
                this.btnFastForward.setBounds(7, 91, 20, 24);
            } else {
                this.btnFastForward.setBounds(208, 1, 20, 24);
            }
            this.btnFastForward.setEnabled(this.itemCount != 0);
            this.btnFastForward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Pager.this.currentValue < Pager.this.itemCount - 1) {
                        Pager.this.setValue(Pager.this.itemCount - 1, true);
                    }
                }
            });
            this.btnFastForward.setIcon(new ImageIcon(this.getClass().getResource("images/fastforward.png")));
        }
        return this.btnFastForward;
    }

    private JPanel getSliderPanel() {
        if (this.sliderPanel == null) {
            this.sliderPanel = new JPanel();
            this.sliderPanel.setLayout(null);
            this.sliderPanel.setName("sliderPanel");
            if (this.orientation == VERTICAL) {
                this.sliderPanel.setBounds(3, 0, 35, 181);
            } else {
                this.sliderPanel.setBounds(5, 0, 300, 26);
            }
            this.sliderPanel.setEnabled(false);
            this.sliderPanel.add((Component)this.getSlider(), null);
        }
        return this.sliderPanel;
    }

    private JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider();
            this.slider.setValue(0);
            if (this.orientation == VERTICAL) {
                this.slider.setOrientation(1);
                this.slider.setSize(24, 230);
            } else {
                this.slider.setOrientation(0);
                this.slider.setSize(230, 24);
            }
            this.slider.setLocation(0, 1);
            this.slider.setEnabled(this.itemCount != 0);
            this.slider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    int value = (int)((double)(Pager.this.getSlider().getValue() * Pager.this.itemCount) * 0.01);
                    if (value >= Pager.this.itemCount) {
                        value = Pager.this.itemCount - 1;
                    }
                    Pager.this.refreshText(value);
                    Pager.this.setValue(value, false);
                }
            });
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = (int)((double)(Pager.this.getSlider().getValue() * Pager.this.itemCount) * 0.01);
                    if (value >= Pager.this.itemCount) {
                        value = Pager.this.itemCount - 1;
                    }
                    Pager.this.refreshText(value);
                    if (!Pager.this.refreshing) {
                        Pager.this.callValueChanged(value);
                    }
                }
            });
        }
        return this.slider;
    }

    public void setItemCount(int count) {
        this.itemCount = count;
        this.getSlider().setEnabled(count != 0);
        this.getBtnFastBackward().setEnabled(count != 0);
        this.getBtnBackward().setEnabled(count != 0);
        this.getTxtItemCountDisplay().setEnabled(count != 0);
        this.getBtnForward().setEnabled(count != 0);
        this.getBtnFastForward().setEnabled(count != 0);
    }

    public void setStartingPosition(int initialPosition) {
        this.lowLimit = initialPosition;
    }

    public void setCurrentPosition(int pos) {
        this.setValue(pos, true);
    }
}

