/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformset.base;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormSetButtonBar
implements org.gvsig.tools.swing.api.Component {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormSetButtonBar.class);
    public static final int ID_ACTION_FIRST = 1;
    public static final int ID_ACTION_PREVIOUS = 2;
    public static final int ID_ACTION_NEXT = 3;
    public static final int ID_ACTION_LAST = 4;
    public static final int ID_ACTION_SAVE = 5;
    public static final int ID_ACTION_NEW = 6;
    public static final int ID_ACTION_CANCEL_NEW = 7;
    public static final int ID_ACTION_DELETE = 8;
    public static final int ID_ACTION_SEARCH = 9;
    public static final int ID_ACTION_CLOSE = 10;
    public static final int ID_ACTION_SET_CURRENT_RECORD = 11;
    private static final int MAX_ACTIONS = 12;
    private static final int COUNTER_HEIGHT = 50;
    private static final int COUNTER_WIDTH = 100;
    private JPanel contents = null;
    private Set listeners = null;
    private int current = 0;
    private String currentLabel = null;
    private int numrecords = 0;
    private JPanel othersButtons;
    private final List<Action> otherActions;
    private final Map<String, JButton> otherButtons;
    private final Map<String, Integer> actionNameToId;
    private boolean readOnly = false;
    private JButton records;
    private final JButton[] buttons = new JButton[12];
    private final Boolean[] activatedActions = new Boolean[12];

    public FormSetButtonBar() {
        for (int i = 0; i < this.activatedActions.length; ++i) {
            this.activatedActions[i] = true;
        }
        this.actionNameToId = new HashMap<String, Integer>();
        this.actionNameToId.put("first", 1);
        this.actionNameToId.put("previous", 2);
        this.actionNameToId.put("next", 3);
        this.actionNameToId.put("last", 4);
        this.actionNameToId.put("save", 5);
        this.actionNameToId.put("new", 6);
        this.actionNameToId.put("cancel-new", 7);
        this.actionNameToId.put("delete", 8);
        this.actionNameToId.put("search", 9);
        this.actionNameToId.put("close", 10);
        this.actionNameToId.put("set-current-record", 11);
        this.listeners = new HashSet();
        this.otherActions = new ArrayList<Action>();
        this.otherButtons = new HashMap<String, JButton>();
    }

    public JComponent asJComponent() {
        if (this.contents == null) {
            this.initComponents();
        }
        return this.contents;
    }

    public void addListener(FormSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FormSetListener listener) {
        this.listeners.remove(listener);
    }

    public void fireEvent(String action, Object value) {
        block31: {
            Integer actionid;
            block30: {
                actionid = this.actionNameToId.get(action);
                if (actionid != null) break block30;
                JButton button = this.otherButtons.get(action);
                if (button == null || button.getAction() == null) break block31;
                button.getAction().actionPerformed(new ActionEvent(value, 1, action));
                break block31;
            }
            if (this.readOnly) {
                for (FormSetListener listener : this.listeners) {
                    try {
                        switch (actionid) {
                            case 1: {
                                listener.doActionFirst();
                                break;
                            }
                            case 2: {
                                listener.doActionPrevious();
                                break;
                            }
                            case 3: {
                                listener.doActionNext();
                                break;
                            }
                            case 4: {
                                listener.doActionLast();
                                break;
                            }
                            case 9: {
                                listener.doActionSearch();
                                break;
                            }
                            case 10: {
                                listener.doActionClose();
                                break;
                            }
                            case 11: {
                                listener.doSetCurrentRecord((Integer)value);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
                    }
                }
            } else {
                for (FormSetListener listener : this.listeners) {
                    try {
                        switch (actionid) {
                            case 1: {
                                listener.doActionFirst();
                                break;
                            }
                            case 2: {
                                listener.doActionPrevious();
                                break;
                            }
                            case 3: {
                                listener.doActionNext();
                                break;
                            }
                            case 4: {
                                listener.doActionLast();
                                break;
                            }
                            case 5: {
                                listener.doActionSave();
                                break;
                            }
                            case 6: {
                                listener.doActionNew();
                                break;
                            }
                            case 7: {
                                listener.doActionCancelNew();
                                break;
                            }
                            case 8: {
                                listener.doActionDelete();
                                break;
                            }
                            case 9: {
                                listener.doActionSearch();
                                break;
                            }
                            case 10: {
                                listener.doActionClose();
                                break;
                            }
                            case 11: {
                                listener.doSetCurrentRecord((Integer)value);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.info("Error calling listener " + listener.toString() + "(" + listener.getClass().getName() + ") from " + this.toString() + "(" + this.getClass().getName() + ").", (Throwable)ex);
                    }
                }
            }
        }
    }

    private void updateRecords() {
        this.setEnabled("new", true);
        if (this.numrecords <= 0) {
            this.records.setText("0 / 0");
            this.setEnabled(1, false);
            this.setEnabled(2, false);
            this.setEnabled(3, false);
            this.setEnabled("last", false);
            return;
        }
        if (this.currentLabel == null) {
            this.records.setText(this.current + 1 + " / " + this.numrecords);
        } else {
            this.records.setText(this.currentLabel + " / " + this.numrecords);
        }
        if (this.current <= 0) {
            this.current = 0;
            this.setEnabled(1, false);
            this.setEnabled(2, false);
            this.setEnabled(3, true);
            this.setEnabled("last", true);
        } else if (this.current >= this.numrecords - 1) {
            this.current = this.numrecords - 1;
            this.setEnabled(3, false);
            this.setEnabled("last", false);
            this.setEnabled(1, true);
            this.setEnabled(2, true);
        } else {
            this.setEnabled(3, true);
            this.setEnabled("last", true);
            this.setEnabled(1, true);
            this.setEnabled(2, true);
        }
    }

    private void initComponents() {
        this.contents = new JPanel();
        this.contents.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.ipady = 1;
        c.gridy = 0;
        c.gridy = 0;
        c.gridx = 0;
        this.contents.add((Component)this.getStandardButtonBar(), c);
        this.othersButtons = new JPanel();
        this.othersButtons.setLayout(new FlowLayout(3, 4, 4));
        for (Action action : this.otherActions) {
            this.othersButtons.add(new JButton(action));
        }
        c.gridx = 1;
        this.contents.add((Component)this.othersButtons, c);
        c.gridx = 2;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.contents.add((Component)this.createButton(i18n.getTranslation("_Close"), "common-form-close", "close", 0), c);
        c.weightx = 1.0;
        c.gridx = 3;
        this.contents.add((Component)new JLabel(), c);
        this.initButtons();
        this.updateRecords();
    }

    private JPanel getStandardButtonBar() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        JPanel theContents = new JPanel();
        theContents.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.ipadx = 2;
        c.ipady = 1;
        c.gridy = 0;
        JComponent firstButton = this.createButton(i18nManager.getTranslation("_first"), "common-form-first", "first", 35);
        c.gridx = 0;
        theContents.add((Component)firstButton, c);
        c.gridx = 1;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("_back"), "common-form-previous", "previous", 33), c);
        this.records = new JButton();
        this.records.setCursor(new Cursor(12));
        this.records.setBorder(BorderFactory.createEmptyBorder());
        this.records.setBorderPainted(false);
        this.records.setFocusPainted(false);
        this.records.setContentAreaFilled(false);
        this.records.addActionListener(ae -> this.doGoRecord());
        int height = this.records.getFont().getSize();
        if (height < 16) {
            height = 16;
        }
        this.records.setPreferredSize(new Dimension(100, height));
        this.records.setHorizontalAlignment(0);
        this.buttons[11] = this.records;
        c.gridx = 2;
        theContents.add((Component)this.records, c);
        c.gridx = 3;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("_next"), "common-form-next", "next", 34), c);
        c.gridx = 4;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("_last"), "common-form-last", "last", 36), c);
        c.gridx = 5;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("guardar"), "common-form-save", "save", 85), c);
        c.gridx = 6;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("nuevo"), "common-form-new", "new", 117), c);
        c.gridx = 7;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("cancelar nuevo"), "common-form-cancelnew", "cancel-new", 123), c);
        c.gridx = 8;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("borrar"), "common-form-delete", "delete", 114), c);
        c.gridx = 9;
        theContents.add((Component)this.createButton(i18nManager.getTranslation("search"), "common-form-search", "search", 72), c);
        return theContents;
    }

    public void doGoRecord() {
        int record;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        String value = JOptionPane.showInputDialog(this.records, i18nManager.getTranslation("_Enter_the_registration_number_you_want_to_go"), i18nManager.getTranslation("_Go_to_record"), 3);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        try {
            record = Integer.parseInt(value);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.records, i18nManager.getTranslation("_invalid_record_number"), i18nManager.getTranslation("_Go_to_record"), 2);
            return;
        }
        this.fireEvent("set-current-record", record);
    }

    private void initButtons() {
        this.setActionActive(5, this.isActionActive(5));
        this.setActionActive(6, this.isActionActive(6));
        this.setActionActive(9, this.isActionActive(9));
        this.setActionActive(8, this.isActionActive(8));
        this.setActionActive(10, this.isActionActive(10));
    }

    private JComponent createButton(String tip, String image, String action, int mnemonic) {
        int actionid = this.actionNameToId.get(action);
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        ImageIcon icon = iconTheme.get(image);
        JButton button = new JButton(icon);
        if (mnemonic != 0) {
            button.setMnemonic(mnemonic);
        }
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setToolTipText(tip);
        button.setCursor(new Cursor(12));
        button.addActionListener(ae -> this.fireEvent(action, null));
        this.buttons[actionid] = button;
        return button;
    }

    public void setEnabled(int action, boolean enabled) {
        JButton button = this.buttons[action];
        if (enabled) {
            button.setEnabled(true);
        } else {
            button.setEnabled(false);
        }
    }

    public void setVisible(int action, boolean visible) {
        JButton button = this.buttons[action];
        if (visible) {
            button.setVisible(true);
        } else {
            button.setVisible(false);
        }
    }

    public void setVisible(String id, boolean visible) {
        Integer x = this.actionNameToId.get(id);
        if (x != null) {
            this.buttons[x].setVisible(visible);
            return;
        }
        JButton button = this.otherButtons.get(id);
        if (button == null) {
            return;
        }
        button.setVisible(visible);
    }

    public void setEnabled(String id, boolean enabled) {
        if (StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)"#navigation")) {
            if (enabled) {
                this.updateRecords();
                return;
            }
            this.setEnabled(3, false);
            this.setEnabled(2, false);
            this.setEnabled(1, false);
            this.setEnabled(4, false);
            return;
        }
        Integer x = this.actionNameToId.get(id);
        if (x != null) {
            this.buttons[x].setEnabled(enabled);
            return;
        }
        JButton button = this.otherButtons.get(id);
        if (button == null) {
            return;
        }
        button.setEnabled(enabled);
    }

    public boolean isEnabled(String id) {
        Integer x = this.actionNameToId.get(id);
        if (x != null) {
            return this.buttons[x].isEnabled();
        }
        JButton button = this.otherButtons.get(id);
        if (button == null) {
            throw new IllegalArgumentException("Don't exists action '" + id + "'.");
        }
        return button.isEnabled();
    }

    public JComponent getActionButton(String id) {
        Integer x = this.actionNameToId.get(id);
        if (x != null) {
            return this.buttons[x];
        }
        JButton button = this.otherButtons.get(id);
        return button;
    }

    public boolean isVisible(String id) {
        Integer x = this.actionNameToId.get(id);
        if (x != null) {
            return this.buttons[x].isVisible();
        }
        JButton button = this.otherButtons.get(id);
        if (button == null) {
            throw new IllegalArgumentException("Don't exists action '" + id + "'.");
        }
        return button.isVisible();
    }

    public void setCurrent(int current) {
        this.current = current;
        this.updateRecords();
    }

    public void setCurrentLabel(String label) {
        this.currentLabel = label;
        this.updateRecords();
    }

    public void setNumrecords(int numrecords) {
        this.numrecords = numrecords;
        this.updateRecords();
    }

    public void setActionActive(int action, boolean active) {
        if (action == 5 || action == 8 || action == 6 || action == 9 || action == 10) {
            if (this.contents == null) {
                this.initComponents();
            }
            this.activatedActions[action] = active;
            this.buttons[action].setVisible(active);
        }
    }

    public boolean isActionActive(int action) {
        return this.activatedActions[action];
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEnabled(5, !readOnly);
        this.setEnabled("new", !readOnly);
        this.setEnabled(7, !readOnly);
        this.setEnabled("delete", !readOnly);
        this.setEnabled(9, true);
        this.setEnabled("close", true);
        this.updateRecords();
    }

    public void addAction(Action action) {
        this.otherActions.add(action);
        if (this.contents == null) {
            return;
        }
        JButton button = new JButton(action);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setCursor(new Cursor(12));
        String id = Objects.toString(action.getValue("ActionCommandKey"), null);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            this.otherButtons.put(id, button);
        }
        this.othersButtons.add(button);
    }

    public Action getAction(String id) {
        for (Action action : this.otherActions) {
            String actionId = Objects.toString(action.getValue("ActionCommandKey"), null);
            if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)actionId)) continue;
            return action;
        }
        return null;
    }

    public List<Action> getActions() {
        return this.otherActions;
    }

    public static interface FormSetListener {
        public boolean doActionFirst();

        public boolean doActionPrevious();

        public boolean doActionNext();

        public boolean doActionLast();

        public boolean doActionSave();

        public boolean doActionNew();

        public boolean doActionCancelNew();

        public boolean doActionDelete();

        public boolean doActionSearch();

        public boolean doActionClose();

        public void doSetCurrentRecord(int var1);
    }
}

