/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import org.gvsig.utils.SymbolSet;

public class StringUtilities {
    public static String insert(String base, int position, String injerto) {
        return base.substring(0, position) + injerto + base.substring(position);
    }

    public static boolean isBetweenSymbols(String string, int position, String startSymbol, String endSymbol) {
        TreeSet<Integer> startSymbolIndexes = new TreeSet<Integer>();
        TreeSet<Integer> endSymbolIndexes = new TreeSet<Integer>();
        boolean sameSymbolOpen = true;
        int pos = 0;
        while ((pos = string.indexOf(startSymbol, pos)) < position && pos != -1) {
            startSymbolIndexes.add(pos);
            ++pos;
        }
        pos = 0;
        while ((pos = string.indexOf(endSymbol, pos)) < position && pos != -1) {
            endSymbolIndexes.add(pos);
            ++pos;
        }
        Iterator startIndexesIterator = startSymbolIndexes.iterator();
        Iterator endIndexesIterator = endSymbolIndexes.iterator();
        Integer startIndex = null;
        Integer endIndex = null;
        int count = 0;
        while (startIndexesIterator.hasNext() || endIndexesIterator.hasNext()) {
            if (startIndexesIterator.hasNext()) {
                startIndex = (Integer)startIndexesIterator.next();
            }
            if (endIndexesIterator.hasNext()) {
                endIndex = (Integer)endIndexesIterator.next();
            }
            if (startIndex == null) {
                if (endIndexesIterator.hasNext()) {
                    endIndex = (Integer)startIndexesIterator.next();
                }
                --count;
                continue;
            }
            if (endIndex == null) {
                if (startIndexesIterator.hasNext()) {
                    startIndex = (Integer)startIndexesIterator.next();
                }
                ++count;
                continue;
            }
            if (endIndex < startIndex) {
                endIndex = endIndexesIterator.hasNext() ? (Integer)startIndexesIterator.next() : null;
                --count;
                continue;
            }
            startIndex = startIndexesIterator.hasNext() ? (Integer)startIndexesIterator.next() : null;
            ++count;
        }
        return count != 0;
    }

    public static boolean isBetweenSymbols(String string, int position, String symbol) {
        int pos = 0;
        int count = 0;
        while ((pos = string.indexOf(symbol, pos)) < position && pos != -1) {
            count = 1 - count;
            ++pos;
        }
        return count != 0;
    }

    public static String substringWithSymbols(String string, SymbolSet symbolSet, int position) {
        char[] characters = new char[string.length() - position];
        string.getChars(position, string.length(), characters, 0);
        for (int i = position; i < characters.length; ++i) {
            if (!symbolSet.contains(characters[i])) continue;
            char[] buff = new char[string.length() - i];
            int j = 0;
            while (symbolSet.contains(characters[i])) {
                buff[j] = characters[i];
                ++j;
                if (++i != characters.length) continue;
            }
            char[] ret = new char[j];
            System.arraycopy(buff, 0, ret, 0, j);
            return new String(ret);
        }
        return null;
    }

    public static String substringDelimited(String string, String start, String end2, int startingPosition) {
        int endIndex;
        int startIndex = string.indexOf(start, startingPosition);
        if (startIndex == -1) {
            return null;
        }
        if ((startIndex += start.length()) < (endIndex = string.indexOf(end2, startIndex)) && endIndex != -1 && startIndex != -1) {
            return string.substring(startIndex, endIndex);
        }
        return null;
    }

    public static String rect2String(Rectangle2D rect) {
        return rect.getMinX() + "," + rect.getMinY() + "," + rect.getWidth() + "," + rect.getHeight();
    }

    public static Rectangle2D string2Rect(String rect) {
        String[] coords = new String[4];
        coords = rect.split(",");
        Rectangle2D.Double ret = new Rectangle2D.Double(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]), Double.parseDouble(coords[2]), Double.parseDouble(coords[3]));
        return ret;
    }

    public static String color2String(Color c) {
        if (c == null) {
            return null;
        }
        return c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha();
    }

    public static Color string2Color(String stringColor) {
        if (stringColor == null || stringColor.equals("null")) {
            return null;
        }
        String[] ints = new String[4];
        ints = stringColor.split(",");
        int[] ret = new int[4];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Integer.parseInt(ints[i]);
        }
        return new Color(ret[0], ret[1], ret[2], ret[3]);
    }

    public static String floatArray2String(float[] array) {
        String aux = "" + array[0];
        for (int i = 1; i < array.length; ++i) {
            aux = aux + "," + array[i];
        }
        return aux;
    }

    public static float[] string2FloatArray(String array) {
        String[] floats = new String[4];
        floats = array.split(",");
        float[] ret = new float[floats.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Float.parseFloat(floats[i]);
        }
        return ret;
    }

    public static String getComaSeparated(String[] input) {
        return StringUtilities.getXSeparated(",", input);
    }

    public static String getBlankSeparated(String[] input) {
        return StringUtilities.getXSeparated(" ", input);
    }

    private static String getXSeparated(String X, String[] input) {
        String output = "";
        if (input.length == 0) {
            return "";
        }
        output = input[0];
        for (int i = 1; i < input.length; ++i) {
            output = output + X + input[i];
        }
        return output;
    }

    public static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String generateRandomString(int length) {
        Random r = new Random();
        String sorigen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        char[] fuente = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        char[] buffer = new char[length];
        for (int i = 0; i < length; ++i) {
            int rnd = Math.abs(r.nextInt()) % fuente.length;
            buffer[i] = fuente[rnd];
        }
        return new String(buffer);
    }

    public static int numberOfOccurrencesOfSubStringInString(String str, String subStr, boolean caseSensitive) {
        int aux = 0;
        int numberOfOccurrences = 0;
        if (!caseSensitive) {
            str = str.toLowerCase();
            subStr = subStr.toLowerCase();
        }
        while ((aux = str.indexOf(subStr, aux)) != -1) {
            aux += subStr.length();
            ++numberOfOccurrences;
        }
        return numberOfOccurrences;
    }

    public static int numberOfOccurrencesOfSubStringInStringBetweenPositions(String str, String subStr, boolean caseSensitive, int start_position, int end_position) {
        int aux = start_position;
        int numberOfOccurrences = 0;
        boolean finish = false;
        if (!caseSensitive) {
            str = str.toLowerCase();
            subStr = subStr.toLowerCase();
        }
        while (!finish && (aux = str.indexOf(subStr, aux)) != -1) {
            if ((aux += subStr.length()) > end_position) {
                finish = true;
                continue;
            }
            ++numberOfOccurrences;
        }
        return numberOfOccurrences;
    }
}

