/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang3.StringUtils;

public class SimpleLDAP {
    private String ldapurl;
    private String userTemplate;
    private String searchGroupsFilterTemplate;
    private InitialDirContext context;
    private String username;

    public SimpleLDAP(String ldapurl, String userTemplate) {
        this.ldapurl = ldapurl;
        this.userTemplate = userTemplate;
    }

    public SimpleLDAP(String ldapurl, String userTemplate, String searchGroupsFilterTemplate) {
        this(ldapurl, userTemplate);
        this.searchGroupsFilterTemplate = searchGroupsFilterTemplate;
    }

    public String getUser() {
        return this.username;
    }

    public boolean authenticate(String user, String password) {
        this.username = user;
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.provider.url", this.ldapurl);
        if (user.startsWith("uid=")) {
            props.put("java.naming.security.principal", user);
        } else {
            props.put("java.naming.security.principal", String.format(this.userTemplate, user));
        }
        props.put("java.naming.security.credentials", password);
        try {
            this.context = new InitialDirContext(props);
            return true;
        }
        catch (NamingException ex) {
            return false;
        }
    }

    public List<String> groups(String searchGroupsName) {
        if (StringUtils.isBlank((CharSequence)searchGroupsName) || StringUtils.isBlank((CharSequence)this.searchGroupsFilterTemplate)) {
            return Collections.EMPTY_LIST;
        }
        try {
            SearchControls ctrls = new SearchControls();
            ctrls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = this.context.search(searchGroupsName, String.format(this.searchGroupsFilterTemplate, this.username), ctrls);
            String fullusername = String.format(this.userTemplate, this.username);
            ArrayList<String> groups = new ArrayList<String>();
            while (results.hasMore()) {
                SearchResult result = results.next();
                Attribute groupname = result.getAttributes().get("cn");
                Attribute member = result.getAttributes().get("member");
                for (int idx = 0; idx < member.size(); ++idx) {
                    if (!fullusername.equals(member.get(idx))) continue;
                    groups.add(groupname.get().toString());
                }
            }
            return groups;
        }
        catch (NamingException ex) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String LDAP_URL = "ldap://127.0.0.1:10389";
        String LDAP_USER_TEMPLATE = "uid=%s,ou=Users,dc=ldap,dc=example";
        String LDAP_SEARCH_FILTER_TEMPLATE = "member=uid=%s*";
        String LDAP_SEARCH_OPERATIONS_NAME = "ou=operations,ou=vcsgis_urbansignage,dc=ldap,dc=example";
        String LDAP_SEARCH_ROLES_NAME = "ou=roles,ou=vcsgis_urbansignage,dc=ldap,dc=example";
        SimpleLDAP ldap = new SimpleLDAP(LDAP_URL, LDAP_USER_TEMPLATE, LDAP_SEARCH_FILTER_TEMPLATE);
        boolean n = ldap.authenticate("jduke", "theduke");
        System.out.println("autenticate " + ldap.getUser() + ": " + n);
        List<String> groups = ldap.groups(LDAP_SEARCH_OPERATIONS_NAME);
        System.out.println("groups " + ldap.getUser() + ": " + StringUtils.join(groups, (String)","));
        groups = ldap.groups(LDAP_SEARCH_ROLES_NAME);
        System.out.println("roles " + ldap.getUser() + ": " + StringUtils.join(groups, (String)","));
        System.out.println();
        n = ldap.authenticate("lucas", "thelucas");
        System.out.println("autenticate " + ldap.getUser() + ": " + n);
        groups = ldap.groups(LDAP_SEARCH_OPERATIONS_NAME);
        System.out.println("groups " + ldap.getUser() + ": " + StringUtils.join(groups, (String)","));
        groups = ldap.groups(LDAP_SEARCH_ROLES_NAME);
        System.out.println("roles " + ldap.getUser() + ": " + StringUtils.join(groups, (String)","));
        System.out.println();
    }
}

