/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.impl.DefaultDynClassName;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynObjectPersistenceFactory
implements PersistenceFactory {
    static Logger LOG = LoggerFactory.getLogger(DynObjectPersistenceFactory.class);
    Map definitions = new HashMap();

    private void addDefinition(DynStruct definition) {
        this.definitions.put(definition.getFullName(), definition);
    }

    @Override
    public Object createFromState(PersistentState state) throws PersistenceException {
        return ToolsLocator.getDynObjectManager().createDynObject(state.getDefinition());
    }

    @Override
    public void loadFromState(PersistentState state, Object object) throws PersistenceException {
        DynClass definition = ((DynObject)object).getDynClass();
        this.addDefinition(definition);
        DynField[] fields = definition.getDynFields();
        for (int i = 0; i < fields.length; ++i) {
            DynField field = fields[i];
            if (!field.isPersistent()) continue;
            if (field.getDataType().isContainer()) {
                if (field.getDataType().getType() == 36) {
                    Map persistedMap = (Map)state.get(field.getName());
                    HashMap auxMap = new HashMap();
                    if (persistedMap != null) {
                        auxMap.putAll(persistedMap);
                    }
                    ((DynObject)object).setDynValue(field.getName(), auxMap);
                    continue;
                }
                if (field.getDataType().getType() == 34) {
                    List persistedList = (List)state.get(field.getName());
                    ArrayList auxList = new ArrayList();
                    if (persistedList != null) {
                        auxList.addAll(persistedList);
                    }
                    ((DynObject)object).setDynValue(field.getName(), auxList);
                    continue;
                }
                if (field.getDataType().getType() == 35) {
                    Set persistedSet = (Set)state.get(field.getName());
                    HashSet auxSet = new HashSet();
                    if (persistedSet != null) {
                        auxSet.addAll(persistedSet);
                    }
                    ((DynObject)object).setDynValue(field.getName(), auxSet);
                    continue;
                }
            }
            ((DynObject)object).setDynValue(field.getName(), state.get(field.getName()));
        }
    }

    @Override
    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        DynClass definition = ((DynObject)obj).getDynClass();
        this.addDefinition(definition);
        DynField[] fields = definition.getDynFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isPersistent()) continue;
            state.set(fields[i].getName(), ((DynObject)obj).getDynValue(fields[i].getName()));
        }
    }

    @Override
    public boolean manages(Object object) {
        return object instanceof DynObject;
    }

    @Override
    public boolean manages(Class theClass) {
        return DynObject.class.isAssignableFrom(theClass);
    }

    @Override
    public boolean manages(PersistentState state) {
        String className = state.getTheClassName();
        DefaultDynClassName dynClassName = new DefaultDynClassName(className);
        return dynClassName.getNamespace().equals("PersistenceDynObject");
    }

    @Override
    public List getDefinitions() {
        ArrayList defs = new ArrayList();
        defs.addAll(this.definitions.values());
        return defs;
    }

    @Override
    public DynStruct getDefinition(String className) {
        DynObjectManager dynMan = ToolsLocator.getDynObjectManager();
        DynClass struct = dynMan.get("PersistenceDynObject", className);
        if (struct == null) {
            struct = dynMan.get(className);
        }
        return struct;
    }

    @Override
    public String getDomainName() {
        return "gvsig";
    }

    @Override
    public String getDomainURL() {
        return "http://www.gvsig.org";
    }

    @Override
    public List getManagedClasses() {
        return Collections.singletonList(DynObject.class);
    }

    @Override
    public Class getManagedClass(Object object) {
        if (DynObject.class.isInstance(object)) {
            return DynObject.class;
        }
        return null;
    }

    @Override
    public String getManagedClassName(Object object) {
        if (DynObject.class.isInstance(object)) {
            return ((DynObject)object).getDynClass().getFullName();
        }
        return null;
    }

    @Override
    public Class getManagedClass(PersistentState state) {
        String className = state.getTheClassName();
        DefaultDynClassName dynClassName = new DefaultDynClassName(className);
        if (!dynClassName.getNamespace().equals("PersistenceDynObject")) {
            return null;
        }
        return DynObject.class;
    }

    @Override
    public Class getManagedClass(String name) {
        DefaultDynClassName dynClassName = new DefaultDynClassName(name);
        if (dynClassName.getNamespace().equals("PersistenceDynObject")) {
            return DynObject.class;
        }
        return null;
    }
}

