/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gvsig.tools.util.UnmodifiableBasicMap;

public class UnmodifiableBasicMapToMapAdapter<K, V>
implements Map<K, V> {
    private final UnmodifiableBasicMap<K, V> umap;

    public UnmodifiableBasicMapToMapAdapter(UnmodifiableBasicMap<K, V> umap) {
        this.umap = umap;
    }

    @Override
    public int size() {
        return this.umap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.umap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.umap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object v : this.umap) {
            if (value == v) {
                return true;
            }
            if (value == null || v == null || !value.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.umap.get(key);
    }

    @Override
    public Set<K> keySet() {
        return new UnmodifiableBasicMapKeySet();
    }

    @Override
    public Collection<V> values() {
        return new UnmodifiableBasicMapValues();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new UnmodifiableBasicMapEntrySet();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class UnmodifiableBasicMapValues
    extends AbstractUnmodifiableBasicMapCollection
    implements Collection {
        UnmodifiableBasicMapValues() {
        }

        @Override
        public boolean contains(Object value) {
            for (Object v : UnmodifiableBasicMapToMapAdapter.this.umap) {
                if (value == v) {
                    return true;
                }
                if (value == null || v == null || !value.equals(v)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return UnmodifiableBasicMapToMapAdapter.this.umap.iterator();
        }
    }

    class UnmodifiableBasicMapKeySet
    extends AbstractUnmodifiableBasicMapCollection
    implements Set {
        UnmodifiableBasicMapKeySet() {
        }

        @Override
        public boolean contains(Object value) {
            return UnmodifiableBasicMapToMapAdapter.this.umap.keySet().contains(value);
        }

        @Override
        public Iterator<K> iterator() {
            return UnmodifiableBasicMapToMapAdapter.this.umap.keySet().iterator();
        }
    }

    class UnmodifiableBasicMapEntrySet
    extends AbstractUnmodifiableBasicMapCollection
    implements Set {
        UnmodifiableBasicMapEntrySet() {
        }

        @Override
        public boolean contains(Object value) {
            for (Object key : UnmodifiableBasicMapToMapAdapter.this.umap.keySet()) {
                AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, UnmodifiableBasicMapToMapAdapter.this.umap.get(key));
                if (value == entry) {
                    return true;
                }
                if (value == null || !value.equals(entry)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator it = UnmodifiableBasicMapToMapAdapter.this.umap.keySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    Object key = it.next();
                    AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, UnmodifiableBasicMapToMapAdapter.this.umap.get(key));
                    return entry;
                }
            };
        }
    }

    private abstract class AbstractUnmodifiableBasicMapCollection {
        private AbstractUnmodifiableBasicMapCollection() {
        }

        public int size() {
            return UnmodifiableBasicMapToMapAdapter.this.umap.size();
        }

        public boolean isEmpty() {
            return UnmodifiableBasicMapToMapAdapter.this.umap.isEmpty();
        }

        public abstract boolean contains(Object var1);

        public abstract Iterator iterator();

        public boolean containsAll(Collection c) {
            for (Object element : c) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        public Object[] toArray(Object[] a) {
            int sz = this.size();
            if (a.length < sz) {
                a = Arrays.copyOf(new Object[]{null}, sz, a.getClass());
            }
            int n = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                a[n] = it.next();
            }
            return a;
        }

        public Object[] toArray() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean add(Object e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

