/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class LocalePickerControllerImpl
extends AbstractPickerController<Locale> {
    private final JLabel lblLocale;
    private final JComboBox cboLocale;

    public static void selfRegister() {
    }

    public LocalePickerControllerImpl(JLabel lblCharset, JComboBox cboLocale) {
        this.lblLocale = lblCharset == null ? new JLabel() : lblCharset;
        this.cboLocale = cboLocale;
        this.fillLocales(this.cboLocale);
        ListElement.setSelected((JComboBox)cboLocale, (Object)new LabeledValueImpl(Locale.getDefault().getDisplayName(), (Object)Locale.getDefault()));
    }

    private void fillLocales(JComboBox cboLocale) {
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        List<Locale> locales = Arrays.asList(Locale.getAvailableLocales());
        Collections.sort(locales, new CompareUtils.NullSafeComparator<Locale>(){

            public int safeCompare(Locale o1, Locale o2) {
                return StringUtils.compare((String)o1.getDisplayName(), (String)o2.getDisplayName());
            }
        });
        for (Locale locale : locales) {
            model.addElement(new LabeledValueImpl(locale.getDisplayName(), (Object)locale));
        }
        cboLocale.setModel(model);
    }

    public boolean isEmpty() {
        return this.cboLocale.getSelectedItem() == null;
    }

    public void set(Locale locale) {
        if (locale == null) {
            this.cboLocale.setSelectedIndex(-1);
            return;
        }
        ListElement.setSelected((JComboBox)this.cboLocale, (Object)locale);
    }

    public Locale get() {
        Object l = this.cboLocale.getSelectedItem();
        if (l == null || !(l instanceof LabeledValue) || !(((LabeledValue)l).getValue() instanceof Locale)) {
            return null;
        }
        return (Locale)((LabeledValue)l).getValue();
    }

    public void setEnabled(boolean enabled) {
        this.lblLocale.setEnabled(enabled);
        this.cboLocale.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.cboLocale.isEnabled();
    }

    public void coerceAndSet(Object value) {
        this.set((Locale)this.coerce(20, value, null));
    }
}

