/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.spinner.editor;

import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.locator.LocatorException;

public class NullableNumberSpinnerModel
extends SpinnerNumberModel
implements SpinnerModel {
    private static final long serialVersionUID = 1320385929219211201L;
    private DynField field;
    private Object number;
    private boolean isFirstTime;

    public NullableNumberSpinnerModel(DynField field, Number value) {
        super((Number)0, (Comparable)field.getMinValue(), (Comparable)field.getMaxValue(), (Number)1);
        this.field = field;
        this.isFirstTime = true;
        super.setValue(0);
        if (value != null) {
            this.setValue(value);
        }
    }

    @Override
    public Object getNextValue() {
        Number next = null;
        next = this.isNull() ? (Number)0 : (Number)((Number)super.getNextValue());
        this.number = next;
        return next;
    }

    @Override
    public Object getPreviousValue() {
        if (this.isNull()) {
            return null;
        }
        if (this.number.equals(this.getMinimum())) {
            this.number = null;
            return "";
        }
        return super.getPreviousValue();
    }

    @Override
    public Object getValue() {
        if (this.isFirstTime) {
            this.number = 0;
        }
        if (this.number == null) {
            return null;
        }
        try {
            return ToolsLocator.getDataTypesManager().coerce(this.field.getType(), this.number);
        }
        catch (LocatorException e) {
            e.printStackTrace();
        }
        catch (CoercionException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected boolean isNull() {
        Object value = this.getValue();
        return value == null || value.equals("");
    }

    @Override
    public void setValue(Object value) {
        this.number = value;
        this.isFirstTime = false;
        if (!this.isNull()) {
            super.setValue(value);
        }
        this.fireStateChanged();
    }
}

