/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl.dynformfield;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;

public class JDynFormFieldExpression
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected Expression assignedValue = null;
    protected Expression currentValue = null;
    protected JTextComponent jtext = null;
    protected JButton btnBuilder = null;
    protected JButton btnHistory = null;
    protected JButton btnBookmarks = null;
    protected boolean readonly = false;
    private ExpressionPickerController pickerController;

    public JDynFormFieldExpression(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (Expression)value;
    }

    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        if (this.contents != null) {
            if (this.readonly) {
                this.pickerController.setEditable(false);
            } else {
                this.pickerController.setEditable(true);
            }
        }
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        this.contents = new JPanel();
        this.jtext = this.getComponentsFactory().getJTextField(this.getDefinition(), null);
        this.jtext.addFocusListener(this);
        this.btnBuilder = this.getComponentsFactory().getJButton(this.getDefinition(), null);
        this.btnHistory = this.getComponentsFactory().getJButton(this.getDefinition(), "History");
        this.btnBookmarks = this.getComponentsFactory().getJButton(this.getDefinition(), "Bookmarks");
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.pickerController = expressionSwingManager.createExpressionPickerController(this.jtext, this.btnBuilder, this.btnHistory, this.btnBookmarks);
        this.pickerController.addChangeListener(e -> {
            Expression value = this.pickerController.getWithOutHistory();
            this.fireFieldChangedEventIfChanged(value);
            try {
                value.getCode();
                this.getDefinition().validate((Object)value);
                this.problemIndicator().clear();
            }
            catch (Exception ex) {
                this.problemIndicator().set(ex.getLocalizedMessage());
            }
        });
        if (this.readonly) {
            this.pickerController.setEditable(false);
        } else {
            this.pickerController.setEditable(true);
        }
        if (!this.getComponentsFactory().containsJTextField(this.getDefinition(), null)) {
            this.createLayout();
        }
        this.setValue(this.assignedValue);
    }

    private void createLayout() {
        GridBagLayout layout = new GridBagLayout();
        this.contents.setLayout(layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.contents.add((Component)this.jtext, gridBagConstraints);
        if (this.btnBuilder != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            this.contents.add((Component)this.btnBuilder, gridBagConstraints);
        }
        if (this.btnHistory != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            this.contents.add((Component)this.btnHistory, gridBagConstraints);
        }
        if (this.btnBookmarks != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridy = 0;
            this.contents.add((Component)this.btnBookmarks, gridBagConstraints);
        }
    }

    private void fireFieldChangedEventIfChanged(Expression previous) {
        if (previous == null) {
            if (this.currentValue == null) {
                return;
            }
            this.fireFieldChangedEvent();
            return;
        }
        if (this.currentValue == null) {
            this.fireFieldChangedEvent();
            return;
        }
        if (StringUtils.equals((CharSequence)previous.getPhrase(), (CharSequence)this.currentValue.getPhrase())) {
            this.fireFieldChangedEvent();
        }
    }

    public void setValue(Object value) {
        Expression previous = this.currentValue;
        if (value instanceof CharSequence) {
            value = ExpressionUtils.createExpression((String)value.toString());
        }
        if (value != null && !(value instanceof Expression)) {
            LOGGER.info("setValue invoked with non File value (" + value.toString() + ").");
            return;
        }
        this.assignedValue = (Expression)value;
        this.pickerController.set((Object)this.assignedValue);
        this.currentValue = this.assignedValue;
        this.fireFieldChangedEventIfChanged(previous);
    }

    public Object getValue() {
        Expression value = this.pickerController.get();
        return value;
    }

    public boolean hasValidValue() {
        try {
            Expression value = this.pickerController.get();
            value.getCode();
            this.getDefinition().validate((Object)value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void clear() {
        this.pickerController.set(null);
    }
}

