/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl.elements;

import java.util.Comparator;
import java.util.Objects;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.impl.Utils;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.LabeledValue;

public class DefaultConstantValueElement
extends AbstractElement
implements Element.ConstantElement {
    private final String label;

    public DefaultConstantValueElement(Object value, String label, String description) {
        super(Objects.toString(value, ""), value, "expressionbuilder-element-constant");
        this.label = label == null ? Objects.toString(value, "") : label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRenderedValue() {
        return " " + Utils.repr(this.getValue()) + " ";
    }

    public String getDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        Object theValue = this.getValue();
        if (theValue == null) {
            html.append("<b>").append(i18n.getTranslation("_Constant")).append("</b><br>\n<br>\n");
            html.append("<b>").append(i18n.getTranslation("_Value")).append("</b> NULL<br>\n");
        } else {
            html.append("<b>").append(i18n.getTranslation("_Constant")).append("</b><br>\n<br>\n");
            html.append("<b>").append(i18n.getTranslation("_Value")).append("</b> ").append(Utils.repr(theValue)).append("<br>\n");
            html.append("<b>").append(i18n.getTranslation("_Type")).append("</b> ").append(theValue.getClass().getSimpleName()).append("<br>\n");
        }
        html.append("</html>\n");
        return html.toString();
    }

    public int compareTo(Object other) {
        if (!(other instanceof LabeledValue)) {
            return super.compareTo(other);
        }
        Comparator comparator = Utils.naturalComparator();
        return comparator.compare(this.getValue(), ((LabeledValue)other).getValue());
    }
}

