/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceEngineFactory;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DatabaseRegistry {
    public static final String GenericEngine = "generic";
    private String _jdbcUrl;
    private Properties _jdbcProps;
    private DataSource _dataSource;
    private MappingResolver _mapResolver;
    private String _name;
    private LockEngine _engine;
    private static Hashtable _databases = new Hashtable();
    private static Hashtable _byEngine = new Hashtable();
    public static String DefaultMapping = "mapping.xml";
    static /* synthetic */ Class class$org$exolab$castor$jdo$conf$Database;

    DatabaseRegistry(String name, MappingResolver mapResolver, PersistenceFactory factory, String jdbcUrl, Properties jdbcProps) throws MappingException {
        this(name, mapResolver, factory);
        this._jdbcUrl = jdbcUrl;
        this._jdbcProps = jdbcProps;
    }

    DatabaseRegistry(String name, MappingResolver mapResolver, PersistenceFactory factory, DataSource dataSource) throws MappingException {
        this(name, mapResolver, factory);
        this._dataSource = dataSource;
    }

    DatabaseRegistry(String name, MappingResolver mapResolver, PersistenceFactory factory) throws MappingException {
        this._name = name;
        this._mapResolver = mapResolver;
        this._engine = new PersistenceEngineFactory().createEngine(mapResolver, factory);
        _byEngine.put(this._engine, this);
    }

    public MappingResolver getMappingResolver() {
        return this._mapResolver;
    }

    public String getName() {
        return this._name;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        Unmarshaller unm = new Unmarshaller(class$org$exolab$castor$jdo$conf$Database == null ? (class$org$exolab$castor$jdo$conf$Database = DatabaseRegistry.class$("org.exolab.castor.jdo.conf.Database")) : class$org$exolab$castor$jdo$conf$Database);
        try {
            void var7_18;
            DatabaseRegistry dbs;
            if (resolver == null) {
                unm.setEntityResolver(new DTDResolver());
            } else {
                unm.setEntityResolver(new DTDResolver(resolver));
            }
            Database database = (Database)unm.unmarshal(source);
            if (_databases.get(database.getName()) != null) {
                return;
            }
            PersistenceFactory factory = database.getEngine() == null ? PersistenceFactoryRegistry.getPersistenceFactory(GenericEngine) : PersistenceFactoryRegistry.getPersistenceFactory(database.getEngine());
            if (factory == null) {
                throw new MappingException("jdo.noSuchEngine", database.getEngine());
            }
            org.exolab.castor.mapping.Mapping mapping = new org.exolab.castor.mapping.Mapping(loader);
            if (resolver != null) {
                mapping.setEntityResolver(resolver);
            }
            if (source.getSystemId() != null) {
                mapping.setBaseURL(source.getSystemId());
            }
            Enumeration mappings = database.enumerateMapping();
            while (mappings.hasMoreElements()) {
                mapping.loadMapping(((Mapping)mappings.nextElement()).getHref());
            }
            if (database.getDriver() != null) {
                if (database.getDriver().getClassName() != null) {
                    try {
                        Class.forName(database.getDriver().getClassName()).newInstance();
                    }
                    catch (Exception except) {
                        throw new MappingException(except);
                    }
                }
                if (DriverManager.getDriver(database.getDriver().getUrl()) == null) {
                    throw new MappingException("jdo.missingDriver", database.getDriver().getUrl());
                }
                Properties props = new Properties();
                Enumeration params = database.getDriver().enumerateParam();
                while (params.hasMoreElements()) {
                    Param param = (Param)params.nextElement();
                    props.put(param.getName(), param.getValue());
                }
                dbs = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, factory), factory, database.getDriver().getUrl(), props);
            } else if (database.getDataSource() != null) {
                DataSource ds = database.getDataSource().getParams();
                if (ds == null) {
                    throw new MappingException("jdo.missingDataSource", database.getName());
                }
                dbs = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, factory), factory, ds);
            } else if (database.getJndi() != null) {
                Object ds;
                try {
                    ds = new InitialContext().lookup(database.getJndi().getName());
                }
                catch (NameNotFoundException except) {
                    throw new MappingException("jdo.jndiNameNotFound", database.getJndi().getName());
                }
                catch (NamingException except) {
                    throw new MappingException(except);
                }
                if (!(ds instanceof DataSource)) {
                    throw new MappingException("jdo.jndiNameNotFound", database.getJndi().getName());
                }
                dbs = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, factory), factory, (DataSource)ds);
            } else {
                throw new MappingException("jdo.missingDataSource", database.getName());
            }
            _databases.put(database.getName(), var7_18);
        }
        catch (MappingException except) {
            throw except;
        }
        catch (Exception except) {
            throw new MappingException(except);
        }
    }

    public Connection createConnection() throws SQLException {
        if (this._dataSource != null) {
            return this._dataSource.getConnection();
        }
        return DriverManager.getConnection(this._jdbcUrl, this._jdbcProps);
    }

    static LockEngine getLockEngine(Class objType) {
        Enumeration enumeration = _databases.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRegistry dbs = (DatabaseRegistry)enumeration.nextElement();
            if (dbs._mapResolver.getDescriptor(objType) == null) continue;
            return dbs._engine;
        }
        return null;
    }

    static LockEngine getLockEngine(DatabaseRegistry dbs) {
        return dbs._engine;
    }

    public static DatabaseRegistry getDatabaseRegistry(Object obj) {
        return DatabaseRegistry.getDatabaseRegistry(obj.getClass());
    }

    public static DatabaseRegistry getDatabaseRegistry(Class c) {
        Enumeration enumeration = _databases.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRegistry dbs = (DatabaseRegistry)enumeration.nextElement();
            if (dbs._mapResolver.getDescriptor(c) == null) continue;
            return dbs;
        }
        return null;
    }

    public static synchronized DatabaseRegistry getDatabaseRegistry(String name) {
        DatabaseRegistry dbs = (DatabaseRegistry)_databases.get(name);
        return dbs;
    }

    static Connection createConnection(LockEngine engine) throws SQLException {
        DatabaseRegistry dbs = (DatabaseRegistry)_byEngine.get(engine);
        if (dbs._dataSource != null) {
            return dbs._dataSource.getConnection();
        }
        return DriverManager.getConnection(dbs._jdbcUrl, dbs._jdbcProps);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

