/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.store.properties.ColorProperty;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class ColorProxy
extends Color {
    private ColorProperty m_color_prop;

    public ColorProxy() {
        super(255, 255, 255);
    }

    public ColorProxy(ColorProperty cprop) {
        super(255, 255, 255);
        this.m_color_prop = new ColorProperty();
        this.m_color_prop.setValue(cprop);
    }

    public ColorProperty getColorProperty() {
        return this.m_color_prop;
    }

    public void setColorProperty(ColorProperty prop) {
        this.m_color_prop = prop;
    }

    public Color getColor() {
        Color c = this.m_color_prop.getColor();
        if (c == null) {
            c = Color.white;
        }
        return c;
    }

    public int getRed() {
        return this.getColor().getRed();
    }

    public int getGreen() {
        return this.getColor().getGreen();
    }

    public int getBlue() {
        return this.getColor().getBlue();
    }

    public int getAlpha() {
        return this.getColor().getAlpha();
    }

    public int getRGB() {
        return this.getColor().getRGB();
    }

    public Color brighter() {
        return this.getColor().brighter();
    }

    public Color darker() {
        return this.getColor().darker();
    }

    public int hashCode() {
        return this.getColor().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Color) {
            return obj.equals(this.getColor());
        }
        if (obj instanceof ColorProxy) {
            return ((ColorProxy)obj).getColor().equals(this.getColor());
        }
        return false;
    }

    public String toString() {
        return this.getColor().toString();
    }

    public float[] getRGBComponents(float[] compArray) {
        return this.getColor().getRGBComponents(compArray);
    }

    public float[] getRGBColorComponents(float[] compArray) {
        return this.getColor().getRGBColorComponents(compArray);
    }

    public float[] getComponents(float[] compArray) {
        return this.getColor().getComponents(compArray);
    }

    public float[] getColorComponents(float[] compArray) {
        return this.getColor().getColorComponents(compArray);
    }

    public float[] getComponents(ColorSpace cspace, float[] compArray) {
        return this.getColor().getComponents(cspace, compArray);
    }

    public float[] getColorComponents(ColorSpace cspace, float[] compArray) {
        return this.getColor().getColorComponents(cspace, compArray);
    }

    public ColorSpace getColorSpace() {
        return this.getColor().getColorSpace();
    }

    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        return this.getColor().createContext(cm, r, r2d, xform, hints);
    }

    public int getTransparency() {
        return this.getColor().getTransparency();
    }
}

