/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.framework;

import com.jeta.open.gui.framework.JETAContainer;
import com.jeta.open.gui.framework.UIDirector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class JETAController {
    private JETAContainer m_view;
    private CommandListener m_cmdListener = new CommandListener();
    private ListenerManager m_action_listeners = new ListenerManager();
    private ListListener m_llistener = new ListListener();
    private ListenerManager m_list_listeners;
    private ComponentChangeListener m_clistener = new ComponentChangeListener();
    private ListenerManager m_change_listeners;
    private TextFocusListener m_text_focus_listener = new TextFocusListener();
    private HashMap m_txt_values = new HashMap();
    private boolean m_events_enabled = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JETAController(JETAContainer view) {
        this.m_view = view;
    }

    public boolean actionPerformed(String actionName, ActionEvent evt) {
        if (this.isEventsEnabled()) {
            UIDirector uidirector;
            JETAContainer view;
            boolean bresult = false;
            ActionListener listener = (ActionListener)this.m_action_listeners.getListener(actionName);
            if (listener != null) {
                listener.actionPerformed(evt);
                bresult = true;
            }
            if ((view = this.getView()) != null && (uidirector = view.getUIDirector()) != null) {
                uidirector.updateComponents(evt);
            }
            return bresult;
        }
        return false;
    }

    public void assignAction(String compName, ActionListener action) {
        this.assignAction(this.getView(), compName, action);
    }

    private void assignAction(JETAContainer view, String commandId, ActionListener action) {
        Collection comps = view.getComponentsByName(commandId);
        if (comps.size() == 0) {
            System.out.println("JETAController.assignAction failed for: " + commandId);
        }
        Iterator iter = comps.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (comp == null) continue;
            this.assignComponentAction(comp, commandId, action);
        }
        this.m_action_listeners.assignListener(commandId, action);
    }

    protected void assignComponentAction(Component comp, String commandId, ActionListener action) {
        block7: {
            try {
                Method m;
                if (comp instanceof AbstractButton) {
                    AbstractButton btn = (AbstractButton)comp;
                    btn.removeActionListener(this.m_cmdListener);
                    btn.addActionListener(this.m_cmdListener);
                    btn.setActionCommand(commandId);
                    break block7;
                }
                if (comp instanceof JTextField) {
                    JTextField txtfield = (JTextField)comp;
                    txtfield.removeActionListener(this.m_cmdListener);
                    txtfield.addActionListener(this.m_cmdListener);
                    txtfield.setActionCommand(commandId);
                    txtfield.addFocusListener(this.m_text_focus_listener);
                    break block7;
                }
                if (comp instanceof JComboBox) {
                    JComboBox box = (JComboBox)comp;
                    box.removeActionListener(this.m_cmdListener);
                    box.addActionListener(this.m_cmdListener);
                    box.setActionCommand(commandId);
                    break block7;
                }
                Class[] params = new Class[]{ActionListener.class};
                Object[] values = new Object[]{this.m_cmdListener};
                try {
                    m = comp.getClass().getMethod("removeActionListener", params);
                    m.invoke((Object)comp, values);
                }
                catch (Exception e) {
                    // empty catch block
                }
                m = comp.getClass().getMethod("addActionListener", params);
                m.invoke((Object)comp, values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void assignListener(String compName, ListSelectionListener listener) {
        this.assignListener(this.getView(), compName, listener);
    }

    private void assignListener(JETAContainer view, String compName, ListSelectionListener listener) {
        Component comp = view.getComponentByName(compName);
        if (comp instanceof JList) {
            JList list = (JList)comp;
            if (list != null) {
                if (this.m_list_listeners == null) {
                    this.m_list_listeners = new ListenerManager();
                }
                list.addListSelectionListener(this.m_llistener);
                this.m_list_listeners.assignListener(compName, listener);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    public void assignListener(String compName, ChangeListener listener) {
        this.assignListener(this.getView(), compName, listener);
    }

    private void assignListener(JETAContainer view, String compName, ChangeListener listener) {
        try {
            Component comp = view.getComponentByName(compName);
            if (comp != null) {
                if (this.m_change_listeners == null) {
                    this.m_change_listeners = new ListenerManager();
                }
                Class[] params = new Class[]{ChangeListener.class};
                Object[] values = new Object[]{this.m_clistener};
                Method m = comp.getClass().getMethod("addChangeListener", params);
                m.invoke((Object)comp, values);
                this.m_change_listeners.assignListener(compName, listener);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void enableEvents(boolean enable) {
        this.m_events_enabled = enable;
    }

    public ActionListener getPrimaryActionListener() {
        return this.m_cmdListener;
    }

    public ActionListener getAction(String actionName) {
        return (ActionListener)this.m_action_listeners.getListener(actionName);
    }

    public JETAContainer getView() {
        return this.m_view;
    }

    public boolean invokeAction(String actionName) {
        return this.actionPerformed(actionName, new ActionEvent(this, 0, actionName));
    }

    public boolean isEventsEnabled() {
        return this.m_events_enabled;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.isEventsEnabled()) {
            UIDirector uidirector;
            JETAContainer view;
            if (this.m_change_listeners == null) {
                return;
            }
            Component comp = (Component)e.getSource();
            ChangeListener listener = (ChangeListener)this.m_change_listeners.getListener(comp.getName());
            if (listener != null) {
                listener.stateChanged(e);
            }
            if ((view = this.getView()) != null && (uidirector = view.getUIDirector()) != null) {
                uidirector.updateComponents(e);
            }
        }
    }

    public void updateComponents(Object src) {
        UIDirector uidirector;
        JETAContainer view;
        if (src == null) {
            src = this;
        }
        EventObject evt = null;
        if (!(src instanceof EventObject)) {
            evt = new EventObject(src);
        }
        if ((view = this.getView()) != null && (uidirector = view.getUIDirector()) != null) {
            uidirector.updateComponents(evt);
        }
    }

    private final String validate() {
        return null;
    }

    private final String validateInputs() {
        return this.validate();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.isEventsEnabled()) {
            UIDirector uidirector;
            JETAContainer view;
            if (this.m_list_listeners == null) {
                return;
            }
            JList list = (JList)e.getSource();
            ListSelectionListener listener = (ListSelectionListener)this.m_list_listeners.getListener(list.getName());
            if (listener != null) {
                listener.valueChanged(e);
            }
            if ((view = this.getView()) != null && (uidirector = view.getUIDirector()) != null) {
                uidirector.updateComponents(e);
            }
        }
    }

    private final boolean validateCustom() {
        return true;
    }

    static {
        $assertionsDisabled = !JETAController.class.desiredAssertionStatus();
    }

    public static class ListenerManager {
        private HashMap m_listeners = new HashMap();

        public Object getListener(String commandId) {
            return this.m_listeners.get(commandId);
        }

        public void assignListener(String commandId, Object listener) {
            this.m_listeners.put(commandId, listener);
        }
    }

    public class TextFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent evt) {
            JTextField comp = (JTextField)evt.getSource();
            JETAController.this.m_txt_values.put(comp, comp.getText());
        }

        public void focusLost(FocusEvent evt) {
            JTextField comp = (JTextField)evt.getSource();
            String old_value = (String)JETAController.this.m_txt_values.get(comp);
            if (!comp.getText().equals(old_value)) {
                JETAController.this.actionPerformed(comp.getName(), new ActionEvent(comp, 1001, comp.getName()));
            }
        }
    }

    class ComponentChangeListener
    implements ChangeListener {
        ComponentChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JETAController.this.stateChanged(e);
        }
    }

    class ListListener
    implements ListSelectionListener {
        ListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            JETAController.this.valueChanged(e);
        }
    }

    class CommandListener
    implements ActionListener {
        CommandListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            String actionCommand = e.getActionCommand();
            String actionName = ((Component)src).getName();
            if (src instanceof JTextField) {
                JTextField comp = (JTextField)src;
                JETAController.this.m_txt_values.put(comp, comp.getText());
            }
            if (!actionName.equals(actionCommand)) {
                System.out.println("JETAController actionCommand != componentName.  actionCommand: " + actionCommand + "  componentName: " + actionName);
            }
            JETAController.this.actionPerformed(actionName, e);
        }
    }
}

