/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class AbsFunction
extends AbstractFunction {
    public AbsFunction() {
        super("Numeric", "ABS", Range.is((Comparable)Integer.valueOf(1)), "Returns the absolute value of a double value. If the argument is not negative, the argument is returned. If the argument is negative, the negation of the argument is returned. Special cases:\n- If the argument is positive zero or negative zero, the result is positive zero.\n- If the argument is infinite, the result is positive infinity.\n- If the argument is NaN, the result is NaN.\nIn other words, the result is the same as the value of the expression:\nDouble.longBitsToDouble((Double.doubleToLongBits(a)<<1)>>>1)", "ABS({{a}})", new String[]{"a - the argument whose absolute value is to be determined"}, "Double", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object op1 = args[0];
        if (op1 instanceof Double) {
            double value = Math.abs(((Number)op1).doubleValue());
            return value;
        }
        if (op1 instanceof Float) {
            float value = Math.abs(((Number)op1).floatValue());
            return Float.valueOf(value);
        }
        if (op1 instanceof Long) {
            long value = Math.abs(((Number)op1).longValue());
            return value;
        }
        if (op1 instanceof Integer) {
            int value = Math.abs(((Number)op1).intValue());
            return value;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' function.");
    }
}

