/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class RegExpOperator
extends AbstractBinaryOperator {
    public RegExpOperator() {
        super("Boolean", "~", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        Matcher m;
        if (op1 == null || op2 == null) {
            return null;
        }
        String re = Objects.toString(op2, "");
        Pattern exp = (Pattern)interpreter.getCache().get(this.getClass(), (Object)re);
        if (exp == null) {
            exp = Pattern.compile(re);
            interpreter.getCache().put(this.getClass(), (Object)re, (Object)exp);
        }
        if ((m = exp.matcher(Objects.toString(op1, ""))) == null) {
            return false;
        }
        return m.matches();
    }
}

