/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.PrettyFormatter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class IFFunction
extends AbstractFunction {
    public IFFunction() {
        super("Boolean", "IF", Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)), "IF() function tests a specified numeric expression and returns one of two values, based on whether the expression tested was true or false.", "IF {{condition}} THEN\n  PASS\nELSE\n  PASS;\nEND IF\n", null, "Object", true);
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        boolean condition = this.getBoolean(interpreter, args, 0);
        Object value = condition ? this.getObject(interpreter, args, 1) : (args.size() > 2 && args.get(2) != null ? this.getObject(interpreter, args, 2) : null);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Codes args, Formatter<Code> formatter) {
        Code codeCondition = (Code)args.get(0);
        Code codeIfTrue = (Code)args.get(1);
        Code codeIfFalse = args.size() > 2 ? (Code)args.get(2) : null;
        PrettyFormatter builder = PrettyFormatter.get(formatter);
        try {
            Code.Callable block;
            builder.push();
            builder.append((Object)"IF ");
            builder.append((Object)codeCondition.toString(formatter));
            builder.append((Object)" THEN ");
            builder.indent();
            if (Code.isFunction((Code)codeIfTrue, (String)"BLOCK")) {
                block = (Code.Callable)codeIfTrue;
                for (Code parameter : block.parameters()) {
                    builder.nl();
                    builder.append((Object)parameter.toString(formatter));
                    builder.append((Object)"; ");
                }
            } else {
                builder.nl();
                builder.append((Object)codeIfTrue.toString(formatter));
                builder.append((Object)"; ");
            }
            builder.unindent();
            if (codeIfFalse != null) {
                builder.nl();
                builder.append((Object)"ELSE ");
                builder.indent();
                if (Code.isFunction((Code)codeIfTrue, (String)"BLOCK")) {
                    block = (Code.Callable)codeIfFalse;
                    for (Code parameter : block.parameters()) {
                        builder.nl();
                        builder.append((Object)parameter.toString(formatter));
                        builder.append((Object)"; ");
                    }
                } else {
                    builder.nl();
                    builder.append((Object)codeIfFalse.toString(formatter));
                    builder.append((Object)"; ");
                }
            }
            builder.nl();
            builder.append((Object)"END IF");
            String string = builder.build();
            return string;
        }
        finally {
            builder.pop();
        }
    }
}

