/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import javax.swing.SwingUtilities;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.DefaultInterpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class SwingBlockFunction
extends AbstractFunction {
    public static final String NAME = "SWING";

    public SwingBlockFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), "Evaluate each of the arguments sequentially.", "SWING({{sentence}}, sentence2, ...)", null, "Object", false);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(final Interpreter interpreter, final Codes args) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            Object value = null;
            for (Code arg : args) {
                value = ((DefaultInterpreter)interpreter).runCode(arg);
            }
            return value;
        }
        final MutableObject value = new MutableObject();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Code arg : args) {
                        value.setValue(((DefaultInterpreter)interpreter).runCode(arg));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return value.getValue();
    }
}

