/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.javascripting;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.gvsig.expressionevaluator.MutableSymbolTable;

public class SymbolTableToBindingsAdapter
implements Bindings {
    private MutableSymbolTable symbolTable;

    public SymbolTableToBindingsAdapter(MutableSymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public MutableSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @Override
    public Object put(String name, Object value) {
        Object previous = this.symbolTable.value(name);
        this.symbolTable.setVar(name, value);
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.symbolTable.setVar(key, value);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.symbolTable.exists(key.toString());
    }

    @Override
    public Object get(Object key) {
        return this.symbolTable.value(key.toString());
    }

    @Override
    public Object remove(Object key) {
        Object previous = this.symbolTable.value(key.toString());
        this.symbolTable.removeVar(key.toString());
        return previous;
    }

    @Override
    public int size() {
        return this.symbolTable.variables().size();
    }

    @Override
    public boolean isEmpty() {
        return this.symbolTable.variables().isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        Collection vars = this.symbolTable.variables();
        return new HashSet<String>(vars);
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }
}

