/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.spi;

import java.net.URL;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationFactory;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class AbstractDownloaderAuthenticationConfig
implements DownloaderAuthenticationConfig {
    protected final String providerName;
    private DownloaderAuthenticationFactory factory;
    protected String serviceUrl;

    protected AbstractDownloaderAuthenticationConfig(String providerName, DownloaderAuthenticationFactory factory, String serviceUrl) {
        this(providerName);
        this.factory = factory;
        this.serviceUrl = this.getUrlWithoutQuery(serviceUrl);
    }

    protected AbstractDownloaderAuthenticationConfig(String providerName) {
        this.providerName = providerName;
        if (StringUtils.isBlank((CharSequence)this.providerName)) {
            throw new IllegalArgumentException("providerName can't be blank");
        }
        this.factory = null;
        this.serviceUrl = null;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public DownloaderAuthenticationFactory getFactory() {
        if (this.factory == null) {
            DownloaderManager manager = DownloaderLocator.getDownloaderManager();
            this.factory = manager.getDownloaderAuthenticationFactory(this.providerName);
        }
        return this.factory;
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean isFilled() {
        return true;
    }

    @Override
    public boolean requestAuthenticationConfig() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return (DownloaderAuthenticationConfig)super.clone();
    }

    @Override
    public String getKey() {
        return "ServiceUrl=" + this.getServiceUrl();
    }

    public void fromJson(JsonObject json) {
        this.serviceUrl = json.getString("serviceUrl", null);
        String providerName = json.getString("factory", null);
        if (providerName != null && !StringUtils.equalsIgnoreCase((CharSequence)this.providerName, (CharSequence)providerName)) {
            throw new IllegalArgumentException("this json can't be restored in a config of '" + this.providerName + "' (need a '" + providerName + "')");
        }
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("factory", this.getFactory().getProviderName());
        builder.add("serviceUrl", this.serviceUrl);
        return builder;
    }

    private String getUrlWithoutQuery(URL url) {
        try {
            URL x = new URL(url.getProtocol(), url.getHost(), url.getPath());
            return x.toExternalForm();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getUrlWithoutQuery(String url) {
        try {
            return this.getUrlWithoutQuery(new URL(url));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void selfRegister() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("DownloaderAuthenticationConfig") == null) {
            DynStruct definition = manager.addDefinition(DownloaderAuthenticationConfig.class, "DownloaderAuthenticationConfig", "DownloaderAuthenticationConfig persistence definition", null, null);
            definition.addDynFieldString("factory");
            definition.addDynFieldString("serviceUrl");
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("factory", this.providerName);
        state.set("serviceUrl", this.serviceUrl);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        String providerName = state.getString("factory");
        if (providerName != null && !StringUtils.equalsIgnoreCase((CharSequence)this.providerName, (CharSequence)providerName)) {
            throw new IllegalArgumentException("this state can't be restored in a config of '" + this.providerName + "' (need a '" + providerName + "')");
        }
        this.serviceUrl = state.getString("serviceUrl");
    }
}

