/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.lib.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.lib.api.PDFWriter;
import org.gvsig.pdf.lib.impl.DefaultPDFDocument;
import org.gvsig.pdf.lib.impl.DefaultPDFWriter;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.task.SimpleTaskStatus;

public class DefaultPDFManager
implements PDFManager {
    public PDFDocument createPDFDocument(byte[] document) {
        DefaultPDFDocument doc = new DefaultPDFDocument();
        doc.setSource(document);
        return doc;
    }

    public PDFDocument createPDFDocument(String document) {
        DefaultPDFDocument doc = new DefaultPDFDocument();
        doc.setSource(document);
        return doc;
    }

    public PDFDocument createPDFDocument(File document) {
        DefaultPDFDocument doc = new DefaultPDFDocument();
        doc.setSource(document);
        return doc;
    }

    public PDFDocument createPDFDocument() {
        DefaultPDFDocument doc = new DefaultPDFDocument();
        return doc;
    }

    public PDFWriter createPDFWriter() {
        return new DefaultPDFWriter();
    }

    public void merge(List<PDFDocument> inputs, OutputStream output, long maxMemoryToUse, String title, String creator, String subject) {
        try {
            PDFMergerUtility pdfMerger = new PDFMergerUtility();
            pdfMerger.setDestinationStream(output);
            PDDocumentInformation documentInformation = new PDDocumentInformation();
            documentInformation.setTitle(title);
            documentInformation.setCreator(creator);
            documentInformation.setSubject(subject);
            for (PDFDocument input : inputs) {
                pdfMerger.addSource(input.getInputStream());
            }
            FoldersManager folderManager = ToolsLocator.getFoldersManager();
            pdfMerger.mergeDocuments(MemoryUsageSetting.setupMixed((long)maxMemoryToUse).setTempDir(folderManager.getTemporaryFolder()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't merge pdf documents", ex);
        }
    }

    public void merge(List inputPdfs, File outputFile, String title, String creator, String subject, SimpleTaskStatus status) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(outputFile);
            this.merge(inputPdfs, (OutputStream)os, title, creator, subject, status);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't merge pdf's", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public void merge(List inputPdfs, OutputStream outputPdf, String title, String creator, String subject, SimpleTaskStatus status) {
        COSStream cosStream = null;
        Object bos = null;
        try {
            status.push();
            status.setRangeOfValues(1L, (long)inputPdfs.size());
            PDFMergerUtility pdfMerger = new PDFMergerUtility();
            cosStream = new COSStream();
            bos = outputPdf instanceof BufferedOutputStream ? CloseShieldOutputStream.wrap((OutputStream)outputPdf) : new BufferedOutputStream((OutputStream)CloseShieldOutputStream.wrap((OutputStream)outputPdf));
            pdfMerger.setDestinationStream((OutputStream)bos);
            PDDocumentInformation pdfDocumentInfo = this.createPDFDocumentInfo(title, creator, subject);
            PDMetadata xmpMetadata = this.createXMPMetadata(cosStream, title, creator, subject);
            pdfMerger.setDestinationDocumentInformation(pdfDocumentInfo);
            pdfMerger.setDestinationMetadata(xmpMetadata);
            for (Object pdf : inputPdfs) {
                if (pdf instanceof File) {
                    pdfMerger.addSource((File)pdf);
                } else if (pdf instanceof PDFDocument) {
                    pdfMerger.addSource(((PDFDocument)pdf).getInputStream());
                } else if (pdf instanceof InputStream) {
                    pdfMerger.addSource((InputStream)pdf);
                }
                status.incrementCurrentValue();
            }
            pdfMerger.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't merge pdf's", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(cosStream);
                status.pop();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((Closeable)cosStream);
        status.pop();
    }

    private PDDocumentInformation createPDFDocumentInfo(String title, String creator, String subject) {
        PDDocumentInformation documentInformation = new PDDocumentInformation();
        documentInformation.setTitle(title);
        documentInformation.setCreator(creator);
        documentInformation.setSubject(subject);
        return documentInformation;
    }

    /*
     * Exception decompiling
     */
    private PDMetadata createXMPMetadata(COSStream cosStream, String title, String creator, String subject) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

