/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roi;

import java.awt.Color;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.roi.ROI;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class AbstractROI
implements ROI {
    public static final String PERSISTENT_NAME = "AbstractROI_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "AbstractROI Persistent";
    private long id = 0L;
    private String name = "";
    private Color color = null;
    private RasterDataStore store = null;
    protected Statistics statistic = null;
    protected Extent roiExtent = null;
    private int pxWidth = -1;
    private int pxHeight = -1;
    protected int xOffset = 0;
    protected int yOffset = 0;
    private int[] bandsSubset = null;
    private RasterManager manager = RasterLocator.getManager();
    private int operationBand = 0;

    public AbstractROI(RasterDataStore store) {
        this.store = store;
        this.roiExtent = this.manager.getDataStructFactory().createExtent();
        this.statistic = this.manager.createROIStatistics(this);
    }

    @Override
    public RasterDataStore getStore() {
        return this.store;
    }

    public static Extent getROIsMaximunExtent(List<ROI> rois) {
        double minx = 0.0;
        double miny = 0.0;
        double maxx = 0.0;
        double maxy = 0.0;
        for (int i = 0; i < rois.size(); ++i) {
            Extent ext = ((AbstractROI)rois.get(i)).getROIExtent();
            if (i == 0) {
                minx = ext.minX();
                miny = ext.minY();
                maxx = ext.maxX();
                maxy = ext.maxY();
                continue;
            }
            if (ext.minX() < minx) {
                minx = ext.minX();
            }
            if (ext.minY() < miny) {
                miny = ext.minY();
            }
            if (ext.maxX() > maxx) {
                maxx = ext.maxX();
            }
            if (!(ext.maxY() > maxy)) continue;
            maxy = ext.maxY();
        }
        return RasterLocator.getManager().getDataStructFactory().createExtent(minx, miny, maxx, maxy);
    }

    public ROI add(ROI roi) {
        return null;
    }

    public ROI intersect(ROI roi) {
        return null;
    }

    public ROI subtract(ROI roi) {
        return null;
    }

    public ROI exclusiveOr(ROI roi) {
        return null;
    }

    public double getCellSize() {
        return this.store.getCellSize();
    }

    @Override
    public Extent getROIExtent() {
        return this.roiExtent;
    }

    public Extent getStoreExtent() {
        return this.store.getExtent();
    }

    public int getLayerWidth() {
        return (int)this.store.getWidth();
    }

    public int getLayerHeight() {
        return (int)this.store.getHeight();
    }

    public long getValues() throws GridException {
        if (!this.statistic.isCalculated()) {
            try {
                this.statistic.calculate(1.0);
            }
            catch (FileNotOpenException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (RasterDriverException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (ProcessInterruptedException e) {
                throw new GridException("", (Exception)((Object)e));
            }
        }
        return this.statistic.getNumberOfCells()[this.operationBand];
    }

    public double getMaxValue() throws GridException {
        if (!this.statistic.isCalculated()) {
            try {
                this.statistic.calculate(1.0);
            }
            catch (FileNotOpenException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (RasterDriverException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (ProcessInterruptedException e) {
                throw new GridException("", (Exception)((Object)e));
            }
        }
        return this.statistic.getMax()[this.operationBand];
    }

    public double getMeanValue() throws GridException {
        if (!this.statistic.isCalculated()) {
            try {
                this.statistic.calculate(1.0);
            }
            catch (FileNotOpenException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (RasterDriverException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (ProcessInterruptedException e) {
                throw new GridException("", (Exception)((Object)e));
            }
        }
        return this.statistic.getMean()[this.operationBand];
    }

    public double getMinValue() throws GridException {
        if (!this.statistic.isCalculated()) {
            try {
                this.statistic.calculate(1.0);
            }
            catch (FileNotOpenException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (RasterDriverException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (ProcessInterruptedException e) {
                throw new GridException("", (Exception)((Object)e));
            }
        }
        return this.statistic.getMin()[this.operationBand];
    }

    public double[][] getVarCovMatrix() throws GridException {
        if (!this.statistic.isAdvancedStatisticsCalculated()) {
            this.statistic.calculateAdvanced();
        }
        return this.statistic.getVarianceCovarianceMatrix();
    }

    public int getROIPxWidth() {
        if (this.pxWidth < 0) {
            this.pxWidth = (int)Math.abs(Math.floor((this.roiExtent.maxX() - this.roiExtent.minX()) / this.store.getCellSize()));
        }
        return this.pxWidth;
    }

    public int getROIPxHeight() {
        if (this.pxHeight < 0) {
            this.pxHeight = (int)Math.abs(Math.floor((this.roiExtent.minY() - this.roiExtent.maxY()) / this.store.getCellSize()));
        }
        return this.pxHeight;
    }

    public double getNoDataValue() {
        return this.store.getNoDataValue().getValue().doubleValue();
    }

    public double getVariance() throws GridException {
        if (!this.statistic.isCalculated()) {
            try {
                this.statistic.calculate(1.0);
            }
            catch (FileNotOpenException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (RasterDriverException e) {
                throw new GridException("", (Exception)((Object)e));
            }
            catch (ProcessInterruptedException e) {
                throw new GridException("", (Exception)((Object)e));
            }
        }
        return this.statistic.getVariance()[this.operationBand];
    }

    @Override
    public abstract boolean isInsideOfPolygon(int var1, int var2);

    @Override
    public abstract boolean isInside(double var1, double var3, double var5, double var7);

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public void setID(long id) {
        this.id = id;
    }

    public String toString() {
        return this.getName();
    }

    public void setBandsSubset(int[] bandsSubset) {
        this.bandsSubset = bandsSubset;
        this.statistic.setCalculated(false);
    }

    public void clearBandsSubset() {
        if (this.bandsSubset != null) {
            this.bandsSubset = null;
            this.statistic.setCalculated(false);
        }
    }

    public int getBandCount() {
        return this.store.getBandCount();
    }

    public int[] getBandsSubset() {
        return this.bandsSubset;
    }

    protected Statistics getStatistic() {
        return this.statistic;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.id = state.getLong("id");
        this.name = state.getString("name");
        this.color = (Color)state.get("color");
        this.statistic = (Statistics)state.get("statistic");
        this.roiExtent = (GridExtent)state.get("roiExtent");
        this.xOffset = state.getInt("xOffset");
        this.yOffset = state.getInt("yOffset");
        List aux = state.getList("bandsSubset");
        this.bandsSubset = new int[aux.size()];
        for (int i = 0; i < aux.size(); ++i) {
            this.bandsSubset[i] = (Integer)aux.get(i);
        }
        this.manager = (RasterManager)state.get("manager");
        this.operationBand = state.getInt("operationBand");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("id", this.id);
        state.set("name", this.name);
        state.set("color", (Object)this.color);
        state.set("statistic", (Object)this.statistic);
        state.set("roiExtent", (Persistent)this.roiExtent);
        state.set("xOffset", this.xOffset);
        state.set("yOffset", this.yOffset);
        state.set("bandsSubset", this.bandsSubset);
        state.set("manager", (Object)this.manager);
        state.set("operationBand", this.operationBand);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(AbstractROI.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldLong("id").setMandatory(true);
            definition.addDynFieldString("name").setMandatory(true);
            definition.addDynFieldObject("color").setClassOfValue(Color.class).setMandatory(false);
            definition.addDynFieldObject("statistic").setClassOfValue(Statistics.class).setMandatory(false);
            definition.addDynFieldObject("roiExtent").setClassOfValue(GridExtent.class).setMandatory(false);
            definition.addDynFieldInt("xOffset").setMandatory(false);
            definition.addDynFieldInt("yOffset").setMandatory(false);
            definition.addDynFieldList("bandsSubset").setClassOfItems(Integer.class).setMandatory(false);
            definition.addDynFieldObject("manager").setClassOfValue(GridExtent.class).setMandatory(true);
            definition.addDynFieldInt("operationBand").setMandatory(true);
        }
    }
}

