/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.app;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.render.ImageDrawer;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.algorithm.process.ProcessParamsManagement;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roimask.algorithm.ROIMaskProcess;
import org.gvsig.raster.roimask.app.ROIMaskExtension;
import org.gvsig.raster.roimask.swing.ROIMaskData;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROIMaskPreview
implements DataSourcePreview {
    private FLyrRaster inputLyr = null;
    private Extent bbox = null;
    private ROIMaskData data = null;
    private static final Logger logger = LoggerFactory.getLogger(ROIMaskPreview.class);

    public void setData(ROIMaskData data) {
        this.data = data;
        this.loadLayers();
    }

    private void loadLayers() {
        if (this.data == null) {
            return;
        }
        Object obj = this.data.getInputLayer();
        if (obj != null) {
            this.inputLyr = (FLyrRaster)((ROIMaskExtension.LayerElement)this.data.getInputLayer()).getLayer();
        }
        if (this.inputLyr != null) {
            this.bbox = this.inputLyr.getFullRasterExtent();
        }
    }

    public void closePreviewLayer() {
    }

    public double getCellSize() {
        if (this.inputLyr != null) {
            return this.inputLyr.getDataStore().getCellSize();
        }
        return 1.0;
    }

    public DataSourcePreview cloneDataSourcePreview() {
        return this;
    }

    public void popStatus() {
    }

    public void pushStatus() {
    }

    public void draw(BufferedImage image, Graphics2D g, double[] coords, int w, int h, Cancellable cancel, double scale) throws ImageUnavailableException {
        int x = 0;
        int y = 0;
        double iniX = coords[0];
        double iniY = coords[1];
        double endX = coords[2];
        double endY = coords[3];
        if (this.bbox.getULX() > coords[0]) {
            iniX = this.bbox.getULX();
            x = (int)((iniX - coords[0]) * (double)w / Math.abs(coords[2] - coords[0]));
        }
        if (this.bbox.getULY() < coords[1]) {
            iniY = this.bbox.getULY();
            y = (int)((coords[1] - iniY) * (double)h / Math.abs(coords[3] - coords[1]));
        }
        if (this.bbox.getLRX() < coords[2]) {
            endX = this.bbox.getLRX();
        }
        if (this.bbox.getLRY() > coords[3]) {
            endY = this.bbox.getLRY();
        }
        if (iniX != coords[0] || endX != coords[2]) {
            w = (int)(Math.abs(endX - iniX) * (double)w / Math.abs(coords[2] - coords[0]));
        }
        if (iniY != coords[1] || endY != coords[3]) {
            h = (int)(Math.abs(iniY - endY) * (double)h / Math.abs(coords[3] - coords[1]));
        }
        Extent ext = RasterLocator.getManager().getDataStructFactory().createExtent(iniX, iniY, endX, endY);
        BufferedImage img = this.throwProcess(ext, w, h);
        g.drawImage((Image)img, x, y, null);
    }

    private BufferedImage throwProcess(Extent ext, int w, int h) {
        DataProcess task;
        this.loadLayers();
        try {
            task = RasterBaseAlgorithmLibrary.getManager().createRasterTask("ROIMaskProcess");
            task.addParam(ROIMaskProcess.RASTER_STORE1, (Object)this.inputLyr.getDataStore());
            task.addParam(ProcessParamsManagement.PREVIEW, (Object)true);
            task.addParam(ProcessParamsManagement.WINDOW, (Object)ext);
            task.addParam(ProcessParamsManagement.OUTPUT_WIDTH, (Object)w);
            task.addParam(ProcessParamsManagement.OUTPUT_HEIGHT, (Object)h);
            task.addParam(ROIMaskProcess.ROIS, (Object)this.getROIsSelected());
            task.addParam(ROIMaskProcess.ALPHA, (Object)this.data.getAlpha());
            task.addParam(ROIMaskProcess.INVERSE, (Object)this.data.isInverse());
            task.addParam(ROIMaskProcess.NODATA, (Object)this.getNoDataSelected());
        }
        catch (ProcessException e1) {
            logger.debug("Error creating task", (Throwable)e1);
            return null;
        }
        catch (ROIException e) {
            logger.debug("Error creating task", (Throwable)e);
            return null;
        }
        task.init();
        try {
            task.process();
        }
        catch (ProcessInterruptedException e1) {
            return null;
        }
        catch (ProcessException e) {
            logger.debug("Error in process");
            return null;
        }
        HashMap map = task.getResult();
        Buffer buf = (Buffer)map.get(ROIMaskProcess.BUFFER);
        buf.setDataExtent(ext.toRectangle2D());
        ColorInterpretation ci = this.inputLyr.getDataStore().getColorInterpretation();
        Transparency transparency = null;
        if (ci.isRGB() || ci.isRGBA()) {
            Integer alphaBandNumber = (Integer)map.get(ROIMaskProcess.ALPHA_BAND);
            transparency = RasterLocator.getManager().getDataStructFactory().createTransparency(buf.getBandCount());
            transparency.setTransparencyBand(alphaBandNumber.intValue());
            transparency.activeTransparency();
        }
        ImageDrawer drawer = RasterLocator.getManager().createImageDrawerService();
        drawer.setBuffer(buf);
        drawer.setLastTransparency(transparency);
        try {
            this.applyFiltersToPreview(drawer);
            return (BufferedImage)drawer.drawBufferOverImageObject();
        }
        catch (ProcessInterruptedException e) {
            return null;
        }
    }

    private void applyFiltersToPreview(ImageDrawer drawer) {
        RasterFilterList filterList = this.inputLyr.getRender().getFilterList();
        ArrayList<RasterFilter> list = new ArrayList<RasterFilter>();
        if (filterList.lenght() > 0) {
            for (int i = 0; i < filterList.lenght(); ++i) {
                RasterFilter rf = filterList.get(i);
                if (rf.getName().equals("colortable")) {
                    drawer.addEnhanced(this.inputLyr.getDataStore().getStatistics(), true, 0.2);
                    return;
                }
                list.add(rf);
            }
        }
        try {
            drawer.addFilters(this.inputLyr.getDataStore().getStatistics(), list);
        }
        catch (FilterTypeException e) {
            logger.debug("Tirando sin filtros", (Throwable)e);
        }
    }

    private NoData getNoDataSelected() {
        NoData nodata = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.inputLyr.getDataStore().getBandCount(), this.inputLyr.getDataStore().getDataType()[0]);
        nodata.setValue((Number)this.data.getValueNoData());
        return nodata;
    }

    private ROI[] getROIsSelected() throws ROIException {
        List roi = this.inputLyr.getRois();
        boolean[] roisSelected = this.data.getROIsSelected();
        ArrayList roisToDraw = new ArrayList();
        for (int i = 0; i < roisSelected.length; ++i) {
            if (!roisSelected[i]) continue;
            roisToDraw.add(roi.get(i));
        }
        return roisToDraw.toArray(new ROI[0]);
    }

    public Object getSource() {
        return null;
    }

    public Rectangle2D getBBoxRectangle() {
        if (this.inputLyr != null) {
            return this.inputLyr.getFullRasterExtent().toRectangle2D();
        }
        return new Rectangle2D.Double();
    }

    public void addParams(DataProcess task, String path, String fileName) throws ROIException {
        if (!fileName.matches("([*]\\.[???])")) {
            fileName = fileName + ".tif";
        }
        task.addParam(ROIMaskProcess.PATH, (Object)(path + File.separator + fileName));
        task.addParam(ROIMaskProcess.RASTER_STORE1, (Object)this.inputLyr.getDataStore());
        task.addParam(ROIMaskProcess.ROIS, (Object)this.getROIsSelected());
        task.addParam(ROIMaskProcess.ALPHA, (Object)this.data.getAlpha());
        task.addParam(ROIMaskProcess.INVERSE, (Object)this.data.isInverse());
        task.addParam(ROIMaskProcess.NODATA, (Object)this.getNoDataSelected());
    }
}

