/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.basicformats.impl;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.basicformats.HDRFile;
import org.gvsig.basicformats.impl.AbstractFormatFile;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHDRFile
extends AbstractFormatFile
implements HDRFile {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHDRFile.class);
    private File source = null;
    private String comments;
    private int nrows = -1;
    private int ncols = -1;
    private int nbands = 1;
    private int nbits = 8;
    private String pixeltype;
    private String byteorder_word;
    private ByteOrder byteorder = ByteOrder.nativeOrder();
    private String layout = "bil";
    private int skipbytes = 0;
    private double ulxmax = Double.NaN;
    private double ulymax = Double.NaN;
    private double xdim = Double.NaN;
    private double ydim = Double.NaN;
    private int bandrowbytes = -1;
    private int totalrowbytes = -1;
    private int bandgapbytes = 0;
    private boolean valid = false;
    private double nodata_value = Double.NaN;
    private double xllcorner = Double.NaN;
    private double yllcorner = Double.NaN;
    private int cellsize = -1;

    @Override
    public File getFile(File file) {
        File f = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + "." + "hdr");
        return f;
    }

    @Override
    public File getFile() {
        return this.source;
    }

    @Override
    public void read(File file) throws IOException {
        block51: {
            File f = this.getFile(file);
            if (f.exists()) {
                try {
                    List lines = FileUtils.readLines((File)f);
                    if (lines == null) break block51;
                    this.source = f.getAbsoluteFile();
                    int lineno = 1;
                    for (String line : lines) {
                        String[] words = StringUtils.split((String)line.trim().toLowerCase());
                        try {
                            switch (words[0]) {
                                case "nrows": {
                                    this.nrows = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "ncols": {
                                    this.ncols = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "nbands": {
                                    this.nbands = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "nbits": {
                                    this.nbits = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "pixeltype": {
                                    this.pixeltype = words[1];
                                    break;
                                }
                                case "byteorder": {
                                    this.byteorder_word = words[1];
                                    break;
                                }
                                case "layout": {
                                    this.layout = words[1];
                                    break;
                                }
                                case "skipbytes": {
                                    this.skipbytes = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "nodata_value": {
                                    this.nodata_value = Double.parseDouble(words[1]);
                                    break;
                                }
                                case "cellsize": {
                                    this.cellsize = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "xllcorner": 
                                case "xllcenter": {
                                    this.xllcorner = Double.parseDouble(words[1]);
                                    break;
                                }
                                case "yllcorner": 
                                case "yllcenter": {
                                    this.yllcorner = Double.parseDouble(words[1]);
                                    break;
                                }
                                case "ulxmax": {
                                    this.ulxmax = Double.parseDouble(words[1]);
                                    break;
                                }
                                case "ulymax": {
                                    this.ulymax = Double.parseDouble(words[1]);
                                    break;
                                }
                                case "xdim": {
                                    this.xdim = Double.parseDouble(words[1]);
                                    break;
                                }
                                case "ydim": {
                                    this.ydim = Double.parseDouble(words[1]);
                                    break;
                                }
                                case "bandrowbytes": {
                                    this.bandrowbytes = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "totalrowbytes": {
                                    this.totalrowbytes = Integer.parseInt(words[1]);
                                    break;
                                }
                                case "bandgapbytes": {
                                    this.bandgapbytes = Integer.parseInt(words[1]);
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            logger.warn("Can't parse keyword '" + words[0] + "' (value='" + words[1] + "', lineno=+" + lineno + ", file=" + f.getAbsoluteFile() + ").", (Throwable)e);
                        }
                        ++lineno;
                    }
                    this.fixValues();
                }
                catch (IOException e) {
                    logger.warn("Couldn't read hdr file (" + f.getAbsoluteFile() + ")", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    String msg = "Couldn't read hdr file (" + f.getAbsoluteFile() + ")";
                    logger.warn(msg, (Throwable)e);
                    throw new IOException(msg, e);
                }
            }
        }
    }

    private void fixValues() {
        boolean valid = true;
        if (this.pixeltype != null) {
            switch (this.pixeltype) {
                case "signedint": {
                    this.nbits = 32;
                    break;
                }
                case "byte_unsigned": {
                    this.nbits = 8;
                }
            }
        }
        switch (this.getNbits()) {
            case 1: 
            case 4: {
                logger.warn("nbits keyword has a non supported value of " + this.getNbits() + " (" + this.source.getAbsolutePath() + ").");
                valid = false;
                break;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                logger.warn("nbits keyword has an invalid value of " + this.getNbits() + " (" + this.source.getAbsolutePath() + ").");
                this.nbits = 1;
                valid = false;
            }
        }
        switch (this.getLayout()) {
            case "bil": 
            case "bip": 
            case "bsq": {
                break;
            }
            default: {
                logger.warn("layout keyword has an invalid value of '" + this.getLayout() + "' (" + this.source.getAbsolutePath() + ").");
                this.layout = "bil";
                valid = false;
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.byteorder_word)) {
            this.byteorder = ByteOrder.nativeOrder();
            this.byteorder_word = this.byteorder == ByteOrder.BIG_ENDIAN ? "msbfirst" : "lsbfirst";
        } else {
            switch (this.byteorder_word) {
                case "lsbfirst": 
                case "little_endian": 
                case "littleendian": 
                case "intel": 
                case "i": {
                    this.byteorder = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                case "motorola": 
                case "m": 
                case "msbfirst": 
                case "big_endian": 
                case "bigendian": {
                    this.byteorder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                default: {
                    logger.warn("byteorder keyword has an invalid value of '" + this.byteorder_word + "' (" + this.source.getAbsolutePath() + ").");
                    this.byteorder = ByteOrder.nativeOrder();
                }
            }
        }
        if (this.getNrows() == -1 || this.getNcols() == -1) {
            logger.warn("nrows/ncols keywords has an invalid value of '" + this.getNrows() + "/" + this.getNcols() + "' (" + this.source.getAbsolutePath() + ").");
            valid = false;
        }
        if (this.getUlymax() == -1.0) {
            this.ulymax = this.getNrows() - 1;
        }
        if (this.getBandrowbytes() == -1) {
            this.bandrowbytes = this.getNcols() * this.getNbits() / 8;
        }
        switch (this.getLayout()) {
            case "bil": {
                if (this.getTotalrowbytes() == -1) {
                    this.totalrowbytes = this.getNbands() * this.getBandrowbytes();
                }
                this.bandgapbytes = 0;
                break;
            }
            case "bip": {
                if (this.getTotalrowbytes() == -1) {
                    this.totalrowbytes = this.getNcols() * this.getNbands() * this.getNbits() / 8;
                }
                this.bandgapbytes = 0;
                break;
            }
            case "bsq": {
                if (this.getTotalrowbytes() == -1) {
                    this.totalrowbytes = 0;
                }
                if (this.getBandgapbytes() != -1) break;
                this.bandgapbytes = 0;
            }
        }
        this.valid = valid;
    }

    @Override
    public int getDataType() {
        if (this.pixeltype != null) {
            switch (this.pixeltype) {
                case "signedint": {
                    return 3;
                }
                case "byte_unsigned": {
                    return 0;
                }
            }
        }
        switch (this.getNbits()) {
            default: {
                return 32;
            }
            case 8: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 32: {
                return 3;
            }
            case 64: 
        }
        return 5;
    }

    @Override
    public void write(File file) throws IOException {
        File f = this.getFile(file);
        StringBuilder builder = new StringBuilder();
        builder.append("; ").append(this.comments).append("\n");
        builder.append("nrows ").append(this.nrows).append("\n");
        builder.append("ncols ").append(this.ncols).append("\n");
        builder.append("nbands ").append(this.nbands).append("\n");
        builder.append("nbits ").append(this.nbits).append("\n");
        builder.append("layout ").append("bsq").append("\n");
        builder.append("byteorder ").append(this.byteorder_word).append("\n");
        builder.append("ulxmax ").append(this.ulxmax).append("\n");
        builder.append("ulymax ").append(this.ulymax).append("\n");
        builder.append("ydim ").append(this.ydim).append("\n");
        builder.append("xdim ").append(this.xdim).append("\n");
        FileUtils.write((File)file, (CharSequence)builder.toString());
    }

    @Override
    public void setByteOrder(ByteOrder order) {
        this.byteorder = order;
        this.byteorder_word = order == ByteOrder.BIG_ENDIAN ? "msbfirst" : "lsbfirst";
    }

    @Override
    public void setNBands(int nbands) {
        this.nbands = nbands;
    }

    @Override
    public void setDataType(int dataType) {
        switch (dataType) {
            case 0: {
                this.nbits = 8;
                break;
            }
            case 1: {
                this.nbits = 16;
                break;
            }
            case 3: {
                this.nbits = 32;
                break;
            }
            case 5: {
                this.nbits = 64;
                break;
            }
            default: {
                throw new IllegalArgumentException("The data type " + dataType + " is not supported");
            }
        }
    }

    @Override
    public void setDimensions(int nrows, int ncols, Envelope envelope) {
        this.ncols = ncols;
        this.nrows = nrows;
        Point min = envelope.getLowerCorner();
        Point max = envelope.getUpperCorner();
        this.ulxmax = min.getX();
        this.ulymax = max.getY();
        this.ydim = (min.getY() - max.getY()) / (double)this.nrows;
        this.xdim = (max.getX() - min.getX()) / (double)this.ncols;
    }

    @Override
    public Envelope getEnvelope() {
        Envelope envelope = null;
        try {
            if (!Double.isNaN(this.xllcorner) && !Double.isNaN(this.yllcorner) && this.cellsize > 0) {
                envelope = GeometryLocator.getGeometryManager().createEnvelope(this.xllcorner, this.yllcorner, this.xllcorner + (double)(this.ncols * this.cellsize), this.yllcorner + (double)(this.nrows * this.cellsize), 0);
            }
            if (!(envelope != null || Double.isNaN(this.ulxmax) || Double.isNaN(this.ulymax) || Double.isNaN(this.xdim) || Double.isNaN(this.ydim))) {
                envelope = GeometryLocator.getGeometryManager().createEnvelope(this.ulxmax, this.ulymax - (double)this.nrows * this.ydim, this.ulxmax + (double)this.ncols * this.xdim, this.ulymax, 0);
            }
            if (envelope == null && !Double.isNaN(this.xdim) && !Double.isNaN(this.ydim)) {
                envelope = GeometryLocator.getGeometryManager().createEnvelope(0.0, 0.0, (double)this.ncols * this.xdim, (double)this.nrows * this.ydim, 0);
            }
            if (envelope == null && this.cellsize > 0) {
                envelope = GeometryLocator.getGeometryManager().createEnvelope(0.0, 0.0, (double)(this.ncols * this.cellsize), (double)(this.nrows * this.cellsize), 0);
            }
            if (envelope == null) {
                envelope = GeometryLocator.getGeometryManager().createEnvelope(0.0, 0.0, (double)this.ncols, (double)this.nrows, 0);
            }
        }
        catch (Exception ex) {
            logger.debug("Can't calculate envelope.", (Throwable)ex);
        }
        return envelope;
    }

    @Override
    public int getNrows() {
        return this.nrows;
    }

    @Override
    public int getNcols() {
        return this.ncols;
    }

    @Override
    public int getNbands() {
        return this.nbands;
    }

    @Override
    public int getNbits() {
        return this.nbits;
    }

    @Override
    public ByteOrder getByteorder() {
        return this.byteorder;
    }

    @Override
    public String getLayout() {
        return this.layout;
    }

    @Override
    public int getSkipbytes() {
        return this.skipbytes;
    }

    @Override
    public double getUlxmax() {
        return this.ulxmax;
    }

    @Override
    public double getUlymax() {
        return this.ulymax;
    }

    @Override
    public double getXdim() {
        return this.xdim;
    }

    @Override
    public double getYdim() {
        return this.ydim;
    }

    @Override
    public int getBandrowbytes() {
        return this.bandrowbytes;
    }

    @Override
    public int getTotalrowbytes() {
        return this.totalrowbytes;
    }

    @Override
    public int getBandgapbytes() {
        return this.bandgapbytes;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public double getNodata_value() {
        return this.nodata_value;
    }

    @Override
    public double getXllcorner() {
        return this.xllcorner;
    }

    @Override
    public double getYllcorner() {
        return this.yllcorner;
    }

    @Override
    public int getCellsize() {
        return this.cellsize;
    }

    @Override
    public int getBandSize() {
        return this.nrows * this.ncols * this.nbits + this.bandgapbytes;
    }
}

