/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.h2spatial.restore;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.text.JTextComponent;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.h2spatial.restore.RestoreView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Restore
extends RestoreView {
    private static final Logger LOGGER = LoggerFactory.getLogger(Restore.class);
    private FilePickerController pickerBackupFile;
    private FilePickerController pickerDatabaseFile;

    public Restore() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.pickerBackupFile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtBackupFile, this.btnBackupFile);
        this.pickerDatabaseFile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtDatabaseFile, this.btnDatabaseFile);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblBackupFile);
        toolsSwingManager.translate(this.lblDatabaseFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreBackup() {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        Connection conn = null;
        Statement st = null;
        try {
            File[] h2Files;
            String h2DatabaseFile = H2SpatialUtils.removeH2FileNameExtension((String)((File)this.pickerDatabaseFile.get()).getAbsolutePath().replace("\\", "/"));
            for (File h2File : h2Files = H2SpatialUtils.getH2Files((File)new File(h2DatabaseFile))) {
                if (!h2File.exists()) continue;
                application.messageDialog(i18n.getTranslation("_The_target_file_already_exists"), i18n.getTranslation("_Restore"), 2);
                return;
            }
            conn = DriverManager.getConnection("jdbc:h2:" + h2DatabaseFile + ";MODE=PostgreSQL;SCHEMA=PUBLIC;ALLOW_LITERALS=ALL", "sa", "");
            st = conn.createStatement();
            st.execute("RUNSCRIPT FROM '" + ((File)this.pickerBackupFile.get()).getAbsolutePath().replace("\\", "/") + "'");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't restore backup.", (Throwable)ex);
            application.messageDialog(i18n.getTranslation("_Cant_restore_backup") + "\n\n" + i18n.getTranslation("_see_error_log_for_more_information"), i18n.getTranslation("_Restore"), 2);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOGGER.debug("Can't close statement", (Throwable)ex);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOGGER.debug("Can't close connection", (Throwable)ex);
                }
            }
        }
    }
}

