/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.installer;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.installer.EPSGDatabaseInstaller;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.service.spi.AbstractProviderFactory;
import org.gvsig.tools.service.spi.Provider;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.gvsig.tools.service.spi.ProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPSGDatabaseInstallerFactory
extends AbstractProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(EPSGDatabaseInstallerFactory.class);
    public static final String PROVIDER_NAME = "jCRS_EPSG";
    public static final String PROVIDER_DESCRIPTION = "EPSG database installer for jCRS";
    private DynClass dynclass;

    protected DynClass createParametersDynClass() {
        if (this.dynclass == null) {
            this.initialize();
        }
        return this.dynclass;
    }

    protected Provider doCreate(DynObject parameters, ProviderServices services) {
        return new EPSGDatabaseInstaller(services);
    }

    public void initialize() {
        if (this.dynclass == null) {
            DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
            this.dynclass = dynObjectManager.createDynClass(PROVIDER_NAME, PROVIDER_DESCRIPTION);
            dynObjectManager.add(this.dynclass);
        }
    }

    public static void registerEPSGDatabaseInstaller() {
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        InstallerProviderManager providerManager = InstallerProviderLocator.getProviderManager();
        PluginsManager pluginsManager = PluginsLocator.getManager();
        providerManager.addProviderFactory((ProviderFactory)new EPSGDatabaseInstallerFactory());
        File epsgDatabaseFolder = new File(CrsFactory.getDataBaseFolder(), "EPSG");
        try {
            FileUtils.forceMkdir((File)epsgDatabaseFolder);
        }
        catch (IOException ex) {
            logger.warn("Can't create EPSG databases folder in '" + epsgDatabaseFolder.getAbsolutePath() + "'.", (Throwable)ex);
        }
        installerManager.setDefaultLocalAddonRepository(epsgDatabaseFolder, PROVIDER_NAME);
    }
}

