/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jexcel.dynformfield.point;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.jexcel.dynformfield.point.PointFieldsSelectorView;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class PointFieldsSelector
extends PointFieldsSelectorView {
    Set<String> fieldNames = new HashSet<String>();
    boolean processingUserChangeCombo = false;

    public PointFieldsSelector() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.addClearButton((JTextComponent)this.txtXYZ, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointFieldsSelector.this.clear();
            }
        });
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PointFieldsSelector.this.processingUserChangeCombo) {
                    return;
                }
                try {
                    PointFieldsSelector.this.processingUserChangeCombo = true;
                    if (PointFieldsSelector.this.cboX.isEnabled()) {
                        PointFieldsSelector.this.updateText();
                    }
                }
                finally {
                    PointFieldsSelector.this.processingUserChangeCombo = false;
                }
            }
        };
        this.cboX.addItemListener(listener);
        this.cboY.addItemListener(listener);
        this.cboZ.addItemListener(listener);
        this.txtXYZ.setEditable(false);
    }

    public void setAvailableFields(List<String> fieldNames) {
        boolean enabled = this.isEnabled();
        String selectedFields = this.getSelectedFields();
        DefaultComboBoxModel<String> modelX = new DefaultComboBoxModel<String>();
        DefaultComboBoxModel<String> modelY = new DefaultComboBoxModel<String>();
        DefaultComboBoxModel<String> modelZ = new DefaultComboBoxModel<String>();
        modelX.addElement(" ");
        modelY.addElement(" ");
        modelZ.addElement(" ");
        this.fieldNames.clear();
        if (fieldNames == null || fieldNames.isEmpty()) {
            enabled = false;
            this.txtXYZ.setEditable(true);
        } else {
            this.txtXYZ.setEditable(false);
            for (String fieldName : fieldNames) {
                modelX.addElement(fieldName);
                modelY.addElement(fieldName);
                modelZ.addElement(fieldName);
                this.fieldNames.add(fieldName);
            }
        }
        this.cboX.setModel(modelX);
        this.cboY.setModel(modelY);
        this.cboZ.setModel(modelZ);
        this.cboX.setEnabled(enabled);
        this.cboY.setEnabled(enabled);
        this.cboZ.setEnabled(enabled);
        this.setSelectedFields(selectedFields);
    }

    public void clear() {
        this.cboX.setSelectedIndex(-1);
        this.cboY.setSelectedIndex(-1);
        this.cboZ.setSelectedIndex(-1);
        this.txtXYZ.setText("");
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.txtXYZ.getText());
    }

    public void setSelectedFields(String fields) {
        if (StringUtils.isBlank((CharSequence)fields)) {
            this.clear();
            return;
        }
        String[] m = StringUtils.split((String)fields, (char)',');
        if (m.length < 2 || m.length > 3) {
            this.clear();
            return;
        }
        for (int i = 0; i < m.length; ++i) {
            m[i] = m[i].trim();
        }
        if (this.isEnabled() && this.cboX.isEnabled()) {
            if (this.fieldNames.contains(m[0])) {
                this.cboX.setSelectedItem(m[0]);
            }
            if (this.fieldNames.contains(m[1])) {
                this.cboY.setSelectedItem(m[1]);
            }
            if (m.length > 2 && this.fieldNames.contains(m[2])) {
                this.cboZ.setSelectedItem(m[2]);
            }
        }
        this.txtXYZ.setText(fields);
    }

    public String getSelectedFields() {
        if (!this.cboX.isEnabled()) {
            return (String)StringUtils.defaultIfEmpty((CharSequence)this.txtXYZ.getText(), null);
        }
        String xfield = (String)this.cboX.getSelectedItem();
        String yfield = (String)this.cboY.getSelectedItem();
        String zfield = (String)this.cboZ.getSelectedItem();
        if (StringUtils.isBlank((CharSequence)xfield) || StringUtils.isBlank((CharSequence)yfield)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)zfield)) {
            return xfield + "," + yfield;
        }
        return xfield + "," + yfield + "," + zfield;
    }

    private void updateText() {
        String xfield = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboX.getSelectedItem()), (CharSequence)"-");
        String yfield = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboY.getSelectedItem()), (CharSequence)"-");
        String zfield = (String)this.cboZ.getSelectedItem();
        String value = StringUtils.isBlank((CharSequence)zfield) ? xfield + "," + yfield : xfield + "," + yfield + "," + zfield;
        this.txtXYZ.setText(value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cboX.setEnabled(enabled);
        this.cboY.setEnabled(enabled);
        this.cboZ.setEnabled(enabled);
    }

    public void detect() {
        String xfield = null;
        String yfield = null;
        String zfield = null;
        for (String fieldName : this.fieldNames) {
            if (fieldName.equalsIgnoreCase("x")) {
                xfield = fieldName;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)fieldName, (CharSequence)"lon") && xfield == null) {
                xfield = fieldName;
            }
            if (fieldName.equalsIgnoreCase("y")) {
                yfield = fieldName;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)fieldName, (CharSequence)"lat") && yfield == null) {
                yfield = fieldName;
            }
            if (!fieldName.equalsIgnoreCase("z")) continue;
            zfield = fieldName;
        }
        if (xfield != null) {
            this.cboX.setSelectedItem(xfield);
        }
        if (yfield != null) {
            this.cboY.setSelectedItem(yfield);
        }
        if (zfield != null) {
            this.cboZ.setSelectedItem(zfield);
        }
    }
}

