/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jexcel.dynformfield.sheet;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.jexcel.Spread;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.services.dynformfield.Integer.JDynFormFieldInteger;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObjectValueItem;

public class JDynFormFieldExcelSheet
extends JDynFormFieldInteger {
    private JDynFormField.JDynFormFieldListener fileChangedListener;
    private DynObjectValueItem[] availableValues;
    private File lastSelectedFile;

    public JDynFormFieldExcelSheet(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
    }

    public DynObjectValueItem[] getAvailableValues() {
        if (this.availableValues == null) {
            this.availableValues = new DynObjectValueItem[0];
        }
        return this.availableValues;
    }

    public void setValue(Object value) {
        this.addListenerToFile();
        super.setValue(value);
    }

    public void addListenerToFile() {
        if (this.fileChangedListener != null) {
            return;
        }
        JDynForm form = this.getForm();
        JDynFormField fileField = form.getField("file");
        if (fileField == null) {
            return;
        }
        JDynFormField.JDynFormFieldListener listener = new JDynFormField.JDynFormFieldListener(){

            public void fieldEnter(JDynFormField field) {
            }

            public void fieldExit(JDynFormField field) {
            }

            public void fieldChanged(JDynFormField field) {
                JDynFormFieldExcelSheet.this.doChangeFile(field);
            }

            public void message(JDynFormField field, String message) {
            }
        };
        fileField.addListener(listener);
        this.fileChangedListener = listener;
        this.doChangeFile(fileField);
    }

    private Locale getLocale() {
        JDynForm form = this.getForm();
        JDynFormField localeField = form.getField("locale");
        Locale locale = Locale.getDefault();
        String x = Objects.toString(localeField.getValue(), null);
        if (!StringUtils.isBlank((CharSequence)x)) {
            locale = new Locale(x);
        }
        return locale;
    }

    protected DynObjectValueItem[] getAvailableSheets(File file) {
        try {
            if (file == null) {
                return null;
            }
            Spread spread = Spread.create(file, new Object[0]);
            List<String> sheetNames = spread.getSheetNames();
            DynObjectValueItem[] values = new DynObjectValueItem[sheetNames.size()];
            for (int i = 0; i < sheetNames.size(); ++i) {
                values[i] = new DynObjectValueItem((Object)i, sheetNames.get(i));
            }
            return values;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve the number of sheets.", (Throwable)ex);
            return null;
        }
    }

    public void doChangeFile(JDynFormField field) {
        File currentFile = (File)field.getValue();
        DefaultComboBoxModel<DynObjectValueItem> model = new DefaultComboBoxModel<DynObjectValueItem>();
        if (currentFile != null && (this.lastSelectedFile == null || currentFile.getPath().equals(this.lastSelectedFile.getPath()))) {
            this.availableValues = this.getAvailableSheets(currentFile);
            if (this.availableValues != null) {
                for (DynObjectValueItem availableValue : this.availableValues) {
                    model.addElement(availableValue);
                }
            }
            this.lastSelectedFile = currentFile;
        }
        this.getDropDown().setModel(model);
        if (model.getSize() > 0) {
            this.getDropDown().setSelectedIndex(0);
            this.fireFieldChangedEvent();
        }
    }
}

